from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.SelectMgr import *
from OCC.Core.Media import *
from OCC.Core.PrsMgr import *
from OCC.Core.TCollection import *
from OCC.Core.Quantity import *
from OCC.Core.TopAbs import *
from OCC.Core.TopoDS import *
from OCC.Core.Prs3d import *
from OCC.Core.TColStd import *
from OCC.Core.Aspect import *
from OCC.Core.Graphic3d import *
from OCC.Core.V3d import *
from OCC.Core.Bnd import *
from OCC.Core.gp import *
from OCC.Core.TopLoc import *
from OCC.Core.StdSelect import *
from OCC.Core.TColgp import *
from OCC.Core.Select3D import *
from OCC.Core.SelectBasics import *
from OCC.Core.Geom import *
from OCC.Core.Poly import *
from OCC.Core.Image import *

AIS_AnimationTimer = NewType("AIS_AnimationTimer", Media_Timer)
AIS_DisplayStatus = NewType("AIS_DisplayStatus", PrsMgr_DisplayStatus)

class AIS_ListOfInteractive:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AIS_NArray1OfEntityOwner:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AIS_NListOfEntityOwner:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AIS_DisplayMode(IntEnum):
    AIS_WireFrame: int = ...
    AIS_Shaded: int = ...

AIS_WireFrame = AIS_DisplayMode.AIS_WireFrame
AIS_Shaded = AIS_DisplayMode.AIS_Shaded

class AIS_DragAction(IntEnum):
    AIS_DragAction_Start: int = ...
    AIS_DragAction_Confirmed: int = ...
    AIS_DragAction_Update: int = ...
    AIS_DragAction_Stop: int = ...
    AIS_DragAction_Abort: int = ...

AIS_DragAction_Start = AIS_DragAction.AIS_DragAction_Start
AIS_DragAction_Confirmed = AIS_DragAction.AIS_DragAction_Confirmed
AIS_DragAction_Update = AIS_DragAction.AIS_DragAction_Update
AIS_DragAction_Stop = AIS_DragAction.AIS_DragAction_Stop
AIS_DragAction_Abort = AIS_DragAction.AIS_DragAction_Abort

class AIS_KindOfInteractive(IntEnum):
    AIS_KindOfInteractive_None: int = ...
    AIS_KindOfInteractive_Datum: int = ...
    AIS_KindOfInteractive_Shape: int = ...
    AIS_KindOfInteractive_Object: int = ...
    AIS_KindOfInteractive_Relation: int = ...
    AIS_KindOfInteractive_Dimension: int = ...
    AIS_KindOfInteractive_LightSource: int = ...
    AIS_KOI_None: int = ...
    AIS_KOI_Datum: int = ...
    AIS_KOI_Shape: int = ...
    AIS_KOI_Object: int = ...
    AIS_KOI_Relation: int = ...
    AIS_KOI_Dimension: int = ...

AIS_KindOfInteractive_None = AIS_KindOfInteractive.AIS_KindOfInteractive_None
AIS_KindOfInteractive_Datum = AIS_KindOfInteractive.AIS_KindOfInteractive_Datum
AIS_KindOfInteractive_Shape = AIS_KindOfInteractive.AIS_KindOfInteractive_Shape
AIS_KindOfInteractive_Object = AIS_KindOfInteractive.AIS_KindOfInteractive_Object
AIS_KindOfInteractive_Relation = AIS_KindOfInteractive.AIS_KindOfInteractive_Relation
AIS_KindOfInteractive_Dimension = AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension
AIS_KindOfInteractive_LightSource = AIS_KindOfInteractive.AIS_KindOfInteractive_LightSource
AIS_KOI_None = AIS_KindOfInteractive.AIS_KOI_None
AIS_KOI_Datum = AIS_KindOfInteractive.AIS_KOI_Datum
AIS_KOI_Shape = AIS_KindOfInteractive.AIS_KOI_Shape
AIS_KOI_Object = AIS_KindOfInteractive.AIS_KOI_Object
AIS_KOI_Relation = AIS_KindOfInteractive.AIS_KOI_Relation
AIS_KOI_Dimension = AIS_KindOfInteractive.AIS_KOI_Dimension

class AIS_ManipulatorMode(IntEnum):
    AIS_MM_None: int = ...
    AIS_MM_Translation: int = ...
    AIS_MM_Rotation: int = ...
    AIS_MM_Scaling: int = ...
    AIS_MM_TranslationPlane: int = ...

AIS_MM_None = AIS_ManipulatorMode.AIS_MM_None
AIS_MM_Translation = AIS_ManipulatorMode.AIS_MM_Translation
AIS_MM_Rotation = AIS_ManipulatorMode.AIS_MM_Rotation
AIS_MM_Scaling = AIS_ManipulatorMode.AIS_MM_Scaling
AIS_MM_TranslationPlane = AIS_ManipulatorMode.AIS_MM_TranslationPlane

class AIS_MouseGesture(IntEnum):
    AIS_MouseGesture_NONE: int = ...
    AIS_MouseGesture_SelectRectangle: int = ...
    AIS_MouseGesture_SelectLasso: int = ...
    AIS_MouseGesture_Zoom: int = ...
    AIS_MouseGesture_ZoomWindow: int = ...
    AIS_MouseGesture_Pan: int = ...
    AIS_MouseGesture_RotateOrbit: int = ...
    AIS_MouseGesture_RotateView: int = ...
    AIS_MouseGesture_Drag: int = ...

AIS_MouseGesture_NONE = AIS_MouseGesture.AIS_MouseGesture_NONE
AIS_MouseGesture_SelectRectangle = AIS_MouseGesture.AIS_MouseGesture_SelectRectangle
AIS_MouseGesture_SelectLasso = AIS_MouseGesture.AIS_MouseGesture_SelectLasso
AIS_MouseGesture_Zoom = AIS_MouseGesture.AIS_MouseGesture_Zoom
AIS_MouseGesture_ZoomWindow = AIS_MouseGesture.AIS_MouseGesture_ZoomWindow
AIS_MouseGesture_Pan = AIS_MouseGesture.AIS_MouseGesture_Pan
AIS_MouseGesture_RotateOrbit = AIS_MouseGesture.AIS_MouseGesture_RotateOrbit
AIS_MouseGesture_RotateView = AIS_MouseGesture.AIS_MouseGesture_RotateView
AIS_MouseGesture_Drag = AIS_MouseGesture.AIS_MouseGesture_Drag

class AIS_NavigationMode(IntEnum):
    AIS_NavigationMode_Orbit: int = ...
    AIS_NavigationMode_FirstPersonFlight: int = ...
    AIS_NavigationMode_FirstPersonWalk: int = ...

AIS_NavigationMode_Orbit = AIS_NavigationMode.AIS_NavigationMode_Orbit
AIS_NavigationMode_FirstPersonFlight = AIS_NavigationMode.AIS_NavigationMode_FirstPersonFlight
AIS_NavigationMode_FirstPersonWalk = AIS_NavigationMode.AIS_NavigationMode_FirstPersonWalk


class AIS_RotationMode(IntEnum):
    AIS_RotationMode_BndBoxActive: int = ...
    AIS_RotationMode_PickLast: int = ...
    AIS_RotationMode_PickCenter: int = ...
    AIS_RotationMode_CameraAt: int = ...
    AIS_RotationMode_BndBoxScene: int = ...

AIS_RotationMode_BndBoxActive = AIS_RotationMode.AIS_RotationMode_BndBoxActive
AIS_RotationMode_PickLast = AIS_RotationMode.AIS_RotationMode_PickLast
AIS_RotationMode_PickCenter = AIS_RotationMode.AIS_RotationMode_PickCenter
AIS_RotationMode_CameraAt = AIS_RotationMode.AIS_RotationMode_CameraAt
AIS_RotationMode_BndBoxScene = AIS_RotationMode.AIS_RotationMode_BndBoxScene


class AIS_SelectStatus(IntEnum):
    AIS_SS_Added: int = ...
    AIS_SS_Removed: int = ...
    AIS_SS_NotDone: int = ...

AIS_SS_Added = AIS_SelectStatus.AIS_SS_Added
AIS_SS_Removed = AIS_SelectStatus.AIS_SS_Removed
AIS_SS_NotDone = AIS_SelectStatus.AIS_SS_NotDone

class AIS_SelectionModesConcurrency(IntEnum):
    AIS_SelectionModesConcurrency_Single: int = ...
    AIS_SelectionModesConcurrency_GlobalOrLocal: int = ...
    AIS_SelectionModesConcurrency_Multiple: int = ...

AIS_SelectionModesConcurrency_Single = AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Single
AIS_SelectionModesConcurrency_GlobalOrLocal = AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_GlobalOrLocal
AIS_SelectionModesConcurrency_Multiple = AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Multiple

class AIS_SelectionScheme(IntEnum):
    AIS_SelectionScheme_UNKNOWN: int = ...
    AIS_SelectionScheme_Replace: int = ...
    AIS_SelectionScheme_Add: int = ...
    AIS_SelectionScheme_Remove: int = ...
    AIS_SelectionScheme_XOR: int = ...
    AIS_SelectionScheme_Clear: int = ...
    AIS_SelectionScheme_ReplaceExtra: int = ...

AIS_SelectionScheme_UNKNOWN = AIS_SelectionScheme.AIS_SelectionScheme_UNKNOWN
AIS_SelectionScheme_Replace = AIS_SelectionScheme.AIS_SelectionScheme_Replace
AIS_SelectionScheme_Add = AIS_SelectionScheme.AIS_SelectionScheme_Add
AIS_SelectionScheme_Remove = AIS_SelectionScheme.AIS_SelectionScheme_Remove
AIS_SelectionScheme_XOR = AIS_SelectionScheme.AIS_SelectionScheme_XOR
AIS_SelectionScheme_Clear = AIS_SelectionScheme.AIS_SelectionScheme_Clear
AIS_SelectionScheme_ReplaceExtra = AIS_SelectionScheme.AIS_SelectionScheme_ReplaceExtra

class AIS_StatusOfDetection(IntEnum):
    AIS_SOD_Error: int = ...
    AIS_SOD_Nothing: int = ...
    AIS_SOD_AllBad: int = ...
    AIS_SOD_Selected: int = ...
    AIS_SOD_OnlyOneDetected: int = ...
    AIS_SOD_OnlyOneGood: int = ...
    AIS_SOD_SeveralGood: int = ...

AIS_SOD_Error = AIS_StatusOfDetection.AIS_SOD_Error
AIS_SOD_Nothing = AIS_StatusOfDetection.AIS_SOD_Nothing
AIS_SOD_AllBad = AIS_StatusOfDetection.AIS_SOD_AllBad
AIS_SOD_Selected = AIS_StatusOfDetection.AIS_SOD_Selected
AIS_SOD_OnlyOneDetected = AIS_StatusOfDetection.AIS_SOD_OnlyOneDetected
AIS_SOD_OnlyOneGood = AIS_StatusOfDetection.AIS_SOD_OnlyOneGood
AIS_SOD_SeveralGood = AIS_StatusOfDetection.AIS_SOD_SeveralGood

class AIS_StatusOfPick(IntEnum):
    AIS_SOP_Error: int = ...
    AIS_SOP_NothingSelected: int = ...
    AIS_SOP_Removed: int = ...
    AIS_SOP_OneSelected: int = ...
    AIS_SOP_SeveralSelected: int = ...

AIS_SOP_Error = AIS_StatusOfPick.AIS_SOP_Error
AIS_SOP_NothingSelected = AIS_StatusOfPick.AIS_SOP_NothingSelected
AIS_SOP_Removed = AIS_StatusOfPick.AIS_SOP_Removed
AIS_SOP_OneSelected = AIS_StatusOfPick.AIS_SOP_OneSelected
AIS_SOP_SeveralSelected = AIS_StatusOfPick.AIS_SOP_SeveralSelected

class AIS_TrihedronSelectionMode(IntEnum):
    AIS_TrihedronSelectionMode_EntireObject: int = ...
    AIS_TrihedronSelectionMode_Origin: int = ...
    AIS_TrihedronSelectionMode_Axes: int = ...
    AIS_TrihedronSelectionMode_MainPlanes: int = ...

AIS_TrihedronSelectionMode_EntireObject = AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_EntireObject
AIS_TrihedronSelectionMode_Origin = AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Origin
AIS_TrihedronSelectionMode_Axes = AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Axes
AIS_TrihedronSelectionMode_MainPlanes = AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_MainPlanes

class AIS_TypeOfAttribute(IntEnum):
    AIS_TOA_Line: int = ...
    AIS_TOA_Dimension: int = ...
    AIS_TOA_Wire: int = ...
    AIS_TOA_Plane: int = ...
    AIS_TOA_Vector: int = ...
    AIS_TOA_UIso: int = ...
    AIS_TOA_VIso: int = ...
    AIS_TOA_Free: int = ...
    AIS_TOA_UnFree: int = ...
    AIS_TOA_Section: int = ...
    AIS_TOA_Hidden: int = ...
    AIS_TOA_Seen: int = ...
    AIS_TOA_FaceBoundary: int = ...
    AIS_TOA_FirstAxis: int = ...
    AIS_TOA_SecondAxis: int = ...
    AIS_TOA_ThirdAxis: int = ...

AIS_TOA_Line = AIS_TypeOfAttribute.AIS_TOA_Line
AIS_TOA_Dimension = AIS_TypeOfAttribute.AIS_TOA_Dimension
AIS_TOA_Wire = AIS_TypeOfAttribute.AIS_TOA_Wire
AIS_TOA_Plane = AIS_TypeOfAttribute.AIS_TOA_Plane
AIS_TOA_Vector = AIS_TypeOfAttribute.AIS_TOA_Vector
AIS_TOA_UIso = AIS_TypeOfAttribute.AIS_TOA_UIso
AIS_TOA_VIso = AIS_TypeOfAttribute.AIS_TOA_VIso
AIS_TOA_Free = AIS_TypeOfAttribute.AIS_TOA_Free
AIS_TOA_UnFree = AIS_TypeOfAttribute.AIS_TOA_UnFree
AIS_TOA_Section = AIS_TypeOfAttribute.AIS_TOA_Section
AIS_TOA_Hidden = AIS_TypeOfAttribute.AIS_TOA_Hidden
AIS_TOA_Seen = AIS_TypeOfAttribute.AIS_TOA_Seen
AIS_TOA_FaceBoundary = AIS_TypeOfAttribute.AIS_TOA_FaceBoundary
AIS_TOA_FirstAxis = AIS_TypeOfAttribute.AIS_TOA_FirstAxis
AIS_TOA_SecondAxis = AIS_TypeOfAttribute.AIS_TOA_SecondAxis
AIS_TOA_ThirdAxis = AIS_TypeOfAttribute.AIS_TOA_ThirdAxis

class AIS_TypeOfAxis(IntEnum):
    AIS_TOAX_Unknown: int = ...
    AIS_TOAX_XAxis: int = ...
    AIS_TOAX_YAxis: int = ...
    AIS_TOAX_ZAxis: int = ...

AIS_TOAX_Unknown = AIS_TypeOfAxis.AIS_TOAX_Unknown
AIS_TOAX_XAxis = AIS_TypeOfAxis.AIS_TOAX_XAxis
AIS_TOAX_YAxis = AIS_TypeOfAxis.AIS_TOAX_YAxis
AIS_TOAX_ZAxis = AIS_TypeOfAxis.AIS_TOAX_ZAxis

class AIS_TypeOfIso(IntEnum):
    AIS_TOI_IsoU: int = ...
    AIS_TOI_IsoV: int = ...
    AIS_TOI_Both: int = ...

AIS_TOI_IsoU = AIS_TypeOfIso.AIS_TOI_IsoU
AIS_TOI_IsoV = AIS_TypeOfIso.AIS_TOI_IsoV
AIS_TOI_Both = AIS_TypeOfIso.AIS_TOI_Both

class AIS_TypeOfPlane(IntEnum):
    AIS_TOPL_Unknown: int = ...
    AIS_TOPL_XYPlane: int = ...
    AIS_TOPL_XZPlane: int = ...
    AIS_TOPL_YZPlane: int = ...

AIS_TOPL_Unknown = AIS_TypeOfPlane.AIS_TOPL_Unknown
AIS_TOPL_XYPlane = AIS_TypeOfPlane.AIS_TOPL_XYPlane
AIS_TOPL_XZPlane = AIS_TypeOfPlane.AIS_TOPL_XZPlane
AIS_TOPL_YZPlane = AIS_TypeOfPlane.AIS_TOPL_YZPlane

class AIS_ViewSelectionTool(IntEnum):
    AIS_ViewSelectionTool_Picking: int = ...
    AIS_ViewSelectionTool_RubberBand: int = ...
    AIS_ViewSelectionTool_Polygon: int = ...
    AIS_ViewSelectionTool_ZoomWindow: int = ...

AIS_ViewSelectionTool_Picking = AIS_ViewSelectionTool.AIS_ViewSelectionTool_Picking
AIS_ViewSelectionTool_RubberBand = AIS_ViewSelectionTool.AIS_ViewSelectionTool_RubberBand
AIS_ViewSelectionTool_Polygon = AIS_ViewSelectionTool.AIS_ViewSelectionTool_Polygon
AIS_ViewSelectionTool_ZoomWindow = AIS_ViewSelectionTool.AIS_ViewSelectionTool_ZoomWindow

class AIS_ViewInputBufferType(IntEnum):
    AIS_ViewInputBufferType_UI: int = ...
    AIS_ViewInputBufferType_GL: int = ...

AIS_ViewInputBufferType_UI = AIS_ViewInputBufferType.AIS_ViewInputBufferType_UI
AIS_ViewInputBufferType_GL = AIS_ViewInputBufferType.AIS_ViewInputBufferType_GL

class AIS_WalkTranslation(IntEnum):
    AIS_WalkTranslation_Forward: int = ...
    AIS_WalkTranslation_Side: int = ...
    AIS_WalkTranslation_Up: int = ...

AIS_WalkTranslation_Forward = AIS_WalkTranslation.AIS_WalkTranslation_Forward
AIS_WalkTranslation_Side = AIS_WalkTranslation.AIS_WalkTranslation_Side
AIS_WalkTranslation_Up = AIS_WalkTranslation.AIS_WalkTranslation_Up

class AIS_WalkRotation(IntEnum):
    AIS_WalkRotation_Yaw: int = ...
    AIS_WalkRotation_Pitch: int = ...
    AIS_WalkRotation_Roll: int = ...

AIS_WalkRotation_Yaw = AIS_WalkRotation.AIS_WalkRotation_Yaw
AIS_WalkRotation_Pitch = AIS_WalkRotation.AIS_WalkRotation_Pitch
AIS_WalkRotation_Roll = AIS_WalkRotation.AIS_WalkRotation_Roll

class ais:
    pass

class AIS_Animation(Standard_Transient):
    def __init__(self, theAnimationName: str) -> None: ...
    def Add(self, theAnimation: AIS_Animation) -> None: ...
    def Children(self) -> False: ...
    def Clear(self) -> None: ...
    def CopyFrom(self, theOther: AIS_Animation) -> None: ...
    def Duration(self) -> float: ...
    def ElapsedTime(self) -> float: ...
    def Find(self, theAnimationName: str) -> AIS_Animation: ...
    def HasOwnDuration(self) -> bool: ...
    def IsStopped(self) -> bool: ...
    def Name(self) -> str: ...
    def OwnDuration(self) -> float: ...
    def Pause(self) -> None: ...
    def Remove(self, theAnimation: AIS_Animation) -> bool: ...
    def Replace(self, theAnimationOld: AIS_Animation, theAnimationNew: AIS_Animation) -> bool: ...
    def SetOwnDuration(self, theDuration: float) -> None: ...
    def SetStartPts(self, thePtsStart: float) -> None: ...
    def SetTimer(self, theTimer: Media_Timer) -> None: ...
    def Start(self, theToUpdate: bool) -> None: ...
    def StartPts(self) -> float: ...
    def StartTimer(self, theStartPts: float, thePlaySpeed: float, theToUpdate: bool, theToStopTimer: Optional[bool] = False) -> None: ...
    def Stop(self) -> None: ...
    def Timer(self) -> Media_Timer: ...
    def Update(self, thePts: float) -> bool: ...
    def UpdateTimer(self) -> float: ...
    def UpdateTotalDuration(self) -> None: ...

class AIS_AnimationProgress:
    def __init__(self) -> None: ...

class AIS_AttributeFilter(SelectMgr_Filter):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, aCol: Quantity_NameOfColor) -> None: ...
    @overload
    def __init__(self, aWidth: float) -> None: ...
    def HasColor(self) -> bool: ...
    def HasWidth(self) -> bool: ...
    def IsOk(self, anObj: SelectMgr_EntityOwner) -> bool: ...
    def SetColor(self, theCol: Quantity_NameOfColor) -> None: ...
    def SetWidth(self, theWidth: float) -> None: ...
    def UnsetColor(self) -> None: ...
    def UnsetWidth(self) -> None: ...

class AIS_BadEdgeFilter(SelectMgr_Filter):
    def __init__(self) -> None: ...
    def ActsOn(self, aType: TopAbs_ShapeEnum) -> bool: ...
    def AddEdge(self, anEdge: TopoDS_Edge, Index: int) -> None: ...
    def IsOk(self, EO: SelectMgr_EntityOwner) -> bool: ...
    def RemoveEdges(self, Index: int) -> None: ...
    def SetContour(self, Index: int) -> None: ...

class AIS_C0RegularityFilter(SelectMgr_Filter):
    def __init__(self, aShape: TopoDS_Shape) -> None: ...
    def ActsOn(self, aType: TopAbs_ShapeEnum) -> bool: ...
    def IsOk(self, EO: SelectMgr_EntityOwner) -> bool: ...

class AIS_ColoredDrawer(Prs3d_Drawer):
    def __init__(self, theLink: Prs3d_Drawer) -> None: ...
    def HasOwnColor(self) -> bool: ...
    def HasOwnMaterial(self) -> bool: ...
    def HasOwnTransparency(self) -> bool: ...
    def HasOwnWidth(self) -> bool: ...
    def IsHidden(self) -> bool: ...
    def SetHidden(self, theToHide: bool) -> None: ...
    def SetOwnMaterial(self) -> None: ...
    def UnsetOwnColor(self) -> None: ...
    def UnsetOwnMaterial(self) -> None: ...
    def UnsetOwnTransparency(self) -> None: ...
    def UnsetOwnWidth(self) -> None: ...

class AIS_ExclusionFilter(SelectMgr_Filter):
    @overload
    def __init__(self, ExclusionFlagOn: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, TypeToExclude: AIS_KindOfInteractive, ExclusionFlagOn: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, TypeToExclude: AIS_KindOfInteractive, SignatureInType: int, ExclusionFlagOn: Optional[bool] = True) -> None: ...
    @overload
    def Add(self, TypeToExclude: AIS_KindOfInteractive) -> bool: ...
    @overload
    def Add(self, TypeToExclude: AIS_KindOfInteractive, SignatureInType: int) -> bool: ...
    def Clear(self) -> None: ...
    def IsExclusionFlagOn(self) -> bool: ...
    def IsOk(self, anObj: SelectMgr_EntityOwner) -> bool: ...
    def IsStored(self, aType: AIS_KindOfInteractive) -> bool: ...
    def ListOfSignature(self, aType: AIS_KindOfInteractive, TheStoredList: TColStd_ListOfInteger) -> None: ...
    def ListOfStoredTypes(self, TheList: TColStd_ListOfInteger) -> None: ...
    @overload
    def Remove(self, TypeToExclude: AIS_KindOfInteractive) -> bool: ...
    @overload
    def Remove(self, TypeToExclude: AIS_KindOfInteractive, SignatureInType: int) -> bool: ...
    def SetExclusionFlag(self, theStatus: bool) -> None: ...

class AIS_GlobalStatus(Standard_Transient):
    def __init__(self) -> None: ...
    def AddSelectionMode(self, theMode: int) -> bool: ...
    def ClearSelectionModes(self) -> None: ...
    def DisplayMode(self) -> int: ...
    def HilightStyle(self) -> Prs3d_Drawer: ...
    def IsHilighted(self) -> bool: ...
    def IsSModeIn(self, theMode: int) -> bool: ...
    def IsSubIntensityOn(self) -> bool: ...
    def RemoveSelectionMode(self, theMode: int) -> bool: ...
    def SelectionModes(self) -> TColStd_ListOfInteger: ...
    def SetDisplayMode(self, theMode: int) -> None: ...
    def SetHilightStatus(self, theStatus: bool) -> None: ...
    def SetHilightStyle(self, theStyle: Prs3d_Drawer) -> None: ...
    def SetSubIntensity(self, theIsOn: bool) -> None: ...

class AIS_GraphicTool:
    @overload
    @staticmethod
    def GetInteriorColor(aDrawer: Prs3d_Drawer) -> Quantity_NameOfColor: ...
    @overload
    @staticmethod
    def GetInteriorColor(aDrawer: Prs3d_Drawer, aColor: Quantity_Color) -> None: ...
    @staticmethod
    def GetLineAtt(aDrawer: Prs3d_Drawer, TheTypeOfAttributes: AIS_TypeOfAttribute, aCol: Quantity_NameOfColor) -> Tuple[float, Aspect_TypeOfLine]: ...
    @overload
    @staticmethod
    def GetLineColor(aDrawer: Prs3d_Drawer, TheTypeOfAttributes: AIS_TypeOfAttribute) -> Quantity_NameOfColor: ...
    @overload
    @staticmethod
    def GetLineColor(aDrawer: Prs3d_Drawer, TheTypeOfAttributes: AIS_TypeOfAttribute, TheLineColor: Quantity_Color) -> None: ...
    @staticmethod
    def GetLineType(aDrawer: Prs3d_Drawer, TheTypeOfAttributes: AIS_TypeOfAttribute) -> Aspect_TypeOfLine: ...
    @staticmethod
    def GetLineWidth(aDrawer: Prs3d_Drawer, TheTypeOfAttributes: AIS_TypeOfAttribute) -> float: ...
    @staticmethod
    def GetMaterial(aDrawer: Prs3d_Drawer) -> Graphic3d_MaterialAspect: ...

class AIS_InteractiveContext(Standard_Transient):
    def __init__(self, MainViewer: V3d_Viewer) -> None: ...
    @overload
    def Activate(self, theObj: AIS_InteractiveObject, theMode: Optional[int] = 0, theIsForce: Optional[bool] = False) -> None: ...
    @overload
    def Activate(self, theMode: int, theIsForce: Optional[bool] = False) -> None: ...
    def ActivatedModes(self, anIobj: AIS_InteractiveObject, theList: TColStd_ListOfInteger) -> None: ...
    def AddFilter(self, theFilter: SelectMgr_Filter) -> None: ...
    def AddOrRemoveCurrentObject(self, theObj: AIS_InteractiveObject, theIsToUpdateViewer: bool) -> None: ...
    @overload
    def AddOrRemoveSelected(self, theObject: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    @overload
    def AddOrRemoveSelected(self, theOwner: SelectMgr_EntityOwner, theToUpdateViewer: bool) -> None: ...
    @overload
    def AddSelect(self, theObject: SelectMgr_EntityOwner) -> AIS_StatusOfPick: ...
    @overload
    def AddSelect(self, theObject: AIS_InteractiveObject) -> AIS_StatusOfPick: ...
    def Applicative(self) -> Standard_Transient: ...
    def AutomaticHilight(self) -> bool: ...
    def BeginImmediateDraw(self) -> bool: ...
    @overload
    def BoundingBoxOfSelection(self, theView: V3d_View) -> Bnd_Box: ...
    @overload
    def BoundingBoxOfSelection(self) -> Bnd_Box: ...
    def ClearActiveSensitive(self, aView: V3d_View) -> None: ...
    def ClearCurrents(self, theToUpdateViewer: bool) -> None: ...
    def ClearDetected(self, theToRedrawImmediate: Optional[bool] = False) -> bool: ...
    def ClearPrs(self, theIObj: AIS_InteractiveObject, theMode: int, theToUpdateViewer: bool) -> None: ...
    def ClearSelected(self, theToUpdateViewer: bool) -> None: ...
    def Color(self, aniobj: AIS_InteractiveObject, acolor: Quantity_Color) -> None: ...
    def Current(self) -> AIS_InteractiveObject: ...
    def CurrentViewer(self) -> V3d_Viewer: ...
    @overload
    def Deactivate(self, theObj: AIS_InteractiveObject) -> None: ...
    @overload
    def Deactivate(self, theObj: AIS_InteractiveObject, theMode: int) -> None: ...
    @overload
    def Deactivate(self, theMode: int) -> None: ...
    @overload
    def Deactivate(self) -> None: ...
    def DefaultDrawer(self) -> Prs3d_Drawer: ...
    def DetectedCurrentObject(self) -> AIS_InteractiveObject: ...
    def DetectedCurrentOwner(self) -> SelectMgr_EntityOwner: ...
    def DetectedCurrentShape(self) -> TopoDS_Shape: ...
    def DetectedInteractive(self) -> AIS_InteractiveObject: ...
    def DetectedOwner(self) -> SelectMgr_EntityOwner: ...
    def DetectedShape(self) -> TopoDS_Shape: ...
    def DeviationAngle(self) -> float: ...
    def DeviationCoefficient(self) -> float: ...
    def DisableDrawHiddenLine(self) -> None: ...
    def Disconnect(self, theAssembly: AIS_InteractiveObject, theObjToDisconnect: Optional[AIS_InteractiveObject] = None) -> None: ...
    @overload
    def Display(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    @overload
    def Display(self, theIObj: AIS_InteractiveObject, theDispMode: int, theSelectionMode: int, theToUpdateViewer: bool, theDispStatus: Optional[PrsMgr_DisplayStatus] = PrsMgr_DisplayStatus_None) -> None: ...
    @overload
    def Display(self, theIObj: AIS_InteractiveObject, theDispMode: int, theSelectionMode: int, theToUpdateViewer: bool, theToAllowDecomposition: bool, theDispStatus: Optional[PrsMgr_DisplayStatus] = PrsMgr_DisplayStatus_None) -> None: ...
    @overload
    def DisplayActiveSensitive(self, aView: V3d_View) -> None: ...
    @overload
    def DisplayActiveSensitive(self, anObject: AIS_InteractiveObject, aView: V3d_View) -> None: ...
    def DisplayAll(self, theToUpdateViewer: bool) -> None: ...
    def DisplayMode(self) -> int: ...
    def DisplayPriority(self, theIObj: AIS_InteractiveObject) -> Graphic3d_DisplayPriority: ...
    def DisplaySelected(self, theToUpdateViewer: bool) -> None: ...
    def DisplayStatus(self, anIobj: AIS_InteractiveObject) -> PrsMgr_DisplayStatus: ...
    @overload
    def DisplayedObjects(self, aListOfIO: AIS_ListOfInteractive) -> None: ...
    @overload
    def DisplayedObjects(self, theWhichKind: AIS_KindOfInteractive, theWhichSignature: int, theListOfIO: AIS_ListOfInteractive) -> None: ...
    def DrawHiddenLine(self) -> bool: ...
    def DumpJson(self, depth: Optional[int]=-1) -> str: ...
    def EnableDrawHiddenLine(self) -> None: ...
    @overload
    def EndImmediateDraw(self, theView: V3d_View) -> bool: ...
    @overload
    def EndImmediateDraw(self) -> bool: ...
    def Erase(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def EraseAll(self, theToUpdateViewer: bool) -> None: ...
    def EraseSelected(self, theToUpdateViewer: bool) -> None: ...
    @overload
    def ErasedObjects(self, theListOfIO: AIS_ListOfInteractive) -> None: ...
    @overload
    def ErasedObjects(self, theWhichKind: AIS_KindOfInteractive, theWhichSignature: int, theListOfIO: AIS_ListOfInteractive) -> None: ...
    def FilterType(self) -> SelectMgr_FilterType: ...
    def Filters(self) -> SelectMgr_ListOfFilter: ...
    def FirstSelectedObject(self) -> AIS_InteractiveObject: ...
    @overload
    def FitSelected(self, theView: V3d_View, theMargin: float, theToUpdate: bool) -> None: ...
    @overload
    def FitSelected(self, theView: V3d_View) -> None: ...
    def GetAutoActivateSelection(self) -> bool: ...
    def GetZLayer(self, theIObj: AIS_InteractiveObject) -> Graphic3d_ZLayerId: ...
    def GlobalFilter(self) -> SelectMgr_AndOrFilter: ...
    def GravityPoint(self, theView: V3d_View) -> gp_Pnt: ...
    def HasApplicative(self) -> bool: ...
    def HasColor(self, aniobj: AIS_InteractiveObject) -> bool: ...
    def HasDetected(self) -> bool: ...
    def HasDetectedShape(self) -> bool: ...
    def HasLocation(self, theObject: AIS_InteractiveObject) -> bool: ...
    def HasNextDetected(self) -> bool: ...
    def HasPolygonOffsets(self, anObj: AIS_InteractiveObject) -> bool: ...
    def HasSelectedShape(self) -> bool: ...
    def HiddenLineAspect(self) -> Prs3d_LineAspect: ...
    @overload
    def HighlightStyle(self, theStyleType: Prs3d_TypeOfHighlight) -> Prs3d_Drawer: ...
    @overload
    def HighlightStyle(self) -> Prs3d_Drawer: ...
    @overload
    def HighlightStyle(self, theObj: AIS_InteractiveObject, theStyle: Prs3d_Drawer) -> bool: ...
    @overload
    def HighlightStyle(self, theOwner: SelectMgr_EntityOwner, theStyle: Prs3d_Drawer) -> bool: ...
    def Hilight(self, theObj: AIS_InteractiveObject, theIsToUpdateViewer: bool) -> None: ...
    def HilightCurrents(self, theToUpdateViewer: bool) -> None: ...
    def HilightNextDetected(self, theView: V3d_View, theToRedrawImmediate: Optional[bool] = True) -> int: ...
    def HilightPreviousDetected(self, theView: V3d_View, theToRedrawImmediate: Optional[bool] = True) -> int: ...
    def HilightSelected(self, theToUpdateViewer: bool) -> None: ...
    def HilightWithColor(self, theObj: AIS_InteractiveObject, theStyle: Prs3d_Drawer, theToUpdateViewer: bool) -> None: ...
    def ImmediateAdd(self, theObj: AIS_InteractiveObject, theMode: Optional[int] = 0) -> bool: ...
    def InitCurrent(self) -> None: ...
    def InitDetected(self) -> None: ...
    def InitSelected(self) -> None: ...
    def IsCurrent(self, theObject: AIS_InteractiveObject) -> bool: ...
    @overload
    def IsDisplayed(self, anIobj: AIS_InteractiveObject) -> bool: ...
    @overload
    def IsDisplayed(self, aniobj: AIS_InteractiveObject, aMode: int) -> bool: ...
    @overload
    def IsHilighted(self, theObj: AIS_InteractiveObject) -> bool: ...
    @overload
    def IsHilighted(self, theOwner: SelectMgr_EntityOwner) -> bool: ...
    def IsImmediateModeOn(self) -> bool: ...
    @overload
    def IsSelected(self, theOwner: SelectMgr_EntityOwner) -> bool: ...
    @overload
    def IsSelected(self, theObj: AIS_InteractiveObject) -> bool: ...
    def IsoNumber(self, WhichIsos: Optional[AIS_TypeOfIso] = AIS_TOI_Both) -> int: ...
    @overload
    def IsoOnPlane(self, theToSwitchOn: bool) -> None: ...
    @overload
    def IsoOnPlane(self) -> bool: ...
    @overload
    def IsoOnTriangulation(self, theIsEnabled: bool, theObject: AIS_InteractiveObject) -> None: ...
    @overload
    def IsoOnTriangulation(self, theToSwitchOn: bool) -> None: ...
    @overload
    def IsoOnTriangulation(self) -> bool: ...
    def LastActiveView(self) -> V3d_View: ...
    @overload
    def Load(self, theObj: AIS_InteractiveObject, theSelectionMode: Optional[int] = -1) -> None: ...
    def Location(self, theObject: AIS_InteractiveObject) -> TopLoc_Location: ...
    def MainPrsMgr(self) -> PrsMgr_PresentationManager: ...
    def MainSelector(self) -> StdSelect_ViewerSelector3d: ...
    def MoreCurrent(self) -> bool: ...
    def MoreDetected(self) -> bool: ...
    def MoreSelected(self) -> bool: ...
    @overload
    def MoveTo(self, theXPix: int, theYPix: int, theView: V3d_View, theToRedrawOnUpdate: bool) -> AIS_StatusOfDetection: ...
    @overload
    def MoveTo(self, theAxis: gp_Ax1, theView: V3d_View, theToRedrawOnUpdate: bool) -> AIS_StatusOfDetection: ...
    def NbCurrents(self) -> int: ...
    def NbSelected(self) -> int: ...
    def NextCurrent(self) -> None: ...
    def NextDetected(self) -> None: ...
    def NextSelected(self) -> None: ...
    def ObjectIterator(self) -> AIS_DataMapIteratorOfDataMapOfIOStatus: ...
    @overload
    def ObjectsByDisplayStatus(self, theStatus: PrsMgr_DisplayStatus, theListOfIO: AIS_ListOfInteractive) -> None: ...
    @overload
    def ObjectsByDisplayStatus(self, WhichKind: AIS_KindOfInteractive, WhichSignature: int, theStatus: PrsMgr_DisplayStatus, theListOfIO: AIS_ListOfInteractive) -> None: ...
    def ObjectsForView(self, theListOfIO: AIS_ListOfInteractive, theView: V3d_View, theIsVisibleInView: bool, theStatus: Optional[PrsMgr_DisplayStatus] = PrsMgr_DisplayStatus_None) -> None: ...
    def ObjectsInside(self, aListOfIO: AIS_ListOfInteractive, WhichKind: Optional[AIS_KindOfInteractive] = AIS_KindOfInteractive_None, WhichSignature: Optional[int] = -1) -> None: ...
    def PickingStrategy(self) -> SelectMgr_PickingStrategy: ...
    def PixelTolerance(self) -> int: ...
    def PlaneSize(self) -> Tuple[bool, float, float]: ...
    def PolygonOffsets(self, anObj: AIS_InteractiveObject) -> Tuple[int, float, float]: ...
    def RebuildSelectionStructs(self) -> None: ...
    def RecomputePrsOnly(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool, theAllModes: Optional[bool] = False) -> None: ...
    def RecomputeSelectionOnly(self, anIObj: AIS_InteractiveObject) -> None: ...
    @overload
    def Redisplay(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool, theAllModes: Optional[bool] = False) -> None: ...
    @overload
    def Redisplay(self, theTypeOfObject: AIS_KindOfInteractive, theSignature: int, theToUpdateViewer: bool) -> None: ...
    def RedrawImmediate(self, theViewer: V3d_Viewer) -> None: ...
    def Remove(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def RemoveAll(self, theToUpdateViewer: bool) -> None: ...
    def RemoveFilter(self, theFilter: SelectMgr_Filter) -> None: ...
    def RemoveFilters(self) -> None: ...
    def ResetLocation(self, theObject: AIS_InteractiveObject) -> None: ...
    @overload
    def Select(self, theOwners: AIS_NArray1OfEntityOwner, theSelScheme: AIS_SelectionScheme) -> AIS_StatusOfPick: ...
    @overload
    def Select(self, theXPMin: int, theYPMin: int, theXPMax: int, theYPMax: int, theView: V3d_View, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    @overload
    def Select(self, thePolyline: TColgp_Array1OfPnt2d, theView: V3d_View, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    @overload
    def Select(self, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    def SelectDetected(self, theSelScheme: Optional[AIS_SelectionScheme] = AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: ...
    def SelectPoint(self, thePnt: Graphic3d_Vec2i, theView: V3d_View, theSelScheme: Optional[AIS_SelectionScheme] = AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: ...
    def SelectPolygon(self, thePolyline: TColgp_Array1OfPnt2d, theView: V3d_View, theSelScheme: Optional[AIS_SelectionScheme] = AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: ...
    def SelectRectangle(self, thePntMin: Graphic3d_Vec2i, thePntMax: Graphic3d_Vec2i, theView: V3d_View, theSelScheme: Optional[AIS_SelectionScheme] = AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: ...
    def SelectedInteractive(self) -> AIS_InteractiveObject: ...
    def SelectedOwner(self) -> SelectMgr_EntityOwner: ...
    def SelectedShape(self) -> TopoDS_Shape: ...
    def Selection(self) -> AIS_Selection: ...
    def SelectionManager(self) -> SelectMgr_SelectionManager: ...
    def SelectionStyle(self) -> Prs3d_Drawer: ...
    def SetAngleAndDeviation(self, theIObj: AIS_InteractiveObject, theAngle: float, theToUpdateViewer: bool) -> None: ...
    def SetAutoActivateSelection(self, theIsAuto: bool) -> None: ...
    def SetAutomaticHilight(self, theStatus: bool) -> None: ...
    def SetColor(self, theIObj: AIS_InteractiveObject, theColor: Quantity_Color, theToUpdateViewer: bool) -> None: ...
    def SetCurrentFacingModel(self, aniobj: AIS_InteractiveObject, aModel: Optional[Aspect_TypeOfFacingModel] = Aspect_TOFM_BOTH_SIDE) -> None: ...
    def SetCurrentObject(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def SetDefaultDrawer(self, theDrawer: Prs3d_Drawer) -> None: ...
    @overload
    def SetDeviationAngle(self, theIObj: AIS_InteractiveObject, theAngle: float, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetDeviationAngle(self, theAngle: float) -> None: ...
    @overload
    def SetDeviationCoefficient(self, theIObj: AIS_InteractiveObject, theCoefficient: float, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetDeviationCoefficient(self, theCoefficient: float) -> None: ...
    @overload
    def SetDisplayMode(self, theMode: int, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetDisplayMode(self, theIObj: AIS_InteractiveObject, theMode: int, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetDisplayPriority(self, theIObj: AIS_InteractiveObject, thePriority: Graphic3d_DisplayPriority) -> None: ...
    @overload
    def SetDisplayPriority(self, theIObj: AIS_InteractiveObject, thePriority: int) -> None: ...
    def SetFilterType(self, theFilterType: SelectMgr_FilterType) -> None: ...
    def SetHiddenLineAspect(self, theAspect: Prs3d_LineAspect) -> None: ...
    @overload
    def SetHighlightStyle(self, theStyleType: Prs3d_TypeOfHighlight, theStyle: Prs3d_Drawer) -> None: ...
    @overload
    def SetHighlightStyle(self, theStyle: Prs3d_Drawer) -> None: ...
    def SetIsoNumber(self, NbIsos: int, WhichIsos: Optional[AIS_TypeOfIso] = AIS_TOI_Both) -> None: ...
    def SetLocalAttributes(self, theIObj: AIS_InteractiveObject, theDrawer: Prs3d_Drawer, theToUpdateViewer: bool) -> None: ...
    def SetLocation(self, theObject: AIS_InteractiveObject, theLocation: TopLoc_Location) -> None: ...
    def SetMaterial(self, theIObj: AIS_InteractiveObject, theMaterial: Graphic3d_MaterialAspect, theToUpdateViewer: bool) -> None: ...
    def SetPickingStrategy(self, theStrategy: SelectMgr_PickingStrategy) -> None: ...
    def SetPixelTolerance(self, thePrecision: Optional[int] = 2) -> None: ...
    @overload
    def SetPlaneSize(self, theSizeX: float, theSizeY: float, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetPlaneSize(self, theSize: float, theToUpdateViewer: bool) -> None: ...
    def SetPolygonOffsets(self, theIObj: AIS_InteractiveObject, theMode: int, theFactor: float, theUnits: float, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetSelected(self, theOwners: SelectMgr_EntityOwner, theToUpdateViewer: bool) -> None: ...
    @overload
    def SetSelected(self, theObject: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def SetSelectedAspect(self, theAspect: Prs3d_BasicAspect, theToUpdateViewer: bool) -> None: ...
    def SetSelectedState(self, theOwner: SelectMgr_EntityOwner, theIsSelected: bool) -> bool: ...
    def SetSelection(self, theSelection: AIS_Selection) -> None: ...
    def SetSelectionModeActive(self, theObj: AIS_InteractiveObject, theMode: int, theToActivate: bool, theConcurrency: Optional[AIS_SelectionModesConcurrency] = AIS_SelectionModesConcurrency_Multiple, theIsForce: Optional[bool] = False) -> None: ...
    def SetSelectionSensitivity(self, theObject: AIS_InteractiveObject, theMode: int, theNewSensitivity: int) -> None: ...
    def SetSelectionStyle(self, theStyle: Prs3d_Drawer) -> None: ...
    def SetSubIntensityColor(self, theColor: Quantity_Color) -> None: ...
    def SetToHilightSelected(self, toHilight: bool) -> None: ...
    def SetTransformPersistence(self, theObject: AIS_InteractiveObject, theTrsfPers: Graphic3d_TransformPers) -> None: ...
    def SetTransparency(self, theIObj: AIS_InteractiveObject, theValue: float, theToUpdateViewer: bool) -> None: ...
    def SetTrihedronSize(self, theSize: float, theToUpdateViewer: bool) -> None: ...
    def SetViewAffinity(self, theIObj: AIS_InteractiveObject, theView: V3d_View, theIsVisible: bool) -> None: ...
    def SetWidth(self, theIObj: AIS_InteractiveObject, theValue: float, theToUpdateViewer: bool) -> None: ...
    def SetZLayer(self, theIObj: AIS_InteractiveObject, theLayerId: int) -> None: ...
    @overload
    def ShiftSelect(self, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    @overload
    def ShiftSelect(self, thePolyline: TColgp_Array1OfPnt2d, theView: V3d_View, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    @overload
    def ShiftSelect(self, theXPMin: int, theYPMin: int, theXPMax: int, theYPMax: int, theView: V3d_View, theToUpdateViewer: bool) -> AIS_StatusOfPick: ...
    def SubIntensityColor(self) -> Quantity_Color: ...
    def SubIntensityOff(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def SubIntensityOn(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def ToHilightSelected(self) -> bool: ...
    def TrihedronSize(self) -> float: ...
    def Unhilight(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnhilightCurrents(self, theToUpdateViewer: bool) -> None: ...
    def UnhilightSelected(self, theToUpdateViewer: bool) -> None: ...
    def UnsetColor(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnsetDisplayMode(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnsetLocalAttributes(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnsetMaterial(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnsetTransparency(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def UnsetWidth(self, theIObj: AIS_InteractiveObject, theToUpdateViewer: bool) -> None: ...
    def Update(self, theIObj: AIS_InteractiveObject, theUpdateViewer: bool) -> None: ...
    def UpdateCurrent(self) -> None: ...
    def UpdateCurrentViewer(self) -> None: ...
    def UpdateSelected(self, theToUpdateViewer: bool) -> None: ...
    def Width(self, aniobj: AIS_InteractiveObject) -> float: ...

class AIS_InteractiveObject(SelectMgr_SelectableObject):
    def ClearOwner(self) -> None: ...
    def DumpJson(self, depth: Optional[int]=-1) -> str: ...
    def GetContext(self) -> AIS_InteractiveContext: ...
    def GetOwner(self) -> Standard_Transient: ...
    def HasInteractiveContext(self) -> bool: ...
    def HasOwner(self) -> bool: ...
    def HasPresentation(self) -> bool: ...
    def InteractiveContext(self) -> AIS_InteractiveContext: ...
    def Presentation(self) -> Prs3d_Presentation: ...
    def ProcessDragging(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theOwner: SelectMgr_EntityOwner, theDragFrom: Graphic3d_Vec2i, theDragTo: Graphic3d_Vec2i, theAction: AIS_DragAction) -> bool: ...
    def Redisplay(self, AllModes: Optional[bool] = False) -> None: ...
    def SetAspect(self, anAspect: Prs3d_BasicAspect) -> None: ...
    def SetContext(self, aCtx: AIS_InteractiveContext) -> None: ...
    def SetOwner(self, theApplicativeEntity: Standard_Transient) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...

class AIS_LightSourceOwner(SelectMgr_EntityOwner):
    def __init__(self, theObject: AIS_LightSource, thePriority: Optional[int] = 5) -> None: ...
    def HandleMouseClick(self, thePoint: Graphic3d_Vec2i, theButton: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsDoubleClick: bool) -> bool: ...
    def HilightWithColor(self, thePrsMgr: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theMode: int) -> None: ...
    def IsForcedHilight(self) -> bool: ...

class AIS_ManipulatorOwner(SelectMgr_EntityOwner):
    def __init__(self, theSelObject: SelectMgr_SelectableObject, theIndex: int, theMode: AIS_ManipulatorMode, thePriority: Optional[int] = 0) -> None: ...
    def HilightWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theMode: int) -> None: ...
    def Index(self) -> int: ...
    def IsHilighted(self, thePM: PrsMgr_PresentationManager, theMode: int) -> bool: ...
    def Mode(self) -> AIS_ManipulatorMode: ...
    def Unhilight(self, thePM: PrsMgr_PresentationManager, theMode: int) -> None: ...

class AIS_PointCloudOwner(SelectMgr_EntityOwner):
    def __init__(self, theOrigin: AIS_PointCloud) -> None: ...
    def Clear(self, thePrsMgr: PrsMgr_PresentationManager, theMode: int) -> None: ...
    def DetectedPoints(self) -> TColStd_HPackedMapOfInteger: ...
    def HilightWithColor(self, thePrsMgr: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theMode: int) -> None: ...
    def IsForcedHilight(self) -> bool: ...
    def SelectedPoints(self) -> TColStd_HPackedMapOfInteger: ...
    def Unhilight(self, thePrsMgr: PrsMgr_PresentationManager, theMode: int) -> None: ...

class AIS_Selection(Standard_Transient):
    def __init__(self) -> None: ...
    def AddSelect(self, theObject: SelectMgr_EntityOwner) -> AIS_SelectStatus: ...
    def Clear(self) -> None: ...
    def ClearAndSelect(self, theObject: SelectMgr_EntityOwner, theFilter: SelectMgr_Filter, theIsDetected: bool) -> None: ...
    def Extent(self) -> int: ...
    def Init(self) -> None: ...
    def IsEmpty(self) -> bool: ...
    def IsSelected(self, theObject: SelectMgr_EntityOwner) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Objects(self) -> AIS_NListOfEntityOwner: ...
    def Select(self, theOwner: SelectMgr_EntityOwner, theFilter: SelectMgr_Filter, theSelScheme: AIS_SelectionScheme, theIsDetected: bool) -> AIS_SelectStatus: ...
    def SelectOwners(self, thePickedOwners: AIS_NArray1OfEntityOwner, theSelScheme: AIS_SelectionScheme, theToAllowSelOverlap: bool, theFilter: SelectMgr_Filter) -> None: ...
    def Value(self) -> SelectMgr_EntityOwner: ...

class AIS_TrihedronOwner(SelectMgr_EntityOwner):
    def __init__(self, theSelObject: SelectMgr_SelectableObject, theDatumPart: Prs3d_DatumParts, thePriority: int) -> None: ...
    def DatumPart(self) -> Prs3d_DatumParts: ...
    def HilightWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theMode: int) -> None: ...
    def IsHilighted(self, thePM: PrsMgr_PresentationManager, theMode: int) -> bool: ...
    def Unhilight(self, thePM: PrsMgr_PresentationManager, theMode: int) -> None: ...

class AIS_TypeFilter(SelectMgr_Filter):
    def __init__(self, aGivenKind: AIS_KindOfInteractive) -> None: ...
    def IsOk(self, anobj: SelectMgr_EntityOwner) -> bool: ...

class AIS_ViewController(Aspect_WindowInputListener):
    def __init__(self) -> None: ...
    def AbortViewAnimation(self) -> None: ...
    def AddTouchPoint(self, theId: int, thePnt: Graphic3d_Vec2d, theClearBefore: Optional[bool] = false) -> None: ...
    def ChangeInputBuffer(self, theType: AIS_ViewInputBufferType) -> AIS_ViewInputBuffer: ...
    def ChangeMouseGestureMap(self) -> AIS_MouseGestureMap: ...
    def ChangeMouseSelectionSchemes(self) -> AIS_MouseSelectionSchemeMap: ...
    def FetchNavigationKeys(self, theCrouchRatio: float, theRunRatio: float) -> AIS_WalkDelta: ...
    def FitAllAuto(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def FlushViewEvents(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theToHandle: Optional[bool] = False) -> None: ...
    def GravityPoint(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> gp_Pnt: ...
    def HandleViewEvents(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def HasPreviousMoveTo(self) -> bool: ...
    def InputBuffer(self, theType: AIS_ViewInputBufferType) -> AIS_ViewInputBuffer: ...
    def IsContinuousRedraw(self) -> bool: ...
    def KeyDown(self, theKey: Aspect_VKey, theTime: float, thePressure: Optional[float] = 1.0) -> None: ...
    def KeyFromAxis(self, theNegative: Aspect_VKey, thePositive: Aspect_VKey, theTime: float, thePressure: float) -> None: ...
    def KeyUp(self, theKey: Aspect_VKey, theTime: float) -> None: ...
    def MinZoomDistance(self) -> float: ...
    def MouseAcceleration(self) -> float: ...
    def MouseDoubleClickInterval(self) -> float: ...
    def MouseGestureMap(self) -> AIS_MouseGestureMap: ...
    def MouseSelectionSchemes(self) -> AIS_MouseSelectionSchemeMap: ...
    def NavigationMode(self) -> AIS_NavigationMode: ...
    def ObjectsAnimation(self) -> AIS_Animation: ...
    def OnObjectDragged(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theAction: AIS_DragAction) -> None: ...
    def OnSelectionChanged(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def OnSubviewChanged(self, theCtx: AIS_InteractiveContext, theOldView: V3d_View, theNewView: V3d_View) -> None: ...
    def OrbitAcceleration(self) -> float: ...
    def PickAxis(self, theTopPnt: gp_Pnt, theCtx: AIS_InteractiveContext, theView: V3d_View, theAxis: gp_Ax1) -> bool: ...
    def PickPoint(self, thePnt: gp_Pnt, theCtx: AIS_InteractiveContext, theView: V3d_View, theCursor: Graphic3d_Vec2i, theToStickToPickRay: bool) -> bool: ...
    def PreviousMoveTo(self) -> Graphic3d_Vec2i: ...
    def ProcessClose(self) -> None: ...
    def ProcessConfigure(self, theIsResized: bool) -> None: ...
    def ProcessExpose(self) -> None: ...
    def ProcessFocus(self, theIsActivated: bool) -> None: ...
    def ProcessInput(self) -> None: ...
    def RemoveTouchPoint(self, theId: int, theClearSelectPnts: Optional[bool] = false) -> bool: ...
    def ResetPreviousMoveTo(self) -> None: ...
    def ResetViewInput(self) -> None: ...
    def RotationMode(self) -> AIS_RotationMode: ...
    @overload
    def SelectInViewer(self, thePnt: Graphic3d_Vec2i, theScheme: Optional[AIS_SelectionScheme] = AIS_SelectionScheme_Replace) -> None: ...
    def SetAllowDragging(self, theToEnable: bool) -> None: ...
    def SetAllowHighlight(self, theToEnable: bool) -> None: ...
    def SetAllowPanning(self, theToEnable: bool) -> None: ...
    def SetAllowRotation(self, theToEnable: bool) -> None: ...
    def SetAllowTouchZRotation(self, theToEnable: bool) -> None: ...
    def SetAllowZFocus(self, theToEnable: bool) -> None: ...
    def SetAllowZooming(self, theToEnable: bool) -> None: ...
    def SetContinuousRedraw(self, theToEnable: bool) -> None: ...
    def SetDisplayXRAuxDevices(self, theToDisplay: bool) -> None: ...
    def SetDisplayXRHands(self, theToDisplay: bool) -> None: ...
    def SetInvertPitch(self, theToInvert: bool) -> None: ...
    def SetLockOrbitZUp(self, theToForceUp: bool) -> None: ...
    def SetMinZoomDistance(self, theDist: float) -> None: ...
    def SetMouseAcceleration(self, theRatio: float) -> None: ...
    def SetMouseDoubleClickInterval(self, theSeconds: float) -> None: ...
    def SetNavigationMode(self, theMode: AIS_NavigationMode) -> None: ...
    def SetObjectsAnimation(self, theAnimation: AIS_Animation) -> None: ...
    def SetOrbitAcceleration(self, theRatio: float) -> None: ...
    def SetPauseObjectsAnimation(self, theToPause: bool) -> None: ...
    def SetRotationMode(self, theMode: AIS_RotationMode) -> None: ...
    def SetShowPanAnchorPoint(self, theToShow: bool) -> None: ...
    def SetShowRotateCenter(self, theToShow: bool) -> None: ...
    def SetStickToRayOnRotation(self, theToEnable: bool) -> None: ...
    def SetStickToRayOnZoom(self, theToEnable: bool) -> None: ...
    def SetThrustSpeed(self, theSpeed: float) -> None: ...
    def SetTouchToleranceScale(self, theTolerance: float) -> None: ...
    def SetViewAnimation(self, theAnimation: AIS_AnimationCamera) -> None: ...
    def SetWalkSpeedAbsolute(self, theSpeed: float) -> None: ...
    def SetWalkSpeedRelative(self, theFactor: float) -> None: ...
    def ThrustSpeed(self) -> float: ...
    def ToAllowDragging(self) -> bool: ...
    def ToAllowHighlight(self) -> bool: ...
    def ToAllowPanning(self) -> bool: ...
    def ToAllowRotation(self) -> bool: ...
    def ToAllowTouchZRotation(self) -> bool: ...
    def ToAllowZFocus(self) -> bool: ...
    def ToAllowZooming(self) -> bool: ...
    def ToDisplayXRAuxDevices(self) -> bool: ...
    def ToDisplayXRHands(self) -> bool: ...
    def ToInvertPitch(self) -> bool: ...
    def ToLockOrbitZUp(self) -> bool: ...
    def ToPauseObjectsAnimation(self) -> bool: ...
    def ToShowPanAnchorPoint(self) -> bool: ...
    def ToShowRotateCenter(self) -> bool: ...
    def ToStickToRayOnRotation(self) -> bool: ...
    def ToStickToRayOnZoom(self) -> bool: ...
    def TouchToleranceScale(self) -> float: ...
    def UpdateMouseButtons(self, thePoint: Graphic3d_Vec2i, theButtons: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def UpdateMouseClick(self, thePoint: Graphic3d_Vec2i, theButton: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsDoubleClick: bool) -> bool: ...
    def UpdateMousePosition(self, thePoint: Graphic3d_Vec2i, theButtons: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def UpdateMouseScroll(self, theDelta: Aspect_ScrollDelta) -> bool: ...
    def UpdatePolySelection(self, thePnt: Graphic3d_Vec2i, theToAppend: bool) -> None: ...
    def UpdateRubberBand(self, thePntFrom: Graphic3d_Vec2i, thePntTo: Graphic3d_Vec2i) -> None: ...
    def UpdateTouchPoint(self, theId: int, thePnt: Graphic3d_Vec2d) -> None: ...
    def UpdateViewOrientation(self, theOrientation: V3d_TypeOfOrientation, theToFitAll: bool) -> None: ...
    def UpdateZRotation(self, theAngle: float) -> bool: ...
    def UpdateZoom(self, theDelta: Aspect_ScrollDelta) -> bool: ...
    def ViewAnimation(self) -> AIS_AnimationCamera: ...
    def WalkSpeedAbsolute(self) -> float: ...
    def WalkSpeedRelative(self) -> float: ...
    def handleCameraActions(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theWalk: AIS_WalkDelta) -> None: ...
    def handleMoveTo(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleNavigationKeys(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> AIS_WalkDelta: ...
    def handleOrbitRotation(self, theView: V3d_View, thePnt: gp_Pnt, theToLockZUp: bool) -> None: ...
    def handlePanning(self, theView: V3d_View) -> None: ...
    def handleViewOrientationKeys(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleViewRedraw(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleViewRotation(self, theView: V3d_View, theYawExtra: float, thePitchExtra: float, theRoll: float, theToRestartOnIncrement: bool) -> None: ...
    def handleXRHighlight(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleXRInput(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theWalk: AIS_WalkDelta) -> None: ...
    def handleXRMoveTo(self, theCtx: AIS_InteractiveContext, theView: V3d_View, thePose: gp_Trsf, theToHighlight: bool) -> int: ...
    def handleXRPicking(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleXRPresentations(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleXRTeleport(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleXRTurnPad(self, theCtx: AIS_InteractiveContext, theView: V3d_View) -> None: ...
    def handleZFocusScroll(self, theView: V3d_View, theParams: Aspect_ScrollDelta) -> None: ...
    def handleZRotate(self, theView: V3d_View) -> None: ...
    def handleZoom(self, theView: V3d_View, theParams: Aspect_ScrollDelta, thePnt: gp_Pnt) -> None: ...
    def hasPanningAnchorPoint(self) -> bool: ...
    def panningAnchorPoint(self) -> gp_Pnt: ...
    def setAskNextFrame(self, theToDraw: Optional[bool] = true) -> None: ...
    def setPanningAnchorPoint(self, thePnt: gp_Pnt) -> None: ...
    def toAskNextFrame(self) -> bool: ...

class AIS_ViewCubeOwner(SelectMgr_EntityOwner):
    def __init__(self, theObject: AIS_ViewCube, theOrient: V3d_TypeOfOrientation, thePriority: Optional[int] = 5) -> None: ...
    def HandleMouseClick(self, thePoint: Graphic3d_Vec2i, theButton: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsDoubleClick: bool) -> bool: ...
    def IsForcedHilight(self) -> bool: ...
    def MainOrientation(self) -> V3d_TypeOfOrientation: ...

class AIS_ViewCubeSensitive(Select3D_SensitivePrimitiveArray):
    def __init__(self, theOwner: SelectMgr_EntityOwner, theTris: Graphic3d_ArrayOfTriangles) -> None: ...
    def Matches(self, theMgr: SelectBasics_SelectingVolumeManager, thePickResult: SelectBasics_PickResult) -> bool: ...

class AIS_ViewInputBuffer:
    def __init__(self) -> None: ...
    def Reset(self) -> None: ...

class AIS_WalkDelta:
    def __init__(self) -> None: ...
    def IsCrouching(self) -> bool: ...
    def IsDefined(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def IsJumping(self) -> bool: ...
    def IsRunning(self) -> bool: ...
    def SetCrouching(self, theIsCrouching: bool) -> None: ...
    def SetDefined(self, theIsDefined: bool) -> None: ...
    def SetJumping(self, theIsJumping: bool) -> None: ...
    def SetRunning(self, theIsRunning: bool) -> None: ...
    def ToMove(self) -> bool: ...
    def ToRotate(self) -> bool: ...

class AIS_WalkPart:
    def __init__(self) -> None: ...
    def IsEmpty(self) -> bool: ...

class AIS_AnimationCamera(AIS_Animation):
    def __init__(self, theAnimationName: str, theView: V3d_View) -> None: ...
    def CameraEnd(self) -> Graphic3d_Camera: ...
    def CameraStart(self) -> Graphic3d_Camera: ...
    def SetCameraEnd(self, theCameraEnd: Graphic3d_Camera) -> None: ...
    def SetCameraStart(self, theCameraStart: Graphic3d_Camera) -> None: ...
    def SetView(self, theView: V3d_View) -> None: ...
    def View(self) -> V3d_View: ...

class AIS_Axis(AIS_InteractiveObject):
    @overload
    def __init__(self, aComponent: Geom_Line) -> None: ...
    @overload
    def __init__(self, aComponent: Geom_Axis2Placement, anAxisType: AIS_TypeOfAxis) -> None: ...
    @overload
    def __init__(self, anAxis: Geom_Axis1Placement) -> None: ...
    @overload
    def __init__(self, theAxis: gp_Ax1, theLength: Optional[float] = -1) -> None: ...
    def AcceptDisplayMode(self, aMode: int) -> bool: ...
    def Axis2Placement(self) -> Geom_Axis2Placement: ...
    def Component(self) -> Geom_Line: ...
    def IsXYZAxis(self) -> bool: ...
    def SetAxis1Placement(self, anAxis: Geom_Axis1Placement) -> None: ...
    def SetAxis2Placement(self, aComponent: Geom_Axis2Placement, anAxisType: AIS_TypeOfAxis) -> None: ...
    def SetColor(self, aColor: Quantity_Color) -> None: ...
    def SetComponent(self, aComponent: Geom_Line) -> None: ...
    def SetDisplayAspect(self, theNewDatumAspect: Prs3d_LineAspect) -> None: ...
    def SetTypeOfAxis(self, theTypeAxis: AIS_TypeOfAxis) -> None: ...
    def SetWidth(self, aValue: float) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def TypeOfAxis(self) -> AIS_TypeOfAxis: ...
    def UnsetColor(self) -> None: ...
    def UnsetWidth(self) -> None: ...

class AIS_BaseAnimationObject(AIS_Animation):
    pass

class AIS_CameraFrustum(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def SetCameraFrustum(self, theCamera: Graphic3d_Camera) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def UnsetColor(self) -> None: ...
    def UnsetTransparency(self) -> None: ...

class AIS_Circle(AIS_InteractiveObject):
    @overload
    def __init__(self, aCircle: Geom_Circle) -> None: ...
    @overload
    def __init__(self, theCircle: Geom_Circle, theUStart: float, theUEnd: float, theIsFilledCircleSens: Optional[bool] = False) -> None: ...
    def Circle(self) -> Geom_Circle: ...
    def IsFilledCircleSens(self) -> bool: ...
    def Parameters(self) -> Tuple[float, float]: ...
    def SetCircle(self, theCircle: Geom_Circle) -> None: ...
    def SetColor(self, aColor: Quantity_Color) -> None: ...
    def SetFilledCircleSens(self, theIsFilledCircleSens: bool) -> None: ...
    def SetFirstParam(self, theU: float) -> None: ...
    def SetLastParam(self, theU: float) -> None: ...
    def SetWidth(self, aValue: float) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetColor(self) -> None: ...
    def UnsetWidth(self) -> None: ...

class AIS_ColorScale(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def ColorRange(self, theMinColor: Quantity_Color, theMaxColor: Quantity_Color) -> None: ...
    def Compute(self, thePrsMgr: PrsMgr_PresentationManager, thePresentation: Prs3d_Presentation, theMode: int) -> None: ...
    @overload
    @staticmethod
    def FindColor(theValue: float, theMin: float, theMax: float, theColorsCount: int, theColorHlsMin: Graphic3d_Vec3d, theColorHlsMax: Graphic3d_Vec3d, theColor: Quantity_Color) -> bool: ...
    @overload
    @staticmethod
    def FindColor(theValue: float, theMin: float, theMax: float, theColorsCount: int, theColor: Quantity_Color) -> bool: ...
    @overload
    def FindColor(self, theValue: float, theColor: Quantity_Color) -> bool: ...
    def Format(self) -> str: ...
    def GetBreadth(self) -> int: ...
    def GetColorType(self) -> Aspect_TypeOfColorScaleData: ...
    @overload
    def GetColors(self, theColors: Aspect_SequenceOfColor) -> None: ...
    @overload
    def GetColors(self) -> Aspect_SequenceOfColor: ...
    def GetFormat(self) -> str: ...
    def GetHeight(self) -> int: ...
    def GetIntervalColor(self, theIndex: int) -> Quantity_Color: ...
    def GetLabel(self, theIndex: int) -> str: ...
    def GetLabelPosition(self) -> Aspect_TypeOfColorScalePosition: ...
    def GetLabelType(self) -> Aspect_TypeOfColorScaleData: ...
    def GetLabels(self, theLabels: TColStd_SequenceOfExtendedString) -> None: ...
    def GetMax(self) -> float: ...
    def GetMin(self) -> float: ...
    def GetNumberOfIntervals(self) -> int: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetTextHeight(self) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitlePosition(self) -> Aspect_TypeOfColorScalePosition: ...
    def GetXPosition(self) -> int: ...
    def GetYPosition(self) -> int: ...
    def HueMax(self) -> float: ...
    def HueMin(self) -> float: ...
    def HueRange(self) -> Tuple[float, float]: ...
    def IsLabelAtBorder(self) -> bool: ...
    def IsLogarithmic(self) -> bool: ...
    def IsReversed(self) -> bool: ...
    def IsSmoothTransition(self) -> bool: ...
    def Labels(self) -> TColStd_SequenceOfExtendedString: ...
    @staticmethod
    def MakeUniformColors(theNbColors: int, theLightness: float, theHueFrom: float, theHueTo: float) -> Aspect_SequenceOfColor: ...
    def SetBreadth(self, theBreadth: int) -> None: ...
    def SetColorRange(self, theMinColor: Quantity_Color, theMaxColor: Quantity_Color) -> None: ...
    def SetColorType(self, theType: Aspect_TypeOfColorScaleData) -> None: ...
    def SetColors(self, theSeq: Aspect_SequenceOfColor) -> None: ...
    def SetFormat(self, theFormat: str) -> None: ...
    def SetHeight(self, theHeight: int) -> None: ...
    def SetHueRange(self, theMinAngle: float, theMaxAngle: float) -> None: ...
    def SetIntervalColor(self, theColor: Quantity_Color, theIndex: int) -> None: ...
    def SetLabel(self, theLabel: str, theIndex: int) -> None: ...
    def SetLabelAtBorder(self, theOn: bool) -> None: ...
    def SetLabelPosition(self, thePos: Aspect_TypeOfColorScalePosition) -> None: ...
    def SetLabelType(self, theType: Aspect_TypeOfColorScaleData) -> None: ...
    def SetLabels(self, theSeq: TColStd_SequenceOfExtendedString) -> None: ...
    def SetLogarithmic(self, isLogarithmic: bool) -> None: ...
    def SetMax(self, theMax: float) -> None: ...
    def SetMin(self, theMin: float) -> None: ...
    def SetNumberOfIntervals(self, theNum: int) -> None: ...
    def SetPosition(self, theX: int, theY: int) -> None: ...
    def SetRange(self, theMin: float, theMax: float) -> None: ...
    def SetReversed(self, theReverse: bool) -> None: ...
    def SetSize(self, theBreadth: int, theHeight: int) -> None: ...
    def SetSmoothTransition(self, theIsSmooth: bool) -> None: ...
    def SetTextHeight(self, theHeight: int) -> None: ...
    def SetTitle(self, theTitle: str) -> None: ...
    def SetTitlePosition(self, thePos: Aspect_TypeOfColorScalePosition) -> None: ...
    def SetUniformColors(self, theLightness: float, theHueFrom: float, theHueTo: float) -> None: ...
    def SetXPosition(self, theX: int) -> None: ...
    def SetYPosition(self, theY: int) -> None: ...
    def TextHeight(self, theText: str) -> int: ...
    def TextSize(self, theText: str, theHeight: int) -> Tuple[int, int, int]: ...
    def TextWidth(self, theText: str) -> int: ...
    @staticmethod
    def hueToValidRange(theHue: float) -> float: ...

class AIS_ConnectedInteractive(AIS_InteractiveObject):
    def __init__(self, aTypeOfPresentation3d: Optional[PrsMgr_TypeOfPresentation3d] = PrsMgr_TOP_AllView) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def AcceptShapeDecomposition(self) -> bool: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject) -> None: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject, theLocation: gp_Trsf) -> None: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject, theLocation: TopLoc_Datum3D) -> None: ...
    def ConnectedTo(self) -> AIS_InteractiveObject: ...
    def Disconnect(self) -> None: ...
    def HasConnection(self) -> bool: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...

class AIS_LightSource(AIS_InteractiveObject):
    def __init__(self, theLightSource: Graphic3d_CLight) -> None: ...
    def ArcSize(self) -> int: ...
    def IsZoomable(self) -> bool: ...
    def Light(self) -> Graphic3d_CLight: ...
    def MarkerImage(self, theIsEnabled: bool) -> Graphic3d_MarkerImage: ...
    def MarkerType(self, theIsEnabled: bool) -> Aspect_TypeOfMarker: ...
    def NbArrows(self) -> int: ...
    def NbSplitsArrow(self) -> int: ...
    def NbSplitsQuadric(self) -> int: ...
    def SetArcSize(self, theSize: int) -> None: ...
    def SetDisplayName(self, theToDisplay: bool) -> None: ...
    def SetDisplayRange(self, theToDisplay: bool) -> None: ...
    def SetDraggable(self, theIsDraggable: bool) -> None: ...
    def SetLight(self, theLight: Graphic3d_CLight) -> None: ...
    def SetMarkerImage(self, theImage: Graphic3d_MarkerImage, theIsEnabled: bool) -> None: ...
    def SetMarkerType(self, theType: Aspect_TypeOfMarker, theIsEnabled: bool) -> None: ...
    def SetNbArrows(self, theNbArrows: int) -> None: ...
    def SetNbSplitsArrow(self, theNbSplits: int) -> None: ...
    def SetNbSplitsQuadric(self, theNbSplits: int) -> None: ...
    def SetSize(self, theSize: float) -> None: ...
    def SetSwitchOnClick(self, theToHandle: bool) -> None: ...
    def SetZoomable(self, theIsZoomable: bool) -> None: ...
    def Size(self) -> float: ...
    def ToDisplayName(self) -> bool: ...
    def ToDisplayRange(self) -> bool: ...
    def ToSwitchOnClick(self) -> bool: ...
    def Type(self) -> AIS_KindOfInteractive: ...

class AIS_Line(AIS_InteractiveObject):
    @overload
    def __init__(self, aLine: Geom_Line) -> None: ...
    @overload
    def __init__(self, aStartPoint: Geom_Point, aEndPoint: Geom_Point) -> None: ...
    def Line(self) -> Geom_Line: ...
    def Points(self, thePStart: Geom_Point, thePEnd: Geom_Point) -> None: ...
    def SetColor(self, aColor: Quantity_Color) -> None: ...
    def SetLine(self, theLine: Geom_Line) -> None: ...
    def SetPoints(self, thePStart: Geom_Point, thePEnd: Geom_Point) -> None: ...
    def SetWidth(self, aValue: float) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetColor(self) -> None: ...
    def UnsetWidth(self) -> None: ...

class AIS_Manipulator(AIS_InteractiveObject):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, thePosition: gp_Ax2) -> None: ...
    def ActiveAxisIndex(self) -> int: ...
    def ActiveMode(self) -> AIS_ManipulatorMode: ...
    def ClearSelected(self) -> None: ...
    def Compute(self, thePrsMgr: PrsMgr_PresentationManager, thePrs: Prs3d_Presentation, theMode: Optional[int] = 0) -> None: ...
    def ComputeSelection(self, theSelection: SelectMgr_Selection, theMode: int) -> None: ...
    def DeactivateCurrentMode(self) -> None: ...
    def Detach(self) -> None: ...
    def EnableMode(self, theMode: AIS_ManipulatorMode) -> None: ...
    def HasActiveMode(self) -> bool: ...
    def HasActiveTransformation(self) -> bool: ...
    def HilightOwnerWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theOwner: SelectMgr_EntityOwner) -> None: ...
    def HilightSelected(self, thePM: PrsMgr_PresentationManager, theSeq: SelectMgr_SequenceOfOwner) -> None: ...
    def IsAttached(self) -> bool: ...
    def IsAutoHilight(self) -> bool: ...
    def IsModeActivationOnDetection(self) -> bool: ...
    @overload
    def Object(self) -> AIS_InteractiveObject: ...
    @overload
    def Object(self, theIndex: int) -> AIS_InteractiveObject: ...
    def ObjectTransformation(self, theX: int, theY: int, theView: V3d_View, theTrsf: gp_Trsf) -> bool: ...
    def Objects(self) -> AIS_ManipulatorObjectSequence: ...
    def Position(self) -> gp_Ax2: ...
    def ProcessDragging(self, theCtx: AIS_InteractiveContext, theView: V3d_View, theOwner: SelectMgr_EntityOwner, theDragFrom: Graphic3d_Vec2i, theDragTo: Graphic3d_Vec2i, theAction: AIS_DragAction) -> bool: ...
    def SetGap(self, theValue: float) -> None: ...
    def SetModeActivationOnDetection(self, theToEnable: bool) -> None: ...
    @overload
    def SetPart(self, theAxisIndex: int, theMode: AIS_ManipulatorMode, theIsEnabled: bool) -> None: ...
    @overload
    def SetPart(self, theMode: AIS_ManipulatorMode, theIsEnabled: bool) -> None: ...
    def SetPosition(self, thePosition: gp_Ax2) -> None: ...
    def SetSize(self, theSideLength: float) -> None: ...
    def SetTransformPersistence(self, theTrsfPers: Graphic3d_TransformPers) -> None: ...
    def SetZoomPersistence(self, theToEnable: bool) -> None: ...
    def Size(self) -> float: ...
    def StartTransform(self, theX: int, theY: int, theView: V3d_View) -> None: ...
    @overload
    def StartTransformation(self) -> gp_Trsf: ...
    @overload
    def StartTransformation(self, theIndex: int) -> gp_Trsf: ...
    def StopTransform(self, theToApply: Optional[bool] = True) -> None: ...
    @overload
    def Transform(self, aTrsf: gp_Trsf) -> None: ...
    @overload
    def Transform(self, theX: int, theY: int, theView: V3d_View) -> gp_Trsf: ...
    def ZoomPersistence(self) -> bool: ...

class AIS_MediaPlayer(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def Duration(self) -> float: ...
    def OpenInput(self, thePath: str, theToWait: bool) -> None: ...
    def PlayPause(self) -> None: ...
    def PlayerContext(self) -> Media_PlayerContext: ...
    def PresentFrame(self, theLeftCorner: Graphic3d_Vec2i, theMaxSize: Graphic3d_Vec2i) -> bool: ...
    def SetClosePlayer(self) -> None: ...

class AIS_MultipleConnectedInteractive(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def AcceptShapeDecomposition(self) -> bool: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject, theLocation: TopLoc_Datum3D, theTrsfPers: Graphic3d_TransformPers) -> AIS_InteractiveObject: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject) -> AIS_InteractiveObject: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject, theLocation: gp_Trsf) -> AIS_InteractiveObject: ...
    @overload
    def Connect(self, theAnotherObj: AIS_InteractiveObject, theLocation: gp_Trsf, theTrsfPers: Graphic3d_TransformPers) -> AIS_InteractiveObject: ...
    def Disconnect(self, theInteractive: AIS_InteractiveObject) -> None: ...
    def DisconnectAll(self) -> None: ...
    def GetAssemblyOwner(self) -> SelectMgr_EntityOwner: ...
    def GlobalSelOwner(self) -> SelectMgr_EntityOwner: ...
    def HasConnection(self) -> bool: ...
    def SetContext(self, theCtx: AIS_InteractiveContext) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...

class AIS_Plane(AIS_InteractiveObject):
    @overload
    def __init__(self, aComponent: Geom_Plane, aCurrentMode: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, aComponent: Geom_Plane, aCenter: gp_Pnt, aCurrentMode: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, aComponent: Geom_Plane, aCenter: gp_Pnt, aPmin: gp_Pnt, aPmax: gp_Pnt, aCurrentMode: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, aComponent: Geom_Axis2Placement, aPlaneType: AIS_TypeOfPlane, aCurrentMode: Optional[bool] = False) -> None: ...
    def AcceptDisplayMode(self, aMode: int) -> bool: ...
    def Axis2Placement(self) -> Geom_Axis2Placement: ...
    def Center(self) -> gp_Pnt: ...
    def Component(self) -> Geom_Plane: ...
    def ComputeSelection(self, theSelection: SelectMgr_Selection, theMode: int) -> None: ...
    def CurrentMode(self) -> bool: ...
    def HasMinimumSize(self) -> bool: ...
    def HasOwnSize(self) -> bool: ...
    def IsXYZPlane(self) -> bool: ...
    def PlaneAttributes(self, aComponent: Geom_Plane, aCenter: gp_Pnt, aPmin: gp_Pnt, aPmax: gp_Pnt) -> bool: ...
    def SetAxis2Placement(self, aComponent: Geom_Axis2Placement, aPlaneType: AIS_TypeOfPlane) -> None: ...
    def SetCenter(self, theCenter: gp_Pnt) -> None: ...
    def SetColor(self, aColor: Quantity_Color) -> None: ...
    def SetComponent(self, aComponent: Geom_Plane) -> None: ...
    def SetContext(self, aCtx: AIS_InteractiveContext) -> None: ...
    def SetCurrentMode(self, theCurrentMode: bool) -> None: ...
    def SetMinimumSize(self, theValue: float) -> None: ...
    def SetPlaneAttributes(self, aComponent: Geom_Plane, aCenter: gp_Pnt, aPmin: gp_Pnt, aPmax: gp_Pnt) -> None: ...
    @overload
    def SetSize(self, aValue: float) -> None: ...
    @overload
    def SetSize(self, Xval: float, YVal: float) -> None: ...
    def SetTypeOfSensitivity(self, theTypeOfSensitivity: Select3D_TypeOfSensitivity) -> None: ...
    def Signature(self) -> int: ...
    def Size(self) -> Tuple[bool, float, float]: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def TypeOfPlane(self) -> AIS_TypeOfPlane: ...
    def TypeOfSensitivity(self) -> Select3D_TypeOfSensitivity: ...
    def UnsetColor(self) -> None: ...
    def UnsetMinimumSize(self) -> None: ...
    def UnsetSize(self) -> None: ...

class AIS_PlaneTrihedron(AIS_InteractiveObject):
    def __init__(self, aPlane: Geom_Plane) -> None: ...
    def AcceptDisplayMode(self, aMode: int) -> bool: ...
    def Component(self) -> Geom_Plane: ...
    def GetLength(self) -> float: ...
    def Position(self) -> AIS_Point: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetComponent(self, aPlane: Geom_Plane) -> None: ...
    def SetLength(self, theLength: float) -> None: ...
    def SetXLabel(self, theLabel: str) -> None: ...
    def SetYLabel(self, theLabel: str) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def XAxis(self) -> AIS_Line: ...
    def YAxis(self) -> AIS_Line: ...

class AIS_Point(AIS_InteractiveObject):
    def __init__(self, aComponent: Geom_Point) -> None: ...
    def AcceptDisplayMode(self, aMode: int) -> bool: ...
    def Component(self) -> Geom_Point: ...
    def HasMarker(self) -> bool: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetComponent(self, aComponent: Geom_Point) -> None: ...
    def SetMarker(self, aType: Aspect_TypeOfMarker) -> None: ...
    def Signature(self) -> int: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetColor(self) -> None: ...
    def UnsetMarker(self) -> None: ...
    def Vertex(self) -> TopoDS_Vertex: ...

class AIS_PointCloud(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def GetBoundingBox(self) -> Bnd_Box: ...
    def GetPoints(self) -> Graphic3d_ArrayOfPoints: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetMaterial(self, theMat: Graphic3d_MaterialAspect) -> None: ...
    @overload
    def SetPoints(self, thePoints: Graphic3d_ArrayOfPoints) -> None: ...
    @overload
    def SetPoints(self, theCoords: TColgp_HArray1OfPnt, theColors: Optional[Quantity_HArray1OfColor] = None, theNormals: Optional[TColgp_HArray1OfDir] = None) -> None: ...
    def UnsetColor(self) -> None: ...
    def UnsetMaterial(self) -> None: ...

class AIS_RubberBand(AIS_InteractiveObject):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLineColor: Quantity_Color, theType: Aspect_TypeOfLine, theLineWidth: Optional[float] = 1.0, theIsPolygonClosed: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theLineColor: Quantity_Color, theType: Aspect_TypeOfLine, theFillColor: Quantity_Color, theTransparency: Optional[float] = 1.0, theLineWidth: Optional[float] = 1.0, theIsPolygonClosed: Optional[bool] = True) -> None: ...
    def AddPoint(self, thePoint: Graphic3d_Vec2i) -> None: ...
    def ClearPoints(self) -> None: ...
    def FillColor(self) -> Quantity_Color: ...
    def FillTransparency(self) -> float: ...
    def IsFilling(self) -> bool: ...
    def IsPolygonClosed(self) -> bool: ...
    def LineColor(self) -> Quantity_Color: ...
    def LineType(self) -> Aspect_TypeOfLine: ...
    def LineWidth(self) -> float: ...
    def Points(self) -> False: ...
    def RemoveLastPoint(self) -> None: ...
    def SetFillColor(self, theColor: Quantity_Color) -> None: ...
    def SetFillTransparency(self, theValue: float) -> None: ...
    @overload
    def SetFilling(self, theIsFilling: bool) -> None: ...
    @overload
    def SetFilling(self, theColor: Quantity_Color, theTransparency: float) -> None: ...
    def SetLineColor(self, theColor: Quantity_Color) -> None: ...
    def SetLineType(self, theType: Aspect_TypeOfLine) -> None: ...
    def SetLineWidth(self, theWidth: float) -> None: ...
    def SetPolygonClosed(self, theIsPolygonClosed: bool) -> None: ...
    def SetRectangle(self, theMinX: int, theMinY: int, theMaxX: int, theMaxY: int) -> None: ...

class AIS_Shape(AIS_InteractiveObject):
    def __init__(self, shap: TopoDS_Shape) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def AcceptShapeDecomposition(self) -> bool: ...
    def BoundingBox(self) -> Bnd_Box: ...
    def Color(self, aColor: Quantity_Color) -> None: ...
    def DumpJson(self, depth: Optional[int]=-1) -> str: ...
    def Material(self) -> Graphic3d_NameOfMaterial: ...
    def OwnDeviationAngle(self) -> Tuple[bool, float, float]: ...
    def OwnDeviationCoefficient(self) -> Tuple[bool, float, float]: ...
    @staticmethod
    def SelectionMode(theShapeType: TopAbs_ShapeEnum) -> int: ...
    @staticmethod
    def SelectionType(theSelMode: int) -> TopAbs_ShapeEnum: ...
    def Set(self, theShape: TopoDS_Shape) -> None: ...
    def SetAngleAndDeviation(self, anAngle: float) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetMaterial(self, aName: Graphic3d_MaterialAspect) -> None: ...
    @overload
    def SetOwnDeviationAngle(self) -> bool: ...
    @overload
    def SetOwnDeviationAngle(self, anAngle: float) -> None: ...
    @overload
    def SetOwnDeviationCoefficient(self) -> bool: ...
    @overload
    def SetOwnDeviationCoefficient(self, aCoefficient: float) -> None: ...
    def SetShape(self, theShape: TopoDS_Shape) -> None: ...
    def SetTextureOriginUV(self, theOriginUV: gp_Pnt2d) -> None: ...
    def SetTextureRepeatUV(self, theRepeatUV: gp_Pnt2d) -> None: ...
    def SetTextureScaleUV(self, theScaleUV: gp_Pnt2d) -> None: ...
    def SetTransparency(self, aValue: Optional[float] = 0.6) -> None: ...
    def SetTypeOfHLR(self, theTypeOfHLR: Prs3d_TypeOfHLR) -> None: ...
    def SetWidth(self, aValue: float) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...
    def Signature(self) -> int: ...
    def TextureOriginUV(self) -> gp_Pnt2d: ...
    def TextureRepeatUV(self) -> gp_Pnt2d: ...
    def TextureScaleUV(self) -> gp_Pnt2d: ...
    def Transparency(self) -> float: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def TypeOfHLR(self) -> Prs3d_TypeOfHLR: ...
    def UnsetColor(self) -> None: ...
    def UnsetMaterial(self) -> None: ...
    def UnsetTransparency(self) -> None: ...
    def UnsetWidth(self) -> None: ...
    def UserAngle(self) -> float: ...
    @staticmethod
    def computeHlrPresentation(theProjector: Graphic3d_Camera, thePrs: Prs3d_Presentation, theShape: TopoDS_Shape, theDrawer: Prs3d_Drawer) -> None: ...

class AIS_SignatureFilter(AIS_TypeFilter):
    def __init__(self, aGivenKind: AIS_KindOfInteractive, aGivenSignature: int) -> None: ...
    def IsOk(self, anobj: SelectMgr_EntityOwner) -> bool: ...

class AIS_TextLabel(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def FontAspect(self) -> False: ...
    def FontName(self) -> str: ...
    def HasFlipping(self) -> bool: ...
    def HasOrientation3D(self) -> bool: ...
    def HasOwnAnchorPoint(self) -> bool: ...
    def Orientation3D(self) -> gp_Ax2: ...
    def Position(self) -> gp_Pnt: ...
    def SetAngle(self, theAngle: float) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetColorSubTitle(self, theColor: Quantity_Color) -> None: ...
    def SetDisplayType(self, theDisplayType: Aspect_TypeOfDisplayText) -> None: ...
    def SetFlipping(self, theIsFlipping: bool) -> None: ...
    def SetFont(self, theFont: str) -> None: ...
    def SetHJustification(self, theHJust: Graphic3d_HorizontalTextAlignment) -> None: ...
    def SetHeight(self, theHeight: float) -> None: ...
    def SetOrientation3D(self, theOrientation: gp_Ax2) -> None: ...
    def SetOwnAnchorPoint(self, theOwnAnchorPoint: bool) -> None: ...
    def SetPosition(self, thePosition: gp_Pnt) -> None: ...
    def SetText(self, theText: str) -> None: ...
    def SetTransparency(self, theValue: float) -> None: ...
    def SetVJustification(self, theVJust: Graphic3d_VerticalTextAlignment) -> None: ...
    def SetZoomable(self, theIsZoomable: bool) -> None: ...
    def Text(self) -> str: ...
    def TextFormatter(self) -> False: ...
    def UnsetOrientation3D(self) -> None: ...
    def UnsetTransparency(self) -> None: ...

class AIS_Triangulation(AIS_InteractiveObject):
    def __init__(self, aTriangulation: Poly_Triangulation) -> None: ...
    def GetColors(self) -> TColStd_HArray1OfInteger: ...
    def GetTriangulation(self) -> Poly_Triangulation: ...
    def HasVertexColors(self) -> bool: ...
    def SetColors(self, aColor: TColStd_HArray1OfInteger) -> None: ...
    def SetTransparency(self, aValue: Optional[float] = 0.6) -> None: ...
    def SetTriangulation(self, aTriangulation: Poly_Triangulation) -> None: ...
    def UnsetTransparency(self) -> None: ...

class AIS_Trihedron(AIS_InteractiveObject):
    def __init__(self, theComponent: Geom_Axis2Placement) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def ArrowColor(self) -> Quantity_Color: ...
    def ClearSelected(self) -> None: ...
    def Component(self) -> Geom_Axis2Placement: ...
    def DatumDisplayMode(self) -> Prs3d_DatumMode: ...
    def DatumPartColor(self, thePart: Prs3d_DatumParts) -> Quantity_Color: ...
    def HasArrowColor(self) -> bool: ...
    def HasOwnSize(self) -> bool: ...
    def HasTextColor(self) -> bool: ...
    def HilightOwnerWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theOwner: SelectMgr_EntityOwner) -> None: ...
    def HilightSelected(self, thePM: PrsMgr_PresentationManager, theOwners: SelectMgr_SequenceOfOwner) -> None: ...
    def Label(self, thePart: Prs3d_DatumParts) -> str: ...
    def SelectionPriority(self, thePart: Prs3d_DatumParts) -> int: ...
    @overload
    def SetArrowColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetArrowColor(self, thePart: Prs3d_DatumParts, theColor: Quantity_Color) -> None: ...
    def SetAxisColor(self, theColor: Quantity_Color) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetComponent(self, theComponent: Geom_Axis2Placement) -> None: ...
    def SetDatumDisplayMode(self, theMode: Prs3d_DatumMode) -> None: ...
    def SetDatumPartColor(self, thePart: Prs3d_DatumParts, theColor: Quantity_Color) -> None: ...
    def SetDrawArrows(self, theToDraw: bool) -> None: ...
    def SetLabel(self, thePart: Prs3d_DatumParts, theName: str) -> None: ...
    def SetOriginColor(self, theColor: Quantity_Color) -> None: ...
    def SetSelectionPriority(self, thePart: Prs3d_DatumParts, thePriority: int) -> None: ...
    def SetSize(self, theValue: float) -> None: ...
    @overload
    def SetTextColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetTextColor(self, thePart: Prs3d_DatumParts, theColor: Quantity_Color) -> None: ...
    def SetXAxisColor(self, theColor: Quantity_Color) -> None: ...
    def SetYAxisColor(self, theColor: Quantity_Color) -> None: ...
    def Signature(self) -> int: ...
    def Size(self) -> float: ...
    def TextColor(self) -> Quantity_Color: ...
    def ToDrawArrows(self) -> bool: ...
    def Type(self) -> AIS_KindOfInteractive: ...
    def UnsetColor(self) -> None: ...
    def UnsetSize(self) -> None: ...

class AIS_ViewCube(AIS_InteractiveObject):
    def __init__(self) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def AxesConeRadius(self) -> float: ...
    def AxesPadding(self) -> float: ...
    def AxesRadius(self) -> float: ...
    def AxesSphereRadius(self) -> float: ...
    def AxisLabel(self, theAxis: Prs3d_DatumParts) -> str: ...
    def BoxColor(self) -> Quantity_Color: ...
    def BoxCornerMinSize(self) -> float: ...
    def BoxCornerStyle(self) -> Prs3d_ShadingAspect: ...
    def BoxEdgeGap(self) -> float: ...
    def BoxEdgeMinSize(self) -> float: ...
    def BoxEdgeStyle(self) -> Prs3d_ShadingAspect: ...
    def BoxFacetExtension(self) -> float: ...
    def BoxSideLabel(self, theSide: V3d_TypeOfOrientation) -> str: ...
    def BoxSideStyle(self) -> Prs3d_ShadingAspect: ...
    def BoxTransparency(self) -> float: ...
    def ClearSelected(self) -> None: ...
    def Compute(self, thePrsMgr: PrsMgr_PresentationManager, thePrs: Prs3d_Presentation, theMode: Optional[int] = 0) -> None: ...
    def ComputeSelection(self, theSelection: SelectMgr_Selection, theMode: int) -> None: ...
    def Duration(self) -> float: ...
    def Font(self) -> str: ...
    def FontHeight(self) -> float: ...
    def GlobalSelOwner(self) -> SelectMgr_EntityOwner: ...
    def HandleClick(self, theOwner: AIS_ViewCubeOwner) -> None: ...
    def HasAnimation(self) -> bool: ...
    def HilightOwnerWithColor(self, thePM: PrsMgr_PresentationManager, theStyle: Prs3d_Drawer, theOwner: SelectMgr_EntityOwner) -> None: ...
    def HilightSelected(self, thePM: PrsMgr_PresentationManager, theSeq: SelectMgr_SequenceOfOwner) -> None: ...
    def InnerColor(self) -> Quantity_Color: ...
    def IsAutoHilight(self) -> bool: ...
    @staticmethod
    def IsBoxCorner(theOrient: V3d_TypeOfOrientation) -> bool: ...
    @staticmethod
    def IsBoxEdge(theOrient: V3d_TypeOfOrientation) -> bool: ...
    @staticmethod
    def IsBoxSide(theOrient: V3d_TypeOfOrientation) -> bool: ...
    def IsFixedAnimationLoop(self) -> bool: ...
    def IsYup(self) -> bool: ...
    def ResetStyles(self) -> None: ...
    def RoundRadius(self) -> float: ...
    def SetAutoStartAnimation(self, theToEnable: bool) -> None: ...
    def SetAxesConeRadius(self, theRadius: float) -> None: ...
    def SetAxesLabels(self, theX: str, theY: str, theZ: str) -> None: ...
    def SetAxesPadding(self, theValue: float) -> None: ...
    def SetAxesRadius(self, theRadius: float) -> None: ...
    def SetAxesSphereRadius(self, theRadius: float) -> None: ...
    def SetBoxColor(self, theColor: Quantity_Color) -> None: ...
    def SetBoxCornerMinSize(self, theValue: float) -> None: ...
    def SetBoxEdgeGap(self, theValue: float) -> None: ...
    def SetBoxEdgeMinSize(self, theValue: float) -> None: ...
    def SetBoxFacetExtension(self, theValue: float) -> None: ...
    def SetBoxSideLabel(self, theSide: V3d_TypeOfOrientation, theLabel: str) -> None: ...
    def SetBoxTransparency(self, theValue: float) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetDrawAxes(self, theValue: bool) -> None: ...
    def SetDrawEdges(self, theValue: bool) -> None: ...
    def SetDrawVertices(self, theValue: bool) -> None: ...
    def SetDuration(self, theValue: float) -> None: ...
    def SetFitSelected(self, theToFitSelected: bool) -> None: ...
    def SetFixedAnimationLoop(self, theToEnable: bool) -> None: ...
    def SetFont(self, theFont: str) -> None: ...
    def SetFontHeight(self, theValue: float) -> None: ...
    def SetInnerColor(self, theColor: Quantity_Color) -> None: ...
    def SetMaterial(self, theMat: Graphic3d_MaterialAspect) -> None: ...
    def SetResetCamera(self, theToReset: bool) -> None: ...
    def SetRoundRadius(self, theValue: float) -> None: ...
    def SetSize(self, theValue: float, theToAdaptAnother: Optional[bool] = true) -> None: ...
    def SetTextColor(self, theColor: Quantity_Color) -> None: ...
    def SetTransparency(self, theValue: float) -> None: ...
    def SetViewAnimation(self, theAnimation: AIS_AnimationCamera) -> None: ...
    def SetYup(self, theIsYup: bool, theToUpdateLabels: Optional[bool] = True) -> None: ...
    def Size(self) -> float: ...
    def StartAnimation(self, theOwner: AIS_ViewCubeOwner) -> None: ...
    def TextColor(self) -> Quantity_Color: ...
    def ToAutoStartAnimation(self) -> bool: ...
    def ToDrawAxes(self) -> bool: ...
    def ToDrawEdges(self) -> bool: ...
    def ToDrawVertices(self) -> bool: ...
    def ToFitSelected(self) -> bool: ...
    def ToResetCameraUp(self) -> bool: ...
    def UnsetAttributes(self) -> None: ...
    def UnsetColor(self) -> None: ...
    def UnsetHilightAttributes(self) -> None: ...
    def UnsetMaterial(self) -> None: ...
    def UnsetTransparency(self) -> None: ...
    def UpdateAnimation(self, theToUpdate: bool) -> bool: ...
    def ViewAnimation(self) -> AIS_AnimationCamera: ...

class AIS_XRTrackedDevice(AIS_InteractiveObject):
    @overload
    def __init__(self, theTris: Graphic3d_ArrayOfTriangles, theTexture: Image_Texture) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def LaserColor(self) -> Quantity_Color: ...
    def LaserLength(self) -> float: ...
    def Role(self) -> Aspect_XRTrackedDeviceRole: ...
    def SetLaserColor(self, theColor: Quantity_Color) -> None: ...
    def SetLaserLength(self, theLength: float) -> None: ...
    def SetRole(self, theRole: Aspect_XRTrackedDeviceRole) -> None: ...
    def SetUnitFactor(self, theFactor: float) -> None: ...
    def UnitFactor(self) -> float: ...

class AIS_AnimationAxisRotation(AIS_BaseAnimationObject):
    def __init__(self, theAnimationName: str, theContext: AIS_InteractiveContext, theObject: AIS_InteractiveObject, theAxis: gp_Ax1, theAngleStart: float, theAngleEnd: float) -> None: ...

class AIS_AnimationObject(AIS_BaseAnimationObject):
    def __init__(self, theAnimationName: str, theContext: AIS_InteractiveContext, theObject: AIS_InteractiveObject, theTrsfStart: gp_Trsf, theTrsfEnd: gp_Trsf) -> None: ...

class AIS_ColoredShape(AIS_Shape):
    @overload
    def __init__(self, theShape: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, theShape: AIS_Shape) -> None: ...
    def ChangeCustomAspectsMap(self) -> AIS_DataMapOfShapeDrawer: ...
    def ClearCustomAspects(self) -> None: ...
    def CustomAspects(self, theShape: TopoDS_Shape) -> AIS_ColoredDrawer: ...
    def CustomAspectsMap(self) -> AIS_DataMapOfShapeDrawer: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetCustomColor(self, theShape: TopoDS_Shape, theColor: Quantity_Color) -> None: ...
    def SetCustomTransparency(self, theShape: TopoDS_Shape, theTransparency: float) -> None: ...
    def SetCustomWidth(self, theShape: TopoDS_Shape, theLineWidth: float) -> None: ...
    def SetMaterial(self, theAspect: Graphic3d_MaterialAspect) -> None: ...
    def SetTransparency(self, theValue: float) -> None: ...
    def SetWidth(self, theLineWidth: float) -> None: ...
    def UnsetCustomAspects(self, theShape: TopoDS_Shape, theToUnregister: Optional[bool] = False) -> None: ...
    def UnsetTransparency(self) -> None: ...
    def UnsetWidth(self) -> None: ...

class AIS_TexturedShape(AIS_Shape):
    def __init__(self, theShape: TopoDS_Shape) -> None: ...
    def AcceptDisplayMode(self, theMode: int) -> bool: ...
    def DisableTextureModulate(self) -> None: ...
    def EnableTextureModulate(self) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetMaterial(self, theAspect: Graphic3d_MaterialAspect) -> None: ...
    def SetTextureFileName(self, theTextureFileName: str) -> None: ...
    def SetTextureMapOff(self) -> None: ...
    def SetTextureMapOn(self) -> None: ...
    def SetTextureOrigin(self, theToSetTextureOrigin: bool, theUOrigin: Optional[float] = 0.0, theVOrigin: Optional[float] = 0.0) -> None: ...
    def SetTexturePixMap(self, theTexturePixMap: Image_PixMap) -> None: ...
    def SetTextureRepeat(self, theToRepeat: bool, theURepeat: Optional[float] = 1.0, theVRepeat: Optional[float] = 1.0) -> None: ...
    def SetTextureScale(self, theToSetTextureScale: bool, theScaleU: Optional[float] = 1.0, theScaleV: Optional[float] = 1.0) -> None: ...
    def TextureFile(self) -> str: ...
    def TextureMapState(self) -> bool: ...
    def TextureModulate(self) -> bool: ...
    def TextureOrigin(self) -> bool: ...
    def TexturePixMap(self) -> Image_PixMap: ...
    def TextureRepeat(self) -> bool: ...
    def TextureScale(self) -> bool: ...
    def TextureScaleU(self) -> float: ...
    def TextureScaleV(self) -> float: ...
    def TextureUOrigin(self) -> float: ...
    def TextureVOrigin(self) -> float: ...
    def URepeat(self) -> float: ...
    def UnsetColor(self) -> None: ...
    def UnsetMaterial(self) -> None: ...
    def UpdateAttributes(self) -> None: ...
    def VRepeat(self) -> float: ...

# harray1 classes
# harray2 classes
# hsequence classes

