# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Approx module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_approx.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Approx
else:
    import _Approx

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Approx.delete_SwigPyIterator

    def value(self):
        return _Approx.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Approx.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Approx.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Approx.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Approx.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Approx.SwigPyIterator_copy(self)

    def next(self):
        return _Approx.SwigPyIterator_next(self)

    def __next__(self):
        return _Approx.SwigPyIterator___next__(self)

    def previous(self):
        return _Approx.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Approx.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Approx.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Approx.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Approx.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Approx.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Approx.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Approx.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Approx:
_Approx.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Approx.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Approx.ios_base_erase_event
    imbue_event = _Approx.ios_base_imbue_event
    copyfmt_event = _Approx.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Approx.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Approx.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Approx.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Approx.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Approx.ios_base_precision(self, *args)

    def width(self, *args):
        return _Approx.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Approx.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Approx.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Approx.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Approx.ios_base_xalloc()

    def iword(self, __ix):
        return _Approx.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Approx.ios_base_pword(self, __ix)
    __swig_destroy__ = _Approx.delete_ios_base

# Register ios_base in _Approx:
_Approx.ios_base_swigregister(ios_base)
cvar = _Approx.cvar
ios_base.boolalpha = _Approx.cvar.ios_base_boolalpha
ios_base.dec = _Approx.cvar.ios_base_dec
ios_base.fixed = _Approx.cvar.ios_base_fixed
ios_base.hex = _Approx.cvar.ios_base_hex
ios_base.internal = _Approx.cvar.ios_base_internal
ios_base.left = _Approx.cvar.ios_base_left
ios_base.oct = _Approx.cvar.ios_base_oct
ios_base.right = _Approx.cvar.ios_base_right
ios_base.scientific = _Approx.cvar.ios_base_scientific
ios_base.showbase = _Approx.cvar.ios_base_showbase
ios_base.showpoint = _Approx.cvar.ios_base_showpoint
ios_base.showpos = _Approx.cvar.ios_base_showpos
ios_base.skipws = _Approx.cvar.ios_base_skipws
ios_base.unitbuf = _Approx.cvar.ios_base_unitbuf
ios_base.uppercase = _Approx.cvar.ios_base_uppercase
ios_base.adjustfield = _Approx.cvar.ios_base_adjustfield
ios_base.basefield = _Approx.cvar.ios_base_basefield
ios_base.floatfield = _Approx.cvar.ios_base_floatfield
ios_base.badbit = _Approx.cvar.ios_base_badbit
ios_base.eofbit = _Approx.cvar.ios_base_eofbit
ios_base.failbit = _Approx.cvar.ios_base_failbit
ios_base.goodbit = _Approx.cvar.ios_base_goodbit
ios_base.app = _Approx.cvar.ios_base_app
ios_base.ate = _Approx.cvar.ios_base_ate
ios_base.binary = _Approx.cvar.ios_base_binary
ios_base.ios_base_in = _Approx.cvar.ios_base_ios_base_in
ios_base.out = _Approx.cvar.ios_base_out
ios_base.trunc = _Approx.cvar.ios_base_trunc
ios_base.beg = _Approx.cvar.ios_base_beg
ios_base.cur = _Approx.cvar.ios_base_cur
ios_base.end = _Approx.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Approx.ios_rdstate(self)

    def clear(self, *args):
        return _Approx.ios_clear(self, *args)

    def setstate(self, __state):
        return _Approx.ios_setstate(self, __state)

    def good(self):
        return _Approx.ios_good(self)

    def eof(self):
        return _Approx.ios_eof(self)

    def fail(self):
        return _Approx.ios_fail(self)

    def bad(self):
        return _Approx.ios_bad(self)

    def exceptions(self, *args):
        return _Approx.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Approx.ios_swiginit(self, _Approx.new_ios(__sb))
    __swig_destroy__ = _Approx.delete_ios

    def tie(self, *args):
        return _Approx.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Approx.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Approx.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Approx.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Approx.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Approx.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Approx.ios_widen(self, __c)

# Register ios in _Approx:
_Approx.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Approx.ostream_swiginit(self, _Approx.new_ostream(__sb))
    __swig_destroy__ = _Approx.delete_ostream

    def __lshift__(self, *args):
        return _Approx.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Approx.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Approx.ostream_write(self, __s, __n)

    def flush(self):
        return _Approx.ostream_flush(self)

    def tellp(self):
        return _Approx.ostream_tellp(self)

    def seekp(self, *args):
        return _Approx.ostream_seekp(self, *args)

# Register ostream in _Approx:
_Approx.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Approx.istream_swiginit(self, _Approx.new_istream(__sb))
    __swig_destroy__ = _Approx.delete_istream

    def __rshift__(self, *args):
        return _Approx.istream___rshift__(self, *args)

    def gcount(self):
        return _Approx.istream_gcount(self)

    def get(self, *args):
        return _Approx.istream_get(self, *args)

    def getline(self, *args):
        return _Approx.istream_getline(self, *args)

    def ignore(self, *args):
        return _Approx.istream_ignore(self, *args)

    def peek(self):
        return _Approx.istream_peek(self)

    def read(self, __s, __n):
        return _Approx.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Approx.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Approx.istream_putback(self, __c)

    def unget(self):
        return _Approx.istream_unget(self)

    def sync(self):
        return _Approx.istream_sync(self)

    def tellg(self):
        return _Approx.istream_tellg(self)

    def seekg(self, *args):
        return _Approx.istream_seekg(self, *args)

# Register istream in _Approx:
_Approx.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Approx.iostream_swiginit(self, _Approx.new_iostream(__sb))
    __swig_destroy__ = _Approx.delete_iostream

# Register iostream in _Approx:
_Approx.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Approx.endl_cb_ptr
endl = _Approx.endl
ends_cb_ptr = _Approx.ends_cb_ptr
ends = _Approx.ends
flush_cb_ptr = _Approx.flush_cb_ptr
flush = _Approx.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.AppCont
import OCC.Core.AppParCurves

from enum import IntEnum
from OCC.Core.Exception import *

Approx_ChordLength = _Approx.Approx_ChordLength
Approx_Centripetal = _Approx.Approx_Centripetal
Approx_IsoParametric = _Approx.Approx_IsoParametric
Approx_PointsAdded = _Approx.Approx_PointsAdded
Approx_NoPointsAdded = _Approx.Approx_NoPointsAdded
Approx_NoApproximation = _Approx.Approx_NoApproximation


class Approx_ParametrizationType(IntEnum):
	Approx_ChordLength = 0
	Approx_Centripetal = 1
	Approx_IsoParametric = 2
Approx_ChordLength = Approx_ParametrizationType.Approx_ChordLength
Approx_Centripetal = Approx_ParametrizationType.Approx_Centripetal
Approx_IsoParametric = Approx_ParametrizationType.Approx_IsoParametric

class Approx_Status(IntEnum):
	Approx_PointsAdded = 0
	Approx_NoPointsAdded = 1
	Approx_NoApproximation = 2
Approx_PointsAdded = Approx_Status.Approx_PointsAdded
Approx_NoPointsAdded = Approx_Status.Approx_NoPointsAdded
Approx_NoApproximation = Approx_Status.Approx_NoApproximation


def Handle_Approx_CurvlinFunc_Create():
    return _Approx.Handle_Approx_CurvlinFunc_Create()

def Handle_Approx_CurvlinFunc_DownCast(t):
    return _Approx.Handle_Approx_CurvlinFunc_DownCast(t)

def Handle_Approx_CurvlinFunc_IsNull(t):
    return _Approx.Handle_Approx_CurvlinFunc_IsNull(t)

def Handle_Approx_SweepFunction_Create():
    return _Approx.Handle_Approx_SweepFunction_Create()

def Handle_Approx_SweepFunction_DownCast(t):
    return _Approx.Handle_Approx_SweepFunction_DownCast(t)

def Handle_Approx_SweepFunction_IsNull(t):
    return _Approx.Handle_Approx_SweepFunction_IsNull(t)

def Handle_Approx_HArray1OfAdHSurface_Create():
    return _Approx.Handle_Approx_HArray1OfAdHSurface_Create()

def Handle_Approx_HArray1OfAdHSurface_DownCast(t):
    return _Approx.Handle_Approx_HArray1OfAdHSurface_DownCast(t)

def Handle_Approx_HArray1OfAdHSurface_IsNull(t):
    return _Approx.Handle_Approx_HArray1OfAdHSurface_IsNull(t)

def Handle_Approx_HArray1OfGTrsf2d_Create():
    return _Approx.Handle_Approx_HArray1OfGTrsf2d_Create()

def Handle_Approx_HArray1OfGTrsf2d_DownCast(t):
    return _Approx.Handle_Approx_HArray1OfGTrsf2d_DownCast(t)

def Handle_Approx_HArray1OfGTrsf2d_IsNull(t):
    return _Approx.Handle_Approx_HArray1OfGTrsf2d_IsNull(t)
class Approx_Array1OfAdHSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self, *args):
        return _Approx.Approx_Array1OfAdHSurface_begin(self, *args)

    def cbegin(self):
        return _Approx.Approx_Array1OfAdHSurface_cbegin(self)

    def end(self, *args):
        return _Approx.Approx_Array1OfAdHSurface_end(self, *args)

    def cend(self):
        return _Approx.Approx_Array1OfAdHSurface_cend(self)

    def __init__(self, *args):
        _Approx.Approx_Array1OfAdHSurface_swiginit(self, _Approx.new_Approx_Array1OfAdHSurface(*args))
    __swig_destroy__ = _Approx.delete_Approx_Array1OfAdHSurface

    def Init(self, theValue):
        return _Approx.Approx_Array1OfAdHSurface_Init(self, theValue)

    def Size(self):
        return _Approx.Approx_Array1OfAdHSurface_Size(self)

    def Length(self):
        return _Approx.Approx_Array1OfAdHSurface_Length(self)

    def IsEmpty(self):
        return _Approx.Approx_Array1OfAdHSurface_IsEmpty(self)

    def Lower(self):
        return _Approx.Approx_Array1OfAdHSurface_Lower(self)

    def Upper(self):
        return _Approx.Approx_Array1OfAdHSurface_Upper(self)

    def Assign(self, theOther):
        return _Approx.Approx_Array1OfAdHSurface_Assign(self, theOther)

    def Move(self, *args):
        return _Approx.Approx_Array1OfAdHSurface_Move(self, *args)

    def Set(self, *args):
        return _Approx.Approx_Array1OfAdHSurface_Set(self, *args)

    def First(self):
        return _Approx.Approx_Array1OfAdHSurface_First(self)

    def ChangeFirst(self):
        return _Approx.Approx_Array1OfAdHSurface_ChangeFirst(self)

    def Last(self):
        return _Approx.Approx_Array1OfAdHSurface_Last(self)

    def ChangeLast(self):
        return _Approx.Approx_Array1OfAdHSurface_ChangeLast(self)

    def Value(self, theIndex):
        return _Approx.Approx_Array1OfAdHSurface_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Approx.Approx_Array1OfAdHSurface_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Approx.Approx_Array1OfAdHSurface___call__(self, *args)

    def SetValue(self, *args):
        return _Approx.Approx_Array1OfAdHSurface_SetValue(self, *args)

    def UpdateLowerBound(self, theLower):
        return _Approx.Approx_Array1OfAdHSurface_UpdateLowerBound(self, theLower)

    def UpdateUpperBound(self, theUpper):
        return _Approx.Approx_Array1OfAdHSurface_UpdateUpperBound(self, theUpper)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Approx.Approx_Array1OfAdHSurface_Resize(self, theLower, theUpper, theToCopyData)

    def IsDeletable(self):
        return _Approx.Approx_Array1OfAdHSurface_IsDeletable(self)

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Approx_Array1OfAdHSurface in _Approx:
_Approx.Approx_Array1OfAdHSurface_swigregister(Approx_Array1OfAdHSurface)
class Approx_Array1OfGTrsf2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d_begin(self, *args)

    def cbegin(self):
        return _Approx.Approx_Array1OfGTrsf2d_cbegin(self)

    def end(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d_end(self, *args)

    def cend(self):
        return _Approx.Approx_Array1OfGTrsf2d_cend(self)

    def __init__(self, *args):
        _Approx.Approx_Array1OfGTrsf2d_swiginit(self, _Approx.new_Approx_Array1OfGTrsf2d(*args))
    __swig_destroy__ = _Approx.delete_Approx_Array1OfGTrsf2d

    def Init(self, theValue):
        return _Approx.Approx_Array1OfGTrsf2d_Init(self, theValue)

    def Size(self):
        return _Approx.Approx_Array1OfGTrsf2d_Size(self)

    def Length(self):
        return _Approx.Approx_Array1OfGTrsf2d_Length(self)

    def IsEmpty(self):
        return _Approx.Approx_Array1OfGTrsf2d_IsEmpty(self)

    def Lower(self):
        return _Approx.Approx_Array1OfGTrsf2d_Lower(self)

    def Upper(self):
        return _Approx.Approx_Array1OfGTrsf2d_Upper(self)

    def Assign(self, theOther):
        return _Approx.Approx_Array1OfGTrsf2d_Assign(self, theOther)

    def Move(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d_Move(self, *args)

    def Set(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d_Set(self, *args)

    def First(self):
        return _Approx.Approx_Array1OfGTrsf2d_First(self)

    def ChangeFirst(self):
        return _Approx.Approx_Array1OfGTrsf2d_ChangeFirst(self)

    def Last(self):
        return _Approx.Approx_Array1OfGTrsf2d_Last(self)

    def ChangeLast(self):
        return _Approx.Approx_Array1OfGTrsf2d_ChangeLast(self)

    def Value(self, theIndex):
        return _Approx.Approx_Array1OfGTrsf2d_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Approx.Approx_Array1OfGTrsf2d_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d___call__(self, *args)

    def SetValue(self, *args):
        return _Approx.Approx_Array1OfGTrsf2d_SetValue(self, *args)

    def UpdateLowerBound(self, theLower):
        return _Approx.Approx_Array1OfGTrsf2d_UpdateLowerBound(self, theLower)

    def UpdateUpperBound(self, theUpper):
        return _Approx.Approx_Array1OfGTrsf2d_UpdateUpperBound(self, theUpper)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Approx.Approx_Array1OfGTrsf2d_Resize(self, theLower, theUpper, theToCopyData)

    def IsDeletable(self):
        return _Approx.Approx_Array1OfGTrsf2d_IsDeletable(self)

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Approx_Array1OfGTrsf2d in _Approx:
_Approx.Approx_Array1OfGTrsf2d_swigregister(Approx_Array1OfGTrsf2d)
class Approx_SequenceOfHArray1OfReal(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_begin(self)

    def end(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_end(self)

    def cbegin(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_cbegin(self)

    def cend(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_cend(self)

    def __init__(self, *args):
        _Approx.Approx_SequenceOfHArray1OfReal_swiginit(self, _Approx.new_Approx_SequenceOfHArray1OfReal(*args))

    def Size(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Size(self)

    def Length(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Length(self)

    def Lower(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Lower(self)

    def Upper(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Upper(self)

    def IsEmpty(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_IsEmpty(self)

    def Reverse(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Reverse(self)

    def Exchange(self, I, J):
        return _Approx.Approx_SequenceOfHArray1OfReal_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Approx.Approx_SequenceOfHArray1OfReal_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Approx.Approx_SequenceOfHArray1OfReal_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Approx.Approx_SequenceOfHArray1OfReal_Assign(self, theOther)

    def Set(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_Set(self, *args)

    def Remove(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_Remove(self, *args)

    def Append(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_Append(self, *args)

    def Prepend(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Approx.Approx_SequenceOfHArray1OfReal_Split(self, theIndex, theSeq)

    def First(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_First(self)

    def ChangeFirst(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_ChangeFirst(self)

    def Last(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_Last(self)

    def ChangeLast(self):
        return _Approx.Approx_SequenceOfHArray1OfReal_ChangeLast(self)

    def Value(self, theIndex):
        return _Approx.Approx_SequenceOfHArray1OfReal_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Approx.Approx_SequenceOfHArray1OfReal_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Approx.Approx_SequenceOfHArray1OfReal___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Approx.Approx_SequenceOfHArray1OfReal_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Approx.delete_Approx_SequenceOfHArray1OfReal

    def __len__(self):
        return self.Size()


# Register Approx_SequenceOfHArray1OfReal in _Approx:
_Approx.Approx_SequenceOfHArray1OfReal_swigregister(Approx_SequenceOfHArray1OfReal)
class Approx_Curve2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C2D: Adaptor2d_Curve2d
        First: float
        Last: float
        TolU: float
        TolV: float
        Continuity: GeomAbs_Shape
        MaxDegree: int
        MaxSegments: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Approx.Approx_Curve2d_swiginit(self, _Approx.new_Approx_Curve2d(*args))

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve2d_Curve(self, *args)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve2d_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve2d_IsDone(self, *args)

    def MaxError2dU(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve2d_MaxError2dU(self, *args)

    def MaxError2dV(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve2d_MaxError2dV(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_Curve2d

# Register Approx_Curve2d in _Approx:
_Approx.Approx_Curve2d_swigregister(Approx_Curve2d)
class Approx_Curve3d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        Tol3d: float
        Order: GeomAbs_Shape
        MaxSegments: int
        MaxDegree: int

        Return
        -------
        None

        Description
        -----------
        Approximation of a curve with respect of the required tolerance tol3d.

        """
        _Approx.Approx_Curve3d_swiginit(self, _Approx.new_Approx_Curve3d(*args))

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_Curve3d_Curve(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        o: Standard_OStream

        Description
        -----------
        Print on the stream o information about the object.

        """
        return _Approx.Approx_Curve3d_Dump(self, *args)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the approximation did come out with a result that is not necessarely within the required tolerance.

        """
        return _Approx.Approx_Curve3d_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the approximation has been done within required tolerance.

        """
        return _Approx.Approx_Curve3d_IsDone(self, *args)

    def MaxError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum error (>0 when an approximation has been done, 0 if no approximation).

        """
        return _Approx.Approx_Curve3d_MaxError(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_Curve3d

# Register Approx_Curve3d in _Approx:
_Approx.Approx_Curve3d_swigregister(Approx_Curve3d)
class Approx_CurveOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C2D: Adaptor2d_Curve2d
        Surf: Adaptor3d_Surface
        First: float
        Last: float
        Tol: float
        Continuity: GeomAbs_Shape
        MaxDegree: int
        MaxSegments: int
        Only3d: bool (optional, default to Standard_False)
        Only2d: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        This constructor calls perform method. this constructor is deprecated.

        Parameters
        ----------
        theC2D: Adaptor2d_Curve2d
        theSurf: Adaptor3d_Surface
        theFirst: float
        theLast: float
        theTol: float

        Return
        -------
        None

        Description
        -----------
        This constructor does not call perform method. @param thec2d 2d curve to be approximated in 3d. @param thesurf surface where 2d curve is located. @param thefirst first parameter of resulting curve. @param thefirst last parameter of resulting curve. @param thetol computation tolerance.

        """
        _Approx.Approx_CurveOnSurface_swiginit(self, _Approx.new_Approx_CurveOnSurface(*args))

    def Curve2d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_Curve2d(self, *args)

    def Curve3d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_Curve3d(self, *args)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_IsDone(self, *args)

    def MaxError2dU(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_MaxError2dU(self, *args)

    def MaxError2dV(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum errors relatively to the u component or the v component of the 2d curve.

        """
        return _Approx.Approx_CurveOnSurface_MaxError2dV(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurveOnSurface_MaxError3d(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int
        theMaxDegree: int
        theContinuity: GeomAbs_Shape
        theOnly3d: bool (optional, default to Standard_False)
        theOnly2d: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs the 3d curve. input parameters are ignored when the input curve is u-isoline or v-isoline. @param themaxsegments maximal number of segments in the resulting spline. @param themaxdegree maximal degree of the result. @param thecontinuity resulting continuity. @param theonly3d determines building only 3d curve. @param theonly2d determines building only 2d curve.

        """
        return _Approx.Approx_CurveOnSurface_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_CurveOnSurface

# Register Approx_CurveOnSurface in _Approx:
_Approx.Approx_CurveOnSurface_swigregister(Approx_CurveOnSurface)
class Approx_CurvilinearParameter(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C3D: Adaptor3d_Curve
        Tol: float
        Order: GeomAbs_Shape
        MaxDegree: int
        MaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Case of a free 3d curve.

        Parameters
        ----------
        C2D: Adaptor2d_Curve2d
        Surf: Adaptor3d_Surface
        Tol: float
        Order: GeomAbs_Shape
        MaxDegree: int
        MaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Case of a curve on one surface.

        Parameters
        ----------
        C2D1: Adaptor2d_Curve2d
        Surf1: Adaptor3d_Surface
        C2D2: Adaptor2d_Curve2d
        Surf2: Adaptor3d_Surface
        Tol: float
        Order: GeomAbs_Shape
        MaxDegree: int
        MaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Case of a curve on two surfaces.

        """
        _Approx.Approx_CurvilinearParameter_swiginit(self, _Approx.new_Approx_CurvilinearParameter(*args))

    def Curve2d1(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns the bsplinecurve representing the reparametrized 2d curve on the first surface (case of a curve on one or two surfaces).

        """
        return _Approx.Approx_CurvilinearParameter_Curve2d1(self, *args)

    def Curve2d2(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns the bsplinecurve representing the reparametrized 2d curve on the second surface (case of a curve on two surfaces).

        """
        return _Approx.Approx_CurvilinearParameter_Curve2d2(self, *args)

    def Curve3d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        Returns the bspline curve corresponding to the reparametrized 3d curve.

        """
        return _Approx.Approx_CurvilinearParameter_Curve3d(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        o: Standard_OStream

        Description
        -----------
        Print the maximum errors(s).

        """
        return _Approx.Approx_CurvilinearParameter_Dump(self, *args)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurvilinearParameter_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurvilinearParameter_IsDone(self, *args)

    def MaxError2d1(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum error on the first reparametrized 2d curve.

        """
        return _Approx.Approx_CurvilinearParameter_MaxError2d1(self, *args)

    def MaxError2d2(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum error on the second reparametrized 2d curve.

        """
        return _Approx.Approx_CurvilinearParameter_MaxError2d2(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum error on the reparametrized 3d curve.

        """
        return _Approx.Approx_CurvilinearParameter_MaxError3d(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_CurvilinearParameter

# Register Approx_CurvilinearParameter in _Approx:
_Approx.Approx_CurvilinearParameter_swigregister(Approx_CurvilinearParameter)
class Approx_CurvlinFunc(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        Tol: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C2D: Adaptor2d_Curve2d
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C2D1: Adaptor2d_Curve2d
        C2D2: Adaptor2d_Curve2d
        S1: Adaptor3d_Surface
        S2: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Approx.Approx_CurvlinFunc_swiginit(self, _Approx.new_Approx_CurvlinFunc(*args))

    def EvalCase1(self, *args):
        r"""

        Parameters
        ----------
        S: float
        Order: int
        Result: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        If mycase != 1.

        """
        return _Approx.Approx_CurvlinFunc_EvalCase1(self, *args)

    def EvalCase2(self, *args):
        r"""

        Parameters
        ----------
        S: float
        Order: int
        Result: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        If mycase != 2.

        """
        return _Approx.Approx_CurvlinFunc_EvalCase2(self, *args)

    def EvalCase3(self, *args):
        r"""

        Parameters
        ----------
        S: float
        Order: int
        Result: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        If mycase != 3.

        """
        return _Approx.Approx_CurvlinFunc_EvalCase3(self, *args)

    def FirstParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurvlinFunc_FirstParameter(self, *args)

    def GetLength(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurvlinFunc_GetLength(self, *args)

    def GetSParameter(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        float

        Description
        -----------
        Returns original parameter corresponding s.

        """
        return _Approx.Approx_CurvlinFunc_GetSParameter(self, *args)

    def GetUParameter(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: float
        NumberOfCurve: int

        Return
        -------
        float

        Description
        -----------
        Returns original parameter corresponding s. if case == 1 computation is performed on myc2d1 and mysurf1, otherwise it is done on myc2d2 and mysurf2.

        """
        return _Approx.Approx_CurvlinFunc_GetUParameter(self, *args)

    def Intervals(self, *args):
        r"""

        Parameters
        ----------
        T: TColStd_Array1OfReal
        S: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Stores in <t> the parameters bounding the intervals of continuity <s>. //! the array must provide enough room to accommodate for the parameters. i.e. t.length() > nbintervals().

        """
        return _Approx.Approx_CurvlinFunc_Intervals(self, *args)

    def LastParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_CurvlinFunc_LastParameter(self, *args)

    def Length(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes length of the curve.

        Parameters
        ----------
        C: Adaptor3d_Curve
        FirstU: float
        LasrU: float

        Return
        -------
        float

        Description
        -----------
        Computes length of the curve segment.

        """
        return _Approx.Approx_CurvlinFunc_Length(self, *args)

    def NbIntervals(self, *args):
        r"""

        Parameters
        ----------
        S: GeomAbs_Shape

        Return
        -------
        int

        Description
        -----------
        Returns the number of intervals for continuity <s>. may be one if continuity(me) >= <s>.

        """
        return _Approx.Approx_CurvlinFunc_NbIntervals(self, *args)

    def SetTol(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        ---purpose update the tolerance to used.

        """
        return _Approx.Approx_CurvlinFunc_SetTol(self, *args)

    def Trim(self, *args):
        r"""

        Parameters
        ----------
        First: float
        Last: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        If first < 0 or last > 1.

        """
        return _Approx.Approx_CurvlinFunc_Trim(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Approx_CurvlinFunc_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_CurvlinFunc

# Register Approx_CurvlinFunc in _Approx:
_Approx.Approx_CurvlinFunc_swigregister(Approx_CurvlinFunc)
class Approx_FitAndDivide(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Line: AppCont_Function
        degreemin: int (optional, default to 3)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-5)
        Tolerance2d: float (optional, default to 1.0e-5)
        cutting: bool (optional, default to Standard_False)
        FirstC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)
        LastC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true.

        Parameters
        ----------
        degreemin: int (optional, default to 3)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-05)
        Tolerance2d: float (optional, default to 1.0e-05)
        cutting: bool (optional, default to Standard_False)
        FirstC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)
        LastC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        _Approx.Approx_FitAndDivide_swiginit(self, _Approx.new_Approx_FitAndDivide(*args))

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        tol3d: float
        tol2d: float

        Description
        -----------
        Returns the tolerances 2d and 3d of the <index> multicurve.

        """
        return _Approx.Approx_FitAndDivide_Error(self, *args)

    def IsAllApproximated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if at a moment of the approximation, the status noapproximation has been sent by the user when more points were needed.

        """
        return _Approx.Approx_FitAndDivide_IsAllApproximated(self, *args)

    def IsToleranceReached(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the status nopointsadded has been sent.

        """
        return _Approx.Approx_FitAndDivide_IsToleranceReached(self, *args)

    def NbMultiCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of multicurve doing the approximation of the multiline.

        """
        return _Approx.Approx_FitAndDivide_NbMultiCurves(self, *args)

    def Parameters(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        firstp: float
        lastp: float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_FitAndDivide_Parameters(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Line: AppCont_Function

        Return
        -------
        None

        Description
        -----------
        Runs the algorithm after having initialized the fields.

        """
        return _Approx.Approx_FitAndDivide_Perform(self, *args)

    def SetConstraints(self, *args):
        r"""

        Parameters
        ----------
        FirstC: AppParCurves_Constraint
        LastC: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Changes the constraints of the approximation.

        """
        return _Approx.Approx_FitAndDivide_SetConstraints(self, *args)

    def SetDegrees(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int
        degreemax: int

        Return
        -------
        None

        Description
        -----------
        Changes the degrees of the approximation.

        """
        return _Approx.Approx_FitAndDivide_SetDegrees(self, *args)

    def SetHangChecking(self, *args):
        r"""

        Parameters
        ----------
        theHangChecking: bool

        Return
        -------
        None

        Description
        -----------
        Set value of hang checking flag if this flag = true, possible hang of algorithm is checked and algorithm is forced to stop. by default hang checking is used.

        """
        return _Approx.Approx_FitAndDivide_SetHangChecking(self, *args)

    def SetInvOrder(self, *args):
        r"""

        Parameters
        ----------
        theInvOrder: bool

        Return
        -------
        None

        Description
        -----------
        Set inverse order of degree selection: if theinvordr = true, current degree is chosen by inverse order - from maxdegree to mindegree. by default inverse order is used.

        """
        return _Approx.Approx_FitAndDivide_SetInvOrder(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Changes the max number of segments, which is allowed for cutting.

        """
        return _Approx.Approx_FitAndDivide_SetMaxSegments(self, *args)

    def SetTolerances(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3d: float
        Tolerance2d: float

        Return
        -------
        None

        Description
        -----------
        Changes the tolerances of the approximation.

        """
        return _Approx.Approx_FitAndDivide_SetTolerances(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 1)

        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the approximation multicurve of range <index>.

        """
        return _Approx.Approx_FitAndDivide_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_FitAndDivide

# Register Approx_FitAndDivide in _Approx:
_Approx.Approx_FitAndDivide_swigregister(Approx_FitAndDivide)
class Approx_FitAndDivide2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Line: AppCont_Function
        degreemin: int (optional, default to 3)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-5)
        Tolerance2d: float (optional, default to 1.0e-5)
        cutting: bool (optional, default to Standard_False)
        FirstC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)
        LastC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true.

        Parameters
        ----------
        degreemin: int (optional, default to 3)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-05)
        Tolerance2d: float (optional, default to 1.0e-05)
        cutting: bool (optional, default to Standard_False)
        FirstC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)
        LastC: AppParCurves_Constraint (optional, default to AppParCurves_TangencyPoint)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        _Approx.Approx_FitAndDivide2d_swiginit(self, _Approx.new_Approx_FitAndDivide2d(*args))

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        tol3d: float
        tol2d: float

        Description
        -----------
        Returns the tolerances 2d and 3d of the <index> multicurve.

        """
        return _Approx.Approx_FitAndDivide2d_Error(self, *args)

    def IsAllApproximated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if at a moment of the approximation, the status noapproximation has been sent by the user when more points were needed.

        """
        return _Approx.Approx_FitAndDivide2d_IsAllApproximated(self, *args)

    def IsToleranceReached(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the status nopointsadded has been sent.

        """
        return _Approx.Approx_FitAndDivide2d_IsToleranceReached(self, *args)

    def NbMultiCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of multicurve doing the approximation of the multiline.

        """
        return _Approx.Approx_FitAndDivide2d_NbMultiCurves(self, *args)

    def Parameters(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        firstp: float
        lastp: float

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_FitAndDivide2d_Parameters(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Line: AppCont_Function

        Return
        -------
        None

        Description
        -----------
        Runs the algorithm after having initialized the fields.

        """
        return _Approx.Approx_FitAndDivide2d_Perform(self, *args)

    def SetConstraints(self, *args):
        r"""

        Parameters
        ----------
        FirstC: AppParCurves_Constraint
        LastC: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Changes the constraints of the approximation.

        """
        return _Approx.Approx_FitAndDivide2d_SetConstraints(self, *args)

    def SetDegrees(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int
        degreemax: int

        Return
        -------
        None

        Description
        -----------
        Changes the degrees of the approximation.

        """
        return _Approx.Approx_FitAndDivide2d_SetDegrees(self, *args)

    def SetHangChecking(self, *args):
        r"""

        Parameters
        ----------
        theHangChecking: bool

        Return
        -------
        None

        Description
        -----------
        Set value of hang checking flag if this flag = true, possible hang of algorithm is checked and algorithm is forced to stop. by default hang checking is used.

        """
        return _Approx.Approx_FitAndDivide2d_SetHangChecking(self, *args)

    def SetInvOrder(self, *args):
        r"""

        Parameters
        ----------
        theInvOrder: bool

        Return
        -------
        None

        Description
        -----------
        Set inverse order of degree selection: if theinvordr = true, current degree is chosen by inverse order - from maxdegree to mindegree. by default inverse order is used.

        """
        return _Approx.Approx_FitAndDivide2d_SetInvOrder(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Changes the max number of segments, which is allowed for cutting.

        """
        return _Approx.Approx_FitAndDivide2d_SetMaxSegments(self, *args)

    def SetTolerances(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3d: float
        Tolerance2d: float

        Return
        -------
        None

        Description
        -----------
        Changes the tolerances of the approximation.

        """
        return _Approx.Approx_FitAndDivide2d_SetTolerances(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 1)

        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the approximation multicurve of range <index>.

        """
        return _Approx.Approx_FitAndDivide2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_FitAndDivide2d

# Register Approx_FitAndDivide2d in _Approx:
_Approx.Approx_FitAndDivide2d_swigregister(Approx_FitAndDivide2d)
class Approx_MCurvesToBSpCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Approx.Approx_MCurvesToBSpCurve_swiginit(self, _Approx.new_Approx_MCurvesToBSpCurve(*args))

    def Append(self, *args):
        r"""

        Parameters
        ----------
        MC: AppParCurves_MultiCurve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_MCurvesToBSpCurve_Append(self, *args)

    def ChangeValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Return the composite multicurves as a multibspcurve.

        """
        return _Approx.Approx_MCurvesToBSpCurve_ChangeValue(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        TheSeq: AppParCurves_SequenceOfMultiCurve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_MCurvesToBSpCurve_Perform(self, *args)

    def Reset(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_MCurvesToBSpCurve_Reset(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Return the composite multicurves as a multibspcurve.

        """
        return _Approx.Approx_MCurvesToBSpCurve_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_MCurvesToBSpCurve

# Register Approx_MCurvesToBSpCurve in _Approx:
_Approx.Approx_MCurvesToBSpCurve_swigregister(Approx_MCurvesToBSpCurve)
class Approx_SameParameter(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C3D: Geom_Curve
        C2D: Geom2d_Curve
        S: Geom_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Warning: the c3d and c2d must have the same parametric domain.

        Parameters
        ----------
        C3D: Adaptor3d_Curve
        C2D: Geom2d_Curve
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Warning: the c3d and c2d must have the same parametric domain.

        Parameters
        ----------
        C3D: Adaptor3d_Curve
        C2D: Adaptor2d_Curve2d
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Warning: the c3d and c2d must have the same parametric domain.

        """
        _Approx.Approx_SameParameter_swiginit(self, _Approx.new_Approx_SameParameter(*args))

    def Curve2d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Returns the 2d curve that has the same parameter as the 3d curve once evaluated on the surface up to the specified tolerance.

        """
        return _Approx.Approx_SameParameter_Curve2d(self, *args)

    def Curve3d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Curve>

        Description
        -----------
        Returns the 3d curve that has the same parameter as the 3d curve once evaluated on the surface up to the specified tolerance.

        """
        return _Approx.Approx_SameParameter_Curve3d(self, *args)

    def CurveOnSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_CurveOnSurface>

        Description
        -----------
        Returns the 3d curve on surface that has the same parameter as the 3d curve up to the specified tolerance.

        """
        return _Approx.Approx_SameParameter_CurveOnSurface(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        //!@returns .false. if calculations failed, .true. if calculations succeed.

        """
        return _Approx.Approx_SameParameter_IsDone(self, *args)

    def IsSameParameter(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells whether the original data had already the same parameter up to the tolerance: in that case nothing is done.

        """
        return _Approx.Approx_SameParameter_IsSameParameter(self, *args)

    def TolReached(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        //!@returns tolerance (maximal distance) between 3d curve and curve on surface, generated by 2d curve and surface. .

        """
        return _Approx.Approx_SameParameter_TolReached(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_SameParameter

# Register Approx_SameParameter in _Approx:
_Approx.Approx_SameParameter_swigregister(Approx_SameParameter)
class Approx_SweepApproximation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Func: Approx_SweepFunction

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Approx.Approx_SweepApproximation_swiginit(self, _Approx.new_Approx_SweepApproximation(*args))

    def Average2dError(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the average error of the <index> 2d curve approximation.

        """
        return _Approx.Approx_SweepApproximation_Average2dError(self, *args)

    def AverageErrorOnSurf(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error in the surface approximation.

        """
        return _Approx.Approx_SweepApproximation_AverageErrorOnSurf(self, *args)

    def Curve2d(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        TPoles: TColgp_Array1OfPnt2d
        TKnots: TColStd_Array1OfReal
        TMults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curve2d(self, *args)

    def Curve2dPoles(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        TColgp_Array1OfPnt2d

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curve2dPoles(self, *args)

    def Curves2dDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curves2dDegree(self, *args)

    def Curves2dKnots(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curves2dKnots(self, *args)

    def Curves2dMults(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curves2dMults(self, *args)

    def Curves2dShape(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        Degree: int
        NbPoles: int
        NbKnots: int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Curves2dShape(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        o: Standard_OStream

        Description
        -----------
        Display information on approximation.

        """
        return _Approx.Approx_SweepApproximation_Dump(self, *args)

    def Eval(self, *args):
        r"""

        Parameters
        ----------
        Parameter: float
        DerivativeRequest: int
        First: float
        Last: float

        Return
        -------
        Result: float

        Description
        -----------
        The evaluatorfunction from advapprox;.

        """
        return _Approx.Approx_SweepApproximation_Eval(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns if we have an result.

        """
        return _Approx.Approx_SweepApproximation_IsDone(self, *args)

    def Max2dError(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the maximum error of the <index> 2d curve approximation.

        """
        return _Approx.Approx_SweepApproximation_Max2dError(self, *args)

    def MaxErrorOnSurf(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum error in the surface approximation.

        """
        return _Approx.Approx_SweepApproximation_MaxErrorOnSurf(self, *args)

    def NbCurves2d(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_NbCurves2d(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        First: float
        Last: float
        Tol3d: float
        BoundTol: float
        Tol2d: float
        TolAngular: float
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C0)
        Degmax: int (optional, default to 11)
        Segmax: int (optional, default to 50)

        Return
        -------
        None

        Description
        -----------
        Perform the approximation [first, last]: approx_sweepapproximation.cdl tol3d: tolerance to surface approximation tol2d: tolerance used to perform curve approximation normally the 2d curve are approximated with a tolerance given by the resolution on support surfaces, but if this tolerance is too large tol2d is used. tolangular: tolerance (in radian) to control the angle between tangents on the section law and tangent of iso-v on approximated surface continuity: the continuity in v waiting on the surface degmax: the maximum degree in v required on the surface segmax: the maximum number of span in v required on the surface warning: the continuity ci can be obtained only if ft is ci.

        """
        return _Approx.Approx_SweepApproximation_Perform(self, *args)

    def SurfPoles(self, *args):
        r"""
        Return
        -------
        TColgp_Array2OfPnt

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfPoles(self, *args)

    def SurfShape(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        UDegree: int
        VDegree: int
        NbUPoles: int
        NbVPoles: int
        NbUKnots: int
        NbVKnots: int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfShape(self, *args)

    def SurfUKnots(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfUKnots(self, *args)

    def SurfUMults(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfUMults(self, *args)

    def SurfVKnots(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfVKnots(self, *args)

    def SurfVMults(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfVMults(self, *args)

    def SurfWeights(self, *args):
        r"""
        Return
        -------
        TColStd_Array2OfReal

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_SurfWeights(self, *args)

    def Surface(self, *args):
        r"""

        Parameters
        ----------
        TPoles: TColgp_Array2OfPnt
        TWeights: TColStd_Array2OfReal
        TUKnots: TColStd_Array1OfReal
        TVKnots: TColStd_Array1OfReal
        TUMults: TColStd_Array1OfInteger
        TVMults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_Surface(self, *args)

    def TolCurveOnSurf(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the maximum 3d error of the <index> 2d curve approximation on the surface.

        """
        return _Approx.Approx_SweepApproximation_TolCurveOnSurf(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_UDegree(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Approx.Approx_SweepApproximation_VDegree(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_SweepApproximation

# Register Approx_SweepApproximation in _Approx:
_Approx.Approx_SweepApproximation_swigregister(Approx_SweepApproximation)
class Approx_SweepFunction(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BarycentreOfSurf(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Get the barycentre of surface. an very poor estimation is sufficient. this information is useful to perform well conditioned rational approximation. warning: used only if <self> isrational.

        """
        return _Approx.Approx_SweepFunction_BarycentreOfSurf(self, *args)

    def D0(self, *args):
        r"""

        Parameters
        ----------
        Param: float
        First: float
        Last: float
        Poles: TColgp_Array1OfPnt
        Poles2d: TColgp_Array1OfPnt2d
        Weigths: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        Compute the section for v = param.

        """
        return _Approx.Approx_SweepFunction_D0(self, *args)

    def D1(self, *args):
        r"""

        Parameters
        ----------
        Param: float
        First: float
        Last: float
        Poles: TColgp_Array1OfPnt
        DPoles: TColgp_Array1OfVec
        Poles2d: TColgp_Array1OfPnt2d
        DPoles2d: TColgp_Array1OfVec2d
        Weigths: TColStd_Array1OfReal
        DWeigths: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        Compute the first derivative in v direction of the section for v = param warning: it used only for c1 or c2 approximation.

        """
        return _Approx.Approx_SweepFunction_D1(self, *args)

    def D2(self, *args):
        r"""

        Parameters
        ----------
        Param: float
        First: float
        Last: float
        Poles: TColgp_Array1OfPnt
        DPoles: TColgp_Array1OfVec
        D2Poles: TColgp_Array1OfVec
        Poles2d: TColgp_Array1OfPnt2d
        DPoles2d: TColgp_Array1OfVec2d
        D2Poles2d: TColgp_Array1OfVec2d
        Weigths: TColStd_Array1OfReal
        DWeigths: TColStd_Array1OfReal
        D2Weigths: TColStd_Array1OfReal

        Return
        -------
        bool

        Description
        -----------
        Compute the second derivative in v direction of the section for v = param warning: it used only for c2 approximation.

        """
        return _Approx.Approx_SweepFunction_D2(self, *args)

    def GetMinimalWeight(self, *args):
        r"""

        Parameters
        ----------
        Weigths: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Compute the minimal value of weight for each poles in all sections. this information is useful to control error in rational approximation. warning: used only if <self> isrational.

        """
        return _Approx.Approx_SweepFunction_GetMinimalWeight(self, *args)

    def GetTolerance(self, *args):
        r"""

        Parameters
        ----------
        BoundTol: float
        SurfTol: float
        AngleTol: float
        Tol3d: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the tolerance to reach in approximation to satisfy. boundtol error at the boundary angletol tangent error at the boundary (in radian) surftol error inside the surface.

        """
        return _Approx.Approx_SweepFunction_GetTolerance(self, *args)

    def Intervals(self, *args):
        r"""

        Parameters
        ----------
        T: TColStd_Array1OfReal
        S: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Stores in <t> the parameters bounding the intervals of continuity <s>. //! the array must provide enough room to accommodate for the parameters. i.e. t.length() > nbintervals().

        """
        return _Approx.Approx_SweepFunction_Intervals(self, *args)

    def IsRational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns if the sections are rationnal or not.

        """
        return _Approx.Approx_SweepFunction_IsRational(self, *args)

    def Knots(self, *args):
        r"""

        Parameters
        ----------
        TKnots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Get the knots of the section.

        """
        return _Approx.Approx_SweepFunction_Knots(self, *args)

    def MaximalSection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the length of the greater section. thisinformation is useful to g1's control. warning: with an little value, approximation can be slower.

        """
        return _Approx.Approx_SweepFunction_MaximalSection(self, *args)

    def Mults(self, *args):
        r"""

        Parameters
        ----------
        TMults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Get the multplicities of the section.

        """
        return _Approx.Approx_SweepFunction_Mults(self, *args)

    def Nb2dCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Get the number of 2d curves to approximate.

        """
        return _Approx.Approx_SweepFunction_Nb2dCurves(self, *args)

    def NbIntervals(self, *args):
        r"""

        Parameters
        ----------
        S: GeomAbs_Shape

        Return
        -------
        int

        Description
        -----------
        Returns the number of intervals for continuity <s>. may be one if continuity(me) >= <s>.

        """
        return _Approx.Approx_SweepFunction_NbIntervals(self, *args)

    def Resolution(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Tol: float

        Return
        -------
        TolU: float
        TolV: float

        Description
        -----------
        Returns the resolutions in the sub-space 2d <index> this information is usfull to find an good tolerance in 2d approximation.

        """
        return _Approx.Approx_SweepFunction_Resolution(self, *args)

    def SectionShape(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        NbPoles: int
        NbKnots: int
        Degree: int

        Description
        -----------
        Get the format of an section.

        """
        return _Approx.Approx_SweepFunction_SectionShape(self, *args)

    def SetInterval(self, *args):
        r"""

        Parameters
        ----------
        First: float
        Last: float

        Return
        -------
        None

        Description
        -----------
        Sets the bounds of the parametric interval on the fonction this determines the derivatives in these values if the function is not cn.

        """
        return _Approx.Approx_SweepFunction_SetInterval(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol3d: float
        Tol2d: float

        Return
        -------
        None

        Description
        -----------
        Is useful, if (me) have to run numerical algorithm to perform d0, d1 or d2.

        """
        return _Approx.Approx_SweepFunction_SetTolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Approx_SweepFunction_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Approx.delete_Approx_SweepFunction

# Register Approx_SweepFunction in _Approx:
_Approx.Approx_SweepFunction_swigregister(Approx_SweepFunction)
class Approx_HArray1OfAdHSurface(Approx_Array1OfAdHSurface, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Approx.Approx_HArray1OfAdHSurface_swiginit(self, _Approx.new_Approx_HArray1OfAdHSurface(*args))

    def Array1(self):
        return _Approx.Approx_HArray1OfAdHSurface_Array1(self)

    def ChangeArray1(self):
        return _Approx.Approx_HArray1OfAdHSurface_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Approx_HArray1OfAdHSurface_DownCast(t)

    __swig_destroy__ = _Approx.delete_Approx_HArray1OfAdHSurface

# Register Approx_HArray1OfAdHSurface in _Approx:
_Approx.Approx_HArray1OfAdHSurface_swigregister(Approx_HArray1OfAdHSurface)
class Approx_HArray1OfGTrsf2d(Approx_Array1OfGTrsf2d, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Approx.Approx_HArray1OfGTrsf2d_swiginit(self, _Approx.new_Approx_HArray1OfGTrsf2d(*args))

    def Array1(self):
        return _Approx.Approx_HArray1OfGTrsf2d_Array1(self)

    def ChangeArray1(self):
        return _Approx.Approx_HArray1OfGTrsf2d_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Approx_HArray1OfGTrsf2d_DownCast(t)

    __swig_destroy__ = _Approx.delete_Approx_HArray1OfGTrsf2d

# Register Approx_HArray1OfGTrsf2d in _Approx:
_Approx.Approx_HArray1OfGTrsf2d_swigregister(Approx_HArray1OfGTrsf2d)



