# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Convert module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_convert.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Convert
else:
    import _Convert

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Convert.delete_SwigPyIterator

    def value(self):
        return _Convert.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Convert.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Convert.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Convert.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Convert.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Convert.SwigPyIterator_copy(self)

    def next(self):
        return _Convert.SwigPyIterator_next(self)

    def __next__(self):
        return _Convert.SwigPyIterator___next__(self)

    def previous(self):
        return _Convert.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Convert.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Convert.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Convert.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Convert.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Convert.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Convert.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Convert.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Convert:
_Convert.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Convert.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Convert.ios_base_erase_event
    imbue_event = _Convert.ios_base_imbue_event
    copyfmt_event = _Convert.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Convert.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Convert.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Convert.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Convert.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Convert.ios_base_precision(self, *args)

    def width(self, *args):
        return _Convert.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Convert.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Convert.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Convert.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Convert.ios_base_xalloc()

    def iword(self, __ix):
        return _Convert.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Convert.ios_base_pword(self, __ix)
    __swig_destroy__ = _Convert.delete_ios_base

# Register ios_base in _Convert:
_Convert.ios_base_swigregister(ios_base)
cvar = _Convert.cvar
ios_base.boolalpha = _Convert.cvar.ios_base_boolalpha
ios_base.dec = _Convert.cvar.ios_base_dec
ios_base.fixed = _Convert.cvar.ios_base_fixed
ios_base.hex = _Convert.cvar.ios_base_hex
ios_base.internal = _Convert.cvar.ios_base_internal
ios_base.left = _Convert.cvar.ios_base_left
ios_base.oct = _Convert.cvar.ios_base_oct
ios_base.right = _Convert.cvar.ios_base_right
ios_base.scientific = _Convert.cvar.ios_base_scientific
ios_base.showbase = _Convert.cvar.ios_base_showbase
ios_base.showpoint = _Convert.cvar.ios_base_showpoint
ios_base.showpos = _Convert.cvar.ios_base_showpos
ios_base.skipws = _Convert.cvar.ios_base_skipws
ios_base.unitbuf = _Convert.cvar.ios_base_unitbuf
ios_base.uppercase = _Convert.cvar.ios_base_uppercase
ios_base.adjustfield = _Convert.cvar.ios_base_adjustfield
ios_base.basefield = _Convert.cvar.ios_base_basefield
ios_base.floatfield = _Convert.cvar.ios_base_floatfield
ios_base.badbit = _Convert.cvar.ios_base_badbit
ios_base.eofbit = _Convert.cvar.ios_base_eofbit
ios_base.failbit = _Convert.cvar.ios_base_failbit
ios_base.goodbit = _Convert.cvar.ios_base_goodbit
ios_base.app = _Convert.cvar.ios_base_app
ios_base.ate = _Convert.cvar.ios_base_ate
ios_base.binary = _Convert.cvar.ios_base_binary
ios_base.ios_base_in = _Convert.cvar.ios_base_ios_base_in
ios_base.out = _Convert.cvar.ios_base_out
ios_base.trunc = _Convert.cvar.ios_base_trunc
ios_base.beg = _Convert.cvar.ios_base_beg
ios_base.cur = _Convert.cvar.ios_base_cur
ios_base.end = _Convert.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Convert.ios_rdstate(self)

    def clear(self, *args):
        return _Convert.ios_clear(self, *args)

    def setstate(self, __state):
        return _Convert.ios_setstate(self, __state)

    def good(self):
        return _Convert.ios_good(self)

    def eof(self):
        return _Convert.ios_eof(self)

    def fail(self):
        return _Convert.ios_fail(self)

    def bad(self):
        return _Convert.ios_bad(self)

    def exceptions(self, *args):
        return _Convert.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Convert.ios_swiginit(self, _Convert.new_ios(__sb))
    __swig_destroy__ = _Convert.delete_ios

    def tie(self, *args):
        return _Convert.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Convert.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Convert.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Convert.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Convert.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Convert.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Convert.ios_widen(self, __c)

# Register ios in _Convert:
_Convert.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Convert.ostream_swiginit(self, _Convert.new_ostream(__sb))
    __swig_destroy__ = _Convert.delete_ostream

    def __lshift__(self, *args):
        return _Convert.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Convert.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Convert.ostream_write(self, __s, __n)

    def flush(self):
        return _Convert.ostream_flush(self)

    def tellp(self):
        return _Convert.ostream_tellp(self)

    def seekp(self, *args):
        return _Convert.ostream_seekp(self, *args)

# Register ostream in _Convert:
_Convert.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Convert.istream_swiginit(self, _Convert.new_istream(__sb))
    __swig_destroy__ = _Convert.delete_istream

    def __rshift__(self, *args):
        return _Convert.istream___rshift__(self, *args)

    def gcount(self):
        return _Convert.istream_gcount(self)

    def get(self, *args):
        return _Convert.istream_get(self, *args)

    def getline(self, *args):
        return _Convert.istream_getline(self, *args)

    def ignore(self, *args):
        return _Convert.istream_ignore(self, *args)

    def peek(self):
        return _Convert.istream_peek(self)

    def read(self, __s, __n):
        return _Convert.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Convert.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Convert.istream_putback(self, __c)

    def unget(self):
        return _Convert.istream_unget(self)

    def sync(self):
        return _Convert.istream_sync(self)

    def tellg(self):
        return _Convert.istream_tellg(self)

    def seekg(self, *args):
        return _Convert.istream_seekg(self, *args)

# Register istream in _Convert:
_Convert.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Convert.iostream_swiginit(self, _Convert.new_iostream(__sb))
    __swig_destroy__ = _Convert.delete_iostream

# Register iostream in _Convert:
_Convert.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Convert.endl_cb_ptr
endl = _Convert.endl
ends_cb_ptr = _Convert.ends_cb_ptr
ends = _Convert.ends
flush_cb_ptr = _Convert.flush_cb_ptr
flush = _Convert.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColgp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *

Convert_TgtThetaOver2 = _Convert.Convert_TgtThetaOver2
Convert_TgtThetaOver2_1 = _Convert.Convert_TgtThetaOver2_1
Convert_TgtThetaOver2_2 = _Convert.Convert_TgtThetaOver2_2
Convert_TgtThetaOver2_3 = _Convert.Convert_TgtThetaOver2_3
Convert_TgtThetaOver2_4 = _Convert.Convert_TgtThetaOver2_4
Convert_QuasiAngular = _Convert.Convert_QuasiAngular
Convert_RationalC1 = _Convert.Convert_RationalC1
Convert_Polynomial = _Convert.Convert_Polynomial


class Convert_ParameterisationType(IntEnum):
	Convert_TgtThetaOver2 = 0
	Convert_TgtThetaOver2_1 = 1
	Convert_TgtThetaOver2_2 = 2
	Convert_TgtThetaOver2_3 = 3
	Convert_TgtThetaOver2_4 = 4
	Convert_QuasiAngular = 5
	Convert_RationalC1 = 6
	Convert_Polynomial = 7
Convert_TgtThetaOver2 = Convert_ParameterisationType.Convert_TgtThetaOver2
Convert_TgtThetaOver2_1 = Convert_ParameterisationType.Convert_TgtThetaOver2_1
Convert_TgtThetaOver2_2 = Convert_ParameterisationType.Convert_TgtThetaOver2_2
Convert_TgtThetaOver2_3 = Convert_ParameterisationType.Convert_TgtThetaOver2_3
Convert_TgtThetaOver2_4 = Convert_ParameterisationType.Convert_TgtThetaOver2_4
Convert_QuasiAngular = Convert_ParameterisationType.Convert_QuasiAngular
Convert_RationalC1 = Convert_ParameterisationType.Convert_RationalC1
Convert_Polynomial = Convert_ParameterisationType.Convert_Polynomial

class Convert_SequenceOfArray1OfPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_begin(self)

    def end(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_end(self)

    def cbegin(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_cbegin(self)

    def cend(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_cend(self)

    def __init__(self, *args):
        _Convert.Convert_SequenceOfArray1OfPoles_swiginit(self, _Convert.new_Convert_SequenceOfArray1OfPoles(*args))

    def Size(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Size(self)

    def Length(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Length(self)

    def Lower(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Lower(self)

    def Upper(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Upper(self)

    def IsEmpty(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_IsEmpty(self)

    def Reverse(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Reverse(self)

    def Exchange(self, I, J):
        return _Convert.Convert_SequenceOfArray1OfPoles_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Convert.Convert_SequenceOfArray1OfPoles_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Convert.Convert_SequenceOfArray1OfPoles_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Convert.Convert_SequenceOfArray1OfPoles_Assign(self, theOther)

    def Set(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_Set(self, *args)

    def Remove(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_Remove(self, *args)

    def Append(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_Append(self, *args)

    def Prepend(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Convert.Convert_SequenceOfArray1OfPoles_Split(self, theIndex, theSeq)

    def First(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_First(self)

    def ChangeFirst(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeFirst(self)

    def Last(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_Last(self)

    def ChangeLast(self):
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeLast(self)

    def Value(self, theIndex):
        return _Convert.Convert_SequenceOfArray1OfPoles_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Convert.Convert_SequenceOfArray1OfPoles___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Convert.Convert_SequenceOfArray1OfPoles_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Convert.delete_Convert_SequenceOfArray1OfPoles

    def __len__(self):
        return self.Size()


# Register Convert_SequenceOfArray1OfPoles in _Convert:
_Convert.Convert_SequenceOfArray1OfPoles_swigregister(Convert_SequenceOfArray1OfPoles)
class Convert_CompBezierCurves2dToBSplineCurve2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        AngularTolerance: float (optional, default to 1.0e-4)

        Return
        -------
        None

        Description
        -----------
        Constructs a framework for converting a sequence of adjacent non-rational bezier curves into a bspline curve. knots will be created on the computed bspline curve at each junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. angulartolerance (given in radians, and defaulted to 1.0 e-4) will be used to check the parallelism of the two tangent vectors. use the following functions: - addcurve to define in sequence the adjacent bezier curves to be converted, - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve.

        """
        _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_swiginit(self, _Convert.new_Convert_CompBezierCurves2dToBSplineCurve2d(*args))

    def AddCurve(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Adds the bezier curve defined by the table of poles poles, to the sequence (still contained in this framework) of adjacent bezier curves to be converted into a bspline curve. only polynomial (i.e. non-rational) bezier curves are converted using this framework. if this is not the first call to the function (i.e. if this framework still contains data in its sequence of bezier curves), the degree of continuity of the bspline curve will be increased at the time of computation at the first point of the added bezier curve (i.e. the first point of the poles table). this will be the case if the tangent vector of the curve at this point is parallel to the tangent vector at the end point of the preceding bezier curve in the sequence of bezier curves still contained in this framework. an angular tolerance given at the time of construction of this framework, will be used to check the parallelism of the two tangent vectors. this checking procedure, and all the relative computations will be performed by the function perform. when the sequence of adjacent bezier curves is complete, use the following functions: - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve. warning the sequence of bezier curves treated by this framework is automatically initialized with the first bezier curve when the function is first called. during subsequent use of this function, ensure that the first point of the added bezier curve (i.e. the first point of the poles table) is coincident with the last point of the sequence (i.e. the last point of the preceding bezier curve in the sequence) of bezier curves still contained in this framework. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above, as this condition is not checked either when defining the sequence of bezier curves or at the time of computation.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_AddCurve(self, *args)

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Degree(self, *args)

    def KnotsAndMults(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Loads the knots table with the knots and the mults table with the corresponding multiplicities of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the knots and mults arrays must be equal to the number of knots in the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above as these conditions are not checked, and an error may occur.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_KnotsAndMults(self, *args)

    def NbKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_NbKnots(self, *args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_NbPoles(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to build a bspline curve equivalent to the sequence of adjacent bezier curves still contained in this framework. a knot is inserted on the computed bspline curve at the junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. an angular tolerance given at the time of construction of this framework is used to check the parallelism of the two tangent vectors. use the available consultation functions to access the computed data. this data may then be used to construct the bspline curve. warning ensure that the curves in the sequence of bezier curves contained in this framework are adjacent. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above as this condition is not checked, either when defining the bezier curve sequence or at the time of computation.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Perform(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Loads the poles table with the poles of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the poles array must be equal to the number of poles of the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above, as these conditions are not checked, and an error may occur.

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompBezierCurves2dToBSplineCurve2d

# Register Convert_CompBezierCurves2dToBSplineCurve2d in _Convert:
_Convert.Convert_CompBezierCurves2dToBSplineCurve2d_swigregister(Convert_CompBezierCurves2dToBSplineCurve2d)
class Convert_CompBezierCurvesToBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        AngularTolerance: float (optional, default to 1.0e-4)

        Return
        -------
        None

        Description
        -----------
        Constructs a framework for converting a sequence of adjacent non-rational bezier curves into a bspline curve. knots will be created on the computed bspline curve at each junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. angulartolerance (given in radians, and defaulted to 1.0 e-4) will be used to check the parallelism of the two tangent vectors. use the following functions: - addcurve to define in sequence the adjacent bezier curves to be converted, - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve.

        """
        _Convert.Convert_CompBezierCurvesToBSplineCurve_swiginit(self, _Convert.new_Convert_CompBezierCurvesToBSplineCurve(*args))

    def AddCurve(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Adds the bezier curve defined by the table of poles poles, to the sequence (still contained in this framework) of adjacent bezier curves to be converted into a bspline curve. only polynomial (i.e. non-rational) bezier curves are converted using this framework. if this is not the first call to the function (i.e. if this framework still contains data in its bezier curve sequence), the degree of continuity of the bspline curve will be increased at the time of computation at the first point of the added bezier curve (i.e. the first point of the poles table). this will be the case if the tangent vector of the curve at this point is parallel to the tangent vector at the end point of the preceding bezier curve in the bezier curve sequence still contained in this framework. an angular tolerance given at the time of construction of this framework will be used to check the parallelism of the two tangent vectors. this checking procedure and all related computations will be performed by the perform function. when the adjacent bezier curve sequence is complete, use the following functions: - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve. warning the bezier curve sequence treated by this framework is automatically initialized with the first bezier curve when the function is first called. during subsequent use of this function, ensure that the first point of the added bezier curve (i.e. the first point of the poles table) is coincident with the last point of the bezier curve sequence (i.e. the last point of the preceding bezier curve in the sequence) still contained in this framework. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above, as this condition is not checked either when defining the bezier curve sequence or at the time of computation.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_AddCurve(self, *args)

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Degree(self, *args)

    def KnotsAndMults(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        - loads the knots table with the knots, - and loads the mults table with the corresponding multiplicities of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the knots and mults arrays must be equal to the number of knots in the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above as these conditions are not checked, and an error may occur.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_KnotsAndMults(self, *args)

    def NbKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_NbKnots(self, *args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_NbPoles(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to build a bspline curve equivalent to the adjacent bezier curve sequence still contained in this framework. a knot is inserted on the computed bspline curve at the junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. an angular tolerance given at the time of construction of this framework is used to check the parallelism of the two tangent vectors. use the available consultation functions to access the computed data. this data may then be used to construct the bspline curve. warning make sure that the curves in the bezier curve sequence contained in this framework are adjacent. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above as this condition is not checked, either when defining the bezier curve sequence or at the time of computation.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Perform(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Loads the poles table with the poles of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the poles array must be equal to the number of poles of the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above, as these conditions are not checked, and an error may occur.

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompBezierCurvesToBSplineCurve

# Register Convert_CompBezierCurvesToBSplineCurve in _Convert:
_Convert.Convert_CompBezierCurvesToBSplineCurve_swigregister(Convert_CompBezierCurvesToBSplineCurve)
class Convert_CompPolynomialToPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        NumCurves: int
        Continuity: int
        Dimension: int
        MaxDegree: int
        NumCoeffPerCurve: TColStd_HArray1OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialIntervals: TColStd_HArray2OfReal
        TrueIntervals: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Warning! continuity can be at most the maximum degree of the polynomial functions trueintervals: this is the true parameterisation for the composite curve that is: the curve has mycontinuity if the nth curve is parameterized between mytrueintervals(n) and mytrueintervals(n+1) //! coefficients have to be the implicit 'c form': coefficients[numcurves][maxdegree+1][dimension] //! warning! the numberofcoefficient of an polynome is his degree + 1 example: to convert the linear function f(x) = 2*x + 1 on the domaine [2,5] to bspline with the bound [-1,1]. arguments are: numcurves = 1; continuity = 1; dimension = 1; maxdegree = 1; numcoeffpercurve [1] = {2}; coefficients[2] = {1, 2}; polynomialintervals[1,2] = {{2,5}} trueintervals[2] = {-1, 1}.

        Parameters
        ----------
        NumCurves: int
        Dimension: int
        MaxDegree: int
        Continuity: TColStd_Array1OfInteger
        NumCoeffPerCurve: TColStd_Array1OfInteger
        Coefficients: TColStd_Array1OfReal
        PolynomialIntervals: TColStd_Array2OfReal
        TrueIntervals: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        To convert sevral span with different order of continuity. warning: the length of continuity have to be numcurves-1.

        Parameters
        ----------
        Dimension: int
        MaxDegree: int
        Degree: int
        Coefficients: TColStd_Array1OfReal
        PolynomialIntervals: TColStd_Array1OfReal
        TrueIntervals: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        To convert only one span.

        """
        _Convert.Convert_CompPolynomialToPoles_swiginit(self, _Convert.new_Convert_CompPolynomialToPoles(*args))

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_CompPolynomialToPoles_Degree(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_CompPolynomialToPoles_IsDone(self, *args)

    def Knots(self, *args):
        r"""

        Parameters
        ----------
        K: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Knots of the n-dimensional bspline.

        """
        return _Convert.Convert_CompPolynomialToPoles_Knots(self, *args)

    def Multiplicities(self, *args):
        r"""

        Parameters
        ----------
        M: TColStd_HArray1OfInteger

        Return
        -------
        None

        Description
        -----------
        Multiplicities of the knots in the bspline.

        """
        return _Convert.Convert_CompPolynomialToPoles_Multiplicities(self, *args)

    def NbKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Degree of the n-dimensional bspline.

        """
        return _Convert.Convert_CompPolynomialToPoles_NbKnots(self, *args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Number of poles of the n-dimensional bspline.

        """
        return _Convert.Convert_CompPolynomialToPoles_NbPoles(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColStd_HArray2OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the poles of the n-dimensional bspline in the following format: [1..numpoles][1..dimension].

        """
        return _Convert.Convert_CompPolynomialToPoles_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompPolynomialToPoles

# Register Convert_CompPolynomialToPoles in _Convert:
_Convert.Convert_CompPolynomialToPoles_swigregister(Convert_CompPolynomialToPoles)
class Convert_ConicToBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BuildCosAndSin(self, *args):
        r"""

        Parameters
        ----------
        Parametrisation: Convert_ParameterisationType
        CosNumerator: TColStd_HArray1OfReal
        SinNumerator: TColStd_HArray1OfReal
        Denominator: TColStd_HArray1OfReal
        Knots: TColStd_HArray1OfReal
        Mults: TColStd_HArray1OfInteger

        Return
        -------
        Degree: int

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Parametrisation: Convert_ParameterisationType
        UFirst: float
        ULast: float
        CosNumerator: TColStd_HArray1OfReal
        SinNumerator: TColStd_HArray1OfReal
        Denominator: TColStd_HArray1OfReal
        Knots: TColStd_HArray1OfReal
        Mults: TColStd_HArray1OfInteger

        Return
        -------
        Degree: int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_ConicToBSplineCurve_BuildCosAndSin(self, *args)

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_Degree(self, *args)

    def IsPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the bspline curve whose data is computed in this framework is periodic.

        """
        return _Convert.Convert_ConicToBSplineCurve_IsPeriodic(self, *args)

    def Knot(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the knot of index index to the knots table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the knots table of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_Knot(self, *args)

    def Multiplicity(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity of the knot of index index to the knots table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the knots table of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_Multiplicity(self, *args)

    def NbKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_NbKnots(self, *args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_NbPoles(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the pole of index index to the poles table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the poles table of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_Pole(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight of the pole of index index to the poles table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the poles table of the bspline curve whose data is computed in this framework.

        """
        return _Convert.Convert_ConicToBSplineCurve_Weight(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ConicToBSplineCurve

# Register Convert_ConicToBSplineCurve in _Convert:
_Convert.Convert_ConicToBSplineCurve_swigregister(Convert_ConicToBSplineCurve)
class Convert_ElementarySurfaceToBSplineSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsUPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_IsUPeriodic(self, *args)

    def IsVPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the bspline surface whose data is computed in this framework is periodic in the u or v parametric direction.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_IsVPeriodic(self, *args)

    def NbUKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbUKnots(self, *args)

    def NbUPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbUPoles(self, *args)

    def NbVKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots for the u or v parametric direction of the bspline surface whose data is computed in this framework .

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbVKnots(self, *args)

    def NbVPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles for the u or v parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbVPoles(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the pole of index (uindex,vindex) to the poles table of the bspline surface whose data is computed in this framework. exceptions standard_outofrange if, for the bspline surface whose data is computed in this framework: - uindex is outside the bounds of the poles table in the u parametric direction, or - vindex is outside the bounds of the poles table in the v parametric direction.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_Pole(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UDegree(self, *args)

    def UKnot(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the u-knot of range uindex. raised if uindex < 1 or uindex > nbuknots.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UKnot(self, *args)

    def UMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity of the u-knot of range uindex. raised if uindex < 1 or uindex > nbuknots.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UMultiplicity(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree for the u or v parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VDegree(self, *args)

    def VKnot(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the v-knot of range vindex. raised if vindex < 1 or vindex > nbvknots.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VKnot(self, *args)

    def VMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity of the v-knot of range vindex. raised if vindex < 1 or vindex > nbvknots.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VMultiplicity(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight of the pole of index (uindex,vindex) to the poles table of the bspline surface whose data is computed in this framework. exceptions standard_outofrange if, for the bspline surface whose data is computed in this framework: - uindex is outside the bounds of the poles table in the u parametric direction, or - vindex is outside the bounds of the poles table in the v parametric direction.

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_Weight(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ElementarySurfaceToBSplineSurface

# Register Convert_ElementarySurfaceToBSplineSurface in _Convert:
_Convert.Convert_ElementarySurfaceToBSplineSurface_swigregister(Convert_ElementarySurfaceToBSplineSurface)
class Convert_GridPolynomialToPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        MaxUDegree: int
        MaxVDegree: int
        NumCoeff: TColStd_HArray1OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        To only one polynomial surface. the length of <polynomialuintervals> and <polynomialvintervals> have to be 2. this values defined the parametric domain of the polynomial equation. //! coefficients: the <coefficients> have to be formatted than an 'c array' [maxudegree+1] [maxvdegree+1] [3].

        Parameters
        ----------
        NbUSurfaces: int
        NBVSurfaces: int
        UContinuity: int
        VContinuity: int
        MaxUDegree: int
        MaxVDegree: int
        NumCoeffPerSurface: TColStd_HArray2OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal
        TrueUIntervals: TColStd_HArray1OfReal
        TrueVIntervals: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        To one grid of polynomial surface. warning! continuity in each parametric direction can be at most the maximum degree of the polynomial functions. //! <trueuintervals>, <truevintervals>: this is the true parameterisation for the composite surface //! coefficients: the coefficients have to be formatted than an 'c array' [nbvsurfaces] [nbusurfaces] [maxudegree+1] [maxvdegree+1] [3] raises domainerror if <numcoeffpersurface> is not a [1, nbvsurfaces*nbusurfaces, 1,2] array. if <coefficients> is not a.

        """
        _Convert.Convert_GridPolynomialToPoles_swiginit(self, _Convert.new_Convert_GridPolynomialToPoles(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_IsDone(self, *args)

    def NbUKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_NbUKnots(self, *args)

    def NbUPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_NbUPoles(self, *args)

    def NbVKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_NbVKnots(self, *args)

    def NbVPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_NbVPoles(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        UContinuity: int
        VContinuity: int
        MaxUDegree: int
        MaxVDegree: int
        NumCoeffPerSurface: TColStd_HArray2OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal
        TrueUIntervals: TColStd_HArray1OfReal
        TrueVIntervals: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_Perform(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColgp_HArray2OfPnt>

        Description
        -----------
        Returns the poles of the bspline surface.

        """
        return _Convert.Convert_GridPolynomialToPoles_Poles(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_UDegree(self, *args)

    def UKnots(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Knots in the u direction.

        """
        return _Convert.Convert_GridPolynomialToPoles_UKnots(self, *args)

    def UMultiplicities(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        Description
        -----------
        Multiplicities of the knots in the u direction.

        """
        return _Convert.Convert_GridPolynomialToPoles_UMultiplicities(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Convert.Convert_GridPolynomialToPoles_VDegree(self, *args)

    def VKnots(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Knots in the v direction.

        """
        return _Convert.Convert_GridPolynomialToPoles_VKnots(self, *args)

    def VMultiplicities(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        Description
        -----------
        Multiplicities of the knots in the v direction.

        """
        return _Convert.Convert_GridPolynomialToPoles_VMultiplicities(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_GridPolynomialToPoles

# Register Convert_GridPolynomialToPoles in _Convert:
_Convert.Convert_GridPolynomialToPoles_swigregister(Convert_GridPolynomialToPoles)
class Convert_CircleToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Circ2d
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline curve has the same orientation as the circle c.

        Parameters
        ----------
        C: gp_Circ2d
        U1: float
        U2: float
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        The circle c is limited between the parametric values u1, u2 in radians. u1 and u2 [0.0, 2*pi] . the equivalent b-spline curve is oriented from u1 to u2 and has the same orientation as the circle c. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi.

        """
        _Convert.Convert_CircleToBSplineCurve_swiginit(self, _Convert.new_Convert_CircleToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CircleToBSplineCurve

# Register Convert_CircleToBSplineCurve in _Convert:
_Convert.Convert_CircleToBSplineCurve_swigregister(Convert_CircleToBSplineCurve)
class Convert_ConeToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Cone
        U1: float
        U2: float
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the cone in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        C: gp_Cone
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the cone in the u and v parametric directions. //! raised if v1 = v2.

        """
        _Convert.Convert_ConeToBSplineSurface_swiginit(self, _Convert.new_Convert_ConeToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ConeToBSplineSurface

# Register Convert_ConeToBSplineSurface in _Convert:
_Convert.Convert_ConeToBSplineSurface_swigregister(Convert_ConeToBSplineSurface)
class Convert_CylinderToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Cyl: gp_Cylinder
        U1: float
        U2: float
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-splinesurface as the same orientation as the cylinder in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        Cyl: gp_Cylinder
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-splinesurface as the same orientation as the cylinder in the u and v parametric directions. //! raised if v1 = v2.

        """
        _Convert.Convert_CylinderToBSplineSurface_swiginit(self, _Convert.new_Convert_CylinderToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CylinderToBSplineSurface

# Register Convert_CylinderToBSplineSurface in _Convert:
_Convert.Convert_CylinderToBSplineSurface_swigregister(Convert_CylinderToBSplineSurface)
class Convert_EllipseToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        E: gp_Elips2d
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline curve has the same orientation as the ellipse e.

        Parameters
        ----------
        E: gp_Elips2d
        U1: float
        U2: float
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        The ellipse e is limited between the parametric values u1, u2. the equivalent b-spline curve is oriented from u1 to u2 and has the same orientation as e. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi.

        """
        _Convert.Convert_EllipseToBSplineCurve_swiginit(self, _Convert.new_Convert_EllipseToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_EllipseToBSplineCurve

# Register Convert_EllipseToBSplineCurve in _Convert:
_Convert.Convert_EllipseToBSplineCurve_swigregister(Convert_EllipseToBSplineCurve)
class Convert_HyperbolaToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        H: gp_Hypr2d
        U1: float
        U2: float

        Return
        -------
        None

        Description
        -----------
        The hyperbola h is limited between the parametric values u1, u2 and the equivalent b-spline curve has the same orientation as the hyperbola.

        """
        _Convert.Convert_HyperbolaToBSplineCurve_swiginit(self, _Convert.new_Convert_HyperbolaToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_HyperbolaToBSplineCurve

# Register Convert_HyperbolaToBSplineCurve in _Convert:
_Convert.Convert_HyperbolaToBSplineCurve_swigregister(Convert_HyperbolaToBSplineCurve)
class Convert_ParabolaToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Prb: gp_Parab2d
        U1: float
        U2: float

        Return
        -------
        None

        Description
        -----------
        The parabola prb is limited between the parametric values u1, u2 and the equivalent b-spline curve as the same orientation as the parabola prb.

        """
        _Convert.Convert_ParabolaToBSplineCurve_swiginit(self, _Convert.new_Convert_ParabolaToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ParabolaToBSplineCurve

# Register Convert_ParabolaToBSplineCurve in _Convert:
_Convert.Convert_ParabolaToBSplineCurve_swigregister(Convert_ParabolaToBSplineCurve)
class Convert_SphereToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Sph: gp_Sphere
        U1: float
        U2: float
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        Sph: gp_Sphere
        Param1: float
        Param2: float
        UTrim: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions. //! raised if utrim = true and param1 = param2 or param1 = param2 + 2.0 * pi raised if utrim = false and param1 = param2.

        Parameters
        ----------
        Sph: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions.

        """
        _Convert.Convert_SphereToBSplineSurface_swiginit(self, _Convert.new_Convert_SphereToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_SphereToBSplineSurface

# Register Convert_SphereToBSplineSurface in _Convert:
_Convert.Convert_SphereToBSplineSurface_swigregister(Convert_SphereToBSplineSurface)
class Convert_TorusToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Torus
        U1: float
        U2: float
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2 or v1 = v2 + 2.0 * pi.

        Parameters
        ----------
        T: gp_Torus
        Param1: float
        Param2: float
        UTrim: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions. //! raised if param1 = param2 or param1 = param2 + 2.0 * pi.

        Parameters
        ----------
        T: gp_Torus

        Return
        -------
        None

        Description
        -----------
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions.

        """
        _Convert.Convert_TorusToBSplineSurface_swiginit(self, _Convert.new_Convert_TorusToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_TorusToBSplineSurface

# Register Convert_TorusToBSplineSurface in _Convert:
_Convert.Convert_TorusToBSplineSurface_swigregister(Convert_TorusToBSplineSurface)

Convert_SequenceOfArray1OfPoles2d=OCC.Core.TColgp.TColgp_SequenceOfArray1OfPnt2d


