# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
FairCurve module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_faircurve.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _FairCurve
else:
    import _FairCurve

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _FairCurve.delete_SwigPyIterator

    def value(self):
        return _FairCurve.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _FairCurve.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _FairCurve.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _FairCurve.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _FairCurve.SwigPyIterator_equal(self, x)

    def copy(self):
        return _FairCurve.SwigPyIterator_copy(self)

    def next(self):
        return _FairCurve.SwigPyIterator_next(self)

    def __next__(self):
        return _FairCurve.SwigPyIterator___next__(self)

    def previous(self):
        return _FairCurve.SwigPyIterator_previous(self)

    def advance(self, n):
        return _FairCurve.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _FairCurve.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _FairCurve.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _FairCurve.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _FairCurve.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _FairCurve.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _FairCurve.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _FairCurve:
_FairCurve.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _FairCurve.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _FairCurve.ios_base_erase_event
    imbue_event = _FairCurve.ios_base_imbue_event
    copyfmt_event = _FairCurve.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _FairCurve.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _FairCurve.ios_base_flags(self, *args)

    def setf(self, *args):
        return _FairCurve.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _FairCurve.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _FairCurve.ios_base_precision(self, *args)

    def width(self, *args):
        return _FairCurve.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _FairCurve.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _FairCurve.ios_base_imbue(self, __loc)

    def getloc(self):
        return _FairCurve.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _FairCurve.ios_base_xalloc()

    def iword(self, __ix):
        return _FairCurve.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _FairCurve.ios_base_pword(self, __ix)
    __swig_destroy__ = _FairCurve.delete_ios_base

# Register ios_base in _FairCurve:
_FairCurve.ios_base_swigregister(ios_base)
cvar = _FairCurve.cvar
ios_base.boolalpha = _FairCurve.cvar.ios_base_boolalpha
ios_base.dec = _FairCurve.cvar.ios_base_dec
ios_base.fixed = _FairCurve.cvar.ios_base_fixed
ios_base.hex = _FairCurve.cvar.ios_base_hex
ios_base.internal = _FairCurve.cvar.ios_base_internal
ios_base.left = _FairCurve.cvar.ios_base_left
ios_base.oct = _FairCurve.cvar.ios_base_oct
ios_base.right = _FairCurve.cvar.ios_base_right
ios_base.scientific = _FairCurve.cvar.ios_base_scientific
ios_base.showbase = _FairCurve.cvar.ios_base_showbase
ios_base.showpoint = _FairCurve.cvar.ios_base_showpoint
ios_base.showpos = _FairCurve.cvar.ios_base_showpos
ios_base.skipws = _FairCurve.cvar.ios_base_skipws
ios_base.unitbuf = _FairCurve.cvar.ios_base_unitbuf
ios_base.uppercase = _FairCurve.cvar.ios_base_uppercase
ios_base.adjustfield = _FairCurve.cvar.ios_base_adjustfield
ios_base.basefield = _FairCurve.cvar.ios_base_basefield
ios_base.floatfield = _FairCurve.cvar.ios_base_floatfield
ios_base.badbit = _FairCurve.cvar.ios_base_badbit
ios_base.eofbit = _FairCurve.cvar.ios_base_eofbit
ios_base.failbit = _FairCurve.cvar.ios_base_failbit
ios_base.goodbit = _FairCurve.cvar.ios_base_goodbit
ios_base.app = _FairCurve.cvar.ios_base_app
ios_base.ate = _FairCurve.cvar.ios_base_ate
ios_base.binary = _FairCurve.cvar.ios_base_binary
ios_base.ios_base_in = _FairCurve.cvar.ios_base_ios_base_in
ios_base.out = _FairCurve.cvar.ios_base_out
ios_base.trunc = _FairCurve.cvar.ios_base_trunc
ios_base.beg = _FairCurve.cvar.ios_base_beg
ios_base.cur = _FairCurve.cvar.ios_base_cur
ios_base.end = _FairCurve.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _FairCurve.ios_rdstate(self)

    def clear(self, *args):
        return _FairCurve.ios_clear(self, *args)

    def setstate(self, __state):
        return _FairCurve.ios_setstate(self, __state)

    def good(self):
        return _FairCurve.ios_good(self)

    def eof(self):
        return _FairCurve.ios_eof(self)

    def fail(self):
        return _FairCurve.ios_fail(self)

    def bad(self):
        return _FairCurve.ios_bad(self)

    def exceptions(self, *args):
        return _FairCurve.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _FairCurve.ios_swiginit(self, _FairCurve.new_ios(__sb))
    __swig_destroy__ = _FairCurve.delete_ios

    def tie(self, *args):
        return _FairCurve.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _FairCurve.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _FairCurve.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _FairCurve.ios_fill(self, *args)

    def imbue(self, __loc):
        return _FairCurve.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _FairCurve.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _FairCurve.ios_widen(self, __c)

# Register ios in _FairCurve:
_FairCurve.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _FairCurve.ostream_swiginit(self, _FairCurve.new_ostream(__sb))
    __swig_destroy__ = _FairCurve.delete_ostream

    def __lshift__(self, *args):
        return _FairCurve.ostream___lshift__(self, *args)

    def put(self, __c):
        return _FairCurve.ostream_put(self, __c)

    def write(self, __s, __n):
        return _FairCurve.ostream_write(self, __s, __n)

    def flush(self):
        return _FairCurve.ostream_flush(self)

    def tellp(self):
        return _FairCurve.ostream_tellp(self)

    def seekp(self, *args):
        return _FairCurve.ostream_seekp(self, *args)

# Register ostream in _FairCurve:
_FairCurve.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _FairCurve.istream_swiginit(self, _FairCurve.new_istream(__sb))
    __swig_destroy__ = _FairCurve.delete_istream

    def __rshift__(self, *args):
        return _FairCurve.istream___rshift__(self, *args)

    def gcount(self):
        return _FairCurve.istream_gcount(self)

    def get(self, *args):
        return _FairCurve.istream_get(self, *args)

    def getline(self, *args):
        return _FairCurve.istream_getline(self, *args)

    def ignore(self, *args):
        return _FairCurve.istream_ignore(self, *args)

    def peek(self):
        return _FairCurve.istream_peek(self)

    def read(self, __s, __n):
        return _FairCurve.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _FairCurve.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _FairCurve.istream_putback(self, __c)

    def unget(self):
        return _FairCurve.istream_unget(self)

    def sync(self):
        return _FairCurve.istream_sync(self)

    def tellg(self):
        return _FairCurve.istream_tellg(self)

    def seekg(self, *args):
        return _FairCurve.istream_seekg(self, *args)

# Register istream in _FairCurve:
_FairCurve.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _FairCurve.iostream_swiginit(self, _FairCurve.new_iostream(__sb))
    __swig_destroy__ = _FairCurve.delete_iostream

# Register iostream in _FairCurve:
_FairCurve.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _FairCurve.endl_cb_ptr
endl = _FairCurve.endl
ends_cb_ptr = _FairCurve.ends_cb_ptr
ends = _FairCurve.ends
flush_cb_ptr = _FairCurve.flush_cb_ptr
flush = _FairCurve.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Geom2d
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *

FairCurve_OK = _FairCurve.FairCurve_OK
FairCurve_NotConverged = _FairCurve.FairCurve_NotConverged
FairCurve_InfiniteSliding = _FairCurve.FairCurve_InfiniteSliding
FairCurve_NullHeight = _FairCurve.FairCurve_NullHeight


class FairCurve_AnalysisCode(IntEnum):
	FairCurve_OK = 0
	FairCurve_NotConverged = 1
	FairCurve_InfiniteSliding = 2
	FairCurve_NullHeight = 3
FairCurve_OK = FairCurve_AnalysisCode.FairCurve_OK
FairCurve_NotConverged = FairCurve_AnalysisCode.FairCurve_NotConverged
FairCurve_InfiniteSliding = FairCurve_AnalysisCode.FairCurve_InfiniteSliding
FairCurve_NullHeight = FairCurve_AnalysisCode.FairCurve_NullHeight

class FairCurve_Batten(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        Height: float
        Slope: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Constructor with the two points and the geometrical characteristics of the batten (elastic beam) height is the height of the deformation, and slope is the slope value, initialized at 0. the user can then supply the desired slope value by the method, setslope. other parameters are initialized as follow: - freesliding = false - constraintorder1 = 1 - constraintorder2 = 1 - angle1 = 0 - angle2 = 0 - slidingfactor = 1 exceptions negativevalue if height is less than or equal to 0. nullvalue if the distance between p1 and p2 is less than or equal to the tolerance value for distance in precision::confusion: p1.isequal(p2, precision::confusion()). the function gp_pnt2d::isequal tests to see if this is the case.

        """
        _FairCurve.FairCurve_Batten_swiginit(self, _FairCurve.new_FairCurve_Batten(*args))

    def Compute(self, *args):
        r"""

        Parameters
        ----------
        NbIterations: int (optional, default to 50)
        Tolerance: float (optional, default to 1.0e-3)

        Return
        -------
        Code: FairCurve_AnalysisCode

        Description
        -----------
        Performs the algorithm, using the arguments code, nbiterations and tolerance and computes the curve with respect to the constraints. code will have one of the following values: - ok - notconverged - infinitesliding - nullheight the parameters tolerance and nbiterations control how precise the computation is, and how long it will take.

        """
        return _FairCurve.FairCurve_Batten_Compute(self, *args)

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns the computed curve a 2d bspline.

        """
        return _FairCurve.FairCurve_Batten_Curve(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        o: Standard_OStream

        Description
        -----------
        Prints on the stream o information on the current state of the object. //! private methodes --------------------------------------.

        """
        return _FairCurve.FairCurve_Batten_Dump(self, *args)

    def GetAngle1(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the established first angle.

        """
        return _FairCurve.FairCurve_Batten_GetAngle1(self, *args)

    def GetAngle2(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the established second angle.

        """
        return _FairCurve.FairCurve_Batten_GetAngle2(self, *args)

    def GetConstraintOrder1(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the established first constraint order.

        """
        return _FairCurve.FairCurve_Batten_GetConstraintOrder1(self, *args)

    def GetConstraintOrder2(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the established second constraint order.

        """
        return _FairCurve.FairCurve_Batten_GetConstraintOrder2(self, *args)

    def GetFreeSliding(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the initial free sliding value, false by default. free sliding is generally more aesthetically pleasing than constrained sliding. however, the computation can fail with values such as angles greater than pi/2. this is because the resulting batten length is theoretically infinite.

        """
        return _FairCurve.FairCurve_Batten_GetFreeSliding(self, *args)

    def GetHeight(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the thickness of the lathe.

        """
        return _FairCurve.FairCurve_Batten_GetHeight(self, *args)

    def GetP1(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the established location of the point p1.

        """
        return _FairCurve.FairCurve_Batten_GetP1(self, *args)

    def GetP2(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the established location of the point p2.

        """
        return _FairCurve.FairCurve_Batten_GetP2(self, *args)

    def GetSlidingFactor(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the initial sliding factor.

        """
        return _FairCurve.FairCurve_Batten_GetSlidingFactor(self, *args)

    def GetSlope(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the established slope value.

        """
        return _FairCurve.FairCurve_Batten_GetSlope(self, *args)

    def SetAngle1(self, *args):
        r"""

        Parameters
        ----------
        Angle1: float

        Return
        -------
        None

        Description
        -----------
        Allows you to change the angle angle1 at the first point, p1. the default setting is 0.

        """
        return _FairCurve.FairCurve_Batten_SetAngle1(self, *args)

    def SetAngle2(self, *args):
        r"""

        Parameters
        ----------
        Angle2: float

        Return
        -------
        None

        Description
        -----------
        Allows you to change the angle angle2 at the second point, p2. the default setting is 0.

        """
        return _FairCurve.FairCurve_Batten_SetAngle2(self, *args)

    def SetConstraintOrder1(self, *args):
        r"""

        Parameters
        ----------
        ConstraintOrder: int

        Return
        -------
        None

        Description
        -----------
        Allows you to change the order of the constraint on the first point. constraintorder has the default setting of 1. the following settings are available: - 0-the curve must pass through a point - 1-the curve must pass through a point and have a given tangent - 2-the curve must pass through a point, have a given tangent and a given curvature. the third setting is only valid for faircurve_minimalvariation curves. these constraints, though geometric, represent the mechanical constraints due, for example, to the resistance of the material the actual physical batten is made of.

        """
        return _FairCurve.FairCurve_Batten_SetConstraintOrder1(self, *args)

    def SetConstraintOrder2(self, *args):
        r"""

        Parameters
        ----------
        ConstraintOrder: int

        Return
        -------
        None

        Description
        -----------
        Allows you to change the order of the constraint on the second point. constraintorder is initialized with the default setting of 1. the following settings are available: - 0-the curve must pass through a point - 1-the curve must pass through a point and have a given tangent - 2-the curve must pass through a point, have a given tangent and a given curvature. the third setting is only valid for faircurve_minimalvariation curves. these constraints, though geometric, represent the mechanical constraints due, for example, to the resistance of the material the actual physical batten is made of.

        """
        return _FairCurve.FairCurve_Batten_SetConstraintOrder2(self, *args)

    def SetFreeSliding(self, *args):
        r"""

        Parameters
        ----------
        FreeSliding: bool

        Return
        -------
        None

        Description
        -----------
        Freesliding is initialized with the default setting false. when freesliding is set to true and, as a result, sliding is free, the sliding factor is automatically computed to satisfy the equilibrium of the batten.

        """
        return _FairCurve.FairCurve_Batten_SetFreeSliding(self, *args)

    def SetHeight(self, *args):
        r"""

        Parameters
        ----------
        Height: float

        Return
        -------
        None

        Description
        -----------
        Allows you to change the height of the deformation. raises negativevalue; -- if height <= 0 if height <= 0.

        """
        return _FairCurve.FairCurve_Batten_SetHeight(self, *args)

    def SetP1(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Allows you to change the location of the point, p1, and in doing so, modify the curve. warning this method changes the angle as well as the point. exceptions nullvalue if the distance between p1 and p2 is less than or equal to the tolerance value for distance in precision::confusion: p1.isequal(p2, precision::confusion()). the function gp_pnt2d::isequal tests to see if this is the case.

        """
        return _FairCurve.FairCurve_Batten_SetP1(self, *args)

    def SetP2(self, *args):
        r"""

        Parameters
        ----------
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Allows you to change the location of the point, p1, and in doing so, modify the curve. warning this method changes the angle as well as the point. exceptions nullvalue if the distance between p1 and p2 is less than or equal to the tolerance value for distance in precision::confusion: p1.isequal(p2, precision::confusion()). the function gp_pnt2d::isequal tests to see if this is the case.

        """
        return _FairCurve.FairCurve_Batten_SetP2(self, *args)

    def SetSlidingFactor(self, *args):
        r"""

        Parameters
        ----------
        SlidingFactor: float

        Return
        -------
        None

        Description
        -----------
        Allows you to change the ratio slidingfactor. this compares the length of the batten and the reference length, which is, in turn, a function of the constraints. this modification has one of the following two effects: - if you increase the value, it inflates the batten - if you decrease the value, it flattens the batten. when sliding is free, the sliding factor is automatically computed to satisfy the equilibrium of the batten. when sliding is imposed, a value is required for the sliding factor. slidingfactor is initialized with the default setting of 1.

        """
        return _FairCurve.FairCurve_Batten_SetSlidingFactor(self, *args)

    def SetSlope(self, *args):
        r"""

        Parameters
        ----------
        Slope: float

        Return
        -------
        None

        Description
        -----------
        Allows you to set the slope value, slope.

        """
        return _FairCurve.FairCurve_Batten_SetSlope(self, *args)

    def SlidingOfReference(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the real number value for length sliding of reference for new constraints. if you want to give a specific length to a batten curve, use the following syntax: b.setslidingfactor(l / b.slidingofreference()) where b is the name of the batten curve object.

        """
        return _FairCurve.FairCurve_Batten_SlidingOfReference(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_Batten

# Register FairCurve_Batten in _FairCurve:
_FairCurve.FairCurve_Batten_swigregister(FairCurve_Batten)
class FairCurve_BattenLaw(OCC.Core.math.math_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Heigth: float
        Slope: float
        Sliding: float

        Return
        -------
        None

        Description
        -----------
        Constructor of linear batten with heigth: the heigth at the middle point slope: the geometric slope of the batten sliding: active length of the batten without extension.

        """
        _FairCurve.FairCurve_BattenLaw_swiginit(self, _FairCurve.new_FairCurve_BattenLaw(*args))

    def SetHeigth(self, *args):
        r"""

        Parameters
        ----------
        Heigth: float

        Return
        -------
        None

        Description
        -----------
        Change the value of heigth at the middle point.

        """
        return _FairCurve.FairCurve_BattenLaw_SetHeigth(self, *args)

    def SetSliding(self, *args):
        r"""

        Parameters
        ----------
        Sliding: float

        Return
        -------
        None

        Description
        -----------
        Change the value of sliding.

        """
        return _FairCurve.FairCurve_BattenLaw_SetSliding(self, *args)

    def SetSlope(self, *args):
        r"""

        Parameters
        ----------
        Slope: float

        Return
        -------
        None

        Description
        -----------
        Change the value of the geometric slope.

        """
        return _FairCurve.FairCurve_BattenLaw_SetSlope(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_BattenLaw

# Register FairCurve_BattenLaw in _FairCurve:
_FairCurve.FairCurve_BattenLaw_swigregister(FairCurve_BattenLaw)
class FairCurve_DistributionOfEnergy(OCC.Core.math.math_FunctionSet):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetDerivativeOrder(self, *args):
        r"""

        Parameters
        ----------
        DerivativeOrder: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _FairCurve.FairCurve_DistributionOfEnergy_SetDerivativeOrder(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_DistributionOfEnergy

# Register FairCurve_DistributionOfEnergy in _FairCurve:
_FairCurve.FairCurve_DistributionOfEnergy_swigregister(FairCurve_DistributionOfEnergy)
class FairCurve_Energy(OCC.Core.math.math_MultipleVarFunctionWithHessian):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Poles(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColgp_HArray1OfPnt2d>

        Description
        -----------
        Return the poles.

        """
        return _FairCurve.FairCurve_Energy_Poles(self, *args)

    def Values(self, *args):
        r"""

        Parameters
        ----------
        X: math_Vector
        G: math_Vector

        Return
        -------
        E: float

        Description
        -----------
        Computes the energy <e> and the gradient <g> of the energy for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        G: math_Vector
        H: math_Matrix

        Return
        -------
        E: float

        Description
        -----------
        Computes the energy <e>, the gradient <g> and the hessian <h> of the energy for the variable <x>. returns true if the computation was done successfully, false otherwise.

        """
        return _FairCurve.FairCurve_Energy_Values(self, *args)

    def Variable(self, *args):
        r"""

        Parameters
        ----------
        X: math_Vector

        Return
        -------
        bool

        Description
        -----------
        Compute the variables <x> which correspond with the field <mypoles>.

        """
        return _FairCurve.FairCurve_Energy_Variable(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_Energy

# Register FairCurve_Energy in _FairCurve:
_FairCurve.FairCurve_Energy_swigregister(FairCurve_Energy)
class FairCurve_Newton(OCC.Core.math.math_NewtonMinimum):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithHessian
        theSpatialTolerance: float (optional, default to 1.0e-7)
        theCriteriumTolerance: float (optional, default to 1.0e-7)
        theNbIterations: int (optional, default to 40)
        theConvexity: float (optional, default to 1.0e-6)
        theWithSingularity: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The tolerance required on the solution is given by tolerance. iteration are stopped if (!withsingularity) and h(f(xi)) is not definite positive (if the smaller eigenvalue of h < convexity) or isconverged() returns true for 2 successives iterations. warning: this constructor do not computation.

        """
        _FairCurve.FairCurve_Newton_swiginit(self, _FairCurve.new_FairCurve_Newton(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_Newton

# Register FairCurve_Newton in _FairCurve:
_FairCurve.FairCurve_Newton_swigregister(FairCurve_Newton)
class FairCurve_DistributionOfJerk(FairCurve_DistributionOfEnergy):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BSplOrder: int
        FlatKnots: TColStd_HArray1OfReal
        Poles: TColgp_HArray1OfPnt2d
        DerivativeOrder: int
        Law: FairCurve_BattenLaw
        NbValAux: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _FairCurve.FairCurve_DistributionOfJerk_swiginit(self, _FairCurve.new_FairCurve_DistributionOfJerk(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_DistributionOfJerk

# Register FairCurve_DistributionOfJerk in _FairCurve:
_FairCurve.FairCurve_DistributionOfJerk_swigregister(FairCurve_DistributionOfJerk)
class FairCurve_DistributionOfSagging(FairCurve_DistributionOfEnergy):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BSplOrder: int
        FlatKnots: TColStd_HArray1OfReal
        Poles: TColgp_HArray1OfPnt2d
        DerivativeOrder: int
        Law: FairCurve_BattenLaw
        NbValAux: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _FairCurve.FairCurve_DistributionOfSagging_swiginit(self, _FairCurve.new_FairCurve_DistributionOfSagging(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_DistributionOfSagging

# Register FairCurve_DistributionOfSagging in _FairCurve:
_FairCurve.FairCurve_DistributionOfSagging_swigregister(FairCurve_DistributionOfSagging)
class FairCurve_DistributionOfTension(FairCurve_DistributionOfEnergy):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BSplOrder: int
        FlatKnots: TColStd_HArray1OfReal
        Poles: TColgp_HArray1OfPnt2d
        DerivativeOrder: int
        LengthSliding: float
        Law: FairCurve_BattenLaw
        NbValAux: int (optional, default to 0)
        Uniform: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _FairCurve.FairCurve_DistributionOfTension_swiginit(self, _FairCurve.new_FairCurve_DistributionOfTension(*args))

    def SetLengthSliding(self, *args):
        r"""

        Parameters
        ----------
        LengthSliding: float

        Return
        -------
        None

        Description
        -----------
        Change the length sliding.

        """
        return _FairCurve.FairCurve_DistributionOfTension_SetLengthSliding(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_DistributionOfTension

# Register FairCurve_DistributionOfTension in _FairCurve:
_FairCurve.FairCurve_DistributionOfTension_swigregister(FairCurve_DistributionOfTension)
class FairCurve_EnergyOfBatten(FairCurve_Energy):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BSplOrder: int
        FlatKnots: TColStd_HArray1OfReal
        Poles: TColgp_HArray1OfPnt2d
        ContrOrder1: int
        ContrOrder2: int
        Law: FairCurve_BattenLaw
        LengthSliding: float
        FreeSliding: bool (optional, default to Standard_True)
        Angle1: float (optional, default to 0)
        Angle2: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Angles corresspond to the ox axis.

        """
        _FairCurve.FairCurve_EnergyOfBatten_swiginit(self, _FairCurve.new_FairCurve_EnergyOfBatten(*args))

    def LengthSliding(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return the lengthsliding = p1p2 + sliding.

        """
        return _FairCurve.FairCurve_EnergyOfBatten_LengthSliding(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        FairCurve_AnalysisCode

        Description
        -----------
        Return the status.

        """
        return _FairCurve.FairCurve_EnergyOfBatten_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_EnergyOfBatten

# Register FairCurve_EnergyOfBatten in _FairCurve:
_FairCurve.FairCurve_EnergyOfBatten_swigregister(FairCurve_EnergyOfBatten)
class FairCurve_EnergyOfMVC(FairCurve_Energy):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BSplOrder: int
        FlatKnots: TColStd_HArray1OfReal
        Poles: TColgp_HArray1OfPnt2d
        ContrOrder1: int
        ContrOrder2: int
        Law: FairCurve_BattenLaw
        PhysicalRatio: float
        LengthSliding: float
        FreeSliding: bool (optional, default to Standard_True)
        Angle1: float (optional, default to 0)
        Angle2: float (optional, default to 0)
        Curvature1: float (optional, default to 0)
        Curvature2: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Angles corresspond to the ox axis.

        """
        _FairCurve.FairCurve_EnergyOfMVC_swiginit(self, _FairCurve.new_FairCurve_EnergyOfMVC(*args))

    def LengthSliding(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return the lengthsliding = p1p2 + sliding.

        """
        return _FairCurve.FairCurve_EnergyOfMVC_LengthSliding(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        FairCurve_AnalysisCode

        Description
        -----------
        Return the status.

        """
        return _FairCurve.FairCurve_EnergyOfMVC_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_EnergyOfMVC

# Register FairCurve_EnergyOfMVC in _FairCurve:
_FairCurve.FairCurve_EnergyOfMVC_swigregister(FairCurve_EnergyOfMVC)
class FairCurve_MinimalVariation(FairCurve_Batten):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        Heigth: float
        Slope: float (optional, default to 0)
        PhysicalRatio: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Constructs the two contact points p1 and p2 and the geometrical characteristics of the batten (elastic beam) these include the real number values for height of deformation height, slope value slope, and kind of energy physicalratio. the kinds of energy include: - jerk (0) - sagging (1). note that the default setting for physical ration is in faircurve_batten other parameters are initialized as follow: - freesliding = false - constraintorder1 = 1 - constraintorder2 = 1 - angle1 = 0 - angle2 = 0 - curvature1 = 0 - curvature2 = 0 - slidingfactor = 1 warning if physicalratio equals 1, you cannot impose constraints on curvature. exceptions negativevalue if height is less than or equal to 0. nullvalue if the distance between p1 and p2 is less than or equal to the tolerance value for distance in precision::confusion: p1.isequal(p2, precision::confusion()). the function gp_pnt2d::isequal tests to see if this is the case. definition of the geometricals constraints.

        """
        _FairCurve.FairCurve_MinimalVariation_swiginit(self, _FairCurve.new_FairCurve_MinimalVariation(*args))

    def GetCurvature1(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the first established curvature.

        """
        return _FairCurve.FairCurve_MinimalVariation_GetCurvature1(self, *args)

    def GetCurvature2(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the second established curvature.

        """
        return _FairCurve.FairCurve_MinimalVariation_GetCurvature2(self, *args)

    def GetPhysicalRatio(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the physical ratio, or kind of energy.

        """
        return _FairCurve.FairCurve_MinimalVariation_GetPhysicalRatio(self, *args)

    def SetCurvature1(self, *args):
        r"""

        Parameters
        ----------
        Curvature: float

        Return
        -------
        None

        Description
        -----------
        Allows you to set a new constraint on curvature at the first point.

        """
        return _FairCurve.FairCurve_MinimalVariation_SetCurvature1(self, *args)

    def SetCurvature2(self, *args):
        r"""

        Parameters
        ----------
        Curvature: float

        Return
        -------
        None

        Description
        -----------
        Allows you to set a new constraint on curvature at the second point.

        """
        return _FairCurve.FairCurve_MinimalVariation_SetCurvature2(self, *args)

    def SetPhysicalRatio(self, *args):
        r"""

        Parameters
        ----------
        Ratio: float

        Return
        -------
        None

        Description
        -----------
        Allows you to set the physical ratio ratio. the kinds of energy which you can specify include: 0 is only 'jerk' energy 1 is only 'sagging' energy like batten warning: if ratio is 1 it is impossible to impose curvature constraints. raises domainerror if ratio < 0 or ratio > 1.

        """
        return _FairCurve.FairCurve_MinimalVariation_SetPhysicalRatio(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _FairCurve.delete_FairCurve_MinimalVariation

# Register FairCurve_MinimalVariation in _FairCurve:
_FairCurve.FairCurve_MinimalVariation_swigregister(FairCurve_MinimalVariation)



