# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
HatchGen module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_hatchgen.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _HatchGen
else:
    import _HatchGen

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _HatchGen.delete_SwigPyIterator

    def value(self):
        return _HatchGen.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _HatchGen.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _HatchGen.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _HatchGen.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _HatchGen.SwigPyIterator_equal(self, x)

    def copy(self):
        return _HatchGen.SwigPyIterator_copy(self)

    def next(self):
        return _HatchGen.SwigPyIterator_next(self)

    def __next__(self):
        return _HatchGen.SwigPyIterator___next__(self)

    def previous(self):
        return _HatchGen.SwigPyIterator_previous(self)

    def advance(self, n):
        return _HatchGen.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _HatchGen.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _HatchGen.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _HatchGen.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _HatchGen.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _HatchGen.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _HatchGen.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _HatchGen:
_HatchGen.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _HatchGen.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _HatchGen.ios_base_erase_event
    imbue_event = _HatchGen.ios_base_imbue_event
    copyfmt_event = _HatchGen.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _HatchGen.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _HatchGen.ios_base_flags(self, *args)

    def setf(self, *args):
        return _HatchGen.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _HatchGen.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _HatchGen.ios_base_precision(self, *args)

    def width(self, *args):
        return _HatchGen.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _HatchGen.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _HatchGen.ios_base_imbue(self, __loc)

    def getloc(self):
        return _HatchGen.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _HatchGen.ios_base_xalloc()

    def iword(self, __ix):
        return _HatchGen.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _HatchGen.ios_base_pword(self, __ix)
    __swig_destroy__ = _HatchGen.delete_ios_base

# Register ios_base in _HatchGen:
_HatchGen.ios_base_swigregister(ios_base)
cvar = _HatchGen.cvar
ios_base.boolalpha = _HatchGen.cvar.ios_base_boolalpha
ios_base.dec = _HatchGen.cvar.ios_base_dec
ios_base.fixed = _HatchGen.cvar.ios_base_fixed
ios_base.hex = _HatchGen.cvar.ios_base_hex
ios_base.internal = _HatchGen.cvar.ios_base_internal
ios_base.left = _HatchGen.cvar.ios_base_left
ios_base.oct = _HatchGen.cvar.ios_base_oct
ios_base.right = _HatchGen.cvar.ios_base_right
ios_base.scientific = _HatchGen.cvar.ios_base_scientific
ios_base.showbase = _HatchGen.cvar.ios_base_showbase
ios_base.showpoint = _HatchGen.cvar.ios_base_showpoint
ios_base.showpos = _HatchGen.cvar.ios_base_showpos
ios_base.skipws = _HatchGen.cvar.ios_base_skipws
ios_base.unitbuf = _HatchGen.cvar.ios_base_unitbuf
ios_base.uppercase = _HatchGen.cvar.ios_base_uppercase
ios_base.adjustfield = _HatchGen.cvar.ios_base_adjustfield
ios_base.basefield = _HatchGen.cvar.ios_base_basefield
ios_base.floatfield = _HatchGen.cvar.ios_base_floatfield
ios_base.badbit = _HatchGen.cvar.ios_base_badbit
ios_base.eofbit = _HatchGen.cvar.ios_base_eofbit
ios_base.failbit = _HatchGen.cvar.ios_base_failbit
ios_base.goodbit = _HatchGen.cvar.ios_base_goodbit
ios_base.app = _HatchGen.cvar.ios_base_app
ios_base.ate = _HatchGen.cvar.ios_base_ate
ios_base.binary = _HatchGen.cvar.ios_base_binary
ios_base.ios_base_in = _HatchGen.cvar.ios_base_ios_base_in
ios_base.out = _HatchGen.cvar.ios_base_out
ios_base.trunc = _HatchGen.cvar.ios_base_trunc
ios_base.beg = _HatchGen.cvar.ios_base_beg
ios_base.cur = _HatchGen.cvar.ios_base_cur
ios_base.end = _HatchGen.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _HatchGen.ios_rdstate(self)

    def clear(self, *args):
        return _HatchGen.ios_clear(self, *args)

    def setstate(self, __state):
        return _HatchGen.ios_setstate(self, __state)

    def good(self):
        return _HatchGen.ios_good(self)

    def eof(self):
        return _HatchGen.ios_eof(self)

    def fail(self):
        return _HatchGen.ios_fail(self)

    def bad(self):
        return _HatchGen.ios_bad(self)

    def exceptions(self, *args):
        return _HatchGen.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _HatchGen.ios_swiginit(self, _HatchGen.new_ios(__sb))
    __swig_destroy__ = _HatchGen.delete_ios

    def tie(self, *args):
        return _HatchGen.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _HatchGen.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _HatchGen.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _HatchGen.ios_fill(self, *args)

    def imbue(self, __loc):
        return _HatchGen.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _HatchGen.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _HatchGen.ios_widen(self, __c)

# Register ios in _HatchGen:
_HatchGen.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _HatchGen.ostream_swiginit(self, _HatchGen.new_ostream(__sb))
    __swig_destroy__ = _HatchGen.delete_ostream

    def __lshift__(self, *args):
        return _HatchGen.ostream___lshift__(self, *args)

    def put(self, __c):
        return _HatchGen.ostream_put(self, __c)

    def write(self, __s, __n):
        return _HatchGen.ostream_write(self, __s, __n)

    def flush(self):
        return _HatchGen.ostream_flush(self)

    def tellp(self):
        return _HatchGen.ostream_tellp(self)

    def seekp(self, *args):
        return _HatchGen.ostream_seekp(self, *args)

# Register ostream in _HatchGen:
_HatchGen.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _HatchGen.istream_swiginit(self, _HatchGen.new_istream(__sb))
    __swig_destroy__ = _HatchGen.delete_istream

    def __rshift__(self, *args):
        return _HatchGen.istream___rshift__(self, *args)

    def gcount(self):
        return _HatchGen.istream_gcount(self)

    def get(self, *args):
        return _HatchGen.istream_get(self, *args)

    def getline(self, *args):
        return _HatchGen.istream_getline(self, *args)

    def ignore(self, *args):
        return _HatchGen.istream_ignore(self, *args)

    def peek(self):
        return _HatchGen.istream_peek(self)

    def read(self, __s, __n):
        return _HatchGen.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _HatchGen.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _HatchGen.istream_putback(self, __c)

    def unget(self):
        return _HatchGen.istream_unget(self)

    def sync(self):
        return _HatchGen.istream_sync(self)

    def tellg(self):
        return _HatchGen.istream_tellg(self)

    def seekg(self, *args):
        return _HatchGen.istream_seekg(self, *args)

# Register istream in _HatchGen:
_HatchGen.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _HatchGen.iostream_swiginit(self, _HatchGen.new_iostream(__sb))
    __swig_destroy__ = _HatchGen.delete_iostream

# Register iostream in _HatchGen:
_HatchGen.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _HatchGen.endl_cb_ptr
endl = _HatchGen.endl
ends_cb_ptr = _HatchGen.ends_cb_ptr
ends = _HatchGen.ends
flush_cb_ptr = _HatchGen.flush_cb_ptr
flush = _HatchGen.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopAbs
import OCC.Core.IntRes2d
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection

from enum import IntEnum
from OCC.Core.Exception import *

HatchGen_NoProblem = _HatchGen.HatchGen_NoProblem
HatchGen_TrimFailure = _HatchGen.HatchGen_TrimFailure
HatchGen_TransitionFailure = _HatchGen.HatchGen_TransitionFailure
HatchGen_IncoherentParity = _HatchGen.HatchGen_IncoherentParity
HatchGen_IncompatibleStates = _HatchGen.HatchGen_IncompatibleStates
HatchGen_TRUE = _HatchGen.HatchGen_TRUE
HatchGen_TOUCH = _HatchGen.HatchGen_TOUCH
HatchGen_TANGENT = _HatchGen.HatchGen_TANGENT
HatchGen_UNDETERMINED = _HatchGen.HatchGen_UNDETERMINED


class HatchGen_ErrorStatus(IntEnum):
	HatchGen_NoProblem = 0
	HatchGen_TrimFailure = 1
	HatchGen_TransitionFailure = 2
	HatchGen_IncoherentParity = 3
	HatchGen_IncompatibleStates = 4
HatchGen_NoProblem = HatchGen_ErrorStatus.HatchGen_NoProblem
HatchGen_TrimFailure = HatchGen_ErrorStatus.HatchGen_TrimFailure
HatchGen_TransitionFailure = HatchGen_ErrorStatus.HatchGen_TransitionFailure
HatchGen_IncoherentParity = HatchGen_ErrorStatus.HatchGen_IncoherentParity
HatchGen_IncompatibleStates = HatchGen_ErrorStatus.HatchGen_IncompatibleStates

class HatchGen_IntersectionType(IntEnum):
	HatchGen_TRUE = 0
	HatchGen_TOUCH = 1
	HatchGen_TANGENT = 2
	HatchGen_UNDETERMINED = 3
HatchGen_TRUE = HatchGen_IntersectionType.HatchGen_TRUE
HatchGen_TOUCH = HatchGen_IntersectionType.HatchGen_TOUCH
HatchGen_TANGENT = HatchGen_IntersectionType.HatchGen_TANGENT
HatchGen_UNDETERMINED = HatchGen_IntersectionType.HatchGen_UNDETERMINED

class HatchGen_Domains(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _HatchGen.HatchGen_Domains_begin(self)

    def end(self):
        return _HatchGen.HatchGen_Domains_end(self)

    def cbegin(self):
        return _HatchGen.HatchGen_Domains_cbegin(self)

    def cend(self):
        return _HatchGen.HatchGen_Domains_cend(self)

    def __init__(self, *args):
        _HatchGen.HatchGen_Domains_swiginit(self, _HatchGen.new_HatchGen_Domains(*args))

    def Size(self):
        return _HatchGen.HatchGen_Domains_Size(self)

    def Length(self):
        return _HatchGen.HatchGen_Domains_Length(self)

    def Lower(self):
        return _HatchGen.HatchGen_Domains_Lower(self)

    def Upper(self):
        return _HatchGen.HatchGen_Domains_Upper(self)

    def IsEmpty(self):
        return _HatchGen.HatchGen_Domains_IsEmpty(self)

    def Reverse(self):
        return _HatchGen.HatchGen_Domains_Reverse(self)

    def Exchange(self, I, J):
        return _HatchGen.HatchGen_Domains_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _HatchGen.HatchGen_Domains_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _HatchGen.HatchGen_Domains_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _HatchGen.HatchGen_Domains_Assign(self, theOther)

    def Set(self, *args):
        return _HatchGen.HatchGen_Domains_Set(self, *args)

    def Remove(self, *args):
        return _HatchGen.HatchGen_Domains_Remove(self, *args)

    def Append(self, *args):
        return _HatchGen.HatchGen_Domains_Append(self, *args)

    def Prepend(self, *args):
        return _HatchGen.HatchGen_Domains_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _HatchGen.HatchGen_Domains_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _HatchGen.HatchGen_Domains_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _HatchGen.HatchGen_Domains_Split(self, theIndex, theSeq)

    def First(self):
        return _HatchGen.HatchGen_Domains_First(self)

    def ChangeFirst(self):
        return _HatchGen.HatchGen_Domains_ChangeFirst(self)

    def Last(self):
        return _HatchGen.HatchGen_Domains_Last(self)

    def ChangeLast(self):
        return _HatchGen.HatchGen_Domains_ChangeLast(self)

    def Value(self, theIndex):
        return _HatchGen.HatchGen_Domains_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _HatchGen.HatchGen_Domains_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _HatchGen.HatchGen_Domains___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _HatchGen.HatchGen_Domains_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _HatchGen.delete_HatchGen_Domains

    def __len__(self):
        return self.Size()


# Register HatchGen_Domains in _HatchGen:
_HatchGen.HatchGen_Domains_swigregister(HatchGen_Domains)
class HatchGen_PointsOnElement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _HatchGen.HatchGen_PointsOnElement_begin(self)

    def end(self):
        return _HatchGen.HatchGen_PointsOnElement_end(self)

    def cbegin(self):
        return _HatchGen.HatchGen_PointsOnElement_cbegin(self)

    def cend(self):
        return _HatchGen.HatchGen_PointsOnElement_cend(self)

    def __init__(self, *args):
        _HatchGen.HatchGen_PointsOnElement_swiginit(self, _HatchGen.new_HatchGen_PointsOnElement(*args))

    def Size(self):
        return _HatchGen.HatchGen_PointsOnElement_Size(self)

    def Length(self):
        return _HatchGen.HatchGen_PointsOnElement_Length(self)

    def Lower(self):
        return _HatchGen.HatchGen_PointsOnElement_Lower(self)

    def Upper(self):
        return _HatchGen.HatchGen_PointsOnElement_Upper(self)

    def IsEmpty(self):
        return _HatchGen.HatchGen_PointsOnElement_IsEmpty(self)

    def Reverse(self):
        return _HatchGen.HatchGen_PointsOnElement_Reverse(self)

    def Exchange(self, I, J):
        return _HatchGen.HatchGen_PointsOnElement_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _HatchGen.HatchGen_PointsOnElement_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _HatchGen.HatchGen_PointsOnElement_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _HatchGen.HatchGen_PointsOnElement_Assign(self, theOther)

    def Set(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_Set(self, *args)

    def Remove(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_Remove(self, *args)

    def Append(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_Append(self, *args)

    def Prepend(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _HatchGen.HatchGen_PointsOnElement_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _HatchGen.HatchGen_PointsOnElement_Split(self, theIndex, theSeq)

    def First(self):
        return _HatchGen.HatchGen_PointsOnElement_First(self)

    def ChangeFirst(self):
        return _HatchGen.HatchGen_PointsOnElement_ChangeFirst(self)

    def Last(self):
        return _HatchGen.HatchGen_PointsOnElement_Last(self)

    def ChangeLast(self):
        return _HatchGen.HatchGen_PointsOnElement_ChangeLast(self)

    def Value(self, theIndex):
        return _HatchGen.HatchGen_PointsOnElement_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _HatchGen.HatchGen_PointsOnElement_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _HatchGen.HatchGen_PointsOnElement___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _HatchGen.HatchGen_PointsOnElement_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _HatchGen.delete_HatchGen_PointsOnElement

    def __len__(self):
        return self.Size()


# Register HatchGen_PointsOnElement in _HatchGen:
_HatchGen.HatchGen_PointsOnElement_swigregister(HatchGen_PointsOnElement)
class HatchGen_PointsOnHatching(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _HatchGen.HatchGen_PointsOnHatching_begin(self)

    def end(self):
        return _HatchGen.HatchGen_PointsOnHatching_end(self)

    def cbegin(self):
        return _HatchGen.HatchGen_PointsOnHatching_cbegin(self)

    def cend(self):
        return _HatchGen.HatchGen_PointsOnHatching_cend(self)

    def __init__(self, *args):
        _HatchGen.HatchGen_PointsOnHatching_swiginit(self, _HatchGen.new_HatchGen_PointsOnHatching(*args))

    def Size(self):
        return _HatchGen.HatchGen_PointsOnHatching_Size(self)

    def Length(self):
        return _HatchGen.HatchGen_PointsOnHatching_Length(self)

    def Lower(self):
        return _HatchGen.HatchGen_PointsOnHatching_Lower(self)

    def Upper(self):
        return _HatchGen.HatchGen_PointsOnHatching_Upper(self)

    def IsEmpty(self):
        return _HatchGen.HatchGen_PointsOnHatching_IsEmpty(self)

    def Reverse(self):
        return _HatchGen.HatchGen_PointsOnHatching_Reverse(self)

    def Exchange(self, I, J):
        return _HatchGen.HatchGen_PointsOnHatching_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _HatchGen.HatchGen_PointsOnHatching_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _HatchGen.HatchGen_PointsOnHatching_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _HatchGen.HatchGen_PointsOnHatching_Assign(self, theOther)

    def Set(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_Set(self, *args)

    def Remove(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_Remove(self, *args)

    def Append(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_Append(self, *args)

    def Prepend(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _HatchGen.HatchGen_PointsOnHatching_Split(self, theIndex, theSeq)

    def First(self):
        return _HatchGen.HatchGen_PointsOnHatching_First(self)

    def ChangeFirst(self):
        return _HatchGen.HatchGen_PointsOnHatching_ChangeFirst(self)

    def Last(self):
        return _HatchGen.HatchGen_PointsOnHatching_Last(self)

    def ChangeLast(self):
        return _HatchGen.HatchGen_PointsOnHatching_ChangeLast(self)

    def Value(self, theIndex):
        return _HatchGen.HatchGen_PointsOnHatching_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _HatchGen.HatchGen_PointsOnHatching_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _HatchGen.HatchGen_PointsOnHatching___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _HatchGen.HatchGen_PointsOnHatching_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _HatchGen.delete_HatchGen_PointsOnHatching

    def __len__(self):
        return self.Size()


# Register HatchGen_PointsOnHatching in _HatchGen:
_HatchGen.HatchGen_PointsOnHatching_swigregister(HatchGen_PointsOnHatching)
class HatchGen_Domain(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an infinite domain.

        Parameters
        ----------
        P1: HatchGen_PointOnHatching
        P2: HatchGen_PointOnHatching

        Return
        -------
        None

        Description
        -----------
        Creates a domain for the curve associated to a hatching.

        Parameters
        ----------
        P: HatchGen_PointOnHatching
        First: bool

        Return
        -------
        None

        Description
        -----------
        Creates a semi-infinite domain for the curve associated to a hatching. the `first' flag means that the given point is the first one.

        """
        _HatchGen.HatchGen_Domain_swiginit(self, _HatchGen.new_HatchGen_Domain(*args))

    def Dump(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Dump of the domain.

        """
        return _HatchGen.HatchGen_Domain_Dump(self, *args)

    def FirstPoint(self, *args):
        r"""
        Return
        -------
        HatchGen_PointOnHatching

        Description
        -----------
        Returns the first point of the domain. the exception domainerror is raised if hasfirstpoint returns false.

        """
        return _HatchGen.HatchGen_Domain_FirstPoint(self, *args)

    def HasFirstPoint(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the domain has a first point.

        """
        return _HatchGen.HatchGen_Domain_HasFirstPoint(self, *args)

    def HasSecondPoint(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the domain has a second point.

        """
        return _HatchGen.HatchGen_Domain_HasSecondPoint(self, *args)

    def SecondPoint(self, *args):
        r"""
        Return
        -------
        HatchGen_PointOnHatching

        Description
        -----------
        Returns the second point of the domain. the exception domainerror is raised if hassecondpoint returns false.

        """
        return _HatchGen.HatchGen_Domain_SecondPoint(self, *args)

    def SetFirstPoint(self, *args):
        r"""

        Parameters
        ----------
        P: HatchGen_PointOnHatching

        Return
        -------
        None

        Description
        -----------
        Sets the first point of the domain.
        Return
        -------
        None

        Description
        -----------
        Sets the first point of the domain at the infinite.

        """
        return _HatchGen.HatchGen_Domain_SetFirstPoint(self, *args)

    def SetPoints(self, *args):
        r"""

        Parameters
        ----------
        P1: HatchGen_PointOnHatching
        P2: HatchGen_PointOnHatching

        Return
        -------
        None

        Description
        -----------
        Sets the first and the second points of the domain.
        Return
        -------
        None

        Description
        -----------
        Sets the first and the second points of the domain as the infinite.

        """
        return _HatchGen.HatchGen_Domain_SetPoints(self, *args)

    def SetSecondPoint(self, *args):
        r"""

        Parameters
        ----------
        P: HatchGen_PointOnHatching

        Return
        -------
        None

        Description
        -----------
        Sets the second point of the domain.
        Return
        -------
        None

        Description
        -----------
        Sets the second point of the domain at the infinite.

        """
        return _HatchGen.HatchGen_Domain_SetSecondPoint(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _HatchGen.delete_HatchGen_Domain

# Register HatchGen_Domain in _HatchGen:
_HatchGen.HatchGen_Domain_swigregister(HatchGen_Domain)
class HatchGen_IntersectionPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Dump(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Dump of the point on element.

        """
        return _HatchGen.HatchGen_IntersectionPoint_Dump(self, *args)

    def Index(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the index of the supporting curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_Index(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_Parameter(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns the position of the point on the curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_Position(self, *args)

    def SegmentBeginning(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag that the point is the beginning of a segment.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SegmentBeginning(self, *args)

    def SegmentEnd(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag that the point is the end of a segment.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SegmentEnd(self, *args)

    def SetIndex(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Sets the index of the supporting curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetIndex(self, *args)

    def SetParameter(self, *args):
        r"""

        Parameters
        ----------
        Parameter: float

        Return
        -------
        None

        Description
        -----------
        Sets the parameter on the curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetParameter(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        Position: TopAbs_Orientation

        Return
        -------
        None

        Description
        -----------
        Sets the position of the point on the curve.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetPosition(self, *args)

    def SetSegmentBeginning(self, *args):
        r"""

        Parameters
        ----------
        State: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets the flag that the point is the beginning of a segment.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetSegmentBeginning(self, *args)

    def SetSegmentEnd(self, *args):
        r"""

        Parameters
        ----------
        State: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets the flag that the point is the end of a segment.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetSegmentEnd(self, *args)

    def SetStateAfter(self, *args):
        r"""

        Parameters
        ----------
        State: TopAbs_State

        Return
        -------
        None

        Description
        -----------
        Sets the transition state after the intersection.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetStateAfter(self, *args)

    def SetStateBefore(self, *args):
        r"""

        Parameters
        ----------
        State: TopAbs_State

        Return
        -------
        None

        Description
        -----------
        Sets the transition state before the intersection.

        """
        return _HatchGen.HatchGen_IntersectionPoint_SetStateBefore(self, *args)

    def StateAfter(self, *args):
        r"""
        Return
        -------
        TopAbs_State

        Description
        -----------
        Returns the transition state after of the intersection.

        """
        return _HatchGen.HatchGen_IntersectionPoint_StateAfter(self, *args)

    def StateBefore(self, *args):
        r"""
        Return
        -------
        TopAbs_State

        Description
        -----------
        Returns the transition state before the intersection.

        """
        return _HatchGen.HatchGen_IntersectionPoint_StateBefore(self, *args)

    __repr__ = _dumps_object


# Register HatchGen_IntersectionPoint in _HatchGen:
_HatchGen.HatchGen_IntersectionPoint_swigregister(HatchGen_IntersectionPoint)
class HatchGen_PointOnElement(HatchGen_IntersectionPoint):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        ---purpose; creates an empty point on element.

        Parameters
        ----------
        Point: IntRes2d_IntersectionPoint

        Return
        -------
        None

        Description
        -----------
        Creates a point from an intersection point.

        """
        _HatchGen.HatchGen_PointOnElement_swiginit(self, _HatchGen.new_HatchGen_PointOnElement(*args))

    def IntersectionType(self, *args):
        r"""
        Return
        -------
        HatchGen_IntersectionType

        Description
        -----------
        Returns the intersection type at this point.

        """
        return _HatchGen.HatchGen_PointOnElement_IntersectionType(self, *args)

    def IsDifferent(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnElement
        Confusion: float

        Return
        -------
        bool

        Description
        -----------
        Tests if the point is different from an other.

        """
        return _HatchGen.HatchGen_PointOnElement_IsDifferent(self, *args)

    def IsIdentical(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnElement
        Confusion: float

        Return
        -------
        bool

        Description
        -----------
        Tests if the point is identical to an other. that is to say: p1.myindex = p2.myindex abs (p1.myparam - p2.myparam) <= confusion p1.myposit = p2.myposit p1.mybefore = p2.mybefore p1.myafter = p2.myafter p1.mysegbeg = p2.mysegbeg p1.mysegend = p2.mysegend p1.mytype = p2.mytype.

        """
        return _HatchGen.HatchGen_PointOnElement_IsIdentical(self, *args)

    def SetIntersectionType(self, *args):
        r"""

        Parameters
        ----------
        Type: HatchGen_IntersectionType

        Return
        -------
        None

        Description
        -----------
        Sets the intersection type at this point.

        """
        return _HatchGen.HatchGen_PointOnElement_SetIntersectionType(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _HatchGen.delete_HatchGen_PointOnElement

# Register HatchGen_PointOnElement in _HatchGen:
_HatchGen.HatchGen_PointOnElement_swigregister(HatchGen_PointOnElement)
class HatchGen_PointOnHatching(HatchGen_IntersectionPoint):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty point.

        Parameters
        ----------
        Point: IntRes2d_IntersectionPoint

        Return
        -------
        None

        Description
        -----------
        Creates a point from an intersection point.

        """
        _HatchGen.HatchGen_PointOnHatching_swiginit(self, _HatchGen.new_HatchGen_PointOnHatching(*args))

    def AddPoint(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnElement
        Confusion: float

        Return
        -------
        None

        Description
        -----------
        Adds a point on element to the point.

        """
        return _HatchGen.HatchGen_PointOnHatching_AddPoint(self, *args)

    def ClrPoints(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Removes all the points on element of the point.

        """
        return _HatchGen.HatchGen_PointOnHatching_ClrPoints(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnHatching
        Confusion: float

        Return
        -------
        bool

        Description
        -----------
        Tests if the point is equal to an other. a point on hatching p1 is said to be equal to an other p2 if: | p2.myparam - p1.myparam | <= confusion.

        """
        return _HatchGen.HatchGen_PointOnHatching_IsEqual(self, *args)

    def IsGreater(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnHatching
        Confusion: float

        Return
        -------
        bool

        Description
        -----------
        Tests if the point is greater than an other. a point on hatching p1 is said to be greater than an other p2 if: p1.myparam - p2.myparam > confusion.

        """
        return _HatchGen.HatchGen_PointOnHatching_IsGreater(self, *args)

    def IsLower(self, *args):
        r"""

        Parameters
        ----------
        Point: HatchGen_PointOnHatching
        Confusion: float

        Return
        -------
        bool

        Description
        -----------
        Tests if the point is lower than an other. a point on hatching p1 is said to be lower than an other p2 if: p2.myparam - p1.myparam > confusion.

        """
        return _HatchGen.HatchGen_PointOnHatching_IsLower(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of elements intersecting the hatching at this point.

        """
        return _HatchGen.HatchGen_PointOnHatching_NbPoints(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        HatchGen_PointOnElement

        Description
        -----------
        Returns the index-th point on element of the point. the exception outofrange is raised if index > nbpoints.

        """
        return _HatchGen.HatchGen_PointOnHatching_Point(self, *args)

    def RemPoint(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Removes the index-th point on element of the point. the exception outofrange is raised if index > nbpoints.

        """
        return _HatchGen.HatchGen_PointOnHatching_RemPoint(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _HatchGen.delete_HatchGen_PointOnHatching

# Register HatchGen_PointOnHatching in _HatchGen:
_HatchGen.HatchGen_PointOnHatching_swigregister(HatchGen_PointOnHatching)



