# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
MoniTool module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_monitool.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _MoniTool
else:
    import _MoniTool

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MoniTool.delete_SwigPyIterator

    def value(self):
        return _MoniTool.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _MoniTool.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _MoniTool.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _MoniTool.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _MoniTool.SwigPyIterator_equal(self, x)

    def copy(self):
        return _MoniTool.SwigPyIterator_copy(self)

    def next(self):
        return _MoniTool.SwigPyIterator_next(self)

    def __next__(self):
        return _MoniTool.SwigPyIterator___next__(self)

    def previous(self):
        return _MoniTool.SwigPyIterator_previous(self)

    def advance(self, n):
        return _MoniTool.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _MoniTool.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _MoniTool.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _MoniTool.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _MoniTool.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _MoniTool.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _MoniTool.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _MoniTool:
_MoniTool.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _MoniTool.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _MoniTool.ios_base_erase_event
    imbue_event = _MoniTool.ios_base_imbue_event
    copyfmt_event = _MoniTool.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _MoniTool.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _MoniTool.ios_base_flags(self, *args)

    def setf(self, *args):
        return _MoniTool.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _MoniTool.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _MoniTool.ios_base_precision(self, *args)

    def width(self, *args):
        return _MoniTool.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _MoniTool.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _MoniTool.ios_base_imbue(self, __loc)

    def getloc(self):
        return _MoniTool.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _MoniTool.ios_base_xalloc()

    def iword(self, __ix):
        return _MoniTool.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _MoniTool.ios_base_pword(self, __ix)
    __swig_destroy__ = _MoniTool.delete_ios_base

# Register ios_base in _MoniTool:
_MoniTool.ios_base_swigregister(ios_base)
cvar = _MoniTool.cvar
ios_base.boolalpha = _MoniTool.cvar.ios_base_boolalpha
ios_base.dec = _MoniTool.cvar.ios_base_dec
ios_base.fixed = _MoniTool.cvar.ios_base_fixed
ios_base.hex = _MoniTool.cvar.ios_base_hex
ios_base.internal = _MoniTool.cvar.ios_base_internal
ios_base.left = _MoniTool.cvar.ios_base_left
ios_base.oct = _MoniTool.cvar.ios_base_oct
ios_base.right = _MoniTool.cvar.ios_base_right
ios_base.scientific = _MoniTool.cvar.ios_base_scientific
ios_base.showbase = _MoniTool.cvar.ios_base_showbase
ios_base.showpoint = _MoniTool.cvar.ios_base_showpoint
ios_base.showpos = _MoniTool.cvar.ios_base_showpos
ios_base.skipws = _MoniTool.cvar.ios_base_skipws
ios_base.unitbuf = _MoniTool.cvar.ios_base_unitbuf
ios_base.uppercase = _MoniTool.cvar.ios_base_uppercase
ios_base.adjustfield = _MoniTool.cvar.ios_base_adjustfield
ios_base.basefield = _MoniTool.cvar.ios_base_basefield
ios_base.floatfield = _MoniTool.cvar.ios_base_floatfield
ios_base.badbit = _MoniTool.cvar.ios_base_badbit
ios_base.eofbit = _MoniTool.cvar.ios_base_eofbit
ios_base.failbit = _MoniTool.cvar.ios_base_failbit
ios_base.goodbit = _MoniTool.cvar.ios_base_goodbit
ios_base.app = _MoniTool.cvar.ios_base_app
ios_base.ate = _MoniTool.cvar.ios_base_ate
ios_base.binary = _MoniTool.cvar.ios_base_binary
ios_base.ios_base_in = _MoniTool.cvar.ios_base_ios_base_in
ios_base.out = _MoniTool.cvar.ios_base_out
ios_base.trunc = _MoniTool.cvar.ios_base_trunc
ios_base.beg = _MoniTool.cvar.ios_base_beg
ios_base.cur = _MoniTool.cvar.ios_base_cur
ios_base.end = _MoniTool.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _MoniTool.ios_rdstate(self)

    def clear(self, *args):
        return _MoniTool.ios_clear(self, *args)

    def setstate(self, __state):
        return _MoniTool.ios_setstate(self, __state)

    def good(self):
        return _MoniTool.ios_good(self)

    def eof(self):
        return _MoniTool.ios_eof(self)

    def fail(self):
        return _MoniTool.ios_fail(self)

    def bad(self):
        return _MoniTool.ios_bad(self)

    def exceptions(self, *args):
        return _MoniTool.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _MoniTool.ios_swiginit(self, _MoniTool.new_ios(__sb))
    __swig_destroy__ = _MoniTool.delete_ios

    def tie(self, *args):
        return _MoniTool.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _MoniTool.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _MoniTool.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _MoniTool.ios_fill(self, *args)

    def imbue(self, __loc):
        return _MoniTool.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _MoniTool.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _MoniTool.ios_widen(self, __c)

# Register ios in _MoniTool:
_MoniTool.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _MoniTool.ostream_swiginit(self, _MoniTool.new_ostream(__sb))
    __swig_destroy__ = _MoniTool.delete_ostream

    def __lshift__(self, *args):
        return _MoniTool.ostream___lshift__(self, *args)

    def put(self, __c):
        return _MoniTool.ostream_put(self, __c)

    def write(self, __s, __n):
        return _MoniTool.ostream_write(self, __s, __n)

    def flush(self):
        return _MoniTool.ostream_flush(self)

    def tellp(self):
        return _MoniTool.ostream_tellp(self)

    def seekp(self, *args):
        return _MoniTool.ostream_seekp(self, *args)

# Register ostream in _MoniTool:
_MoniTool.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _MoniTool.istream_swiginit(self, _MoniTool.new_istream(__sb))
    __swig_destroy__ = _MoniTool.delete_istream

    def __rshift__(self, *args):
        return _MoniTool.istream___rshift__(self, *args)

    def gcount(self):
        return _MoniTool.istream_gcount(self)

    def get(self, *args):
        return _MoniTool.istream_get(self, *args)

    def getline(self, *args):
        return _MoniTool.istream_getline(self, *args)

    def ignore(self, *args):
        return _MoniTool.istream_ignore(self, *args)

    def peek(self):
        return _MoniTool.istream_peek(self)

    def read(self, __s, __n):
        return _MoniTool.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _MoniTool.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _MoniTool.istream_putback(self, __c)

    def unget(self):
        return _MoniTool.istream_unget(self)

    def sync(self):
        return _MoniTool.istream_sync(self)

    def tellg(self):
        return _MoniTool.istream_tellg(self)

    def seekg(self, *args):
        return _MoniTool.istream_seekg(self, *args)

# Register istream in _MoniTool:
_MoniTool.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _MoniTool.iostream_swiginit(self, _MoniTool.new_iostream(__sb))
    __swig_destroy__ = _MoniTool.delete_iostream

# Register iostream in _MoniTool:
_MoniTool.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _MoniTool.endl_cb_ptr
endl = _MoniTool.endl
ends_cb_ptr = _MoniTool.ends_cb_ptr
ends = _MoniTool.ends
flush_cb_ptr = _MoniTool.flush_cb_ptr
flush = _MoniTool.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *

MoniTool_ValueMisc = _MoniTool.MoniTool_ValueMisc
MoniTool_ValueInteger = _MoniTool.MoniTool_ValueInteger
MoniTool_ValueReal = _MoniTool.MoniTool_ValueReal
MoniTool_ValueIdent = _MoniTool.MoniTool_ValueIdent
MoniTool_ValueVoid = _MoniTool.MoniTool_ValueVoid
MoniTool_ValueText = _MoniTool.MoniTool_ValueText
MoniTool_ValueEnum = _MoniTool.MoniTool_ValueEnum
MoniTool_ValueLogical = _MoniTool.MoniTool_ValueLogical
MoniTool_ValueSub = _MoniTool.MoniTool_ValueSub
MoniTool_ValueHexa = _MoniTool.MoniTool_ValueHexa
MoniTool_ValueBinary = _MoniTool.MoniTool_ValueBinary


class MoniTool_ValueType(IntEnum):
	MoniTool_ValueMisc = 0
	MoniTool_ValueInteger = 1
	MoniTool_ValueReal = 2
	MoniTool_ValueIdent = 3
	MoniTool_ValueVoid = 4
	MoniTool_ValueText = 5
	MoniTool_ValueEnum = 6
	MoniTool_ValueLogical = 7
	MoniTool_ValueSub = 8
	MoniTool_ValueHexa = 9
	MoniTool_ValueBinary = 10
MoniTool_ValueMisc = MoniTool_ValueType.MoniTool_ValueMisc
MoniTool_ValueInteger = MoniTool_ValueType.MoniTool_ValueInteger
MoniTool_ValueReal = MoniTool_ValueType.MoniTool_ValueReal
MoniTool_ValueIdent = MoniTool_ValueType.MoniTool_ValueIdent
MoniTool_ValueVoid = MoniTool_ValueType.MoniTool_ValueVoid
MoniTool_ValueText = MoniTool_ValueType.MoniTool_ValueText
MoniTool_ValueEnum = MoniTool_ValueType.MoniTool_ValueEnum
MoniTool_ValueLogical = MoniTool_ValueType.MoniTool_ValueLogical
MoniTool_ValueSub = MoniTool_ValueType.MoniTool_ValueSub
MoniTool_ValueHexa = MoniTool_ValueType.MoniTool_ValueHexa
MoniTool_ValueBinary = MoniTool_ValueType.MoniTool_ValueBinary


def Handle_MoniTool_CaseData_Create():
    return _MoniTool.Handle_MoniTool_CaseData_Create()

def Handle_MoniTool_CaseData_DownCast(t):
    return _MoniTool.Handle_MoniTool_CaseData_DownCast(t)

def Handle_MoniTool_CaseData_IsNull(t):
    return _MoniTool.Handle_MoniTool_CaseData_IsNull(t)

def Handle_MoniTool_Element_Create():
    return _MoniTool.Handle_MoniTool_Element_Create()

def Handle_MoniTool_Element_DownCast(t):
    return _MoniTool.Handle_MoniTool_Element_DownCast(t)

def Handle_MoniTool_Element_IsNull(t):
    return _MoniTool.Handle_MoniTool_Element_IsNull(t)

def Handle_MoniTool_IntVal_Create():
    return _MoniTool.Handle_MoniTool_IntVal_Create()

def Handle_MoniTool_IntVal_DownCast(t):
    return _MoniTool.Handle_MoniTool_IntVal_DownCast(t)

def Handle_MoniTool_IntVal_IsNull(t):
    return _MoniTool.Handle_MoniTool_IntVal_IsNull(t)

def Handle_MoniTool_RealVal_Create():
    return _MoniTool.Handle_MoniTool_RealVal_Create()

def Handle_MoniTool_RealVal_DownCast(t):
    return _MoniTool.Handle_MoniTool_RealVal_DownCast(t)

def Handle_MoniTool_RealVal_IsNull(t):
    return _MoniTool.Handle_MoniTool_RealVal_IsNull(t)

def Handle_MoniTool_SignText_Create():
    return _MoniTool.Handle_MoniTool_SignText_Create()

def Handle_MoniTool_SignText_DownCast(t):
    return _MoniTool.Handle_MoniTool_SignText_DownCast(t)

def Handle_MoniTool_SignText_IsNull(t):
    return _MoniTool.Handle_MoniTool_SignText_IsNull(t)

def Handle_MoniTool_Timer_Create():
    return _MoniTool.Handle_MoniTool_Timer_Create()

def Handle_MoniTool_Timer_DownCast(t):
    return _MoniTool.Handle_MoniTool_Timer_DownCast(t)

def Handle_MoniTool_Timer_IsNull(t):
    return _MoniTool.Handle_MoniTool_Timer_IsNull(t)

def Handle_MoniTool_TypedValue_Create():
    return _MoniTool.Handle_MoniTool_TypedValue_Create()

def Handle_MoniTool_TypedValue_DownCast(t):
    return _MoniTool.Handle_MoniTool_TypedValue_DownCast(t)

def Handle_MoniTool_TypedValue_IsNull(t):
    return _MoniTool.Handle_MoniTool_TypedValue_IsNull(t)

def Handle_MoniTool_SignShape_Create():
    return _MoniTool.Handle_MoniTool_SignShape_Create()

def Handle_MoniTool_SignShape_DownCast(t):
    return _MoniTool.Handle_MoniTool_SignShape_DownCast(t)

def Handle_MoniTool_SignShape_IsNull(t):
    return _MoniTool.Handle_MoniTool_SignShape_IsNull(t)

def Handle_MoniTool_TransientElem_Create():
    return _MoniTool.Handle_MoniTool_TransientElem_Create()

def Handle_MoniTool_TransientElem_DownCast(t):
    return _MoniTool.Handle_MoniTool_TransientElem_DownCast(t)

def Handle_MoniTool_TransientElem_IsNull(t):
    return _MoniTool.Handle_MoniTool_TransientElem_IsNull(t)

def Handle_MoniTool_HSequenceOfElement_Create():
    return _MoniTool.Handle_MoniTool_HSequenceOfElement_Create()

def Handle_MoniTool_HSequenceOfElement_DownCast(t):
    return _MoniTool.Handle_MoniTool_HSequenceOfElement_DownCast(t)

def Handle_MoniTool_HSequenceOfElement_IsNull(t):
    return _MoniTool.Handle_MoniTool_HSequenceOfElement_IsNull(t)
class MoniTool_DataMapOfShapeTransient(OCC.Core.NCollection.NCollection_BaseMap):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_begin(self)

    def end(self):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_end(self)

    def cbegin(self):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_cbegin(self)

    def cend(self):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_cend(self)

    def __init__(self, *args):
        _MoniTool.MoniTool_DataMapOfShapeTransient_swiginit(self, _MoniTool.new_MoniTool_DataMapOfShapeTransient(*args))

    def Exchange(self, theOther):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Exchange(self, theOther)

    def Assign(self, theOther):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Assign(self, theOther)

    def Set(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Set(self, *args)

    def ReSize(self, N):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_ReSize(self, N)

    def Bind(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Bind(self, *args)

    def Bound(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Bound(self, *args)

    def IsBound(self, theKey):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_UnBind(self, theKey)

    def Seek(self, theKey):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Seek(self, theKey)

    def Find(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient___call__(self, *args)

    def Clear(self, *args):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Clear(self, *args)
    __swig_destroy__ = _MoniTool.delete_MoniTool_DataMapOfShapeTransient

    def Size(self):
        return _MoniTool.MoniTool_DataMapOfShapeTransient_Size(self)

# Register MoniTool_DataMapOfShapeTransient in _MoniTool:
_MoniTool.MoniTool_DataMapOfShapeTransient_swigregister(MoniTool_DataMapOfShapeTransient)
class MoniTool_DataMapOfTimer(OCC.Core.NCollection.NCollection_BaseMap):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _MoniTool.MoniTool_DataMapOfTimer_begin(self)

    def end(self):
        return _MoniTool.MoniTool_DataMapOfTimer_end(self)

    def cbegin(self):
        return _MoniTool.MoniTool_DataMapOfTimer_cbegin(self)

    def cend(self):
        return _MoniTool.MoniTool_DataMapOfTimer_cend(self)

    def __init__(self, *args):
        _MoniTool.MoniTool_DataMapOfTimer_swiginit(self, _MoniTool.new_MoniTool_DataMapOfTimer(*args))

    def Exchange(self, theOther):
        return _MoniTool.MoniTool_DataMapOfTimer_Exchange(self, theOther)

    def Assign(self, theOther):
        return _MoniTool.MoniTool_DataMapOfTimer_Assign(self, theOther)

    def Set(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer_Set(self, *args)

    def ReSize(self, N):
        return _MoniTool.MoniTool_DataMapOfTimer_ReSize(self, N)

    def Bind(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer_Bind(self, *args)

    def Bound(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer_Bound(self, *args)

    def IsBound(self, theKey):
        return _MoniTool.MoniTool_DataMapOfTimer_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _MoniTool.MoniTool_DataMapOfTimer_UnBind(self, theKey)

    def Seek(self, theKey):
        return _MoniTool.MoniTool_DataMapOfTimer_Seek(self, theKey)

    def Find(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _MoniTool.MoniTool_DataMapOfTimer_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _MoniTool.MoniTool_DataMapOfTimer_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer___call__(self, *args)

    def Clear(self, *args):
        return _MoniTool.MoniTool_DataMapOfTimer_Clear(self, *args)
    __swig_destroy__ = _MoniTool.delete_MoniTool_DataMapOfTimer

    def Size(self):
        return _MoniTool.MoniTool_DataMapOfTimer_Size(self)

# Register MoniTool_DataMapOfTimer in _MoniTool:
_MoniTool.MoniTool_DataMapOfTimer_swigregister(MoniTool_DataMapOfTimer)
class MoniTool_IndexedDataMapOfShapeTransient(OCC.Core.NCollection.NCollection_BaseMap):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_begin(self)

    def end(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_end(self)

    def cbegin(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_cbegin(self)

    def cend(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_cend(self)

    def __init__(self, *args):
        _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_swiginit(self, _MoniTool.new_MoniTool_IndexedDataMapOfShapeTransient(*args))

    def Exchange(self, theOther):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Exchange(self, theOther)

    def Assign(self, theOther):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Assign(self, theOther)

    def Set(self, *args):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Set(self, *args)

    def ReSize(self, N):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_ReSize(self, N)

    def Add(self, *args):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Add(self, *args)

    def Contains(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Contains(self, theKey1)

    def Substitute(self, theIndex, theKey1, theItem):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Substitute(self, theIndex, theKey1, theItem)

    def Swap(self, theIndex1, theIndex2):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Swap(self, theIndex1, theIndex2)

    def RemoveLast(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_RemoveLast(self)

    def RemoveFromIndex(self, theIndex):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_RemoveFromIndex(self, theIndex)

    def RemoveKey(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_RemoveKey(self, theKey1)

    def FindKey(self, theIndex):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_FindKey(self, theIndex)

    def FindFromIndex(self, theIndex):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_FindFromIndex(self, theIndex)

    def ChangeFromIndex(self, theIndex):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_ChangeFromIndex(self, theIndex)

    def __call__(self, *args):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient___call__(self, *args)

    def FindIndex(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_FindIndex(self, theKey1)

    def ChangeFromKey(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_ChangeFromKey(self, theKey1)

    def Seek(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Seek(self, theKey1)

    def ChangeSeek(self, theKey1):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_ChangeSeek(self, theKey1)

    def FindFromKey(self, *args):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_FindFromKey(self, *args)

    def Clear(self, *args):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Clear(self, *args)
    __swig_destroy__ = _MoniTool.delete_MoniTool_IndexedDataMapOfShapeTransient

    def Size(self):
        return _MoniTool.MoniTool_IndexedDataMapOfShapeTransient_Size(self)

# Register MoniTool_IndexedDataMapOfShapeTransient in _MoniTool:
_MoniTool.MoniTool_IndexedDataMapOfShapeTransient_swigregister(MoniTool_IndexedDataMapOfShapeTransient)
class MoniTool_SequenceOfElement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _MoniTool.MoniTool_SequenceOfElement_begin(self)

    def end(self):
        return _MoniTool.MoniTool_SequenceOfElement_end(self)

    def cbegin(self):
        return _MoniTool.MoniTool_SequenceOfElement_cbegin(self)

    def cend(self):
        return _MoniTool.MoniTool_SequenceOfElement_cend(self)

    def __init__(self, *args):
        _MoniTool.MoniTool_SequenceOfElement_swiginit(self, _MoniTool.new_MoniTool_SequenceOfElement(*args))

    def Size(self):
        return _MoniTool.MoniTool_SequenceOfElement_Size(self)

    def Length(self):
        return _MoniTool.MoniTool_SequenceOfElement_Length(self)

    def Lower(self):
        return _MoniTool.MoniTool_SequenceOfElement_Lower(self)

    def Upper(self):
        return _MoniTool.MoniTool_SequenceOfElement_Upper(self)

    def IsEmpty(self):
        return _MoniTool.MoniTool_SequenceOfElement_IsEmpty(self)

    def Reverse(self):
        return _MoniTool.MoniTool_SequenceOfElement_Reverse(self)

    def Exchange(self, I, J):
        return _MoniTool.MoniTool_SequenceOfElement_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _MoniTool.MoniTool_SequenceOfElement_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _MoniTool.MoniTool_SequenceOfElement_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _MoniTool.MoniTool_SequenceOfElement_Assign(self, theOther)

    def Set(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_Set(self, *args)

    def Remove(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_Remove(self, *args)

    def Append(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_Append(self, *args)

    def Prepend(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _MoniTool.MoniTool_SequenceOfElement_Split(self, theIndex, theSeq)

    def First(self):
        return _MoniTool.MoniTool_SequenceOfElement_First(self)

    def ChangeFirst(self):
        return _MoniTool.MoniTool_SequenceOfElement_ChangeFirst(self)

    def Last(self):
        return _MoniTool.MoniTool_SequenceOfElement_Last(self)

    def ChangeLast(self):
        return _MoniTool.MoniTool_SequenceOfElement_ChangeLast(self)

    def Value(self, theIndex):
        return _MoniTool.MoniTool_SequenceOfElement_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _MoniTool.MoniTool_SequenceOfElement_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _MoniTool.MoniTool_SequenceOfElement___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _MoniTool.MoniTool_SequenceOfElement_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _MoniTool.delete_MoniTool_SequenceOfElement

    def __len__(self):
        return self.Size()


# Register MoniTool_SequenceOfElement in _MoniTool:
_MoniTool.MoniTool_SequenceOfElement_swigregister(MoniTool_SequenceOfElement)
class MoniTool_AttrList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an attrlist, empty.

        Parameters
        ----------
        other: MoniTool_AttrList

        Return
        -------
        None

        Description
        -----------
        Creates an attrlist from another one, definitions are shared (calls sameattributes).

        """
        _MoniTool.MoniTool_AttrList_swiginit(self, _MoniTool.new_MoniTool_AttrList(*args))

    def AttrList(self, *args):
        r"""
        Return
        -------
        NCollection_DataMap<TCollection_AsciiString, opencascade::handle<Standard_Transient>>

        Description
        -----------
        Returns the exhaustive list of attributes.

        """
        return _MoniTool.MoniTool_AttrList_AttrList(self, *args)

    def Attribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns an attribute from its name. null handle if not recorded (whatever transient, integer, real ...) integer is recorded as intval real is recorded as realval text is recorded as hasciistring.

        """
        return _MoniTool.MoniTool_AttrList_Attribute(self, *args)

    def AttributeType(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        MoniTool_ValueType

        Description
        -----------
        Returns the type of an attribute: valueint , valuereal , valuetext (string) , valueident (any) or valuevoid (not recorded).

        """
        return _MoniTool.MoniTool_AttrList_AttributeType(self, *args)

    def GetAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        type: Standard_Type
        val: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns an attribute from its name, filtered by a type if no attribute has this name, or if it is not kind of this type, <val> is null and returned value is false else, it is true.

        """
        return _MoniTool.MoniTool_AttrList_GetAttribute(self, *args)

    def GetAttributes(self, *args):
        r"""

        Parameters
        ----------
        other: MoniTool_AttrList
        fromname: str (optional, default to )
        copied: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Gets the list of attributes from <other>, by copying it by default, considers all the attributes from <other> if <fromname> is given, considers only the attributes with name beginning by <fromname> //! for each attribute, if <copied> is true (d), its value is also copied if it is a basic type (integer,real,string), else it remains shared between <other> and <self> //! these new attributes are added to the existing ones in <self>, in case of same name, they replace the existing ones.

        """
        return _MoniTool.MoniTool_AttrList_GetAttributes(self, *args)

    def GetIntegerAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        val: int

        Description
        -----------
        Returns an attribute from its name, as integer if no attribute has this name, or not an integer, <val> is 0 and returned value is false else, it is true.

        """
        return _MoniTool.MoniTool_AttrList_GetIntegerAttribute(self, *args)

    def GetRealAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        val: float

        Description
        -----------
        Returns an attribute from its name, as real if no attribute has this name, or not a real <val> is 0.0 and returned value is false else, it is true.

        """
        return _MoniTool.MoniTool_AttrList_GetRealAttribute(self, *args)

    def GetStringAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: str

        Return
        -------
        bool

        Description
        -----------
        Returns an attribute from its name, as string if no attribute has this name, or not a string <val> is 0.0 and returned value is false else, it is true.

        """
        return _MoniTool.MoniTool_AttrList_GetStringAttribute(self, *args)

    def IntegerAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        int

        Description
        -----------
        Returns an integer attribute from its name. 0 if not recorded.

        """
        return _MoniTool.MoniTool_AttrList_IntegerAttribute(self, *args)

    def RealAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        float

        Description
        -----------
        Returns a real attribute from its name. 0.0 if not recorded.

        """
        return _MoniTool.MoniTool_AttrList_RealAttribute(self, *args)

    def RemoveAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        bool

        Description
        -----------
        Removes an attribute returns true when done, false if this attribute did not exist.

        """
        return _MoniTool.MoniTool_AttrList_RemoveAttribute(self, *args)

    def SameAttributes(self, *args):
        r"""

        Parameters
        ----------
        other: MoniTool_AttrList

        Return
        -------
        None

        Description
        -----------
        Gets the list of attributes from <other>, as such, i.e. not copied: attributes are shared, any attribute edited, added, or removed in <other> is also in <self> and vice versa the former list of attributes of <self> is dropped.

        """
        return _MoniTool.MoniTool_AttrList_SameAttributes(self, *args)

    def SetAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Adds an attribute with a given name (replaces the former one with the same name if already exists).

        """
        return _MoniTool.MoniTool_AttrList_SetAttribute(self, *args)

    def SetIntegerAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: int

        Return
        -------
        None

        Description
        -----------
        Adds an integer value for an attribute.

        """
        return _MoniTool.MoniTool_AttrList_SetIntegerAttribute(self, *args)

    def SetRealAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: float

        Return
        -------
        None

        Description
        -----------
        Adds a real value for an attribute.

        """
        return _MoniTool.MoniTool_AttrList_SetRealAttribute(self, *args)

    def SetStringAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: str

        Return
        -------
        None

        Description
        -----------
        Adds a string value for an attribute.

        """
        return _MoniTool.MoniTool_AttrList_SetStringAttribute(self, *args)

    def StringAttribute(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        str

        Description
        -----------
        Returns a string attribute from its name. '' if not recorded.

        """
        return _MoniTool.MoniTool_AttrList_StringAttribute(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_AttrList

# Register MoniTool_AttrList in _MoniTool:
_MoniTool.MoniTool_AttrList_swigregister(MoniTool_AttrList)
class MoniTool_CaseData(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        caseid: str (optional, default to )
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Creates a casedata with a caseid and a name (by default not defined).

        """
        _MoniTool.MoniTool_CaseData_swiginit(self, _MoniTool.new_MoniTool_CaseData(*args))

    def AddAny(self, *args):
        r"""

        Parameters
        ----------
        val: Standard_Transient
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a transient, with no more meaning.

        """
        return _MoniTool.MoniTool_CaseData_AddAny(self, *args)

    def AddCPU(self, *args):
        r"""

        Parameters
        ----------
        lastCPU: float
        curCPU: float (optional, default to 0)
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds the cpu time between lastcpu and now if <curcpu> is given, the cpu amount is curcpu-lastcpu else it is currently measured cpu - lastcpu lastcpu has been read by call to getcpu see getcpu to get amount, and largecpu to test large amount.

        """
        return _MoniTool.MoniTool_CaseData_AddCPU(self, *args)

    def AddData(self, *args):
        r"""

        Parameters
        ----------
        val: Standard_Transient
        kind: int
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Unitary adding a data; rather internal.

        """
        return _MoniTool.MoniTool_CaseData_AddData(self, *args)

    def AddEntity(self, *args):
        r"""

        Parameters
        ----------
        ent: Standard_Transient
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a transient, as an entity from an interfacemodel for instance: it will then be printed with the help of a dbpe.

        """
        return _MoniTool.MoniTool_CaseData_AddEntity(self, *args)

    def AddGeom(self, *args):
        r"""

        Parameters
        ----------
        geom: Standard_Transient
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a geometric as a transient (curve, surface ...).

        """
        return _MoniTool.MoniTool_CaseData_AddGeom(self, *args)

    def AddInteger(self, *args):
        r"""

        Parameters
        ----------
        val: int
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds an integer.

        """
        return _MoniTool.MoniTool_CaseData_AddInteger(self, *args)

    def AddRaised(self, *args):
        r"""

        Parameters
        ----------
        theException: Standard_Failure
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds the currently caught exception.

        """
        return _MoniTool.MoniTool_CaseData_AddRaised(self, *args)

    def AddReal(self, *args):
        r"""

        Parameters
        ----------
        val: float
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a real.

        """
        return _MoniTool.MoniTool_CaseData_AddReal(self, *args)

    def AddReals(self, *args):
        r"""

        Parameters
        ----------
        v1: float
        v2: float
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds two reals (for instance, two parameters).

        """
        return _MoniTool.MoniTool_CaseData_AddReals(self, *args)

    def AddShape(self, *args):
        r"""

        Parameters
        ----------
        sh: TopoDS_Shape
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a shape (recorded as a hshape).

        """
        return _MoniTool.MoniTool_CaseData_AddShape(self, *args)

    def AddText(self, *args):
        r"""

        Parameters
        ----------
        text: str
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a text (as hasciistring).

        """
        return _MoniTool.MoniTool_CaseData_AddText(self, *args)

    def AddXY(self, *args):
        r"""

        Parameters
        ----------
        aXY: gp_XY
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a xy.

        """
        return _MoniTool.MoniTool_CaseData_AddXY(self, *args)

    def AddXYZ(self, *args):
        r"""

        Parameters
        ----------
        aXYZ: gp_XYZ
        name: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds a xyz.

        """
        return _MoniTool.MoniTool_CaseData_AddXYZ(self, *args)

    def CaseId(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the caseid.

        """
        return _MoniTool.MoniTool_CaseData_CaseId(self, *args)

    def Data(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns a data item (n0 <nd> in the set <num>).

        """
        return _MoniTool.MoniTool_CaseData_Data(self, *args)

    @staticmethod
    def DefCheck(*args):
        r"""

        Parameters
        ----------
        acode: str

        Return
        -------
        int

        Description
        -----------
        Returns check status for a code: 0 non/info (default), 1 warning, 2 fail //! remark: defcheck is used to set the check status of a casedata when it is attached to a case code, it can be changed later (by setfail, setwarning, resetcheck).

        """
        return _MoniTool.MoniTool_CaseData_DefCheck(*args)

    @staticmethod
    def DefMsg(*args):
        r"""

        Parameters
        ----------
        casecode: str

        Return
        -------
        str

        Description
        -----------
        Returns the message definition for a case code empty if no message attached.

        """
        return _MoniTool.MoniTool_CaseData_DefMsg(*args)

    def GetCPU(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the current amount of cpu this allows to laterly test and record cpu amount its value has to be given to largecpu and addcpu.

        """
        return _MoniTool.MoniTool_CaseData_GetCPU(self, *args)

    def GetData(self, *args):
        r"""

        Parameters
        ----------
        nd: int
        type: Standard_Type
        val: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns a data item, under control of a type if the data item is kind of this type, it is returned in <val> and the returned value is true else, <val> is unchanged and the returned value is false.

        """
        return _MoniTool.MoniTool_CaseData_GetData(self, *args)

    def Integer(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        val: int

        Description
        -----------
        Returns an integer.

        """
        return _MoniTool.MoniTool_CaseData_Integer(self, *args)

    def IsCheck(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if <self> is check (warning or fail), else it is info.

        """
        return _MoniTool.MoniTool_CaseData_IsCheck(self, *args)

    def IsFail(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if <self> is fail.

        """
        return _MoniTool.MoniTool_CaseData_IsFail(self, *args)

    def IsWarning(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if <self> is warning.

        """
        return _MoniTool.MoniTool_CaseData_IsWarning(self, *args)

    def Kind(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        int

        Description
        -----------
        Returns the kind of a data: kind type meaning 0 any any (not one of the following) 1 ex raised exception 2 en entity 3 g geom 4 sh shape 5 xyz xyz 6 xy or uv xy 7 rr 2 reals 8 r 1 real 9 cpu cpu (1 real) 10 t text 11 i integer //! for namenum, these codes for type must be given exact i.e. sh for a shape, not s nor shape nor solid etc.

        """
        return _MoniTool.MoniTool_CaseData_Kind(self, *args)

    def LargeCPU(self, *args):
        r"""

        Parameters
        ----------
        maxCPU: float
        lastCPU: float
        curCPU: float (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Tells if a cpu time amount is large <maxcpu> gives the amount over which an amount is large <lastcpu> gives the start cpu amount if <curcpu> is given, the tested cpu amount is curcpu-lastcpu else it is currently measured cpu - lastcpu.

        """
        return _MoniTool.MoniTool_CaseData_LargeCPU(self, *args)

    def Msg(self, *args):
        r"""
        Return
        -------
        Message_Msg

        Description
        -----------
        Returns a msg from a casedata: it is build from defmsg, which gives the message code plus the designation of items of the casedata to be added to the msg empty if no message attached //! remains to be implemented.

        """
        return _MoniTool.MoniTool_CaseData_Msg(self, *args)

    def Name(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the name.

        Parameters
        ----------
        nd: int

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns the name of a data. if it has no name, the string is empty (length = 0).

        """
        return _MoniTool.MoniTool_CaseData_Name(self, *args)

    def NameNum(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        int

        Description
        -----------
        Returns the first suitable data rank for a given name exact matching (exact case, no completion) is required firstly checks the recorded names if not found, considers the name as follows: name = 'type': search for the first item with this type name = 'type:nn': search for the nn.th item with this type see allowed values in method kind.

        """
        return _MoniTool.MoniTool_CaseData_NameNum(self, *args)

    def NbData(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the count of data recorded to a set.

        """
        return _MoniTool.MoniTool_CaseData_NbData(self, *args)

    def Real(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        val: float

        Description
        -----------
        Returns a real or cpu amount (stored in geom2d_cartesianpoint) (allows an integer converted to a real).

        """
        return _MoniTool.MoniTool_CaseData_Real(self, *args)

    def Reals(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        v1: float
        v2: float

        Description
        -----------
        Returns a couple of reals (stored in geom2d_cartesianpoint).

        """
        return _MoniTool.MoniTool_CaseData_Reals(self, *args)

    def RemoveData(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Removes a data from its rank. does nothing if out of range.

        """
        return _MoniTool.MoniTool_CaseData_RemoveData(self, *args)

    def ResetCheck(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Resets check status, i.e. sets <self> as info.

        """
        return _MoniTool.MoniTool_CaseData_ResetCheck(self, *args)

    def SetCaseId(self, *args):
        r"""

        Parameters
        ----------
        caseid: str

        Return
        -------
        None

        Description
        -----------
        Sets a caseid.

        """
        return _MoniTool.MoniTool_CaseData_SetCaseId(self, *args)

    def SetChange(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the next add... not to add but to change the data item designated by its name. if next add... is not called with a name, setchange is ignored reset by next add... , whatever <num> is correct or not.

        """
        return _MoniTool.MoniTool_CaseData_SetChange(self, *args)

    @staticmethod
    def SetDefFail(*args):
        r"""

        Parameters
        ----------
        acode: str

        Return
        -------
        None

        Description
        -----------
        Sets a code to give a fail.

        """
        return _MoniTool.MoniTool_CaseData_SetDefFail(*args)

    @staticmethod
    def SetDefMsg(*args):
        r"""

        Parameters
        ----------
        casecode: str
        mesdef: str

        Return
        -------
        None

        Description
        -----------
        Attaches a message definition to a case code this definition includes the message code plus designation of items of the casedata to be added to the message (this part not yet implemented).

        """
        return _MoniTool.MoniTool_CaseData_SetDefMsg(*args)

    @staticmethod
    def SetDefWarning(*args):
        r"""

        Parameters
        ----------
        acode: str

        Return
        -------
        None

        Description
        -----------
        Sets a code to give a warning.

        """
        return _MoniTool.MoniTool_CaseData_SetDefWarning(*args)

    def SetFail(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets <self> as fail.

        """
        return _MoniTool.MoniTool_CaseData_SetFail(self, *args)

    def SetName(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        None

        Description
        -----------
        Sets a name.

        """
        return _MoniTool.MoniTool_CaseData_SetName(self, *args)

    def SetReplace(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Sets the next add... not to add but to replace the data item <num>, if <num> is between 1 and nbdata. reset by next add... , whatever <num> is correct or not.

        """
        return _MoniTool.MoniTool_CaseData_SetReplace(self, *args)

    def SetWarning(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets <self> as warning.

        """
        return _MoniTool.MoniTool_CaseData_SetWarning(self, *args)

    def Shape(self, *args):
        r"""

        Parameters
        ----------
        nd: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a data as a shape, null if not a shape.

        """
        return _MoniTool.MoniTool_CaseData_Shape(self, *args)

    def Text(self, *args):
        r"""

        Parameters
        ----------
        nd: int
        text: str

        Return
        -------
        bool

        Description
        -----------
        Returns a text (stored in tcollection_hasciistring).

        """
        return _MoniTool.MoniTool_CaseData_Text(self, *args)

    def XY(self, *args):
        r"""

        Parameters
        ----------
        nd: int
        val: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Returns a data as a xy (i.e. geom2d_cartesianpoint) returns false if not the good type.

        """
        return _MoniTool.MoniTool_CaseData_XY(self, *args)

    def XYZ(self, *args):
        r"""

        Parameters
        ----------
        nd: int
        val: gp_XYZ

        Return
        -------
        bool

        Description
        -----------
        Returns a data as a xyz (i.e. geom_cartesianpoint) returns false if not the good type.

        """
        return _MoniTool.MoniTool_CaseData_XYZ(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_CaseData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_CaseData

# Register MoniTool_CaseData in _MoniTool:
_MoniTool.MoniTool_CaseData_swigregister(MoniTool_CaseData)
class MoniTool_DataInfo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Type(*args):
        r"""

        Parameters
        ----------
        ent: Standard_Transient

        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns the type attached to an object here, the dynamic type of a transient. null type if unknown.

        """
        return _MoniTool.MoniTool_DataInfo_Type(*args)

    @staticmethod
    def TypeName(*args):
        r"""

        Parameters
        ----------
        ent: Standard_Transient

        Return
        -------
        str

        Description
        -----------
        Returns type name (string) allows to name type of non-handled objects.

        """
        return _MoniTool.MoniTool_DataInfo_TypeName(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _MoniTool.MoniTool_DataInfo_swiginit(self, _MoniTool.new_MoniTool_DataInfo())
    __swig_destroy__ = _MoniTool.delete_MoniTool_DataInfo

# Register MoniTool_DataInfo in _MoniTool:
_MoniTool.MoniTool_DataInfo_swigregister(MoniTool_DataInfo)
class MoniTool_Element(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def ChangeAttr(self, *args):
        r"""
        Return
        -------
        MoniTool_AttrList

        Description
        -----------
        Returns (modifiable) the attribute list.

        """
        return _MoniTool.MoniTool_Element_ChangeAttr(self, *args)

    def Equates(self, *args):
        r"""

        Parameters
        ----------
        other: MoniTool_Element

        Return
        -------
        bool

        Description
        -----------
        Specific testof equality: to be defined by each sub-class, must be false if elements have not the same true type, else their contents must be compared.

        """
        return _MoniTool.MoniTool_Element_Equates(self, *args)

    def GetHashCode(self, *args):
        r"""
        Return
        -------
        size_t

        Description
        -----------
        Returns the hashcode which has been stored by sethashcode (remark that hashcode could be deferred then be defined by sub-classes, the result is the same).

        """
        return _MoniTool.MoniTool_Element_GetHashCode(self, *args)

    def ListAttr(self, *args):
        r"""
        Return
        -------
        MoniTool_AttrList

        Description
        -----------
        Returns (readonly) the attribute list.

        """
        return _MoniTool.MoniTool_Element_ListAttr(self, *args)

    def ValueType(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns the type of the value. by default, returns the dynamictype of <self>, but can be redefined.

        """
        return _MoniTool.MoniTool_Element_ValueType(self, *args)

    def ValueTypeName(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the name of the type of the value. default is name of valuetype, unless it is for a non-handled object.

        """
        return _MoniTool.MoniTool_Element_ValueTypeName(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_Element_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_Element

# Register MoniTool_Element in _MoniTool:
_MoniTool.MoniTool_Element_swigregister(MoniTool_Element)
class MoniTool_IntVal(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        val: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _MoniTool.MoniTool_IntVal_swiginit(self, _MoniTool.new_MoniTool_IntVal(*args))

    def GetCValue(self):
        r"""GetCValue(MoniTool_IntVal self) -> Standard_Integer"""
        return _MoniTool.MoniTool_IntVal_GetCValue(self)

    def SetCValue(self, value):
        r"""SetCValue(MoniTool_IntVal self, Standard_Integer value)"""
        return _MoniTool.MoniTool_IntVal_SetCValue(self, value)

    def Value(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_IntVal_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_IntVal_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_IntVal

# Register MoniTool_IntVal in _MoniTool:
_MoniTool.MoniTool_IntVal_swigregister(MoniTool_IntVal)
class MoniTool_RealVal(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        val: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _MoniTool.MoniTool_RealVal_swiginit(self, _MoniTool.new_MoniTool_RealVal(*args))

    def GetCValue(self):
        r"""GetCValue(MoniTool_RealVal self) -> Standard_Real"""
        return _MoniTool.MoniTool_RealVal_GetCValue(self)

    def SetCValue(self, value):
        r"""SetCValue(MoniTool_RealVal self, Standard_Real value)"""
        return _MoniTool.MoniTool_RealVal_SetCValue(self, value)

    def Value(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_RealVal_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_RealVal_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_RealVal

# Register MoniTool_RealVal in _MoniTool:
_MoniTool.MoniTool_RealVal_swigregister(MoniTool_RealVal)
class MoniTool_SignText(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Name(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns an identification of the signature (a word), given at initialization time.

        """
        return _MoniTool.MoniTool_SignText_Name(self, *args)

    def Text(self, *args):
        r"""

        Parameters
        ----------
        ent: Standard_Transient
        context: Standard_Transient

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Gives a text as a signature for a transient object in a context if the context is senseless, it can be given as null handle empty result if nothing to give (at least the dynamictype could be sent ?).

        """
        return _MoniTool.MoniTool_SignText_Text(self, *args)

    def TextAlone(self, *args):
        r"""

        Parameters
        ----------
        ent: Standard_Transient

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Gives a text as a signature for a transient object alone, i.e. without defined context. by default, calls text with undefined context (null handle) and if empty, then returns dynamictype.

        """
        return _MoniTool.MoniTool_SignText_TextAlone(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_SignText_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_SignText

# Register MoniTool_SignText in _MoniTool:
_MoniTool.MoniTool_SignText_swigregister(MoniTool_SignText)
class MoniTool_Stat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        title: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Creates a stat form. at start, one default phase is defined, with one default step. then, it suffises to start with a count of items (and cycles if several) then record items, to have a queryable report.

        Parameters
        ----------
        other: MoniTool_Stat

        Return
        -------
        None

        Description
        -----------
        Used when starting.

        """
        _MoniTool.MoniTool_Stat_swiginit(self, _MoniTool.new_MoniTool_Stat(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        nb: int (optional, default to 1)

        Return
        -------
        None

        Description
        -----------
        Directly adds items.

        """
        return _MoniTool.MoniTool_Stat_Add(self, *args)

    def AddEnd(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Ends the addsub and cumulates the sub-count to current level.

        """
        return _MoniTool.MoniTool_Stat_AddEnd(self, *args)

    def AddSub(self, *args):
        r"""

        Parameters
        ----------
        nb: int (optional, default to 1)

        Return
        -------
        None

        Description
        -----------
        Declares a count of items to be added later. if a sub-counter is opened, its percentage multiplies this sub-count to compute the percent of current level.

        """
        return _MoniTool.MoniTool_Stat_AddSub(self, *args)

    def Close(self, *args):
        r"""

        Parameters
        ----------
        id: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_Stat_Close(self, *args)

    @staticmethod
    def Current(*args):
        r"""
        Return
        -------
        MoniTool_Stat

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_Stat_Current(*args)

    def Level(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_Stat_Level(self, *args)

    def Open(self, *args):
        r"""

        Parameters
        ----------
        nb: int (optional, default to 100)

        Return
        -------
        int

        Description
        -----------
        Opens a new counter with a starting count of items.

        """
        return _MoniTool.MoniTool_Stat_Open(self, *args)

    def OpenMore(self, *args):
        r"""

        Parameters
        ----------
        id: int
        nb: int

        Return
        -------
        None

        Description
        -----------
        Adds more items to be counted by add... on current level.

        """
        return _MoniTool.MoniTool_Stat_OpenMore(self, *args)

    def Percent(self, *args):
        r"""

        Parameters
        ----------
        fromlev: int (optional, default to 0)

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_Stat_Percent(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_Stat

# Register MoniTool_Stat in _MoniTool:
_MoniTool.MoniTool_Stat_swigregister(MoniTool_Stat)
class MoniTool_Timer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Create timer in empty state.

        """
        _MoniTool.MoniTool_Timer_swiginit(self, _MoniTool.new_MoniTool_Timer(*args))

    def Amend(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return value of accumulated amendment on cpu time.

        """
        return _MoniTool.MoniTool_Timer_Amend(self, *args)

    def CPU(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return value of cpu time minus accumulated amendment.

        """
        return _MoniTool.MoniTool_Timer_CPU(self, *args)

    @staticmethod
    def ClearTimers(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears map of timers.

        """
        return _MoniTool.MoniTool_Timer_ClearTimers(*args)

    @staticmethod
    def ComputeAmendments(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes and remembers amendments for times to access, start, and stop of timer, and estimates second-order error measured by 10 nested timers.

        """
        return _MoniTool.MoniTool_Timer_ComputeAmendments(*args)

    def Count(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return value of hits counter (count of start/stop pairs).

        """
        return _MoniTool.MoniTool_Timer_Count(self, *args)

    @staticmethod
    def Dictionary(*args):
        r"""
        Return
        -------
        MoniTool_DataMapOfTimer

        Description
        -----------
        Returns map of timers.

        """
        return _MoniTool.MoniTool_Timer_Dictionary(*args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        ostr: Standard_OStream

        Description
        -----------
        Dumps current state of a timer shortly (one-line output).

        """
        return _MoniTool.MoniTool_Timer_Dump(self, *args)

    @staticmethod
    def DumpTimers(*args):
        r"""

        Parameters
        ----------

        Return
        -------
        ostr: Standard_OStream

        Description
        -----------
        Dumps contents of the whole dictionary.

        """
        return _MoniTool.MoniTool_Timer_DumpTimers(*args)

    @staticmethod
    def GetAmendments(*args):
        r"""

        Parameters
        ----------

        Return
        -------
        Access: float
        Internal: float
        External: float
        Error10: float

        Description
        -----------
        The computed amendmens are returned (for information only).

        """
        return _MoniTool.MoniTool_Timer_GetAmendments(*args)

    def IsRunning(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns value of nesting counter.

        """
        return _MoniTool.MoniTool_Timer_IsRunning(self, *args)

    def Reset(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Start, stop and reset the timer in addition to doing that to embedded osd_timer, manage also counter of hits.

        """
        return _MoniTool.MoniTool_Timer_Reset(self, *args)

    @staticmethod
    def Start(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        name: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_Timer_Start(*args)

    @staticmethod
    def Stop(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        name: str

        Return
        -------
        None

        Description
        -----------
        Inline methods to conveniently start/stop timer by name shortcut to timer(name)->start/stop().

        """
        return _MoniTool.MoniTool_Timer_Stop(*args)

    @staticmethod
    def Timer(*args):
        r"""
        Return
        -------
        OSD_Timer

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<MoniTool_Timer>

        Description
        -----------
        Returns a timer from a dictionary by its name if timer not existed, creates a new one.

        """
        return _MoniTool.MoniTool_Timer_Timer(*args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_Timer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_Timer

# Register MoniTool_Timer in _MoniTool:
_MoniTool.MoniTool_Timer_swigregister(MoniTool_Timer)
class MoniTool_TimerSentry(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        cname: str

        Return
        -------
        None

        Description
        -----------
        Constructor creates an instance and runs the corresponding timer.

        Parameters
        ----------
        timer: MoniTool_Timer

        Return
        -------
        None

        Description
        -----------
        Constructor creates an instance and runs the corresponding timer.

        """
        _MoniTool.MoniTool_TimerSentry_swiginit(self, _MoniTool.new_MoniTool_TimerSentry(*args))

    def Stop(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Manually stops the timer.

        """
        return _MoniTool.MoniTool_TimerSentry_Stop(self, *args)

    def Timer(self, *args):
        r"""
        Return
        -------
        opencascade::handle<MoniTool_Timer>

        Description
        -----------
        No available documentation.

        """
        return _MoniTool.MoniTool_TimerSentry_Timer(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_TimerSentry

# Register MoniTool_TimerSentry in _MoniTool:
_MoniTool.MoniTool_TimerSentry_swigregister(MoniTool_TimerSentry)
class MoniTool_TypedValue(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        name: str
        type: MoniTool_ValueType (optional, default to MoniTool_ValueText)
        init: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Creates a typedvalue, with a name //! type gives the type of the parameter, default is free text also available: integer, real, enum, entity (i.e. object) more precise specifications, titles, can be given to the typedvalue once created //! init gives an initial value. if it is not given, the typedvalue begins as 'not set', its value is empty.

        Parameters
        ----------
        other: MoniTool_TypedValue

        Return
        -------
        None

        Description
        -----------
        Creates a typedvalue from another one, by duplication.

        """
        _MoniTool.MoniTool_TypedValue_swiginit(self, _MoniTool.new_MoniTool_TypedValue(*args))

    def AddDef(self, *args):
        r"""

        Parameters
        ----------
        initext: str

        Return
        -------
        bool

        Description
        -----------
        Completes the definition of a typedvalue by command <initext>, once created with its type returns true if done, false if could not be interpreted <initext> may be: imin ival: minimum value for an integer imax ival: maximum value for an integer rmin rval: minimum value for a real rmax rval: maximum value for a real unit name: name of unit ematch i: enum from integer value i, match required enum i: enum from integer value i, match not required eval text: add an enumerative value (increments max by 1) eval: add a non-authorised enum value (to be skipped) tmax l: maximum length for a text.

        """
        return _MoniTool.MoniTool_TypedValue_AddDef(self, *args)

    def AddEnum(self, *args):
        r"""

        Parameters
        ----------
        v1: str (optional, default to )
        v2: str (optional, default to )
        v3: str (optional, default to )
        v4: str (optional, default to )
        v5: str (optional, default to )
        v6: str (optional, default to )
        v7: str (optional, default to )
        v8: str (optional, default to )
        v9: str (optional, default to )
        v10: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Adds enumerative definitions. for more than 10, several calls.

        """
        return _MoniTool.MoniTool_TypedValue_AddEnum(self, *args)

    def AddEnumValue(self, *args):
        r"""

        Parameters
        ----------
        val: str
        num: int

        Return
        -------
        None

        Description
        -----------
        Adds an enumeration definition, by its string and numeric values. if it is the first setting for this value, it is recorded as main value. else, it is recognized as alternate string for this numeric value.

        """
        return _MoniTool.MoniTool_TypedValue_AddEnumValue(self, *args)

    @staticmethod
    def AddLib(*args):
        r"""

        Parameters
        ----------
        tv: MoniTool_TypedValue
        def: str (optional, default to )

        Return
        -------
        bool

        Description
        -----------
        Adds a typedvalue in the library. it is recorded then will be accessed by its name its definition may be imposed, else it is computed as usual by default it will be accessed by its definition (string) returns true if done, false if tv is null or brings no definition or <def> not defined //! if a typedvalue was already recorded under this name, it is replaced.

        """
        return _MoniTool.MoniTool_TypedValue_AddLib(*args)

    def CStringValue(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the value, as a cstring. empty if not set.

        """
        return _MoniTool.MoniTool_TypedValue_CStringValue(self, *args)

    def ClearValue(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the recorded value: it is now unset.

        """
        return _MoniTool.MoniTool_TypedValue_ClearValue(self, *args)

    def Definition(self, *args):
        r"""
        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns the definition by priority, the enforced one, else an automatic one, computed from the specification.

        """
        return _MoniTool.MoniTool_TypedValue_Definition(self, *args)

    def EnumCase(self, *args):
        r"""

        Parameters
        ----------
        val: str

        Return
        -------
        int

        Description
        -----------
        Returns the case number which corresponds to a string value works with main and additional values returns (startenum - 1) if not ok, -1 if not an enum.

        """
        return _MoniTool.MoniTool_TypedValue_EnumCase(self, *args)

    def EnumDef(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        startcase: int
        endcase: int
        match: bool

        Description
        -----------
        Gives the enum definitions: start value, end value, match status. returns true for an enum, false else.

        """
        return _MoniTool.MoniTool_TypedValue_EnumDef(self, *args)

    def EnumVal(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        str

        Description
        -----------
        Returns the value of an enumerative definition, from its rank empty string if out of range or not an enum.

        """
        return _MoniTool.MoniTool_TypedValue_EnumVal(self, *args)

    @staticmethod
    def FromLib(*args):
        r"""

        Parameters
        ----------
        def: str

        Return
        -------
        opencascade::handle<MoniTool_TypedValue>

        Description
        -----------
        Returns a copy of the typedvalue bound with a given name null handle if none recorded.

        """
        return _MoniTool.MoniTool_TypedValue_FromLib(*args)

    def GetObjectValue(self, *args):
        r"""

        Parameters
        ----------
        val: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Same as objectvalue, but avoids downcast: the receiving variable is directly loaded. it is assumed that it complies with the definition of objecttype ! otherwise, big trouble.

        """
        return _MoniTool.MoniTool_TypedValue_GetObjectValue(self, *args)

    def HStringValue(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the value, as a handle (can then be shared) null if not defined.

        """
        return _MoniTool.MoniTool_TypedValue_HStringValue(self, *args)

    def HasInterpret(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if a typedvalue has an interpret.

        """
        return _MoniTool.MoniTool_TypedValue_HasInterpret(self, *args)

    def IntegerLimit(self, *args):
        r"""

        Parameters
        ----------
        max: bool

        Return
        -------
        val: int

        Description
        -----------
        Gives an integer limit (upper if <max> true, lower if <max> false). returns true if this limit is defined, false else (in that case, gives the natural limit for integer).

        """
        return _MoniTool.MoniTool_TypedValue_IntegerLimit(self, *args)

    def IntegerValue(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value as integer, i.e.: for type = integer, the integer itself; 0 if not set for type = enum, the designated rank (see enum definition) startenum - 1 if not set or not in the definition else, returns 0.

        """
        return _MoniTool.MoniTool_TypedValue_IntegerValue(self, *args)

    def Internals(self, *args):
        r"""

        Parameters
        ----------
        interp: MoniTool_ValueInterpret
        satisf: MoniTool_ValueSatisfies
        satisname: str
        enums: NCollection_DataMap<TCollection_AsciiString, int>

        Return
        -------
        None

        Description
        -----------
        Access to internal data which have no other access.

        """
        return _MoniTool.MoniTool_TypedValue_Internals(self, *args)

    def Interpret(self, *args):
        r"""

        Parameters
        ----------
        hval: TCollection_HAsciiString
        native: bool

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Interprets a value. <native> true: returns a native value <native> false: returns a coded value if the interpret function is set, calls it else, for an enum, native returns the text, coded returns the number standard returns: = hval means no specific interpretation null means senseless can also be redefined.

        """
        return _MoniTool.MoniTool_TypedValue_Interpret(self, *args)

    def IsSetValue(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the value is set (not empty/not null object).

        """
        return _MoniTool.MoniTool_TypedValue_IsSetValue(self, *args)

    def Label(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the label, if set; else returns an empty string.

        """
        return _MoniTool.MoniTool_TypedValue_Label(self, *args)

    @staticmethod
    def Lib(*args):
        r"""

        Parameters
        ----------
        def: str

        Return
        -------
        opencascade::handle<MoniTool_TypedValue>

        Description
        -----------
        Returns the typedvalue bound with a given name null handle if none recorded warning: it is the original, not duplicated.

        """
        return _MoniTool.MoniTool_TypedValue_Lib(*args)

    @staticmethod
    def LibList(*args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfAsciiString>

        Description
        -----------
        Returns the list of names of items of the library of types -- library of typedvalue as valued parameters, -- -- accessed by parameter name for use by management of static parameters.

        """
        return _MoniTool.MoniTool_TypedValue_LibList(*args)

    def MaxLength(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum length, 0 if not set.

        """
        return _MoniTool.MoniTool_TypedValue_MaxLength(self, *args)

    def Name(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the name.

        """
        return _MoniTool.MoniTool_TypedValue_Name(self, *args)

    def ObjectType(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns the type of which an object typedvalue must be kind of default is standard_transient null for a typedvalue not an object.

        """
        return _MoniTool.MoniTool_TypedValue_ObjectType(self, *args)

    def ObjectTypeName(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the type name of the objectvalue, or an empty string if not set.

        """
        return _MoniTool.MoniTool_TypedValue_ObjectTypeName(self, *args)

    def ObjectValue(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns the value as transient object, only for object/entity remark that the 'hstring value' is ignored here null if not set; remains to be casted.

        """
        return _MoniTool.MoniTool_TypedValue_ObjectValue(self, *args)

    def Print(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        S: Standard_OStream

        Description
        -----------
        Prints definition, specification, and actual status and value.

        """
        return _MoniTool.MoniTool_TypedValue_Print(self, *args)

    def PrintValue(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        S: Standard_OStream

        Description
        -----------
        Prints only the value.

        """
        return _MoniTool.MoniTool_TypedValue_PrintValue(self, *args)

    def RealLimit(self, *args):
        r"""

        Parameters
        ----------
        max: bool

        Return
        -------
        val: float

        Description
        -----------
        Gives an real limit (upper if <max> true, lower if <max> false). returns true if this limit is defined, false else (in that case, gives the natural limit for real).

        """
        return _MoniTool.MoniTool_TypedValue_RealLimit(self, *args)

    def RealValue(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value as real, for a real type typedvalue else, returns 0.

        """
        return _MoniTool.MoniTool_TypedValue_RealValue(self, *args)

    def Satisfies(self, *args):
        r"""

        Parameters
        ----------
        hval: TCollection_HAsciiString

        Return
        -------
        bool

        Description
        -----------
        Returns true if a value statifies the specification (remark: does not apply to entity: see objecttype, for this type, the string is just a comment).

        """
        return _MoniTool.MoniTool_TypedValue_Satisfies(self, *args)

    def SatisfiesName(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns name of specific satisfy, empty string if none.

        """
        return _MoniTool.MoniTool_TypedValue_SatisfiesName(self, *args)

    def SetCStringValue(self, *args):
        r"""

        Parameters
        ----------
        val: str

        Return
        -------
        bool

        Description
        -----------
        Changes the value. the new one must satisfy the specification returns false (and did not set) if the new value does not satisfy the specification can be redefined to be managed (in a subclass).

        """
        return _MoniTool.MoniTool_TypedValue_SetCStringValue(self, *args)

    def SetDefinition(self, *args):
        r"""

        Parameters
        ----------
        deftext: str

        Return
        -------
        None

        Description
        -----------
        Enforces a definition.

        """
        return _MoniTool.MoniTool_TypedValue_SetDefinition(self, *args)

    def SetHStringValue(self, *args):
        r"""

        Parameters
        ----------
        hval: TCollection_HAsciiString

        Return
        -------
        bool

        Description
        -----------
        Forces a new handle for the value it can be empty, else (if type is not free text), it must satisfy the specification. not only the value is changed, but also the way it is shared remark: for type=object, this value is not controlled, it can be set as a comment returns false (and did not set) if the new value does not satisfy the specification can be redefined to be managed (in a subclass).

        """
        return _MoniTool.MoniTool_TypedValue_SetHStringValue(self, *args)

    def SetIntegerLimit(self, *args):
        r"""

        Parameters
        ----------
        max: bool
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets an integer limit (included) to <val>, the upper limit if <max> is true, the lower limit if <max> is false.

        """
        return _MoniTool.MoniTool_TypedValue_SetIntegerLimit(self, *args)

    def SetIntegerValue(self, *args):
        r"""

        Parameters
        ----------
        ival: int

        Return
        -------
        bool

        Description
        -----------
        Changes the value as an integer, only for integer or enum.

        """
        return _MoniTool.MoniTool_TypedValue_SetIntegerValue(self, *args)

    def SetInterpret(self, *args):
        r"""

        Parameters
        ----------
        func: MoniTool_ValueInterpret

        Return
        -------
        None

        Description
        -----------
        Sets a specific interpret function.

        """
        return _MoniTool.MoniTool_TypedValue_SetInterpret(self, *args)

    def SetLabel(self, *args):
        r"""

        Parameters
        ----------
        label: str

        Return
        -------
        None

        Description
        -----------
        Sets a label, which can then be displayed.

        """
        return _MoniTool.MoniTool_TypedValue_SetLabel(self, *args)

    def SetMaxLength(self, *args):
        r"""

        Parameters
        ----------
        max: int

        Return
        -------
        None

        Description
        -----------
        Sets a maximum length for a text (active only for a free text).

        """
        return _MoniTool.MoniTool_TypedValue_SetMaxLength(self, *args)

    def SetObjectType(self, *args):
        r"""

        Parameters
        ----------
        typ: Standard_Type

        Return
        -------
        None

        Description
        -----------
        Sets type of which an object typedvalue must be kind of error for a typedvalue not an object (entity).

        """
        return _MoniTool.MoniTool_TypedValue_SetObjectType(self, *args)

    def SetObjectValue(self, *args):
        r"""

        Parameters
        ----------
        obj: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Changes the value as transient object, only for object/entity returns false if dynamictype does not satisfy objecttype can be redefined to be managed (in a subclass).

        """
        return _MoniTool.MoniTool_TypedValue_SetObjectValue(self, *args)

    def SetRealLimit(self, *args):
        r"""

        Parameters
        ----------
        max: bool
        val: float

        Return
        -------
        None

        Description
        -----------
        Sets a real limit (included) to <val>, the upper limit if <max> is true, the lower limit if <max> is false.

        """
        return _MoniTool.MoniTool_TypedValue_SetRealLimit(self, *args)

    def SetRealValue(self, *args):
        r"""

        Parameters
        ----------
        rval: float

        Return
        -------
        bool

        Description
        -----------
        Changes the value as a real, only for real.

        """
        return _MoniTool.MoniTool_TypedValue_SetRealValue(self, *args)

    def SetSatisfies(self, *args):
        r"""

        Parameters
        ----------
        func: MoniTool_ValueSatisfies
        name: str

        Return
        -------
        None

        Description
        -----------
        Sets a specific satisfies function: it is added to the already defined criteria it must match the form: satisfies (val: hasciistring) returns boolean.

        """
        return _MoniTool.MoniTool_TypedValue_SetSatisfies(self, *args)

    def SetUnitDef(self, *args):
        r"""

        Parameters
        ----------
        def: str

        Return
        -------
        None

        Description
        -----------
        Sets (clears if <def> empty) a unit definition, as an equation of dimensions. typedvalue just records this definition, does not exploit it, to be done as required by user applications.

        """
        return _MoniTool.MoniTool_TypedValue_SetUnitDef(self, *args)

    def StartEnum(self, *args):
        r"""

        Parameters
        ----------
        start: int (optional, default to 0)
        match: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        For an enumeration, precises the starting value (default 0) and the match condition: if true (d), the string value must match the definition, else it may take another value: in that case, the integer value will be start - 1. (empty value remains allowed).

        """
        return _MoniTool.MoniTool_TypedValue_StartEnum(self, *args)

    @staticmethod
    def StaticValue(*args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<MoniTool_TypedValue>

        Description
        -----------
        Returns a static value from its name, null if unknown.

        """
        return _MoniTool.MoniTool_TypedValue_StaticValue(*args)

    def UnitDef(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the recorded unit definition, empty if not set.

        """
        return _MoniTool.MoniTool_TypedValue_UnitDef(self, *args)

    def ValueType(self, *args):
        r"""
        Return
        -------
        MoniTool_ValueType

        Description
        -----------
        Returns the type of the value.

        """
        return _MoniTool.MoniTool_TypedValue_ValueType(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_TypedValue_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_TypedValue

# Register MoniTool_TypedValue in _MoniTool:
_MoniTool.MoniTool_TypedValue_swigregister(MoniTool_TypedValue)
class MoniTool_SignShape(MoniTool_SignText):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _MoniTool.MoniTool_SignShape_swiginit(self, _MoniTool.new_MoniTool_SignShape(*args))


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_SignShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_SignShape

# Register MoniTool_SignShape in _MoniTool:
_MoniTool.MoniTool_SignShape_swigregister(MoniTool_SignShape)
class MoniTool_TransientElem(MoniTool_Element):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        akey: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Creates a transientelem with a value. this value can then not be changed. it is used by the hasher to compute the hashcode, which will then be stored for an immediate reading.

        """
        _MoniTool.MoniTool_TransientElem_swiginit(self, _MoniTool.new_MoniTool_TransientElem(*args))

    def Value(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns the contained value.

        """
        return _MoniTool.MoniTool_TransientElem_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_TransientElem_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _MoniTool.delete_MoniTool_TransientElem

# Register MoniTool_TransientElem in _MoniTool:
_MoniTool.MoniTool_TransientElem_swigregister(MoniTool_TransientElem)
class MoniTool_HSequenceOfElement(MoniTool_SequenceOfElement, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _MoniTool.MoniTool_HSequenceOfElement_swiginit(self, _MoniTool.new_MoniTool_HSequenceOfElement(*args))

    def Sequence(self):
        return _MoniTool.MoniTool_HSequenceOfElement_Sequence(self)

    def Append(self, *args):
        return _MoniTool.MoniTool_HSequenceOfElement_Append(self, *args)

    def ChangeSequence(self):
        return _MoniTool.MoniTool_HSequenceOfElement_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_MoniTool_HSequenceOfElement_DownCast(t)

    __swig_destroy__ = _MoniTool.delete_MoniTool_HSequenceOfElement

# Register MoniTool_HSequenceOfElement in _MoniTool:
_MoniTool.MoniTool_HSequenceOfElement_swigregister(MoniTool_HSequenceOfElement)



@deprecated
def MoniTool_CaseData_DefCheck(*args):
	return MoniTool_CaseData.DefCheck(*args)

@deprecated
def MoniTool_CaseData_DefMsg(*args):
	return MoniTool_CaseData.DefMsg(*args)

@deprecated
def MoniTool_CaseData_SetDefFail(*args):
	return MoniTool_CaseData.SetDefFail(*args)

@deprecated
def MoniTool_CaseData_SetDefMsg(*args):
	return MoniTool_CaseData.SetDefMsg(*args)

@deprecated
def MoniTool_CaseData_SetDefWarning(*args):
	return MoniTool_CaseData.SetDefWarning(*args)

@deprecated
def MoniTool_DataInfo_Type(*args):
	return MoniTool_DataInfo.Type(*args)

@deprecated
def MoniTool_DataInfo_TypeName(*args):
	return MoniTool_DataInfo.TypeName(*args)

@deprecated
def MoniTool_Stat_Current(*args):
	return MoniTool_Stat.Current(*args)

@deprecated
def MoniTool_Timer_ClearTimers(*args):
	return MoniTool_Timer.ClearTimers(*args)

@deprecated
def MoniTool_Timer_ComputeAmendments(*args):
	return MoniTool_Timer.ComputeAmendments(*args)

@deprecated
def MoniTool_Timer_Dictionary(*args):
	return MoniTool_Timer.Dictionary(*args)

@deprecated
def MoniTool_Timer_DumpTimers(*args):
	return MoniTool_Timer.DumpTimers(*args)

@deprecated
def MoniTool_Timer_GetAmendments(*args):
	return MoniTool_Timer.GetAmendments(*args)

@deprecated
def MoniTool_Timer_Start(*args):
	return MoniTool_Timer.Start(*args)

@deprecated
def MoniTool_Timer_Stop(*args):
	return MoniTool_Timer.Stop(*args)

@deprecated
def MoniTool_Timer_Timer(*args):
	return MoniTool_Timer.Timer(*args)

@deprecated
def MoniTool_TypedValue_AddLib(*args):
	return MoniTool_TypedValue.AddLib(*args)

@deprecated
def MoniTool_TypedValue_FromLib(*args):
	return MoniTool_TypedValue.FromLib(*args)

@deprecated
def MoniTool_TypedValue_Lib(*args):
	return MoniTool_TypedValue.Lib(*args)

@deprecated
def MoniTool_TypedValue_LibList(*args):
	return MoniTool_TypedValue.LibList(*args)

@deprecated
def MoniTool_TypedValue_StaticValue(*args):
	return MoniTool_TypedValue.StaticValue(*args)



