from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Storage import *
from OCC.Core.TCollection import *
from OCC.Core.Message import *
from OCC.Core.TColStd import *
from OCC.Core.CDM import *

# the following typedef cannot be wrapped as is
PCDM_BaseDriverPointer = NewType("PCDM_BaseDriverPointer", Any)

class PCDM_SequenceOfDocument:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class PCDM_SequenceOfReference:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> PCDM_Reference: ...
    def Last(self) -> PCDM_Reference: ...
    def Length(self) -> int: ...
    def Append(self, theItem: PCDM_Reference) -> PCDM_Reference: ...
    def Prepend(self, theItem: PCDM_Reference) -> PCDM_Reference: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> PCDM_Reference: ...
    def SetValue(self, theIndex: int, theValue: PCDM_Reference) -> None: ...

class PCDM_ReaderStatus(IntEnum):
    PCDM_RS_OK: int = ...
    PCDM_RS_NoDriver: int = ...
    PCDM_RS_UnknownFileDriver: int = ...
    PCDM_RS_OpenError: int = ...
    PCDM_RS_NoVersion: int = ...
    PCDM_RS_NoSchema: int = ...
    PCDM_RS_NoDocument: int = ...
    PCDM_RS_ExtensionFailure: int = ...
    PCDM_RS_WrongStreamMode: int = ...
    PCDM_RS_FormatFailure: int = ...
    PCDM_RS_TypeFailure: int = ...
    PCDM_RS_TypeNotFoundInSchema: int = ...
    PCDM_RS_UnrecognizedFileFormat: int = ...
    PCDM_RS_MakeFailure: int = ...
    PCDM_RS_PermissionDenied: int = ...
    PCDM_RS_DriverFailure: int = ...
    PCDM_RS_AlreadyRetrievedAndModified: int = ...
    PCDM_RS_AlreadyRetrieved: int = ...
    PCDM_RS_UnknownDocument: int = ...
    PCDM_RS_WrongResource: int = ...
    PCDM_RS_ReaderException: int = ...
    PCDM_RS_NoModel: int = ...
    PCDM_RS_UserBreak: int = ...

PCDM_RS_OK = PCDM_ReaderStatus.PCDM_RS_OK
PCDM_RS_NoDriver = PCDM_ReaderStatus.PCDM_RS_NoDriver
PCDM_RS_UnknownFileDriver = PCDM_ReaderStatus.PCDM_RS_UnknownFileDriver
PCDM_RS_OpenError = PCDM_ReaderStatus.PCDM_RS_OpenError
PCDM_RS_NoVersion = PCDM_ReaderStatus.PCDM_RS_NoVersion
PCDM_RS_NoSchema = PCDM_ReaderStatus.PCDM_RS_NoSchema
PCDM_RS_NoDocument = PCDM_ReaderStatus.PCDM_RS_NoDocument
PCDM_RS_ExtensionFailure = PCDM_ReaderStatus.PCDM_RS_ExtensionFailure
PCDM_RS_WrongStreamMode = PCDM_ReaderStatus.PCDM_RS_WrongStreamMode
PCDM_RS_FormatFailure = PCDM_ReaderStatus.PCDM_RS_FormatFailure
PCDM_RS_TypeFailure = PCDM_ReaderStatus.PCDM_RS_TypeFailure
PCDM_RS_TypeNotFoundInSchema = PCDM_ReaderStatus.PCDM_RS_TypeNotFoundInSchema
PCDM_RS_UnrecognizedFileFormat = PCDM_ReaderStatus.PCDM_RS_UnrecognizedFileFormat
PCDM_RS_MakeFailure = PCDM_ReaderStatus.PCDM_RS_MakeFailure
PCDM_RS_PermissionDenied = PCDM_ReaderStatus.PCDM_RS_PermissionDenied
PCDM_RS_DriverFailure = PCDM_ReaderStatus.PCDM_RS_DriverFailure
PCDM_RS_AlreadyRetrievedAndModified = PCDM_ReaderStatus.PCDM_RS_AlreadyRetrievedAndModified
PCDM_RS_AlreadyRetrieved = PCDM_ReaderStatus.PCDM_RS_AlreadyRetrieved
PCDM_RS_UnknownDocument = PCDM_ReaderStatus.PCDM_RS_UnknownDocument
PCDM_RS_WrongResource = PCDM_ReaderStatus.PCDM_RS_WrongResource
PCDM_RS_ReaderException = PCDM_ReaderStatus.PCDM_RS_ReaderException
PCDM_RS_NoModel = PCDM_ReaderStatus.PCDM_RS_NoModel
PCDM_RS_UserBreak = PCDM_ReaderStatus.PCDM_RS_UserBreak

class PCDM_StoreStatus(IntEnum):
    PCDM_SS_OK: int = ...
    PCDM_SS_DriverFailure: int = ...
    PCDM_SS_WriteFailure: int = ...
    PCDM_SS_Failure: int = ...
    PCDM_SS_Doc_IsNull: int = ...
    PCDM_SS_No_Obj: int = ...
    PCDM_SS_Info_Section_Error: int = ...
    PCDM_SS_UserBreak: int = ...
    PCDM_SS_UnrecognizedFormat: int = ...

PCDM_SS_OK = PCDM_StoreStatus.PCDM_SS_OK
PCDM_SS_DriverFailure = PCDM_StoreStatus.PCDM_SS_DriverFailure
PCDM_SS_WriteFailure = PCDM_StoreStatus.PCDM_SS_WriteFailure
PCDM_SS_Failure = PCDM_StoreStatus.PCDM_SS_Failure
PCDM_SS_Doc_IsNull = PCDM_StoreStatus.PCDM_SS_Doc_IsNull
PCDM_SS_No_Obj = PCDM_StoreStatus.PCDM_SS_No_Obj
PCDM_SS_Info_Section_Error = PCDM_StoreStatus.PCDM_SS_Info_Section_Error
PCDM_SS_UserBreak = PCDM_StoreStatus.PCDM_SS_UserBreak
PCDM_SS_UnrecognizedFormat = PCDM_StoreStatus.PCDM_SS_UnrecognizedFormat

class PCDM_TypeOfFileDriver(IntEnum):
    PCDM_TOFD_File: int = ...
    PCDM_TOFD_CmpFile: int = ...
    PCDM_TOFD_XmlFile: int = ...
    PCDM_TOFD_Unknown: int = ...

PCDM_TOFD_File = PCDM_TypeOfFileDriver.PCDM_TOFD_File
PCDM_TOFD_CmpFile = PCDM_TypeOfFileDriver.PCDM_TOFD_CmpFile
PCDM_TOFD_XmlFile = PCDM_TypeOfFileDriver.PCDM_TOFD_XmlFile
PCDM_TOFD_Unknown = PCDM_TypeOfFileDriver.PCDM_TOFD_Unknown

class pcdm:
    @overload
    @staticmethod
    def FileDriverType(aFileName: str, aBaseDriver: Storage_BaseDriver) -> PCDM_TypeOfFileDriver: ...
    @overload
    @staticmethod
    def FileDriverType(theIStream: str, theBaseDriver: Storage_BaseDriver) -> PCDM_TypeOfFileDriver: ...

class PCDM_ReadWriter(Standard_Transient):
    @overload
    @staticmethod
    def FileFormat(aFileName: str) -> str: ...
    @overload
    @staticmethod
    def FileFormat(theIStream: str, theData: Storage_Data) -> str: ...
    @staticmethod
    def Open(aDriver: Storage_BaseDriver, aFileName: str, anOpenMode: Storage_OpenMode) -> None: ...
    def ReadDocumentVersion(self, aFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def ReadExtensions(self, aFileName: str, theExtensions: TColStd_SequenceOfExtendedString, theMsgDriver: Message_Messenger) -> None: ...
    def ReadReferenceCounter(self, theFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def ReadReferences(self, aFileName: str, theReferences: PCDM_SequenceOfReference, theMsgDriver: Message_Messenger) -> None: ...
    @staticmethod
    def Reader(aFileName: str) -> PCDM_ReadWriter: ...
    def Version(self) -> str: ...
    def WriteExtensions(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    @staticmethod
    def WriteFileFormat(aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    def WriteReferenceCounter(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    def WriteReferences(self, aData: Storage_Data, aDocument: CDM_Document, theReferencerFileName: str) -> None: ...
    def WriteVersion(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    @staticmethod
    def Writer() -> PCDM_ReadWriter: ...

class PCDM_Reader(Standard_Transient):
    def GetStatus(self) -> PCDM_ReaderStatus: ...
    @overload
    def Read(self, aFileName: str, aNewDocument: CDM_Document, anApplication: CDM_Application, theFilter: Optional[PCDM_ReaderFilter] = PCDM_ReaderFilter(), theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    def Read(self, theIStream: str, theStorageData: Storage_Data, theDoc: CDM_Document, theApplication: CDM_Application, theFilter: Optional[PCDM_ReaderFilter] = PCDM_ReaderFilter(), theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...

class PCDM_ReaderFilter(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theSkipped: Standard_Type) -> None: ...
    @overload
    def __init__(self, theEntryToRead: str) -> None: ...
    def AddPath(self, theEntryToRead: str) -> None: ...
    @overload
    def AddRead(self, theRead: Standard_Type) -> None: ...
    @overload
    def AddRead(self, theRead: str) -> None: ...
    @overload
    def AddSkipped(self, theSkipped: Standard_Type) -> None: ...
    @overload
    def AddSkipped(self, theSkipped: str) -> None: ...
    def Clear(self) -> None: ...
    def Down(self, theTag: int) -> None: ...
    def IsAppendMode(self) -> bool: ...
    def IsPartTree(self) -> bool: ...
    @overload
    def IsPassed(self, theAttributeID: Standard_Type) -> bool: ...
    @overload
    def IsPassed(self, theEntry: str) -> bool: ...
    @overload
    def IsPassed(self) -> bool: ...
    def IsPassedAttr(self, theAttributeType: str) -> bool: ...
    @overload
    def IsSubPassed(self, theEntry: str) -> bool: ...
    @overload
    def IsSubPassed(self) -> bool: ...
    def Mode(self) -> False: ...
    def StartIteration(self) -> None: ...
    def Up(self) -> None: ...

class PCDM_Reference:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, aReferenceIdentifier: int, aFileName: str, aDocumentVersion: int) -> None: ...
    def DocumentVersion(self) -> int: ...
    def FileName(self) -> str: ...
    def ReferenceIdentifier(self) -> int: ...

class PCDM_ReferenceIterator(Standard_Transient):
    def __init__(self, theMessageDriver: Message_Messenger) -> None: ...
    def Init(self, aMetaData: CDM_MetaData) -> None: ...
    def LoadReferences(self, aDocument: CDM_Document, aMetaData: CDM_MetaData, anApplication: CDM_Application, UseStorageConfiguration: bool) -> None: ...

class PCDM_Writer(Standard_Transient):
    @overload
    def Write(self, aDocument: CDM_Document, aFileName: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    def Write(self, theDocument: CDM_Document, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...

class PCDM_ReadWriter_1(PCDM_ReadWriter):
    def __init__(self) -> None: ...
    def ReadDocumentVersion(self, aFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def ReadExtensions(self, aFileName: str, theExtensions: TColStd_SequenceOfExtendedString, theMsgDriver: Message_Messenger) -> None: ...
    def ReadReferenceCounter(self, aFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def ReadReferences(self, aFileName: str, theReferences: PCDM_SequenceOfReference, theMsgDriver: Message_Messenger) -> None: ...
    def Version(self) -> str: ...
    def WriteExtensions(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    def WriteReferenceCounter(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...
    def WriteReferences(self, aData: Storage_Data, aDocument: CDM_Document, theReferencerFileName: str) -> None: ...
    def WriteVersion(self, aData: Storage_Data, aDocument: CDM_Document) -> None: ...

class PCDM_RetrievalDriver(PCDM_Reader):
    @staticmethod
    def DocumentVersion(theFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def GetFormat(self) -> str: ...
    @staticmethod
    def ReferenceCounter(theFileName: str, theMsgDriver: Message_Messenger) -> int: ...
    def SetFormat(self, aformat: str) -> None: ...

class PCDM_StorageDriver(PCDM_Writer):
    def GetFormat(self) -> str: ...
    def GetStoreStatus(self) -> PCDM_StoreStatus: ...
    def IsError(self) -> bool: ...
    @overload
    def Make(self, aDocument: CDM_Document) -> PCDM_Document: ...
    @overload
    def Make(self, aDocument: CDM_Document, Documents: PCDM_SequenceOfDocument) -> None: ...
    def SetFormat(self, aformat: str) -> None: ...
    def SetIsError(self, theIsError: bool) -> None: ...
    def SetStoreStatus(self, theStoreStatus: PCDM_StoreStatus) -> None: ...
    @overload
    def Write(self, aDocument: CDM_Document, aFileName: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    def Write(self, theDocument: CDM_Document, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...

#classnotwrapped
class PCDM_DOMHeaderParser: ...

#classnotwrapped
class PCDM_Document: ...

# harray1 classes
# harray2 classes
# hsequence classes

