from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.StepData import *
from OCC.Core.TColStd import *
from OCC.Core.Interface import *


class StepBasic_Array1OfApproval:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfDerivedUnitElement:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfDocument:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfNamedUnit:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfOrganization:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfPerson:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfProduct:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfProductContext:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfProductDefinition:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_Array1OfUncertaintyMeasureWithUnit:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepBasic_AheadOrBehind(IntEnum):
    StepBasic_aobAhead: int = ...
    StepBasic_aobExact: int = ...
    StepBasic_aobBehind: int = ...

StepBasic_aobAhead = StepBasic_AheadOrBehind.StepBasic_aobAhead
StepBasic_aobExact = StepBasic_AheadOrBehind.StepBasic_aobExact
StepBasic_aobBehind = StepBasic_AheadOrBehind.StepBasic_aobBehind

class StepBasic_SiPrefix(IntEnum):
    StepBasic_spExa: int = ...
    StepBasic_spPeta: int = ...
    StepBasic_spTera: int = ...
    StepBasic_spGiga: int = ...
    StepBasic_spMega: int = ...
    StepBasic_spKilo: int = ...
    StepBasic_spHecto: int = ...
    StepBasic_spDeca: int = ...
    StepBasic_spDeci: int = ...
    StepBasic_spCenti: int = ...
    StepBasic_spMilli: int = ...
    StepBasic_spMicro: int = ...
    StepBasic_spNano: int = ...
    StepBasic_spPico: int = ...
    StepBasic_spFemto: int = ...
    StepBasic_spAtto: int = ...

StepBasic_spExa = StepBasic_SiPrefix.StepBasic_spExa
StepBasic_spPeta = StepBasic_SiPrefix.StepBasic_spPeta
StepBasic_spTera = StepBasic_SiPrefix.StepBasic_spTera
StepBasic_spGiga = StepBasic_SiPrefix.StepBasic_spGiga
StepBasic_spMega = StepBasic_SiPrefix.StepBasic_spMega
StepBasic_spKilo = StepBasic_SiPrefix.StepBasic_spKilo
StepBasic_spHecto = StepBasic_SiPrefix.StepBasic_spHecto
StepBasic_spDeca = StepBasic_SiPrefix.StepBasic_spDeca
StepBasic_spDeci = StepBasic_SiPrefix.StepBasic_spDeci
StepBasic_spCenti = StepBasic_SiPrefix.StepBasic_spCenti
StepBasic_spMilli = StepBasic_SiPrefix.StepBasic_spMilli
StepBasic_spMicro = StepBasic_SiPrefix.StepBasic_spMicro
StepBasic_spNano = StepBasic_SiPrefix.StepBasic_spNano
StepBasic_spPico = StepBasic_SiPrefix.StepBasic_spPico
StepBasic_spFemto = StepBasic_SiPrefix.StepBasic_spFemto
StepBasic_spAtto = StepBasic_SiPrefix.StepBasic_spAtto

class StepBasic_SiUnitName(IntEnum):
    StepBasic_sunMetre: int = ...
    StepBasic_sunGram: int = ...
    StepBasic_sunSecond: int = ...
    StepBasic_sunAmpere: int = ...
    StepBasic_sunKelvin: int = ...
    StepBasic_sunMole: int = ...
    StepBasic_sunCandela: int = ...
    StepBasic_sunRadian: int = ...
    StepBasic_sunSteradian: int = ...
    StepBasic_sunHertz: int = ...
    StepBasic_sunNewton: int = ...
    StepBasic_sunPascal: int = ...
    StepBasic_sunJoule: int = ...
    StepBasic_sunWatt: int = ...
    StepBasic_sunCoulomb: int = ...
    StepBasic_sunVolt: int = ...
    StepBasic_sunFarad: int = ...
    StepBasic_sunOhm: int = ...
    StepBasic_sunSiemens: int = ...
    StepBasic_sunWeber: int = ...
    StepBasic_sunTesla: int = ...
    StepBasic_sunHenry: int = ...
    StepBasic_sunDegreeCelsius: int = ...
    StepBasic_sunLumen: int = ...
    StepBasic_sunLux: int = ...
    StepBasic_sunBecquerel: int = ...
    StepBasic_sunGray: int = ...
    StepBasic_sunSievert: int = ...

StepBasic_sunMetre = StepBasic_SiUnitName.StepBasic_sunMetre
StepBasic_sunGram = StepBasic_SiUnitName.StepBasic_sunGram
StepBasic_sunSecond = StepBasic_SiUnitName.StepBasic_sunSecond
StepBasic_sunAmpere = StepBasic_SiUnitName.StepBasic_sunAmpere
StepBasic_sunKelvin = StepBasic_SiUnitName.StepBasic_sunKelvin
StepBasic_sunMole = StepBasic_SiUnitName.StepBasic_sunMole
StepBasic_sunCandela = StepBasic_SiUnitName.StepBasic_sunCandela
StepBasic_sunRadian = StepBasic_SiUnitName.StepBasic_sunRadian
StepBasic_sunSteradian = StepBasic_SiUnitName.StepBasic_sunSteradian
StepBasic_sunHertz = StepBasic_SiUnitName.StepBasic_sunHertz
StepBasic_sunNewton = StepBasic_SiUnitName.StepBasic_sunNewton
StepBasic_sunPascal = StepBasic_SiUnitName.StepBasic_sunPascal
StepBasic_sunJoule = StepBasic_SiUnitName.StepBasic_sunJoule
StepBasic_sunWatt = StepBasic_SiUnitName.StepBasic_sunWatt
StepBasic_sunCoulomb = StepBasic_SiUnitName.StepBasic_sunCoulomb
StepBasic_sunVolt = StepBasic_SiUnitName.StepBasic_sunVolt
StepBasic_sunFarad = StepBasic_SiUnitName.StepBasic_sunFarad
StepBasic_sunOhm = StepBasic_SiUnitName.StepBasic_sunOhm
StepBasic_sunSiemens = StepBasic_SiUnitName.StepBasic_sunSiemens
StepBasic_sunWeber = StepBasic_SiUnitName.StepBasic_sunWeber
StepBasic_sunTesla = StepBasic_SiUnitName.StepBasic_sunTesla
StepBasic_sunHenry = StepBasic_SiUnitName.StepBasic_sunHenry
StepBasic_sunDegreeCelsius = StepBasic_SiUnitName.StepBasic_sunDegreeCelsius
StepBasic_sunLumen = StepBasic_SiUnitName.StepBasic_sunLumen
StepBasic_sunLux = StepBasic_SiUnitName.StepBasic_sunLux
StepBasic_sunBecquerel = StepBasic_SiUnitName.StepBasic_sunBecquerel
StepBasic_sunGray = StepBasic_SiUnitName.StepBasic_sunGray
StepBasic_sunSievert = StepBasic_SiUnitName.StepBasic_sunSievert

class StepBasic_Source(IntEnum):
    StepBasic_sMade: int = ...
    StepBasic_sBought: int = ...
    StepBasic_sNotKnown: int = ...

StepBasic_sMade = StepBasic_Source.StepBasic_sMade
StepBasic_sBought = StepBasic_Source.StepBasic_sBought
StepBasic_sNotKnown = StepBasic_Source.StepBasic_sNotKnown

class StepBasic_Action(Standard_Transient):
    def __init__(self) -> None: ...
    def ChosenMethod(self) -> StepBasic_ActionMethod: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aChosenMethod: StepBasic_ActionMethod) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetChosenMethod(self, ChosenMethod: StepBasic_ActionMethod) -> None: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_ActionAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedAction(self) -> StepBasic_Action: ...
    def Init(self, aAssignedAction: StepBasic_Action) -> None: ...
    def SetAssignedAction(self, AssignedAction: StepBasic_Action) -> None: ...

class StepBasic_ActionMethod(Standard_Transient):
    def __init__(self) -> None: ...
    def Consequence(self) -> TCollection_HAsciiString: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aConsequence: TCollection_HAsciiString, aPurpose: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def Purpose(self) -> TCollection_HAsciiString: ...
    def SetConsequence(self, Consequence: TCollection_HAsciiString) -> None: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetPurpose(self, Purpose: TCollection_HAsciiString) -> None: ...

class StepBasic_ActionRequestAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedActionRequest(self) -> StepBasic_VersionedActionRequest: ...
    def Init(self, aAssignedActionRequest: StepBasic_VersionedActionRequest) -> None: ...
    def SetAssignedActionRequest(self, AssignedActionRequest: StepBasic_VersionedActionRequest) -> None: ...

class StepBasic_ActionRequestSolution(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aMethod: StepBasic_ActionMethod, aRequest: StepBasic_VersionedActionRequest) -> None: ...
    def Method(self) -> StepBasic_ActionMethod: ...
    def Request(self) -> StepBasic_VersionedActionRequest: ...
    def SetMethod(self, Method: StepBasic_ActionMethod) -> None: ...
    def SetRequest(self, Request: StepBasic_VersionedActionRequest) -> None: ...

class StepBasic_Address(Standard_Transient):
    def __init__(self) -> None: ...
    def Country(self) -> TCollection_HAsciiString: ...
    def ElectronicMailAddress(self) -> TCollection_HAsciiString: ...
    def FacsimileNumber(self) -> TCollection_HAsciiString: ...
    def HasCountry(self) -> bool: ...
    def HasElectronicMailAddress(self) -> bool: ...
    def HasFacsimileNumber(self) -> bool: ...
    def HasInternalLocation(self) -> bool: ...
    def HasPostalBox(self) -> bool: ...
    def HasPostalCode(self) -> bool: ...
    def HasRegion(self) -> bool: ...
    def HasStreet(self) -> bool: ...
    def HasStreetNumber(self) -> bool: ...
    def HasTelephoneNumber(self) -> bool: ...
    def HasTelexNumber(self) -> bool: ...
    def HasTown(self) -> bool: ...
    def Init(self, hasAinternalLocation: bool, aInternalLocation: TCollection_HAsciiString, hasAstreetNumber: bool, aStreetNumber: TCollection_HAsciiString, hasAstreet: bool, aStreet: TCollection_HAsciiString, hasApostalBox: bool, aPostalBox: TCollection_HAsciiString, hasAtown: bool, aTown: TCollection_HAsciiString, hasAregion: bool, aRegion: TCollection_HAsciiString, hasApostalCode: bool, aPostalCode: TCollection_HAsciiString, hasAcountry: bool, aCountry: TCollection_HAsciiString, hasAfacsimileNumber: bool, aFacsimileNumber: TCollection_HAsciiString, hasAtelephoneNumber: bool, aTelephoneNumber: TCollection_HAsciiString, hasAelectronicMailAddress: bool, aElectronicMailAddress: TCollection_HAsciiString, hasAtelexNumber: bool, aTelexNumber: TCollection_HAsciiString) -> None: ...
    def InternalLocation(self) -> TCollection_HAsciiString: ...
    def PostalBox(self) -> TCollection_HAsciiString: ...
    def PostalCode(self) -> TCollection_HAsciiString: ...
    def Region(self) -> TCollection_HAsciiString: ...
    def SetCountry(self, aCountry: TCollection_HAsciiString) -> None: ...
    def SetElectronicMailAddress(self, aElectronicMailAddress: TCollection_HAsciiString) -> None: ...
    def SetFacsimileNumber(self, aFacsimileNumber: TCollection_HAsciiString) -> None: ...
    def SetInternalLocation(self, aInternalLocation: TCollection_HAsciiString) -> None: ...
    def SetPostalBox(self, aPostalBox: TCollection_HAsciiString) -> None: ...
    def SetPostalCode(self, aPostalCode: TCollection_HAsciiString) -> None: ...
    def SetRegion(self, aRegion: TCollection_HAsciiString) -> None: ...
    def SetStreet(self, aStreet: TCollection_HAsciiString) -> None: ...
    def SetStreetNumber(self, aStreetNumber: TCollection_HAsciiString) -> None: ...
    def SetTelephoneNumber(self, aTelephoneNumber: TCollection_HAsciiString) -> None: ...
    def SetTelexNumber(self, aTelexNumber: TCollection_HAsciiString) -> None: ...
    def SetTown(self, aTown: TCollection_HAsciiString) -> None: ...
    def Street(self) -> TCollection_HAsciiString: ...
    def StreetNumber(self) -> TCollection_HAsciiString: ...
    def TelephoneNumber(self) -> TCollection_HAsciiString: ...
    def TelexNumber(self) -> TCollection_HAsciiString: ...
    def Town(self) -> TCollection_HAsciiString: ...
    def UnSetCountry(self) -> None: ...
    def UnSetElectronicMailAddress(self) -> None: ...
    def UnSetFacsimileNumber(self) -> None: ...
    def UnSetInternalLocation(self) -> None: ...
    def UnSetPostalBox(self) -> None: ...
    def UnSetPostalCode(self) -> None: ...
    def UnSetRegion(self) -> None: ...
    def UnSetStreet(self) -> None: ...
    def UnSetStreetNumber(self) -> None: ...
    def UnSetTelephoneNumber(self) -> None: ...
    def UnSetTelexNumber(self) -> None: ...
    def UnSetTown(self) -> None: ...

class StepBasic_ApplicationContext(Standard_Transient):
    def __init__(self) -> None: ...
    def Application(self) -> TCollection_HAsciiString: ...
    def Init(self, aApplication: TCollection_HAsciiString) -> None: ...
    def SetApplication(self, aApplication: TCollection_HAsciiString) -> None: ...

class StepBasic_ApplicationContextElement(Standard_Transient):
    def __init__(self) -> None: ...
    def FrameOfReference(self) -> StepBasic_ApplicationContext: ...
    def Init(self, aName: TCollection_HAsciiString, aFrameOfReference: StepBasic_ApplicationContext) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetFrameOfReference(self, aFrameOfReference: StepBasic_ApplicationContext) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_ApplicationProtocolDefinition(Standard_Transient):
    def __init__(self) -> None: ...
    def Application(self) -> StepBasic_ApplicationContext: ...
    def ApplicationInterpretedModelSchemaName(self) -> TCollection_HAsciiString: ...
    def ApplicationProtocolYear(self) -> int: ...
    def Init(self, aStatus: TCollection_HAsciiString, aApplicationInterpretedModelSchemaName: TCollection_HAsciiString, aApplicationProtocolYear: int, aApplication: StepBasic_ApplicationContext) -> None: ...
    def SetApplication(self, aApplication: StepBasic_ApplicationContext) -> None: ...
    def SetApplicationInterpretedModelSchemaName(self, aApplicationInterpretedModelSchemaName: TCollection_HAsciiString) -> None: ...
    def SetApplicationProtocolYear(self, aApplicationProtocolYear: int) -> None: ...
    def SetStatus(self, aStatus: TCollection_HAsciiString) -> None: ...
    def Status(self) -> TCollection_HAsciiString: ...

class StepBasic_Approval(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aStatus: StepBasic_ApprovalStatus, aLevel: TCollection_HAsciiString) -> None: ...
    def Level(self) -> TCollection_HAsciiString: ...
    def SetLevel(self, aLevel: TCollection_HAsciiString) -> None: ...
    def SetStatus(self, aStatus: StepBasic_ApprovalStatus) -> None: ...
    def Status(self) -> StepBasic_ApprovalStatus: ...

class StepBasic_ApprovalAssignment(Standard_Transient):
    def AssignedApproval(self) -> StepBasic_Approval: ...
    def Init(self, aAssignedApproval: StepBasic_Approval) -> None: ...
    def SetAssignedApproval(self, aAssignedApproval: StepBasic_Approval) -> None: ...

class StepBasic_ApprovalDateTime(Standard_Transient):
    def __init__(self) -> None: ...
    def DateTime(self) -> StepBasic_DateTimeSelect: ...
    def DatedApproval(self) -> StepBasic_Approval: ...
    def Init(self, aDateTime: StepBasic_DateTimeSelect, aDatedApproval: StepBasic_Approval) -> None: ...
    def SetDateTime(self, aDateTime: StepBasic_DateTimeSelect) -> None: ...
    def SetDatedApproval(self, aDatedApproval: StepBasic_Approval) -> None: ...

class StepBasic_ApprovalPersonOrganization(Standard_Transient):
    def __init__(self) -> None: ...
    def AuthorizedApproval(self) -> StepBasic_Approval: ...
    def Init(self, aPersonOrganization: StepBasic_PersonOrganizationSelect, aAuthorizedApproval: StepBasic_Approval, aRole: StepBasic_ApprovalRole) -> None: ...
    def PersonOrganization(self) -> StepBasic_PersonOrganizationSelect: ...
    def Role(self) -> StepBasic_ApprovalRole: ...
    def SetAuthorizedApproval(self, aAuthorizedApproval: StepBasic_Approval) -> None: ...
    def SetPersonOrganization(self, aPersonOrganization: StepBasic_PersonOrganizationSelect) -> None: ...
    def SetRole(self, aRole: StepBasic_ApprovalRole) -> None: ...

class StepBasic_ApprovalRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aRelatingApproval: StepBasic_Approval, aRelatedApproval: StepBasic_Approval) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedApproval(self) -> StepBasic_Approval: ...
    def RelatingApproval(self) -> StepBasic_Approval: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def SetRelatedApproval(self, aRelatedApproval: StepBasic_Approval) -> None: ...
    def SetRelatingApproval(self, aRelatingApproval: StepBasic_Approval) -> None: ...

class StepBasic_ApprovalRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aRole: TCollection_HAsciiString) -> None: ...
    def Role(self) -> TCollection_HAsciiString: ...
    def SetRole(self, aRole: TCollection_HAsciiString) -> None: ...

class StepBasic_ApprovalStatus(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_Certification(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPurpose: TCollection_HAsciiString, aKind: StepBasic_CertificationType) -> None: ...
    def Kind(self) -> StepBasic_CertificationType: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def Purpose(self) -> TCollection_HAsciiString: ...
    def SetKind(self, Kind: StepBasic_CertificationType) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetPurpose(self, Purpose: TCollection_HAsciiString) -> None: ...

class StepBasic_CertificationAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedCertification(self) -> StepBasic_Certification: ...
    def Init(self, aAssignedCertification: StepBasic_Certification) -> None: ...
    def SetAssignedCertification(self, AssignedCertification: StepBasic_Certification) -> None: ...

class StepBasic_CertificationType(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...

class StepBasic_CharacterizedObject(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_Contract(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPurpose: TCollection_HAsciiString, aKind: StepBasic_ContractType) -> None: ...
    def Kind(self) -> StepBasic_ContractType: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def Purpose(self) -> TCollection_HAsciiString: ...
    def SetKind(self, Kind: StepBasic_ContractType) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetPurpose(self, Purpose: TCollection_HAsciiString) -> None: ...

class StepBasic_ContractAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedContract(self) -> StepBasic_Contract: ...
    def Init(self, aAssignedContract: StepBasic_Contract) -> None: ...
    def SetAssignedContract(self, AssignedContract: StepBasic_Contract) -> None: ...

class StepBasic_ContractType(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...

class StepBasic_CoordinatedUniversalTimeOffset(Standard_Transient):
    def __init__(self) -> None: ...
    def HasMinuteOffset(self) -> bool: ...
    def HourOffset(self) -> int: ...
    def Init(self, aHourOffset: int, hasAminuteOffset: bool, aMinuteOffset: int, aSense: StepBasic_AheadOrBehind) -> None: ...
    def MinuteOffset(self) -> int: ...
    def Sense(self) -> StepBasic_AheadOrBehind: ...
    def SetHourOffset(self, aHourOffset: int) -> None: ...
    def SetMinuteOffset(self, aMinuteOffset: int) -> None: ...
    def SetSense(self, aSense: StepBasic_AheadOrBehind) -> None: ...
    def UnSetMinuteOffset(self) -> None: ...

class StepBasic_Date(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aYearComponent: int) -> None: ...
    def SetYearComponent(self, aYearComponent: int) -> None: ...
    def YearComponent(self) -> int: ...

class StepBasic_DateAndTime(Standard_Transient):
    def __init__(self) -> None: ...
    def DateComponent(self) -> StepBasic_Date: ...
    def Init(self, aDateComponent: StepBasic_Date, aTimeComponent: StepBasic_LocalTime) -> None: ...
    def SetDateComponent(self, aDateComponent: StepBasic_Date) -> None: ...
    def SetTimeComponent(self, aTimeComponent: StepBasic_LocalTime) -> None: ...
    def TimeComponent(self) -> StepBasic_LocalTime: ...

class StepBasic_DateAndTimeAssignment(Standard_Transient):
    def AssignedDateAndTime(self) -> StepBasic_DateAndTime: ...
    def Init(self, aAssignedDateAndTime: StepBasic_DateAndTime, aRole: StepBasic_DateTimeRole) -> None: ...
    def Role(self) -> StepBasic_DateTimeRole: ...
    def SetAssignedDateAndTime(self, aAssignedDateAndTime: StepBasic_DateAndTime) -> None: ...
    def SetRole(self, aRole: StepBasic_DateTimeRole) -> None: ...

class StepBasic_DateAssignment(Standard_Transient):
    def AssignedDate(self) -> StepBasic_Date: ...
    def Init(self, aAssignedDate: StepBasic_Date, aRole: StepBasic_DateRole) -> None: ...
    def Role(self) -> StepBasic_DateRole: ...
    def SetAssignedDate(self, aAssignedDate: StepBasic_Date) -> None: ...
    def SetRole(self, aRole: StepBasic_DateRole) -> None: ...

class StepBasic_DateRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_DateTimeRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_DateTimeSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Date(self) -> StepBasic_Date: ...
    def DateAndTime(self) -> StepBasic_DateAndTime: ...
    def LocalTime(self) -> StepBasic_LocalTime: ...

class StepBasic_DerivedUnit(Standard_Transient):
    def __init__(self) -> None: ...
    def Elements(self) -> StepBasic_HArray1OfDerivedUnitElement: ...
    def ElementsValue(self, num: int) -> StepBasic_DerivedUnitElement: ...
    def Init(self, elements: StepBasic_HArray1OfDerivedUnitElement) -> None: ...
    def NbElements(self) -> int: ...
    def SetElements(self, elements: StepBasic_HArray1OfDerivedUnitElement) -> None: ...

class StepBasic_DerivedUnitElement(Standard_Transient):
    def __init__(self) -> None: ...
    def Exponent(self) -> float: ...
    def Init(self, aUnit: StepBasic_NamedUnit, aExponent: float) -> None: ...
    def SetExponent(self, aExponent: float) -> None: ...
    def SetUnit(self, aUnit: StepBasic_NamedUnit) -> None: ...
    def Unit(self) -> StepBasic_NamedUnit: ...

class StepBasic_DimensionalExponents(Standard_Transient):
    def __init__(self) -> None: ...
    def AmountOfSubstanceExponent(self) -> float: ...
    def ElectricCurrentExponent(self) -> float: ...
    def Init(self, aLengthExponent: float, aMassExponent: float, aTimeExponent: float, aElectricCurrentExponent: float, aThermodynamicTemperatureExponent: float, aAmountOfSubstanceExponent: float, aLuminousIntensityExponent: float) -> None: ...
    def LengthExponent(self) -> float: ...
    def LuminousIntensityExponent(self) -> float: ...
    def MassExponent(self) -> float: ...
    def SetAmountOfSubstanceExponent(self, aAmountOfSubstanceExponent: float) -> None: ...
    def SetElectricCurrentExponent(self, aElectricCurrentExponent: float) -> None: ...
    def SetLengthExponent(self, aLengthExponent: float) -> None: ...
    def SetLuminousIntensityExponent(self, aLuminousIntensityExponent: float) -> None: ...
    def SetMassExponent(self, aMassExponent: float) -> None: ...
    def SetThermodynamicTemperatureExponent(self, aThermodynamicTemperatureExponent: float) -> None: ...
    def SetTimeExponent(self, aTimeExponent: float) -> None: ...
    def ThermodynamicTemperatureExponent(self) -> float: ...
    def TimeExponent(self) -> float: ...

class StepBasic_Document(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aKind: StepBasic_DocumentType) -> None: ...
    def Kind(self) -> StepBasic_DocumentType: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetId(self, Id: TCollection_HAsciiString) -> None: ...
    def SetKind(self, Kind: StepBasic_DocumentType) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_DocumentProductAssociation(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aRelatingDocument: StepBasic_Document, aRelatedProduct: StepBasic_ProductOrFormationOrDefinition) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedProduct(self) -> StepBasic_ProductOrFormationOrDefinition: ...
    def RelatingDocument(self) -> StepBasic_Document: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetRelatedProduct(self, RelatedProduct: StepBasic_ProductOrFormationOrDefinition) -> None: ...
    def SetRelatingDocument(self, RelatingDocument: StepBasic_Document) -> None: ...

class StepBasic_DocumentReference(Standard_Transient):
    def AssignedDocument(self) -> StepBasic_Document: ...
    def Init0(self, aAssignedDocument: StepBasic_Document, aSource: TCollection_HAsciiString) -> None: ...
    def SetAssignedDocument(self, aAssignedDocument: StepBasic_Document) -> None: ...
    def SetSource(self, aSource: TCollection_HAsciiString) -> None: ...
    def Source(self) -> TCollection_HAsciiString: ...

class StepBasic_DocumentRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aRelating: StepBasic_Document, aRelated: StepBasic_Document) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedDocument(self) -> StepBasic_Document: ...
    def RelatingDocument(self) -> StepBasic_Document: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def SetRelatedDocument(self, aRelated: StepBasic_Document) -> None: ...
    def SetRelatingDocument(self, aRelating: StepBasic_Document) -> None: ...

class StepBasic_DocumentRepresentationType(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aRepresentedDocument: StepBasic_Document) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RepresentedDocument(self) -> StepBasic_Document: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetRepresentedDocument(self, RepresentedDocument: StepBasic_Document) -> None: ...

class StepBasic_DocumentType(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, apdt: TCollection_HAsciiString) -> None: ...
    def ProductDataType(self) -> TCollection_HAsciiString: ...
    def SetProductDataType(self, apdt: TCollection_HAsciiString) -> None: ...

class StepBasic_DocumentUsageConstraint(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aSource: StepBasic_Document, ase: TCollection_HAsciiString, asev: TCollection_HAsciiString) -> None: ...
    def SetSource(self, aSource: StepBasic_Document) -> None: ...
    def SetSubjectElement(self, ase: TCollection_HAsciiString) -> None: ...
    def SetSubjectElementValue(self, asev: TCollection_HAsciiString) -> None: ...
    def Source(self) -> StepBasic_Document: ...
    def SubjectElement(self) -> TCollection_HAsciiString: ...
    def SubjectElementValue(self) -> TCollection_HAsciiString: ...

class StepBasic_Effectivity(Standard_Transient):
    def __init__(self) -> None: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aid: TCollection_HAsciiString) -> None: ...
    def SetId(self, aid: TCollection_HAsciiString) -> None: ...

class StepBasic_EffectivityAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedEffectivity(self) -> StepBasic_Effectivity: ...
    def Init(self, aAssignedEffectivity: StepBasic_Effectivity) -> None: ...
    def SetAssignedEffectivity(self, AssignedEffectivity: StepBasic_Effectivity) -> None: ...

class StepBasic_EulerAngles(Standard_Transient):
    def __init__(self) -> None: ...
    def Angles(self) -> TColStd_HArray1OfReal: ...
    def Init(self, aAngles: TColStd_HArray1OfReal) -> None: ...
    def SetAngles(self, Angles: TColStd_HArray1OfReal) -> None: ...

class StepBasic_ExternalSource(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aSourceId: StepBasic_SourceItem) -> None: ...
    def SetSourceId(self, SourceId: StepBasic_SourceItem) -> None: ...
    def SourceId(self) -> StepBasic_SourceItem: ...

class StepBasic_ExternallyDefinedItem(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aItemId: StepBasic_SourceItem, aSource: StepBasic_ExternalSource) -> None: ...
    def ItemId(self) -> StepBasic_SourceItem: ...
    def SetItemId(self, ItemId: StepBasic_SourceItem) -> None: ...
    def SetSource(self, Source: StepBasic_ExternalSource) -> None: ...
    def Source(self) -> StepBasic_ExternalSource: ...

class StepBasic_GeneralProperty(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetId(self, Id: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_Group(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_GroupAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedGroup(self) -> StepBasic_Group: ...
    def Init(self, aAssignedGroup: StepBasic_Group) -> None: ...
    def SetAssignedGroup(self, AssignedGroup: StepBasic_Group) -> None: ...

class StepBasic_GroupRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aRelatingGroup: StepBasic_Group, aRelatedGroup: StepBasic_Group) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedGroup(self) -> StepBasic_Group: ...
    def RelatingGroup(self) -> StepBasic_Group: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetRelatedGroup(self, RelatedGroup: StepBasic_Group) -> None: ...
    def SetRelatingGroup(self, RelatingGroup: StepBasic_Group) -> None: ...

class StepBasic_IdentificationAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedId(self) -> TCollection_HAsciiString: ...
    def Init(self, aAssignedId: TCollection_HAsciiString, aRole: StepBasic_IdentificationRole) -> None: ...
    def Role(self) -> StepBasic_IdentificationRole: ...
    def SetAssignedId(self, AssignedId: TCollection_HAsciiString) -> None: ...
    def SetRole(self, Role: StepBasic_IdentificationRole) -> None: ...

class StepBasic_IdentificationRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_LocalTime(Standard_Transient):
    def __init__(self) -> None: ...
    def HasMinuteComponent(self) -> bool: ...
    def HasSecondComponent(self) -> bool: ...
    def HourComponent(self) -> int: ...
    def Init(self, aHourComponent: int, hasAminuteComponent: bool, aMinuteComponent: int, hasAsecondComponent: bool, aSecondComponent: float, aZone: StepBasic_CoordinatedUniversalTimeOffset) -> None: ...
    def MinuteComponent(self) -> int: ...
    def SecondComponent(self) -> float: ...
    def SetHourComponent(self, aHourComponent: int) -> None: ...
    def SetMinuteComponent(self, aMinuteComponent: int) -> None: ...
    def SetSecondComponent(self, aSecondComponent: float) -> None: ...
    def SetZone(self, aZone: StepBasic_CoordinatedUniversalTimeOffset) -> None: ...
    def UnSetMinuteComponent(self) -> None: ...
    def UnSetSecondComponent(self) -> None: ...
    def Zone(self) -> StepBasic_CoordinatedUniversalTimeOffset: ...

class StepBasic_MeasureValueMember(StepData_SelectReal):
    def __init__(self) -> None: ...
    def HasName(self) -> bool: ...
    def Name(self) -> str: ...
    def SetName(self, name: str) -> bool: ...

class StepBasic_MeasureWithUnit(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aValueComponent: StepBasic_MeasureValueMember, aUnitComponent: StepBasic_Unit) -> None: ...
    def SetUnitComponent(self, aUnitComponent: StepBasic_Unit) -> None: ...
    def SetValueComponent(self, aValueComponent: float) -> None: ...
    def SetValueComponentMember(self, val: StepBasic_MeasureValueMember) -> None: ...
    def UnitComponent(self) -> StepBasic_Unit: ...
    def ValueComponent(self) -> float: ...
    def ValueComponentMember(self) -> StepBasic_MeasureValueMember: ...

class StepBasic_NameAssignment(Standard_Transient):
    def __init__(self) -> None: ...
    def AssignedName(self) -> TCollection_HAsciiString: ...
    def Init(self, aAssignedName: TCollection_HAsciiString) -> None: ...
    def SetAssignedName(self, AssignedName: TCollection_HAsciiString) -> None: ...

class StepBasic_NamedUnit(Standard_Transient):
    def __init__(self) -> None: ...
    def Dimensions(self) -> StepBasic_DimensionalExponents: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents) -> None: ...
    def SetDimensions(self, aDimensions: StepBasic_DimensionalExponents) -> None: ...

class StepBasic_ObjectRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepBasic_Organization(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasId(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, hasAid: bool, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetId(self, aId: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def UnSetId(self) -> None: ...

class StepBasic_OrganizationAssignment(Standard_Transient):
    def AssignedOrganization(self) -> StepBasic_Organization: ...
    def Init(self, aAssignedOrganization: StepBasic_Organization, aRole: StepBasic_OrganizationRole) -> None: ...
    def Role(self) -> StepBasic_OrganizationRole: ...
    def SetAssignedOrganization(self, aAssignedOrganization: StepBasic_Organization) -> None: ...
    def SetRole(self, aRole: StepBasic_OrganizationRole) -> None: ...

class StepBasic_OrganizationRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_Person(Standard_Transient):
    def __init__(self) -> None: ...
    def FirstName(self) -> TCollection_HAsciiString: ...
    def HasFirstName(self) -> bool: ...
    def HasLastName(self) -> bool: ...
    def HasMiddleNames(self) -> bool: ...
    def HasPrefixTitles(self) -> bool: ...
    def HasSuffixTitles(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, hasAlastName: bool, aLastName: TCollection_HAsciiString, hasAfirstName: bool, aFirstName: TCollection_HAsciiString, hasAmiddleNames: bool, aMiddleNames: Interface_HArray1OfHAsciiString, hasAprefixTitles: bool, aPrefixTitles: Interface_HArray1OfHAsciiString, hasAsuffixTitles: bool, aSuffixTitles: Interface_HArray1OfHAsciiString) -> None: ...
    def LastName(self) -> TCollection_HAsciiString: ...
    def MiddleNames(self) -> Interface_HArray1OfHAsciiString: ...
    def MiddleNamesValue(self, num: int) -> TCollection_HAsciiString: ...
    def NbMiddleNames(self) -> int: ...
    def NbPrefixTitles(self) -> int: ...
    def NbSuffixTitles(self) -> int: ...
    def PrefixTitles(self) -> Interface_HArray1OfHAsciiString: ...
    def PrefixTitlesValue(self, num: int) -> TCollection_HAsciiString: ...
    def SetFirstName(self, aFirstName: TCollection_HAsciiString) -> None: ...
    def SetId(self, aId: TCollection_HAsciiString) -> None: ...
    def SetLastName(self, aLastName: TCollection_HAsciiString) -> None: ...
    def SetMiddleNames(self, aMiddleNames: Interface_HArray1OfHAsciiString) -> None: ...
    def SetPrefixTitles(self, aPrefixTitles: Interface_HArray1OfHAsciiString) -> None: ...
    def SetSuffixTitles(self, aSuffixTitles: Interface_HArray1OfHAsciiString) -> None: ...
    def SuffixTitles(self) -> Interface_HArray1OfHAsciiString: ...
    def SuffixTitlesValue(self, num: int) -> TCollection_HAsciiString: ...
    def UnSetFirstName(self) -> None: ...
    def UnSetLastName(self) -> None: ...
    def UnSetMiddleNames(self) -> None: ...
    def UnSetPrefixTitles(self) -> None: ...
    def UnSetSuffixTitles(self) -> None: ...

class StepBasic_PersonAndOrganization(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aThePerson: StepBasic_Person, aTheOrganization: StepBasic_Organization) -> None: ...
    def SetTheOrganization(self, aTheOrganization: StepBasic_Organization) -> None: ...
    def SetThePerson(self, aThePerson: StepBasic_Person) -> None: ...
    def TheOrganization(self) -> StepBasic_Organization: ...
    def ThePerson(self) -> StepBasic_Person: ...

class StepBasic_PersonAndOrganizationAssignment(Standard_Transient):
    def AssignedPersonAndOrganization(self) -> StepBasic_PersonAndOrganization: ...
    def Init(self, aAssignedPersonAndOrganization: StepBasic_PersonAndOrganization, aRole: StepBasic_PersonAndOrganizationRole) -> None: ...
    def Role(self) -> StepBasic_PersonAndOrganizationRole: ...
    def SetAssignedPersonAndOrganization(self, aAssignedPersonAndOrganization: StepBasic_PersonAndOrganization) -> None: ...
    def SetRole(self, aRole: StepBasic_PersonAndOrganizationRole) -> None: ...

class StepBasic_PersonAndOrganizationRole(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_PersonOrganizationSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Organization(self) -> StepBasic_Organization: ...
    def Person(self) -> StepBasic_Person: ...
    def PersonAndOrganization(self) -> StepBasic_PersonAndOrganization: ...

class StepBasic_Product(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def FrameOfReference(self) -> StepBasic_HArray1OfProductContext: ...
    def FrameOfReferenceValue(self, num: int) -> StepBasic_ProductContext: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aFrameOfReference: StepBasic_HArray1OfProductContext) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def NbFrameOfReference(self) -> int: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetFrameOfReference(self, aFrameOfReference: StepBasic_HArray1OfProductContext) -> None: ...
    def SetId(self, aId: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_ProductCategory(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasAdescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def UnSetDescription(self) -> None: ...

class StepBasic_ProductCategoryRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Category(self) -> StepBasic_ProductCategory: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Init(self, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aCategory: StepBasic_ProductCategory, aSubCategory: StepBasic_ProductCategory) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetCategory(self, Category: StepBasic_ProductCategory) -> None: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetSubCategory(self, SubCategory: StepBasic_ProductCategory) -> None: ...
    def SubCategory(self) -> StepBasic_ProductCategory: ...

class StepBasic_ProductDefinition(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Formation(self) -> StepBasic_ProductDefinitionFormation: ...
    def FrameOfReference(self) -> StepBasic_ProductDefinitionContext: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aFormation: StepBasic_ProductDefinitionFormation, aFrameOfReference: StepBasic_ProductDefinitionContext) -> None: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetFormation(self, aFormation: StepBasic_ProductDefinitionFormation) -> None: ...
    def SetFrameOfReference(self, aFrameOfReference: StepBasic_ProductDefinitionContext) -> None: ...
    def SetId(self, aId: TCollection_HAsciiString) -> None: ...

class StepBasic_ProductDefinitionFormation(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aOfProduct: StepBasic_Product) -> None: ...
    def OfProduct(self) -> StepBasic_Product: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetId(self, aId: TCollection_HAsciiString) -> None: ...
    def SetOfProduct(self, aOfProduct: StepBasic_Product) -> None: ...

class StepBasic_ProductDefinitionFormationRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aRelatingProductDefinitionFormation: StepBasic_ProductDefinitionFormation, aRelatedProductDefinitionFormation: StepBasic_ProductDefinitionFormation) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedProductDefinitionFormation(self) -> StepBasic_ProductDefinitionFormation: ...
    def RelatingProductDefinitionFormation(self) -> StepBasic_ProductDefinitionFormation: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetId(self, Id: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    def SetRelatedProductDefinitionFormation(self, RelatedProductDefinitionFormation: StepBasic_ProductDefinitionFormation) -> None: ...
    def SetRelatingProductDefinitionFormation(self, RelatingProductDefinitionFormation: StepBasic_ProductDefinitionFormation) -> None: ...

class StepBasic_ProductDefinitionOrReference(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def ProductDefinition(self) -> StepBasic_ProductDefinition: ...
    def ProductDefinitionReference(self) -> StepBasic_ProductDefinitionReference: ...
    def ProductDefinitionReferenceWithLocalRepresentation(self) -> StepBasic_ProductDefinitionReferenceWithLocalRepresentation: ...

class StepBasic_ProductDefinitionReference(Standard_Transient):
    def __init__(self) -> None: ...
    def HasIdOwningOrganizationName(self) -> bool: ...
    def IdOwningOrganizationName(self) -> TCollection_HAsciiString: ...
    @overload
    def Init(self, theSource: StepBasic_ExternalSource, theProductId: TCollection_HAsciiString, theProductDefinitionFormationId: TCollection_HAsciiString, theProductDefinitionId: TCollection_HAsciiString, theIdOwningOrganizationName: TCollection_HAsciiString) -> None: ...
    @overload
    def Init(self, theSource: StepBasic_ExternalSource, theProductId: TCollection_HAsciiString, theProductDefinitionFormationId: TCollection_HAsciiString, theProductDefinitionId: TCollection_HAsciiString) -> None: ...
    def ProductDefinitionFormationId(self) -> TCollection_HAsciiString: ...
    def ProductDefinitionId(self) -> TCollection_HAsciiString: ...
    def ProductId(self) -> TCollection_HAsciiString: ...
    def SetIdOwningOrganizationName(self, theIdOwningOrganizationName: TCollection_HAsciiString) -> None: ...
    def SetProductDefinitionFormationId(self, theProductDefinitionFormationId: TCollection_HAsciiString) -> None: ...
    def SetProductDefinitionId(self, theProductDefinitionId: TCollection_HAsciiString) -> None: ...
    def SetProductId(self, theProductId: TCollection_HAsciiString) -> None: ...
    def SetSource(self, theSource: StepBasic_ExternalSource) -> None: ...
    def Source(self) -> StepBasic_ExternalSource: ...

class StepBasic_ProductDefinitionRelationship(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    @overload
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aRelatingProductDefinition: StepBasic_ProductDefinition, aRelatedProductDefinition: StepBasic_ProductDefinition) -> None: ...
    @overload
    def Init(self, aId: TCollection_HAsciiString, aName: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString, aRelatingProductDefinition: StepBasic_ProductDefinitionOrReference, aRelatedProductDefinition: StepBasic_ProductDefinitionOrReference) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def RelatedProductDefinition(self) -> StepBasic_ProductDefinition: ...
    def RelatedProductDefinitionAP242(self) -> StepBasic_ProductDefinitionOrReference: ...
    def RelatingProductDefinition(self) -> StepBasic_ProductDefinition: ...
    def RelatingProductDefinitionAP242(self) -> StepBasic_ProductDefinitionOrReference: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetId(self, Id: TCollection_HAsciiString) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...
    @overload
    def SetRelatedProductDefinition(self, RelatedProductDefinition: StepBasic_ProductDefinition) -> None: ...
    @overload
    def SetRelatedProductDefinition(self, RelatedProductDefinition: StepBasic_ProductDefinitionOrReference) -> None: ...
    @overload
    def SetRelatingProductDefinition(self, RelatingProductDefinition: StepBasic_ProductDefinition) -> None: ...
    @overload
    def SetRelatingProductDefinition(self, RelatingProductDefinition: StepBasic_ProductDefinitionOrReference) -> None: ...

class StepBasic_ProductOrFormationOrDefinition(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Product(self) -> StepBasic_Product: ...
    def ProductDefinition(self) -> StepBasic_ProductDefinition: ...
    def ProductDefinitionFormation(self) -> StepBasic_ProductDefinitionFormation: ...

class StepBasic_RoleAssociation(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aRole: StepBasic_ObjectRole, aItemWithRole: StepBasic_RoleSelect) -> None: ...
    def ItemWithRole(self) -> StepBasic_RoleSelect: ...
    def Role(self) -> StepBasic_ObjectRole: ...
    def SetItemWithRole(self, ItemWithRole: StepBasic_RoleSelect) -> None: ...
    def SetRole(self, Role: StepBasic_ObjectRole) -> None: ...

class StepBasic_RoleSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def ActionAssignment(self) -> StepBasic_ActionAssignment: ...
    def ActionRequestAssignment(self) -> StepBasic_ActionRequestAssignment: ...
    def ApprovalAssignment(self) -> StepBasic_ApprovalAssignment: ...
    def ApprovalDateTime(self) -> StepBasic_ApprovalDateTime: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def CertificationAssignment(self) -> StepBasic_CertificationAssignment: ...
    def ContractAssignment(self) -> StepBasic_ContractAssignment: ...
    def DocumentReference(self) -> StepBasic_DocumentReference: ...
    def EffectivityAssignment(self) -> StepBasic_EffectivityAssignment: ...
    def GroupAssignment(self) -> StepBasic_GroupAssignment: ...
    def NameAssignment(self) -> StepBasic_NameAssignment: ...
    def SecurityClassificationAssignment(self) -> StepBasic_SecurityClassificationAssignment: ...

class StepBasic_SecurityClassification(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPurpose: TCollection_HAsciiString, aSecurityLevel: StepBasic_SecurityClassificationLevel) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def Purpose(self) -> TCollection_HAsciiString: ...
    def SecurityLevel(self) -> StepBasic_SecurityClassificationLevel: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def SetPurpose(self, aPurpose: TCollection_HAsciiString) -> None: ...
    def SetSecurityLevel(self, aSecurityLevel: StepBasic_SecurityClassificationLevel) -> None: ...

class StepBasic_SecurityClassificationAssignment(Standard_Transient):
    def AssignedSecurityClassification(self) -> StepBasic_SecurityClassification: ...
    def Init(self, aAssignedSecurityClassification: StepBasic_SecurityClassification) -> None: ...
    def SetAssignedSecurityClassification(self, aAssignedSecurityClassification: StepBasic_SecurityClassification) -> None: ...

class StepBasic_SecurityClassificationLevel(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_SizeMember(StepData_SelectReal):
    def __init__(self) -> None: ...
    def HasName(self) -> bool: ...
    def Name(self) -> str: ...
    def SetName(self, name: str) -> bool: ...

class StepBasic_SizeSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseMem(self, ent: StepData_SelectMember) -> int: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def NewMember(self) -> StepData_SelectMember: ...
    def RealValue(self) -> float: ...
    def SetRealValue(self, aReal: float) -> None: ...

class StepBasic_SourceItem(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Identifier(self) -> TCollection_HAsciiString: ...
    def NewMember(self) -> StepData_SelectMember: ...

class StepBasic_Unit(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def DerivedUnit(self) -> StepBasic_DerivedUnit: ...
    def NamedUnit(self) -> StepBasic_NamedUnit: ...

class StepBasic_VersionedActionRequest(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def HasDescription(self) -> bool: ...
    def Id(self) -> TCollection_HAsciiString: ...
    def Init(self, aId: TCollection_HAsciiString, aVersion: TCollection_HAsciiString, aPurpose: TCollection_HAsciiString, hasDescription: bool, aDescription: TCollection_HAsciiString) -> None: ...
    def Purpose(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, Description: TCollection_HAsciiString) -> None: ...
    def SetId(self, Id: TCollection_HAsciiString) -> None: ...
    def SetPurpose(self, Purpose: TCollection_HAsciiString) -> None: ...
    def SetVersion(self, Version: TCollection_HAsciiString) -> None: ...
    def Version(self) -> TCollection_HAsciiString: ...

class StepBasic_AreaUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_CalendarDate(StepBasic_Date):
    def __init__(self) -> None: ...
    def DayComponent(self) -> int: ...
    def Init(self, aYearComponent: int, aDayComponent: int, aMonthComponent: int) -> None: ...
    def MonthComponent(self) -> int: ...
    def SetDayComponent(self, aDayComponent: int) -> None: ...
    def SetMonthComponent(self, aMonthComponent: int) -> None: ...

class StepBasic_ConversionBasedUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...
    def ConversionFactor(self) -> StepBasic_MeasureWithUnit: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetConversionFactor(self, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_DigitalDocument(StepBasic_Document):
    def __init__(self) -> None: ...

class StepBasic_DocumentFile(StepBasic_Document):
    def __init__(self) -> None: ...
    def CharacterizedObject(self) -> StepBasic_CharacterizedObject: ...
    def Init(self, aDocument_Id: TCollection_HAsciiString, aDocument_Name: TCollection_HAsciiString, hasDocument_Description: bool, aDocument_Description: TCollection_HAsciiString, aDocument_Kind: StepBasic_DocumentType, aCharacterizedObject_Name: TCollection_HAsciiString, hasCharacterizedObject_Description: bool, aCharacterizedObject_Description: TCollection_HAsciiString) -> None: ...
    def SetCharacterizedObject(self, CharacterizedObject: StepBasic_CharacterizedObject) -> None: ...

class StepBasic_DocumentProductEquivalence(StepBasic_DocumentProductAssociation):
    def __init__(self) -> None: ...

class StepBasic_ExternalIdentificationAssignment(StepBasic_IdentificationAssignment):
    def __init__(self) -> None: ...
    def Init(self, aIdentificationAssignment_AssignedId: TCollection_HAsciiString, aIdentificationAssignment_Role: StepBasic_IdentificationRole, aSource: StepBasic_ExternalSource) -> None: ...
    def SetSource(self, Source: StepBasic_ExternalSource) -> None: ...
    def Source(self) -> StepBasic_ExternalSource: ...

class StepBasic_LengthMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_LengthUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_MassMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_MassUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_OrdinalDate(StepBasic_Date):
    def __init__(self) -> None: ...
    def DayComponent(self) -> int: ...
    def Init(self, aYearComponent: int, aDayComponent: int) -> None: ...
    def SetDayComponent(self, aDayComponent: int) -> None: ...

class StepBasic_OrganizationalAddress(StepBasic_Address):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, hasAinternalLocation: bool, aInternalLocation: TCollection_HAsciiString, hasAstreetNumber: bool, aStreetNumber: TCollection_HAsciiString, hasAstreet: bool, aStreet: TCollection_HAsciiString, hasApostalBox: bool, aPostalBox: TCollection_HAsciiString, hasAtown: bool, aTown: TCollection_HAsciiString, hasAregion: bool, aRegion: TCollection_HAsciiString, hasApostalCode: bool, aPostalCode: TCollection_HAsciiString, hasAcountry: bool, aCountry: TCollection_HAsciiString, hasAfacsimileNumber: bool, aFacsimileNumber: TCollection_HAsciiString, hasAtelephoneNumber: bool, aTelephoneNumber: TCollection_HAsciiString, hasAelectronicMailAddress: bool, aElectronicMailAddress: TCollection_HAsciiString, hasAtelexNumber: bool, aTelexNumber: TCollection_HAsciiString, aOrganizations: StepBasic_HArray1OfOrganization, aDescription: TCollection_HAsciiString) -> None: ...
    def NbOrganizations(self) -> int: ...
    def Organizations(self) -> StepBasic_HArray1OfOrganization: ...
    def OrganizationsValue(self, num: int) -> StepBasic_Organization: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetOrganizations(self, aOrganizations: StepBasic_HArray1OfOrganization) -> None: ...

class StepBasic_PersonalAddress(StepBasic_Address):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, hasAinternalLocation: bool, aInternalLocation: TCollection_HAsciiString, hasAstreetNumber: bool, aStreetNumber: TCollection_HAsciiString, hasAstreet: bool, aStreet: TCollection_HAsciiString, hasApostalBox: bool, aPostalBox: TCollection_HAsciiString, hasAtown: bool, aTown: TCollection_HAsciiString, hasAregion: bool, aRegion: TCollection_HAsciiString, hasApostalCode: bool, aPostalCode: TCollection_HAsciiString, hasAcountry: bool, aCountry: TCollection_HAsciiString, hasAfacsimileNumber: bool, aFacsimileNumber: TCollection_HAsciiString, hasAtelephoneNumber: bool, aTelephoneNumber: TCollection_HAsciiString, hasAelectronicMailAddress: bool, aElectronicMailAddress: TCollection_HAsciiString, hasAtelexNumber: bool, aTelexNumber: TCollection_HAsciiString, aPeople: StepBasic_HArray1OfPerson, aDescription: TCollection_HAsciiString) -> None: ...
    def NbPeople(self) -> int: ...
    def People(self) -> StepBasic_HArray1OfPerson: ...
    def PeopleValue(self, num: int) -> StepBasic_Person: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetPeople(self, aPeople: StepBasic_HArray1OfPerson) -> None: ...

class StepBasic_PhysicallyModeledProductDefinition(StepBasic_ProductDefinition):
    def __init__(self) -> None: ...

class StepBasic_PlaneAngleMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_PlaneAngleUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_ProductConceptContext(StepBasic_ApplicationContextElement):
    def __init__(self) -> None: ...
    def Init(self, aApplicationContextElement_Name: TCollection_HAsciiString, aApplicationContextElement_FrameOfReference: StepBasic_ApplicationContext, aMarketSegmentType: TCollection_HAsciiString) -> None: ...
    def MarketSegmentType(self) -> TCollection_HAsciiString: ...
    def SetMarketSegmentType(self, MarketSegmentType: TCollection_HAsciiString) -> None: ...

class StepBasic_ProductContext(StepBasic_ApplicationContextElement):
    def __init__(self) -> None: ...
    def DisciplineType(self) -> TCollection_HAsciiString: ...
    def Init(self, aName: TCollection_HAsciiString, aFrameOfReference: StepBasic_ApplicationContext, aDisciplineType: TCollection_HAsciiString) -> None: ...
    def SetDisciplineType(self, aDisciplineType: TCollection_HAsciiString) -> None: ...

class StepBasic_ProductDefinitionContext(StepBasic_ApplicationContextElement):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aFrameOfReference: StepBasic_ApplicationContext, aLifeCycleStage: TCollection_HAsciiString) -> None: ...
    def LifeCycleStage(self) -> TCollection_HAsciiString: ...
    def SetLifeCycleStage(self, aLifeCycleStage: TCollection_HAsciiString) -> None: ...

class StepBasic_ProductDefinitionEffectivity(StepBasic_Effectivity):
    def __init__(self) -> None: ...
    def Init(self, aId: TCollection_HAsciiString, aUsage: StepBasic_ProductDefinitionRelationship) -> None: ...
    def SetUsage(self, aUsage: StepBasic_ProductDefinitionRelationship) -> None: ...
    def Usage(self) -> StepBasic_ProductDefinitionRelationship: ...

class StepBasic_ProductDefinitionFormationWithSpecifiedSource(StepBasic_ProductDefinitionFormation):
    def __init__(self) -> None: ...
    def Init(self, aId: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aOfProduct: StepBasic_Product, aMakeOrBuy: StepBasic_Source) -> None: ...
    def MakeOrBuy(self) -> StepBasic_Source: ...
    def SetMakeOrBuy(self, aMakeOrBuy: StepBasic_Source) -> None: ...

class StepBasic_ProductDefinitionReferenceWithLocalRepresentation(StepBasic_ProductDefinition):
    def __init__(self) -> None: ...
    def Init(self, theSource: StepBasic_ExternalSource, theId: TCollection_HAsciiString, theDescription: TCollection_HAsciiString, theFormation: StepBasic_ProductDefinitionFormation, theFrameOfReference: StepBasic_ProductDefinitionContext) -> None: ...
    def SetSource(self, theSource: StepBasic_ExternalSource) -> None: ...
    def Source(self) -> StepBasic_ExternalSource: ...

class StepBasic_ProductDefinitionWithAssociatedDocuments(StepBasic_ProductDefinition):
    def __init__(self) -> None: ...
    def DocIds(self) -> StepBasic_HArray1OfDocument: ...
    def DocIdsValue(self, num: int) -> StepBasic_Document: ...
    def Init(self, aId: TCollection_HAsciiString, aDescription: TCollection_HAsciiString, aFormation: StepBasic_ProductDefinitionFormation, aFrame: StepBasic_ProductDefinitionContext, aDocIds: StepBasic_HArray1OfDocument) -> None: ...
    def NbDocIds(self) -> int: ...
    def SetDocIds(self, DocIds: StepBasic_HArray1OfDocument) -> None: ...
    def SetDocIdsValue(self, num: int, adoc: StepBasic_Document) -> None: ...

class StepBasic_ProductRelatedProductCategory(StepBasic_ProductCategory):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, hasAdescription: bool, aDescription: TCollection_HAsciiString, aProducts: StepBasic_HArray1OfProduct) -> None: ...
    def NbProducts(self) -> int: ...
    def Products(self) -> StepBasic_HArray1OfProduct: ...
    def ProductsValue(self, num: int) -> StepBasic_Product: ...
    def SetProducts(self, aProducts: StepBasic_HArray1OfProduct) -> None: ...

class StepBasic_RatioMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_RatioUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_SiUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...
    def Dimensions(self) -> StepBasic_DimensionalExponents: ...
    def HasPrefix(self) -> bool: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def Name(self) -> StepBasic_SiUnitName: ...
    def Prefix(self) -> StepBasic_SiPrefix: ...
    def SetDimensions(self, aDimensions: StepBasic_DimensionalExponents) -> None: ...
    def SetName(self, aName: StepBasic_SiUnitName) -> None: ...
    def SetPrefix(self, aPrefix: StepBasic_SiPrefix) -> None: ...
    def UnSetPrefix(self) -> None: ...

class StepBasic_SolidAngleMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_SolidAngleUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_ThermodynamicTemperatureUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_TimeMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...

class StepBasic_TimeUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_UncertaintyMeasureWithUnit(StepBasic_MeasureWithUnit):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, aValueComponent: StepBasic_MeasureValueMember, aUnitComponent: StepBasic_Unit, aName: TCollection_HAsciiString, aDescription: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetDescription(self, aDescription: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...

class StepBasic_VolumeUnit(StepBasic_NamedUnit):
    def __init__(self) -> None: ...

class StepBasic_WeekOfYearAndDayDate(StepBasic_Date):
    def __init__(self) -> None: ...
    def DayComponent(self) -> int: ...
    def HasDayComponent(self) -> bool: ...
    def Init(self, aYearComponent: int, aWeekComponent: int, hasAdayComponent: bool, aDayComponent: int) -> None: ...
    def SetDayComponent(self, aDayComponent: int) -> None: ...
    def SetWeekComponent(self, aWeekComponent: int) -> None: ...
    def UnSetDayComponent(self) -> None: ...
    def WeekComponent(self) -> int: ...

class StepBasic_ConversionBasedUnitAndAreaUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def AreaUnit(self) -> StepBasic_AreaUnit: ...
    def SetAreaUnit(self, anAreaUnit: StepBasic_AreaUnit) -> None: ...

class StepBasic_ConversionBasedUnitAndLengthUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def LengthUnit(self) -> StepBasic_LengthUnit: ...
    def SetLengthUnit(self, aLengthUnit: StepBasic_LengthUnit) -> None: ...

class StepBasic_ConversionBasedUnitAndMassUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def MassUnit(self) -> StepBasic_MassUnit: ...
    def SetMassUnit(self, aMassUnit: StepBasic_MassUnit) -> None: ...

class StepBasic_ConversionBasedUnitAndPlaneAngleUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def PlaneAngleUnit(self) -> StepBasic_PlaneAngleUnit: ...
    def SetPlaneAngleUnit(self, aPlaneAngleUnit: StepBasic_PlaneAngleUnit) -> None: ...

class StepBasic_ConversionBasedUnitAndRatioUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def RatioUnit(self) -> StepBasic_RatioUnit: ...
    def SetRatioUnit(self, aRatioUnit: StepBasic_RatioUnit) -> None: ...

class StepBasic_ConversionBasedUnitAndSolidAngleUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def SetSolidAngleUnit(self, aSolidAngleUnit: StepBasic_SolidAngleUnit) -> None: ...
    def SolidAngleUnit(self) -> StepBasic_SolidAngleUnit: ...

class StepBasic_ConversionBasedUnitAndTimeUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def Init(self, aDimensions: StepBasic_DimensionalExponents, aName: TCollection_HAsciiString, aConversionFactor: StepBasic_MeasureWithUnit) -> None: ...
    def SetTimeUnit(self, aTimeUnit: StepBasic_TimeUnit) -> None: ...
    def TimeUnit(self) -> StepBasic_TimeUnit: ...

class StepBasic_ConversionBasedUnitAndVolumeUnit(StepBasic_ConversionBasedUnit):
    def __init__(self) -> None: ...
    def SetVolumeUnit(self, aVolumeUnit: StepBasic_VolumeUnit) -> None: ...
    def VolumeUnit(self) -> StepBasic_VolumeUnit: ...

class StepBasic_DesignContext(StepBasic_ProductDefinitionContext):
    def __init__(self) -> None: ...

class StepBasic_MechanicalContext(StepBasic_ProductContext):
    def __init__(self) -> None: ...

class StepBasic_ProductType(StepBasic_ProductRelatedProductCategory):
    def __init__(self) -> None: ...

class StepBasic_SiUnitAndAreaUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def AreaUnit(self) -> StepBasic_AreaUnit: ...
    def SetAreaUnit(self, anAreaUnit: StepBasic_AreaUnit) -> None: ...

class StepBasic_SiUnitAndLengthUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def LengthUnit(self) -> StepBasic_LengthUnit: ...
    def SetLengthUnit(self, aLengthUnit: StepBasic_LengthUnit) -> None: ...

class StepBasic_SiUnitAndMassUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def MassUnit(self) -> StepBasic_MassUnit: ...
    def SetMassUnit(self, aMassUnit: StepBasic_MassUnit) -> None: ...

class StepBasic_SiUnitAndPlaneAngleUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def PlaneAngleUnit(self) -> StepBasic_PlaneAngleUnit: ...
    def SetPlaneAngleUnit(self, aPlaneAngleUnit: StepBasic_PlaneAngleUnit) -> None: ...

class StepBasic_SiUnitAndRatioUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def RatioUnit(self) -> StepBasic_RatioUnit: ...
    def SetRatioUnit(self, aRatioUnit: StepBasic_RatioUnit) -> None: ...

class StepBasic_SiUnitAndSolidAngleUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def SetSolidAngleUnit(self, aSolidAngleUnit: StepBasic_SolidAngleUnit) -> None: ...
    def SolidAngleUnit(self) -> StepBasic_SolidAngleUnit: ...

class StepBasic_SiUnitAndThermodynamicTemperatureUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def SetThermodynamicTemperatureUnit(self, aThermodynamicTemperatureUnit: StepBasic_ThermodynamicTemperatureUnit) -> None: ...
    def ThermodynamicTemperatureUnit(self) -> StepBasic_ThermodynamicTemperatureUnit: ...

class StepBasic_SiUnitAndTimeUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def Init(self, hasAprefix: bool, aPrefix: StepBasic_SiPrefix, aName: StepBasic_SiUnitName) -> None: ...
    def SetTimeUnit(self, aTimeUnit: StepBasic_TimeUnit) -> None: ...
    def TimeUnit(self) -> StepBasic_TimeUnit: ...

class StepBasic_SiUnitAndVolumeUnit(StepBasic_SiUnit):
    def __init__(self) -> None: ...
    def SetVolumeUnit(self, aVolumeUnit: StepBasic_VolumeUnit) -> None: ...
    def VolumeUnit(self) -> StepBasic_VolumeUnit: ...

# harray1 classes

class StepBasic_HArray1OfApproval(StepBasic_Array1OfApproval, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfApproval: ...


class StepBasic_HArray1OfDerivedUnitElement(StepBasic_Array1OfDerivedUnitElement, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfDerivedUnitElement: ...


class StepBasic_HArray1OfDocument(StepBasic_Array1OfDocument, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfDocument: ...


class StepBasic_HArray1OfNamedUnit(StepBasic_Array1OfNamedUnit, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfNamedUnit: ...


class StepBasic_HArray1OfOrganization(StepBasic_Array1OfOrganization, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfOrganization: ...


class StepBasic_HArray1OfPerson(StepBasic_Array1OfPerson, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfPerson: ...


class StepBasic_HArray1OfProduct(StepBasic_Array1OfProduct, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfProduct: ...


class StepBasic_HArray1OfProductContext(StepBasic_Array1OfProductContext, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfProductContext: ...


class StepBasic_HArray1OfProductDefinition(StepBasic_Array1OfProductDefinition, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfProductDefinition: ...


class StepBasic_HArray1OfUncertaintyMeasureWithUnit(StepBasic_Array1OfUncertaintyMeasureWithUnit, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepBasic_Array1OfUncertaintyMeasureWithUnit: ...

# harray2 classes
# hsequence classes

