# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "19.1.7",
                "commands": r"clang-cl",
                "args": r"",
                "linker args": r"-Wl,-defaultlib:C:/bld/scipy-split_1751160069174/_build_env/lib/clang/19/lib/windows/clang_rt.builtins-x86_64.lib",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.1.2",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "19.1.7",
                "commands": r"clang-cl",
                "args": r"",
                "linker args": r"-Wl,-defaultlib:C:/bld/scipy-split_1751160069174/_build_env/lib/clang/19/lib/windows/clang_rt.builtins-x86_64.lib",
            },
            "fortran": {
                "name": "llvm-flang",
                "linker": r"lld-link",
                "version": "19.1.7",
                "commands": r"flang-new",
                "args": r"-D_CRT_SECURE_NO_WARNINGS, -fms-runtime-lib=dll, -fuse-ld=lld, -IC:\bld\scipy-split_1751160069174\_h_env\Library\include",
                "linker args": r"-Wl,-defaultlib:C:/bld/scipy-split_1751160069174/_build_env/lib/clang/19/lib/windows/clang_rt.builtins-x86_64.lib, -D_CRT_SECURE_NO_WARNINGS, -fms-runtime-lib=dll, -fuse-ld=lld, -IC:\bld\scipy-split_1751160069174\_h_env\Library\include",
            },
            "pythran": {
                "version": r"0.17.0",
                "include directory": r"..\..\_h_env\Lib\site-packages\pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"FreeCAD_env/Library/include",
                "lib directory": r"FreeCAD_env/Library/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"C:\bld\scipy-split_1751160069174\_h_env\Library\lib\pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"FreeCAD_env/Library/include",
                "lib directory": r"FreeCAD_env/Library/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"C:\bld\scipy-split_1751160069174\_h_env\Library\lib\pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.13.6",
                "detection method": "pkgconfig",
                "include directory": r"FreeCAD_env/Library/include",
            },
        },
        "Python Information": {
            "path": r"C:\bld\scipy-split_1751160069174\_h_env\python.exe",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
