from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkAMRBaseParticlesReader(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def FilterLocationOff(self) -> None: ...
    def FilterLocationOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetFileName(self) -> str: ...
    def GetFilterLocation(self) -> int: ...
    def GetFrequency(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParticleArrays(self) -> int: ...
    def GetParticleArrayName(self, index:int) -> str: ...
    def GetParticleArrayStatus(self, name:str) -> int: ...
    def GetParticleDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetTotalNumberOfParticles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRBaseParticlesReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRBaseParticlesReader': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetFileName(self, fileName:str) -> None: ...
    def SetFilterLocation(self, _arg:int) -> None: ...
    def SetFrequency(self, _arg:int) -> None: ...
    def SetMaxLocation(self, maxx:float, maxy:float, maxz:float) -> None: ...
    def SetMinLocation(self, minx:float, miny:float, minz:float) -> None: ...
    def SetParticleArrayStatus(self, name:str, status:int) -> None: ...

class vtkAMRBaseReader(vtkmodules.vtkCommonExecutionModel.vtkOverlappingAMRAlgorithm):
    def EnableCachingOff(self) -> None: ...
    def EnableCachingOn(self) -> None: ...
    def GetCellArrayName(self, index:int) -> str: ...
    def GetCellArrayStatus(self, name:str) -> int: ...
    def GetCellDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetEnableCaching(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetPointArrayName(self, index:int) -> str: ...
    def GetPointArrayStatus(self, name:str) -> int: ...
    def GetPointDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCachingEnabled(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRBaseReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRBaseReader': ...
    def SetCellArrayStatus(self, name:str, status:int) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetEnableCaching(self, _arg:int) -> None: ...
    def SetFileName(self, fileName:str) -> None: ...
    def SetMaxLevel(self, _arg:int) -> None: ...
    def SetPointArrayStatus(self, name:str, status:int) -> None: ...

class vtkAMRDataSetCache(vtkmodules.vtkCommonCore.vtkObject):
    def GetAMRBlock(self, compositeIdx:int) -> 'vtkUniformGrid': ...
    def GetAMRBlockCellData(self, compositeIdx:int, dataName:str) -> 'vtkDataArray': ...
    def GetAMRBlockPointData(self, compositeIdx:int, dataName:str) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasAMRBlock(self, compositeIdx:int) -> bool: ...
    def HasAMRBlockCellData(self, compositeIdx:int, name:str) -> bool: ...
    def HasAMRBlockPointData(self, compositeIdx:int, name:str) -> bool: ...
    def InsertAMRBlock(self, compositeIdx:int, amrGrid:'vtkUniformGrid') -> None: ...
    def InsertAMRBlockCellData(self, compositeIdx:int, dataArray:'vtkDataArray') -> None: ...
    def InsertAMRBlockPointData(self, compositeIdx:int, dataArray:'vtkDataArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRDataSetCache': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRDataSetCache': ...

class vtkAMREnzoParticlesReader(vtkAMRBaseParticlesReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParticleType(self) -> int: ...
    def GetTotalNumberOfParticles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMREnzoParticlesReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMREnzoParticlesReader': ...
    def SetParticleType(self, _arg:int) -> None: ...

class vtkAMREnzoReader(vtkAMRBaseReader):
    def ConvertToCGSOff(self) -> None: ...
    def ConvertToCGSOn(self) -> None: ...
    def GetConvertToCGS(self) -> int: ...
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMREnzoReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMREnzoReader': ...
    def SetConvertToCGS(self, _arg:int) -> None: ...
    def SetFileName(self, fileName:str) -> None: ...

class vtkAMRFlashParticlesReader(vtkAMRBaseParticlesReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTotalNumberOfParticles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRFlashParticlesReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRFlashParticlesReader': ...

class vtkAMRFlashReader(vtkAMRBaseReader):
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRFlashReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRFlashReader': ...
    def SetFileName(self, fileName:str) -> None: ...

class vtkAMRVelodyneReader(vtkAMRBaseReader):
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetOutput(self) -> 'vtkOverlappingAMR': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRVelodyneReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRVelodyneReader': ...
    def SetFileName(self, fileName:str) -> None: ...

class vtkAMReXGridReader(vtkAMRBaseReader):
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMReXGridReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMReXGridReader': ...
    def SetFileName(self, fileName:str) -> None: ...

class vtkAMReXParticlesReader(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    @staticmethod
    def CanReadFile(fname:str, particlesType:str=...) -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParticleType(self) -> str: ...
    def GetPlotFileName(self) -> str: ...
    def GetPointDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMReXParticlesReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMReXParticlesReader': ...
    def SetController(self, controller:'vtkMultiProcessController') -> None: ...
    def SetParticleType(self, str:str) -> None: ...
    def SetPlotFileName(self, fname:str) -> None: ...

