# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepFilletAPI module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_brepfilletapi.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepFilletAPI
else:
    import _BRepFilletAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepFilletAPI.delete_SwigPyIterator

    def value(self):
        return _BRepFilletAPI.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepFilletAPI.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepFilletAPI.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepFilletAPI.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepFilletAPI.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepFilletAPI.SwigPyIterator_copy(self)

    def next(self):
        return _BRepFilletAPI.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepFilletAPI.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepFilletAPI.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepFilletAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepFilletAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepFilletAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepFilletAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepFilletAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepFilletAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepFilletAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepFilletAPI:
_BRepFilletAPI.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepFilletAPI.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _BRepFilletAPI.ios_base_erase_event
    imbue_event = _BRepFilletAPI.ios_base_imbue_event
    copyfmt_event = _BRepFilletAPI.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _BRepFilletAPI.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _BRepFilletAPI.ios_base_flags(self, *args)

    def setf(self, *args):
        return _BRepFilletAPI.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _BRepFilletAPI.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _BRepFilletAPI.ios_base_precision(self, *args)

    def width(self, *args):
        return _BRepFilletAPI.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _BRepFilletAPI.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _BRepFilletAPI.ios_base_imbue(self, __loc)

    def getloc(self):
        return _BRepFilletAPI.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _BRepFilletAPI.ios_base_xalloc()

    def iword(self, __ix):
        return _BRepFilletAPI.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _BRepFilletAPI.ios_base_pword(self, __ix)
    __swig_destroy__ = _BRepFilletAPI.delete_ios_base

# Register ios_base in _BRepFilletAPI:
_BRepFilletAPI.ios_base_swigregister(ios_base)
cvar = _BRepFilletAPI.cvar
ios_base.boolalpha = _BRepFilletAPI.cvar.ios_base_boolalpha
ios_base.dec = _BRepFilletAPI.cvar.ios_base_dec
ios_base.fixed = _BRepFilletAPI.cvar.ios_base_fixed
ios_base.hex = _BRepFilletAPI.cvar.ios_base_hex
ios_base.internal = _BRepFilletAPI.cvar.ios_base_internal
ios_base.left = _BRepFilletAPI.cvar.ios_base_left
ios_base.oct = _BRepFilletAPI.cvar.ios_base_oct
ios_base.right = _BRepFilletAPI.cvar.ios_base_right
ios_base.scientific = _BRepFilletAPI.cvar.ios_base_scientific
ios_base.showbase = _BRepFilletAPI.cvar.ios_base_showbase
ios_base.showpoint = _BRepFilletAPI.cvar.ios_base_showpoint
ios_base.showpos = _BRepFilletAPI.cvar.ios_base_showpos
ios_base.skipws = _BRepFilletAPI.cvar.ios_base_skipws
ios_base.unitbuf = _BRepFilletAPI.cvar.ios_base_unitbuf
ios_base.uppercase = _BRepFilletAPI.cvar.ios_base_uppercase
ios_base.adjustfield = _BRepFilletAPI.cvar.ios_base_adjustfield
ios_base.basefield = _BRepFilletAPI.cvar.ios_base_basefield
ios_base.floatfield = _BRepFilletAPI.cvar.ios_base_floatfield
ios_base.badbit = _BRepFilletAPI.cvar.ios_base_badbit
ios_base.eofbit = _BRepFilletAPI.cvar.ios_base_eofbit
ios_base.failbit = _BRepFilletAPI.cvar.ios_base_failbit
ios_base.goodbit = _BRepFilletAPI.cvar.ios_base_goodbit
ios_base.app = _BRepFilletAPI.cvar.ios_base_app
ios_base.ate = _BRepFilletAPI.cvar.ios_base_ate
ios_base.binary = _BRepFilletAPI.cvar.ios_base_binary
ios_base.ios_base_in = _BRepFilletAPI.cvar.ios_base_ios_base_in
ios_base.out = _BRepFilletAPI.cvar.ios_base_out
ios_base.trunc = _BRepFilletAPI.cvar.ios_base_trunc
ios_base.beg = _BRepFilletAPI.cvar.ios_base_beg
ios_base.cur = _BRepFilletAPI.cvar.ios_base_cur
ios_base.end = _BRepFilletAPI.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _BRepFilletAPI.ios_rdstate(self)

    def clear(self, *args):
        return _BRepFilletAPI.ios_clear(self, *args)

    def setstate(self, __state):
        return _BRepFilletAPI.ios_setstate(self, __state)

    def good(self):
        return _BRepFilletAPI.ios_good(self)

    def eof(self):
        return _BRepFilletAPI.ios_eof(self)

    def fail(self):
        return _BRepFilletAPI.ios_fail(self)

    def bad(self):
        return _BRepFilletAPI.ios_bad(self)

    def exceptions(self, *args):
        return _BRepFilletAPI.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _BRepFilletAPI.ios_swiginit(self, _BRepFilletAPI.new_ios(__sb))
    __swig_destroy__ = _BRepFilletAPI.delete_ios

    def tie(self, *args):
        return _BRepFilletAPI.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _BRepFilletAPI.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _BRepFilletAPI.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _BRepFilletAPI.ios_fill(self, *args)

    def imbue(self, __loc):
        return _BRepFilletAPI.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _BRepFilletAPI.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _BRepFilletAPI.ios_widen(self, __c)

# Register ios in _BRepFilletAPI:
_BRepFilletAPI.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepFilletAPI.ostream_swiginit(self, _BRepFilletAPI.new_ostream(__sb))
    __swig_destroy__ = _BRepFilletAPI.delete_ostream

    def __lshift__(self, *args):
        return _BRepFilletAPI.ostream___lshift__(self, *args)

    def put(self, __c):
        return _BRepFilletAPI.ostream_put(self, __c)

    def write(self, __s, __n):
        return _BRepFilletAPI.ostream_write(self, __s, __n)

    def flush(self):
        return _BRepFilletAPI.ostream_flush(self)

    def tellp(self):
        return _BRepFilletAPI.ostream_tellp(self)

    def seekp(self, *args):
        return _BRepFilletAPI.ostream_seekp(self, *args)

# Register ostream in _BRepFilletAPI:
_BRepFilletAPI.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepFilletAPI.istream_swiginit(self, _BRepFilletAPI.new_istream(__sb))
    __swig_destroy__ = _BRepFilletAPI.delete_istream

    def __rshift__(self, *args):
        return _BRepFilletAPI.istream___rshift__(self, *args)

    def gcount(self):
        return _BRepFilletAPI.istream_gcount(self)

    def get(self, *args):
        return _BRepFilletAPI.istream_get(self, *args)

    def getline(self, *args):
        return _BRepFilletAPI.istream_getline(self, *args)

    def ignore(self, *args):
        return _BRepFilletAPI.istream_ignore(self, *args)

    def peek(self):
        return _BRepFilletAPI.istream_peek(self)

    def read(self, __s, __n):
        return _BRepFilletAPI.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _BRepFilletAPI.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _BRepFilletAPI.istream_putback(self, __c)

    def unget(self):
        return _BRepFilletAPI.istream_unget(self)

    def sync(self):
        return _BRepFilletAPI.istream_sync(self)

    def tellg(self):
        return _BRepFilletAPI.istream_tellg(self)

    def seekg(self, *args):
        return _BRepFilletAPI.istream_seekg(self, *args)

# Register istream in _BRepFilletAPI:
_BRepFilletAPI.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepFilletAPI.iostream_swiginit(self, _BRepFilletAPI.new_iostream(__sb))
    __swig_destroy__ = _BRepFilletAPI.delete_iostream

# Register iostream in _BRepFilletAPI:
_BRepFilletAPI.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _BRepFilletAPI.endl_cb_ptr
endl = _BRepFilletAPI.endl
ends_cb_ptr = _BRepFilletAPI.ends_cb_ptr
ends = _BRepFilletAPI.ends
flush_cb_ptr = _BRepFilletAPI.flush_cb_ptr
flush = _BRepFilletAPI.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.BRepBuilderAPI
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.TopTools
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Geom2d
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.ChFiDS
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.Law
import OCC.Core.ChFi2d
import OCC.Core.TopOpeBRepBuild
import OCC.Core.TopOpeBRepDS
import OCC.Core.TopOpeBRepTool
import OCC.Core.BRepClass3d
import OCC.Core.IntCurveSurface
import OCC.Core.Intf
import OCC.Core.IntSurf
import OCC.Core.IntCurvesFace
import OCC.Core.BRepAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.GeomAdaptor
import OCC.Core.TopExp
import OCC.Core.Extrema
import OCC.Core.ChFi3d
import OCC.Core.BRepBlend
import OCC.Core.BlendFunc
import OCC.Core.Convert
import OCC.Core.Blend
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves
import OCC.Core.AppBlend
import OCC.Core.GeomFill
import OCC.Core.TColGeom

from enum import IntEnum
from OCC.Core.Exception import *



class BRepFilletAPI_LocalOperation(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Abscissa(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        V: TopoDS_Vertex

        Return
        -------
        float

        Description
        -----------
        Returns the abscissa of the vertex v on the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Abscissa(self, *args)

    def Add(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a contour in the builder (builds a contour of tangent edges).

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Add(self, *args)

    def Closed(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the contour of index ic is closed.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Closed(self, *args)

    def ClosedAndTangent(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the contour of index ic is closed an tangent.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_ClosedAndTangent(self, *args)

    def Contour(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        int

        Description
        -----------
        Returns the index of the contour containing the edge e, returns 0 if e doesn't belong to any contour.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Contour(self, *args)

    def Edge(self, *args):
        r"""

        Parameters
        ----------
        I: int
        J: int

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the edge j in the contour i.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Edge(self, *args)

    def FirstVertex(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the first vertex of the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_FirstVertex(self, *args)

    def LastVertex(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the last vertex of the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_LastVertex(self, *args)

    def Length(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        float

        Description
        -----------
        Returns the length the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Length(self, *args)

    def NbContours(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Number of contours.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_NbContours(self, *args)

    def NbEdges(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        int

        Description
        -----------
        Number of edges in the contour i.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_NbEdges(self, *args)

    def NbSurf(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_NbSurf(self, *args)

    def RelativeAbscissa(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        V: TopoDS_Vertex

        Return
        -------
        float

        Description
        -----------
        Returns the relative abscissa([0.,1.]) of the vertex v on the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_RelativeAbscissa(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Remove the contour containing the edge e.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Remove(self, *args)

    def Reset(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset all the fields updated by build operation and leave the algorithm in the same state than before build call. it allows contours and radius modifications to build the result another time.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Reset(self, *args)

    def ResetContour(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        None

        Description
        -----------
        Reset the contour of index ic, there is nomore information in the contour.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_ResetContour(self, *args)

    def Sect(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        IS: int

        Return
        -------
        opencascade::handle<ChFiDS_SecHArray1>

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Sect(self, *args)

    def Simulate(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_LocalOperation_Simulate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepFilletAPI.delete_BRepFilletAPI_LocalOperation

# Register BRepFilletAPI_LocalOperation in _BRepFilletAPI:
_BRepFilletAPI.BRepFilletAPI_LocalOperation_swigregister(BRepFilletAPI_LocalOperation)
class BRepFilletAPI_MakeFillet2d(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Initializes an empty algorithm for computing fillets and chamfers. the face on which the fillets and chamfers are built is defined using the init function. the vertices on which fillets or chamfers are built are defined using the addfillet or addchamfer function. warning the status of the initialization, as given by the status function, can be one of the following: - chfi2d_ready if the initialization is correct, - chfi2d_notplanar if f is not planar, - chfi2d_noface if f is a null face.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm for computing fillets and chamfers on the face f. the vertices on which fillets or chamfers are built are defined using the addfillet or addchamfer function. warning the status of the initialization, as given by the status function, can be one of the following: - chfi2d_ready if the initialization is correct, - chfi2d_notplanar if f is not planar, - chfi2d_noface if f is a null face.

        """
        _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_swiginit(self, _BRepFilletAPI.new_BRepFilletAPI_MakeFillet2d(*args))

    def AddChamfer(self, *args):
        r"""

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        D1: float
        D2: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Adds a chamfer on the face modified by this algorithm between the two adjacent edges e1 and e2, where the extremities of the chamfer are on e1 and e2 at distances d1 and d2 respectively in cases where the edges are not rectilinear, distances are measured using the curvilinear abscissa of the edges and the angle is measured with respect to the tangent at the corresponding point. the angle ang is given in radians. this function returns the chamfer and builds the resulting face.

        Parameters
        ----------
        E: TopoDS_Edge
        V: TopoDS_Vertex
        D: float
        Ang: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Adds a chamfer on the face modified by this algorithm between the two edges connected by the vertex v, where e is one of the two edges. the chamfer makes an angle ang with e and one of its extremities is on e at distance d from v. in cases where the edges are not rectilinear, distances are measured using the curvilinear abscissa of the edges and the angle is measured with respect to the tangent at the corresponding point. the angle ang is given in radians. this function returns the chamfer and builds the resulting face. warning the status of the construction, as given by the status function, can be one of the following: - chfi2d_isdone if the chamfer is built, - chfi2d_parameterserror if d1, d2, d or ang is less than or equal to zero, - chfi2d_connexionerror if: - the edge e, e1 or e2 does not belong to the initial face, or - the edges e1 and e2 are not adjacent, or - the vertex v is not one of the limit points of the edge e, - chfi2d_computationerror if the parameters of the chamfer are too large to build a chamfer between the two adjacent edges, - chfi2d_notauthorized if: - the edge e1, e2 or one of the two edges connected to v is a fillet or chamfer, or - a curve other than a straight line or an arc of a circle is used as e, e1 or e2. do not use the returned chamfer if the status of the construction is not chfi2d_isdone.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_AddChamfer(self, *args)

    def AddFillet(self, *args):
        r"""

        Parameters
        ----------
        V: TopoDS_Vertex
        Radius: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Adds a fillet of radius radius between the two edges adjacent to the vertex v on the face modified by this algorithm. the two edges do not need to be rectilinear. this function returns the fillet and builds the resulting face. warning the status of the construction, as given by the status function, can be one of the following: - chfi2d_isdone if the fillet is built, - chfi2d_connexionerror if v does not belong to the initial face, - chfi2d_computationerror if radius is too large to build a fillet between the two adjacent edges, - chfi2d_notauthorized - if one of the two edges connected to v is a fillet or chamfer, or - if a curve other than a straight line or an arc of a circle is used as e, e1 or e2. do not use the returned fillet if the status of the construction is not chfi2d_isdone. exceptions standard_negativevalue if radius is less than or equal to zero.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_AddFillet(self, *args)

    def BasisEdge(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the basis edge on the face modified by this algorithm from which the chamfered or filleted edge e is built. if e has not been modified, this function returns e. warning e is returned if it does not belong to the initial face.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_BasisEdge(self, *args)

    def ChamferEdges(self, *args):
        r"""
        Return
        -------
        TopTools_SequenceOfShape

        Description
        -----------
        Returns the table of chamfers on the face modified by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_ChamferEdges(self, *args)

    def DescendantEdge(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the chamfered or filleted edge built from the edge e on the face modified by this algorithm. if e has not been modified, this function returns e. exceptions standard_nosuchobject if the edge e does not belong to the initial face.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_DescendantEdge(self, *args)

    def FilletEdges(self, *args):
        r"""
        Return
        -------
        TopTools_SequenceOfShape

        Description
        -----------
        Returns the table of fillets on the face modified by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_FilletEdges(self, *args)

    def HasDescendant(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_HasDescendant(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes this algorithm for constructing fillets or chamfers with the face f. warning the status of the initialization, as given by the status function, can be one of the following: - chfi2d_ready if the initialization is correct, - chfi2d_notplanar if f is not planar, - chfi2d_noface if f is a null face.

        Parameters
        ----------
        RefFace: TopoDS_Face
        ModFace: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        This initialize method allow to init the builder from a face refface and another face modface which derive from refface. this is useful to modify a fillet or a chamfer already created on modface.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_Init(self, *args)

    def IsModified(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Returns true if the edge e on the face modified by this algorithm is chamfered or filleted. warning returns false if e does not belong to the face modified by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_IsModified(self, *args)

    def ModifyChamfer(self, *args):
        r"""

        Parameters
        ----------
        Chamfer: TopoDS_Edge
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        D1: float
        D2: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Modifies the chamfer chamfer on the face modified by this algorithm, where: e1 and e2 are the two adjacent edges on which chamfer is already built; the extremities of the new chamfer are on e1 and e2 at distances d1 and d2 respectively.

        Parameters
        ----------
        Chamfer: TopoDS_Edge
        E: TopoDS_Edge
        D: float
        Ang: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Modifies the chamfer chamfer on the face modified by this algorithm, where: e is one of the two adjacent edges on which chamfer is already built; the new chamfer makes an angle ang with e and one of its extremities is on e at distance d from the vertex on which the chamfer is built. in cases where the edges are not rectilinear, the distances are measured using the curvilinear abscissa of the edges and the angle is measured with respect to the tangent at the corresponding point. the angle ang is given in radians. this function returns the new chamfer and modifies the existing face. warning the status of the construction, as given by the status function, can be one of the following: - chfi2d_isdone if the chamfer is built, - chfi2d_parameterserror if d1, d2, d or ang is less than or equal to zero, - chfi2d_connexionerror if: - the edge e, e1, e2 or chamfer does not belong to the existing face, or - the edges e1 and e2 are not adjacent, - chfi2d_computationerror if the parameters of the chamfer are too large to build a chamfer between the two adjacent edges, - chfi2d_notauthorized if e1 or e2 is a fillet or chamfer. do not use the returned chamfer if the status of the construction is not chfi2d_isdone.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_ModifyChamfer(self, *args)

    def ModifyFillet(self, *args):
        r"""

        Parameters
        ----------
        Fillet: TopoDS_Edge
        Radius: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Assigns the radius radius to the fillet fillet already built on the face modified by this algorithm. this function returns the new fillet and modifies the existing face. warning the status of the construction, as given by the status function, can be one of the following: - chfi2d_isdone if the new fillet is built, - chfi2d_connexionerror if fillet does not belong to the existing face, - chfi2d_computationerror if radius is too large to build a fillet between the two adjacent edges. do not use the returned fillet if the status of the construction is not chfi2d_isdone. exceptions standard_negativevalue if radius is less than or equal to zero.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_ModifyFillet(self, *args)

    def NbChamfer(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of chamfers on the face modified by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_NbChamfer(self, *args)

    def NbCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of new curves after the shape creation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_NbCurves(self, *args)

    def NbFillet(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of fillets on the face modified by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_NbFillet(self, *args)

    def NewEdges(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Return the edges created for curve i.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_NewEdges(self, *args)

    def RemoveChamfer(self, *args):
        r"""

        Parameters
        ----------
        Chamfer: TopoDS_Edge

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Removes the chamfer chamfer already built on the face modified by this algorithm. this function returns the vertex connecting the two adjacent edges of chamfer and modifies the existing face. warning - the returned vertex is only valid if the status function returns chfi2d_isdone. - a null vertex is returned if the edge chamfer does not belong to the initial face.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_RemoveChamfer(self, *args)

    def RemoveFillet(self, *args):
        r"""

        Parameters
        ----------
        Fillet: TopoDS_Edge

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Removes the fillet fillet already built on the face modified by this algorithm. this function returns the vertex connecting the two adjacent edges of fillet and modifies the existing face. warning - the returned vertex is only valid if the status function returns chfi2d_isdone. - a null vertex is returned if the edge fillet does not belong to the initial face.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_RemoveFillet(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        ChFi2d_ConstructionError

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet2d_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepFilletAPI.delete_BRepFilletAPI_MakeFillet2d

# Register BRepFilletAPI_MakeFillet2d in _BRepFilletAPI:
_BRepFilletAPI.BRepFilletAPI_MakeFillet2d_swigregister(BRepFilletAPI_MakeFillet2d)
class BRepFilletAPI_MakeChamfer(BRepFilletAPI_LocalOperation):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm for computing chamfers on the shape s. the edges on which chamfers are built are defined using the add function.

        """
        _BRepFilletAPI.BRepFilletAPI_MakeChamfer_swiginit(self, _BRepFilletAPI.new_BRepFilletAPI_MakeChamfer(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds edge e to the table of edges used by this algorithm to build chamfers, where the parameters of the chamfer must be set after the.

        Parameters
        ----------
        Dis: float
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds edge e to the table of edges used by this algorithm to build chamfers, where the parameters of the chamfer are given by the distance dis (symmetric chamfer). the add function results in a contour being built by propagation from the edge e (i.e. the contour contains at least this edge). this contour is composed of edges of the shape which are tangential to one another and which delimit two series of tangential faces, with one series of faces being located on either side of the contour. warning nothing is done if edge e or the face f does not belong to the initial shape.

        Parameters
        ----------
        Dis1: float
        Dis2: float
        E: TopoDS_Edge
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Adds edge e to the table of edges used by this algorithm to build chamfers, where the parameters of the chamfer are given by the two distances dis1 and dis2; the face f identifies the side where dis1 is measured. the add function results in a contour being built by propagation from the edge e (i.e. the contour contains at least this edge). this contour is composed of edges of the shape which are tangential to one another and which delimit two series of tangential faces, with one series of faces being located on either side of the contour. warning nothing is done if edge e or the face f does not belong to the initial shape.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_Add(self, *args)

    def AddDA(self, *args):
        r"""

        Parameters
        ----------
        Dis: float
        Angle: float
        E: TopoDS_Edge
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Adds a fillet contour in the builder (builds a contour of tangent edges to <e> and sets the distance <dis1> and angle <angle> ( parameters of the chamfer ) ).

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_AddDA(self, *args)

    def Builder(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopOpeBRepBuild_HBuilder>

        Description
        -----------
        Returns the internal filleting algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_Builder(self, *args)

    def Dists(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        Dis1: float
        Dis2: float

        Description
        -----------
        Returns the distances dis1 and dis2 which give the parameters of the chamfer along the contour of index ic in the internal data structure of this algorithm. warning -1. is returned if ic is outside the bounds of the table of contours.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_Dists(self, *args)

    def GetDist(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        Dis: float

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_GetDist(self, *args)

    def GetDistAngle(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        Dis: float
        Angle: float

        Description
        -----------
        Gives the distances <dis> and <angle> of the fillet contour of index <ic> in the ds.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_GetDistAngle(self, *args)

    def IsDistanceAngle(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Return true if chamfer is made with distance and angle false else.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_IsDistanceAngle(self, *args)

    def IsSymetric(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Return true if chamfer symmetric false else.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_IsSymetric(self, *args)

    def IsTwoDistances(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Return true if chamfer is made with two distances false else.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_IsTwoDistances(self, *args)

    def SetDist(self, *args):
        r"""

        Parameters
        ----------
        Dis: float
        IC: int
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets the distances dis1 and dis2 which give the parameters of the chamfer along the contour of index ic generated using the add function in the internal data structure of this algorithm. the face f identifies the side where dis1 is measured. warning nothing is done if either the edge e or the face f does not belong to the initial shape.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_SetDist(self, *args)

    def SetDistAngle(self, *args):
        r"""

        Parameters
        ----------
        Dis: float
        Angle: float
        IC: int
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Set the distance <dis> and <angle> of the fillet contour of index <ic> in the ds with <dis> on <f>. if the face <f> is not one of common faces of an edge of the contour <ic>.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_SetDistAngle(self, *args)

    def SetDists(self, *args):
        r"""

        Parameters
        ----------
        Dis1: float
        Dis2: float
        IC: int
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets the distances dis1 and dis2 which give the parameters of the chamfer along the contour of index ic generated using the add function in the internal data structure of this algorithm. the face f identifies the side where dis1 is measured. warning nothing is done if either the edge e or the face f does not belong to the initial shape.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_SetDists(self, *args)

    def SetMode(self, *args):
        r"""

        Parameters
        ----------
        theMode: ChFiDS_ChamfMode

        Return
        -------
        None

        Description
        -----------
        Sets the mode of chamfer.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeChamfer_SetMode(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepFilletAPI.delete_BRepFilletAPI_MakeChamfer

# Register BRepFilletAPI_MakeChamfer in _BRepFilletAPI:
_BRepFilletAPI.BRepFilletAPI_MakeChamfer_swigregister(BRepFilletAPI_MakeChamfer)
class BRepFilletAPI_MakeFillet(BRepFilletAPI_LocalOperation):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        FShape: ChFi3d_FilletShape (optional, default to ChFi3d_Rational)

        Return
        -------
        None

        Description
        -----------
        Initializes the computation of the fillets. <fshape> sets the type of fillet surface. the default value is chfi3d_rational (classical nurbs representation of circles). chfi3d_quasiangular corresponds to a nurbs representation of circles which parameterisation matches the circle one. chfi3d_polynomial corresponds to a polynomial representation of circles.

        """
        _BRepFilletAPI.BRepFilletAPI_MakeFillet_swiginit(self, _BRepFilletAPI.new_BRepFilletAPI_MakeFillet(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a fillet contour in the builder (builds a contour of tangent edges). the radius must be set after.

        Parameters
        ----------
        Radius: float
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a fillet description in the builder - builds a contour of tangent edges, - sets the radius.

        Parameters
        ----------
        R1: float
        R2: float
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a fillet description in the builder - builds a contour of tangent edges, - sets a linear radius evolution law between the first and last vertex of the spine.

        Parameters
        ----------
        L: Law_Function
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a fillet description in the builder - builds a contour of tangent edges, - sest the radius evolution law.

        Parameters
        ----------
        UandR: TColgp_Array1OfPnt2d
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds a fillet description in the builder - builds a contour of tangent edges, - sets the radius evolution law interpolating the values given in the array uandr: //! p2d.x() = relative parameter on the spine [0,1] p2d.y() = value of the radius.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_Add(self, *args)

    def BadShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        If (hasresult()) returns the partial result.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_BadShape(self, *args)

    def Builder(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopOpeBRepBuild_HBuilder>

        Description
        -----------
        Returns the internal topology building algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_Builder(self, *args)

    def ComputedSurface(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        IS: int

        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Returns the surface number is concerning the contour ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_ComputedSurface(self, *args)

    def FaultyContour(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        int

        Description
        -----------
        For each i in [1.. nbfaultycontours] returns the index ic of the contour where the computation of the fillet failed. the method nbedges(ic) gives the number of edges in the contour ic the method edge(ic,ie) gives the edge number ie of the contour ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_FaultyContour(self, *args)

    def FaultyVertex(self, *args):
        r"""

        Parameters
        ----------
        IV: int

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the vertex where the computation failed.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_FaultyVertex(self, *args)

    def GetBounds(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        E: TopoDS_Edge

        Return
        -------
        F: float
        L: float

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_GetBounds(self, *args)

    def GetFilletShape(self, *args):
        r"""
        Return
        -------
        ChFi3d_FilletShape

        Description
        -----------
        Returns the type of fillet shape built by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_GetFilletShape(self, *args)

    def GetLaw(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        E: TopoDS_Edge

        Return
        -------
        opencascade::handle<Law_Function>

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_GetLaw(self, *args)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if a part of the result has been computed if the filling in a corner failed a shape with a hole is returned.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_HasResult(self, *args)

    def IsConstant(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the radius of the fillet along the contour of index ic in the internal data structure of this algorithm is constant, warning false is returned if ic is outside the bounds of the table of contours or if e does not belong to the contour of index ic.

        Parameters
        ----------
        IC: int
        E: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Returns true if the radius of the fillet along the edge e of the contour of index ic in the internal data structure of this algorithm is constant. warning false is returned if ic is outside the bounds of the table of contours or if e does not belong to the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_IsConstant(self, *args)

    def NbComputedSurfaces(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        int

        Description
        -----------
        Returns the number of surfaces which have been computed on the contour ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_NbComputedSurfaces(self, *args)

    def NbFaultyContours(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of contours where the computation of the fillet failed.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_NbFaultyContours(self, *args)

    def NbFaultyVertices(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of vertices where the computation failed.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_NbFaultyVertices(self, *args)

    def NbSurfaces(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of surfaces after the shape creation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_NbSurfaces(self, *args)

    def NewFaces(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Return the faces created for surface <i>.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_NewFaces(self, *args)

    def Radius(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        float

        Description
        -----------
        Returns the radius of the fillet along the contour of index ic in the internal data structure of this algorithm warning - use this function only if the radius is constant. - -1. is returned if ic is outside the bounds of the table of contours or if e does not belong to the contour of index ic.

        Parameters
        ----------
        IC: int
        E: TopoDS_Edge

        Return
        -------
        float

        Description
        -----------
        Returns the radius of the fillet along the edge e of the contour of index ic in the internal data structure of this algorithm. warning - use this function only if the radius is constant. - -1 is returned if ic is outside the bounds of the table of contours or if e does not belong to the contour of index ic.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_Radius(self, *args)

    def SetContinuity(self, *args):
        r"""

        Parameters
        ----------
        InternalContinuity: GeomAbs_Shape
        AngularTolerance: float

        Return
        -------
        None

        Description
        -----------
        Changes the parameters of continiuity internalcontinuity to produce fillet'surfaces with an continuity ci (i=0,1 or 2). by defaultinternalcontinuity = geomabs_c1. angulartolerance is the g1 tolerance between fillet and support'faces.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_SetContinuity(self, *args)

    def SetFilletShape(self, *args):
        r"""

        Parameters
        ----------
        FShape: ChFi3d_FilletShape

        Return
        -------
        None

        Description
        -----------
        Assigns fshape as the type of fillet shape built by this algorithm.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_SetFilletShape(self, *args)

    def SetLaw(self, *args):
        r"""

        Parameters
        ----------
        IC: int
        E: TopoDS_Edge
        L: Law_Function

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_SetLaw(self, *args)

    def SetParams(self, *args):
        r"""

        Parameters
        ----------
        Tang: float
        Tesp: float
        T2d: float
        TApp3d: float
        TolApp2d: float
        Fleche: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_SetParams(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        Radius: float
        IC: int
        IinC: int

        Return
        -------
        None

        Description
        -----------
        Sets the parameters of the fillet along the contour of index ic generated using the add function in the internal data structure of this algorithm, where radius is the radius of the fillet.

        Parameters
        ----------
        R1: float
        R2: float
        IC: int
        IinC: int

        Return
        -------
        None

        Description
        -----------
        Sets the parameters of the fillet along the contour of index ic generated using the add function in the internal data structure of this algorithm, where the radius of the fillet evolves according to a linear evolution law defined from r1 to r2, between the first and last vertices of the contour of index ic.

        Parameters
        ----------
        L: Law_Function
        IC: int
        IinC: int

        Return
        -------
        None

        Description
        -----------
        Sets the parameters of the fillet along the contour of index ic generated using the add function in the internal data structure of this algorithm, where the radius of the fillet evolves according to the evolution law l, between the first and last vertices of the contour of index ic.

        Parameters
        ----------
        UandR: TColgp_Array1OfPnt2d
        IC: int
        IinC: int

        Return
        -------
        None

        Description
        -----------
        Sets the parameters of the fillet along the contour of index ic generated using the add function in the internal data structure of this algorithm, where the radius of the fillet evolves according to the evolution law which interpolates the set of parameter and radius pairs given in the array uandr as follows: - the x coordinate of a point in uandr defines a relative parameter on the contour (i.e. a parameter between 0 and 1), - the y coordinate of a point in uandr gives the corresponding value of the radius, and the radius evolves between the first and last vertices of the contour of index ic.

        Parameters
        ----------
        Radius: float
        IC: int
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Assigns radius as the radius of the fillet on the edge e.

        Parameters
        ----------
        Radius: float
        IC: int
        V: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_SetRadius(self, *args)

    def StripeStatus(self, *args):
        r"""

        Parameters
        ----------
        IC: int

        Return
        -------
        ChFiDS_ErrorStatus

        Description
        -----------
        Returns the status concerning the contour ic in case of error chfids_ok: the computation is ok chfids_startsolfailure: the computation can't start, perhaps the the radius is too big chfids_twistedsurface: the computation failed because of a twisted surface chfids_walkingfailure: there is a problem in the walking chfids_error: other error different from above.

        """
        return _BRepFilletAPI.BRepFilletAPI_MakeFillet_StripeStatus(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepFilletAPI.delete_BRepFilletAPI_MakeFillet

# Register BRepFilletAPI_MakeFillet in _BRepFilletAPI:
_BRepFilletAPI.BRepFilletAPI_MakeFillet_swigregister(BRepFilletAPI_MakeFillet)



