# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepTools module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_breptools.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepTools
else:
    import _BRepTools

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepTools.delete_SwigPyIterator

    def value(self):
        return _BRepTools.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepTools.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepTools.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepTools.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepTools.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepTools.SwigPyIterator_copy(self)

    def next(self):
        return _BRepTools.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepTools.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepTools.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepTools.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepTools.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepTools.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepTools.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepTools.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepTools.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepTools.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepTools:
_BRepTools.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepTools.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _BRepTools.ios_base_erase_event
    imbue_event = _BRepTools.ios_base_imbue_event
    copyfmt_event = _BRepTools.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _BRepTools.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _BRepTools.ios_base_flags(self, *args)

    def setf(self, *args):
        return _BRepTools.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _BRepTools.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _BRepTools.ios_base_precision(self, *args)

    def width(self, *args):
        return _BRepTools.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _BRepTools.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _BRepTools.ios_base_imbue(self, __loc)

    def getloc(self):
        return _BRepTools.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _BRepTools.ios_base_xalloc()

    def iword(self, __ix):
        return _BRepTools.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _BRepTools.ios_base_pword(self, __ix)
    __swig_destroy__ = _BRepTools.delete_ios_base

# Register ios_base in _BRepTools:
_BRepTools.ios_base_swigregister(ios_base)
cvar = _BRepTools.cvar
ios_base.boolalpha = _BRepTools.cvar.ios_base_boolalpha
ios_base.dec = _BRepTools.cvar.ios_base_dec
ios_base.fixed = _BRepTools.cvar.ios_base_fixed
ios_base.hex = _BRepTools.cvar.ios_base_hex
ios_base.internal = _BRepTools.cvar.ios_base_internal
ios_base.left = _BRepTools.cvar.ios_base_left
ios_base.oct = _BRepTools.cvar.ios_base_oct
ios_base.right = _BRepTools.cvar.ios_base_right
ios_base.scientific = _BRepTools.cvar.ios_base_scientific
ios_base.showbase = _BRepTools.cvar.ios_base_showbase
ios_base.showpoint = _BRepTools.cvar.ios_base_showpoint
ios_base.showpos = _BRepTools.cvar.ios_base_showpos
ios_base.skipws = _BRepTools.cvar.ios_base_skipws
ios_base.unitbuf = _BRepTools.cvar.ios_base_unitbuf
ios_base.uppercase = _BRepTools.cvar.ios_base_uppercase
ios_base.adjustfield = _BRepTools.cvar.ios_base_adjustfield
ios_base.basefield = _BRepTools.cvar.ios_base_basefield
ios_base.floatfield = _BRepTools.cvar.ios_base_floatfield
ios_base.badbit = _BRepTools.cvar.ios_base_badbit
ios_base.eofbit = _BRepTools.cvar.ios_base_eofbit
ios_base.failbit = _BRepTools.cvar.ios_base_failbit
ios_base.goodbit = _BRepTools.cvar.ios_base_goodbit
ios_base.app = _BRepTools.cvar.ios_base_app
ios_base.ate = _BRepTools.cvar.ios_base_ate
ios_base.binary = _BRepTools.cvar.ios_base_binary
ios_base.ios_base_in = _BRepTools.cvar.ios_base_ios_base_in
ios_base.out = _BRepTools.cvar.ios_base_out
ios_base.trunc = _BRepTools.cvar.ios_base_trunc
ios_base.beg = _BRepTools.cvar.ios_base_beg
ios_base.cur = _BRepTools.cvar.ios_base_cur
ios_base.end = _BRepTools.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _BRepTools.ios_rdstate(self)

    def clear(self, *args):
        return _BRepTools.ios_clear(self, *args)

    def setstate(self, __state):
        return _BRepTools.ios_setstate(self, __state)

    def good(self):
        return _BRepTools.ios_good(self)

    def eof(self):
        return _BRepTools.ios_eof(self)

    def fail(self):
        return _BRepTools.ios_fail(self)

    def bad(self):
        return _BRepTools.ios_bad(self)

    def exceptions(self, *args):
        return _BRepTools.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _BRepTools.ios_swiginit(self, _BRepTools.new_ios(__sb))
    __swig_destroy__ = _BRepTools.delete_ios

    def tie(self, *args):
        return _BRepTools.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _BRepTools.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _BRepTools.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _BRepTools.ios_fill(self, *args)

    def imbue(self, __loc):
        return _BRepTools.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _BRepTools.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _BRepTools.ios_widen(self, __c)

# Register ios in _BRepTools:
_BRepTools.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepTools.ostream_swiginit(self, _BRepTools.new_ostream(__sb))
    __swig_destroy__ = _BRepTools.delete_ostream

    def __lshift__(self, *args):
        return _BRepTools.ostream___lshift__(self, *args)

    def put(self, __c):
        return _BRepTools.ostream_put(self, __c)

    def write(self, __s, __n):
        return _BRepTools.ostream_write(self, __s, __n)

    def flush(self):
        return _BRepTools.ostream_flush(self)

    def tellp(self):
        return _BRepTools.ostream_tellp(self)

    def seekp(self, *args):
        return _BRepTools.ostream_seekp(self, *args)

# Register ostream in _BRepTools:
_BRepTools.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepTools.istream_swiginit(self, _BRepTools.new_istream(__sb))
    __swig_destroy__ = _BRepTools.delete_istream

    def __rshift__(self, *args):
        return _BRepTools.istream___rshift__(self, *args)

    def gcount(self):
        return _BRepTools.istream_gcount(self)

    def get(self, *args):
        return _BRepTools.istream_get(self, *args)

    def getline(self, *args):
        return _BRepTools.istream_getline(self, *args)

    def ignore(self, *args):
        return _BRepTools.istream_ignore(self, *args)

    def peek(self):
        return _BRepTools.istream_peek(self)

    def read(self, __s, __n):
        return _BRepTools.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _BRepTools.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _BRepTools.istream_putback(self, __c)

    def unget(self):
        return _BRepTools.istream_unget(self)

    def sync(self):
        return _BRepTools.istream_sync(self)

    def tellg(self):
        return _BRepTools.istream_tellg(self)

    def seekg(self, *args):
        return _BRepTools.istream_seekg(self, *args)

# Register istream in _BRepTools:
_BRepTools.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _BRepTools.iostream_swiginit(self, _BRepTools.new_iostream(__sb))
    __swig_destroy__ = _BRepTools.delete_iostream

# Register iostream in _BRepTools:
_BRepTools.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _BRepTools.endl_cb_ptr
endl = _BRepTools.endl
ends_cb_ptr = _BRepTools.ends_cb_ptr
ends = _BRepTools.ends
flush_cb_ptr = _BRepTools.flush_cb_ptr
flush = _BRepTools.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.BVH
import OCC.Core.TopTools
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.Geom2d
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_BRepTools_History_Create():
    return _BRepTools.Handle_BRepTools_History_Create()

def Handle_BRepTools_History_DownCast(t):
    return _BRepTools.Handle_BRepTools_History_DownCast(t)

def Handle_BRepTools_History_IsNull(t):
    return _BRepTools.Handle_BRepTools_History_IsNull(t)

def Handle_BRepTools_Modification_Create():
    return _BRepTools.Handle_BRepTools_Modification_Create()

def Handle_BRepTools_Modification_DownCast(t):
    return _BRepTools.Handle_BRepTools_Modification_DownCast(t)

def Handle_BRepTools_Modification_IsNull(t):
    return _BRepTools.Handle_BRepTools_Modification_IsNull(t)

def Handle_BRepTools_ReShape_Create():
    return _BRepTools.Handle_BRepTools_ReShape_Create()

def Handle_BRepTools_ReShape_DownCast(t):
    return _BRepTools.Handle_BRepTools_ReShape_DownCast(t)

def Handle_BRepTools_ReShape_IsNull(t):
    return _BRepTools.Handle_BRepTools_ReShape_IsNull(t)

def Handle_BRepTools_CopyModification_Create():
    return _BRepTools.Handle_BRepTools_CopyModification_Create()

def Handle_BRepTools_CopyModification_DownCast(t):
    return _BRepTools.Handle_BRepTools_CopyModification_DownCast(t)

def Handle_BRepTools_CopyModification_IsNull(t):
    return _BRepTools.Handle_BRepTools_CopyModification_IsNull(t)

def Handle_BRepTools_GTrsfModification_Create():
    return _BRepTools.Handle_BRepTools_GTrsfModification_Create()

def Handle_BRepTools_GTrsfModification_DownCast(t):
    return _BRepTools.Handle_BRepTools_GTrsfModification_DownCast(t)

def Handle_BRepTools_GTrsfModification_IsNull(t):
    return _BRepTools.Handle_BRepTools_GTrsfModification_IsNull(t)

def Handle_BRepTools_TrsfModification_Create():
    return _BRepTools.Handle_BRepTools_TrsfModification_Create()

def Handle_BRepTools_TrsfModification_DownCast(t):
    return _BRepTools.Handle_BRepTools_TrsfModification_DownCast(t)

def Handle_BRepTools_TrsfModification_IsNull(t):
    return _BRepTools.Handle_BRepTools_TrsfModification_IsNull(t)

def Handle_BRepTools_NurbsConvertModification_Create():
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_Create()

def Handle_BRepTools_NurbsConvertModification_DownCast(t):
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_DownCast(t)

def Handle_BRepTools_NurbsConvertModification_IsNull(t):
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_IsNull(t)
class BRepTools_MapOfVertexPnt2d(OCC.Core.NCollection.NCollection_BaseMap):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_begin(self)

    def end(self):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_end(self)

    def cbegin(self):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_cbegin(self)

    def cend(self):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_cend(self)

    def __init__(self, *args):
        _BRepTools.BRepTools_MapOfVertexPnt2d_swiginit(self, _BRepTools.new_BRepTools_MapOfVertexPnt2d(*args))

    def Exchange(self, theOther):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Exchange(self, theOther)

    def Assign(self, theOther):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Assign(self, theOther)

    def Set(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Set(self, *args)

    def ReSize(self, N):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ReSize(self, N)

    def Bind(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Bind(self, *args)

    def Bound(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Bound(self, *args)

    def IsBound(self, theKey):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_UnBind(self, theKey)

    def Seek(self, theKey):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Seek(self, theKey)

    def Find(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d___call__(self, *args)

    def Clear(self, *args):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Clear(self, *args)
    __swig_destroy__ = _BRepTools.delete_BRepTools_MapOfVertexPnt2d

    def Size(self):
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Size(self)

# Register BRepTools_MapOfVertexPnt2d in _BRepTools:
_BRepTools.BRepTools_MapOfVertexPnt2d_swigregister(BRepTools_MapOfVertexPnt2d)
class breptools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ActivateTriangulation(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theTriangulationIdx: int
        theToActivateStrictly: bool (optional, default to false)

        Return
        -------
        bool

        Description
        -----------
        Activates triangulation data for each face of the shape from some deferred storage using specified shared input file system @param theshape  [in] shape to activate triangulations @param thetriangulationidx [in] index defining what triangulation should be activated. starts from 0. exception will be thrown in case of invalid negative index @param thetoactivatestrictly [in] flag to activate exactly triangulation with defined thetriangulationidx index. in true case if some face doesn't contain triangulation with this index, active triangulation will not be changed for it. else the last available triangulation will be activated. return true if at least one active triangulation was changed.

        """
        return _BRepTools.breptools_ActivateTriangulation(*args)

    @staticmethod
    def AddUVBounds(*args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the box <b> the bounding values in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the box <b> the bounding values of the wire in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the box <b> the bounding values of the edge in the parametric space of f.

        """
        return _BRepTools.breptools_AddUVBounds(*args)

    @staticmethod
    def CheckLocations(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theProblemShapes: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Check all locations of shape according criterium: atrsf.isnegative() || (abs(abs(atrsf.scalefactor()) - 1.) > toploc_location::scaleprec()) all sub-shapes having such locations are put in list theproblemshapes.

        """
        return _BRepTools.breptools_CheckLocations(*args)

    @staticmethod
    def Clean(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theForce: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Removes all cached polygonal representation of the shape, i.e. the triangulations of the faces of <s> and polygons on triangulations and polygons 3d of the edges. in case polygonal representation is the only available representation for the shape (shape does not have geometry) it is not removed. @param theshape [in] the shape to clean @param theforce [in] allows removing all polygonal representations from the shape,  including polygons on triangulations irrelevant for the faces of the given shape.

        """
        return _BRepTools.breptools_Clean(*args)

    @staticmethod
    def CleanGeometry(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Removes geometry (curves and surfaces) from all edges and faces of the shape.

        """
        return _BRepTools.breptools_CleanGeometry(*args)

    @staticmethod
    def Compare(*args):
        r"""

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the two vertices is lower than their tolerance.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the two edges is lower than their tolerance.

        """
        return _BRepTools.breptools_Compare(*args)

    @staticmethod
    def DetectClosedness(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face

        Return
        -------
        theUclosed: bool
        theVclosed: bool

        Description
        -----------
        Detect closedness of face in u and v directions.

        """
        return _BRepTools.breptools_DetectClosedness(*args)

    @staticmethod
    def Dump(*args):
        r"""

        Parameters
        ----------
        Sh: TopoDS_Shape

        Return
        -------
        S: Standard_OStream

        Description
        -----------
        Dumps the topological structure and the geometry of <sh> on the stream <s>.

        """
        return _BRepTools.breptools_Dump(*args)

    @staticmethod
    def EvalAndUpdateTol(*args):
        r"""

        Parameters
        ----------
        theE: TopoDS_Edge
        theC3d: Geom_Curve
        theC2d: Geom2d_Curve
        theS: Geom_Surface
        theF: float
        theL: float

        Return
        -------
        float

        Description
        -----------
        Evals real tolerance of edge <thee>. <thec3d>, <thec2d>, <thes>, <thef>, <thel> are correspondently 3d curve of edge, 2d curve on surface <thes> and rang of edge if calculated tolerance is more then current edge tolerance, edge is updated. method returns actual tolerance of edge.

        """
        return _BRepTools.breptools_EvalAndUpdateTol(*args)

    @staticmethod
    def IsReallyClosed(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Verifies that the edge <e> is found two times on the face <f> before calling brep_tool::isclosed.

        """
        return _BRepTools.breptools_IsReallyClosed(*args)

    @staticmethod
    def LoadAllTriangulations(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theFileSystem: OSD_FileSystem (optional, default to opencascade::handle<OSD_FileSystem>())

        Return
        -------
        bool

        Description
        -----------
        Loads all available triangulations for each face of the shape from some deferred storage using specified shared input file system @param theshape [in] shape to load triangulations @param thefilesystem [in] shared file system return true if at least one triangulation is loaded.

        """
        return _BRepTools.breptools_LoadAllTriangulations(*args)

    @staticmethod
    def LoadTriangulation(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theTriangulationIdx: int (optional, default to -1)
        theToSetAsActive: bool (optional, default to Standard_False)
        theFileSystem: OSD_FileSystem (optional, default to opencascade::handle<OSD_FileSystem>())

        Return
        -------
        bool

        Description
        -----------
        Loads triangulation data for each face of the shape from some deferred storage using specified shared input file system @param theshape [in] shape to load triangulations @param thetriangulationidx [in] index defining what triangulation should be loaded. starts from 0. -1 is used in specific case to load currently already active triangulation. if some face doesn't contain triangulation with this index, nothing will be loaded for it. exception will be thrown in case of invalid negative index @param thetosetasactive [in] flag to activate triangulation after its loading @param thefilesystem [in] shared file system return true if at least one triangulation is loaded.

        """
        return _BRepTools.breptools_LoadTriangulation(*args)

    @staticmethod
    def Map3DEdges(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        M: TopTools_IndexedMapOfShape

        Return
        -------
        None

        Description
        -----------
        Stores in the map <m> all the 3d topology edges of <s>.

        """
        return _BRepTools.breptools_Map3DEdges(*args)

    @staticmethod
    def OriEdgeInFace(*args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns the cumul of the orientation of <edge> and thc containing wire in <face>.

        """
        return _BRepTools.breptools_OriEdgeInFace(*args)

    @staticmethod
    def OuterWire(*args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Returns the outer most wire of <f>. returns a null wire if <f> has no wires.

        """
        return _BRepTools.breptools_OuterWire(*args)

    @staticmethod
    def Read(*args):
        r"""

        Parameters
        ----------
        Sh: TopoDS_Shape
        S: str
        B: BRep_Builder
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Reads a shape from <s> in returns it in <sh>. <b> is used to build the shape.

        Parameters
        ----------
        Sh: TopoDS_Shape
        File: str
        B: BRep_Builder
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Reads a shape from <file>, returns it in <sh>. <b> is used to build the shape.

        """
        return _BRepTools.breptools_Read(*args)

    @staticmethod
    def RemoveInternals(*args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape
        theForce: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Removes internal sub-shapes from the shape. the check on internal status is based on orientation of sub-shapes, classification is not performed. before removal of internal sub-shapes the algorithm checks if such removal is not going to break topological connectivity between sub-shapes. the flag <theforce> if set to true disables the connectivity check and clears the given shape from all sub-shapes with internal orientation.

        """
        return _BRepTools.breptools_RemoveInternals(*args)

    @staticmethod
    def RemoveUnusedPCurves(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Removes all the pcurves of the edges of <s> that refer to surfaces not belonging to any face of <s>.

        """
        return _BRepTools.breptools_RemoveUnusedPCurves(*args)

    @staticmethod
    def Triangulation(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theLinDefl: float
        theToCheckFreeEdges: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Verifies that each face from the shape has got a triangulation with a deflection smaller or equal to specified one and the edges a discretization on this triangulation. @param theshape [in] shape to verify @param thelindefl [in] maximum allowed linear deflection @param thetocheckfreeedges [in] if true, then free edges are required to have 3d polygon return false if input shape contains faces without triangulation, or that triangulation has worse (greater) deflection than specified one, or edges in shape lack polygons on triangulation or free edges in shape lack 3d polygons.

        """
        return _BRepTools.breptools_Triangulation(*args)

    @staticmethod
    def UVBounds(*args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Description
        -----------
        Returns in umin, umax, vmin, vmax the bounding values in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire

        Return
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Description
        -----------
        Returns in umin, umax, vmin, vmax the bounding values of the wire in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge

        Return
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Description
        -----------
        Returns in umin, umax, vmin, vmax the bounding values of the edge in the parametric space of f.

        """
        return _BRepTools.breptools_UVBounds(*args)

    @staticmethod
    def UnloadAllTriangulations(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Releases all available triangulations for each face of the shape if there is deferred storage to load them later @param theshape [in] shape to unload triangulations return true if at least one triangulation is unloaded.

        """
        return _BRepTools.breptools_UnloadAllTriangulations(*args)

    @staticmethod
    def UnloadTriangulation(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theTriangulationIdx: int (optional, default to -1)

        Return
        -------
        bool

        Description
        -----------
        Releases triangulation data for each face of the shape if there is deferred storage to load it later @param theshape [in] shape to unload triangulations @param thetriangulationidx [in] index defining what triangulation should be unloaded. starts from 0. -1 is used in specific case to unload currently already active triangulation. if some face doesn't contain triangulation with this index, nothing will be unloaded for it. exception will be thrown in case of invalid negative index return true if at least one triangulation is unloaded.

        """
        return _BRepTools.breptools_UnloadTriangulation(*args)

    @staticmethod
    def Update(*args):
        r"""

        Parameters
        ----------
        V: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Update a vertex (nothing is done).

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Update an edge, compute 2d bounding boxes.

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Update a wire (nothing is done).

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Update a face, update uv points.

        Parameters
        ----------
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Update a shell (nothing is done).

        Parameters
        ----------
        S: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Update a solid (nothing is done).

        Parameters
        ----------
        C: TopoDS_CompSolid

        Return
        -------
        None

        Description
        -----------
        Update a composite solid (nothing is done).

        Parameters
        ----------
        C: TopoDS_Compound

        Return
        -------
        None

        Description
        -----------
        Update a compound (nothing is done).

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Update a shape, call the correct update.

        """
        return _BRepTools.breptools_Update(*args)

    @staticmethod
    def UpdateFaceUVPoints(*args):
        r"""

        Parameters
        ----------
        theF: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        For each edge of the face <f> reset the uv points to the bounding points of the parametric curve of the edge on the face.

        """
        return _BRepTools.breptools_UpdateFaceUVPoints(*args)

    @staticmethod
    def Write(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        theStream: Standard_OStream

        Description
        -----------
        Writes the shape to the stream in an ascii format toptools_formatversion_version_1. this alias writes shape with triangulation data. @param theshape [in] the shape to write @param thestream [in][out] the stream to output shape into @param therange the range of progress indicator to fill in.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theWithTriangles: bool
        theWithNormals: bool
        theVersion: TopTools_FormatVersion
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        theStream: Standard_OStream

        Description
        -----------
        Writes the shape to the stream in an ascii format of specified version. @param theshape [in] the shape to write @param thestream [in][out] the stream to output shape into @param thewithtriangles [in] flag which specifies whether to save shape with (true) or without (false) triangles;  has no effect on triangulation-only geometry @param thewithnormals [in] flag which specifies whether to save triangulation with (true) or without (false) normals;  has no effect on triangulation-only geometry @param theversion [in] the toptools format version @param theprogress the range of progress indicator to fill in.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theFile: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Writes the shape to the file in an ascii format toptools_formatversion_version_1. this alias writes shape with triangulation data. @param theshape [in] the shape to write @param thefile [in] the path to file to output shape into @param theprogress the range of progress indicator to fill in.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theFile: str
        theWithTriangles: bool
        theWithNormals: bool
        theVersion: TopTools_FormatVersion
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Writes the shape to the file in an ascii format of specified version. @param theshape [in] the shape to write @param thefile [in] the path to file to output shape into @param thewithtriangles [in] flag which specifies whether to save shape with (true) or without (false) triangles;  has no effect on triangulation-only geometry @param thewithnormals [in] flag which specifies whether to save triangulation with (true) or without (false) normals;  has no effect on triangulation-only geometry @param theversion [in] the toptools format version @param theprogress the range of progress indicator to fill in.

        """
        return _BRepTools.breptools_Write(*args)

    @staticmethod
    def WriteToString(shape, full_precision=True):
        r"""Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding.Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding."""
        return _BRepTools.breptools_WriteToString(shape, full_precision)

    @staticmethod
    def ReadFromString(src):
        r"""Deserializes TopoDS_Shape from string"""
        return _BRepTools.breptools_ReadFromString(src)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepTools.breptools_swiginit(self, _BRepTools.new_breptools())
    __swig_destroy__ = _BRepTools.delete_breptools

# Register breptools in _BRepTools:
_BRepTools.breptools_swigregister(breptools)
class BRepTools_History(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    TRelationType_Removed = _BRepTools.BRepTools_History_TRelationType_Removed
    TRelationType_Generated = _BRepTools.BRepTools_History_TRelationType_Generated
    TRelationType_Modified = _BRepTools.BRepTools_History_TRelationType_Modified


    class TRelationType(IntEnum):
    	TRelationType_Removed = 0
    	TRelationType_Generated = 1
    	TRelationType_Modified = 2
    TRelationType_Removed = TRelationType.TRelationType_Removed
    TRelationType_Generated = TRelationType.TRelationType_Generated
    TRelationType_Modified = TRelationType.TRelationType_Modified


    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BRepTools.BRepTools_History_swiginit(self, _BRepTools.new_BRepTools_History(*args))

    def AddGenerated(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theGenerated: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set the second shape as generated one from the first shape.

        """
        return _BRepTools.BRepTools_History_AddGenerated(self, *args)

    def AddModified(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theModified: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set the second shape as modified one from the first shape.

        """
        return _BRepTools.BRepTools_History_AddModified(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the history.

        """
        return _BRepTools.BRepTools_History_Clear(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theS: Standard_OStream

        Description
        -----------
        Prints the brief description of the history into a stream.

        """
        return _BRepTools.BRepTools_History_Dump(self, *args)

    def Generated(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BRepTools.BRepTools_History_Generated(self, *args)

    def HasGenerated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if there any shapes with generated elements present.

        """
        return _BRepTools.BRepTools_History_HasGenerated(self, *args)

    def HasModified(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if there any modified shapes present.

        """
        return _BRepTools.BRepTools_History_HasModified(self, *args)

    def HasRemoved(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if there any removed shapes present.

        """
        return _BRepTools.BRepTools_History_HasRemoved(self, *args)

    def IsRemoved(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepTools.BRepTools_History_IsRemoved(self, *args)

    @staticmethod
    def IsSupportedType(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if the type of the shape is supported by the history.

        """
        return _BRepTools.BRepTools_History_IsSupportedType(*args)

    def Merge(self, *args):
        r"""

        Parameters
        ----------
        theHistory23: BRepTools_History

        Return
        -------
        None

        Description
        -----------
        Merges the next history to this history.

        Parameters
        ----------
        theHistory23: BRepTools_History

        Return
        -------
        None

        Description
        -----------
        Merges the next history to this history.

        """
        return _BRepTools.BRepTools_History_Merge(self, *args)

    def Modified(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BRepTools.BRepTools_History_Modified(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        theRemoved: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set the shape as removed one.

        """
        return _BRepTools.BRepTools_History_Remove(self, *args)

    def ReplaceGenerated(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theGenerated: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set the second shape as the only generated one from the first one.

        """
        return _BRepTools.BRepTools_History_ReplaceGenerated(self, *args)

    def ReplaceModified(self, *args):
        r"""

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theModified: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Set the second shape as the only modified one from the first one.

        """
        return _BRepTools.BRepTools_History_ReplaceModified(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_History_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_History

# Register BRepTools_History in _BRepTools:
_BRepTools.BRepTools_History_swigregister(BRepTools_History)
class BRepTools_Modification(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Continuity(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        F1: TopoDS_Face
        F2: TopoDS_Face
        NewE: TopoDS_Edge
        NewF1: TopoDS_Face
        NewF2: TopoDS_Face

        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns the continuity of <newe> between <newf1> and <newf2>. <newe> is the new edge created from <e>. <newf1> (resp. <newf2>) is the new face created from <f1> (resp. <f2>).

        """
        return _BRepTools.BRepTools_Modification_Continuity(self, *args)

    def NewCurve(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        C: Geom_Curve
        L: TopLoc_Location

        Return
        -------
        Tol: float

        Description
        -----------
        Returns true if the edge, e, has been modified. if the edge has been modified: - c is the new geometry associated with the edge, - l is its new location, and - tol is the new tolerance. if the edge has not been modified, this function returns false, and the values of c, l and tol are not significant.

        """
        return _BRepTools.BRepTools_Modification_NewCurve(self, *args)

    def NewCurve2d(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face
        NewE: TopoDS_Edge
        NewF: TopoDS_Face
        C: Geom2d_Curve

        Return
        -------
        Tol: float

        Description
        -----------
        Returns true if the edge, e, has a new curve on surface on the face, f. if a new curve exists: - c is the new geometry of the edge, - l is the new location, and - tol is the new tolerance. newe is the new edge created from e, and newf is the new face created from f. if there is no new curve on the face, this function returns false, and the values of c, l and tol are not significant.

        """
        return _BRepTools.BRepTools_Modification_NewCurve2d(self, *args)

    def NewParameter(self, *args):
        r"""

        Parameters
        ----------
        V: TopoDS_Vertex
        E: TopoDS_Edge

        Return
        -------
        P: float
        Tol: float

        Description
        -----------
        Returns true if the vertex v has a new parameter on the edge e. if a new parameter exists: - p is the parameter, and - tol is the new tolerance. if there is no new parameter this function returns false, and the values of p and tol are not significant.

        """
        return _BRepTools.BRepTools_Modification_NewParameter(self, *args)

    def NewPoint(self, *args):
        r"""

        Parameters
        ----------
        V: TopoDS_Vertex
        P: gp_Pnt

        Return
        -------
        Tol: float

        Description
        -----------
        Returns true if the vertex v has been modified. if v has been modified: - p is the new geometry of the vertex, and - tol is the new tolerance. if the vertex has not been modified this function returns false, and the values of p and tol are not significant.

        """
        return _BRepTools.BRepTools_Modification_NewPoint(self, *args)

    def NewPolygon(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        P: Poly_Polygon3D

        Return
        -------
        bool

        Description
        -----------
        Returns true if the edge has been modified according to changed polygon. if the edge has been modified: - p is a new polygon.

        """
        return _BRepTools.BRepTools_Modification_NewPolygon(self, *args)

    def NewPolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face
        P: Poly_PolygonOnTriangulation

        Return
        -------
        bool

        Description
        -----------
        Returns true if the edge has been modified according to changed polygon on triangulation. if the edge has been modified: - p is a new polygon on triangulation.

        """
        return _BRepTools.BRepTools_Modification_NewPolygonOnTriangulation(self, *args)

    def NewSurface(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        S: Geom_Surface
        L: TopLoc_Location

        Return
        -------
        Tol: float
        RevWires: bool
        RevFace: bool

        Description
        -----------
        Returns true if the face, f, has been modified. if the face has been modified: - s is the new geometry of the face, - l is its new location, and - tol is the new tolerance. the flag, revwires, is set to true when the modification reverses the normal of the surface, (i.e. the wires have to be reversed). the flag, revface, is set to true if the orientation of the modified face changes in the shells which contain it. if the face has not been modified this function returns false, and the values of s, l, tol, revwires and revface are not significant.

        """
        return _BRepTools.BRepTools_Modification_NewSurface(self, *args)

    def NewTriangulation(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        T: Poly_Triangulation

        Return
        -------
        bool

        Description
        -----------
        Returns true if the face has been modified according to changed triangulation. if the face has been modified: - t is a new triangulation on the face.

        """
        return _BRepTools.BRepTools_Modification_NewTriangulation(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_Modification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Modification

# Register BRepTools_Modification in _BRepTools:
_BRepTools.BRepTools_Modification_swigregister(BRepTools_Modification)
class BRepTools_Modifier(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theMutableInput: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates an empty modifier.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Creates a modifier on the shape <s>.

        Parameters
        ----------
        S: TopoDS_Shape
        M: BRepTools_Modification

        Return
        -------
        None

        Description
        -----------
        Creates a modifier on the shape <s>, and performs the modifications described by <m>.

        """
        _BRepTools.BRepTools_Modifier_swiginit(self, _BRepTools.new_BRepTools_Modifier(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initializes the modifier with the shape <s>.

        """
        return _BRepTools.BRepTools_Modifier_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the modification has been computed successfully.

        """
        return _BRepTools.BRepTools_Modifier_IsDone(self, *args)

    def IsMutableInput(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the current mutable input state.

        """
        return _BRepTools.BRepTools_Modifier_IsMutableInput(self, *args)

    def ModifiedShape(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the modified shape corresponding to <s>.

        """
        return _BRepTools.BRepTools_Modifier_ModifiedShape(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        M: BRepTools_Modification
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Performs the modifications described by <m>.

        """
        return _BRepTools.BRepTools_Modifier_Perform(self, *args)

    def SetMutableInput(self, *args):
        r"""

        Parameters
        ----------
        theMutableInput: bool

        Return
        -------
        None

        Description
        -----------
        Sets the mutable input state if true then the input (original) shape can be modified during modification process.

        """
        return _BRepTools.BRepTools_Modifier_SetMutableInput(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Modifier

# Register BRepTools_Modifier in _BRepTools:
_BRepTools.BRepTools_Modifier_swigregister(BRepTools_Modifier)
class BRepTools_PurgeLocations(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_PurgeLocations_swiginit(self, _BRepTools.new_BRepTools_PurgeLocations(*args))

    def GetResult(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns shape with removed locations.

        """
        return _BRepTools.BRepTools_PurgeLocations_GetResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepTools.BRepTools_PurgeLocations_IsDone(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Removes all locations correspodingly to criterium from theshape.

        """
        return _BRepTools.BRepTools_PurgeLocations_Perform(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ModifiedShape(self):
    	pass

    __swig_destroy__ = _BRepTools.delete_BRepTools_PurgeLocations

# Register BRepTools_PurgeLocations in _BRepTools:
_BRepTools.BRepTools_PurgeLocations_swigregister(BRepTools_PurgeLocations)
class BRepTools_Quilt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_Quilt_swiginit(self, _BRepTools.new_BRepTools_Quilt(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Add the faces of <s> to the quilt, the faces containing bounded edges are copied.

        """
        return _BRepTools.BRepTools_Quilt_Add(self, *args)

    def Bind(self, *args):
        r"""

        Parameters
        ----------
        Eold: TopoDS_Edge
        Enew: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Binds <enew> to be the new edge instead of <eold>. //! the faces of the added shape containing <eold> will be copied to substitute <eold> by <enew>. //! the vertices of <eold> will be bound to the vertices of <enew> with the same orientation. //! if <eold> and <enew> have different orientations the curves are considered to be opposite and the pcurves of <eold> will be copied and reversed in the new faces. //! <eold> must belong to the next added shape, <enew> must belong to a shape added before.

        Parameters
        ----------
        Vold: TopoDS_Vertex
        Vnew: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Binds <vnew> to be a new vertex instead of <vold>. //! the faces of the added shape containing <vold> will be copied to substitute <vold> by <vnew>.

        """
        return _BRepTools.BRepTools_Quilt_Bind(self, *args)

    def Copy(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the shape substituted to <s> in the quilt.

        """
        return _BRepTools.BRepTools_Quilt_Copy(self, *args)

    def IsCopied(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if <s> has been copied (<s> is a vertex, an edge or a face).

        """
        return _BRepTools.BRepTools_Quilt_IsCopied(self, *args)

    def Shells(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a compound of shells made from the current set of faces. the shells will be flagged as closed or not closed.

        """
        return _BRepTools.BRepTools_Quilt_Shells(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Quilt

# Register BRepTools_Quilt in _BRepTools:
_BRepTools.BRepTools_Quilt_swigregister(BRepTools_Quilt)
class BRepTools_ReShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns an empty reshape.

        """
        _BRepTools.BRepTools_ReShape_swiginit(self, _BRepTools.new_BRepTools_ReShape(*args))

    def Apply(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theUntil: TopAbs_ShapeEnum (optional, default to TopAbs_SHAPE)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Applies the substitutions requests to a shape. //! theuntil gives the level of type until which requests are taken into account. for subshapes of the type <until> no rebuild and further exploring are done. //! note: each subshape can be replaced by shape of the same type or by shape containing only shapes of that type (for example, topods_edge can be replaced by topods_edge, topods_wire or topods_compound containing topods_edges). if incompatible shape type is encountered, it is ignored and flag fail1 is set in status.

        """
        return _BRepTools.BRepTools_ReShape_Apply(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all substitutions requests.

        """
        return _BRepTools.BRepTools_ReShape_Clear(self, *args)

    def CopyVertex(self, *args):
        r"""

        Parameters
        ----------
        theV: TopoDS_Vertex
        theTol: float (optional, default to -1.0)

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns modified copy of vertex if original one is not recorded or returns modified original vertex otherwise.

        Parameters
        ----------
        theV: TopoDS_Vertex
        theNewPos: gp_Pnt
        aTol: float

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns modified copy of vertex if original one is not recorded or returns modified original vertex otherwise.

        """
        return _BRepTools.BRepTools_ReShape_CopyVertex(self, *args)

    def History(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepTools_History>

        Description
        -----------
        Returns the history of the substituted shapes.

        """
        return _BRepTools.BRepTools_ReShape_History(self, *args)

    def IsNewShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Checks if shape has been recorded by reshaper as a value.

        """
        return _BRepTools.BRepTools_ReShape_IsNewShape(self, *args)

    def IsRecorded(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Tells if a shape is recorded for replace/remove.

        """
        return _BRepTools.BRepTools_ReShape_IsRecorded(self, *args)

    def ModeConsiderLocation(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns (modifiable) the flag which defines whether location of shape take into account during replacing shapes.

        """
        return _BRepTools.BRepTools_ReShape_ModeConsiderLocation(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets a request to remove a shape whatever the orientation.

        """
        return _BRepTools.BRepTools_ReShape_Remove(self, *args)

    def Replace(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        newshape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets a request to replace a shape by a new one.

        """
        return _BRepTools.BRepTools_ReShape_Replace(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        newsh: TopoDS_Shape
        last: bool (optional, default to Standard_False)

        Return
        -------
        int

        Description
        -----------
        Returns a complete substitution status for a shape 0: not recorded, <newsh> = original <shape> < 0: to be removed, <newsh> is null > 0: to be replaced, <newsh> is a new item if <last> is false, returns status and new shape recorded in the map directly for the shape, if true and status > 0 then recursively searches for the last status and new shape.

        """
        return _BRepTools.BRepTools_ReShape_Status(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the new value for an individual shape if not recorded, returns the original shape itself if to be removed, returns a null shape else, returns the replacing item.

        """
        return _BRepTools.BRepTools_ReShape_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_ReShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_ReShape

# Register BRepTools_ReShape in _BRepTools:
_BRepTools.BRepTools_ReShape_swigregister(BRepTools_ReShape)
class BRepTools_ShapeSet(OCC.Core.TopTools.TopTools_ShapeSet):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theWithTriangles: bool (optional, default to Standard_True)
        theWithNormals: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Builds an empty shapeset. @param thewithtriangles flag to write triangulation data.

        Parameters
        ----------
        theBuilder: BRep_Builder
        theWithTriangles: bool (optional, default to Standard_True)
        theWithNormals: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Builds an empty shapeset. @param thewithtriangles flag to write triangulation data.

        """
        _BRepTools.BRepTools_ShapeSet_swiginit(self, _BRepTools.new_BRepTools_ShapeSet(*args))

    def DumpGeometry(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Dumps the geometry of me on the stream <os>.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Dumps the geometry of <s> on the stream <os>.

        """
        return _BRepTools.BRepTools_ShapeSet_DumpGeometry(self, *args)

    def DumpPolygon3D(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Dumps the 3d polygons on the stream <os>.

        """
        return _BRepTools.BRepTools_ShapeSet_DumpPolygon3D(self, *args)

    def DumpPolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Dumps the polygons on triangulation on the stream <os>.

        """
        return _BRepTools.BRepTools_ShapeSet_DumpPolygonOnTriangulation(self, *args)

    def DumpTriangulation(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Dumps the triangulation on the stream <os>.

        """
        return _BRepTools.BRepTools_ShapeSet_DumpTriangulation(self, *args)

    def IsWithNormals(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if shape should be stored triangulation with normals.

        """
        return _BRepTools.BRepTools_ShapeSet_IsWithNormals(self, *args)

    def IsWithTriangles(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if shape should be stored with triangles.

        """
        return _BRepTools.BRepTools_ShapeSet_IsWithTriangles(self, *args)

    def ReadGeometry(self, *args):
        r"""

        Parameters
        ----------
        IS: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Reads the geometry of me from the stream <is>.

        Parameters
        ----------
        T: TopAbs_ShapeEnum
        IS: str
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Reads the geometry of a shape of type <t> from the stream <is> and returns it in <s>.

        """
        return _BRepTools.BRepTools_ShapeSet_ReadGeometry(self, *args)

    def ReadPolygon3D(self, *args):
        r"""

        Parameters
        ----------
        IS: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Reads the 3d polygons of me from the stream <is>.

        """
        return _BRepTools.BRepTools_ShapeSet_ReadPolygon3D(self, *args)

    def ReadPolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------
        IS: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Reads the polygons on triangulation of me from the stream <is>.

        """
        return _BRepTools.BRepTools_ShapeSet_ReadPolygonOnTriangulation(self, *args)

    def ReadTriangulation(self, *args):
        r"""

        Parameters
        ----------
        IS: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Reads the triangulation of me from the stream <is>.

        """
        return _BRepTools.BRepTools_ShapeSet_ReadTriangulation(self, *args)

    def SetWithNormals(self, *args):
        r"""

        Parameters
        ----------
        theWithNormals: bool

        Return
        -------
        None

        Description
        -----------
        Define if shape will be stored triangulation with normals. ignored (always written) if face defines only triangulation (no surface).

        """
        return _BRepTools.BRepTools_ShapeSet_SetWithNormals(self, *args)

    def SetWithTriangles(self, *args):
        r"""

        Parameters
        ----------
        theWithTriangles: bool

        Return
        -------
        None

        Description
        -----------
        Define if shape will be stored with triangles. ignored (always written) if face defines only triangulation (no surface).

        """
        return _BRepTools.BRepTools_ShapeSet_SetWithTriangles(self, *args)

    def WriteGeometry(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Writes the geometry of me on the stream <os> in a format that can be read back by read.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Writes the geometry of <s> on the stream <os> in a format that can be read back by read.

        """
        return _BRepTools.BRepTools_ShapeSet_WriteGeometry(self, *args)

    def WritePolygon3D(self, *args):
        r"""

        Parameters
        ----------
        Compact: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Writes the 3d polygons on the stream <os> in a format that can be read back by read.

        """
        return _BRepTools.BRepTools_ShapeSet_WritePolygon3D(self, *args)

    def WritePolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------
        Compact: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Writes the polygons on triangulation on the stream <os> in a format that can be read back by read.

        """
        return _BRepTools.BRepTools_ShapeSet_WritePolygonOnTriangulation(self, *args)

    def WriteTriangulation(self, *args):
        r"""

        Parameters
        ----------
        Compact: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        OS: Standard_OStream

        Description
        -----------
        Writes the triangulation on the stream <os> in a format that can be read back by read.

        """
        return _BRepTools.BRepTools_ShapeSet_WriteTriangulation(self, *args)

    @staticmethod
    def WriteToString(shape, full_precision=True):
        r"""Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding.Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding."""
        return _BRepTools.BRepTools_ShapeSet_WriteToString(shape, full_precision)

    @staticmethod
    def ReadFromString(src):
        r"""Deserializes TopoDS_Shape from string"""
        return _BRepTools.BRepTools_ShapeSet_ReadFromString(src)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_ShapeSet

# Register BRepTools_ShapeSet in _BRepTools:
_BRepTools.BRepTools_ShapeSet_swigregister(BRepTools_ShapeSet)
class BRepTools_Substitution(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_Substitution_swiginit(self, _BRepTools.new_BRepTools_Substitution(*args))

    def Build(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Build newshape from <s> if its subshapes has modified. //! the methods <iscopied> and <copy> allows you to keep the resul of <build>.

        """
        return _BRepTools.BRepTools_Substitution_Build(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset all the fields.

        """
        return _BRepTools.BRepTools_Substitution_Clear(self, *args)

    def Copy(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the set of shapes substituted to <s>.

        """
        return _BRepTools.BRepTools_Substitution_Copy(self, *args)

    def IsCopied(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if <s> has been replaced .

        """
        return _BRepTools.BRepTools_Substitution_IsCopied(self, *args)

    def Substitute(self, *args):
        r"""

        Parameters
        ----------
        OldShape: TopoDS_Shape
        NewShapes: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        <oldshape> will be replaced by <newshapes>. //! <newshapes> can be empty , in this case <oldshape> will disparate from its ancestors. //! if an item of <newshapes> is oriented forward. it will be oriented as <oldshape> in its ancestors. else it will be reversed.

        """
        return _BRepTools.BRepTools_Substitution_Substitute(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Substitution

# Register BRepTools_Substitution in _BRepTools:
_BRepTools.BRepTools_Substitution_swigregister(BRepTools_Substitution)
class BRepTools_WireExplorer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty explorer (which can be initialized using init).

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Iinitializes an exploration of the wire <w>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>.

        """
        _BRepTools.BRepTools_WireExplorer_swiginit(self, _BRepTools.new_BRepTools_WireExplorer(*args))

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the content of the explorer.

        """
        return _BRepTools.BRepTools_WireExplorer_Clear(self, *args)

    def Current(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the current edge.

        """
        return _BRepTools.BRepTools_WireExplorer_Current(self, *args)

    def CurrentVertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the vertex connecting the current edge to the previous one.

        """
        return _BRepTools.BRepTools_WireExplorer_CurrentVertex(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Initializes an exploration of the wire <w>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Return
        -------
        None

        Description
        -----------
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>. <umin>, <umax>, <vmin>, <vmax> - the uv bounds of the face <f>.

        """
        return _BRepTools.BRepTools_WireExplorer_Init(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is a current edge.

        """
        return _BRepTools.BRepTools_WireExplorer_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Proceeds to the next edge.

        """
        return _BRepTools.BRepTools_WireExplorer_Next(self, *args)

    def Orientation(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns an orientation for the current edge.

        """
        return _BRepTools.BRepTools_WireExplorer_Orientation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_WireExplorer

# Register BRepTools_WireExplorer in _BRepTools:
_BRepTools.BRepTools_WireExplorer_swigregister(BRepTools_WireExplorer)
class BRepTools_CopyModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theCopyGeom: bool (optional, default to Standard_True)
        theCopyMesh: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Constructor. \param[in] thecopygeom indicates that the geomtery (surfaces and curves) should be copied \param[in] thecopymesh indicates that the triangulation should be copied.

        """
        _BRepTools.BRepTools_CopyModification_swiginit(self, _BRepTools.new_BRepTools_CopyModification(*args))


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_CopyModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_CopyModification

# Register BRepTools_CopyModification in _BRepTools:
_BRepTools.BRepTools_CopyModification_swigregister(BRepTools_CopyModification)
class BRepTools_GTrsfModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        T: gp_GTrsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_GTrsfModification_swiginit(self, _BRepTools.new_BRepTools_GTrsfModification(*args))

    def GTrsf(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Gives an access on the gtrsf.

        """
        return _BRepTools.BRepTools_GTrsfModification_GTrsf(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_GTrsfModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_GTrsfModification

# Register BRepTools_GTrsfModification in _BRepTools:
_BRepTools.BRepTools_GTrsfModification_swigregister(BRepTools_GTrsfModification)
class BRepTools_TrsfModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_TrsfModification_swiginit(self, _BRepTools.new_BRepTools_TrsfModification(*args))

    def GetIsCopyMesh(self):
        r"""GetIsCopyMesh(BRepTools_TrsfModification self) -> Standard_Boolean"""
        return _BRepTools.BRepTools_TrsfModification_GetIsCopyMesh(self)

    def SetIsCopyMesh(self, value):
        r"""SetIsCopyMesh(BRepTools_TrsfModification self, Standard_Boolean value)"""
        return _BRepTools.BRepTools_TrsfModification_SetIsCopyMesh(self, value)

    def Trsf(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Provides access to the gp_trsf associated with this modification. the transformation can be changed.

        """
        return _BRepTools.BRepTools_TrsfModification_Trsf(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_TrsfModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_TrsfModification

# Register BRepTools_TrsfModification in _BRepTools:
_BRepTools.BRepTools_TrsfModification_swigregister(BRepTools_TrsfModification)
class BRepTools_NurbsConvertModification(BRepTools_CopyModification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepTools.BRepTools_NurbsConvertModification_swiginit(self, _BRepTools.new_BRepTools_NurbsConvertModification(*args))

    def GetUpdatedEdges(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BRepTools.BRepTools_NurbsConvertModification_GetUpdatedEdges(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_NurbsConvertModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_NurbsConvertModification

# Register BRepTools_NurbsConvertModification in _BRepTools:
_BRepTools.BRepTools_NurbsConvertModification_swigregister(BRepTools_NurbsConvertModification)



@deprecated
def breptools_ActivateTriangulation(*args):
	return breptools.ActivateTriangulation(*args)

@deprecated
def breptools_AddUVBounds(*args):
	return breptools.AddUVBounds(*args)

@deprecated
def breptools_AddUVBounds(*args):
	return breptools.AddUVBounds(*args)

@deprecated
def breptools_AddUVBounds(*args):
	return breptools.AddUVBounds(*args)

@deprecated
def breptools_CheckLocations(*args):
	return breptools.CheckLocations(*args)

@deprecated
def breptools_Clean(*args):
	return breptools.Clean(*args)

@deprecated
def breptools_CleanGeometry(*args):
	return breptools.CleanGeometry(*args)

@deprecated
def breptools_Compare(*args):
	return breptools.Compare(*args)

@deprecated
def breptools_Compare(*args):
	return breptools.Compare(*args)

@deprecated
def breptools_DetectClosedness(*args):
	return breptools.DetectClosedness(*args)

@deprecated
def breptools_Dump(*args):
	return breptools.Dump(*args)

@deprecated
def breptools_EvalAndUpdateTol(*args):
	return breptools.EvalAndUpdateTol(*args)

@deprecated
def breptools_IsReallyClosed(*args):
	return breptools.IsReallyClosed(*args)

@deprecated
def breptools_LoadAllTriangulations(*args):
	return breptools.LoadAllTriangulations(*args)

@deprecated
def breptools_LoadTriangulation(*args):
	return breptools.LoadTriangulation(*args)

@deprecated
def breptools_Map3DEdges(*args):
	return breptools.Map3DEdges(*args)

@deprecated
def breptools_OriEdgeInFace(*args):
	return breptools.OriEdgeInFace(*args)

@deprecated
def breptools_OuterWire(*args):
	return breptools.OuterWire(*args)

@deprecated
def breptools_Read(*args):
	return breptools.Read(*args)

@deprecated
def breptools_Read(*args):
	return breptools.Read(*args)

@deprecated
def breptools_RemoveInternals(*args):
	return breptools.RemoveInternals(*args)

@deprecated
def breptools_RemoveUnusedPCurves(*args):
	return breptools.RemoveUnusedPCurves(*args)

@deprecated
def breptools_Triangulation(*args):
	return breptools.Triangulation(*args)

@deprecated
def breptools_UVBounds(*args):
	return breptools.UVBounds(*args)

@deprecated
def breptools_UVBounds(*args):
	return breptools.UVBounds(*args)

@deprecated
def breptools_UVBounds(*args):
	return breptools.UVBounds(*args)

@deprecated
def breptools_UnloadAllTriangulations(*args):
	return breptools.UnloadAllTriangulations(*args)

@deprecated
def breptools_UnloadTriangulation(*args):
	return breptools.UnloadTriangulation(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_Update(*args):
	return breptools.Update(*args)

@deprecated
def breptools_UpdateFaceUVPoints(*args):
	return breptools.UpdateFaceUVPoints(*args)

@deprecated
def breptools_Write(*args):
	return breptools.Write(*args)

@deprecated
def breptools_Write(*args):
	return breptools.Write(*args)

@deprecated
def breptools_Write(*args):
	return breptools.Write(*args)

@deprecated
def breptools_Write(*args):
	return breptools.Write(*args)

@deprecated
def BRepTools_History_IsSupportedType(*args):
	return BRepTools_History.IsSupportedType(*args)



