from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.Bnd import *
from OCC.Core.TopTools import *
from OCC.Core.Geom import *
from OCC.Core.Geom2d import *
from OCC.Core.OSD import *
from OCC.Core.TopAbs import *
from OCC.Core.BRep import *
from OCC.Core.Message import *
from OCC.Core.GeomAbs import *
from OCC.Core.TopLoc import *
from OCC.Core.gp import *
from OCC.Core.Poly import *


class breptools:
    @staticmethod
    def ActivateTriangulation(theShape: TopoDS_Shape, theTriangulationIdx: int, theToActivateStrictly: Optional[bool] = false) -> bool: ...
    @overload
    @staticmethod
    def AddUVBounds(F: TopoDS_Face, B: Bnd_Box2d) -> None: ...
    @overload
    @staticmethod
    def AddUVBounds(F: TopoDS_Face, W: TopoDS_Wire, B: Bnd_Box2d) -> None: ...
    @overload
    @staticmethod
    def AddUVBounds(F: TopoDS_Face, E: TopoDS_Edge, B: Bnd_Box2d) -> None: ...
    @staticmethod
    def CheckLocations(theS: TopoDS_Shape, theProblemShapes: TopTools_ListOfShape) -> None: ...
    @staticmethod
    def Clean(theShape: TopoDS_Shape, theForce: Optional[bool] = False) -> None: ...
    @staticmethod
    def CleanGeometry(theShape: TopoDS_Shape) -> None: ...
    @overload
    @staticmethod
    def Compare(V1: TopoDS_Vertex, V2: TopoDS_Vertex) -> bool: ...
    @overload
    @staticmethod
    def Compare(E1: TopoDS_Edge, E2: TopoDS_Edge) -> bool: ...
    @staticmethod
    def DetectClosedness(theFace: TopoDS_Face) -> Tuple[bool, bool]: ...
    @staticmethod
    def Dump(Sh: TopoDS_Shape) -> str: ...
    @staticmethod
    def EvalAndUpdateTol(theE: TopoDS_Edge, theC3d: Geom_Curve, theC2d: Geom2d_Curve, theS: Geom_Surface, theF: float, theL: float) -> float: ...
    @staticmethod
    def IsReallyClosed(E: TopoDS_Edge, F: TopoDS_Face) -> bool: ...
    @staticmethod
    def LoadAllTriangulations(theShape: TopoDS_Shape, theFileSystem: Optional[OSD_FileSystem] = OSD_FileSystem()) -> bool: ...
    @staticmethod
    def LoadTriangulation(theShape: TopoDS_Shape, theTriangulationIdx: Optional[int] = -1, theToSetAsActive: Optional[bool] = False, theFileSystem: Optional[OSD_FileSystem] = OSD_FileSystem()) -> bool: ...
    @staticmethod
    def Map3DEdges(S: TopoDS_Shape, M: TopTools_IndexedMapOfShape) -> None: ...
    @staticmethod
    def OriEdgeInFace(theEdge: TopoDS_Edge, theFace: TopoDS_Face) -> TopAbs_Orientation: ...
    @staticmethod
    def OuterWire(F: TopoDS_Face) -> TopoDS_Wire: ...
    @overload
    @staticmethod
    def Read(Sh: TopoDS_Shape, S: str, B: BRep_Builder, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    @staticmethod
    def Read(Sh: TopoDS_Shape, File: str, B: BRep_Builder, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @staticmethod
    def RemoveInternals(theS: TopoDS_Shape, theForce: Optional[bool] = False) -> None: ...
    @staticmethod
    def RemoveUnusedPCurves(S: TopoDS_Shape) -> None: ...
    @staticmethod
    def Triangulation(theShape: TopoDS_Shape, theLinDefl: float, theToCheckFreeEdges: Optional[bool] = False) -> bool: ...
    @overload
    @staticmethod
    def UVBounds(F: TopoDS_Face) -> Tuple[float, float, float, float]: ...
    @overload
    @staticmethod
    def UVBounds(F: TopoDS_Face, W: TopoDS_Wire) -> Tuple[float, float, float, float]: ...
    @overload
    @staticmethod
    def UVBounds(F: TopoDS_Face, E: TopoDS_Edge) -> Tuple[float, float, float, float]: ...
    @staticmethod
    def UnloadAllTriangulations(theShape: TopoDS_Shape) -> bool: ...
    @staticmethod
    def UnloadTriangulation(theShape: TopoDS_Shape, theTriangulationIdx: Optional[int] = -1) -> bool: ...
    @overload
    @staticmethod
    def Update(V: TopoDS_Vertex) -> None: ...
    @overload
    @staticmethod
    def Update(E: TopoDS_Edge) -> None: ...
    @overload
    @staticmethod
    def Update(W: TopoDS_Wire) -> None: ...
    @overload
    @staticmethod
    def Update(F: TopoDS_Face) -> None: ...
    @overload
    @staticmethod
    def Update(S: TopoDS_Shell) -> None: ...
    @overload
    @staticmethod
    def Update(S: TopoDS_Solid) -> None: ...
    @overload
    @staticmethod
    def Update(C: TopoDS_CompSolid) -> None: ...
    @overload
    @staticmethod
    def Update(C: TopoDS_Compound) -> None: ...
    @overload
    @staticmethod
    def Update(S: TopoDS_Shape) -> None: ...
    @staticmethod
    def UpdateFaceUVPoints(theF: TopoDS_Face) -> None: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theWithTriangles: bool, theWithNormals: bool, theVersion: TopTools_FormatVersion, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theFile: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    @staticmethod
    def Write(theShape: TopoDS_Shape, theFile: str, theWithTriangles: bool, theWithNormals: bool, theVersion: TopTools_FormatVersion, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @staticmethod
    def WriteToString(sh: TopoDS_Shape) -> str: ...
    @staticmethod
    def ReadFromString(s: str) -> TopoDS_Shape: ...

class BRepTools_History(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    def AddGenerated(self, theInitial: TopoDS_Shape, theGenerated: TopoDS_Shape) -> None: ...
    def AddModified(self, theInitial: TopoDS_Shape, theModified: TopoDS_Shape) -> None: ...
    def Clear(self) -> None: ...
    def Dump(self) -> str: ...
    def Generated(self, theInitial: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def HasGenerated(self) -> bool: ...
    def HasModified(self) -> bool: ...
    def HasRemoved(self) -> bool: ...
    def IsRemoved(self, theInitial: TopoDS_Shape) -> bool: ...
    @staticmethod
    def IsSupportedType(theShape: TopoDS_Shape) -> bool: ...
    @overload
    def Merge(self, theHistory23: BRepTools_History) -> None: ...
    @overload
    def Merge(self, theHistory23: BRepTools_History) -> None: ...
    def Modified(self, theInitial: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def Remove(self, theRemoved: TopoDS_Shape) -> None: ...
    def ReplaceGenerated(self, theInitial: TopoDS_Shape, theGenerated: TopoDS_Shape) -> None: ...
    def ReplaceModified(self, theInitial: TopoDS_Shape, theModified: TopoDS_Shape) -> None: ...

class BRepTools_Modification(Standard_Transient):
    def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, NewE: TopoDS_Edge, NewF1: TopoDS_Face, NewF2: TopoDS_Face) -> GeomAbs_Shape: ...
    def NewCurve(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location) -> Tuple[bool, float]: ...
    def NewCurve2d(self, E: TopoDS_Edge, F: TopoDS_Face, NewE: TopoDS_Edge, NewF: TopoDS_Face, C: Geom2d_Curve) -> Tuple[bool, float]: ...
    def NewParameter(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float, float]: ...
    def NewPoint(self, V: TopoDS_Vertex, P: gp_Pnt) -> Tuple[bool, float]: ...
    def NewPolygon(self, E: TopoDS_Edge, P: Poly_Polygon3D) -> bool: ...
    def NewPolygonOnTriangulation(self, E: TopoDS_Edge, F: TopoDS_Face, P: Poly_PolygonOnTriangulation) -> bool: ...
    def NewSurface(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...
    def NewTriangulation(self, F: TopoDS_Face, T: Poly_Triangulation) -> bool: ...

class BRepTools_Modifier:
    @overload
    def __init__(self, theMutableInput: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, M: BRepTools_Modification) -> None: ...
    def Init(self, S: TopoDS_Shape) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMutableInput(self) -> bool: ...
    def ModifiedShape(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
    def Perform(self, M: BRepTools_Modification, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def SetMutableInput(self, theMutableInput: bool) -> None: ...

class BRepTools_PurgeLocations:
    def __init__(self) -> None: ...
    def GetResult(self) -> TopoDS_Shape: ...
    def IsDone(self) -> bool: ...
    def Perform(self, theShape: TopoDS_Shape) -> bool: ...

class BRepTools_Quilt:
    def __init__(self) -> None: ...
    def Add(self, S: TopoDS_Shape) -> None: ...
    @overload
    def Bind(self, Eold: TopoDS_Edge, Enew: TopoDS_Edge) -> None: ...
    @overload
    def Bind(self, Vold: TopoDS_Vertex, Vnew: TopoDS_Vertex) -> None: ...
    def Copy(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
    def IsCopied(self, S: TopoDS_Shape) -> bool: ...
    def Shells(self) -> TopoDS_Shape: ...

class BRepTools_ReShape(Standard_Transient):
    def __init__(self) -> None: ...
    def Apply(self, theShape: TopoDS_Shape, theUntil: Optional[TopAbs_ShapeEnum] = TopAbs_SHAPE) -> TopoDS_Shape: ...
    def Clear(self) -> None: ...
    @overload
    def CopyVertex(self, theV: TopoDS_Vertex, theTol: Optional[float] = -1.0) -> TopoDS_Vertex: ...
    @overload
    def CopyVertex(self, theV: TopoDS_Vertex, theNewPos: gp_Pnt, aTol: float) -> TopoDS_Vertex: ...
    def History(self) -> BRepTools_History: ...
    def IsNewShape(self, theShape: TopoDS_Shape) -> bool: ...
    def IsRecorded(self, shape: TopoDS_Shape) -> bool: ...
    def ModeConsiderLocation(self) -> bool: ...
    def Remove(self, shape: TopoDS_Shape) -> None: ...
    def Replace(self, shape: TopoDS_Shape, newshape: TopoDS_Shape) -> None: ...
    def Status(self, shape: TopoDS_Shape, newsh: TopoDS_Shape, last: Optional[bool] = False) -> int: ...
    def Value(self, shape: TopoDS_Shape) -> TopoDS_Shape: ...

class BRepTools_ShapeSet(TopTools_ShapeSet):
    @overload
    def __init__(self, theWithTriangles: Optional[bool] = True, theWithNormals: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, theBuilder: BRep_Builder, theWithTriangles: Optional[bool] = True, theWithNormals: Optional[bool] = False) -> None: ...
    def AddGeometry(self, S: TopoDS_Shape) -> None: ...
    def AddShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def Check(self, T: TopAbs_ShapeEnum, S: TopoDS_Shape) -> None: ...
    def Clear(self) -> None: ...
    @overload
    def DumpGeometry(self) -> str: ...
    @overload
    def DumpGeometry(self, S: TopoDS_Shape) -> str: ...
    def DumpPolygon3D(self) -> str: ...
    def DumpPolygonOnTriangulation(self) -> str: ...
    def DumpTriangulation(self) -> str: ...
    def IsWithNormals(self) -> bool: ...
    def IsWithTriangles(self) -> bool: ...
    @overload
    def ReadGeometry(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    def ReadGeometry(self, T: TopAbs_ShapeEnum, IS: str, S: TopoDS_Shape) -> None: ...
    def ReadPolygon3D(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def ReadPolygonOnTriangulation(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def ReadTriangulation(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def SetWithNormals(self, theWithNormals: bool) -> None: ...
    def SetWithTriangles(self, theWithTriangles: bool) -> None: ...
    @overload
    def WriteGeometry(self, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    @overload
    def WriteGeometry(self, S: TopoDS_Shape) -> str: ...
    def WritePolygon3D(self, Compact: Optional[bool] = True, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    def WritePolygonOnTriangulation(self, Compact: Optional[bool] = True, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    def WriteTriangulation(self, Compact: Optional[bool] = True, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...
    @staticmethod
    def WriteToString(sh: TopoDS_Shape) -> str: ...
    @staticmethod
    def ReadFromString(s: str) -> TopoDS_Shape: ...

class BRepTools_Substitution:
    def __init__(self) -> None: ...
    def Build(self, S: TopoDS_Shape) -> None: ...
    def Clear(self) -> None: ...
    def Copy(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def IsCopied(self, S: TopoDS_Shape) -> bool: ...
    def Substitute(self, OldShape: TopoDS_Shape, NewShapes: TopTools_ListOfShape) -> None: ...

class BRepTools_WireExplorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, W: TopoDS_Wire) -> None: ...
    @overload
    def __init__(self, W: TopoDS_Wire, F: TopoDS_Face) -> None: ...
    def Clear(self) -> None: ...
    def Current(self) -> TopoDS_Edge: ...
    def CurrentVertex(self) -> TopoDS_Vertex: ...
    @overload
    def Init(self, W: TopoDS_Wire) -> None: ...
    @overload
    def Init(self, W: TopoDS_Wire, F: TopoDS_Face) -> None: ...
    @overload
    def Init(self, W: TopoDS_Wire, F: TopoDS_Face, UMin: float, UMax: float, VMin: float, VMax: float) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Orientation(self) -> TopAbs_Orientation: ...

class BRepTools_CopyModification(BRepTools_Modification):
    def __init__(self, theCopyGeom: Optional[bool] = True, theCopyMesh: Optional[bool] = True) -> None: ...
    def Continuity(self, theEdge: TopoDS_Edge, theFace1: TopoDS_Face, theFace2: TopoDS_Face, theNewEdge: TopoDS_Edge, theNewFace1: TopoDS_Face, theNewFace2: TopoDS_Face) -> GeomAbs_Shape: ...
    def NewCurve(self, theEdge: TopoDS_Edge, theCurve: Geom_Curve, theLoc: TopLoc_Location) -> Tuple[bool, float]: ...
    def NewCurve2d(self, theEdge: TopoDS_Edge, theFace: TopoDS_Face, theNewEdge: TopoDS_Edge, theNewFace: TopoDS_Face, theCurve: Geom2d_Curve) -> Tuple[bool, float]: ...
    def NewParameter(self, theVertex: TopoDS_Vertex, theEdge: TopoDS_Edge) -> Tuple[bool, float, float]: ...
    def NewPoint(self, theVertex: TopoDS_Vertex, thePnt: gp_Pnt) -> Tuple[bool, float]: ...
    def NewPolygon(self, theEdge: TopoDS_Edge, thePoly: Poly_Polygon3D) -> bool: ...
    def NewPolygonOnTriangulation(self, theEdge: TopoDS_Edge, theFace: TopoDS_Face, thePoly: Poly_PolygonOnTriangulation) -> bool: ...
    def NewSurface(self, theFace: TopoDS_Face, theSurf: Geom_Surface, theLoc: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...
    def NewTriangulation(self, theFace: TopoDS_Face, theTri: Poly_Triangulation) -> bool: ...

class BRepTools_GTrsfModification(BRepTools_Modification):
    def __init__(self, T: gp_GTrsf) -> None: ...
    def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, NewE: TopoDS_Edge, NewF1: TopoDS_Face, NewF2: TopoDS_Face) -> GeomAbs_Shape: ...
    def GTrsf(self) -> gp_GTrsf: ...
    def NewCurve(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location) -> Tuple[bool, float]: ...
    def NewCurve2d(self, E: TopoDS_Edge, F: TopoDS_Face, NewE: TopoDS_Edge, NewF: TopoDS_Face, C: Geom2d_Curve) -> Tuple[bool, float]: ...
    def NewParameter(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float, float]: ...
    def NewPoint(self, V: TopoDS_Vertex, P: gp_Pnt) -> Tuple[bool, float]: ...
    def NewPolygon(self, theEdge: TopoDS_Edge, thePoly: Poly_Polygon3D) -> bool: ...
    def NewPolygonOnTriangulation(self, theEdge: TopoDS_Edge, theFace: TopoDS_Face, thePoly: Poly_PolygonOnTriangulation) -> bool: ...
    def NewSurface(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...
    def NewTriangulation(self, theFace: TopoDS_Face, theTri: Poly_Triangulation) -> bool: ...

class BRepTools_TrsfModification(BRepTools_Modification):
    def __init__(self, T: gp_Trsf) -> None: ...
    def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, NewE: TopoDS_Edge, NewF1: TopoDS_Face, NewF2: TopoDS_Face) -> GeomAbs_Shape: ...
    def GetIsCopyMesh(self) -> bool: ...
    def SetIsCopyMesh(self, value: bool) -> None: ...
    def NewCurve(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location) -> Tuple[bool, float]: ...
    def NewCurve2d(self, E: TopoDS_Edge, F: TopoDS_Face, NewE: TopoDS_Edge, NewF: TopoDS_Face, C: Geom2d_Curve) -> Tuple[bool, float]: ...
    def NewParameter(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float, float]: ...
    def NewPoint(self, V: TopoDS_Vertex, P: gp_Pnt) -> Tuple[bool, float]: ...
    def NewPolygon(self, E: TopoDS_Edge, P: Poly_Polygon3D) -> bool: ...
    def NewPolygonOnTriangulation(self, E: TopoDS_Edge, F: TopoDS_Face, P: Poly_PolygonOnTriangulation) -> bool: ...
    def NewSurface(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...
    def NewTriangulation(self, F: TopoDS_Face, T: Poly_Triangulation) -> bool: ...
    def Trsf(self) -> gp_Trsf: ...

class BRepTools_NurbsConvertModification(BRepTools_CopyModification):
    def __init__(self) -> None: ...
    def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, NewE: TopoDS_Edge, NewF1: TopoDS_Face, NewF2: TopoDS_Face) -> GeomAbs_Shape: ...
    def GetUpdatedEdges(self) -> TopTools_ListOfShape: ...
    def NewCurve(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location) -> Tuple[bool, float]: ...
    def NewCurve2d(self, E: TopoDS_Edge, F: TopoDS_Face, NewE: TopoDS_Edge, NewF: TopoDS_Face, C: Geom2d_Curve) -> Tuple[bool, float]: ...
    def NewParameter(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float, float]: ...
    def NewPoint(self, V: TopoDS_Vertex, P: gp_Pnt) -> Tuple[bool, float]: ...
    def NewPolygon(self, theEdge: TopoDS_Edge, thePoly: Poly_Polygon3D) -> bool: ...
    def NewPolygonOnTriangulation(self, theEdge: TopoDS_Edge, theFace: TopoDS_Face, thePoly: Poly_PolygonOnTriangulation) -> bool: ...
    def NewSurface(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...
    def NewTriangulation(self, theFace: TopoDS_Face, theTri: Poly_Triangulation) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes

