from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.TColStd import *
from OCC.Core.TDocStd import *
from OCC.Core.XSControl import *
from OCC.Core.Message import *
from OCC.Core.TopoDS import *

# the following typedef cannot be wrapped as is
DE_ConfigurationVendorMap = NewType("DE_ConfigurationVendorMap", Any)

class DE_ConfigurationContext(Standard_Transient):
    def __init__(self) -> None: ...
    def BooleanVal(self, theParam: str, theDefValue: bool, theScope: Optional[str] = "") -> bool: ...
    def GetBoolean(self, theParam: str, theScope: Optional[str] = "") -> Tuple[bool, bool]: ...
    def GetInteger(self, theParam: str, theScope: Optional[str] = "") -> Tuple[bool, int]: ...
    def GetInternalMap(self) -> DE_ResourceMap: ...
    def GetReal(self, theParam: str, theScope: Optional[str] = "") -> Tuple[bool, float]: ...
    def GetString(self, theParam: str, theValue: str, theScope: Optional[str] = "") -> bool: ...
    def GetStringSeq(self, theParam: str, theValue: TColStd_ListOfAsciiString, theScope: Optional[str] = "") -> bool: ...
    def IntegerVal(self, theParam: str, theDefValue: int, theScope: Optional[str] = "") -> int: ...
    def IsParamSet(self, theParam: str, theScope: Optional[str] = "") -> bool: ...
    def Load(self, theConfiguration: str) -> bool: ...
    def LoadFile(self, theFile: str) -> bool: ...
    def LoadStr(self, theResource: str) -> bool: ...
    def RealVal(self, theParam: str, theDefValue: float, theScope: Optional[str] = "") -> float: ...
    def StringVal(self, theParam: str, theDefValue: str, theScope: Optional[str] = "") -> str: ...

class DE_ConfigurationNode(Standard_Transient):
    def BuildProvider(self) -> DE_Provider: ...
    def CheckContent(self, theBuffer: NCollection_Buffer) -> bool: ...
    def CheckExtension(self, theExtension: str) -> bool: ...
    def Copy(self) -> DE_ConfigurationNode: ...
    def GetExtensions(self) -> TColStd_ListOfAsciiString: ...
    def GetFormat(self) -> str: ...
    def GetVendor(self) -> str: ...
    def IsEnabled(self) -> bool: ...
    def IsExportSupported(self) -> bool: ...
    def IsImportSupported(self) -> bool: ...
    @overload
    def Load(self, theResourcePath: Optional[str] = "") -> bool: ...
    @overload
    def Load(self, theResource: DE_ConfigurationContext) -> bool: ...
    @overload
    def Save(self, theResourcePath: str) -> bool: ...
    @overload
    def Save(self) -> str: ...
    def SetEnabled(self, theIsLoaded: bool) -> None: ...
    def UpdateLoad(self, theToImport: bool, theToKeep: bool) -> bool: ...

class DE_Provider(Standard_Transient):
    def GetFormat(self) -> str: ...
    def GetNode(self) -> DE_ConfigurationNode: ...
    def GetVendor(self) -> str: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    def SetNode(self, theNode: DE_ConfigurationNode) -> None: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

class DE_Wrapper(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theWrapper: DE_Wrapper) -> None: ...
    def Bind(self, theNode: DE_ConfigurationNode) -> bool: ...
    @overload
    def ChangePriority(self, theFormat: str, theVendorPriority: TColStd_ListOfAsciiString, theToDisable: Optional[bool] = False) -> None: ...
    @overload
    def ChangePriority(self, theVendorPriority: TColStd_ListOfAsciiString, theToDisable: Optional[bool] = False) -> None: ...
    def Copy(self) -> DE_Wrapper: ...
    def Find(self, theFormat: str, theVendor: str, theNode: DE_ConfigurationNode) -> bool: ...
    def FindProvider(self, thePath: str, theToImport: bool, theProvider: DE_Provider) -> bool: ...
    @staticmethod
    def GlobalLoadMutex() -> Standard_Mutex: ...
    @staticmethod
    def GlobalWrapper() -> DE_Wrapper: ...
    def KeepUpdates(self) -> bool: ...
    @overload
    def Load(self, theResource: Optional[str] = "", theIsRecursive: Optional[bool] = True) -> bool: ...
    @overload
    def Load(self, theResource: DE_ConfigurationContext, theIsRecursive: Optional[bool] = True) -> bool: ...
    def Nodes(self) -> DE_ConfigurationFormatMap: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Save(self, theResourcePath: str, theIsRecursive: Optional[bool] = True, theFormats: Optional[TColStd_ListOfAsciiString] = TColStd_ListOfAsciiString(), theVendors: Optional[TColStd_ListOfAsciiString] = TColStd_ListOfAsciiString()) -> bool: ...
    @overload
    def Save(self, theIsRecursive: Optional[bool] = True, theFormats: Optional[TColStd_ListOfAsciiString] = TColStd_ListOfAsciiString(), theVendors: Optional[TColStd_ListOfAsciiString] = TColStd_ListOfAsciiString()) -> str: ...
    @staticmethod
    def SetGlobalWrapper(theWrapper: DE_Wrapper) -> None: ...
    def SetKeepUpdates(self, theToKeepUpdates: bool) -> None: ...
    def UnBind(self, theNode: DE_ConfigurationNode) -> bool: ...
    def UpdateLoad(self, theToForceUpdate: Optional[bool] = False) -> None: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

#classnotwrapped
class DE_PluginHolder: ...

# harray1 classes
# harray2 classes
# hsequence classes

