# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Geom module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_geom.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Geom
else:
    import _Geom

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Geom.delete_SwigPyIterator

    def value(self):
        return _Geom.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Geom.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Geom.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Geom.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Geom.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Geom.SwigPyIterator_copy(self)

    def next(self):
        return _Geom.SwigPyIterator_next(self)

    def __next__(self):
        return _Geom.SwigPyIterator___next__(self)

    def previous(self):
        return _Geom.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Geom.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Geom.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Geom.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Geom.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Geom.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Geom.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Geom.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Geom:
_Geom.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Geom.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Geom.ios_base_erase_event
    imbue_event = _Geom.ios_base_imbue_event
    copyfmt_event = _Geom.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Geom.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Geom.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Geom.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Geom.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Geom.ios_base_precision(self, *args)

    def width(self, *args):
        return _Geom.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Geom.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Geom.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Geom.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Geom.ios_base_xalloc()

    def iword(self, __ix):
        return _Geom.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Geom.ios_base_pword(self, __ix)
    __swig_destroy__ = _Geom.delete_ios_base

# Register ios_base in _Geom:
_Geom.ios_base_swigregister(ios_base)
cvar = _Geom.cvar
ios_base.boolalpha = _Geom.cvar.ios_base_boolalpha
ios_base.dec = _Geom.cvar.ios_base_dec
ios_base.fixed = _Geom.cvar.ios_base_fixed
ios_base.hex = _Geom.cvar.ios_base_hex
ios_base.internal = _Geom.cvar.ios_base_internal
ios_base.left = _Geom.cvar.ios_base_left
ios_base.oct = _Geom.cvar.ios_base_oct
ios_base.right = _Geom.cvar.ios_base_right
ios_base.scientific = _Geom.cvar.ios_base_scientific
ios_base.showbase = _Geom.cvar.ios_base_showbase
ios_base.showpoint = _Geom.cvar.ios_base_showpoint
ios_base.showpos = _Geom.cvar.ios_base_showpos
ios_base.skipws = _Geom.cvar.ios_base_skipws
ios_base.unitbuf = _Geom.cvar.ios_base_unitbuf
ios_base.uppercase = _Geom.cvar.ios_base_uppercase
ios_base.adjustfield = _Geom.cvar.ios_base_adjustfield
ios_base.basefield = _Geom.cvar.ios_base_basefield
ios_base.floatfield = _Geom.cvar.ios_base_floatfield
ios_base.badbit = _Geom.cvar.ios_base_badbit
ios_base.eofbit = _Geom.cvar.ios_base_eofbit
ios_base.failbit = _Geom.cvar.ios_base_failbit
ios_base.goodbit = _Geom.cvar.ios_base_goodbit
ios_base.app = _Geom.cvar.ios_base_app
ios_base.ate = _Geom.cvar.ios_base_ate
ios_base.binary = _Geom.cvar.ios_base_binary
ios_base.ios_base_in = _Geom.cvar.ios_base_ios_base_in
ios_base.out = _Geom.cvar.ios_base_out
ios_base.trunc = _Geom.cvar.ios_base_trunc
ios_base.beg = _Geom.cvar.ios_base_beg
ios_base.cur = _Geom.cvar.ios_base_cur
ios_base.end = _Geom.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Geom.ios_rdstate(self)

    def clear(self, *args):
        return _Geom.ios_clear(self, *args)

    def setstate(self, __state):
        return _Geom.ios_setstate(self, __state)

    def good(self):
        return _Geom.ios_good(self)

    def eof(self):
        return _Geom.ios_eof(self)

    def fail(self):
        return _Geom.ios_fail(self)

    def bad(self):
        return _Geom.ios_bad(self)

    def exceptions(self, *args):
        return _Geom.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Geom.ios_swiginit(self, _Geom.new_ios(__sb))
    __swig_destroy__ = _Geom.delete_ios

    def tie(self, *args):
        return _Geom.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Geom.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Geom.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Geom.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Geom.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Geom.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Geom.ios_widen(self, __c)

# Register ios in _Geom:
_Geom.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom.ostream_swiginit(self, _Geom.new_ostream(__sb))
    __swig_destroy__ = _Geom.delete_ostream

    def __lshift__(self, *args):
        return _Geom.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Geom.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Geom.ostream_write(self, __s, __n)

    def flush(self):
        return _Geom.ostream_flush(self)

    def tellp(self):
        return _Geom.ostream_tellp(self)

    def seekp(self, *args):
        return _Geom.ostream_seekp(self, *args)

# Register ostream in _Geom:
_Geom.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom.istream_swiginit(self, _Geom.new_istream(__sb))
    __swig_destroy__ = _Geom.delete_istream

    def __rshift__(self, *args):
        return _Geom.istream___rshift__(self, *args)

    def gcount(self):
        return _Geom.istream_gcount(self)

    def get(self, *args):
        return _Geom.istream_get(self, *args)

    def getline(self, *args):
        return _Geom.istream_getline(self, *args)

    def ignore(self, *args):
        return _Geom.istream_ignore(self, *args)

    def peek(self):
        return _Geom.istream_peek(self)

    def read(self, __s, __n):
        return _Geom.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Geom.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Geom.istream_putback(self, __c)

    def unget(self):
        return _Geom.istream_unget(self)

    def sync(self):
        return _Geom.istream_sync(self)

    def tellg(self):
        return _Geom.istream_tellg(self)

    def seekg(self, *args):
        return _Geom.istream_seekg(self, *args)

# Register istream in _Geom:
_Geom.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom.iostream_swiginit(self, _Geom.new_iostream(__sb))
    __swig_destroy__ = _Geom.delete_iostream

# Register iostream in _Geom:
_Geom.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Geom.endl_cb_ptr
endl = _Geom.endl
ends_cb_ptr = _Geom.ends_cb_ptr
ends = _Geom.ends
flush_cb_ptr = _Geom.flush_cb_ptr
flush = _Geom.flush
import OCC.Core.Standard
import OCC.Core.NCollection

import numpy as np

import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Geom_Geometry_Create():
    return _Geom.Handle_Geom_Geometry_Create()

def Handle_Geom_Geometry_DownCast(t):
    return _Geom.Handle_Geom_Geometry_DownCast(t)

def Handle_Geom_Geometry_IsNull(t):
    return _Geom.Handle_Geom_Geometry_IsNull(t)

def Handle_Geom_OsculatingSurface_Create():
    return _Geom.Handle_Geom_OsculatingSurface_Create()

def Handle_Geom_OsculatingSurface_DownCast(t):
    return _Geom.Handle_Geom_OsculatingSurface_DownCast(t)

def Handle_Geom_OsculatingSurface_IsNull(t):
    return _Geom.Handle_Geom_OsculatingSurface_IsNull(t)

def Handle_Geom_Transformation_Create():
    return _Geom.Handle_Geom_Transformation_Create()

def Handle_Geom_Transformation_DownCast(t):
    return _Geom.Handle_Geom_Transformation_DownCast(t)

def Handle_Geom_Transformation_IsNull(t):
    return _Geom.Handle_Geom_Transformation_IsNull(t)

def Handle_Geom_AxisPlacement_Create():
    return _Geom.Handle_Geom_AxisPlacement_Create()

def Handle_Geom_AxisPlacement_DownCast(t):
    return _Geom.Handle_Geom_AxisPlacement_DownCast(t)

def Handle_Geom_AxisPlacement_IsNull(t):
    return _Geom.Handle_Geom_AxisPlacement_IsNull(t)

def Handle_Geom_Curve_Create():
    return _Geom.Handle_Geom_Curve_Create()

def Handle_Geom_Curve_DownCast(t):
    return _Geom.Handle_Geom_Curve_DownCast(t)

def Handle_Geom_Curve_IsNull(t):
    return _Geom.Handle_Geom_Curve_IsNull(t)

def Handle_Geom_Point_Create():
    return _Geom.Handle_Geom_Point_Create()

def Handle_Geom_Point_DownCast(t):
    return _Geom.Handle_Geom_Point_DownCast(t)

def Handle_Geom_Point_IsNull(t):
    return _Geom.Handle_Geom_Point_IsNull(t)

def Handle_Geom_Surface_Create():
    return _Geom.Handle_Geom_Surface_Create()

def Handle_Geom_Surface_DownCast(t):
    return _Geom.Handle_Geom_Surface_DownCast(t)

def Handle_Geom_Surface_IsNull(t):
    return _Geom.Handle_Geom_Surface_IsNull(t)

def Handle_Geom_Vector_Create():
    return _Geom.Handle_Geom_Vector_Create()

def Handle_Geom_Vector_DownCast(t):
    return _Geom.Handle_Geom_Vector_DownCast(t)

def Handle_Geom_Vector_IsNull(t):
    return _Geom.Handle_Geom_Vector_IsNull(t)

def Handle_Geom_Axis1Placement_Create():
    return _Geom.Handle_Geom_Axis1Placement_Create()

def Handle_Geom_Axis1Placement_DownCast(t):
    return _Geom.Handle_Geom_Axis1Placement_DownCast(t)

def Handle_Geom_Axis1Placement_IsNull(t):
    return _Geom.Handle_Geom_Axis1Placement_IsNull(t)

def Handle_Geom_Axis2Placement_Create():
    return _Geom.Handle_Geom_Axis2Placement_Create()

def Handle_Geom_Axis2Placement_DownCast(t):
    return _Geom.Handle_Geom_Axis2Placement_DownCast(t)

def Handle_Geom_Axis2Placement_IsNull(t):
    return _Geom.Handle_Geom_Axis2Placement_IsNull(t)

def Handle_Geom_BoundedCurve_Create():
    return _Geom.Handle_Geom_BoundedCurve_Create()

def Handle_Geom_BoundedCurve_DownCast(t):
    return _Geom.Handle_Geom_BoundedCurve_DownCast(t)

def Handle_Geom_BoundedCurve_IsNull(t):
    return _Geom.Handle_Geom_BoundedCurve_IsNull(t)

def Handle_Geom_BoundedSurface_Create():
    return _Geom.Handle_Geom_BoundedSurface_Create()

def Handle_Geom_BoundedSurface_DownCast(t):
    return _Geom.Handle_Geom_BoundedSurface_DownCast(t)

def Handle_Geom_BoundedSurface_IsNull(t):
    return _Geom.Handle_Geom_BoundedSurface_IsNull(t)

def Handle_Geom_CartesianPoint_Create():
    return _Geom.Handle_Geom_CartesianPoint_Create()

def Handle_Geom_CartesianPoint_DownCast(t):
    return _Geom.Handle_Geom_CartesianPoint_DownCast(t)

def Handle_Geom_CartesianPoint_IsNull(t):
    return _Geom.Handle_Geom_CartesianPoint_IsNull(t)

def Handle_Geom_Conic_Create():
    return _Geom.Handle_Geom_Conic_Create()

def Handle_Geom_Conic_DownCast(t):
    return _Geom.Handle_Geom_Conic_DownCast(t)

def Handle_Geom_Conic_IsNull(t):
    return _Geom.Handle_Geom_Conic_IsNull(t)

def Handle_Geom_Direction_Create():
    return _Geom.Handle_Geom_Direction_Create()

def Handle_Geom_Direction_DownCast(t):
    return _Geom.Handle_Geom_Direction_DownCast(t)

def Handle_Geom_Direction_IsNull(t):
    return _Geom.Handle_Geom_Direction_IsNull(t)

def Handle_Geom_ElementarySurface_Create():
    return _Geom.Handle_Geom_ElementarySurface_Create()

def Handle_Geom_ElementarySurface_DownCast(t):
    return _Geom.Handle_Geom_ElementarySurface_DownCast(t)

def Handle_Geom_ElementarySurface_IsNull(t):
    return _Geom.Handle_Geom_ElementarySurface_IsNull(t)

def Handle_Geom_Line_Create():
    return _Geom.Handle_Geom_Line_Create()

def Handle_Geom_Line_DownCast(t):
    return _Geom.Handle_Geom_Line_DownCast(t)

def Handle_Geom_Line_IsNull(t):
    return _Geom.Handle_Geom_Line_IsNull(t)

def Handle_Geom_OffsetCurve_Create():
    return _Geom.Handle_Geom_OffsetCurve_Create()

def Handle_Geom_OffsetCurve_DownCast(t):
    return _Geom.Handle_Geom_OffsetCurve_DownCast(t)

def Handle_Geom_OffsetCurve_IsNull(t):
    return _Geom.Handle_Geom_OffsetCurve_IsNull(t)

def Handle_Geom_OffsetSurface_Create():
    return _Geom.Handle_Geom_OffsetSurface_Create()

def Handle_Geom_OffsetSurface_DownCast(t):
    return _Geom.Handle_Geom_OffsetSurface_DownCast(t)

def Handle_Geom_OffsetSurface_IsNull(t):
    return _Geom.Handle_Geom_OffsetSurface_IsNull(t)

def Handle_Geom_SweptSurface_Create():
    return _Geom.Handle_Geom_SweptSurface_Create()

def Handle_Geom_SweptSurface_DownCast(t):
    return _Geom.Handle_Geom_SweptSurface_DownCast(t)

def Handle_Geom_SweptSurface_IsNull(t):
    return _Geom.Handle_Geom_SweptSurface_IsNull(t)

def Handle_Geom_VectorWithMagnitude_Create():
    return _Geom.Handle_Geom_VectorWithMagnitude_Create()

def Handle_Geom_VectorWithMagnitude_DownCast(t):
    return _Geom.Handle_Geom_VectorWithMagnitude_DownCast(t)

def Handle_Geom_VectorWithMagnitude_IsNull(t):
    return _Geom.Handle_Geom_VectorWithMagnitude_IsNull(t)

def Handle_Geom_BSplineCurve_Create():
    return _Geom.Handle_Geom_BSplineCurve_Create()

def Handle_Geom_BSplineCurve_DownCast(t):
    return _Geom.Handle_Geom_BSplineCurve_DownCast(t)

def Handle_Geom_BSplineCurve_IsNull(t):
    return _Geom.Handle_Geom_BSplineCurve_IsNull(t)

def Handle_Geom_BSplineSurface_Create():
    return _Geom.Handle_Geom_BSplineSurface_Create()

def Handle_Geom_BSplineSurface_DownCast(t):
    return _Geom.Handle_Geom_BSplineSurface_DownCast(t)

def Handle_Geom_BSplineSurface_IsNull(t):
    return _Geom.Handle_Geom_BSplineSurface_IsNull(t)

def Handle_Geom_BezierCurve_Create():
    return _Geom.Handle_Geom_BezierCurve_Create()

def Handle_Geom_BezierCurve_DownCast(t):
    return _Geom.Handle_Geom_BezierCurve_DownCast(t)

def Handle_Geom_BezierCurve_IsNull(t):
    return _Geom.Handle_Geom_BezierCurve_IsNull(t)

def Handle_Geom_BezierSurface_Create():
    return _Geom.Handle_Geom_BezierSurface_Create()

def Handle_Geom_BezierSurface_DownCast(t):
    return _Geom.Handle_Geom_BezierSurface_DownCast(t)

def Handle_Geom_BezierSurface_IsNull(t):
    return _Geom.Handle_Geom_BezierSurface_IsNull(t)

def Handle_Geom_Circle_Create():
    return _Geom.Handle_Geom_Circle_Create()

def Handle_Geom_Circle_DownCast(t):
    return _Geom.Handle_Geom_Circle_DownCast(t)

def Handle_Geom_Circle_IsNull(t):
    return _Geom.Handle_Geom_Circle_IsNull(t)

def Handle_Geom_ConicalSurface_Create():
    return _Geom.Handle_Geom_ConicalSurface_Create()

def Handle_Geom_ConicalSurface_DownCast(t):
    return _Geom.Handle_Geom_ConicalSurface_DownCast(t)

def Handle_Geom_ConicalSurface_IsNull(t):
    return _Geom.Handle_Geom_ConicalSurface_IsNull(t)

def Handle_Geom_CylindricalSurface_Create():
    return _Geom.Handle_Geom_CylindricalSurface_Create()

def Handle_Geom_CylindricalSurface_DownCast(t):
    return _Geom.Handle_Geom_CylindricalSurface_DownCast(t)

def Handle_Geom_CylindricalSurface_IsNull(t):
    return _Geom.Handle_Geom_CylindricalSurface_IsNull(t)

def Handle_Geom_Ellipse_Create():
    return _Geom.Handle_Geom_Ellipse_Create()

def Handle_Geom_Ellipse_DownCast(t):
    return _Geom.Handle_Geom_Ellipse_DownCast(t)

def Handle_Geom_Ellipse_IsNull(t):
    return _Geom.Handle_Geom_Ellipse_IsNull(t)

def Handle_Geom_Hyperbola_Create():
    return _Geom.Handle_Geom_Hyperbola_Create()

def Handle_Geom_Hyperbola_DownCast(t):
    return _Geom.Handle_Geom_Hyperbola_DownCast(t)

def Handle_Geom_Hyperbola_IsNull(t):
    return _Geom.Handle_Geom_Hyperbola_IsNull(t)

def Handle_Geom_Parabola_Create():
    return _Geom.Handle_Geom_Parabola_Create()

def Handle_Geom_Parabola_DownCast(t):
    return _Geom.Handle_Geom_Parabola_DownCast(t)

def Handle_Geom_Parabola_IsNull(t):
    return _Geom.Handle_Geom_Parabola_IsNull(t)

def Handle_Geom_Plane_Create():
    return _Geom.Handle_Geom_Plane_Create()

def Handle_Geom_Plane_DownCast(t):
    return _Geom.Handle_Geom_Plane_DownCast(t)

def Handle_Geom_Plane_IsNull(t):
    return _Geom.Handle_Geom_Plane_IsNull(t)

def Handle_Geom_RectangularTrimmedSurface_Create():
    return _Geom.Handle_Geom_RectangularTrimmedSurface_Create()

def Handle_Geom_RectangularTrimmedSurface_DownCast(t):
    return _Geom.Handle_Geom_RectangularTrimmedSurface_DownCast(t)

def Handle_Geom_RectangularTrimmedSurface_IsNull(t):
    return _Geom.Handle_Geom_RectangularTrimmedSurface_IsNull(t)

def Handle_Geom_SphericalSurface_Create():
    return _Geom.Handle_Geom_SphericalSurface_Create()

def Handle_Geom_SphericalSurface_DownCast(t):
    return _Geom.Handle_Geom_SphericalSurface_DownCast(t)

def Handle_Geom_SphericalSurface_IsNull(t):
    return _Geom.Handle_Geom_SphericalSurface_IsNull(t)

def Handle_Geom_SurfaceOfLinearExtrusion_Create():
    return _Geom.Handle_Geom_SurfaceOfLinearExtrusion_Create()

def Handle_Geom_SurfaceOfLinearExtrusion_DownCast(t):
    return _Geom.Handle_Geom_SurfaceOfLinearExtrusion_DownCast(t)

def Handle_Geom_SurfaceOfLinearExtrusion_IsNull(t):
    return _Geom.Handle_Geom_SurfaceOfLinearExtrusion_IsNull(t)

def Handle_Geom_SurfaceOfRevolution_Create():
    return _Geom.Handle_Geom_SurfaceOfRevolution_Create()

def Handle_Geom_SurfaceOfRevolution_DownCast(t):
    return _Geom.Handle_Geom_SurfaceOfRevolution_DownCast(t)

def Handle_Geom_SurfaceOfRevolution_IsNull(t):
    return _Geom.Handle_Geom_SurfaceOfRevolution_IsNull(t)

def Handle_Geom_ToroidalSurface_Create():
    return _Geom.Handle_Geom_ToroidalSurface_Create()

def Handle_Geom_ToroidalSurface_DownCast(t):
    return _Geom.Handle_Geom_ToroidalSurface_DownCast(t)

def Handle_Geom_ToroidalSurface_IsNull(t):
    return _Geom.Handle_Geom_ToroidalSurface_IsNull(t)

def Handle_Geom_TrimmedCurve_Create():
    return _Geom.Handle_Geom_TrimmedCurve_Create()

def Handle_Geom_TrimmedCurve_DownCast(t):
    return _Geom.Handle_Geom_TrimmedCurve_DownCast(t)

def Handle_Geom_TrimmedCurve_IsNull(t):
    return _Geom.Handle_Geom_TrimmedCurve_IsNull(t)

def Handle_Geom_HSequenceOfBSplineSurface_Create():
    return _Geom.Handle_Geom_HSequenceOfBSplineSurface_Create()

def Handle_Geom_HSequenceOfBSplineSurface_DownCast(t):
    return _Geom.Handle_Geom_HSequenceOfBSplineSurface_DownCast(t)

def Handle_Geom_HSequenceOfBSplineSurface_IsNull(t):
    return _Geom.Handle_Geom_HSequenceOfBSplineSurface_IsNull(t)
class Geom_SequenceOfBSplineSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Geom.Geom_SequenceOfBSplineSurface_begin(self)

    def end(self):
        return _Geom.Geom_SequenceOfBSplineSurface_end(self)

    def cbegin(self):
        return _Geom.Geom_SequenceOfBSplineSurface_cbegin(self)

    def cend(self):
        return _Geom.Geom_SequenceOfBSplineSurface_cend(self)

    def __init__(self, *args):
        _Geom.Geom_SequenceOfBSplineSurface_swiginit(self, _Geom.new_Geom_SequenceOfBSplineSurface(*args))

    def Size(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Size(self)

    def Length(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Length(self)

    def Lower(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Lower(self)

    def Upper(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Upper(self)

    def IsEmpty(self):
        return _Geom.Geom_SequenceOfBSplineSurface_IsEmpty(self)

    def Reverse(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Reverse(self)

    def Exchange(self, I, J):
        return _Geom.Geom_SequenceOfBSplineSurface_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Geom.Geom_SequenceOfBSplineSurface_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Geom.Geom_SequenceOfBSplineSurface_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Geom.Geom_SequenceOfBSplineSurface_Assign(self, theOther)

    def Set(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_Set(self, *args)

    def Remove(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_Remove(self, *args)

    def Append(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_Append(self, *args)

    def Prepend(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Geom.Geom_SequenceOfBSplineSurface_Split(self, theIndex, theSeq)

    def First(self):
        return _Geom.Geom_SequenceOfBSplineSurface_First(self)

    def ChangeFirst(self):
        return _Geom.Geom_SequenceOfBSplineSurface_ChangeFirst(self)

    def Last(self):
        return _Geom.Geom_SequenceOfBSplineSurface_Last(self)

    def ChangeLast(self):
        return _Geom.Geom_SequenceOfBSplineSurface_ChangeLast(self)

    def Value(self, theIndex):
        return _Geom.Geom_SequenceOfBSplineSurface_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Geom.Geom_SequenceOfBSplineSurface_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Geom.Geom_SequenceOfBSplineSurface___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Geom.Geom_SequenceOfBSplineSurface_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Geom.delete_Geom_SequenceOfBSplineSurface

    def __len__(self):
        return self.Size()


# Register Geom_SequenceOfBSplineSurface in _Geom:
_Geom.Geom_SequenceOfBSplineSurface_swigregister(Geom_SequenceOfBSplineSurface)
class Geom_Geometry(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Copy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        Creates a new object which is a copy of this geometric object.

        """
        return _Geom.Geom_Geometry_Copy(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Geometry_DumpJson(self, depth)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a geometry with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a geometry with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a geometry with respect to a plane. the axis placement a2 locates the plane of the symmetry: (location, xdirection, ydirection).

        """
        return _Geom.Geom_Geometry_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_Geometry_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Return
        -------
        None

        Description
        -----------
        Rotates a geometry. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        """
        return _Geom.Geom_Geometry_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_Geometry_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Return
        -------
        None

        Description
        -----------
        Scales a geometry. s is the scaling value.

        """
        return _Geom.Geom_Geometry_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_Geometry_Scaled(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Transformation of a geometric object. this tansformation can be a translation, a rotation, a symmetry, a scaling or a complex transformation obtained by combination of the previous elementaries transformations. (see class transformation of the package geom).

        """
        return _Geom.Geom_Geometry_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_Geometry_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Translates a geometry. v is the vector of the translation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Translates a geometry from the point p1 to the point p2.

        """
        return _Geom.Geom_Geometry_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_Geometry_Translated(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Geometry_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Geometry

# Register Geom_Geometry in _Geom:
_Geom.Geom_Geometry_swigregister(Geom_Geometry)
class Geom_OsculatingSurface(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        BS: Geom_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Detects if the surface has punctual u or v isoparametric curve along on the bounds of the surface relatively to the tolerance tol and builds the corresponding osculating surfaces.

        """
        _Geom.Geom_OsculatingSurface_swiginit(self, _Geom.new_Geom_OsculatingSurface(*args))

    def BasisSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_OsculatingSurface_BasisSurface(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_OsculatingSurface_DumpJson(self, depth)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        BS: Geom_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_OsculatingSurface_Init(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_OsculatingSurface_Tolerance(self, *args)

    def UOscSurf(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        L: Geom_BSplineSurface

        Return
        -------
        t: bool

        Description
        -----------
        If standard_true, l is the local osculating surface along u at the point u,v.

        """
        return _Geom.Geom_OsculatingSurface_UOscSurf(self, *args)

    def VOscSurf(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        L: Geom_BSplineSurface

        Return
        -------
        t: bool

        Description
        -----------
        If standard_true, l is the local osculating surface along v at the point u,v.

        """
        return _Geom.Geom_OsculatingSurface_VOscSurf(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_OsculatingSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_OsculatingSurface

# Register Geom_OsculatingSurface in _Geom:
_Geom.Geom_OsculatingSurface_swigregister(Geom_OsculatingSurface)
class Geom_Transformation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an identity transformation.

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Creates a transient copy of t.

        """
        _Geom.Geom_Transformation_swiginit(self, _Geom.new_Geom_Transformation(*args))

    def Copy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Transformation>

        Description
        -----------
        Creates a new object which is a copy of this transformation.

        """
        return _Geom.Geom_Transformation_Copy(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Transformation_DumpJson(self, depth)

    def Form(self, *args):
        r"""
        Return
        -------
        gp_TrsfForm

        Description
        -----------
        Returns the nature of this transformation as a value of the gp_trsfform enumeration.

        """
        return _Geom.Geom_Transformation_Form(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Raised if the transformation is singular. this means that the scalefactor is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_Transformation_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Transformation>

        Description
        -----------
        Raised if the transformation is singular. this means that the scalefactor is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_Transformation_Inverted(self, *args)

    def IsNegative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks whether this transformation is an indirect transformation: returns true if the determinant of the matrix of the vectorial part of the transformation is less than 0.

        """
        return _Geom.Geom_Transformation_IsNegative(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Transformation

        Return
        -------
        opencascade::handle<Geom_Transformation>

        Description
        -----------
        Computes the transformation composed with other and <self>. <self> * other. returns a new transformation.

        """
        return _Geom.Geom_Transformation_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: Geom_Transformation

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed with other and <self> . <self> = <self> * other.

        """
        return _Geom.Geom_Transformation_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        None

        Description
        -----------
        Computes the following composition of transformations if n > 0 <self> * <self> * .......* <self>. if n = 0 identity if n < 0 <self>.invert() * .........* <self>.invert() //! raised if n < 0 and if the transformation is not inversible.

        """
        return _Geom.Geom_Transformation_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        opencascade::handle<Geom_Transformation>

        Description
        -----------
        Raised if n < 0 and if the transformation is not inversible.

        """
        return _Geom.Geom_Transformation_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Transformation

        Return
        -------
        None

        Description
        -----------
        Computes the matrix of the transformation composed with <self> and other. <self> = other * <self>.

        """
        return _Geom.Geom_Transformation_PreMultiply(self, *args)

    def ScaleFactor(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the scale value of the transformation.

        """
        return _Geom.Geom_Transformation_ScaleFactor(self, *args)

    def SetMirror(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation with respect to a point p. p is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation with respect to an axis a1. a1 is the center of the axial symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation with respect to a plane. the plane of the symmetry is defined with the axis placement a2. it is the plane (location, xdirection, ydirection).

        """
        return _Geom.Geom_Transformation_SetMirror(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a rotation. a1 is the axis rotation and ang is the angular value of the rotation in radians.

        """
        return _Geom.Geom_Transformation_SetRotation(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_Pnt
        theScale: float

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a scale. p is the center of the scale and s is the scaling value.

        """
        return _Geom.Geom_Transformation_SetScale(self, *args)

    def SetTransformation(self, *args):
        r"""

        Parameters
        ----------
        theFromSystem1: gp_Ax3
        theToSystem2: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Makes a transformation allowing passage from the coordinate system 'fromsystem1' to the coordinate system 'tosystem2'. example: in a c++ implementation: real x1, y1, z1; // are the coordinates of a point in the // local system fromsystem1 real x2, y2, z2; // are the coordinates of a point in the // local system tosystem2 gp_pnt p1 (x1, y1, z1) geom_transformation t; t.settransformation (fromsystem1, tosystem2); gp_pnt p2 = p1.transformed (t); p2.coord (x2, y2, z2);.

        Parameters
        ----------
        theToSystem: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Makes the transformation allowing passage from the basic coordinate system {p(0.,0.,0.), vx (1.,0.,0.), vy (0.,1.,0.), vz (0., 0. ,1.) } to the local coordinate system defined with the ax2 tosystem. same utilisation as the previous method. fromsystem1 is defaulted to the absolute coordinate system.

        """
        return _Geom.Geom_Transformation_SetTransformation(self, *args)

    def SetTranslation(self, *args):
        r"""

        Parameters
        ----------
        theVec: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a translation. v is the vector of the translation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a translation from the point p1 to the point p2.

        """
        return _Geom.Geom_Transformation_SetTranslation(self, *args)

    def SetTrsf(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Converts the gp_trsf transformation t into this transformation.

        """
        return _Geom.Geom_Transformation_SetTrsf(self, *args)

    def Transforms(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float
        theZ: float

        Description
        -----------
        Applies the transformation <self> to the triplet {x, y, z}.

        """
        return _Geom.Geom_Transformation_Transforms(self, *args)

    def Trsf(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Returns a non transient copy of <self>.

        """
        return _Geom.Geom_Transformation_Trsf(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficients of the global matrix of transformation. it is a 3 rows x 4 columns matrix. //! raised if row < 1 or row > 3 or col < 1 or col > 4.

        """
        return _Geom.Geom_Transformation_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Transformation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Transformation

# Register Geom_Transformation in _Geom:
_Geom.Geom_Transformation_swigregister(Geom_Transformation)
class Geom_AxisPlacement(Geom_Geometry):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_AxisPlacement

        Return
        -------
        float

        Description
        -----------
        Computes the angular value, in radians, between the 'main direction' of this positioning system and that of positioning system other. the result is a value between 0 and pi.

        """
        return _Geom.Geom_AxisPlacement_Angle(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of the axis placement. for an 'axis2placement' it is the main axis (location, direction ). for an 'axis1placement' this method returns a copy of <self>.

        """
        return _Geom.Geom_AxisPlacement_Axis(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the main 'direction' of an axis placement.

        """
        return _Geom.Geom_AxisPlacement_Direction(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point (origin) of the axis placement.

        """
        return _Geom.Geom_AxisPlacement_Location(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Assigns a1 as the 'main axis' of this positioning system. this modifies - its origin, and - its 'main direction'. if this positioning system is a geom_axis2placement, then its 'x direction' and 'y direction' are recomputed. exceptions for a geom_axis2placement: standard_constructionerror if a1 and the previous 'x direction' of the coordinate system are parallel.

        """
        return _Geom.Geom_AxisPlacement_SetAxis(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the direction of the axis placement. if <self> is an axis placement two axis the main 'direction' is modified and the 'xdirection' and 'ydirection' are recomputed. raises constructionerror only for an axis placement two axis if v and the previous 'xdirection' are parallel because it is not possible to calculate the new 'xdirection' and the new 'ydirection'.

        """
        return _Geom.Geom_AxisPlacement_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Assigns the point p as the origin of this positioning system.

        """
        return _Geom.Geom_AxisPlacement_SetLocation(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_AxisPlacement_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_AxisPlacement

# Register Geom_AxisPlacement in _Geom:
_Geom.Geom_AxisPlacement_swigregister(Geom_AxisPlacement)
class Geom_Curve(Geom_Geometry):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Continuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        It is the global continuity of the curve c0: only geometric continuity, c1: continuity of the first derivative all along the curve, c2: continuity of the second derivative all along the curve, c3: continuity of the third derivative all along the curve, g1: tangency continuity all along the curve, g2: curvature continuity all along the curve, cn: the order of continuity is infinite.

        """
        return _Geom.Geom_Curve_Continuity(self, *args)

    def D0(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Returns in p the point of parameter u. if the curve is periodic then the returned point is p(u) with u = ustart + (u - uend) where ustart and uend are the parametric bounds of the curve. //! raised only for the 'offsetcurve' if it is not possible to compute the current point. for example when the first derivative on the basis curve and the offset direction are parallel.

        """
        return _Geom.Geom_Curve_D0(self, *args)

    def D1(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt
        V1: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Returns the point p of parameter u and the first derivative v1. raised if the continuity of the curve is not c1.

        """
        return _Geom.Geom_Curve_D1(self, *args)

    def D2(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Returns the point p of parameter u, the first and second derivatives v1 and v2. raised if the continuity of the curve is not c2.

        """
        return _Geom.Geom_Curve_D2(self, *args)

    def D3(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec
        V3: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Returns the point p of parameter u, the first, the second and the third derivative. raised if the continuity of the curve is not c3.

        """
        return _Geom.Geom_Curve_D3(self, *args)

    def DN(self, *args):
        r"""

        Parameters
        ----------
        U: float
        N: int

        Return
        -------
        gp_Vec

        Description
        -----------
        The returned vector gives the value of the derivative for the order of derivation n. raised if the continuity of the curve is not cn. //! raised if the derivative cannot be computed easily. e.g. rational bspline and n > 3. raised if n < 1.

        """
        return _Geom.Geom_Curve_DN(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Curve_DumpJson(self, depth)

    def FirstParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value of the first parameter. warnings: it can be realfirst from package standard if the curve is infinite.

        """
        return _Geom.Geom_Curve_FirstParameter(self, *args)

    def IsCN(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the degree of continuity of this curve is at least n. exceptions - standard_rangeerror if n is less than 0.

        """
        return _Geom.Geom_Curve_IsCN(self, *args)

    def IsClosed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the curve is closed. some curves such as circle are always closed, others such as line are never closed (by definition). some curves such as offsetcurve can be closed or not. these curves are considered as closed if the distance between the first point and the last point of the curve is lower or equal to the resolution from package gp which is a fixed criterion independent of the application.

        """
        return _Geom.Geom_Curve_IsClosed(self, *args)

    def IsPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Is the parametrization of the curve periodic ? it is possible only if the curve is closed and if the following relation is satisfied: for each parametric value u the distance between the point p(u) and the point p (u + t) is lower or equal to resolution from package gp, t is the period and must be a constant. there are three possibilities: . the curve is never periodic by definition (segmentline) . the curve is always periodic by definition (circle) . the curve can be defined as periodic (bspline). in this case a function setperiodic allows you to give the shape of the curve. the general rule for this case is: if a curve can be periodic or not the default periodicity set is non periodic and you have to turn (explicitly) the curve into a periodic curve if you want the curve to be periodic.

        """
        return _Geom.Geom_Curve_IsPeriodic(self, *args)

    def LastParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value of the last parameter. warnings: it can be reallast from package standard if the curve is infinite.

        """
        return _Geom.Geom_Curve_LastParameter(self, *args)

    def ParametricTransformation(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        float

        Description
        -----------
        Returns a coefficient to compute the parameter on the transformed curve for the transform of the point on <self>. //! transformed(t)->value(u * parametrictransformation(t)) //! is the same point as //! value(u).transformed(t) //! this methods returns 1. //! it can be redefined. for example on the line.

        """
        return _Geom.Geom_Curve_ParametricTransformation(self, *args)

    def Period(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the period of this curve. exceptions standard_nosuchobject if this curve is not periodic.

        """
        return _Geom.Geom_Curve_Period(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Changes the direction of parametrization of <self>. the 'firstparameter' and the 'lastparameter' are not changed but the orientation of the curve is modified. if the curve is bounded the startpoint of the initial curve becomes the endpoint of the reversed curve and the endpoint of the initial curve becomes the startpoint of the reversed curve.

        """
        return _Geom.Geom_Curve_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Returns a copy of <self> reversed.

        """
        return _Geom.Geom_Curve_Reversed(self, *args)

    def ReversedParameter(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the reversed curve for the point of parameter u on <self>. //! me->reversed()->value(me->reversedparameter(u)) //! is the same point as //! me->value(u).

        """
        return _Geom.Geom_Curve_ReversedParameter(self, *args)

    def TransformedParameter(self, *args):
        r"""

        Parameters
        ----------
        U: float
        T: gp_Trsf

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the transformed curve for the transform of the point of parameter u on <self>. //! me->transformed(t)->value(me->transformedparameter(u,t)) //! is the same point as //! me->value(u).transformed(t) //! this methods returns <u> //! it can be redefined. for example on the line.

        """
        return _Geom.Geom_Curve_TransformedParameter(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the point of parameter u on <self>. if the curve is periodic then the returned point is p(u) with u = ustart + (u - uend) where ustart and uend are the parametric bounds of the curve. it is implemented with d0. //! raised only for the 'offsetcurve' if it is not possible to compute the current point. for example when the first derivative on the basis curve and the offset direction are parallel.

        """
        return _Geom.Geom_Curve_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Curve_DownCast(t)


    __repr__ = _dumps_object


    def evalNumpy(self, numpyArrayU, numpyArrayResultArgout, nDimsResult):
        return _Geom.Geom_Curve_evalNumpy(self, numpyArrayU, numpyArrayResultArgout, nDimsResult)

    def evalDerivativeNumpy(self, numpyArrayU, numpyArrayResultArgout, nDimsResult, nU):
        return _Geom.Geom_Curve_evalDerivativeNumpy(self, numpyArrayU, numpyArrayResultArgout, nDimsResult, nU)

    def eval_numpy_array(self, u_arr):
        return self.evalNumpy(u_arr, len(u_arr) * 3, 3).reshape(-1, 3)

    def eval_derivative_numpy_array(self, u_arr, n_u):
        return self.evalDerivativeNumpy(u_arr, len(u_arr) * 3, 3, n_u).reshape(-1, 3)

    __swig_destroy__ = _Geom.delete_Geom_Curve

# Register Geom_Curve in _Geom:
_Geom.Geom_Curve_swigregister(Geom_Curve)
class Geom_Point(Geom_Geometry):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Coord(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        X: float
        Y: float
        Z: float

        Description
        -----------
        Returns the coordinates of <self>.

        """
        return _Geom.Geom_Point_Coord(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Point

        Return
        -------
        float

        Description
        -----------
        Computes the distance between <self> and <other>.

        """
        return _Geom.Geom_Point_Distance(self, *args)

    def Pnt(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns a non transient copy of <self>.

        """
        return _Geom.Geom_Point_Pnt(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Point

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and <other>.

        """
        return _Geom.Geom_Point_SquareDistance(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x coordinate of <self>.

        """
        return _Geom.Geom_Point_X(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y coordinate of <self>.

        """
        return _Geom.Geom_Point_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the z coordinate of <self>.

        """
        return _Geom.Geom_Point_Z(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Point_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Point

# Register Geom_Point in _Geom:
_Geom.Geom_Point_swigregister(Geom_Point)
class Geom_Surface(Geom_Geometry):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Bounds(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        U1: float
        U2: float
        V1: float
        V2: float

        Description
        -----------
        Returns the parametric bounds u1, u2, v1 and v2 of this surface. if the surface is infinite, this function can return a value equal to precision::infinite: instead of standard_real::lastreal.

        """
        return _Geom.Geom_Surface_Bounds(self, *args)

    def Continuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns the global continuity of the surface in direction u and v: - c0: only geometric continuity, - c1: continuity of the first derivative all along the surface, - c2: continuity of the second derivative all along the surface, - c3: continuity of the third derivative all along the surface, - g1: tangency continuity all along the surface, - g2: curvature continuity all along the surface, - cn: the order of continuity is infinite. //! example: if the surface is c1 in the v parametric direction and c2 in the u parametric direction shape = c1.

        """
        return _Geom.Geom_Surface_Continuity(self, *args)

    def D0(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the point of parameter u,v on the surface. //! raised only for an 'offsetsurface' if it is not possible to compute the current point.

        """
        return _Geom.Geom_Surface_D0(self, *args)

    def D1(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the point p and the first derivatives in the directions u and v at this point. raised if the continuity of the surface is not c1. //! tip: use geomlib::normestim() to calculate surface normal at specified (u, v) point.

        """
        return _Geom.Geom_Surface_D1(self, *args)

    def D2(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec
        D2U: gp_Vec
        D2V: gp_Vec
        D2UV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the point p, the first and the second derivatives in the directions u and v at this point. raised if the continuity of the surface is not c2.

        """
        return _Geom.Geom_Surface_D2(self, *args)

    def D3(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec
        D2U: gp_Vec
        D2V: gp_Vec
        D2UV: gp_Vec
        D3U: gp_Vec
        D3V: gp_Vec
        D3UUV: gp_Vec
        D3UVV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the point p, the first,the second and the third derivatives in the directions u and v at this point. raised if the continuity of the surface is not c2.

        """
        return _Geom.Geom_Surface_D3(self, *args)

    def DN(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        Nu: int
        Nv: int

        Return
        -------
        gp_Vec

        Description
        -----------
        Computes the derivative of order nu in the direction u and nv in the direction v at the point p(u, v). //! raised if the continuity of the surface is not cnu in the u direction or not cnv in the v direction. raised if nu + nv < 1 or nu < 0 or nv < 0.

        """
        return _Geom.Geom_Surface_DN(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Surface_DumpJson(self, depth)

    def IsCNu(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        bool

        Description
        -----------
        Returns the order of continuity of the surface in the u parametric direction. raised if n < 0.

        """
        return _Geom.Geom_Surface_IsCNu(self, *args)

    def IsCNv(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        bool

        Description
        -----------
        Returns the order of continuity of the surface in the v parametric direction. raised if n < 0.

        """
        return _Geom.Geom_Surface_IsCNv(self, *args)

    def IsUClosed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks whether this surface is closed in the u parametric direction. returns true if, in the u parametric direction: taking ufirst and ulast as the parametric bounds in the u parametric direction, for each parameter v, the distance between the points p(ufirst, v) and p(ulast, v) is less than or equal to gp::resolution().

        """
        return _Geom.Geom_Surface_IsUClosed(self, *args)

    def IsUPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks if this surface is periodic in the u parametric direction. returns true if: - this surface is closed in the u parametric direction, and - there is a constant t such that the distance between the points p (u, v) and p (u + t, v) (or the points p (u, v) and p (u, v + t)) is less than or equal to gp::resolution(). //! note: t is the parametric period in the u parametric direction.

        """
        return _Geom.Geom_Surface_IsUPeriodic(self, *args)

    def IsVClosed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks whether this surface is closed in the u parametric direction. returns true if, in the v parametric direction: taking vfirst and vlast as the parametric bounds in the v parametric direction, for each parameter u, the distance between the points p(u, vfirst) and p(u, vlast) is less than or equal to gp::resolution().

        """
        return _Geom.Geom_Surface_IsVClosed(self, *args)

    def IsVPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks if this surface is periodic in the v parametric direction. returns true if: - this surface is closed in the v parametric direction, and - there is a constant t such that the distance between the points p (u, v) and p (u + t, v) (or the points p (u, v) and p (u, v + t)) is less than or equal to gp::resolution(). //! note: t is the parametric period in the v parametric direction.

        """
        return _Geom.Geom_Surface_IsVPeriodic(self, *args)

    def ParametricTransformation(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        gp_GTrsf2d

        Description
        -----------
        Returns a 2d transformation used to find the new parameters of a point on the transformed surface. @code me->transformed(t)->value(u',v') @endcode is the same point as @code me->value(u,v).transformed(t) @endcode where u',v' are obtained by transforming u,v with the 2d transformation returned by @code me->parametrictransformation(t) @endcode this method returns an identity transformation //! it can be redefined. for example on the plane, cylinder, cone, revolved and extruded surfaces.

        """
        return _Geom.Geom_Surface_ParametricTransformation(self, *args)

    def TransformParameters(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        U: float
        V: float

        Description
        -----------
        Computes the parameters on the transformed surface for the transform of the point of parameters u,v on <self>. @code me->transformed(t)->value(u',v') @endcode is the same point as @code me->value(u,v).transformed(t) @endcode where u',v' are the new values of u,v after calling @code me->transformparameters(u,v,t) @endcode this method does not change <u> and <v> //! it can be redefined. for example on the plane, cylinder, cone, revolved and extruded surfaces.

        """
        return _Geom.Geom_Surface_TransformParameters(self, *args)

    def UIso(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the u isoparametric curve.

        """
        return _Geom.Geom_Surface_UIso(self, *args)

    def UPeriod(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the period of this surface in the u parametric direction. raises if the surface is not uperiodic.

        """
        return _Geom.Geom_Surface_UPeriod(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u direction of parametrization of <self>. the bounds of the surface are not modified.

        """
        return _Geom.Geom_Surface_UReverse(self, *args)

    def UReversed(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Reverses the u direction of parametrization of <self>. the bounds of the surface are not modified. a copy of <self> is returned.

        """
        return _Geom.Geom_Surface_UReversed(self, *args)

    def UReversedParameter(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the ureversed surface for the point of parameter u on <self>. @code me->ureversed()->value(me->ureversedparameter(u),v) @endcode is the same point as @code me->value(u,v) @endcode.

        """
        return _Geom.Geom_Surface_UReversedParameter(self, *args)

    def VIso(self, *args):
        r"""

        Parameters
        ----------
        V: float

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the v isoparametric curve.

        """
        return _Geom.Geom_Surface_VIso(self, *args)

    def VPeriod(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the period of this surface in the v parametric direction. raises if the surface is not vperiodic.

        """
        return _Geom.Geom_Surface_VPeriod(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v direction of parametrization of <self>. the bounds of the surface are not modified.

        """
        return _Geom.Geom_Surface_VReverse(self, *args)

    def VReversed(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Reverses the v direction of parametrization of <self>. the bounds of the surface are not modified. a copy of <self> is returned.

        """
        return _Geom.Geom_Surface_VReversed(self, *args)

    def VReversedParameter(self, *args):
        r"""

        Parameters
        ----------
        V: float

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the vreversed surface for the point of parameter v on <self>. @code me->vreversed()->value(u,me->vreversedparameter(v)) @endcode is the same point as @code me->value(u,v) @endcode.

        """
        return _Geom.Geom_Surface_VReversedParameter(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the point of parameter (u, v) on the surface. //! it is implemented with d0. tip: use geomlib::normestim() to calculate surface normal at specified (u, v) point. //! raised only for an 'offsetsurface' if it is not possible to compute the current point.

        """
        return _Geom.Geom_Surface_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Surface_DownCast(t)


    __repr__ = _dumps_object


    def evalNumpy(self, numpyArrayUV, numpyArrayResultArgout, nDimsResult):
        return _Geom.Geom_Surface_evalNumpy(self, numpyArrayUV, numpyArrayResultArgout, nDimsResult)

    def evalDerivativeNumpy(self, numpyArrayUV, numpyArrayResultArgout, nDimsResult, nU, nV):
        return _Geom.Geom_Surface_evalDerivativeNumpy(self, numpyArrayUV, numpyArrayResultArgout, nDimsResult, nU, nV)

    def eval_numpy_array(self, u_arr):
        return self.evalNumpy(u_arr, len(u_arr) * 3, 3).reshape(-1, 3)

    def eval_derivative_numpy_array(self, u_arr, n_u, n_v):
        return self.evalDerivativeNumpy(u_arr, len(u_arr) * 3, 3, n_u, n_v).reshape(-1, 3)

    __swig_destroy__ = _Geom.delete_Geom_Surface

# Register Geom_Surface in _Geom:
_Geom.Geom_Surface_swigregister(Geom_Surface)
class Geom_Vector(Geom_Geometry):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        float

        Description
        -----------
        Computes the angular value, in radians, between this vector and vector other. the result is a value between 0 and pi. exceptions gp_vectorwithnullmagnitude if: - the magnitude of this vector is less than or equal to gp::resolution(), or - the magnitude of vector other is less than or equal to gp::resolution().

        """
        return _Geom.Geom_Vector_Angle(self, *args)

    def AngleWithRef(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector
        VRef: Geom_Vector

        Return
        -------
        float

        Description
        -----------
        Computes the angular value, in radians, between this vector and vector other. the result is a value between -pi and pi. the vector vref defines the positive sense of rotation: the angular value is positive if the cross product this ^ other has the same orientation as vref (in relation to the plane defined by this vector and vector other). otherwise, it is negative. exceptions standard_domainerror if this vector, vector other and vector vref are coplanar, except if this vector and vector other are parallel. gp_vectorwithnullmagnitude if the magnitude of this vector, vector other or vector vref is less than or equal to gp::resolution().

        """
        return _Geom.Geom_Vector_AngleWithRef(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        X: float
        Y: float
        Z: float

        Description
        -----------
        Returns the coordinates x, y and z of this vector.

        """
        return _Geom.Geom_Vector_Coord(self, *args)

    def Cross(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        None

        Description
        -----------
        Computes the cross product between <self> and <other>. //! raised if <self> is a 'direction' and if <self> and <other> are parallel because it is not possible to build a 'direction' with null length.

        """
        return _Geom.Geom_Vector_Cross(self, *args)

    def CrossCross(self, *args):
        r"""

        Parameters
        ----------
        V1: Geom_Vector
        V2: Geom_Vector

        Return
        -------
        None

        Description
        -----------
        Computes the triple vector product <self> ^(v1 ^ v2). //! raised if <self> is a 'direction' and if v1 and v2 are parallel or <self> and (v1 ^ v2) are parallel.

        """
        return _Geom.Geom_Vector_CrossCross(self, *args)

    def CrossCrossed(self, *args):
        r"""

        Parameters
        ----------
        V1: Geom_Vector
        V2: Geom_Vector

        Return
        -------
        opencascade::handle<Geom_Vector>

        Description
        -----------
        Computes the triple vector product <self> ^(v1 ^ v2). //! raised if <self> is a direction and if v1 and v2 are parallel or <self> and (v1 ^ v2) are parallel.

        """
        return _Geom.Geom_Vector_CrossCrossed(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        opencascade::handle<Geom_Vector>

        Description
        -----------
        Computes the cross product between <self> and <other>. a new direction is returned. //! raised if <self> is a 'direction' and if the two vectors are parallel because it is not possible to create a 'direction' with null length.

        """
        return _Geom.Geom_Vector_Crossed(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product of this vector and vector other.

        """
        return _Geom.Geom_Vector_Dot(self, *args)

    def DotCross(self, *args):
        r"""

        Parameters
        ----------
        V1: Geom_Vector
        V2: Geom_Vector

        Return
        -------
        float

        Description
        -----------
        Computes the triple scalar product. returns me . (v1 ^ v2).

        """
        return _Geom.Geom_Vector_DotCross(self, *args)

    def Magnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the magnitude of <self>.

        """
        return _Geom.Geom_Vector_Magnitude(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the vector <self>.

        """
        return _Geom.Geom_Vector_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Vector>

        Description
        -----------
        Returns a copy of <self> reversed.

        """
        return _Geom.Geom_Vector_Reversed(self, *args)

    def SquareMagnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the square magnitude of <self>.

        """
        return _Geom.Geom_Vector_SquareMagnitude(self, *args)

    def Vec(self, *args):
        r"""
        Return
        -------
        gp_Vec

        Description
        -----------
        Converts this vector into a gp_vec vector.

        """
        return _Geom.Geom_Vector_Vec(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x coordinate of <self>.

        """
        return _Geom.Geom_Vector_X(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y coordinate of <self>.

        """
        return _Geom.Geom_Vector_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the z coordinate of <self>.

        """
        return _Geom.Geom_Vector_Z(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Vector_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Vector

# Register Geom_Vector in _Geom:
_Geom.Geom_Vector_swigregister(Geom_Vector)
class Geom_Axis1Placement(Geom_AxisPlacement):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Returns a transient copy of a1.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        P is the origin of the axis placement and v is the direction of the axis placement.

        """
        _Geom.Geom_Axis1Placement_swiginit(self, _Geom.new_Geom_Axis1Placement(*args))

    def Ax1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns a non transient copy of <self>.

        """
        return _Geom.Geom_Axis1Placement_Ax1(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the direction of the axis placement.

        """
        return _Geom.Geom_Axis1Placement_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Axis1Placement>

        Description
        -----------
        Returns a copy of <self> reversed.

        """
        return _Geom.Geom_Axis1Placement_Reversed(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Axis1Placement_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Axis1Placement

# Register Geom_Axis1Placement in _Geom:
_Geom.Geom_Axis1Placement_swigregister(Geom_Axis1Placement)
class Geom_Axis2Placement(Geom_AxisPlacement):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Returns a transient copy of a2.

        Parameters
        ----------
        P: gp_Pnt
        N: gp_Dir
        Vx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        P is the origin of the axis placement, n is the main direction of the axis placement and vx is the 'xdirection'. if the two directions n and vx are not orthogonal the 'xdirection' is computed as follow: xdirection = n ^ (vx ^ n). raised if n and vx are parallel.

        """
        _Geom.Geom_Axis2Placement_swiginit(self, _Geom.new_Geom_Axis2Placement(*args))

    def Ax2(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns a non transient copy of <self>.

        """
        return _Geom.Geom_Axis2Placement_Ax2(self, *args)

    def SetAx2(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Assigns the origin and the three unit vectors of a2 to this coordinate system.

        """
        return _Geom.Geom_Axis2Placement_SetAx2(self, *args)

    def SetXDirection(self, *args):
        r"""

        Parameters
        ----------
        Vx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'xdirection' of the axis placement, vx is the new 'xdirection'. if vx is not normal to the main direction then 'xdirection' is computed as follow: xdirection = direction ^ ( vx ^ direction). the main direction is not modified. raised if vx and 'direction' are parallel.

        """
        return _Geom.Geom_Axis2Placement_SetXDirection(self, *args)

    def SetYDirection(self, *args):
        r"""

        Parameters
        ----------
        Vy: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'ydirection' of the axis placement, vy is the new 'ydirection'. if vy is not normal to the main direction then 'ydirection' is computed as follow: ydirection = direction ^ ( vy ^ direction). the main direction is not modified. the 'xdirection' is modified. raised if vy and the main direction are parallel.

        """
        return _Geom.Geom_Axis2Placement_SetYDirection(self, *args)

    def XDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'xdirection'. this is a unit vector.

        """
        return _Geom.Geom_Axis2Placement_XDirection(self, *args)

    def YDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'ydirection'. this is a unit vector.

        """
        return _Geom.Geom_Axis2Placement_YDirection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Axis2Placement_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Axis2Placement

# Register Geom_Axis2Placement in _Geom:
_Geom.Geom_Axis2Placement_swigregister(Geom_Axis2Placement)
class Geom_BoundedCurve(Geom_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_BoundedCurve_DumpJson(self, depth)

    def EndPoint(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the end point of the curve.

        """
        return _Geom.Geom_BoundedCurve_EndPoint(self, *args)

    def StartPoint(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the start point of the curve.

        """
        return _Geom.Geom_BoundedCurve_StartPoint(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BoundedCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BoundedCurve

# Register Geom_BoundedCurve in _Geom:
_Geom.Geom_BoundedCurve_swigregister(Geom_BoundedCurve)
class Geom_BoundedSurface(Geom_Surface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BoundedSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BoundedSurface

# Register Geom_BoundedSurface in _Geom:
_Geom.Geom_BoundedSurface_swigregister(Geom_BoundedSurface)
class Geom_CartesianPoint(Geom_Point):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Returns a transient copy of p.

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Constructs a point defined by its three cartesian coordinates x, y and z.

        """
        _Geom.Geom_CartesianPoint_swiginit(self, _Geom.new_Geom_CartesianPoint(*args))

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Assigns the coordinates x, y and z to this point.

        """
        return _Geom.Geom_CartesianPoint_SetCoord(self, *args)

    def SetPnt(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Set <self> to p.x(), p.y(), p.z() coordinates.

        """
        return _Geom.Geom_CartesianPoint_SetPnt(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        X: float

        Return
        -------
        None

        Description
        -----------
        Changes the x coordinate of me.

        """
        return _Geom.Geom_CartesianPoint_SetX(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        Y: float

        Return
        -------
        None

        Description
        -----------
        Changes the y coordinate of me.

        """
        return _Geom.Geom_CartesianPoint_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        Z: float

        Return
        -------
        None

        Description
        -----------
        Changes the z coordinate of me.

        """
        return _Geom.Geom_CartesianPoint_SetZ(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_CartesianPoint_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_CartesianPoint

# Register Geom_CartesianPoint in _Geom:
_Geom.Geom_CartesianPoint_swigregister(Geom_CartesianPoint)
class Geom_Conic(Geom_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the 'main axis' of this conic. this axis is normal to the plane of the conic.

        """
        return _Geom.Geom_Conic_Axis(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Conic_DumpJson(self, depth)

    def Eccentricity(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the eccentricity value of the conic e. e = 0 for a circle 0 < e < 1 for an ellipse (e = 0 if majorradius = minorradius) e > 1 for a hyperbola e = 1 for a parabola exceptions standard_domainerror in the case of a hyperbola if its major radius is null.

        """
        return _Geom.Geom_Conic_Eccentricity(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point of the conic. for the circle, the ellipse and the hyperbola it is the center of the conic. for the parabola it is the apex of the parabola.

        """
        return _Geom.Geom_Conic_Location(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns the local coordinates system of the conic. the main direction of the axis2placement is normal to the plane of the conic. the x direction of the axis2placement is in the plane of the conic and corresponds to the origin for the conic's parametric value u.

        """
        return _Geom.Geom_Conic_Position(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the orientation of the conic's plane. the normal axis to the plane is a1. the xaxis and the yaxis are recomputed. //! raised if the a1 is parallel to the xaxis of the conic.

        """
        return _Geom.Geom_Conic_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location point of the conic.

        """
        return _Geom.Geom_Conic_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the conic.

        """
        return _Geom.Geom_Conic_SetPosition(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the xaxis of the conic. this axis defines the origin of parametrization of the conic. this axis is perpendicular to the axis of the conic. this axis and the yaxis define the plane of the conic.

        """
        return _Geom.Geom_Conic_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the yaxis of the conic. the yaxis is perpendicular to the xaxis. this axis and the xaxis define the plane of the conic.

        """
        return _Geom.Geom_Conic_YAxis(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Conic_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Conic

# Register Geom_Conic in _Geom:
_Geom.Geom_Conic_swigregister(Geom_Conic)
class Geom_Direction(Geom_Vector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Creates a unit vector with it 3 cartesian coordinates. //! raised if sqrt( x*x + y*y + z*z) <= resolution from gp.

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a transient copy of <self>.

        """
        _Geom.Geom_Direction_swiginit(self, _Geom.new_Geom_Direction(*args))

    def Dir(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the non transient direction with the same coordinates as <self>.

        """
        return _Geom.Geom_Direction_Dir(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Sets <self> to x,y,z coordinates. //! raised if sqrt( x*x + y*y + z*z) <= resolution from gp.

        """
        return _Geom.Geom_Direction_SetCoord(self, *args)

    def SetDir(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Converts the gp_dir unit vector v into this unit vector.

        """
        return _Geom.Geom_Direction_SetDir(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        X: float

        Return
        -------
        None

        Description
        -----------
        Changes the x coordinate of <self>. //! raised if sqrt( x*x + y*y + z*z) <= resolution from gp.

        """
        return _Geom.Geom_Direction_SetX(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        Y: float

        Return
        -------
        None

        Description
        -----------
        Changes the y coordinate of <self>. //! raised if sqrt( x*x + y*y + z*z) <= resolution from gp.

        """
        return _Geom.Geom_Direction_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        Z: float

        Return
        -------
        None

        Description
        -----------
        Changes the z coordinate of <self>. //! raised if sqrt( x*x + y*y + z*z) <= resolution from gp.

        """
        return _Geom.Geom_Direction_SetZ(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Direction_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Direction

# Register Geom_Direction in _Geom:
_Geom.Geom_Direction_swigregister(Geom_Direction)
class Geom_ElementarySurface(Geom_Surface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of the surface (zaxis).

        """
        return _Geom.Geom_ElementarySurface_Axis(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_ElementarySurface_DumpJson(self, depth)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point of the local coordinate system of the surface.

        """
        return _Geom.Geom_ElementarySurface_Location(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinates system of the surface.

        """
        return _Geom.Geom_ElementarySurface_Position(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the main axis (zaxis) of the elementary surface. //! raised if the direction of a1 is parallel to the xaxis of the coordinate system of the surface.

        """
        return _Geom.Geom_ElementarySurface_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location of the local coordinates system of the surface.

        """
        return _Geom.Geom_ElementarySurface_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theAx3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinates system of the surface.

        """
        return _Geom.Geom_ElementarySurface_SetPosition(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_ElementarySurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_ElementarySurface

# Register Geom_ElementarySurface in _Geom:
_Geom.Geom_ElementarySurface_swigregister(Geom_ElementarySurface)
class Geom_Line(Geom_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Creates a line located in 3d space with the axis placement a1. the location of a1 is the origin of the line.

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        Creates a line from a non transient line from package gp.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Constructs a line passing through point p and parallel to vector v (p and v are, respectively, the origin and the unit vector of the positioning axis of the line).

        """
        _Geom.Geom_Line_swiginit(self, _Geom.new_Geom_Line(*args))

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Line_DumpJson(self, depth)

    def Lin(self, *args):
        r"""
        Return
        -------
        gp_Lin

        Description
        -----------
        Returns non transient line from gp with the same geometric properties as <self>.

        """
        return _Geom.Geom_Line_Lin(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the positioning axis of this line; this is also its local coordinate system.

        """
        return _Geom.Geom_Line_Position(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the direction of the line.

        """
        return _Geom.Geom_Line_SetDirection(self, *args)

    def SetLin(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        Set <self> so that <self> has the same geometric properties as l.

        """
        return _Geom.Geom_Line_SetLin(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (origin) of the line.

        """
        return _Geom.Geom_Line_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' and a the 'direction' of <self>.

        """
        return _Geom.Geom_Line_SetPosition(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Line_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Line

# Register Geom_Line in _Geom:
_Geom.Geom_Line_swigregister(Geom_Line)
class Geom_OffsetCurve(Geom_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        Offset: float
        V: gp_Dir
        isNotCheckC0: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        C is the basis curve, offset is the distance between <self> and the basis curve at any point. v defines the fixed reference direction (offset direction). if p is a point on the basis curve and t the first derivative with non zero length at this point, the corresponding point on the offset curve is in the direction of the vector-product n = v ^ t where n is a unitary vector. if isnotcheckc0 = true checking if basis curve has c0-continuity is not made. warnings: in this package the entities are not shared. the offsetcurve is built with a copy of the curve c. so when c is modified the offsetcurve is not modified //! raised if the basis curve c is not at least c1. warnings: no check is done to know if ||v^t|| != 0.0 at any point.

        """
        _Geom.Geom_OffsetCurve_swiginit(self, _Geom.new_Geom_OffsetCurve(*args))

    def BasisCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Returns the basis curve of this offset curve. note: the basis curve can be an offset curve.

        """
        return _Geom.Geom_OffsetCurve_BasisCurve(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the reference vector of this offset curve. value and derivatives warnings: the exception undefinedvalue or undefinedderivative is raised if it is not possible to compute a unique offset direction. if t is the first derivative with not null length and v the offset direction the relation ||t(u) ^ v|| != 0 must be satisfied to evaluate the offset curve. no check is done at the creation time and we suppose in this package that the offset curve is well defined.

        """
        return _Geom.Geom_OffsetCurve_Direction(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_OffsetCurve_DumpJson(self, depth)

    def GetBasisCurveContinuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns continuity of the basis curve.

        """
        return _Geom.Geom_OffsetCurve_GetBasisCurveContinuity(self, *args)

    def Offset(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the offset value of this offset curve.

        """
        return _Geom.Geom_OffsetCurve_Offset(self, *args)

    def SetBasisCurve(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        isNotCheckC0: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Changes this offset curve by assigning c as the basis curve from which it is built. if isnotcheckc0 = true checking if basis curve has c0-continuity is not made. exceptions standard_constructionerror if the curve c is not at least 'c1' continuous.

        """
        return _Geom.Geom_OffsetCurve_SetBasisCurve(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes this offset curve by assigning v as the reference vector used to compute the offset direction.

        """
        return _Geom.Geom_OffsetCurve_SetDirection(self, *args)

    def SetOffsetValue(self, *args):
        r"""

        Parameters
        ----------
        D: float

        Return
        -------
        None

        Description
        -----------
        Changes this offset curve by assigning d as the offset value.

        """
        return _Geom.Geom_OffsetCurve_SetOffsetValue(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_OffsetCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_OffsetCurve

# Register Geom_OffsetCurve in _Geom:
_Geom.Geom_OffsetCurve_swigregister(Geom_OffsetCurve)
class Geom_OffsetSurface(Geom_Surface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface
        Offset: float
        isNotCheckC0: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs a surface offset from the basis surface s, where offset is the distance between the offset surface and the basis surface at any point. a point on the offset surface is built by measuring the offset value along a normal vector at a point on s. this normal vector is given by the cross product d1u^d1v, where d1u and d1v are the vectors tangential to the basis surface in the u and v parametric directions at this point. the side of s on which the offset value is measured is indicated by this normal vector if offset is positive, or is the inverse sense if offset is negative. if isnotcheckc0 = true checking if basis surface has c0-continuity is not made. warnings: - the offset surface is built with a copy of the surface s. therefore, when s is modified the offset surface is not modified. - no check is made at the time of construction to detect points on s with multiple possible normal directions. raised if s is not at least c1. warnings: no check is done to verify that a unique normal direction is defined at any point of the basis surface s.

        """
        _Geom.Geom_OffsetSurface_swiginit(self, _Geom.new_Geom_OffsetSurface(*args))

    def BasisSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Returns the basis surface of this offset surface. note: the basis surface can be an offset surface.

        """
        return _Geom.Geom_OffsetSurface_BasisSurface(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_OffsetSurface_DumpJson(self, depth)

    def GetBasisSurfContinuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns continuity of the basis surface.

        """
        return _Geom.Geom_OffsetSurface_GetBasisSurfContinuity(self, *args)

    def Offset(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the offset value of this offset surface.

        """
        return _Geom.Geom_OffsetSurface_Offset(self, *args)

    def OsculatingSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_OsculatingSurface>

        Description
        -----------
        Returns osculating surface if base surface is b-spline or bezier.

        """
        return _Geom.Geom_OffsetSurface_OsculatingSurface(self, *args)

    def SetBasisSurface(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface
        isNotCheckC0: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Raised if s is not at least c1. warnings: no check is done to verify that a unique normal direction is defined at any point of the basis surface s. if isnotcheckc0 = true checking if basis surface has c0-continuity is not made. exceptions standard_constructionerror if the surface s is not at least 'c1' continuous.

        """
        return _Geom.Geom_OffsetSurface_SetBasisSurface(self, *args)

    def SetOffsetValue(self, *args):
        r"""

        Parameters
        ----------
        D: float

        Return
        -------
        None

        Description
        -----------
        Changes this offset surface by assigning d as the offset value.

        """
        return _Geom.Geom_OffsetSurface_SetOffsetValue(self, *args)

    def Surface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Returns an equivalent surface of the offset surface when the basis surface is a canonic surface or a rectangular limited surface on canonic surface or if the offset is null.

        """
        return _Geom.Geom_OffsetSurface_Surface(self, *args)

    def UOsculatingSurface(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        UOsculSurf: Geom_BSplineSurface

        Return
        -------
        IsOpposite: bool

        Description
        -----------
        If standard_true, l is the local osculating surface along u at the point u,v. it means that dl/du is collinear to ds/du . if isopposite == standard_true these vectors have opposite direction.

        """
        return _Geom.Geom_OffsetSurface_UOsculatingSurface(self, *args)

    def VOsculatingSurface(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        VOsculSurf: Geom_BSplineSurface

        Return
        -------
        IsOpposite: bool

        Description
        -----------
        If standard_true, l is the local osculating surface along v at the point u,v. it means that dl/dv is collinear to ds/dv . if isopposite == standard_true these vectors have opposite direction.

        """
        return _Geom.Geom_OffsetSurface_VOsculatingSurface(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_OffsetSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_OffsetSurface

# Register Geom_OffsetSurface in _Geom:
_Geom.Geom_OffsetSurface_swigregister(Geom_OffsetSurface)
class Geom_SweptSurface(Geom_Surface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BasisCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Returns the referenced curve of the surface. for a surface of revolution it is the revolution curve, for a surface of linear extrusion it is the extruded curve.

        """
        return _Geom.Geom_SweptSurface_BasisCurve(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the reference direction of the swept surface. for a surface of revolution it is the direction of the revolution axis, for a surface of linear extrusion it is the direction of extrusion.

        """
        return _Geom.Geom_SweptSurface_Direction(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_SweptSurface_DumpJson(self, depth)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_SweptSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_SweptSurface

# Register Geom_SweptSurface in _Geom:
_Geom.Geom_SweptSurface_swigregister(Geom_SweptSurface)
class Geom_VectorWithMagnitude(Geom_Vector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Creates a transient copy of v.

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Creates a vector with three cartesian coordinates.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Creates a vector from the point p1 to the point p2. the magnitude of the vector is the distance between p1 and p2.

        """
        _Geom.Geom_VectorWithMagnitude_swiginit(self, _Geom.new_Geom_VectorWithMagnitude(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        None

        Description
        -----------
        Adds the vector other to <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        opencascade::handle<Geom_VectorWithMagnitude>

        Description
        -----------
        Adds the vector other to <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_Added(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        Scalar: float

        Return
        -------
        None

        Description
        -----------
        Divides <self> by a scalar.

        """
        return _Geom.Geom_VectorWithMagnitude_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        Scalar: float

        Return
        -------
        opencascade::handle<Geom_VectorWithMagnitude>

        Description
        -----------
        Divides <self> by a scalar. a new vector is returned.

        """
        return _Geom.Geom_VectorWithMagnitude_Divided(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        Scalar: float

        Return
        -------
        opencascade::handle<Geom_VectorWithMagnitude>

        Description
        -----------
        Computes the product of the vector <self> by a scalar. a new vector is returned.

        """
        return _Geom.Geom_VectorWithMagnitude_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        Scalar: float

        Return
        -------
        None

        Description
        -----------
        Computes the product of the vector <self> by a scalar.

        """
        return _Geom.Geom_VectorWithMagnitude_Multiply(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Normalizes <self>. //! raised if the magnitude of the vector is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_VectorWithMagnitude_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_VectorWithMagnitude>

        Description
        -----------
        Returns a copy of <self> normalized. //! raised if the magnitude of the vector is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_VectorWithMagnitude_Normalized(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Assigns the values x, y and z to the coordinates of this vector.

        """
        return _Geom.Geom_VectorWithMagnitude_SetCoord(self, *args)

    def SetVec(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Converts the gp_vec vector v into this vector.

        """
        return _Geom.Geom_VectorWithMagnitude_SetVec(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        X: float

        Return
        -------
        None

        Description
        -----------
        Changes the x coordinate of <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_SetX(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        Y: float

        Return
        -------
        None

        Description
        -----------
        Changes the y coordinate of <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        Z: float

        Return
        -------
        None

        Description
        -----------
        Changes the z coordinate of <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_SetZ(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        None

        Description
        -----------
        Subtracts the vector other to <self>.

        """
        return _Geom.Geom_VectorWithMagnitude_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        Other: Geom_Vector

        Return
        -------
        opencascade::handle<Geom_VectorWithMagnitude>

        Description
        -----------
        No available documentation.

        """
        return _Geom.Geom_VectorWithMagnitude_Subtracted(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_VectorWithMagnitude_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_VectorWithMagnitude

# Register Geom_VectorWithMagnitude in _Geom:
_Geom.Geom_VectorWithMagnitude_swigregister(Geom_VectorWithMagnitude)
class Geom_BSplineCurve(Geom_BoundedCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        Knots: TColStd_Array1OfReal
        Multiplicities: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates a non-rational b_spline curve on the basis <knots, multiplicities> of degree <degree>.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Multiplicities: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool (optional, default to Standard_False)
        CheckRational: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a rational b_spline curve on the basis <knots, multiplicities> of degree <degree>. raises constructionerror subject to the following conditions 0 < degree <= maxdegree. //! weights.length() == poles.length() //! knots.length() == mults.length() >= 2 //! knots(i) < knots(i+1) (knots are increasing) //! 1 <= mults(i) <= degree //! on a non periodic curve the first and last multiplicities may be degree+1 (this is even recommended if you want the curve to start and finish on the first and last pole). //! on a periodic curve the first and the last multicities must be the same. //! on non-periodic curves //! poles.length() == sum(mults(i)) - degree - 1 >= 2 //! on periodic curves //! poles.length() == sum(mults(i)) except the first or last.

        """
        _Geom.Geom_BSplineCurve_swiginit(self, _Geom.new_Geom_BSplineCurve(*args))

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of this bspline curve. the degree of a geom_bsplinecurve curve cannot be greater than geom_bsplinecurve::maxdegree(). computation of value and derivatives.

        """
        return _Geom.Geom_BSplineCurve_Degree(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_BSplineCurve_DumpJson(self, depth)

    def FirstUKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the index in the knot array of the knot corresponding to the first or last parameter of this bspline curve. for a bspline curve, the first (or last) parameter (which gives the start (or end) point of the curve) is a knot value. however, if the multiplicity of the first (or last) knot is less than degree + 1, where degree is the degree of the curve, it is not the first (or last) knot of the curve.

        """
        return _Geom.Geom_BSplineCurve_FirstUKnotIndex(self, *args)

    def IncreaseDegree(self, *args):
        r"""

        Parameters
        ----------
        Degree: int

        Return
        -------
        None

        Description
        -----------
        Increases the degree of this bspline curve to degree. as a result, the poles, weights and multiplicities tables are modified; the knots table is not changed. nothing is done if degree is less than or equal to the current degree. exceptions standard_constructionerror if degree is greater than geom_bsplinecurve::maxdegree().

        """
        return _Geom.Geom_BSplineCurve_IncreaseDegree(self, *args)

    def IncreaseMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases the multiplicity of the knot <index> to <m>. //! if <m> is lower or equal to the current multiplicity nothing is done. if <m> is higher than the degree the degree is used. if <index> is not in [firstuknotindex, lastuknotindex].

        Parameters
        ----------
        I1: int
        I2: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases the multiplicities of the knots in [i1,i2] to <m>. //! for each knot if <m> is lower or equal to the current multiplicity nothing is done. if <m> is higher than the degree the degree is used. if <i1,i2> are not in [firstuknotindex, lastuknotindex].

        """
        return _Geom.Geom_BSplineCurve_IncreaseMultiplicity(self, *args)

    def IncrementMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        I1: int
        I2: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increment the multiplicities of the knots in [i1,i2] by <m>. //! if <m> is not positive nithing is done. //! for each knot the resulting multiplicity is limited to the degree. if <i1,i2> are not in [firstuknotindex, lastuknotindex].

        """
        return _Geom.Geom_BSplineCurve_IncrementMultiplicity(self, *args)

    def InsertKnot(self, *args):
        r"""

        Parameters
        ----------
        U: float
        M: int (optional, default to 1)
        ParametricTolerance: float (optional, default to 0.0)
        Add: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Inserts a knot value in the sequence of knots. if <u> is an existing knot the multiplicity is increased by <m>. //! if u is not on the parameter range nothing is done. //! if the multiplicity is negative or null nothing is done. the new multiplicity is limited to the degree. //! the tolerance criterion for knots equality is the max of epsilon(u) and parametrictolerance.

        """
        return _Geom.Geom_BSplineCurve_InsertKnot(self, *args)

    def InsertKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        ParametricTolerance: float (optional, default to 0.0)
        Add: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Inserts a set of knots values in the sequence of knots. //! for each u = knots(i), m = mults(i) //! if <u> is an existing knot the multiplicity is increased by <m> if <add> is true, increased to <m> if <add> is false. //! if u is not on the parameter range nothing is done. //! if the multiplicity is negative or null nothing is done. the new multiplicity is limited to the degree. //! the tolerance criterion for knots equality is the max of epsilon(u) and parametrictolerance.

        """
        return _Geom.Geom_BSplineCurve_InsertKnots(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: Geom_BSplineCurve
        thePreci: float

        Return
        -------
        bool

        Description
        -----------
        Comapare two bspline curve on identity;.

        """
        return _Geom.Geom_BSplineCurve_IsEqual(self, *args)

    def IsG1(self, *args):
        r"""

        Parameters
        ----------
        theTf: float
        theTl: float
        theAngTol: float

        Return
        -------
        bool

        Description
        -----------
        Check if curve has at least g1 continuity in interval [thetf, thetl] returns true if iscn(1) or angle between 'left' and 'right' first derivatives at knots with c0 continuity is less then theangtol only knots in interval [thetf, thetl] is checked.

        """
        return _Geom.Geom_BSplineCurve_IsG1(self, *args)

    def IsRational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the weights are not identical. the tolerance criterion is epsilon of the class real.

        """
        return _Geom.Geom_BSplineCurve_IsRational(self, *args)

    def Knot(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the knot of range index. when there is a knot with a multiplicity greater than 1 the knot is not repeated. the method multiplicity can be used to get the multiplicity of the knot. raised if index < 1 or index > nbknots.

        """
        return _Geom.Geom_BSplineCurve_Knot(self, *args)

    def KnotDistribution(self, *args):
        r"""
        Return
        -------
        GeomAbs_BSplKnotDistribution

        Description
        -----------
        Returns nonuniform or uniform or quasiuniform or piecewisebezier. if all the knots differ by a positive constant from the preceding knot the bspline curve can be: - uniform if all the knots are of multiplicity 1, - quasiuniform if all the knots are of multiplicity 1 except for the first and last knot which are of multiplicity degree + 1, - piecewisebezier if the first and last knots have multiplicity degree + 1 and if interior knots have multiplicity degree a piecewise bezier with only two knots is a beziercurve. else the curve is non uniform. the tolerance criterion is epsilon from class real.

        """
        return _Geom.Geom_BSplineCurve_KnotDistribution(self, *args)

    def KnotSequence(self, *args):
        r"""

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns k, the knots sequence of this bspline curve. in this sequence, knots with a multiplicity greater than 1 are repeated. in the case of a non-periodic curve the length of the sequence must be equal to the sum of the nbknots multiplicities of the knots of the curve (where nbknots is the number of knots of this bspline curve). this sum is also equal to: nbpoles + degree + 1 where nbpoles is the number of poles and degree the degree of this bspline curve. in the case of a periodic curve, if there are k periodic knots, the period is knot(k+1) - knot(1). the initial sequence is built by writing knots 1 to k+1, which are repeated according to their corresponding multiplicities. if degree is the degree of the curve, the degree of continuity of the curve at the knot of index 1 (or k+1) is equal to c = degree + 1 - mult(1). c knots are then inserted at the beginning and end of the initial sequence: - the c values of knots preceding the first item knot(k+1) in the initial sequence are inserted at the beginning; the period is subtracted from these c values; - the c values of knots following the last item knot(1) in the initial sequence are inserted at the end; the period is added to these c values. the length of the sequence must therefore be equal to: nbpoles + 2*degree - mult(1) + 2. example for a non-periodic bspline curve of degree 2 where: - the array of knots is: { k1 k2 k3 k4 }, - with associated multiplicities: { 3 1 2 3 }, the knot sequence is: k = { k1 k1 k1 k2 k3 k3 k4 k4 k4 } for a periodic bspline curve of degree 4 , which is 'c1' continuous at the first knot, and where: - the periodic knots are: { k1 k2 k3 (k4) } (3 periodic knots: the points of parameter k1 and k4 are identical, the period is p = k4 - k1), - with associated multiplicities: { 3 1 2 (3) }, the degree of continuity at knots k1 and k4 is: degree + 1 - mult(i) = 2. 2 supplementary knots are added at the beginning and end of the sequence: - at the beginning: the 2 knots preceding k4 minus the period; in this example, this is k3 - p both times; - at the end: the 2 knots following k1 plus the period; in this example, this is k2 + p and k3 + p. the knot sequence is therefore: k = { k3-p k3-p k1 k1 k1 k2 k3 k3 k4 k4 k4 k2+p k3+p } exceptions raised if k.lower() is less than number of first knot in knot sequence with repetitions or k.upper() is more than number of last knot in knot sequence with repetitions.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the knots of the b-spline curve. knots with multiplicit greater than 1 are repeated.

        """
        return _Geom.Geom_BSplineCurve_KnotSequence(self, *args)

    def Knots(self, *args):
        r"""

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the knot values of the b-spline curve; warning a knot with a multiplicity greater than 1 is not repeated in the knot table. the multiplicity function can be used to obtain the multiplicity of each knot. //! raised k.lower() is less than number of first knot or k.upper() is more than number of last knot.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the knot values of the b-spline curve; warning a knot with a multiplicity greater than 1 is not repeated in the knot table. the multiplicity function can be used to obtain the multiplicity of each knot.

        """
        return _Geom.Geom_BSplineCurve_Knots(self, *args)

    def LastUKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        For a bspline curve the last parameter (which gives the end point of the curve) is a knot value but if the multiplicity of the last knot index is lower than degree + 1 it is not the last knot of the curve. this method computes the index of the knot corresponding to the last parameter.

        """
        return _Geom.Geom_BSplineCurve_LastUKnotIndex(self, *args)

    def LocalD0(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Raised if fromk1 = tok2.

        """
        return _Geom.Geom_BSplineCurve_LocalD0(self, *args)

    def LocalD1(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        P: gp_Pnt
        V1: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the curve is not c1 between the knot k1 and the knot k2. raised if fromk1 = tok2.

        """
        return _Geom.Geom_BSplineCurve_LocalD1(self, *args)

    def LocalD2(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the curve is not c2 between the knot k1 and the knot k2. raised if fromk1 = tok2.

        """
        return _Geom.Geom_BSplineCurve_LocalD2(self, *args)

    def LocalD3(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec
        V3: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the curve is not c3 between the knot k1 and the knot k2. raised if fromk1 = tok2.

        """
        return _Geom.Geom_BSplineCurve_LocalD3(self, *args)

    def LocalDN(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        N: int

        Return
        -------
        gp_Vec

        Description
        -----------
        Raised if the local continuity of the curve is not cn between the knot k1 and the knot k2. raised if fromk1 = tok2. raised if n < 1.

        """
        return _Geom.Geom_BSplineCurve_LocalDN(self, *args)

    def LocalValue(self, *args):
        r"""

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Raised if fromk1 = tok2.

        """
        return _Geom.Geom_BSplineCurve_LocalValue(self, *args)

    def LocateU(self, *args):
        r"""

        Parameters
        ----------
        U: float
        ParametricTolerance: float
        WithKnotRepetition: bool (optional, default to Standard_False)

        Return
        -------
        I1: int
        I2: int

        Description
        -----------
        Locates the parametric value u in the sequence of knots. if 'withknotrepetition' is true we consider the knot's representation with repetition of multiple knot value, otherwise we consider the knot's representation with no repetition of multiple knot values. knots (i1) <= u <= knots (i2) . if i1 = i2 u is a knot value (the tolerance criterion parametrictolerance is used). . if i1 < 1 => u < knots (1) - abs(parametrictolerance) . if i2 > nbknots => u > knots (nbknots) + abs(parametrictolerance).

        """
        return _Geom.Geom_BSplineCurve_LocateU(self, *args)

    @staticmethod
    def MaxDegree(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value of the maximum degree of the normalized b-spline basis functions in this package.

        """
        return _Geom.Geom_BSplineCurve_MaxDegree(*args)

    def MovePoint(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt
        Index1: int
        Index2: int

        Return
        -------
        FirstModifiedPole: int
        LastModifiedPole: int

        Description
        -----------
        Moves the point of parameter u of this bspline curve to p. index1 and index2 are the indexes in the table of poles of this bspline curve of the first and last poles designated to be moved. firstmodifiedpole and lastmodifiedpole are the indexes of the first and last poles which are effectively modified. in the event of incompatibility between index1, index2 and the value u: - no change is made to this bspline curve, and - the firstmodifiedpole and lastmodifiedpole are returned null. exceptions standard_outofrange if: - index1 is greater than or equal to index2, or - index1 or index2 is less than 1 or greater than the number of poles of this bspline curve.

        """
        return _Geom.Geom_BSplineCurve_MovePoint(self, *args)

    def MovePointAndTangent(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt
        Tangent: gp_Vec
        Tolerance: float
        StartingCondition: int
        EndingCondition: int

        Return
        -------
        ErrorStatus: int

        Description
        -----------
        Move a point with parameter u to p. and makes it tangent at u be tangent. startingcondition = -1 means first can move endingcondition = -1 means last point can move startingcondition = 0 means the first point cannot move endingcondition = 0 means the last point cannot move startingcondition = 1 means the first point and tangent cannot move endingcondition = 1 means the last point and tangent cannot move and so forth errorstatus != 0 means that there are not enough degree of freedom with the constrain to deform the curve accordingly.

        """
        return _Geom.Geom_BSplineCurve_MovePointAndTangent(self, *args)

    def Multiplicities(self, *args):
        r"""

        Parameters
        ----------
        M: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Returns the multiplicity of the knots of the curve. //! raised if the length of m is not equal to nbknots.
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        Returns the multiplicity of the knots of the curve.

        """
        return _Geom.Geom_BSplineCurve_Multiplicities(self, *args)

    def Multiplicity(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity of the knots of range index. raised if index < 1 or index > nbknots.

        """
        return _Geom.Geom_BSplineCurve_Multiplicity(self, *args)

    def NbKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots. this method returns the number of knot without repetition of multiple knots.

        """
        return _Geom.Geom_BSplineCurve_NbKnots(self, *args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles.

        """
        return _Geom.Geom_BSplineCurve_NbPoles(self, *args)

    def PeriodicNormalization(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        U: float

        Description
        -----------
        Returns the parameter normalized within the period if the curve is periodic: otherwise does not do anything.

        """
        return _Geom.Geom_BSplineCurve_PeriodicNormalization(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the pole of range index. raised if index < 1 or index > nbpoles.

        """
        return _Geom.Geom_BSplineCurve_Pole(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        P: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Returns the poles of the b-spline curve; //! raised if the length of p is not equal to the number of poles.
        Return
        -------
        TColgp_Array1OfPnt

        Description
        -----------
        Returns the poles of the b-spline curve;.

        """
        return _Geom.Geom_BSplineCurve_Poles(self, *args)

    def RemoveKnot(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        M: int
        Tolerance: float

        Return
        -------
        bool

        Description
        -----------
        Reduces the multiplicity of the knot of index index to m. if m is equal to 0, the knot is removed. with a modification of this type, the array of poles is also modified. two different algorithms are systematically used to compute the new poles of the curve. if, for each pole, the distance between the pole calculated using the first algorithm and the same pole calculated using the second algorithm, is less than tolerance, this ensures that the curve is not modified by more than tolerance. under these conditions, true is returned; otherwise, false is returned. a low tolerance is used to prevent modification of the curve. a high tolerance is used to 'smooth' the curve. exceptions standard_outofrange if index is outside the bounds of the knots table. pole insertion and pole removing this operation is limited to the uniform or quasiuniform bsplinecurve. the knot values are modified . if the bspline is nonuniform or piecewise bezier an exception construction error is raised.

        """
        return _Geom.Geom_BSplineCurve_RemoveKnot(self, *args)

    def Resolution(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3D: float

        Return
        -------
        UTolerance: float

        Description
        -----------
        Computes for this bspline curve the parametric tolerance utolerance for a given 3d tolerance tolerance3d. if f(t) is the equation of this bspline curve, utolerance ensures that: | t1 - t0| < utolerance ===> |f(t1) - f(t0)| < tolerance3d.

        """
        return _Geom.Geom_BSplineCurve_Resolution(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        theTolerance: float (optional, default to Precision::PConfusion())

        Return
        -------
        None

        Description
        -----------
        Modifies this bspline curve by segmenting it between u1 and u2. either of these values can be outside the bounds of the curve, but u2 must be greater than u1. all data structure tables of this bspline curve are modified, but the knots located between u1 and u2 are retained. the degree of the curve is not modified. //! parameter thetolerance defines the possible proximity of the segment boundaries and b-spline knots to treat them as equal. //! warnings: even if <self> is not closed it can become closed after the segmentation for example if u1 or u2 are out of the bounds of the curve <self> or if the curve makes loop. after the segmentation the length of a curve can be null. raises if u2 < u1. standard_domainerror if u2 - u1 exceeds the period for periodic curves. i.e. ((u2 - u1) - period) > precision::pconfusion().

        """
        return _Geom.Geom_BSplineCurve_Segment(self, *args)

    def SetKnot(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        K: float

        Return
        -------
        None

        Description
        -----------
        Modifies this bspline curve by assigning the value k to the knot of index index in the knots table. this is a relatively local modification because k must be such that: knots(index - 1) < k < knots(index + 1) the second syntax allows you also to increase the multiplicity of the knot to m (but it is not possible to decrease the multiplicity of the knot with this function). standard_constructionerror if: - k is not such that: knots(index - 1) < k < knots(index + 1) - m is greater than the degree of this bspline curve or lower than the previous multiplicity of knot of index index in the knots table. standard_outofrange if index is outside the bounds of the knots table.

        Parameters
        ----------
        Index: int
        K: float
        M: int

        Return
        -------
        None

        Description
        -----------
        Changes the knot of range index with its multiplicity. you can increase the multiplicity of a knot but it is not allowed to decrease the multiplicity of an existing knot. //! raised if k >= knots(index+1) or k <= knots(index-1). raised if m is greater than degree or lower than the previous multiplicity of knot of range index. raised if index < 1 || index > nbknots.

        """
        return _Geom.Geom_BSplineCurve_SetKnot(self, *args)

    def SetKnots(self, *args):
        r"""

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Modifies this bspline curve by assigning the array k to its knots table. the multiplicity of the knots is not modified. exceptions standard_constructionerror if the values in the array k are not in ascending order. standard_outofrange if the bounds of the array k are not respectively 1 and the number of knots of this bspline curve.

        """
        return _Geom.Geom_BSplineCurve_SetKnots(self, *args)

    def SetNotPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Changes this bspline curve into a non-periodic curve. if this curve is already non-periodic, it is not modified. note: the poles and knots tables are modified. warning if this curve is periodic, as the multiplicity of the first and last knots is not modified, and is not equal to degree + 1, where degree is the degree of this bspline curve, the start and end points of the curve are not its first and last poles.

        """
        return _Geom.Geom_BSplineCurve_SetNotPeriodic(self, *args)

    def SetOrigin(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Assigns the knot of index index in the knots table as the origin of this periodic bspline curve. as a consequence, the knots and poles tables are modified. exceptions standard_nosuchobject if this curve is not periodic. standard_domainerror if index is outside the bounds of the knots table.

        Parameters
        ----------
        U: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Set the origin of a periodic curve at knot u. if u is not a knot of the bspline a new knot is inserted. knotvector and poles are modified. raised if the curve is not periodic.

        """
        return _Geom.Geom_BSplineCurve_SetOrigin(self, *args)

    def SetPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Changes this bspline curve into a periodic curve. to become periodic, the curve must first be closed. next, the knot sequence must be periodic. for this, firstuknotindex and lastuknotindex are used to compute i1 and i2, the indexes in the knots array of the knots corresponding to the first and last parameters of this bspline curve. the period is therefore: knots(i2) - knots(i1). consequently, the knots and poles tables are modified. exceptions standard_constructionerror if this bspline curve is not closed.

        """
        return _Geom.Geom_BSplineCurve_SetPeriodic(self, *args)

    def SetPole(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Modifies this bspline curve by assigning p to the pole of index index in the poles table. exceptions standard_outofrange if index is outside the bounds of the poles table. standard_constructionerror if weight is negative or null.

        Parameters
        ----------
        Index: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Modifies this bspline curve by assigning p to the pole of index index in the poles table. this syntax also allows you to modify the weight of the modified pole, which becomes weight. in this case, if this bspline curve is non-rational, it can become rational and vice versa. exceptions standard_outofrange if index is outside the bounds of the poles table. standard_constructionerror if weight is negative or null.

        """
        return _Geom.Geom_BSplineCurve_SetPole(self, *args)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Changes the weight for the pole of range index. if the curve was non rational it can become rational. if the curve was rational it can become non rational. //! raised if index < 1 || index > nbpoles raised if weight <= 0.0.

        """
        return _Geom.Geom_BSplineCurve_SetWeight(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight of the pole of range index . raised if index < 1 or index > nbpoles.

        """
        return _Geom.Geom_BSplineCurve_Weight(self, *args)

    def Weights(self, *args):
        r"""

        Parameters
        ----------
        W: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the weights of the b-spline curve; //! raised if the length of w is not equal to nbpoles.
        Return
        -------
        TColStd_Array1OfReal *

        Description
        -----------
        Returns the weights of the b-spline curve;.

        """
        return _Geom.Geom_BSplineCurve_Weights(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BSplineCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BSplineCurve

# Register Geom_BSplineCurve in _Geom:
_Geom.Geom_BSplineCurve_swigregister(Geom_BSplineCurve)
class Geom_BSplineSurface(Geom_BoundedSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger
        VMults: TColStd_Array1OfInteger
        UDegree: int
        VDegree: int
        UPeriodic: bool (optional, default to Standard_False)
        VPeriodic: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates a non-rational b-spline surface (weights default value is 1.). the following conditions must be verified. 0 < udegree <= maxdegree. uknots.length() == umults.length() >= 2 uknots(i) < uknots(i+1) (knots are increasing) 1 <= umults(i) <= udegree on a non uperiodic surface the first and last umultiplicities may be udegree+1 (this is even recommended if you want the curve to start and finish on the first and last pole). on a uperiodic surface the first and the last umultiplicities must be the same. on non-uperiodic surfaces poles.collength() == sum(umults(i)) - udegree - 1 >= 2 on uperiodic surfaces poles.collength() == sum(umults(i)) except the first or last the previous conditions for u holds also for v, with the rowlength of the poles.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger
        VMults: TColStd_Array1OfInteger
        UDegree: int
        VDegree: int
        UPeriodic: bool (optional, default to Standard_False)
        VPeriodic: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates a non-rational b-spline surface (weights default value is 1.). //! the following conditions must be verified. 0 < udegree <= maxdegree. //! uknots.length() == umults.length() >= 2 //! uknots(i) < uknots(i+1) (knots are increasing) 1 <= umults(i) <= udegree //! on a non uperiodic surface the first and last umultiplicities may be udegree+1 (this is even recommended if you want the curve to start and finish on the first and last pole). //! on a uperiodic surface the first and the last umultiplicities must be the same. //! on non-uperiodic surfaces //! poles.collength() == sum(umults(i)) - udegree - 1 >= 2 //! on uperiodic surfaces //! poles.collength() == sum(umults(i)) except the first or last //! the previous conditions for u holds also for v, with the rowlength of the poles.

        """
        _Geom.Geom_BSplineSurface_swiginit(self, _Geom.new_Geom_BSplineSurface(*args))

    def CheckAndSegment(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        V1: float
        V2: float
        theUTolerance: float (optional, default to Precision::PConfusion())
        theVTolerance: float (optional, default to Precision::PConfusion())

        Return
        -------
        None

        Description
        -----------
        Segments the surface between u1 and u2 in the u-direction. between v1 and v2 in the v-direction. //! same as segment but do nothing if u1 and u2 (resp. v1 and v2) are equal to the bounds in u (resp. in v) of <self>. for example, if <self> is periodic in v, it will be always periodic in v after the segmentation if the bounds in v are unchanged //! parameters theutolerance, thevtolerance define the possible proximity along the corresponding direction of the segment boundaries and b-spline knots to treat them as equal. //! warnings: even if <self> is not closed it can become closed after the segmentation for example if u1 or u2 are out of the bounds of the surface <self> or if the surface makes loop. raises if u2 < u1 or v2 < v1. standard_domainerror if u2 - u1 exceeds the uperiod for uperiodic surfaces. i.e. ((u2 - u1) - uperiod) > precision::pconfusion(). standard_domainerror if v2 - v1 exceeds the vperiod for vperiodic surfaces. i.e. ((v2 - v1) - vperiod) > precision::pconfusion()).

        """
        return _Geom.Geom_BSplineSurface_CheckAndSegment(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_BSplineSurface_DumpJson(self, depth)

    def ExchangeUV(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Exchanges the u and v parametric directions on this bspline surface. as a consequence: - the poles and weights tables are transposed, - the knots and multiplicities tables are exchanged, - degrees of continuity, and rational, periodic and uniform characteristics are exchanged, and - the orientation of the surface is inverted.

        """
        return _Geom.Geom_BSplineSurface_ExchangeUV(self, *args)

    def FirstUKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Computes the index of the uknots which gives the first parametric value of the surface in the u direction. the uiso curve corresponding to this value is a boundary curve of the surface.

        """
        return _Geom.Geom_BSplineSurface_FirstUKnotIndex(self, *args)

    def FirstVKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Computes the index of the vknots which gives the first parametric value of the surface in the v direction. the viso curve corresponding to this knot is a boundary curve of the surface.

        """
        return _Geom.Geom_BSplineSurface_FirstVKnotIndex(self, *args)

    def IncreaseDegree(self, *args):
        r"""

        Parameters
        ----------
        UDegree: int
        VDegree: int

        Return
        -------
        None

        Description
        -----------
        Increases the degrees of this bspline surface to udegree and vdegree in the u and v parametric directions respectively. as a result, the tables of poles, weights and multiplicities are modified. the tables of knots is not changed. note: nothing is done if the given degree is less than or equal to the current degree in the corresponding parametric direction. exceptions standard_constructionerror if udegree or vdegree is greater than geom_bsplinesurface::maxdegree().

        """
        return _Geom.Geom_BSplineSurface_IncreaseDegree(self, *args)

    def IncreaseUMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases the multiplicity of the knot of range uindex in the uknots sequence. m is the new multiplicity. m must be greater than the previous multiplicity and lower or equal to the degree of the surface in the u parametric direction. raised if m is not in the range [1, udegree] //! raised if uindex is not in the range [firstuknotindex, lastuknotindex] given by the methods with the same name.

        Parameters
        ----------
        FromI1: int
        ToI2: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases until order m the multiplicity of the set of knots fromi1,...., toi2 in the u direction. this method can be used to make a b_spline surface into a piecewisebezier b_spline surface. if <self> was uniform, it can become non uniform. //! raised if fromi1 or toi2 is out of the range [firstuknotindex, lastuknotindex]. //! m should be greater than the previous multiplicity of the all the knots fromi1,..., toi2 and lower or equal to the degree of the surface in the u parametric direction.

        """
        return _Geom.Geom_BSplineSurface_IncreaseUMultiplicity(self, *args)

    def IncreaseVMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases the multiplicity of a knot in the v direction. m is the new multiplicity. //! m should be greater than the previous multiplicity and lower than the degree of the surface in the v parametric direction. //! raised if vindex is not in the range [firstvknotindex, lastvknotindex] given by the methods with the same name.

        Parameters
        ----------
        FromI1: int
        ToI2: int
        M: int

        Return
        -------
        None

        Description
        -----------
        Increases until order m the multiplicity of the set of knots fromi1,...., toi2 in the v direction. this method can be used to make a bsplinesurface into a piecewisebezier b_spline surface. if <self> was uniform, it can become non-uniform. //! raised if fromi1 or toi2 is out of the range [firstvknotindex, lastvknotindex] given by the methods with the same name. //! m should be greater than the previous multiplicity of the all the knots fromi1,..., toi2 and lower or equal to the degree of the surface in the v parametric direction.

        """
        return _Geom.Geom_BSplineSurface_IncreaseVMultiplicity(self, *args)

    def IncrementUMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        FromI1: int
        ToI2: int
        Step: int

        Return
        -------
        None

        Description
        -----------
        Increments the multiplicity of the consecutives uknots fromi1..toi2 by step. the multiplicity of each knot fromi1,.....,toi2 must be lower or equal to the udegree of the b_spline. //! raised if fromi1 or toi2 is not in the range [firstuknotindex, lastuknotindex] //! raised if one knot has a multiplicity greater than udegree.

        """
        return _Geom.Geom_BSplineSurface_IncrementUMultiplicity(self, *args)

    def IncrementVMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        FromI1: int
        ToI2: int
        Step: int

        Return
        -------
        None

        Description
        -----------
        Increments the multiplicity of the consecutives vknots fromi1..toi2 by step. the multiplicity of each knot fromi1,.....,toi2 must be lower or equal to the vdegree of the b_spline. //! raised if fromi1 or toi2 is not in the range [firstvknotindex, lastvknotindex] //! raised if one knot has a multiplicity greater than vdegree.

        """
        return _Geom.Geom_BSplineSurface_IncrementVMultiplicity(self, *args)

    def InsertUKnot(self, *args):
        r"""

        Parameters
        ----------
        U: float
        M: int
        ParametricTolerance: float
        Add: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Inserts a knot value in the sequence of uknots. if u is a knot value this method increases the multiplicity of the knot if the previous multiplicity was lower than m else it does nothing. the tolerance criterion is parametrictolerance. parametrictolerance should be greater or equal than resolution from package gp. //! raised if u is out of the bounds [u1, u2] given by the methods bounds, the criterion parametrictolerance is used. raised if m is not in the range [1, udegree].

        """
        return _Geom.Geom_BSplineSurface_InsertUKnot(self, *args)

    def InsertUKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        ParametricTolerance: float (optional, default to 0.0)
        Add: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Inserts into the knots table for the u parametric direction of this bspline surface: - the values of the array knots, with their respective multiplicities, mults. if the knot value to insert already exists in the table, its multiplicity is: - increased by m, if add is true (the default), or - increased to m, if add is false. the tolerance criterion used to check the equality of the knots is the larger of the values parametrictolerance and standard_real::epsilon(val), where val is the knot value to be inserted. warning - if a given multiplicity coefficient is null, or negative, nothing is done. - the new multiplicity of a knot is limited to the degree of this bspline surface in the corresponding parametric direction. exceptions standard_constructionerror if a knot value to insert is outside the bounds of this bspline surface in the specified parametric direction. the comparison uses the precision criterion parametrictolerance.

        """
        return _Geom.Geom_BSplineSurface_InsertUKnots(self, *args)

    def InsertVKnot(self, *args):
        r"""

        Parameters
        ----------
        V: float
        M: int
        ParametricTolerance: float
        Add: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Inserts a knot value in the sequence of vknots. if v is a knot value this method increases the multiplicity of the knot if the previous multiplicity was lower than m otherwise it does nothing. the tolerance criterion is parametrictolerance. parametrictolerance should be greater or equal than resolution from package gp. //! raises if v is out of the bounds [v1, v2] given by the methods bounds, the criterion parametrictolerance is used. raises if m is not in the range [1, vdegree].

        """
        return _Geom.Geom_BSplineSurface_InsertVKnot(self, *args)

    def InsertVKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        ParametricTolerance: float (optional, default to 0.0)
        Add: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Inserts into the knots table for the v parametric direction of this bspline surface: - the values of the array knots, with their respective multiplicities, mults. if the knot value to insert already exists in the table, its multiplicity is: - increased by m, if add is true (the default), or - increased to m, if add is false. the tolerance criterion used to check the equality of the knots is the larger of the values parametrictolerance and standard_real::epsilon(val), where val is the knot value to be inserted. warning - if a given multiplicity coefficient is null, or negative, nothing is done. - the new multiplicity of a knot is limited to the degree of this bspline surface in the corresponding parametric direction. exceptions standard_constructionerror if a knot value to insert is outside the bounds of this bspline surface in the specified parametric direction. the comparison uses the precision criterion parametrictolerance.

        """
        return _Geom.Geom_BSplineSurface_InsertVKnots(self, *args)

    def IsURational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if for each row of weights all the weights are identical. the tolerance criterion is resolution from package gp. example: |1.0, 1.0, 1.0| if weights = |0.5, 0.5, 0.5| returns false |2.0, 2.0, 2.0|.

        """
        return _Geom.Geom_BSplineSurface_IsURational(self, *args)

    def IsVRational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if for each column of weights all the weights are identical. the tolerance criterion is resolution from package gp. examples: |1.0, 2.0, 0.5| if weights = |1.0, 2.0, 0.5| returns false |1.0, 2.0, 0.5|.

        """
        return _Geom.Geom_BSplineSurface_IsVRational(self, *args)

    def LastUKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Computes the index of the uknots which gives the last parametric value of the surface in the u direction. the uiso curve corresponding to this knot is a boundary curve of the surface.

        """
        return _Geom.Geom_BSplineSurface_LastUKnotIndex(self, *args)

    def LastVKnotIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Computes the index of the vknots which gives the last parametric value of the surface in the v direction. the viso curve corresponding to this knot is a boundary curve of the surface.

        """
        return _Geom.Geom_BSplineSurface_LastVKnotIndex(self, *args)

    def LocalD0(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Raised if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalD0(self, *args)

    def LocalD1(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the surface is not c1 between the knots fromuk1, touk2 and fromvk1, tovk2. raised if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalD1(self, *args)

    def LocalD2(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec
        D2U: gp_Vec
        D2V: gp_Vec
        D2UV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the surface is not c2 between the knots fromuk1, touk2 and fromvk1, tovk2. raised if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalD2(self, *args)

    def LocalD3(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        P: gp_Pnt
        D1U: gp_Vec
        D1V: gp_Vec
        D2U: gp_Vec
        D2V: gp_Vec
        D2UV: gp_Vec
        D3U: gp_Vec
        D3V: gp_Vec
        D3UUV: gp_Vec
        D3UVV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Raised if the local continuity of the surface is not c3 between the knots fromuk1, touk2 and fromvk1, tovk2. raised if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalD3(self, *args)

    def LocalDN(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        Nu: int
        Nv: int

        Return
        -------
        gp_Vec

        Description
        -----------
        Raised if the local continuity of the surface is not cnu between the knots fromuk1, touk2 and cnv between the knots fromvk1, tovk2. raised if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalDN(self, *args)

    def LocalValue(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the point of parameter u, v on the bspline surface patch defines between the knots uk1 uk2, vk1, vk2. u can be out of the bounds [knot uk1, knot uk2] and v can be outof the bounds [knot vk1, knot vk2] but for the computation we only use the definition of the surface between these knot values. raises if fromuk1 = touk2 or fromvk1 = tovk2.

        """
        return _Geom.Geom_BSplineSurface_LocalValue(self, *args)

    def LocateU(self, *args):
        r"""

        Parameters
        ----------
        U: float
        ParametricTolerance: float
        WithKnotRepetition: bool (optional, default to Standard_False)

        Return
        -------
        I1: int
        I2: int

        Description
        -----------
        Locates the parametric value u in the sequence of uknots. if 'withknotrepetition' is true we consider the knot's representation with repetition of multiple knot value, otherwise we consider the knot's representation with no repetition of multiple knot values. uknots (i1) <= u <= uknots (i2) . if i1 = i2 u is a knot value (the tolerance criterion parametrictolerance is used). . if i1 < 1 => u < uknots(1) - abs(parametrictolerance) . if i2 > nbuknots => u > uknots(nbuknots)+abs(parametrictolerance).

        """
        return _Geom.Geom_BSplineSurface_LocateU(self, *args)

    def LocateV(self, *args):
        r"""

        Parameters
        ----------
        V: float
        ParametricTolerance: float
        WithKnotRepetition: bool (optional, default to Standard_False)

        Return
        -------
        I1: int
        I2: int

        Description
        -----------
        Locates the parametric value v in the sequence of knots. if 'withknotrepetition' is true we consider the knot's representation with repetition of multiple knot value, otherwise we consider the knot's representation with no repetition of multiple knot values. vknots (i1) <= v <= vknots (i2) . if i1 = i2 v is a knot value (the tolerance criterion parametrictolerance is used). . if i1 < 1 => v < vknots(1) - abs(parametrictolerance) . if i2 > nbvknots => v > vknots(nbvknots)+abs(parametrictolerance) poles insertion and removing the following methods are available only if the surface is uniform or quasiuniform in the considered direction the knot repartition is modified.

        """
        return _Geom.Geom_BSplineSurface_LocateV(self, *args)

    @staticmethod
    def MaxDegree(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value of the maximum degree of the normalized b-spline basis functions in the u and v directions.

        """
        return _Geom.Geom_BSplineSurface_MaxDegree(*args)

    def MovePoint(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt
        UIndex1: int
        UIndex2: int
        VIndex1: int
        VIndex2: int

        Return
        -------
        UFirstIndex: int
        ULastIndex: int
        VFirstIndex: int
        VLastIndex: int

        Description
        -----------
        Move a point with parameter u and v to p. given u,v as parameters) to reach a new position uindex1, uindex2, vindex1, vindex2: indicates the poles which can be moved if problem in bsplinebasis calculation, no change for the curve and ufirstindex, vlastindex = 0 vfirstindex, vlastindex = 0 //! raised if uindex1 < uindex2 or vindex1 < vindex2 or uindex1 < 1 || uindex1 > nbupoles or uindex2 < 1 || uindex2 > nbupoles vindex1 < 1 || vindex1 > nbvpoles or vindex2 < 1 || vindex2 > nbvpoles characteristics of the surface.

        """
        return _Geom.Geom_BSplineSurface_MovePoint(self, *args)

    def NbUKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots in the u direction.

        """
        return _Geom.Geom_BSplineSurface_NbUKnots(self, *args)

    def NbUPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of poles in the u direction.

        """
        return _Geom.Geom_BSplineSurface_NbUPoles(self, *args)

    def NbVKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots in the v direction.

        """
        return _Geom.Geom_BSplineSurface_NbVKnots(self, *args)

    def NbVPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles in the v direction.

        """
        return _Geom.Geom_BSplineSurface_NbVPoles(self, *args)

    def PeriodicNormalization(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        U: float
        V: float

        Description
        -----------
        Returns the parameter normalized within the period if the surface is periodic: otherwise does not do anything.

        """
        return _Geom.Geom_BSplineSurface_PeriodicNormalization(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the pole of range (uindex, vindex). //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles.

        """
        return _Geom.Geom_BSplineSurface_Pole(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        P: TColgp_Array2OfPnt

        Return
        -------
        None

        Description
        -----------
        Returns the poles of the b-spline surface. //! raised if the length of p in the u and v direction is not equal to nbupoles and nbvpoles.
        Return
        -------
        TColgp_Array2OfPnt

        Description
        -----------
        Returns the poles of the b-spline surface.

        """
        return _Geom.Geom_BSplineSurface_Poles(self, *args)

    def RemoveUKnot(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        M: int
        Tolerance: float

        Return
        -------
        bool

        Description
        -----------
        Reduces to m the multiplicity of the knot of index index in the u parametric direction. if m is 0, the knot is removed. with a modification of this type, the table of poles is also modified. two different algorithms are used systematically to compute the new poles of the surface. for each pole, the distance between the pole calculated using the first algorithm and the same pole calculated using the second algorithm, is checked. if this distance is less than tolerance it ensures that the surface is not modified by more than tolerance. under these conditions, the function returns true; otherwise, it returns false. a low tolerance prevents modification of the surface. a high tolerance 'smoothes' the surface. exceptions standard_outofrange if index is outside the bounds of the knots table of this bspline surface.

        """
        return _Geom.Geom_BSplineSurface_RemoveUKnot(self, *args)

    def RemoveVKnot(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        M: int
        Tolerance: float

        Return
        -------
        bool

        Description
        -----------
        Reduces to m the multiplicity of the knot of index index in the v parametric direction. if m is 0, the knot is removed. with a modification of this type, the table of poles is also modified. two different algorithms are used systematically to compute the new poles of the surface. for each pole, the distance between the pole calculated using the first algorithm and the same pole calculated using the second algorithm, is checked. if this distance is less than tolerance it ensures that the surface is not modified by more than tolerance. under these conditions, the function returns true; otherwise, it returns false. a low tolerance prevents modification of the surface. a high tolerance 'smoothes' the surface. exceptions standard_outofrange if index is outside the bounds of the knots table of this bspline surface.

        """
        return _Geom.Geom_BSplineSurface_RemoveVKnot(self, *args)

    def Resolution(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3D: float

        Return
        -------
        UTolerance: float
        VTolerance: float

        Description
        -----------
        Computes two tolerance values for this bspline surface, based on the given tolerance in 3d space tolerance3d. the tolerances computed are: - utolerance in the u parametric direction, and - vtolerance in the v parametric direction. if f(u,v) is the equation of this bspline surface, utolerance and vtolerance guarantee that: | u1 - u0 | < utolerance and | v1 - v0 | < vtolerance ====> |f (u1,v1) - f (u0,v0)| < tolerance3d.

        """
        return _Geom.Geom_BSplineSurface_Resolution(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        V1: float
        V2: float
        theUTolerance: float (optional, default to Precision::PConfusion())
        theVTolerance: float (optional, default to Precision::PConfusion())

        Return
        -------
        None

        Description
        -----------
        Segments the surface between u1 and u2 in the u-direction. between v1 and v2 in the v-direction. the control points are modified, the first and the last point are not the same. //! parameters theutolerance, thevtolerance define the possible proximity along the corresponding direction of the segment boundaries and b-spline knots to treat them as equal. //! warnings: even if <self> is not closed it can become closed after the segmentation for example if u1 or u2 are out of the bounds of the surface <self> or if the surface makes loop. raises if u2 < u1 or v2 < v1. standard_domainerror if u2 - u1 exceeds the uperiod for uperiodic surfaces. i.e. ((u2 - u1) - uperiod) > precision::pconfusion(). standard_domainerror if v2 - v1 exceeds the vperiod for vperiodic surfaces. i.e. ((v2 - v1) - vperiod) > precision::pconfusion()).

        """
        return _Geom.Geom_BSplineSurface_Segment(self, *args)

    def SetPole(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Substitutes the pole of range (uindex, vindex) with p. if the surface is rational the weight of range (uindex, vindex) is not modified. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles.

        Parameters
        ----------
        UIndex: int
        VIndex: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Substitutes the pole and the weight of range (uindex, vindex) with p and w. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles. raised if weight <= resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_SetPole(self, *args)

    def SetPoleCol(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Changes a column of poles or a part of this column. raised if vindex < 1 or vindex > nbvpoles. //! raised if cpoles.lower() < 1 or cpoles.upper() > nbupoles.

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes a column of poles or a part of this column with the corresponding weights. if the surface was rational it can become non rational. if the surface was non rational it can become rational. raised if vindex < 1 or vindex > nbvpoles. //! raised if cpoles.lower() < 1 or cpoles.upper() > nbupoles raised if the bounds of cpoleweights are not the same as the bounds of cpoles. raised if one of the weight value of cpoleweights is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_SetPoleCol(self, *args)

    def SetPoleRow(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes a row of poles or a part of this row with the corresponding weights. if the surface was rational it can become non rational. if the surface was non rational it can become rational. raised if uindex < 1 or uindex > nbupoles. //! raised if cpoles.lower() < 1 or cpoles.upper() > nbvpoles raises if the bounds of cpoleweights are not the same as the bounds of cpoles. raised if one of the weight value of cpoleweights is lower or equal to resolution from package gp.

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Changes a row of poles or a part of this row. raised if uindex < 1 or uindex > nbupoles. //! raised if cpoles.lower() < 1 or cpoles.upper() > nbvpoles.

        """
        return _Geom.Geom_BSplineSurface_SetPoleRow(self, *args)

    def SetUKnot(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        K: float

        Return
        -------
        None

        Description
        -----------
        Substitutes the uknots of range uindex with k. //! raised if uindex < 1 or uindex > nbuknots //! raised if k >= uknots(uindex+1) or k <= uknots(uindex-1).

        Parameters
        ----------
        UIndex: int
        K: float
        M: int

        Return
        -------
        None

        Description
        -----------
        Changes the value of the uknots of range uindex and increases its multiplicity. //! raised if uindex is not in the range [firstuknotindex, lastuknotindex] given by the methods with the same name. //! raised if k >= uknots(uindex+1) or k <= uknots(uindex-1) m must be lower than udegree and greater than the previous multiplicity of the knot of range uindex.

        """
        return _Geom.Geom_BSplineSurface_SetUKnot(self, *args)

    def SetUKnots(self, *args):
        r"""

        Parameters
        ----------
        UK: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes all the u-knots of the surface. the multiplicity of the knots are not modified. //! raised if there is an index such that uk (index+1) <= uk (index). //! raised if uk.lower() < 1 or uk.upper() > nbuknots.

        """
        return _Geom.Geom_BSplineSurface_SetUKnots(self, *args)

    def SetUNotPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the surface u not periodic. changes this bspline surface into a non-periodic surface along u direction. if this surface is already non-periodic, it is not modified. note: the poles and knots tables are modified.

        """
        return _Geom.Geom_BSplineSurface_SetUNotPeriodic(self, *args)

    def SetUOrigin(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Assigns the knot of index index in the knots table in the corresponding parametric direction to be the origin of this periodic bspline surface. as a consequence, the knots and poles tables are modified. exceptions standard_nosuchobject if this bspline surface is not periodic in the given parametric direction. standard_domainerror if index is outside the bounds of the knots table in the given parametric direction.

        """
        return _Geom.Geom_BSplineSurface_SetUOrigin(self, *args)

    def SetUPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the surface u periodic. modifies this surface to be periodic in the u parametric direction. to become periodic in a given parametric direction a surface must be closed in that parametric direction, and the knot sequence relative to that direction must be periodic. to generate this periodic sequence of knots, the functions firstuknotindex and lastuknotindex are used to compute i1 and i2. these are the indexes, in the knot array associated with the given parametric direction, of the knots that correspond to the first and last parameters of this bspline surface in the given parametric direction. hence the period is: knots(i1) - knots(i2) as a result, the knots and poles tables are modified. exceptions standard_constructionerror if the surface is not closed in the given parametric direction.

        """
        return _Geom.Geom_BSplineSurface_SetUPeriodic(self, *args)

    def SetVKnot(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        K: float

        Return
        -------
        None

        Description
        -----------
        Substitutes the vknots of range vindex with k. //! raised if vindex < 1 or vindex > nbvknots //! raised if k >= vknots(vindex+1) or k <= vknots(vindex-1).

        Parameters
        ----------
        VIndex: int
        K: float
        M: int

        Return
        -------
        None

        Description
        -----------
        Changes the value of the vknots of range vindex and increases its multiplicity. //! raised if vindex is not in the range [firstvknotindex, lastvknotindex] given by the methods with the same name. //! raised if k >= vknots(vindex+1) or k <= vknots(vindex-1) m must be lower than vdegree and greater than the previous multiplicity of the knot of range vindex.

        """
        return _Geom.Geom_BSplineSurface_SetVKnot(self, *args)

    def SetVKnots(self, *args):
        r"""

        Parameters
        ----------
        VK: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes all the v-knots of the surface. the multiplicity of the knots are not modified. //! raised if there is an index such that vk (index+1) <= vk (index). //! raised if vk.lower() < 1 or vk.upper() > nbvknots.

        """
        return _Geom.Geom_BSplineSurface_SetVKnots(self, *args)

    def SetVNotPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the surface v not periodic. changes this bspline surface into a non-periodic surface along v direction. if this surface is already non-periodic, it is not modified. note: the poles and knots tables are modified.

        """
        return _Geom.Geom_BSplineSurface_SetVNotPeriodic(self, *args)

    def SetVOrigin(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Assigns the knot of index index in the knots table in the corresponding parametric direction to be the origin of this periodic bspline surface. as a consequence, the knots and poles tables are modified. exceptions standard_nosuchobject if this bspline surface is not periodic in the given parametric direction. standard_domainerror if index is outside the bounds of the knots table in the given parametric direction.

        """
        return _Geom.Geom_BSplineSurface_SetVOrigin(self, *args)

    def SetVPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the surface v periodic. modifies this surface to be periodic in the v parametric direction. to become periodic in a given parametric direction a surface must be closed in that parametric direction, and the knot sequence relative to that direction must be periodic. to generate this periodic sequence of knots, the functions firstvknotindex and lastvknotindex are used to compute i1 and i2. these are the indexes, in the knot array associated with the given parametric direction, of the knots that correspond to the first and last parameters of this bspline surface in the given parametric direction. hence the period is: knots(i1) - knots(i2) as a result, the knots and poles tables are modified. exceptions standard_constructionerror if the surface is not closed in the given parametric direction.

        """
        return _Geom.Geom_BSplineSurface_SetVPeriodic(self, *args)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Changes the weight of the pole of range uindex, vindex. if the surface was non rational it can become rational. if the surface was rational it can become non rational. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles //! raised if weight is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_SetWeight(self, *args)

    def SetWeightCol(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes a column of weights of a part of this column. //! raised if vindex < 1 or vindex > nbvpoles //! raised if cpoleweights.lower() < 1 or cpoleweights.upper() > nbupoles. raised if a weight value is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_SetWeightCol(self, *args)

    def SetWeightRow(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Changes a row of weights or a part of this row. //! raised if uindex < 1 or uindex > nbupoles //! raised if cpoleweights.lower() < 1 or cpoleweights.upper() > nbvpoles. raised if a weight value is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_SetWeightRow(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the normalized b-splines ni,n in the u direction.

        """
        return _Geom.Geom_BSplineSurface_UDegree(self, *args)

    def UIso(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the u isoparametric curve. a b-spline curve is returned.

        Parameters
        ----------
        U: float
        CheckRational: bool

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the u isoparametric curve. if checkrational=false, no try to make it non-rational. a b-spline curve is returned.

        """
        return _Geom.Geom_BSplineSurface_UIso(self, *args)

    def UKnot(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the knot value of range uindex. raised if uindex < 1 or uindex > nbuknots.

        """
        return _Geom.Geom_BSplineSurface_UKnot(self, *args)

    def UKnotDistribution(self, *args):
        r"""
        Return
        -------
        GeomAbs_BSplKnotDistribution

        Description
        -----------
        Returns nonuniform or uniform or quasiuniform or piecewisebezier. if all the knots differ by a positive constant from the preceding knot in the u direction the b-spline surface can be: - uniform if all the knots are of multiplicity 1, - quasiuniform if all the knots are of multiplicity 1 except for the first and last knot which are of multiplicity degree + 1, - piecewisebezier if the first and last knots have multiplicity degree + 1 and if interior knots have multiplicity degree otherwise the surface is non uniform in the u direction the tolerance criterion is resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_UKnotDistribution(self, *args)

    def UKnotSequence(self, *args):
        r"""

        Parameters
        ----------
        Ku: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the uknots sequence. in this sequence the knots with a multiplicity greater than 1 are repeated. example: ku = {k1, k1, k1, k2, k3, k3, k4, k4, k4} //! raised if the length of ku is not equal to nbupoles + udegree + 1.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the uknots sequence. in this sequence the knots with a multiplicity greater than 1 are repeated. example: ku = {k1, k1, k1, k2, k3, k3, k4, k4, k4}.

        """
        return _Geom.Geom_BSplineSurface_UKnotSequence(self, *args)

    def UKnots(self, *args):
        r"""

        Parameters
        ----------
        Ku: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the knots in the u direction. //! raised if the length of ku is not equal to the number of knots in the u direction.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the knots in the u direction.

        """
        return _Geom.Geom_BSplineSurface_UKnots(self, *args)

    def UMultiplicities(self, *args):
        r"""

        Parameters
        ----------
        Mu: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Returns the multiplicities of the knots in the u direction. //! raised if the length of mu is not equal to the number of knots in the u direction.
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        Returns the multiplicities of the knots in the u direction.

        """
        return _Geom.Geom_BSplineSurface_UMultiplicities(self, *args)

    def UMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity value of knot of range uindex in the u direction. raised if uindex < 1 or uindex > nbuknots.

        """
        return _Geom.Geom_BSplineSurface_UMultiplicity(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the normalized b-splines ni,d in the v direction.

        """
        return _Geom.Geom_BSplineSurface_VDegree(self, *args)

    def VIso(self, *args):
        r"""

        Parameters
        ----------
        V: float

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the v isoparametric curve. a b-spline curve is returned.

        Parameters
        ----------
        V: float
        CheckRational: bool

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Computes the v isoparametric curve. if checkrational=false, no try to make it non-rational. a b-spline curve is returned. transformations.

        """
        return _Geom.Geom_BSplineSurface_VIso(self, *args)

    def VKnot(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the knot value of range vindex. raised if vindex < 1 or vindex > nbvknots.

        """
        return _Geom.Geom_BSplineSurface_VKnot(self, *args)

    def VKnotDistribution(self, *args):
        r"""
        Return
        -------
        GeomAbs_BSplKnotDistribution

        Description
        -----------
        Returns nonuniform or uniform or quasiuniform or piecewisebezier. if all the knots differ by a positive constant from the preceding knot in the v direction the b-spline surface can be: - uniform if all the knots are of multiplicity 1, - quasiuniform if all the knots are of multiplicity 1 except for the first and last knot which are of multiplicity degree + 1, - piecewisebezier if the first and last knots have multiplicity degree + 1 and if interior knots have multiplicity degree otherwise the surface is non uniform in the v direction. the tolerance criterion is resolution from package gp.

        """
        return _Geom.Geom_BSplineSurface_VKnotDistribution(self, *args)

    def VKnotSequence(self, *args):
        r"""

        Parameters
        ----------
        Kv: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the vknots sequence. in this sequence the knots with a multiplicity greater than 1 are repeated. example: kv = {k1, k1, k1, k2, k3, k3, k4, k4, k4} //! raised if the length of kv is not equal to nbvpoles + vdegree + 1.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the vknots sequence. in this sequence the knots with a multiplicity greater than 1 are repeated. example: ku = {k1, k1, k1, k2, k3, k3, k4, k4, k4}.

        """
        return _Geom.Geom_BSplineSurface_VKnotSequence(self, *args)

    def VKnots(self, *args):
        r"""

        Parameters
        ----------
        Kv: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the knots in the v direction. //! raised if the length of kv is not equal to the number of knots in the v direction.
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the knots in the v direction.

        """
        return _Geom.Geom_BSplineSurface_VKnots(self, *args)

    def VMultiplicities(self, *args):
        r"""

        Parameters
        ----------
        Mv: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Returns the multiplicities of the knots in the v direction. //! raised if the length of mv is not equal to the number of knots in the v direction.
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        Returns the multiplicities of the knots in the v direction.

        """
        return _Geom.Geom_BSplineSurface_VMultiplicities(self, *args)

    def VMultiplicity(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the multiplicity value of knot of range vindex in the v direction. raised if vindex < 1 or vindex > nbvknots.

        """
        return _Geom.Geom_BSplineSurface_VMultiplicity(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight value of range uindex, vindex. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles.

        """
        return _Geom.Geom_BSplineSurface_Weight(self, *args)

    def Weights(self, *args):
        r"""

        Parameters
        ----------
        W: TColStd_Array2OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the weights of the b-spline surface. //! raised if the length of w in the u and v direction is not equal to nbupoles and nbvpoles.
        Return
        -------
        TColStd_Array2OfReal *

        Description
        -----------
        Returns the weights of the b-spline surface. value and derivatives computation.

        """
        return _Geom.Geom_BSplineSurface_Weights(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BSplineSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BSplineSurface

# Register Geom_BSplineSurface in _Geom:
_Geom.Geom_BSplineSurface_swigregister(Geom_BSplineSurface)
class Geom_BezierCurve(Geom_BoundedCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        CurvePoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Creates a non rational bezier curve with a set of poles curvepoles. the weights are defaulted to all being 1. raises constructionerror if the number of poles is greater than maxdegree + 1 or lower than 2.

        Parameters
        ----------
        CurvePoles: TColgp_Array1OfPnt
        PoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Creates a rational bezier curve with the set of poles curvepoles and the set of weights poleweights . if all the weights are identical the curve is considered as non rational. raises constructionerror if the number of poles is greater than maxdegree + 1 or lower than 2 or curvepoles and curveweights have not the same length or one weight value is lower or equal to resolution from package gp.

        """
        _Geom.Geom_BezierCurve_swiginit(self, _Geom.new_Geom_BezierCurve(*args))

    def Degree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the polynomial degree of the curve. it is the number of poles - 1 point p and derivatives (v1, v2, v3) computation the bezier curve has a polynomial representation so the parameter u can be out of the bounds of the curve.

        """
        return _Geom.Geom_BezierCurve_Degree(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_BezierCurve_DumpJson(self, depth)

    def Increase(self, *args):
        r"""

        Parameters
        ----------
        Degree: int

        Return
        -------
        None

        Description
        -----------
        Increases the degree of a bezier curve. degree is the new degree of <self>. raises constructionerror if degree is greater than maxdegree or lower than 2 or lower than the initial degree of <self>.

        """
        return _Geom.Geom_BezierCurve_Increase(self, *args)

    def InsertPoleAfter(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Inserts a pole p after the pole of range index. if the curve <self> is rational the weight value for the new pole of range index is 1.0. raised if index is not in the range [1, nbpoles] //! raised if the resulting number of poles is greater than maxdegree + 1.

        Parameters
        ----------
        Index: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Inserts a pole with its weight in the set of poles after the pole of range index. if the curve was non rational it can become rational if all the weights are not identical. raised if index is not in the range [1, nbpoles] //! raised if the resulting number of poles is greater than maxdegree + 1. raised if weight is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierCurve_InsertPoleAfter(self, *args)

    def InsertPoleBefore(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Inserts a pole p before the pole of range index. if the curve <self> is rational the weight value for the new pole of range index is 1.0. raised if index is not in the range [1, nbpoles] //! raised if the resulting number of poles is greater than maxdegree + 1.

        Parameters
        ----------
        Index: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Inserts a pole with its weight in the set of poles after the pole of range index. if the curve was non rational it can become rational if all the weights are not identical. raised if index is not in the range [1, nbpoles] //! raised if the resulting number of poles is greater than maxdegree + 1. raised if weight is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierCurve_InsertPoleBefore(self, *args)

    def IsRational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if all the weights are identical. the tolerance criterion is resolution from package gp.

        """
        return _Geom.Geom_BezierCurve_IsRational(self, *args)

    @staticmethod
    def MaxDegree(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value of the maximum polynomial degree of any geom_beziercurve curve. this value is 25.

        """
        return _Geom.Geom_BezierCurve_MaxDegree(*args)

    def NbPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles of this bezier curve.

        """
        return _Geom.Geom_BezierCurve_NbPoles(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the pole of range index. raised if index is not in the range [1, nbpoles].

        """
        return _Geom.Geom_BezierCurve_Pole(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        P: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Returns all the poles of the curve. //! raised if the length of p is not equal to the number of poles.
        Return
        -------
        TColgp_Array1OfPnt

        Description
        -----------
        Returns all the poles of the curve.

        """
        return _Geom.Geom_BezierCurve_Poles(self, *args)

    def RemovePole(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        None

        Description
        -----------
        Removes the pole of range index. if the curve was rational it can become non rational. raised if index is not in the range [1, nbpoles] raised if degree is lower than 2.

        """
        return _Geom.Geom_BezierCurve_RemovePole(self, *args)

    def Resolution(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3D: float

        Return
        -------
        UTolerance: float

        Description
        -----------
        Computes for this bezier curve the parametric tolerance utolerance for a given 3d tolerance tolerance3d. if f(t) is the equation of this bezier curve, utolerance ensures that: |t1-t0| < utolerance ===> |f(t1)-f(t0)| < tolerance3d.

        """
        return _Geom.Geom_BezierCurve_Resolution(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float

        Return
        -------
        None

        Description
        -----------
        Segments the curve between u1 and u2 which can be out of the bounds of the curve. the curve is oriented from u1 to u2. the control points are modified, the first and the last point are not the same but the parametrization range is [0, 1] else it could not be a bezier curve. warnings: even if <self> is not closed it can become closed after the segmentation for example if u1 or u2 are out of the bounds of the curve <self> or if the curve makes loop. after the segmentation the length of a curve can be null.

        """
        return _Geom.Geom_BezierCurve_Segment(self, *args)

    def SetPole(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Substitutes the pole of range index with p. if the curve <self> is rational the weight of range index is not modified. raised if index is not in the range [1, nbpoles].

        Parameters
        ----------
        Index: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Substitutes the pole and the weights of range index. if the curve <self> is not rational it can become rational if all the weights are not identical. if the curve was rational it can become non rational if all the weights are identical. raised if index is not in the range [1, nbpoles] raised if weight <= resolution from package gp.

        """
        return _Geom.Geom_BezierCurve_SetPole(self, *args)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Changes the weight of the pole of range index. if the curve <self> is not rational it can become rational if all the weights are not identical. if the curve was rational it can become non rational if all the weights are identical. raised if index is not in the range [1, nbpoles] raised if weight <= resolution from package gp.

        """
        return _Geom.Geom_BezierCurve_SetWeight(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight of range index. raised if index is not in the range [1, nbpoles].

        """
        return _Geom.Geom_BezierCurve_Weight(self, *args)

    def Weights(self, *args):
        r"""

        Parameters
        ----------
        W: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns all the weights of the curve. //! raised if the length of w is not equal to the number of poles.
        Return
        -------
        TColStd_Array1OfReal *

        Description
        -----------
        Returns all the weights of the curve.

        """
        return _Geom.Geom_BezierCurve_Weights(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BezierCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BezierCurve

# Register Geom_BezierCurve in _Geom:
_Geom.Geom_BezierCurve_swigregister(Geom_BezierCurve)
class Geom_BezierSurface(Geom_BoundedSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SurfacePoles: TColgp_Array2OfPnt

        Return
        -------
        None

        Description
        -----------
        Creates a non-rational bezier surface with a set of poles. control points representation: spoles(uorigin,vorigin) ...................spoles(uorigin,vend) .  . .  . spoles(uend, vorigin) .....................spoles(uend, vend) for the double array the row indice corresponds to the parametric u direction and the columns indice corresponds to the parametric v direction. the weights are defaulted to all being 1. //! raised if the number of poles of the surface is lower than 2 or greater than maxdegree + 1 in one of the two directions u or v.

        Parameters
        ----------
        SurfacePoles: TColgp_Array2OfPnt
        PoleWeights: TColStd_Array2OfReal

        Return
        -------
        None

        Description
        -----------
        ---purpose creates a rational bezier surface with a set of poles and a set of weights. for the double array the row indice corresponds to the parametric u direction and the columns indice corresponds to the parametric v direction. if all the weights are identical the surface is considered as non-rational (the tolerance criterion is resolution from package gp). //! raised if surfacepoles and poleweights have not the same rowlength or have not the same collength. raised if poleweights (i, j) <= resolution from gp; raised if the number of poles of the surface is lower than 2 or greater than maxdegree + 1 in one of the two directions u or v.

        """
        _Geom.Geom_BezierSurface_swiginit(self, _Geom.new_Geom_BezierSurface(*args))

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_BezierSurface_DumpJson(self, depth)

    def ExchangeUV(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Exchanges the direction u and v on a bezier surface as a consequence: - the poles and weights tables are transposed, - degrees, rational characteristics and so on are exchanged between the two parametric directions, and - the orientation of the surface is reversed.

        """
        return _Geom.Geom_BezierSurface_ExchangeUV(self, *args)

    def Increase(self, *args):
        r"""

        Parameters
        ----------
        UDeg: int
        VDeg: int

        Return
        -------
        None

        Description
        -----------
        Increases the degree of this bezier surface in the two parametric directions. //! raised if udegree < udegree <self> or vdegree < vdegree <self> raised if the degree of the surface is greater than maxdegree in one of the two directions u or v.

        """
        return _Geom.Geom_BezierSurface_Increase(self, *args)

    def InsertPoleColAfter(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Inserts a column of poles. if the surface is rational the weights values associated with cpoles are equal defaulted to 1. //! raised if vindex < 1 or vindex > nbvpoles. //! raises if vdegree is greater than maxdegree. raises if the length of cpoles is not equal to nbupoles.

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Inserts a column of poles and weights. if the surface was non-rational it can become rational. //! raised if vindex < 1 or vindex > nbvpoles. raised if . vdegree is greater than maxdegree. . the length of cpoles is not equal to nbupoles . a weight value is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_InsertPoleColAfter(self, *args)

    def InsertPoleColBefore(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Inserts a column of poles. if the surface is rational the weights values associated with cpoles are equal defaulted to 1. //! raised if vindex < 1 or vindex > nbvpoles. //! raised if vdegree is greater than maxdegree. raised if the length of cpoles is not equal to nbupoles.

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Inserts a column of poles and weights. if the surface was non-rational it can become rational. //! raised if vindex < 1 or vindex > nbvpoles. raised if: . vdegree is greater than maxdegree. . the length of cpoles is not equal to nbupoles . a weight value is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_InsertPoleColBefore(self, *args)

    def InsertPoleRowAfter(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Inserts a row of poles. if the surface is rational the weights values associated with cpoles are equal defaulted to 1. //! raised if uindex < 1 or uindex > nbupoles. //! raised if udegree is greater than maxdegree. raised if the length of cpoles is not equal to nbvpoles.

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Inserts a row of poles and weights. if the surface was non-rational it can become rational. //! raised if uindex < 1 or uindex > nbupoles. raised if: . udegree is greater than maxdegree. . the length of cpoles is not equal to nbvpoles . a weight value is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_InsertPoleRowAfter(self, *args)

    def InsertPoleRowBefore(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Inserts a row of poles. if the surface is rational the weights values associated with cpoles are equal defaulted to 1. //! raised if uindex < 1 or uindex > nbupoles. //! raised if udegree is greater than maxdegree. raised if the length of cpoles is not equal to nbvpoles.

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Inserts a row of poles and weights. if the surface was non-rational it can become rational. //! raised if uindex < 1 or uindex > nbupoles. raised if: . udegree is greater than maxdegree. . the length of cpoles is not equal to nbvpoles . a weight value is lower or equal to resolution from pacakage gp.

        """
        return _Geom.Geom_BezierSurface_InsertPoleRowBefore(self, *args)

    def IsURational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the weights are identical in the u direction, the tolerance criterion is resolution from package gp. example: |1.0, 1.0, 1.0| if weights = |0.5, 0.5, 0.5| returns false |2.0, 2.0, 2.0|.

        """
        return _Geom.Geom_BezierSurface_IsURational(self, *args)

    def IsVRational(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the weights are identical in the v direction, the tolerance criterion is resolution from package gp. example: |1.0, 2.0, 0.5| if weights = |1.0, 2.0, 0.5| returns false |1.0, 2.0, 0.5|.

        """
        return _Geom.Geom_BezierSurface_IsVRational(self, *args)

    @staticmethod
    def MaxDegree(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value of the maximum polynomial degree of a bezier surface. this value is 25.

        """
        return _Geom.Geom_BezierSurface_MaxDegree(*args)

    def NbUPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles in the u direction.

        """
        return _Geom.Geom_BezierSurface_NbUPoles(self, *args)

    def NbVPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles in the v direction.

        """
        return _Geom.Geom_BezierSurface_NbVPoles(self, *args)

    def Pole(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the pole of range uindex, vindex raised if uindex < 1 or uindex > nbupoles, or vindex < 1 or vindex > nbvpoles.

        """
        return _Geom.Geom_BezierSurface_Pole(self, *args)

    def Poles(self, *args):
        r"""

        Parameters
        ----------
        P: TColgp_Array2OfPnt

        Return
        -------
        None

        Description
        -----------
        Returns the poles of the bezier surface. //! raised if the length of p in the u an v direction is not equal to nbupoles and nbvpoles.
        Return
        -------
        TColgp_Array2OfPnt

        Description
        -----------
        Returns the poles of the bezier surface.

        """
        return _Geom.Geom_BezierSurface_Poles(self, *args)

    def RemovePoleCol(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int

        Return
        -------
        None

        Description
        -----------
        Removes a column of poles. if the surface was rational it can become non-rational. //! raised if nbvpoles <= 2 after removing, a bezier surface must have at least two columns of poles. raised if vindex < 1 or vindex > nbvpoles.

        """
        return _Geom.Geom_BezierSurface_RemovePoleCol(self, *args)

    def RemovePoleRow(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        None

        Description
        -----------
        Removes a row of poles. if the surface was rational it can become non-rational. //! raised if nbupoles <= 2 after removing, a bezier surface must have at least two rows of poles. raised if uindex < 1 or uindex > nbupoles.

        """
        return _Geom.Geom_BezierSurface_RemovePoleRow(self, *args)

    def Resolution(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3D: float

        Return
        -------
        UTolerance: float
        VTolerance: float

        Description
        -----------
        Computes two tolerance values for this bezier surface, based on the given tolerance in 3d space tolerance3d. the tolerances computed are: - utolerance in the u parametric direction, and - vtolerance in the v parametric direction. if f(u,v) is the equation of this bezier surface, utolerance and vtolerance guarantee that: | u1 - u0 | < utolerance and | v1 - v0 | < vtolerance ====> |f (u1,v1) - f (u0,v0)| < tolerance3d.

        """
        return _Geom.Geom_BezierSurface_Resolution(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        V1: float
        V2: float

        Return
        -------
        None

        Description
        -----------
        Modifies this bezier surface by segmenting it between u1 and u2 in the u parametric direction, and between v1 and v2 in the v parametric direction. u1, u2, v1, and v2 can be outside the bounds of this surface. - u1 and u2 isoparametric bezier curves, segmented between v1 and v2, become the two bounds of the surface in the v parametric direction (0. and 1. u isoparametric curves). - v1 and v2 isoparametric bezier curves, segmented between u1 and u2, become the two bounds of the surface in the u parametric direction (0. and 1. v isoparametric curves). the poles and weights tables are modified, but the degree of this surface in the u and v parametric directions does not change. u1 can be greater than u2, and v1 can be greater than v2. in these cases, the corresponding parametric direction is inverted. the orientation of the surface is inverted if one (and only one) parametric direction is inverted.

        """
        return _Geom.Geom_BezierSurface_Segment(self, *args)

    def SetPole(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Modifies a pole value. if the surface is rational the weight of range (uindex, vindex) is not modified. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles.

        Parameters
        ----------
        UIndex: int
        VIndex: int
        P: gp_Pnt
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Substitutes the pole and the weight of range uindex, vindex. if the surface <self> is not rational it can become rational. if the surface was rational it can become non-rational. //! raises if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles. raised if weight <= resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_SetPole(self, *args)

    def SetPoleCol(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Modifies a column of poles. the length of cpoles can be lower but not greater than nbupoles so you can modify just a part of the column. raised if vindex < 1 or vindex > nbvpoles //! raised if cpoles.lower() < 1 or cpoles.upper() > nbupoles.

        Parameters
        ----------
        VIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Modifies a column of poles. if the surface was rational it can become non-rational if the surface was non-rational it can become rational. the length of cpoles can be lower but not greater than nbupoles so you can modify just a part of the column. raised if vindex < 1 or vindex > nbvpoles //! raised if cpoles.lower() < 1 or cpoles.upper() > nbupoles raised if cpoleweights and cpoles have not the same bounds. raised if one of the weight value cpoleweights (i) is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_SetPoleCol(self, *args)

    def SetPoleRow(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Modifies a row of poles. the length of cpoles can be lower but not greater than nbvpoles so you can modify just a part of the row. raised if uindex < 1 or uindex > nbupoles //! raised if cpoles.lower() < 1 or cpoles.upper() > nbvpoles.

        Parameters
        ----------
        UIndex: int
        CPoles: TColgp_Array1OfPnt
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Modifies a row of poles and weights. if the surface was rational it can become non-rational. if the surface was non-rational it can become rational. the length of cpoles can be lower but not greater than nbvpoles so you can modify just a part of the row. raised if uindex < 1 or uindex > nbupoles //! raised if cpoles.lower() < 1 or cpoles.upper() > nbvpoles raised if cpoleweights and cpoles have not the same bounds. raised if one of the weight value cpoleweights (i) is lower or equal to resolution from gp.

        """
        return _Geom.Geom_BezierSurface_SetPoleRow(self, *args)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int
        Weight: float

        Return
        -------
        None

        Description
        -----------
        Modifies the weight of the pole of range uindex, vindex. if the surface was non-rational it can become rational. if the surface was rational it can become non-rational. //! raised if uindex < 1 or uindex > nbupoles or vindex < 1 or vindex > nbvpoles. raised if weight <= resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_SetWeight(self, *args)

    def SetWeightCol(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Modifies a column of weights. if the surface was rational it can become non-rational. if the surface was non-rational it can become rational. the length of cpoleweights can be lower but not greater than nbupoles. raised if vindex < 1 or vindex > nbvpoles //! raised if cpoleweights.lower() < 1 or cpoleweights.upper() > nbupoles raised if one of the weight value cpoleweights (i) is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_SetWeightCol(self, *args)

    def SetWeightRow(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        CPoleWeights: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Modifies a row of weights. if the surface was rational it can become non-rational. if the surface was non-rational it can become rational. the length of cpoleweights can be lower but not greater than nbvpoles. raised if uindex < 1 or uindex > nbupoles //! raised if cpoleweights.lower() < 1 or cpoleweights.upper() > nbvpoles raised if one of the weight value cpoleweights (i) is lower or equal to resolution from package gp.

        """
        return _Geom.Geom_BezierSurface_SetWeightRow(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the surface in the u direction it is nbupoles - 1.

        """
        return _Geom.Geom_BezierSurface_UDegree(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree of the surface in the v direction it is nbvpoles - 1.

        """
        return _Geom.Geom_BezierSurface_VDegree(self, *args)

    def Weight(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the weight of range uindex, vindex //! raised if uindex < 1 or uindex > nbupoles, or vindex < 1 or vindex > nbvpoles.

        """
        return _Geom.Geom_BezierSurface_Weight(self, *args)

    def Weights(self, *args):
        r"""

        Parameters
        ----------
        W: TColStd_Array2OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the weights of the bezier surface. //! raised if the length of w in the u an v direction is not equal to nbupoles and nbvpoles.
        Return
        -------
        TColStd_Array2OfReal *

        Description
        -----------
        Returns the weights of the bezier surface.

        """
        return _Geom.Geom_BezierSurface_Weights(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_BezierSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_BezierSurface

# Register Geom_BezierSurface in _Geom:
_Geom.Geom_BezierSurface_swigregister(Geom_BezierSurface)
class Geom_Circle(Geom_Conic):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Constructs a circle by conversion of the gp_circ circle c.

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Constructs a circle of radius radius, where a2 locates the circle and defines its orientation in 3d space such that: - the center of the circle is the origin of a2, - the origin, 'x direction' and 'y direction' of a2 define the plane of the circle, - a2 is the local coordinate system of the circle. note: it is possible to create a circle where radius is equal to 0.0. raised if radius < 0.

        """
        _Geom.Geom_Circle_swiginit(self, _Geom.new_Geom_Circle(*args))

    def Circ(self, *args):
        r"""
        Return
        -------
        gp_Circ

        Description
        -----------
        Returns the non transient circle from gp with the same geometric properties as <self>.

        """
        return _Geom.Geom_Circle_Circ(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Circle_DumpJson(self, depth)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of this circle.

        """
        return _Geom.Geom_Circle_Radius(self, *args)

    def SetCirc(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Set <self> so that <self> has the same geometric properties as c.

        """
        return _Geom.Geom_Circle_SetCirc(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        None

        Description
        -----------
        Assigns the value r to the radius of this circle. note: it is possible to have a circle with a radius equal to 0.0. exceptions - standard_constructionerror if r is negative.

        """
        return _Geom.Geom_Circle_SetRadius(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Circle_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Circle

# Register Geom_Circle in _Geom:
_Geom.Geom_Circle_swigregister(Geom_Circle)
class Geom_ConicalSurface(Geom_ElementarySurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A3: gp_Ax3
        Ang: float
        Radius: float

        Return
        -------
        None

        Description
        -----------
        A3 defines the local coordinate system of the conical surface. ang is the conical surface semi-angle. its absolute value is in range ]0, pi/2[. radius is the radius of the circle viso in the placement plane of the conical surface defined with 'xaxis' and 'yaxis'. the 'zdirection' of a3 defines the direction of the surface's axis of symmetry. if the location point of a3 is the apex of the surface radius = 0 . at the creation the parametrization of the surface is defined such that the normal vector (n = d1u ^ d1v) is oriented towards the 'outside region' of the surface. //! raised if radius < 0.0 or abs(ang) < resolution from gp or abs(ang) >= pi/2 - resolution.

        Parameters
        ----------
        C: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Creates a conicalsurface from a non transient gp_cone.

        """
        _Geom.Geom_ConicalSurface_swiginit(self, _Geom.new_Geom_ConicalSurface(*args))

    def Apex(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the apex of this cone. it is on the negative side of the axis of revolution of this cone if the half-angle at the apex is positive, and on the positive side of the 'main axis' if the half-angle is negative.

        """
        return _Geom.Geom_ConicalSurface_Apex(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        Description
        -----------
        Returns the coefficients of the implicit equation of the quadric in the absolute cartesian coordinate system: these coefficients are normalized. @code a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0 @endcode.

        """
        return _Geom.Geom_ConicalSurface_Coefficients(self, *args)

    def Cone(self, *args):
        r"""
        Return
        -------
        gp_Cone

        Description
        -----------
        Returns a non transient cone with the same geometric properties as <self>.

        """
        return _Geom.Geom_ConicalSurface_Cone(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_ConicalSurface_DumpJson(self, depth)

    def RefRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the reference radius of this cone. the reference radius is the radius of the circle formed by the intersection of this cone and its reference plane (i.e. the plane defined by the origin, 'x direction' and 'y direction' of the local coordinate system of this cone). if the apex of this cone is on the origin of the local coordinate system of this cone, the returned value is 0.

        """
        return _Geom.Geom_ConicalSurface_RefRadius(self, *args)

    def SemiAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the semi-angle at the apex of this cone. attention! semi-angle can be negative.

        """
        return _Geom.Geom_ConicalSurface_SemiAngle(self, *args)

    def SetCone(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Set <self> so that <self> has the same geometric properties as c.

        """
        return _Geom.Geom_ConicalSurface_SetCone(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        None

        Description
        -----------
        Changes the radius of the conical surface in the placement plane (z = 0, v = 0). the local coordinate system is not modified. raised if r < 0.0.

        """
        return _Geom.Geom_ConicalSurface_SetRadius(self, *args)

    def SetSemiAngle(self, *args):
        r"""

        Parameters
        ----------
        Ang: float

        Return
        -------
        None

        Description
        -----------
        Changes the semi angle of the conical surface. semi-angle can be negative. its absolute value abs(ang) is in range ]0,pi/2[. raises constructionerror if abs(ang) < resolution from gp or abs(ang) >= pi/2 - resolution.

        """
        return _Geom.Geom_ConicalSurface_SetSemiAngle(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_ConicalSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_ConicalSurface

# Register Geom_ConicalSurface in _Geom:
_Geom.Geom_ConicalSurface_swigregister(Geom_ConicalSurface)
class Geom_CylindricalSurface(Geom_ElementarySurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A3: gp_Ax3
        Radius: float

        Return
        -------
        None

        Description
        -----------
        A3 defines the local coordinate system of the cylindrical surface. the 'zdirection' of a3 defines the direction of the surface's axis of symmetry. at the creation the parametrization of the surface is defined such that the normal vector (n = d1u ^ d1v) is oriented towards the 'outside region' of the surface. warnings: it is not forbidden to create a cylindrical surface with radius = 0.0 raised if radius < 0.0.

        Parameters
        ----------
        C: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Creates a cylindricalsurface from a non transient gp_cylinder.

        """
        _Geom.Geom_CylindricalSurface_swiginit(self, _Geom.new_Geom_CylindricalSurface(*args))

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        Description
        -----------
        Returns the coefficients of the implicit equation of the quadric in the absolute cartesian coordinate system: these coefficients are normalized. @code a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0 @endcode.

        """
        return _Geom.Geom_CylindricalSurface_Coefficients(self, *args)

    def Cylinder(self, *args):
        r"""
        Return
        -------
        gp_Cylinder

        Description
        -----------
        Returns a non transient cylinder with the same geometric properties as <self>.

        """
        return _Geom.Geom_CylindricalSurface_Cylinder(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_CylindricalSurface_DumpJson(self, depth)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of this cylinder.

        """
        return _Geom.Geom_CylindricalSurface_Radius(self, *args)

    def SetCylinder(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Set <self> so that <self> has the same geometric properties as c.

        """
        return _Geom.Geom_CylindricalSurface_SetCylinder(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        None

        Description
        -----------
        Changes the radius of the cylinder. raised if r < 0.0.

        """
        return _Geom.Geom_CylindricalSurface_SetRadius(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_CylindricalSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_CylindricalSurface

# Register Geom_CylindricalSurface in _Geom:
_Geom.Geom_CylindricalSurface_swigregister(Geom_CylindricalSurface)
class Geom_Ellipse(Geom_Conic):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        Constructs an ellipse by conversion of the gp_elips ellipse e.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Constructs an ellipse defined by its major and minor radii, majorradius and minorradius, where a2 locates the ellipse and defines its orientation in 3d space such that: - the center of the ellipse is the origin of a2, - the 'x direction' of a2 defines the major axis of the ellipse, i.e. the major radius majorradius is measured along this axis, - the 'y direction' of a2 defines the minor axis of the ellipse, i.e. the minor radius minorradius is measured along this axis, - a2 is the local coordinate system of the ellipse. exceptions standard_constructionerror if: - majorradius is less than minorradius, or - minorradius is less than 0. warning the geom package does not prevent the construction of an ellipse where majorradius and minorradius are equal.

        """
        _Geom.Geom_Ellipse_swiginit(self, _Geom.new_Geom_Ellipse(*args))

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This directrix is the line normal to the xaxis of the ellipse in the local plane (z = 0) at a distance d = majorradius / e from the center of the ellipse, where e is the eccentricity of the ellipse. this line is parallel to the 'yaxis'. the intersection point between directrix1 and the 'xaxis' is the 'location' point of the directrix1. this point is on the positive side of the 'xaxis'. raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        """
        return _Geom.Geom_Ellipse_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the ellipse. //! raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        """
        return _Geom.Geom_Ellipse_Directrix2(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Ellipse_DumpJson(self, depth)

    def Elips(self, *args):
        r"""
        Return
        -------
        gp_Elips

        Description
        -----------
        Returns the non transient ellipse from gp with the same.

        """
        return _Geom.Geom_Ellipse_Elips(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance. it is the distance between the the two focus of the ellipse.

        """
        return _Geom.Geom_Ellipse_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the first focus of the ellipse. this focus is on the positive side of the 'xaxis' of the ellipse.

        """
        return _Geom.Geom_Ellipse_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the second focus of the ellipse. this focus is on the negative side of the 'xaxis' of the ellipse.

        """
        return _Geom.Geom_Ellipse_Focus2(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of this ellipse.

        """
        return _Geom.Geom_Ellipse_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of this ellipse.

        """
        return _Geom.Geom_Ellipse_MinorRadius(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (1 - e * e) * majorradius where e is the eccentricity of the ellipse. returns 0 if majorradius = 0.

        """
        return _Geom.Geom_Ellipse_Parameter(self, *args)

    def SetElips(self, *args):
        r"""

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        Converts the gp_elips ellipse e into this ellipse.

        """
        return _Geom.Geom_Ellipse_SetElips(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        MajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns a value to the major radius of this ellipse. constructionerror raised if majorradius < minorradius.

        """
        return _Geom.Geom_Ellipse_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns a value to the minor radius of this ellipse. constructionerror raised if majorradius < minorradius or if minorradius < 0.

        """
        return _Geom.Geom_Ellipse_SetMinorRadius(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Ellipse_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Ellipse

# Register Geom_Ellipse in _Geom:
_Geom.Geom_Ellipse_swigregister(Geom_Ellipse)
class Geom_Hyperbola(Geom_Conic):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        Constructs a hyperbola by conversion of the gp_hypr hyperbola h.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Constructs a hyperbola defined by its major and minor radii, majorradius and minorradius, where a2 locates the hyperbola and defines its orientation in 3d space such that: - the center of the hyperbola is the origin of a2, - the 'x direction' of a2 defines the major axis of the hyperbola, i.e. the major radius majorradius is measured along this axis, - the 'y direction' of a2 defines the minor axis of the hyperbola, i.e. the minor radius minorradius is measured along this axis, - a2 is the local coordinate system of the hyperbola. exceptions standard_constructionerror if: - majorradius is less than 0.0, - minorradius is less than 0.0.

        """
        _Geom.Geom_Hyperbola_swiginit(self, _Geom.new_Geom_Hyperbola(*args))

    def Asymptote1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = (b/a)*x. raises constructionerror if majorradius = 0.0.

        """
        return _Geom.Geom_Hyperbola_Asymptote1(self, *args)

    def Asymptote2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = -(b/a)*x. raises constructionerror if majorradius = 0.0.

        """
        return _Geom.Geom_Hyperbola_Asymptote2(self, *args)

    def ConjugateBranch1(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        This branch of hyperbola is on the positive side of the yaxis of <self>.

        """
        return _Geom.Geom_Hyperbola_ConjugateBranch1(self, *args)

    def ConjugateBranch2(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        This branch of hyperbola is on the negative side of the yaxis of <self>. note: the diagram given under the class purpose indicates where these two branches of hyperbola are positioned in relation to this branch of hyperbola.

        """
        return _Geom.Geom_Hyperbola_ConjugateBranch2(self, *args)

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This directrix is the line normal to the xaxis of the hyperbola in the local plane (z = 0) at a distance d = majorradius / e from the center of the hyperbola, where e is the eccentricity of the hyperbola. this line is parallel to the yaxis. the intersection point between directrix1 and the xaxis is the location point of the directrix1. this point is on the positive side of the xaxis.

        """
        return _Geom.Geom_Hyperbola_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the yaxis of the hyperbola.

        """
        return _Geom.Geom_Hyperbola_Directrix2(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Hyperbola_DumpJson(self, depth)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance. it is the distance between the two focus of the hyperbola.

        """
        return _Geom.Geom_Hyperbola_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the first focus of the hyperbola. this focus is on the positive side of the xaxis of the hyperbola.

        """
        return _Geom.Geom_Hyperbola_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the second focus of the hyperbola. this focus is on the negative side of the xaxis of the hyperbola.

        """
        return _Geom.Geom_Hyperbola_Focus2(self, *args)

    def Hypr(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Returns the non transient parabola from gp with the same geometric properties as <self>.

        """
        return _Geom.Geom_Hyperbola_Hypr(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major or minor radius of this hyperbola. the major radius is also the distance between the center of the hyperbola and the apex of the main branch (located on the 'x axis' of the hyperbola).

        """
        return _Geom.Geom_Hyperbola_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major or minor radius of this hyperbola. the minor radius is also the distance between the center of the hyperbola and the apex of a conjugate branch (located on the 'y axis' of the hyperbola).

        """
        return _Geom.Geom_Hyperbola_MinorRadius(self, *args)

    def OtherBranch(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Computes the 'other' branch of this hyperbola. this is the symmetrical branch with respect to the center of this hyperbola. note: the diagram given under the class purpose indicates where the 'other' branch is positioned in relation to this branch of the hyperbola.

        """
        return _Geom.Geom_Hyperbola_OtherBranch(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (e * e - 1) * majorradius where e is the eccentricity of the hyperbola. raised if majorradius = 0.0.

        """
        return _Geom.Geom_Hyperbola_Parameter(self, *args)

    def SetHypr(self, *args):
        r"""

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        Converts the gp_hypr hyperbola h into this hyperbola.

        """
        return _Geom.Geom_Hyperbola_SetHypr(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        MajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns a value to the major radius of this hyperbola. exceptions standard_constructionerror if: - majorradius is less than 0.0, or - minorradius is less than 0.0.raised if majorradius < 0.0.

        """
        return _Geom.Geom_Hyperbola_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns a value to the minor radius of this hyperbola. exceptions standard_constructionerror if: - majorradius is less than 0.0, or - minorradius is less than 0.0.raised if majorradius < 0.0.

        """
        return _Geom.Geom_Hyperbola_SetMinorRadius(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Hyperbola_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Hyperbola

# Register Geom_Hyperbola in _Geom:
_Geom.Geom_Hyperbola_swigregister(Geom_Hyperbola)
class Geom_Parabola(Geom_Conic):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Prb: gp_Parab

        Return
        -------
        None

        Description
        -----------
        Creates a parabola from a non transient one.

        Parameters
        ----------
        A2: gp_Ax2
        Focal: float

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its local coordinate system 'a2' and it's focal length 'focal'. the xdirection of a2 defines the axis of symmetry of the parabola. the ydirection of a2 is parallel to the directrix of the parabola. the location point of a2 is the vertex of the parabola raised if focal < 0.0.

        Parameters
        ----------
        D: gp_Ax1
        F: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        D is the directrix of the parabola and f the focus point. the symmetry axis (xaxis) of the parabola is normal to the directrix and pass through the focus point f, but its location point is the vertex of the parabola. the yaxis of the parabola is parallel to d and its location point is the vertex of the parabola. the normal to the plane of the parabola is the cross product between the xaxis and the yaxis.

        """
        _Geom.Geom_Parabola_swiginit(self, _Geom.new_Geom_Parabola(*args))

    def Directrix(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes the directrix of this parabola. this is a line normal to the axis of symmetry, in the plane of this parabola, located on the negative side of its axis of symmetry, at a distance from the apex equal to the focal length. the directrix is returned as an axis (gp_ax1 object), where the origin is located on the 'x axis' of this parabola.

        """
        return _Geom.Geom_Parabola_Directrix(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Parabola_DumpJson(self, depth)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance of this parabola the focal distance is the distance between the apex and the focus of the parabola.

        """
        return _Geom.Geom_Parabola_Focal(self, *args)

    def Focus(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the focus of this parabola. the focus is on the positive side of the 'x axis' of the local coordinate system of the parabola.

        """
        return _Geom.Geom_Parabola_Focus(self, *args)

    def Parab(self, *args):
        r"""
        Return
        -------
        gp_Parab

        Description
        -----------
        Returns the non transient parabola from gp with the same geometric properties as <self>.

        """
        return _Geom.Geom_Parabola_Parab(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the parameter of this parabola which is the distance between its focus and its directrix. this distance is twice the focal length. if p is the parameter of the parabola, the equation of the parabola in its local coordinate system is: y**2 = 2.*p*x.

        """
        return _Geom.Geom_Parabola_Parameter(self, *args)

    def SetFocal(self, *args):
        r"""

        Parameters
        ----------
        Focal: float

        Return
        -------
        None

        Description
        -----------
        Assigns the value focal to the focal distance of this parabola. exceptions standard_constructionerror if focal is negative.

        """
        return _Geom.Geom_Parabola_SetFocal(self, *args)

    def SetParab(self, *args):
        r"""

        Parameters
        ----------
        Prb: gp_Parab

        Return
        -------
        None

        Description
        -----------
        Converts the gp_parab parabola prb into this parabola.

        """
        return _Geom.Geom_Parabola_SetParab(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Parabola_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Parabola

# Register Geom_Parabola in _Geom:
_Geom.Geom_Parabola_swigregister(Geom_Parabola)
class Geom_Plane(Geom_ElementarySurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Creates a plane located in 3d space with an axis placement three axis. the 'zdirection' of 'a3' is the direction normal to the plane. the 'location' point of 'a3' is the origin of the plane. the 'xdirection' and 'ydirection' of 'a3' define the directions of the u isoparametric and v isoparametric curves.

        Parameters
        ----------
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Creates a plane from a non transient plane from package gp.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        P is the 'location' point or origin of the plane. v is the direction normal to the plane.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float

        Return
        -------
        None

        Description
        -----------
        Creates a plane from its cartesian equation: @code ax + by + cz + d = 0.0 @endcode raised if sqrt (a*a + b*b + c*c) <= resolution from gp.

        """
        _Geom.Geom_Plane_swiginit(self, _Geom.new_Geom_Plane(*args))

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        A: float
        B: float
        C: float
        D: float

        Description
        -----------
        Computes the normalized coefficients of the plane's cartesian equation: @code ax + by + cz + d = 0.0 @endcode.

        """
        return _Geom.Geom_Plane_Coefficients(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_Plane_DumpJson(self, depth)

    def Pln(self, *args):
        r"""
        Return
        -------
        gp_Pln

        Description
        -----------
        Converts this plane into a gp_pln plane.

        """
        return _Geom.Geom_Plane_Pln(self, *args)

    def SetPln(self, *args):
        r"""

        Parameters
        ----------
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Set <self> so that <self> has the same geometric properties as pl.

        """
        return _Geom.Geom_Plane_SetPln(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_Plane_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_Plane

# Register Geom_Plane in _Geom:
_Geom.Geom_Plane_swigregister(Geom_Plane)
class Geom_RectangularTrimmedSurface(Geom_BoundedSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface
        U1: float
        U2: float
        V1: float
        V2: float
        USense: bool (optional, default to Standard_True)
        VSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The u parametric direction of the surface is oriented from u1 to u2. the v parametric direction of the surface is oriented from v1 to v2. these two directions define the orientation of the surface (normal). if the surface is not periodic usense and vsense are not used for the construction. if the surface s is periodic in one direction usense and vsense give the available part of the surface. by default in this case the surface has the same orientation as the basis surface s. the returned surface is not closed and not periodic. constructionerror raised if s is not periodic in the udirection and u1 or u2 are out of the bounds of s. s is not periodic in the vdirection and v1 or v2 are out of the bounds of s. u1 = u2 or v1 = v2.

        Parameters
        ----------
        S: Geom_Surface
        Param1: float
        Param2: float
        UTrim: bool
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The basis surface s is only trim in one parametric direction. if utrim = true the surface is trimmed in the u parametric direction else the surface is trimmed in the v parametric direction. in the considered parametric direction the resulting surface is oriented from param1 to param2. if s is periodic sense gives the available part of the surface. by default the trimmed surface has the same orientation as the basis surface s in the considered parametric direction (sense = true). if the basis surface s is closed or periodic in the parametric direction opposite to the trimming direction the trimmed surface has the same characteristics as the surface s in this direction. warnings: in this package the entities are not shared. the rectangulartrimmedsurface is built with a copy of the surface s. so when s is modified the rectangulartrimmedsurface is not modified raised if s is not periodic in the considered parametric direction and param1 or param2 are out of the bounds of s. param1 = param2.

        """
        _Geom.Geom_RectangularTrimmedSurface_swiginit(self, _Geom.new_Geom_RectangularTrimmedSurface(*args))

    def BasisSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Returns the basis surface of <self>.

        """
        return _Geom.Geom_RectangularTrimmedSurface_BasisSurface(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_RectangularTrimmedSurface_DumpJson(self, depth)

    def SetTrim(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        V1: float
        V2: float
        USense: bool (optional, default to Standard_True)
        VSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Modifies this patch by changing the trim values applied to the original surface the u parametric direction of this patch is oriented from u1 to u2. the v parametric direction of this patch is oriented from v1 to v2. usense and vsense are used for the construction only if the surface is periodic in the corresponding parametric direction, and define the available part of the surface; by default in this case, this patch has the same orientation as the basis surface. raised if the basissurface is not periodic in the udirection and u1 or u2 are out of the bounds of the basissurface. the basissurface is not periodic in the vdirection and v1 or v2 are out of the bounds of the basissurface. u1 = u2 or v1 = v2.

        Parameters
        ----------
        Param1: float
        Param2: float
        UTrim: bool
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Modifies this patch by changing the trim values applied to the original surface the basis surface is trimmed only in one parametric direction: if utrim is true, the surface is trimmed in the u parametric direction; if it is false, it is trimmed in the v parametric direction. in the 'trimmed' direction, this patch is oriented from param1 to param2. if the basis surface is periodic in the 'trimmed' direction, sense defines its available part. by default in this case, this patch has the same orientation as the basis surface in this parametric direction. if the basis surface is closed or periodic in the other parametric direction (i.e. not the 'trimmed' direction), this patch has the same characteristics as the basis surface in that parametric direction. raised if the basissurface is not periodic in the considered direction and param1 or param2 are out of the bounds of the basissurface. param1 = param2.

        """
        return _Geom.Geom_RectangularTrimmedSurface_SetTrim(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_RectangularTrimmedSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_RectangularTrimmedSurface

# Register Geom_RectangularTrimmedSurface in _Geom:
_Geom.Geom_RectangularTrimmedSurface_swigregister(Geom_RectangularTrimmedSurface)
class Geom_SphericalSurface(Geom_ElementarySurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A3: gp_Ax3
        Radius: float

        Return
        -------
        None

        Description
        -----------
        A3 is the local coordinate system of the surface. at the creation the parametrization of the surface is defined such as the normal vector (n = d1u ^ d1v) is directed away from the center of the sphere. the direction of increasing parametric value v is defined by the rotation around the 'ydirection' of a2 in the trigonometric sense and the orientation of increasing parametric value u is defined by the rotation around the main direction of a2 in the trigonometric sense. warnings: it is not forbidden to create a spherical surface with radius = 0.0 raised if radius < 0.0.

        Parameters
        ----------
        S: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Creates a sphericalsurface from a non persistent sphere from package gp.

        """
        _Geom.Geom_SphericalSurface_swiginit(self, _Geom.new_Geom_SphericalSurface(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the aera of the spherical surface.

        """
        return _Geom.Geom_SphericalSurface_Area(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        Description
        -----------
        Returns the coefficients of the implicit equation of the quadric in the absolute cartesian coordinates system: these coefficients are normalized. a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0.

        """
        return _Geom.Geom_SphericalSurface_Coefficients(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_SphericalSurface_DumpJson(self, depth)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the coefficients of the implicit equation of this quadric in the absolute cartesian coordinate system: a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0 an implicit normalization is applied (i.e. a1 = a2 = 1. in the local coordinate system of this sphere).

        """
        return _Geom.Geom_SphericalSurface_Radius(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        None

        Description
        -----------
        Assigns the value r to the radius of this sphere. exceptions standard_constructionerror if r is less than 0.0.

        """
        return _Geom.Geom_SphericalSurface_SetRadius(self, *args)

    def SetSphere(self, *args):
        r"""

        Parameters
        ----------
        S: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Converts the gp_sphere s into this sphere.

        """
        return _Geom.Geom_SphericalSurface_SetSphere(self, *args)

    def Sphere(self, *args):
        r"""
        Return
        -------
        gp_Sphere

        Description
        -----------
        Returns a non persistent sphere with the same geometric properties as <self>.

        """
        return _Geom.Geom_SphericalSurface_Sphere(self, *args)

    def Volume(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the volume of the spherical surface.

        """
        return _Geom.Geom_SphericalSurface_Volume(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_SphericalSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_SphericalSurface

# Register Geom_SphericalSurface in _Geom:
_Geom.Geom_SphericalSurface_swigregister(Geom_SphericalSurface)
class Geom_SurfaceOfLinearExtrusion(Geom_SweptSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        V is the direction of extrusion. c is the extruded curve. the form of a surfaceoflinearextrusion can be: . ruled surface (ruledform), . a cylindrical surface if the extruded curve is a circle or a trimmed circle (cylindricalform), . a plane surface if the extruded curve is a line (planarform). warnings: degenerated surface cases are not detected. for example if the curve c is a line and v is parallel to the direction of this line.

        """
        _Geom.Geom_SurfaceOfLinearExtrusion_swiginit(self, _Geom.new_Geom_SurfaceOfLinearExtrusion(*args))

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_SurfaceOfLinearExtrusion_DumpJson(self, depth)

    def SetBasisCurve(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        Modifies this surface of linear extrusion by redefining its 'basis curve' (the 'extruded curve').

        """
        return _Geom.Geom_SurfaceOfLinearExtrusion_SetBasisCurve(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Assigns v as the 'direction of extrusion' for this surface of linear extrusion.

        """
        return _Geom.Geom_SurfaceOfLinearExtrusion_SetDirection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_SurfaceOfLinearExtrusion_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_SurfaceOfLinearExtrusion

# Register Geom_SurfaceOfLinearExtrusion in _Geom:
_Geom.Geom_SurfaceOfLinearExtrusion_swigregister(Geom_SurfaceOfLinearExtrusion)
class Geom_SurfaceOfRevolution(Geom_SweptSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        C: is the meridian or the referenced curve. a1 is the axis of revolution. the form of a surfaceofrevolution can be: . a general revolution surface (revolutionform), . a conical surface if the meridian is a line or a trimmed line (conicalform), . a cylindrical surface if the meridian is a line or a trimmed line parallel to the revolution axis (cylindricalform), . a planar surface if the meridian is a line perpendicular to the revolution axis of the surface (planarform). . a spherical surface, . a toroidal surface, . a quadric surface. warnings: it is not checked that the curve c is planar and that the surface axis is in the plane of the curve. it is not checked that the revolved curve c doesn't self-intersects.

        """
        _Geom.Geom_SurfaceOfRevolution_swiginit(self, _Geom.new_Geom_SurfaceOfRevolution(*args))

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the revolution axis of the surface.

        """
        return _Geom.Geom_SurfaceOfRevolution_Axis(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_SurfaceOfRevolution_DumpJson(self, depth)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point of the axis of revolution.

        """
        return _Geom.Geom_SurfaceOfRevolution_Location(self, *args)

    def ReferencePlane(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Computes the position of the reference plane of the surface defined by the basis curve and the symmetry axis. the location point is the location point of the revolution's axis, the xdirection of the plane is given by the revolution's axis and the orientation of the normal to the plane is given by the sense of revolution. //! raised if the revolved curve is not planar or if the revolved curve and the symmetry axis are not in the same plane or if the maximum of distance between the axis and the revolved curve is lower or equal to resolution from gp.

        """
        return _Geom.Geom_SurfaceOfRevolution_ReferencePlane(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the axis of revolution. warnings: it is not checked that the axis is in the plane of the revolved curve.

        """
        return _Geom.Geom_SurfaceOfRevolution_SetAxis(self, *args)

    def SetBasisCurve(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        Changes the revolved curve of the surface. warnings: it is not checked that the curve c is planar and that the surface axis is in the plane of the curve. it is not checked that the revolved curve c doesn't self-intersects.

        """
        return _Geom.Geom_SurfaceOfRevolution_SetBasisCurve(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the direction of the revolution axis. warnings: it is not checked that the axis is in the plane of the revolved curve.

        """
        return _Geom.Geom_SurfaceOfRevolution_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location point of the revolution axis. warnings: it is not checked that the axis is in the plane of the revolved curve.

        """
        return _Geom.Geom_SurfaceOfRevolution_SetLocation(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_SurfaceOfRevolution_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_SurfaceOfRevolution

# Register Geom_SurfaceOfRevolution in _Geom:
_Geom.Geom_SurfaceOfRevolution_swigregister(Geom_SurfaceOfRevolution)
class Geom_ToroidalSurface(Geom_ElementarySurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A3: gp_Ax3
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        A3 is the local coordinate system of the surface. the orientation of increasing v parametric value is defined by the rotation around the main axis (zaxis) in the trigonometric sense. the parametrization of the surface in the u direction is defined such as the normal vector (n = d1u ^ d1v) is oriented towards the 'outside region' of the surface. warnings: it is not forbidden to create a toroidal surface with majorradius = minorradius = 0.0 //! raised if minorradius < 0.0 or if majorradius < 0.0.

        Parameters
        ----------
        T: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Creates a toroidalsurface from a non transient torus from package gp.

        """
        _Geom.Geom_ToroidalSurface_swiginit(self, _Geom.new_Geom_ToroidalSurface(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the aera of the surface.

        """
        return _Geom.Geom_ToroidalSurface_Area(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------
        Coef: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns the coefficients of the implicit equation of the surface in the absolute cartesian coordinate system: coef(1) * x**4 + coef(2) * y**4 + coef(3) * z**4 + coef(4) * x**3 * y + coef(5) * x**3 * z + coef(6) * y**3 * x + coef(7) * y**3 * z + coef(8) * z**3 * x + coef(9) * z**3 * y + coef(10) * x**2 * y**2 + coef(11) * x**2 * z**2 + coef(12) * y**2 * z**2 + coef(13) * x**3 + coef(14) * y**3 + coef(15) * z**3 + coef(16) * x**2 * y + coef(17) * x**2 * z + coef(18) * y**2 * x + coef(19) * y**2 * z + coef(20) * z**2 * x + coef(21) * z**2 * y + coef(22) * x**2 + coef(23) * y**2 + coef(24) * z**2 + coef(25) * x * y + coef(26) * x * z + coef(27) * y * z + coef(28) * x + coef(29) * y + coef(30) * z + coef(31) = 0.0 raised if the length of coef is lower than 31.

        """
        return _Geom.Geom_ToroidalSurface_Coefficients(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_ToroidalSurface_DumpJson(self, depth)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius, or the minor radius, of this torus.

        """
        return _Geom.Geom_ToroidalSurface_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius, or the minor radius, of this torus.

        """
        return _Geom.Geom_ToroidalSurface_MinorRadius(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        MajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies this torus by changing its major radius. exceptions standard_constructionerror if: - majorradius is negative, or - majorradius - r is less than or equal to gp::resolution(), where r is the minor radius of this torus.

        """
        return _Geom.Geom_ToroidalSurface_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies this torus by changing its minor radius. exceptions standard_constructionerror if: - minorradius is negative, or - r - minorradius is less than or equal to gp::resolution(), where r is the major radius of this torus.

        """
        return _Geom.Geom_ToroidalSurface_SetMinorRadius(self, *args)

    def SetTorus(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Converts the gp_torus torus t into this torus.

        """
        return _Geom.Geom_ToroidalSurface_SetTorus(self, *args)

    def Torus(self, *args):
        r"""
        Return
        -------
        gp_Torus

        Description
        -----------
        Returns the non transient torus with the same geometric properties as <self>.

        """
        return _Geom.Geom_ToroidalSurface_Torus(self, *args)

    def Volume(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the volume.

        """
        return _Geom.Geom_ToroidalSurface_Volume(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_ToroidalSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_ToroidalSurface

# Register Geom_ToroidalSurface in _Geom:
_Geom.Geom_ToroidalSurface_swigregister(Geom_ToroidalSurface)
class Geom_TrimmedCurve(Geom_BoundedCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        U1: float
        U2: float
        Sense: bool (optional, default to Standard_True)
        theAdjustPeriodic: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Constructs a trimmed curve from the basis curve c which is limited between parameter values u1 and u2. note: - u1 can be greater or less than u2; in both cases, the returned curve is oriented from u1 to u2. - if the basis curve c is periodic, there is an ambiguity because two parts are available. in this case, the trimmed curve has the same orientation as the basis curve if sense is true (default value) or the opposite orientation if sense is false. - if the curve is closed but not periodic, it is not possible to keep the part of the curve which includes the junction point (except if the junction point is at the beginning or at the end of the trimmed curve). if you tried to do this, you could alter the fundamental characteristics of the basis curve, which are used, for example, to compute the derivatives of the trimmed curve. the rules for a closed curve are therefore the same as those for an open curve. warning: the trimmed curve is built from a copy of curve c. therefore, when c is modified, the trimmed curve is not modified. - if the basis curve is periodic and theadjustperiodic is true, the bounds of the trimmed curve may be different from u1 and u2 if the parametric origin of the basis curve is within the arc of the trimmed curve. in this case, the modified parameter will be equal to u1 or u2 plus or minus the period. when theadjustperiodic is false, parameters u1 and u2 will be the same, without adjustment into the first period. exceptions standard_constructionerror if: - c is not periodic and u1 or u2 is outside the bounds of c, or - u1 is equal to u2.

        """
        _Geom.Geom_TrimmedCurve_swiginit(self, _Geom.new_Geom_TrimmedCurve(*args))

    def BasisCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Returns the basis curve. warning this function does not return a constant reference. consequently, any modification of the returned value directly modifies the trimmed curve.

        """
        return _Geom.Geom_TrimmedCurve_BasisCurve(self, *args)

    def DumpJson(self, depth=-1):
        r"""

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        Parameters
        ----------
        depth: int, default=-1

        Return
        -------
        str

        Description
        -----------
        Dump the object to JSON string.

        """
        return _Geom.Geom_TrimmedCurve_DumpJson(self, depth)

    def SetTrim(self, *args):
        r"""

        Parameters
        ----------
        U1: float
        U2: float
        Sense: bool (optional, default to Standard_True)
        theAdjustPeriodic: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Changes this trimmed curve, by redefining the parameter values u1 and u2 which limit its basis curve. note: if the basis curve is periodic, the trimmed curve has the same orientation as the basis curve if sense is true (default value) or the opposite orientation if sense is false. warning if the basis curve is periodic and theadjustperiodic is true, the bounds of the trimmed curve may be different from u1 and u2 if the parametric origin of the basis curve is within the arc of the trimmed curve. in this case, the modified parameter will be equal to u1 or u2 plus or minus the period. when theadjustperiodic is false, parameters u1 and u2 will be the same, without adjustment into the first period. exceptions standard_constructionerror if: - the basis curve is not periodic, and either u1 or u2 are outside the bounds of the basis curve, or - u1 is equal to u2.

        """
        return _Geom.Geom_TrimmedCurve_SetTrim(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_TrimmedCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Geom.delete_Geom_TrimmedCurve

# Register Geom_TrimmedCurve in _Geom:
_Geom.Geom_TrimmedCurve_swigregister(Geom_TrimmedCurve)
class Geom_HSequenceOfBSplineSurface(Geom_SequenceOfBSplineSurface, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Geom.Geom_HSequenceOfBSplineSurface_swiginit(self, _Geom.new_Geom_HSequenceOfBSplineSurface(*args))

    def Sequence(self):
        return _Geom.Geom_HSequenceOfBSplineSurface_Sequence(self)

    def Append(self, *args):
        return _Geom.Geom_HSequenceOfBSplineSurface_Append(self, *args)

    def ChangeSequence(self):
        return _Geom.Geom_HSequenceOfBSplineSurface_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_Geom_HSequenceOfBSplineSurface_DownCast(t)

    __swig_destroy__ = _Geom.delete_Geom_HSequenceOfBSplineSurface

# Register Geom_HSequenceOfBSplineSurface in _Geom:
_Geom.Geom_HSequenceOfBSplineSurface_swigregister(Geom_HSequenceOfBSplineSurface)



@deprecated
def Geom_BSplineCurve_MaxDegree(*args):
	return Geom_BSplineCurve.MaxDegree(*args)

@deprecated
def Geom_BSplineSurface_MaxDegree(*args):
	return Geom_BSplineSurface.MaxDegree(*args)

@deprecated
def Geom_BezierCurve_MaxDegree(*args):
	return Geom_BezierCurve.MaxDegree(*args)

@deprecated
def Geom_BezierSurface_MaxDegree(*args):
	return Geom_BezierSurface.MaxDegree(*args)



