# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Geom2dAPI module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_geom2dapi.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Geom2dAPI
else:
    import _Geom2dAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Geom2dAPI.delete_SwigPyIterator

    def value(self):
        return _Geom2dAPI.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Geom2dAPI.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Geom2dAPI.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Geom2dAPI.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Geom2dAPI.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Geom2dAPI.SwigPyIterator_copy(self)

    def next(self):
        return _Geom2dAPI.SwigPyIterator_next(self)

    def __next__(self):
        return _Geom2dAPI.SwigPyIterator___next__(self)

    def previous(self):
        return _Geom2dAPI.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Geom2dAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Geom2dAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Geom2dAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Geom2dAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Geom2dAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Geom2dAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Geom2dAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Geom2dAPI:
_Geom2dAPI.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Geom2dAPI.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Geom2dAPI.ios_base_erase_event
    imbue_event = _Geom2dAPI.ios_base_imbue_event
    copyfmt_event = _Geom2dAPI.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Geom2dAPI.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Geom2dAPI.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Geom2dAPI.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Geom2dAPI.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Geom2dAPI.ios_base_precision(self, *args)

    def width(self, *args):
        return _Geom2dAPI.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Geom2dAPI.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Geom2dAPI.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Geom2dAPI.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Geom2dAPI.ios_base_xalloc()

    def iword(self, __ix):
        return _Geom2dAPI.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Geom2dAPI.ios_base_pword(self, __ix)
    __swig_destroy__ = _Geom2dAPI.delete_ios_base

# Register ios_base in _Geom2dAPI:
_Geom2dAPI.ios_base_swigregister(ios_base)
cvar = _Geom2dAPI.cvar
ios_base.boolalpha = _Geom2dAPI.cvar.ios_base_boolalpha
ios_base.dec = _Geom2dAPI.cvar.ios_base_dec
ios_base.fixed = _Geom2dAPI.cvar.ios_base_fixed
ios_base.hex = _Geom2dAPI.cvar.ios_base_hex
ios_base.internal = _Geom2dAPI.cvar.ios_base_internal
ios_base.left = _Geom2dAPI.cvar.ios_base_left
ios_base.oct = _Geom2dAPI.cvar.ios_base_oct
ios_base.right = _Geom2dAPI.cvar.ios_base_right
ios_base.scientific = _Geom2dAPI.cvar.ios_base_scientific
ios_base.showbase = _Geom2dAPI.cvar.ios_base_showbase
ios_base.showpoint = _Geom2dAPI.cvar.ios_base_showpoint
ios_base.showpos = _Geom2dAPI.cvar.ios_base_showpos
ios_base.skipws = _Geom2dAPI.cvar.ios_base_skipws
ios_base.unitbuf = _Geom2dAPI.cvar.ios_base_unitbuf
ios_base.uppercase = _Geom2dAPI.cvar.ios_base_uppercase
ios_base.adjustfield = _Geom2dAPI.cvar.ios_base_adjustfield
ios_base.basefield = _Geom2dAPI.cvar.ios_base_basefield
ios_base.floatfield = _Geom2dAPI.cvar.ios_base_floatfield
ios_base.badbit = _Geom2dAPI.cvar.ios_base_badbit
ios_base.eofbit = _Geom2dAPI.cvar.ios_base_eofbit
ios_base.failbit = _Geom2dAPI.cvar.ios_base_failbit
ios_base.goodbit = _Geom2dAPI.cvar.ios_base_goodbit
ios_base.app = _Geom2dAPI.cvar.ios_base_app
ios_base.ate = _Geom2dAPI.cvar.ios_base_ate
ios_base.binary = _Geom2dAPI.cvar.ios_base_binary
ios_base.ios_base_in = _Geom2dAPI.cvar.ios_base_ios_base_in
ios_base.out = _Geom2dAPI.cvar.ios_base_out
ios_base.trunc = _Geom2dAPI.cvar.ios_base_trunc
ios_base.beg = _Geom2dAPI.cvar.ios_base_beg
ios_base.cur = _Geom2dAPI.cvar.ios_base_cur
ios_base.end = _Geom2dAPI.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Geom2dAPI.ios_rdstate(self)

    def clear(self, *args):
        return _Geom2dAPI.ios_clear(self, *args)

    def setstate(self, __state):
        return _Geom2dAPI.ios_setstate(self, __state)

    def good(self):
        return _Geom2dAPI.ios_good(self)

    def eof(self):
        return _Geom2dAPI.ios_eof(self)

    def fail(self):
        return _Geom2dAPI.ios_fail(self)

    def bad(self):
        return _Geom2dAPI.ios_bad(self)

    def exceptions(self, *args):
        return _Geom2dAPI.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Geom2dAPI.ios_swiginit(self, _Geom2dAPI.new_ios(__sb))
    __swig_destroy__ = _Geom2dAPI.delete_ios

    def tie(self, *args):
        return _Geom2dAPI.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Geom2dAPI.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Geom2dAPI.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Geom2dAPI.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Geom2dAPI.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Geom2dAPI.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Geom2dAPI.ios_widen(self, __c)

# Register ios in _Geom2dAPI:
_Geom2dAPI.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom2dAPI.ostream_swiginit(self, _Geom2dAPI.new_ostream(__sb))
    __swig_destroy__ = _Geom2dAPI.delete_ostream

    def __lshift__(self, *args):
        return _Geom2dAPI.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Geom2dAPI.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Geom2dAPI.ostream_write(self, __s, __n)

    def flush(self):
        return _Geom2dAPI.ostream_flush(self)

    def tellp(self):
        return _Geom2dAPI.ostream_tellp(self)

    def seekp(self, *args):
        return _Geom2dAPI.ostream_seekp(self, *args)

# Register ostream in _Geom2dAPI:
_Geom2dAPI.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom2dAPI.istream_swiginit(self, _Geom2dAPI.new_istream(__sb))
    __swig_destroy__ = _Geom2dAPI.delete_istream

    def __rshift__(self, *args):
        return _Geom2dAPI.istream___rshift__(self, *args)

    def gcount(self):
        return _Geom2dAPI.istream_gcount(self)

    def get(self, *args):
        return _Geom2dAPI.istream_get(self, *args)

    def getline(self, *args):
        return _Geom2dAPI.istream_getline(self, *args)

    def ignore(self, *args):
        return _Geom2dAPI.istream_ignore(self, *args)

    def peek(self):
        return _Geom2dAPI.istream_peek(self)

    def read(self, __s, __n):
        return _Geom2dAPI.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Geom2dAPI.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Geom2dAPI.istream_putback(self, __c)

    def unget(self):
        return _Geom2dAPI.istream_unget(self)

    def sync(self):
        return _Geom2dAPI.istream_sync(self)

    def tellg(self):
        return _Geom2dAPI.istream_tellg(self)

    def seekg(self, *args):
        return _Geom2dAPI.istream_seekg(self, *args)

# Register istream in _Geom2dAPI:
_Geom2dAPI.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Geom2dAPI.iostream_swiginit(self, _Geom2dAPI.new_iostream(__sb))
    __swig_destroy__ = _Geom2dAPI.delete_iostream

# Register iostream in _Geom2dAPI:
_Geom2dAPI.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Geom2dAPI.endl_cb_ptr
endl = _Geom2dAPI.endl
ends_cb_ptr = _Geom2dAPI.ends_cb_ptr
ends = _Geom2dAPI.ends
flush_cb_ptr = _Geom2dAPI.flush_cb_ptr
flush = _Geom2dAPI.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom2d
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Extrema
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dInt
import OCC.Core.IntRes2d
import OCC.Core.IntCurve
import OCC.Core.Intf
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves

from enum import IntEnum
from OCC.Core.Exception import *



class Geom2dAPI_ExtremaCurveCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C1: Geom2d_Curve
        C2: Geom2d_Curve
        U1min: float
        U1max: float
        U2min: float
        U2max: float

        Return
        -------
        None

        Description
        -----------
        Computes the extrema between - the portion of the curve c1 limited by the two points of parameter (u1min,u1max), and - the portion of the curve c2 limited by the two points of parameter (u2min,u2max). warning use the function nbextrema to obtain the number of solutions. if this algorithm fails, nbextrema returns 0.

        """
        _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_swiginit(self, _Geom2dAPI.new_Geom2dAPI_ExtremaCurveCurve(*args))

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Computes the distance between the end points of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_Distance(self, *args)

    def Extrema(self, *args):
        r"""
        Return
        -------
        Extrema_ExtCC2d

        Description
        -----------
        No available documentation.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_Extrema(self, *args)

    def LowerDistance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the distance between the end points of the shortest extremum computed by this algorithm. exceptions - stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_LowerDistance(self, *args)

    def LowerDistanceParameters(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        U1: float
        U2: float

        Description
        -----------
        Returns the parameters u1 of the point on the first curve and u2 of the point on the second curve, which are the ends of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_LowerDistanceParameters(self, *args)

    def NbExtrema(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of extrema computed by this algorithm. note: if this algorithm fails, nbextrema returns 0.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_NbExtrema(self, *args)

    def NearestPoints(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Returns the points p1 on the first curve and p2 on the second curve, which are the ends of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_NearestPoints(self, *args)

    def Parameters(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        U1: float
        U2: float

        Description
        -----------
        Returns the parameters u1 of the point on the first curve and u2 of the point on the second curve, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_Parameters(self, *args)

    def Points(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Returns the points p1 on the first curve and p2 on the second curve, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        """
        return _Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_Points(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Geom2dAPI.delete_Geom2dAPI_ExtremaCurveCurve

# Register Geom2dAPI_ExtremaCurveCurve in _Geom2dAPI:
_Geom2dAPI.Geom2dAPI_ExtremaCurveCurve_swigregister(Geom2dAPI_ExtremaCurveCurve)
class Geom2dAPI_InterCurveCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Create an empty intersector. use the function init for further initialization of the intersection algorithm by curves or curve.

        Parameters
        ----------
        C1: Geom2d_Curve
        C2: Geom2d_Curve
        Tol: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Creates an object and computes the intersections between the curves c1 and c2.

        Parameters
        ----------
        C1: Geom2d_Curve
        Tol: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Creates an object and computes self-intersections of the curve c1. tolerance value tol, defaulted to 1.0e-6, defines the precision of computing the intersection points. in case of a tangential intersection, tol also defines the size of intersection segments (limited portions of the curves) where the distance between all points from two curves (or a curve in case of self-intersection) is less than tol. warning use functions nbpoints and nbsegments to obtain the number of solutions. if the algorithm finds no intersections nbpoints and nbsegments return 0.

        """
        _Geom2dAPI.Geom2dAPI_InterCurveCurve_swiginit(self, _Geom2dAPI.new_Geom2dAPI_InterCurveCurve(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C1: Geom2d_Curve
        C2: Geom2d_Curve
        Tol: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm with the given arguments and computes the intersections between the curves c1. and c2.

        Parameters
        ----------
        C1: Geom2d_Curve
        Tol: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Initializes an algorithm with the given arguments and computes the self-intersections of the curve c1. tolerance value tol, defaulted to 1.0e-6, defines the precision of computing the intersection points. in case of a tangential intersection, tol also defines the size of intersection segments (limited portions of the curves) where the distance between all points from two curves (or a curve in case of self-intersection) is less than tol. warning use functions nbpoints and nbsegments to obtain the number of solutions. if the algorithm finds no intersections nbpoints and nbsegments return 0.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_Init(self, *args)

    def Intersector(self, *args):
        r"""
        Return
        -------
        Geom2dInt_GInter

        Description
        -----------
        Return the algorithmic object from intersection.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_Intersector(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of intersection-points in case of cross intersections. nbpoints returns 0 if no intersections were found.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_NbPoints(self, *args)

    def NbSegments(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of tangential intersections. nbsegments returns 0 if no intersections were found.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_NbSegments(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the intersection point of index index. intersection points are computed in case of cross intersections with a precision equal to the tolerance value assigned at the time of construction or in the function init (this value is defaulted to 1.0e-6). exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of computed intersection points.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_Point(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Curve1: Geom2d_Curve
        Curve2: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Use this syntax only to get solutions of tangential intersection between two curves. output values curve1 and curve2 are the intersection segments on the first curve and on the second curve accordingly. parameter index defines a number of computed solution. an intersection segment is a portion of an initial curve limited by two points. the distance from each point of this segment to the other curve is less or equal to the tolerance value assigned at the time of construction or in function init (this value is defaulted to 1.0e-6). exceptions standard_outofrange if index is not in the range [ 1,nbsegments ], where nbsegments is the number of computed tangential intersections. standard_nullobject if the algorithm is initialized for the computing of self-intersections on a curve.

        """
        return _Geom2dAPI.Geom2dAPI_InterCurveCurve_Segment(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Geom2dAPI.delete_Geom2dAPI_InterCurveCurve

# Register Geom2dAPI_InterCurveCurve in _Geom2dAPI:
_Geom2dAPI.Geom2dAPI_InterCurveCurve_swigregister(Geom2dAPI_InterCurveCurve)
class Geom2dAPI_Interpolate(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Points: TColgp_HArray1OfPnt2d
        PeriodicFlag: bool
        Tolerance: float

        Return
        -------
        None

        Description
        -----------
        Tolerance is to check if the points are not too close to one an other it is also used to check if the tangent vector is not too small. there should be at least 2 points if periodicflag is true then the curve will be periodic.

        Parameters
        ----------
        Points: TColgp_HArray1OfPnt2d
        Parameters: TColStd_HArray1OfReal
        PeriodicFlag: bool
        Tolerance: float

        Return
        -------
        None

        Description
        -----------
        If periodicflag is true then the curve will be periodic warning: there should be as many parameters as there are points except if periodicflag is true: then there should be one more parameter to close the curve.

        """
        _Geom2dAPI.Geom2dAPI_Interpolate_swiginit(self, _Geom2dAPI.new_Geom2dAPI_Interpolate(*args))

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns the computed bspline curve. raises stdfail_notdone if the interpolation fails.

        """
        return _Geom2dAPI.Geom2dAPI_Interpolate_Curve(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the constrained bspline curve is successfully constructed. note: in this case, the result is given by the function curve.

        """
        return _Geom2dAPI.Geom2dAPI_Interpolate_IsDone(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        InitialTangent: gp_Vec2d
        FinalTangent: gp_Vec2d
        Scale: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Assigns this constrained bspline curve to be tangential to vectors initialtangent and finaltangent at its first and last points respectively (i.e. the first and last points of the table of points through which the curve passes, as defined at the time of initialization). <scale> - boolean flag defining whether tangent vectors are to be scaled according to derivatives of lagrange interpolation.

        Parameters
        ----------
        Tangents: TColgp_Array1OfVec2d
        TangentFlags: TColStd_HArray1OfBoolean
        Scale: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Assigns this constrained bspline curve to be tangential to vectors defined in the table tangents, which is parallel to the table of points through which the curve passes, as defined at the time of initialization. vectors in the table tangents are defined only if the flag given in the parallel table tangentflags is true: only these vectors are set as tangency constraints. <scale> - boolean flag defining whether tangent vectors are to be scaled according to derivatives of lagrange interpolation.

        """
        return _Geom2dAPI.Geom2dAPI_Interpolate_Load(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes the constrained bspline curve. use the function isdone to verify that the computation is successful, and then the function curve to obtain the result.

        """
        return _Geom2dAPI.Geom2dAPI_Interpolate_Perform(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ClearTangents(self):
    	pass

    __swig_destroy__ = _Geom2dAPI.delete_Geom2dAPI_Interpolate

# Register Geom2dAPI_Interpolate in _Geom2dAPI:
_Geom2dAPI.Geom2dAPI_Interpolate_swigregister(Geom2dAPI_Interpolate)
class Geom2dAPI_PointsToBSpline(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty approximation algorithm. use an init function to define and build the bspline curve.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        YValues: TColStd_Array1OfReal
        X0: float
        DX: float
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. of coordinates: //! x = x0 + dx * (i-yvalues.lower()) y = yvalues(i) //! with i in the range yvalues.lower(), yvalues.upper() //! the bspline will be parametrized from t = x0 to x0 + dx * (yvalues.upper() - yvalues.lower()) //! and will satisfy x(t) = t //! the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        ParType: Approx_ParametrizationType
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        Parameters: TColStd_Array1OfReal
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point, which parameters are given by the array <parameters>. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol3D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point using variational smoothing algorithm, which tries to minimize additional criterium: weight1*curvelength + weight2*curvature + weight3*torsion.

        """
        _Geom2dAPI.Geom2dAPI_PointsToBSpline_swiginit(self, _Geom2dAPI.new_Geom2dAPI_PointsToBSpline(*args))

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns the approximate bspline curve.

        """
        return _Geom2dAPI.Geom2dAPI_PointsToBSpline_Curve(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        YValues: TColStd_Array1OfReal
        X0: float
        DX: float
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-6)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. of coordinates: //! x = x0 + dx * (i-yvalues.lower()) y = yvalues(i) //! with i in the range yvalues.lower(), yvalues.upper() //! the bspline will be parametrized from t = x0 to x0 + dx * (yvalues.upper() - yvalues.lower()) //! and will satisfy x(t) = t //! the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        ParType: Approx_ParametrizationType
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        Parameters: TColStd_Array1OfReal
        DegMin: int (optional, default to 3)
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point, which parameters are given by the array <parameters>. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol2d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt2d
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int (optional, default to 8)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        Tol2D: float (optional, default to 1.0e-3)

        Return
        -------
        None

        Description
        -----------
        Approximate a bspline curve passing through an array of point using variational smoothing algorithm, which tries to minimize additional criterium: weight1*curvelength + weight2*curvature + weight3*torsion.

        """
        return _Geom2dAPI.Geom2dAPI_PointsToBSpline_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Geom2dAPI.Geom2dAPI_PointsToBSpline_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Geom2dAPI.delete_Geom2dAPI_PointsToBSpline

# Register Geom2dAPI_PointsToBSpline in _Geom2dAPI:
_Geom2dAPI.Geom2dAPI_PointsToBSpline_swigregister(Geom2dAPI_PointsToBSpline)
class Geom2dAPI_ProjectPointOnCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty projector algorithm. use an init function to define the point and the curve on which it is going to work.

        Parameters
        ----------
        P: gp_Pnt2d
        Curve: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Create the projection of a point <p> on a curve <curve>.

        Parameters
        ----------
        P: gp_Pnt2d
        Curve: Geom2d_Curve
        Umin: float
        Usup: float

        Return
        -------
        None

        Description
        -----------
        Create the projection of a point <p> on a curve <curve> limited by the two points of parameter umin and usup. warning use the function nbpoints to obtain the number of solutions. if projection fails, nbpoints returns 0.

        """
        _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_swiginit(self, _Geom2dAPI.new_Geom2dAPI_ProjectPointOnCurve(*args))

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Computes the distance between the point and its computed orthogonal projection on the curve. index is a number of computed projected point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_Distance(self, *args)

    def Extrema(self, *args):
        r"""
        Return
        -------
        Extrema_ExtPC2d

        Description
        -----------
        Return the algorithmic object from extrema.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_Extrema(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt2d
        Curve: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Initializes this algorithm with the given arguments, and computes the orthogonal projections of a point <p> on a curve <curve>.

        Parameters
        ----------
        P: gp_Pnt2d
        Curve: Geom2d_Curve
        Umin: float
        Usup: float

        Return
        -------
        None

        Description
        -----------
        Initializes this algorithm with the given arguments, and computes the orthogonal projections of the point p onto the portion of the curve curve limited by the two points of parameter umin and usup.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_Init(self, *args)

    def LowerDistance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the distance between the point and its nearest orthogonal projection on the curve. exceptions stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_LowerDistance(self, *args)

    def LowerDistanceParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the curve of the nearest orthogonal projection of the point. exceptions stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_LowerDistanceParameter(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return the number of of computed orthogonal projectionn points.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_NbPoints(self, *args)

    def NearestPoint(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the nearest orthogonal projection of the point on the curve. exceptions stdfail_notdone if this algorithm fails.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_NearestPoint(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the curve of a point which is the orthogonal projection. index is a number of a computed projected point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Return
        -------
        U: float

        Description
        -----------
        Returns the parameter on the curve of a point which is the orthogonal projection. index is a number of a computed projected point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_Parameter(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the orthogonal projection on the curve. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        """
        return _Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_Point(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Geom2dAPI.delete_Geom2dAPI_ProjectPointOnCurve

# Register Geom2dAPI_ProjectPointOnCurve in _Geom2dAPI:
_Geom2dAPI.Geom2dAPI_ProjectPointOnCurve_swigregister(Geom2dAPI_ProjectPointOnCurve)



