from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Geom import *
from OCC.Core.Geom2d import *
from OCC.Core.Message import *


class geomtools:
    @overload
    @staticmethod
    def Dump(S: Geom_Surface) -> str: ...
    @overload
    @staticmethod
    def Dump(C: Geom_Curve) -> str: ...
    @overload
    @staticmethod
    def Dump(C: Geom2d_Curve) -> str: ...
    @staticmethod
    def GetReal(IS: str) -> float: ...
    @staticmethod
    def GetUndefinedTypeHandler() -> GeomTools_UndefinedTypeHandler: ...
    @overload
    @staticmethod
    def Read(S: Geom_Surface, IS: str) -> None: ...
    @overload
    @staticmethod
    def Read(C: Geom_Curve, IS: str) -> None: ...
    @overload
    @staticmethod
    def Read(C: Geom2d_Curve, IS: str) -> None: ...
    @staticmethod
    def SetUndefinedTypeHandler(aHandler: GeomTools_UndefinedTypeHandler) -> None: ...
    @overload
    @staticmethod
    def Write(S: Geom_Surface) -> str: ...
    @overload
    @staticmethod
    def Write(C: Geom_Curve) -> str: ...
    @overload
    @staticmethod
    def Write(C: Geom2d_Curve) -> str: ...

class GeomTools_Curve2dSet:
    def __init__(self) -> None: ...
    def Add(self, C: Geom2d_Curve) -> int: ...
    def Clear(self) -> None: ...
    def Curve2d(self, I: int) -> Geom2d_Curve: ...
    def Dump(self) -> str: ...
    def Index(self, C: Geom2d_Curve) -> int: ...
    @staticmethod
    def PrintCurve2d(C: Geom2d_Curve, compact: Optional[bool] = False) -> str: ...
    def Read(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @staticmethod
    def ReadCurve2d(IS: str) -> Geom2d_Curve: ...
    def Write(self, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...

class GeomTools_CurveSet:
    def __init__(self) -> None: ...
    def Add(self, C: Geom_Curve) -> int: ...
    def Clear(self) -> None: ...
    def Curve(self, I: int) -> Geom_Curve: ...
    def Dump(self) -> str: ...
    def Index(self, C: Geom_Curve) -> int: ...
    @staticmethod
    def PrintCurve(C: Geom_Curve, compact: Optional[bool] = False) -> str: ...
    def Read(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @staticmethod
    def ReadCurve(IS: str) -> Geom_Curve: ...
    def Write(self, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...

class GeomTools_SurfaceSet:
    def __init__(self) -> None: ...
    def Add(self, S: Geom_Surface) -> int: ...
    def Clear(self) -> None: ...
    def Dump(self) -> str: ...
    def Index(self, S: Geom_Surface) -> int: ...
    @staticmethod
    def PrintSurface(S: Geom_Surface, compact: Optional[bool] = False) -> str: ...
    def Read(self, IS: str, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @staticmethod
    def ReadSurface(IS: str) -> Geom_Surface: ...
    def Surface(self, I: int) -> Geom_Surface: ...
    def Write(self, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> str: ...

class GeomTools_UndefinedTypeHandler(Standard_Transient):
    def __init__(self) -> None: ...
    def PrintCurve(self, C: Geom_Curve, compact: Optional[bool] = False) -> str: ...
    def PrintCurve2d(self, C: Geom2d_Curve, compact: Optional[bool] = False) -> str: ...
    def PrintSurface(self, S: Geom_Surface, compact: Optional[bool] = False) -> str: ...
    def ReadCurve(self, ctype: int, IS: str, C: Geom_Curve) -> Standard_IStream: ...
    def ReadCurve2d(self, ctype: int, IS: str, C: Geom2d_Curve) -> Standard_IStream: ...
    def ReadSurface(self, ctype: int, IS: str, S: Geom_Surface) -> Standard_IStream: ...

# harray1 classes
# harray2 classes
# hsequence classes

