# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Intf module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_intf.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Intf
else:
    import _Intf

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Intf.delete_SwigPyIterator

    def value(self):
        return _Intf.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Intf.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Intf.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Intf.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Intf.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Intf.SwigPyIterator_copy(self)

    def next(self):
        return _Intf.SwigPyIterator_next(self)

    def __next__(self):
        return _Intf.SwigPyIterator___next__(self)

    def previous(self):
        return _Intf.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Intf.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Intf.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Intf.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Intf.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Intf.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Intf.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Intf.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Intf:
_Intf.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Intf.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Intf.ios_base_erase_event
    imbue_event = _Intf.ios_base_imbue_event
    copyfmt_event = _Intf.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Intf.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Intf.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Intf.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Intf.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Intf.ios_base_precision(self, *args)

    def width(self, *args):
        return _Intf.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Intf.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Intf.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Intf.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Intf.ios_base_xalloc()

    def iword(self, __ix):
        return _Intf.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Intf.ios_base_pword(self, __ix)
    __swig_destroy__ = _Intf.delete_ios_base

# Register ios_base in _Intf:
_Intf.ios_base_swigregister(ios_base)
cvar = _Intf.cvar
ios_base.boolalpha = _Intf.cvar.ios_base_boolalpha
ios_base.dec = _Intf.cvar.ios_base_dec
ios_base.fixed = _Intf.cvar.ios_base_fixed
ios_base.hex = _Intf.cvar.ios_base_hex
ios_base.internal = _Intf.cvar.ios_base_internal
ios_base.left = _Intf.cvar.ios_base_left
ios_base.oct = _Intf.cvar.ios_base_oct
ios_base.right = _Intf.cvar.ios_base_right
ios_base.scientific = _Intf.cvar.ios_base_scientific
ios_base.showbase = _Intf.cvar.ios_base_showbase
ios_base.showpoint = _Intf.cvar.ios_base_showpoint
ios_base.showpos = _Intf.cvar.ios_base_showpos
ios_base.skipws = _Intf.cvar.ios_base_skipws
ios_base.unitbuf = _Intf.cvar.ios_base_unitbuf
ios_base.uppercase = _Intf.cvar.ios_base_uppercase
ios_base.adjustfield = _Intf.cvar.ios_base_adjustfield
ios_base.basefield = _Intf.cvar.ios_base_basefield
ios_base.floatfield = _Intf.cvar.ios_base_floatfield
ios_base.badbit = _Intf.cvar.ios_base_badbit
ios_base.eofbit = _Intf.cvar.ios_base_eofbit
ios_base.failbit = _Intf.cvar.ios_base_failbit
ios_base.goodbit = _Intf.cvar.ios_base_goodbit
ios_base.app = _Intf.cvar.ios_base_app
ios_base.ate = _Intf.cvar.ios_base_ate
ios_base.binary = _Intf.cvar.ios_base_binary
ios_base.ios_base_in = _Intf.cvar.ios_base_ios_base_in
ios_base.out = _Intf.cvar.ios_base_out
ios_base.trunc = _Intf.cvar.ios_base_trunc
ios_base.beg = _Intf.cvar.ios_base_beg
ios_base.cur = _Intf.cvar.ios_base_cur
ios_base.end = _Intf.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Intf.ios_rdstate(self)

    def clear(self, *args):
        return _Intf.ios_clear(self, *args)

    def setstate(self, __state):
        return _Intf.ios_setstate(self, __state)

    def good(self):
        return _Intf.ios_good(self)

    def eof(self):
        return _Intf.ios_eof(self)

    def fail(self):
        return _Intf.ios_fail(self)

    def bad(self):
        return _Intf.ios_bad(self)

    def exceptions(self, *args):
        return _Intf.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Intf.ios_swiginit(self, _Intf.new_ios(__sb))
    __swig_destroy__ = _Intf.delete_ios

    def tie(self, *args):
        return _Intf.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Intf.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Intf.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Intf.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Intf.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Intf.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Intf.ios_widen(self, __c)

# Register ios in _Intf:
_Intf.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Intf.ostream_swiginit(self, _Intf.new_ostream(__sb))
    __swig_destroy__ = _Intf.delete_ostream

    def __lshift__(self, *args):
        return _Intf.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Intf.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Intf.ostream_write(self, __s, __n)

    def flush(self):
        return _Intf.ostream_flush(self)

    def tellp(self):
        return _Intf.ostream_tellp(self)

    def seekp(self, *args):
        return _Intf.ostream_seekp(self, *args)

# Register ostream in _Intf:
_Intf.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Intf.istream_swiginit(self, _Intf.new_istream(__sb))
    __swig_destroy__ = _Intf.delete_istream

    def __rshift__(self, *args):
        return _Intf.istream___rshift__(self, *args)

    def gcount(self):
        return _Intf.istream_gcount(self)

    def get(self, *args):
        return _Intf.istream_get(self, *args)

    def getline(self, *args):
        return _Intf.istream_getline(self, *args)

    def ignore(self, *args):
        return _Intf.istream_ignore(self, *args)

    def peek(self):
        return _Intf.istream_peek(self)

    def read(self, __s, __n):
        return _Intf.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Intf.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Intf.istream_putback(self, __c)

    def unget(self):
        return _Intf.istream_unget(self)

    def sync(self):
        return _Intf.istream_sync(self)

    def tellg(self):
        return _Intf.istream_tellg(self)

    def seekg(self, *args):
        return _Intf.istream_seekg(self, *args)

# Register istream in _Intf:
_Intf.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Intf.iostream_swiginit(self, _Intf.new_iostream(__sb))
    __swig_destroy__ = _Intf.delete_iostream

# Register iostream in _Intf:
_Intf.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Intf.endl_cb_ptr
endl = _Intf.endl
ends_cb_ptr = _Intf.ends_cb_ptr
ends = _Intf.ends
flush_cb_ptr = _Intf.flush_cb_ptr
flush = _Intf.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.BVH

from enum import IntEnum
from OCC.Core.Exception import *

Intf_EXTERNAL = _Intf.Intf_EXTERNAL
Intf_FACE = _Intf.Intf_FACE
Intf_EDGE = _Intf.Intf_EDGE
Intf_VERTEX = _Intf.Intf_VERTEX


class Intf_PIType(IntEnum):
	Intf_EXTERNAL = 0
	Intf_FACE = 1
	Intf_EDGE = 2
	Intf_VERTEX = 3
Intf_EXTERNAL = Intf_PIType.Intf_EXTERNAL
Intf_FACE = Intf_PIType.Intf_FACE
Intf_EDGE = Intf_PIType.Intf_EDGE
Intf_VERTEX = Intf_PIType.Intf_VERTEX

class Intf_Array1OfLin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self, *args):
        return _Intf.Intf_Array1OfLin_begin(self, *args)

    def cbegin(self):
        return _Intf.Intf_Array1OfLin_cbegin(self)

    def end(self, *args):
        return _Intf.Intf_Array1OfLin_end(self, *args)

    def cend(self):
        return _Intf.Intf_Array1OfLin_cend(self)

    def __init__(self, *args):
        _Intf.Intf_Array1OfLin_swiginit(self, _Intf.new_Intf_Array1OfLin(*args))
    __swig_destroy__ = _Intf.delete_Intf_Array1OfLin

    def Init(self, theValue):
        return _Intf.Intf_Array1OfLin_Init(self, theValue)

    def Size(self):
        return _Intf.Intf_Array1OfLin_Size(self)

    def Length(self):
        return _Intf.Intf_Array1OfLin_Length(self)

    def IsEmpty(self):
        return _Intf.Intf_Array1OfLin_IsEmpty(self)

    def Lower(self):
        return _Intf.Intf_Array1OfLin_Lower(self)

    def Upper(self):
        return _Intf.Intf_Array1OfLin_Upper(self)

    def Assign(self, theOther):
        return _Intf.Intf_Array1OfLin_Assign(self, theOther)

    def Move(self, *args):
        return _Intf.Intf_Array1OfLin_Move(self, *args)

    def Set(self, *args):
        return _Intf.Intf_Array1OfLin_Set(self, *args)

    def First(self):
        return _Intf.Intf_Array1OfLin_First(self)

    def ChangeFirst(self):
        return _Intf.Intf_Array1OfLin_ChangeFirst(self)

    def Last(self):
        return _Intf.Intf_Array1OfLin_Last(self)

    def ChangeLast(self):
        return _Intf.Intf_Array1OfLin_ChangeLast(self)

    def Value(self, theIndex):
        return _Intf.Intf_Array1OfLin_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Intf.Intf_Array1OfLin_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Intf.Intf_Array1OfLin___call__(self, *args)

    def SetValue(self, *args):
        return _Intf.Intf_Array1OfLin_SetValue(self, *args)

    def UpdateLowerBound(self, theLower):
        return _Intf.Intf_Array1OfLin_UpdateLowerBound(self, theLower)

    def UpdateUpperBound(self, theUpper):
        return _Intf.Intf_Array1OfLin_UpdateUpperBound(self, theUpper)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Intf.Intf_Array1OfLin_Resize(self, theLower, theUpper, theToCopyData)

    def IsDeletable(self):
        return _Intf.Intf_Array1OfLin_IsDeletable(self)

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Intf_Array1OfLin in _Intf:
_Intf.Intf_Array1OfLin_swigregister(Intf_Array1OfLin)
class Intf_SeqOfSectionLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Intf.Intf_SeqOfSectionLine_begin(self)

    def end(self):
        return _Intf.Intf_SeqOfSectionLine_end(self)

    def cbegin(self):
        return _Intf.Intf_SeqOfSectionLine_cbegin(self)

    def cend(self):
        return _Intf.Intf_SeqOfSectionLine_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfSectionLine_swiginit(self, _Intf.new_Intf_SeqOfSectionLine(*args))

    def Size(self):
        return _Intf.Intf_SeqOfSectionLine_Size(self)

    def Length(self):
        return _Intf.Intf_SeqOfSectionLine_Length(self)

    def Lower(self):
        return _Intf.Intf_SeqOfSectionLine_Lower(self)

    def Upper(self):
        return _Intf.Intf_SeqOfSectionLine_Upper(self)

    def IsEmpty(self):
        return _Intf.Intf_SeqOfSectionLine_IsEmpty(self)

    def Reverse(self):
        return _Intf.Intf_SeqOfSectionLine_Reverse(self)

    def Exchange(self, I, J):
        return _Intf.Intf_SeqOfSectionLine_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Intf.Intf_SeqOfSectionLine_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Intf.Intf_SeqOfSectionLine_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Intf.Intf_SeqOfSectionLine_Assign(self, theOther)

    def Set(self, *args):
        return _Intf.Intf_SeqOfSectionLine_Set(self, *args)

    def Remove(self, *args):
        return _Intf.Intf_SeqOfSectionLine_Remove(self, *args)

    def Append(self, *args):
        return _Intf.Intf_SeqOfSectionLine_Append(self, *args)

    def Prepend(self, *args):
        return _Intf.Intf_SeqOfSectionLine_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Intf.Intf_SeqOfSectionLine_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Intf.Intf_SeqOfSectionLine_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Intf.Intf_SeqOfSectionLine_Split(self, theIndex, theSeq)

    def First(self):
        return _Intf.Intf_SeqOfSectionLine_First(self)

    def ChangeFirst(self):
        return _Intf.Intf_SeqOfSectionLine_ChangeFirst(self)

    def Last(self):
        return _Intf.Intf_SeqOfSectionLine_Last(self)

    def ChangeLast(self):
        return _Intf.Intf_SeqOfSectionLine_ChangeLast(self)

    def Value(self, theIndex):
        return _Intf.Intf_SeqOfSectionLine_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Intf.Intf_SeqOfSectionLine_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Intf.Intf_SeqOfSectionLine___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Intf.Intf_SeqOfSectionLine_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfSectionLine

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfSectionLine in _Intf:
_Intf.Intf_SeqOfSectionLine_swigregister(Intf_SeqOfSectionLine)
class Intf_SeqOfSectionPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Intf.Intf_SeqOfSectionPoint_begin(self)

    def end(self):
        return _Intf.Intf_SeqOfSectionPoint_end(self)

    def cbegin(self):
        return _Intf.Intf_SeqOfSectionPoint_cbegin(self)

    def cend(self):
        return _Intf.Intf_SeqOfSectionPoint_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfSectionPoint_swiginit(self, _Intf.new_Intf_SeqOfSectionPoint(*args))

    def Size(self):
        return _Intf.Intf_SeqOfSectionPoint_Size(self)

    def Length(self):
        return _Intf.Intf_SeqOfSectionPoint_Length(self)

    def Lower(self):
        return _Intf.Intf_SeqOfSectionPoint_Lower(self)

    def Upper(self):
        return _Intf.Intf_SeqOfSectionPoint_Upper(self)

    def IsEmpty(self):
        return _Intf.Intf_SeqOfSectionPoint_IsEmpty(self)

    def Reverse(self):
        return _Intf.Intf_SeqOfSectionPoint_Reverse(self)

    def Exchange(self, I, J):
        return _Intf.Intf_SeqOfSectionPoint_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Intf.Intf_SeqOfSectionPoint_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Intf.Intf_SeqOfSectionPoint_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Intf.Intf_SeqOfSectionPoint_Assign(self, theOther)

    def Set(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_Set(self, *args)

    def Remove(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_Remove(self, *args)

    def Append(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_Append(self, *args)

    def Prepend(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Intf.Intf_SeqOfSectionPoint_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Intf.Intf_SeqOfSectionPoint_Split(self, theIndex, theSeq)

    def First(self):
        return _Intf.Intf_SeqOfSectionPoint_First(self)

    def ChangeFirst(self):
        return _Intf.Intf_SeqOfSectionPoint_ChangeFirst(self)

    def Last(self):
        return _Intf.Intf_SeqOfSectionPoint_Last(self)

    def ChangeLast(self):
        return _Intf.Intf_SeqOfSectionPoint_ChangeLast(self)

    def Value(self, theIndex):
        return _Intf.Intf_SeqOfSectionPoint_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Intf.Intf_SeqOfSectionPoint_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Intf.Intf_SeqOfSectionPoint___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Intf.Intf_SeqOfSectionPoint_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfSectionPoint

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfSectionPoint in _Intf:
_Intf.Intf_SeqOfSectionPoint_swigregister(Intf_SeqOfSectionPoint)
class Intf_SeqOfTangentZone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Intf.Intf_SeqOfTangentZone_begin(self)

    def end(self):
        return _Intf.Intf_SeqOfTangentZone_end(self)

    def cbegin(self):
        return _Intf.Intf_SeqOfTangentZone_cbegin(self)

    def cend(self):
        return _Intf.Intf_SeqOfTangentZone_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfTangentZone_swiginit(self, _Intf.new_Intf_SeqOfTangentZone(*args))

    def Size(self):
        return _Intf.Intf_SeqOfTangentZone_Size(self)

    def Length(self):
        return _Intf.Intf_SeqOfTangentZone_Length(self)

    def Lower(self):
        return _Intf.Intf_SeqOfTangentZone_Lower(self)

    def Upper(self):
        return _Intf.Intf_SeqOfTangentZone_Upper(self)

    def IsEmpty(self):
        return _Intf.Intf_SeqOfTangentZone_IsEmpty(self)

    def Reverse(self):
        return _Intf.Intf_SeqOfTangentZone_Reverse(self)

    def Exchange(self, I, J):
        return _Intf.Intf_SeqOfTangentZone_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Intf.Intf_SeqOfTangentZone_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Intf.Intf_SeqOfTangentZone_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Intf.Intf_SeqOfTangentZone_Assign(self, theOther)

    def Set(self, *args):
        return _Intf.Intf_SeqOfTangentZone_Set(self, *args)

    def Remove(self, *args):
        return _Intf.Intf_SeqOfTangentZone_Remove(self, *args)

    def Append(self, *args):
        return _Intf.Intf_SeqOfTangentZone_Append(self, *args)

    def Prepend(self, *args):
        return _Intf.Intf_SeqOfTangentZone_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Intf.Intf_SeqOfTangentZone_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Intf.Intf_SeqOfTangentZone_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Intf.Intf_SeqOfTangentZone_Split(self, theIndex, theSeq)

    def First(self):
        return _Intf.Intf_SeqOfTangentZone_First(self)

    def ChangeFirst(self):
        return _Intf.Intf_SeqOfTangentZone_ChangeFirst(self)

    def Last(self):
        return _Intf.Intf_SeqOfTangentZone_Last(self)

    def ChangeLast(self):
        return _Intf.Intf_SeqOfTangentZone_ChangeLast(self)

    def Value(self, theIndex):
        return _Intf.Intf_SeqOfTangentZone_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Intf.Intf_SeqOfTangentZone_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Intf.Intf_SeqOfTangentZone___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Intf.Intf_SeqOfTangentZone_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfTangentZone

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfTangentZone in _Intf:
_Intf.Intf_SeqOfTangentZone_swigregister(Intf_SeqOfTangentZone)
class intf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Contain(*args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        ThePnt: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Compute if the triangle <p1> <p2> <p3> contain <thepnt>.

        """
        return _Intf.intf_Contain(*args)

    @staticmethod
    def PlaneEquation(*args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        NormalVector: gp_XYZ

        Return
        -------
        PolarDistance: float

        Description
        -----------
        Computes the interference between two polygons in 2d. result: points of intersections and zones of tangence. computes the interference between a polygon or a straight line and a polyhedron. points of intersection and zones of tangence. give the plane equation of the triangle <p1> <p2> <p3>.

        """
        return _Intf.intf_PlaneEquation(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _Intf.intf_swiginit(self, _Intf.new_intf())
    __swig_destroy__ = _Intf.delete_intf

# Register intf in _Intf:
_Intf.intf_swigregister(intf)
class Intf_Interference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        ThePnt: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Tests if the polylines of intersection or the zones of tangence contain the point of intersection <thepnt>.

        """
        return _Intf.Intf_Interference_Contains(self, *args)

    def Dump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Interference_Dump(self, *args)

    def GetTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Gives the tolerance used for the calculation.

        """
        return _Intf.Intf_Interference_GetTolerance(self, *args)

    def Insert(self, *args):
        r"""

        Parameters
        ----------
        TheZone: Intf_TangentZone

        Return
        -------
        bool

        Description
        -----------
        Inserts a new zone of tangence in the current list of tangent zones of the interference and returns true when done.

        Parameters
        ----------
        pdeb: Intf_SectionPoint
        pfin: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Insert a new segment of intersection in the current list of polylines of intersection of the interference.

        """
        return _Intf.Intf_Interference_Insert(self, *args)

    def LineValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Intf_SectionLine

        Description
        -----------
        Gives the polyline of intersection at address <index> in the interference.

        """
        return _Intf.Intf_Interference_LineValue(self, *args)

    def NbSectionLines(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives the number of polylines of intersection in the interference.

        """
        return _Intf.Intf_Interference_NbSectionLines(self, *args)

    def NbSectionPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives the number of points of intersection in the interference.

        """
        return _Intf.Intf_Interference_NbSectionPoints(self, *args)

    def NbTangentZones(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives the number of zones of tangence in the interference.

        """
        return _Intf.Intf_Interference_NbTangentZones(self, *args)

    def PntValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Intf_SectionPoint

        Description
        -----------
        Gives the point of intersection of address index in the interference.

        """
        return _Intf.Intf_Interference_PntValue(self, *args)

    def ZoneValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Intf_TangentZone

        Description
        -----------
        Gives the zone of tangence at address index in the interference.

        """
        return _Intf.Intf_Interference_ZoneValue(self, *args)

    __repr__ = _dumps_object


# Register Intf_Interference in _Intf:
_Intf.Intf_Interference_swigregister(Intf_Interference)
class Intf_Polygon2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Bounding(self, *args):
        r"""
        Return
        -------
        Bnd_Box2d

        Description
        -----------
        Returns the bounding box of the polygon.

        """
        return _Intf.Intf_Polygon2d_Bounding(self, *args)

    def Closed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the polyline is closed.

        """
        return _Intf.Intf_Polygon2d_Closed(self, *args)

    def DeflectionOverEstimation(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the tolerance of the polygon.

        """
        return _Intf.Intf_Polygon2d_DeflectionOverEstimation(self, *args)

    def NbSegments(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of segments in the polyline.

        """
        return _Intf.Intf_Polygon2d_NbSegments(self, *args)

    def Segment(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theBegin: gp_Pnt2d
        theEnd: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Returns the points of the segment <index> in the polygon.

        """
        return _Intf.Intf_Polygon2d_Segment(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_Polygon2d

# Register Intf_Polygon2d in _Intf:
_Intf.Intf_Polygon2d_swigregister(Intf_Polygon2d)
class Intf_SectionLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty sectionline.

        Parameters
        ----------
        Other: Intf_SectionLine

        Return
        -------
        None

        Description
        -----------
        Copies a sectionline.

        """
        _Intf.Intf_SectionLine_swiginit(self, _Intf.new_Intf_SectionLine(*args))

    def Append(self, *args):
        r"""

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Adds a point at the end of the sectionline.

        Parameters
        ----------
        LS: Intf_SectionLine

        Return
        -------
        None

        Description
        -----------
        Concatenates the sectionline <ls> at the end of the sectionline <self>.

        """
        return _Intf.Intf_SectionLine_Append(self, *args)

    def Close(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Closes the sectionline.

        """
        return _Intf.Intf_SectionLine_Close(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Returns true if thepi is in the sectionline <self>.

        """
        return _Intf.Intf_SectionLine_Contains(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------
        Indent: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_SectionLine_Dump(self, *args)

    def GetPoint(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Intf_SectionPoint

        Description
        -----------
        Gives the point of intersection of address <index> in the sectionline.

        """
        return _Intf.Intf_SectionLine_GetPoint(self, *args)

    def IsClosed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the sectionline is closed.

        """
        return _Intf.Intf_SectionLine_IsClosed(self, *args)

    def IsEnd(self, *args):
        r"""

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Return
        -------
        int

        Description
        -----------
        Checks if <thepi> is an end of the sectionline. returns 1 for the beginning, 2 for the end, otherwise 0.

        """
        return _Intf.Intf_SectionLine_IsEnd(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_SectionLine

        Return
        -------
        bool

        Description
        -----------
        Compares two sectionlines.

        """
        return _Intf.Intf_SectionLine_IsEqual(self, *args)

    def NumberOfPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of points in this sectionline.

        """
        return _Intf.Intf_SectionLine_NumberOfPoints(self, *args)

    def Prepend(self, *args):
        r"""

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Adds a point to the beginning of the sectionline <self>.

        Parameters
        ----------
        LS: Intf_SectionLine

        Return
        -------
        None

        Description
        -----------
        Concatenates a sectionline <ls> at the beginning of the sectionline <self>.

        """
        return _Intf.Intf_SectionLine_Prepend(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the order of the elements of the sectionline.

        """
        return _Intf.Intf_SectionLine_Reverse(self, *args)

    def __eq_wrapper__(self, other):
        return _Intf.Intf_SectionLine___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_SectionLine

# Register Intf_SectionLine in _Intf:
_Intf.Intf_SectionLine_swigregister(Intf_SectionLine)
class Intf_SectionPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Where: gp_Pnt
        DimeO: Intf_PIType
        AddrO1: int
        AddrO2: int
        ParamO: float
        DimeT: Intf_PIType
        AddrT1: int
        AddrT2: int
        ParamT: float
        Incid: float

        Return
        -------
        None

        Description
        -----------
        Builds a sectionpoint with the respective dimensions (vertex edge or face) of the concerned arguments and their addresses in the topological structure.

        Parameters
        ----------
        Where: gp_Pnt2d
        DimeO: Intf_PIType
        AddrO1: int
        ParamO: float
        DimeT: Intf_PIType
        AddrT1: int
        ParamT: float
        Incid: float

        Return
        -------
        None

        Description
        -----------
        Builds a sectionpoint 2d with the respective dimensions (vertex or edge) of the concerned arguments and their addresses in the topological structure.

        """
        _Intf.Intf_SectionPoint_swiginit(self, _Intf.new_Intf_SectionPoint(*args))

    def Dump(self, *args):
        r"""

        Parameters
        ----------
        Indent: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_SectionPoint_Dump(self, *args)

    def Incidence(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Gives the incidence at this section point. the incidence between the two triangles is given by the cosine. the best incidence is 0. (pi/2). the worst is 1. (null angle).

        """
        return _Intf.Intf_SectionPoint_Incidence(self, *args)

    def InfoFirst(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        Dim: Intf_PIType
        Add1: int
        Add2: int
        Param: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------

        Return
        -------
        Dim: Intf_PIType
        Addr: int
        Param: float

        Description
        -----------
        Gives the data about the first argument of the interference.

        """
        return _Intf.Intf_SectionPoint_InfoFirst(self, *args)

    def InfoSecond(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        Dim: Intf_PIType
        Add1: int
        Add2: int
        Param: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------

        Return
        -------
        Dim: Intf_PIType
        Addr: int
        Param: float

        Description
        -----------
        Gives the data about the second argument of the interference.

        """
        return _Intf.Intf_SectionPoint_InfoSecond(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Returns true if the two sectionpoint have the same logical information.

        """
        return _Intf.Intf_SectionPoint_IsEqual(self, *args)

    def IsOnSameEdge(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Returns true if the two sectionpoints are on the same edge of the first or the second element.

        """
        return _Intf.Intf_SectionPoint_IsOnSameEdge(self, *args)

    def Merge(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Merges two sectionpoints.

        """
        return _Intf.Intf_SectionPoint_Merge(self, *args)

    def ParamOnFirst(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the cumulated parameter of the sectionpoint on the first element.

        """
        return _Intf.Intf_SectionPoint_ParamOnFirst(self, *args)

    def ParamOnSecond(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the cumulated parameter of the section point on the second element.

        """
        return _Intf.Intf_SectionPoint_ParamOnSecond(self, *args)

    def Pnt(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location of the sectionpoint.

        """
        return _Intf.Intf_SectionPoint_Pnt(self, *args)

    def TypeOnFirst(self, *args):
        r"""
        Return
        -------
        Intf_PIType

        Description
        -----------
        Returns the type of the section point on the first element.

        """
        return _Intf.Intf_SectionPoint_TypeOnFirst(self, *args)

    def TypeOnSecond(self, *args):
        r"""
        Return
        -------
        Intf_PIType

        Description
        -----------
        Returns the type of the section point on the second element.

        """
        return _Intf.Intf_SectionPoint_TypeOnSecond(self, *args)

    def __eq_wrapper__(self, other):
        return _Intf.Intf_SectionPoint___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_SectionPoint

# Register Intf_SectionPoint in _Intf:
_Intf.Intf_SectionPoint_swigregister(Intf_SectionPoint)
class Intf_TangentZone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Builds an empty tangent zone.

        """
        _Intf.Intf_TangentZone_swiginit(self, _Intf.new_Intf_TangentZone(*args))

    def Append(self, *args):
        r"""

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Adds a sectionpoint to the tangentzone.

        Parameters
        ----------
        Tzi: Intf_TangentZone

        Return
        -------
        None

        Description
        -----------
        Adds the tangentzone <tzi> to <self>.

        """
        return _Intf.Intf_TangentZone_Append(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Checks if <thepi> is in tangentzone.

        """
        return _Intf.Intf_TangentZone_Contains(self, *args)

    def Dump(self, *args):
        r"""

        Parameters
        ----------
        Indent: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_TangentZone_Dump(self, *args)

    def GetPoint(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Intf_SectionPoint

        Description
        -----------
        Gives the sectionpoint of address <index> in the tangentzone.

        """
        return _Intf.Intf_TangentZone_GetPoint(self, *args)

    def HasCommonRange(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_TangentZone

        Return
        -------
        bool

        Description
        -----------
        Returns true if the tangentzone <other> has a common part with <self>.

        """
        return _Intf.Intf_TangentZone_HasCommonRange(self, *args)

    def InfoFirst(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        segMin: int
        paraMin: float
        segMax: int
        paraMax: float

        Description
        -----------
        Gives information about the first argument of the interference. (usable only for polygon).

        """
        return _Intf.Intf_TangentZone_InfoFirst(self, *args)

    def InfoSecond(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        segMin: int
        paraMin: float
        segMax: int
        paraMax: float

        Description
        -----------
        Gives information about the second argument of the interference. (usable only for polygon).

        """
        return _Intf.Intf_TangentZone_InfoSecond(self, *args)

    def Insert(self, *args):
        r"""

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Inserts a sectionpoint in the tangentzone.

        """
        return _Intf.Intf_TangentZone_Insert(self, *args)

    def InsertAfter(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Inserts a sectionpoint after <index> in the tangentzone.

        """
        return _Intf.Intf_TangentZone_InsertAfter(self, *args)

    def InsertBefore(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Inserts a sectionpoint before <index> in the tangentzone.

        """
        return _Intf.Intf_TangentZone_InsertBefore(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        Other: Intf_TangentZone

        Return
        -------
        bool

        Description
        -----------
        Compares two tangentzones.

        """
        return _Intf.Intf_TangentZone_IsEqual(self, *args)

    def NumberOfPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of sectionpoint in this tangentzone.

        """
        return _Intf.Intf_TangentZone_NumberOfPoints(self, *args)

    def ParamOnFirst(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        paraMin: float
        paraMax: float

        Description
        -----------
        Gives the parameter range of the tangentzone on the first argument of the interference. (usable only for polygon).

        """
        return _Intf.Intf_TangentZone_ParamOnFirst(self, *args)

    def ParamOnSecond(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        paraMin: float
        paraMax: float

        Description
        -----------
        Gives the parameter range of the tangentzone on the second argument of the interference. (usable only for polygon).

        """
        return _Intf.Intf_TangentZone_ParamOnSecond(self, *args)

    def PolygonInsert(self, *args):
        r"""

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Return
        -------
        None

        Description
        -----------
        Inserts a point in the polygonal tangentzone.

        """
        return _Intf.Intf_TangentZone_PolygonInsert(self, *args)

    def RangeContains(self, *args):
        r"""

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Return
        -------
        bool

        Description
        -----------
        Returns true if <thepi> is in the parameter range of the tangentzone.

        """
        return _Intf.Intf_TangentZone_RangeContains(self, *args)

    def __eq_wrapper__(self, other):
        return _Intf.Intf_TangentZone___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_TangentZone

# Register Intf_TangentZone in _Intf:
_Intf.Intf_TangentZone_swigregister(Intf_TangentZone)
class Intf_Tool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Intf.Intf_Tool_swiginit(self, _Intf.new_Intf_Tool(*args))

    def BeginParam(self, *args):
        r"""

        Parameters
        ----------
        SegmentNum: int

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_BeginParam(self, *args)

    def EndParam(self, *args):
        r"""

        Parameters
        ----------
        SegmentNum: int

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_EndParam(self, *args)

    def Hypr2dBox(self, *args):
        r"""

        Parameters
        ----------
        theHypr2d: gp_Hypr2d
        bounding: Bnd_Box2d
        boxHypr: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_Hypr2dBox(self, *args)

    def HyprBox(self, *args):
        r"""

        Parameters
        ----------
        theHypr: gp_Hypr
        bounding: Bnd_Box
        boxHypr: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_HyprBox(self, *args)

    def Lin2dBox(self, *args):
        r"""

        Parameters
        ----------
        theLin2d: gp_Lin2d
        bounding: Bnd_Box2d
        boxLin: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_Lin2dBox(self, *args)

    def LinBox(self, *args):
        r"""

        Parameters
        ----------
        theLin: gp_Lin
        bounding: Bnd_Box
        boxLin: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_LinBox(self, *args)

    def NbSegments(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_NbSegments(self, *args)

    def Parab2dBox(self, *args):
        r"""

        Parameters
        ----------
        theParab2d: gp_Parab2d
        bounding: Bnd_Box2d
        boxHypr: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_Parab2dBox(self, *args)

    def ParabBox(self, *args):
        r"""

        Parameters
        ----------
        theParab: gp_Parab
        bounding: Bnd_Box
        boxHypr: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Intf.Intf_Tool_ParabBox(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_Tool

# Register Intf_Tool in _Intf:
_Intf.Intf_Tool_swigregister(Intf_Tool)
class Intf_InterferencePolygon2d(Intf_Interference):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty interference of polygon.

        Parameters
        ----------
        Obje1: Intf_Polygon2d
        Obje2: Intf_Polygon2d

        Return
        -------
        None

        Description
        -----------
        Constructs and computes an interference between two polygons.

        Parameters
        ----------
        Obje: Intf_Polygon2d

        Return
        -------
        None

        Description
        -----------
        Constructs and computes the auto interference of a polygon.

        """
        _Intf.Intf_InterferencePolygon2d_swiginit(self, _Intf.new_Intf_InterferencePolygon2d(*args))

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Obje1: Intf_Polygon2d
        Obje2: Intf_Polygon2d

        Return
        -------
        None

        Description
        -----------
        Computes an interference between two polygons.

        Parameters
        ----------
        Obje: Intf_Polygon2d

        Return
        -------
        None

        Description
        -----------
        Computes the self interference of a polygon.

        """
        return _Intf.Intf_InterferencePolygon2d_Perform(self, *args)

    def Pnt2dValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Gives the geometrical 2d point of the intersection point at address <index> in the interference.

        """
        return _Intf.Intf_InterferencePolygon2d_Pnt2dValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_InterferencePolygon2d

# Register Intf_InterferencePolygon2d in _Intf:
_Intf.Intf_InterferencePolygon2d_swigregister(Intf_InterferencePolygon2d)



@deprecated
def intf_Contain(*args):
	return intf.Contain(*args)

@deprecated
def intf_PlaneEquation(*args):
	return intf.PlaneEquation(*args)



