# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Precision module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_precision.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Precision
else:
    import _Precision

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Precision.delete_SwigPyIterator

    def value(self):
        return _Precision.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Precision.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Precision.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Precision.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Precision.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Precision.SwigPyIterator_copy(self)

    def next(self):
        return _Precision.SwigPyIterator_next(self)

    def __next__(self):
        return _Precision.SwigPyIterator___next__(self)

    def previous(self):
        return _Precision.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Precision.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Precision.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Precision.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Precision.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Precision.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Precision.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Precision.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Precision:
_Precision.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Precision.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _Precision.ios_base_erase_event
    imbue_event = _Precision.ios_base_imbue_event
    copyfmt_event = _Precision.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _Precision.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _Precision.ios_base_flags(self, *args)

    def setf(self, *args):
        return _Precision.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _Precision.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _Precision.ios_base_precision(self, *args)

    def width(self, *args):
        return _Precision.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _Precision.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _Precision.ios_base_imbue(self, __loc)

    def getloc(self):
        return _Precision.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _Precision.ios_base_xalloc()

    def iword(self, __ix):
        return _Precision.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _Precision.ios_base_pword(self, __ix)
    __swig_destroy__ = _Precision.delete_ios_base

# Register ios_base in _Precision:
_Precision.ios_base_swigregister(ios_base)
cvar = _Precision.cvar
ios_base.boolalpha = _Precision.cvar.ios_base_boolalpha
ios_base.dec = _Precision.cvar.ios_base_dec
ios_base.fixed = _Precision.cvar.ios_base_fixed
ios_base.hex = _Precision.cvar.ios_base_hex
ios_base.internal = _Precision.cvar.ios_base_internal
ios_base.left = _Precision.cvar.ios_base_left
ios_base.oct = _Precision.cvar.ios_base_oct
ios_base.right = _Precision.cvar.ios_base_right
ios_base.scientific = _Precision.cvar.ios_base_scientific
ios_base.showbase = _Precision.cvar.ios_base_showbase
ios_base.showpoint = _Precision.cvar.ios_base_showpoint
ios_base.showpos = _Precision.cvar.ios_base_showpos
ios_base.skipws = _Precision.cvar.ios_base_skipws
ios_base.unitbuf = _Precision.cvar.ios_base_unitbuf
ios_base.uppercase = _Precision.cvar.ios_base_uppercase
ios_base.adjustfield = _Precision.cvar.ios_base_adjustfield
ios_base.basefield = _Precision.cvar.ios_base_basefield
ios_base.floatfield = _Precision.cvar.ios_base_floatfield
ios_base.badbit = _Precision.cvar.ios_base_badbit
ios_base.eofbit = _Precision.cvar.ios_base_eofbit
ios_base.failbit = _Precision.cvar.ios_base_failbit
ios_base.goodbit = _Precision.cvar.ios_base_goodbit
ios_base.app = _Precision.cvar.ios_base_app
ios_base.ate = _Precision.cvar.ios_base_ate
ios_base.binary = _Precision.cvar.ios_base_binary
ios_base.ios_base_in = _Precision.cvar.ios_base_ios_base_in
ios_base.out = _Precision.cvar.ios_base_out
ios_base.trunc = _Precision.cvar.ios_base_trunc
ios_base.beg = _Precision.cvar.ios_base_beg
ios_base.cur = _Precision.cvar.ios_base_cur
ios_base.end = _Precision.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _Precision.ios_rdstate(self)

    def clear(self, *args):
        return _Precision.ios_clear(self, *args)

    def setstate(self, __state):
        return _Precision.ios_setstate(self, __state)

    def good(self):
        return _Precision.ios_good(self)

    def eof(self):
        return _Precision.ios_eof(self)

    def fail(self):
        return _Precision.ios_fail(self)

    def bad(self):
        return _Precision.ios_bad(self)

    def exceptions(self, *args):
        return _Precision.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _Precision.ios_swiginit(self, _Precision.new_ios(__sb))
    __swig_destroy__ = _Precision.delete_ios

    def tie(self, *args):
        return _Precision.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _Precision.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _Precision.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _Precision.ios_fill(self, *args)

    def imbue(self, __loc):
        return _Precision.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _Precision.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _Precision.ios_widen(self, __c)

# Register ios in _Precision:
_Precision.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Precision.ostream_swiginit(self, _Precision.new_ostream(__sb))
    __swig_destroy__ = _Precision.delete_ostream

    def __lshift__(self, *args):
        return _Precision.ostream___lshift__(self, *args)

    def put(self, __c):
        return _Precision.ostream_put(self, __c)

    def write(self, __s, __n):
        return _Precision.ostream_write(self, __s, __n)

    def flush(self):
        return _Precision.ostream_flush(self)

    def tellp(self):
        return _Precision.ostream_tellp(self)

    def seekp(self, *args):
        return _Precision.ostream_seekp(self, *args)

# Register ostream in _Precision:
_Precision.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Precision.istream_swiginit(self, _Precision.new_istream(__sb))
    __swig_destroy__ = _Precision.delete_istream

    def __rshift__(self, *args):
        return _Precision.istream___rshift__(self, *args)

    def gcount(self):
        return _Precision.istream_gcount(self)

    def get(self, *args):
        return _Precision.istream_get(self, *args)

    def getline(self, *args):
        return _Precision.istream_getline(self, *args)

    def ignore(self, *args):
        return _Precision.istream_ignore(self, *args)

    def peek(self):
        return _Precision.istream_peek(self)

    def read(self, __s, __n):
        return _Precision.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _Precision.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _Precision.istream_putback(self, __c)

    def unget(self):
        return _Precision.istream_unget(self)

    def sync(self):
        return _Precision.istream_sync(self)

    def tellg(self):
        return _Precision.istream_tellg(self)

    def seekg(self, *args):
        return _Precision.istream_seekg(self, *args)

# Register istream in _Precision:
_Precision.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _Precision.iostream_swiginit(self, _Precision.new_iostream(__sb))
    __swig_destroy__ = _Precision.delete_iostream

# Register iostream in _Precision:
_Precision.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _Precision.endl_cb_ptr
endl = _Precision.endl
ends_cb_ptr = _Precision.ends_cb_ptr
ends = _Precision.ends
flush_cb_ptr = _Precision.flush_cb_ptr
flush = _Precision.flush
import OCC.Core.Standard
import OCC.Core.NCollection

from enum import IntEnum
from OCC.Core.Exception import *



class precision(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Angular(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the recommended precision value when checking the equality of two angles (given in radians). standard_real angle1 = ... , angle2 = ... ; if ( abs( angle2 - angle1 ) < precision::angular() ) ... the tolerance of angular equality may be used to check the parallelism of two vectors: gp_vec v1, v2 ; v1 = ... v2 = ... if ( v1.isparallel (v2, precision::angular() ) ) ... the tolerance of angular equality is equal to 1.e-12. note: the tolerance of angular equality can be used when working with scalar products or cross products since sines and angles are equivalent for small angles. therefore, in order to check whether two unit vectors are perpendicular: gp_dir d1, d2 ; d1 = ... d2 = ... you can use: if ( abs( d1.d2 ) < precision::angular() ) ... (although the function isnormal does exist).

        """
        return _Precision.precision_Angular(*args)

    @staticmethod
    def Approximation(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the precision value in real space, frequently used by approximation algorithms. this function provides an acceptable level of precision for an approximation process to define adjustment limits. the tolerance of approximation is designed to ensure an acceptable computation time when performing an approximation process. that is why the tolerance of approximation is greater than the tolerance of confusion. the tolerance of approximation is equal to: precision::confusion() * 10. (that is, 1.e-6). you may use a smaller tolerance in an approximation algorithm, but this option might be costly.

        """
        return _Precision.precision_Approximation(*args)

    @staticmethod
    def Confusion(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the recommended precision value when checking coincidence of two points in real space. the tolerance of confusion is used for testing a 3d distance: - two points are considered to be coincident if their distance is smaller than the tolerance of confusion. gp_pnt p1, p2 ; p1 = ... p2 = ... if ( p1.isequal ( p2 , precision::confusion() ) ) then ... - a vector is considered to be null if it has a null length: gp_vec v ; v = ... if ( v.magnitude() < precision::confusion() ) then ... the tolerance of confusion is equal to 1.e-7. the value of the tolerance of confusion is also used to define: - the tolerance of intersection, and - the tolerance of approximation. note: as a rule, coordinate values in cas.cade are not dimensioned, so 1. represents one user unit, whatever value the unit may have: the millimeter, the meter, the inch, or any other unit. let's say that cas.cade algorithms are written to be tuned essentially with mechanical design applications, on the basis of the millimeter. however, these algorithms may be used with any other unit but the tolerance criterion does no longer have the same signification. so pay particular attention to the type of your application, in relation with the impact of your unit on the precision criterion. - for example in mechanical design, if the unit is the millimeter, the tolerance of confusion corresponds to a distance of 1 / 10000 micron, which is rather difficult to measure. - however in other types of applications, such as cartography, where the kilometer is frequently used, the tolerance of confusion corresponds to a greater distance (1 / 10 millimeter). this distance becomes easily measurable, but only within a restricted space which contains some small objects of the complete scene.

        """
        return _Precision.precision_Confusion(*args)

    @staticmethod
    def Infinite(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns a big number that can be considered as infinite. use -infinite() for a negative big number.

        """
        return _Precision.precision_Infinite(*args)

    @staticmethod
    def Intersection(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the precision value in real space, frequently used by intersection algorithms to decide that a solution is reached. this function provides an acceptable level of precision for an intersection process to define the adjustment limits. the tolerance of intersection is designed to ensure that a point computed by an iterative algorithm as the intersection between two curves is indeed on the intersection. it is obvious that two tangent curves are close to each other, on a large distance. an iterative algorithm of intersection may find points on these curves within the scope of the confusion tolerance, but still far from the true intersection point. in order to force the intersection algorithm to continue the iteration process until a correct point is found on the tangent objects, the tolerance of intersection must be smaller than the tolerance of confusion. on the other hand, the tolerance of intersection must be large enough to minimize the time required by the process to converge to a solution. the tolerance of intersection is equal to: precision::confusion() / 100. (that is, 1.e-9).

        """
        return _Precision.precision_Intersection(*args)

    @staticmethod
    def IsInfinite(*args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if r may be considered as an infinite number. currently abs(r) > 1e100.

        """
        return _Precision.precision_IsInfinite(*args)

    @staticmethod
    def IsNegativeInfinite(*args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if r may be considered as a negative infinite number. currently r < -1e100.

        """
        return _Precision.precision_IsNegativeInfinite(*args)

    @staticmethod
    def IsPositiveInfinite(*args):
        r"""

        Parameters
        ----------
        R: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if r may be considered as a positive infinite number. currently r > 1e100.

        """
        return _Precision.precision_IsPositiveInfinite(*args)

    @staticmethod
    def PApproximation(*args):
        r"""

        Parameters
        ----------
        T: float

        Return
        -------
        float

        Description
        -----------
        Returns a precision value in parametric space, which may be used by approximation algorithms. the purpose of this function is to provide an acceptable level of precision in parametric space, for an approximation process to define the adjustment limits. the parametric tolerance of approximation is designed to give a mean value in relation with the dimension of the curve or the surface. it considers that a variation of parameter equal to 1. along a curve (or an isoparametric curve of a surface) generates a segment whose length is equal to 100. (default value), or t. the parametric tolerance of intersection is equal to: - precision::approximation() / 100., or precision::approximation() / t.
        Return
        -------
        float

        Description
        -----------
        Used for approximations in parametric space on a default curve. //! this is precision::parametric(precision::approximation()).

        """
        return _Precision.precision_PApproximation(*args)

    @staticmethod
    def PConfusion(*args):
        r"""

        Parameters
        ----------
        T: float

        Return
        -------
        float

        Description
        -----------
        Returns a precision value in parametric space, which may be used: - to test the coincidence of two points in the real space, by using parameter values, or - to test the equality of two parameter values in a parametric space. the parametric tolerance of confusion is designed to give a mean value in relation with the dimension of the curve or the surface. it considers that a variation of parameter equal to 1. along a curve (or an isoparametric curve of a surface) generates a segment whose length is equal to 100. (default value), or t. the parametric tolerance of confusion is equal to: - precision::confusion() / 100., or precision::confusion() / t. the value of the parametric tolerance of confusion is also used to define: - the parametric tolerance of intersection, and - the parametric tolerance of approximation. warning it is rather difficult to define a unique precision value in parametric space. - first consider a curve (c) ; if m is the point of parameter u and m' the point of parameter u+du on the curve, call 'parametric tangent' at point m, for the variation du of the parameter, the quantity: t(u,du)=mm'/du (where mm' represents the distance between the two points m and m', in the real space). - consider the other curve resulting from a scaling transformation of (c) with a scale factor equal to 10. the 'parametric tangent' at the point of parameter u of this curve is ten times greater than the previous one. this shows that for two different curves, the distance between two points on the curve, resulting from the same variation of parameter du, may vary considerably. - moreover, the variation of the parameter along the curve is generally not proportional to the curvilinear abscissa along the curve. so the distance between two points resulting from the same variation of parameter du, at two different points of a curve, may completely differ. - moreover, the parameterization of a surface may generate two quite different 'parametric tangent' values in the u or in the v parametric direction. - last, close to the poles of a sphere (the points which correspond to the values -pi/2. and pi/2. of the v parameter) the u parameter may change from 0 to 2.pi without impacting on the resulting point. therefore, take great care when adjusting a parametric tolerance to your own algorithm.
        Return
        -------
        float

        Description
        -----------
        Used to test distances in parametric space on a default curve. //! this is precision::parametric(precision::confusion()).

        """
        return _Precision.precision_PConfusion(*args)

    @staticmethod
    def PIntersection(*args):
        r"""

        Parameters
        ----------
        T: float

        Return
        -------
        float

        Description
        -----------
        Returns a precision value in parametric space, which may be used by intersection algorithms, to decide that a solution is reached. the purpose of this function is to provide an acceptable level of precision in parametric space, for an intersection process to define the adjustment limits. the parametric tolerance of intersection is designed to give a mean value in relation with the dimension of the curve or the surface. it considers that a variation of parameter equal to 1. along a curve (or an isoparametric curve of a surface) generates a segment whose length is equal to 100. (default value), or t. the parametric tolerance of intersection is equal to: - precision::intersection() / 100., or precision::intersection() / t.
        Return
        -------
        float

        Description
        -----------
        Used for intersections in parametric space on a default curve. //! this is precision::parametric(precision::intersection()).

        """
        return _Precision.precision_PIntersection(*args)

    @staticmethod
    def Parametric(*args):
        r"""

        Parameters
        ----------
        P: float
        T: float

        Return
        -------
        float

        Description
        -----------
        Convert a real space precision to a parametric space precision. <t> is the mean value of the length of the tangent of the curve or the surface. //! value is p / t.

        Parameters
        ----------
        P: float

        Return
        -------
        float

        Description
        -----------
        Convert a real space precision to a parametric space precision on a default curve. //! value is parametric(p,1.e+2).

        """
        return _Precision.precision_Parametric(*args)

    @staticmethod
    def SquareConfusion(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns square of confusion. created for speed and convenience.

        """
        return _Precision.precision_SquareConfusion(*args)

    @staticmethod
    def SquarePConfusion(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns square of pconfusion. created for speed and convenience.

        """
        return _Precision.precision_SquarePConfusion(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _Precision.precision_swiginit(self, _Precision.new_precision())
    __swig_destroy__ = _Precision.delete_precision

# Register precision in _Precision:
_Precision.precision_swigregister(precision)



@deprecated
def precision_Angular(*args):
	return precision.Angular(*args)

@deprecated
def precision_Approximation(*args):
	return precision.Approximation(*args)

@deprecated
def precision_Confusion(*args):
	return precision.Confusion(*args)

@deprecated
def precision_Infinite(*args):
	return precision.Infinite(*args)

@deprecated
def precision_Intersection(*args):
	return precision.Intersection(*args)

@deprecated
def precision_IsInfinite(*args):
	return precision.IsInfinite(*args)

@deprecated
def precision_IsNegativeInfinite(*args):
	return precision.IsNegativeInfinite(*args)

@deprecated
def precision_IsPositiveInfinite(*args):
	return precision.IsPositiveInfinite(*args)

@deprecated
def precision_PApproximation(*args):
	return precision.PApproximation(*args)

@deprecated
def precision_PApproximation(*args):
	return precision.PApproximation(*args)

@deprecated
def precision_PConfusion(*args):
	return precision.PConfusion(*args)

@deprecated
def precision_PConfusion(*args):
	return precision.PConfusion(*args)

@deprecated
def precision_PIntersection(*args):
	return precision.PIntersection(*args)

@deprecated
def precision_PIntersection(*args):
	return precision.PIntersection(*args)

@deprecated
def precision_Parametric(*args):
	return precision.Parametric(*args)

@deprecated
def precision_Parametric(*args):
	return precision.Parametric(*args)

@deprecated
def precision_SquareConfusion(*args):
	return precision.SquareConfusion(*args)

@deprecated
def precision_SquarePConfusion(*args):
	return precision.SquarePConfusion(*args)



