# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
ProjLib module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_projlib.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ProjLib
else:
    import _ProjLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ProjLib.delete_SwigPyIterator

    def value(self):
        return _ProjLib.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _ProjLib.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _ProjLib.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _ProjLib.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _ProjLib.SwigPyIterator_equal(self, x)

    def copy(self):
        return _ProjLib.SwigPyIterator_copy(self)

    def next(self):
        return _ProjLib.SwigPyIterator_next(self)

    def __next__(self):
        return _ProjLib.SwigPyIterator___next__(self)

    def previous(self):
        return _ProjLib.SwigPyIterator_previous(self)

    def advance(self, n):
        return _ProjLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _ProjLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _ProjLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _ProjLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _ProjLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _ProjLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _ProjLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ProjLib:
_ProjLib.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _ProjLib.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _ProjLib.ios_base_erase_event
    imbue_event = _ProjLib.ios_base_imbue_event
    copyfmt_event = _ProjLib.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _ProjLib.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _ProjLib.ios_base_flags(self, *args)

    def setf(self, *args):
        return _ProjLib.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _ProjLib.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _ProjLib.ios_base_precision(self, *args)

    def width(self, *args):
        return _ProjLib.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _ProjLib.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _ProjLib.ios_base_imbue(self, __loc)

    def getloc(self):
        return _ProjLib.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _ProjLib.ios_base_xalloc()

    def iword(self, __ix):
        return _ProjLib.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _ProjLib.ios_base_pword(self, __ix)
    __swig_destroy__ = _ProjLib.delete_ios_base

# Register ios_base in _ProjLib:
_ProjLib.ios_base_swigregister(ios_base)
cvar = _ProjLib.cvar
ios_base.boolalpha = _ProjLib.cvar.ios_base_boolalpha
ios_base.dec = _ProjLib.cvar.ios_base_dec
ios_base.fixed = _ProjLib.cvar.ios_base_fixed
ios_base.hex = _ProjLib.cvar.ios_base_hex
ios_base.internal = _ProjLib.cvar.ios_base_internal
ios_base.left = _ProjLib.cvar.ios_base_left
ios_base.oct = _ProjLib.cvar.ios_base_oct
ios_base.right = _ProjLib.cvar.ios_base_right
ios_base.scientific = _ProjLib.cvar.ios_base_scientific
ios_base.showbase = _ProjLib.cvar.ios_base_showbase
ios_base.showpoint = _ProjLib.cvar.ios_base_showpoint
ios_base.showpos = _ProjLib.cvar.ios_base_showpos
ios_base.skipws = _ProjLib.cvar.ios_base_skipws
ios_base.unitbuf = _ProjLib.cvar.ios_base_unitbuf
ios_base.uppercase = _ProjLib.cvar.ios_base_uppercase
ios_base.adjustfield = _ProjLib.cvar.ios_base_adjustfield
ios_base.basefield = _ProjLib.cvar.ios_base_basefield
ios_base.floatfield = _ProjLib.cvar.ios_base_floatfield
ios_base.badbit = _ProjLib.cvar.ios_base_badbit
ios_base.eofbit = _ProjLib.cvar.ios_base_eofbit
ios_base.failbit = _ProjLib.cvar.ios_base_failbit
ios_base.goodbit = _ProjLib.cvar.ios_base_goodbit
ios_base.app = _ProjLib.cvar.ios_base_app
ios_base.ate = _ProjLib.cvar.ios_base_ate
ios_base.binary = _ProjLib.cvar.ios_base_binary
ios_base.ios_base_in = _ProjLib.cvar.ios_base_ios_base_in
ios_base.out = _ProjLib.cvar.ios_base_out
ios_base.trunc = _ProjLib.cvar.ios_base_trunc
ios_base.beg = _ProjLib.cvar.ios_base_beg
ios_base.cur = _ProjLib.cvar.ios_base_cur
ios_base.end = _ProjLib.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _ProjLib.ios_rdstate(self)

    def clear(self, *args):
        return _ProjLib.ios_clear(self, *args)

    def setstate(self, __state):
        return _ProjLib.ios_setstate(self, __state)

    def good(self):
        return _ProjLib.ios_good(self)

    def eof(self):
        return _ProjLib.ios_eof(self)

    def fail(self):
        return _ProjLib.ios_fail(self)

    def bad(self):
        return _ProjLib.ios_bad(self)

    def exceptions(self, *args):
        return _ProjLib.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _ProjLib.ios_swiginit(self, _ProjLib.new_ios(__sb))
    __swig_destroy__ = _ProjLib.delete_ios

    def tie(self, *args):
        return _ProjLib.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _ProjLib.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _ProjLib.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _ProjLib.ios_fill(self, *args)

    def imbue(self, __loc):
        return _ProjLib.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _ProjLib.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _ProjLib.ios_widen(self, __c)

# Register ios in _ProjLib:
_ProjLib.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _ProjLib.ostream_swiginit(self, _ProjLib.new_ostream(__sb))
    __swig_destroy__ = _ProjLib.delete_ostream

    def __lshift__(self, *args):
        return _ProjLib.ostream___lshift__(self, *args)

    def put(self, __c):
        return _ProjLib.ostream_put(self, __c)

    def write(self, __s, __n):
        return _ProjLib.ostream_write(self, __s, __n)

    def flush(self):
        return _ProjLib.ostream_flush(self)

    def tellp(self):
        return _ProjLib.ostream_tellp(self)

    def seekp(self, *args):
        return _ProjLib.ostream_seekp(self, *args)

# Register ostream in _ProjLib:
_ProjLib.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _ProjLib.istream_swiginit(self, _ProjLib.new_istream(__sb))
    __swig_destroy__ = _ProjLib.delete_istream

    def __rshift__(self, *args):
        return _ProjLib.istream___rshift__(self, *args)

    def gcount(self):
        return _ProjLib.istream_gcount(self)

    def get(self, *args):
        return _ProjLib.istream_get(self, *args)

    def getline(self, *args):
        return _ProjLib.istream_getline(self, *args)

    def ignore(self, *args):
        return _ProjLib.istream_ignore(self, *args)

    def peek(self):
        return _ProjLib.istream_peek(self)

    def read(self, __s, __n):
        return _ProjLib.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _ProjLib.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _ProjLib.istream_putback(self, __c)

    def unget(self):
        return _ProjLib.istream_unget(self)

    def sync(self):
        return _ProjLib.istream_sync(self)

    def tellg(self):
        return _ProjLib.istream_tellg(self)

    def seekg(self, *args):
        return _ProjLib.istream_seekg(self, *args)

# Register istream in _ProjLib:
_ProjLib.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _ProjLib.iostream_swiginit(self, _ProjLib.new_iostream(__sb))
    __swig_destroy__ = _ProjLib.delete_iostream

# Register iostream in _ProjLib:
_ProjLib.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _ProjLib.endl_cb_ptr
endl = _ProjLib.endl
ends_cb_ptr = _ProjLib.ends_cb_ptr
ends = _ProjLib.ends
flush_cb_ptr = _ProjLib.flush_cb_ptr
flush = _ProjLib.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColgp
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.AppParCurves
import OCC.Core.GeomAdaptor

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ProjLib_CompProjectedCurve_Create():
    return _ProjLib.Handle_ProjLib_CompProjectedCurve_Create()

def Handle_ProjLib_CompProjectedCurve_DownCast(t):
    return _ProjLib.Handle_ProjLib_CompProjectedCurve_DownCast(t)

def Handle_ProjLib_CompProjectedCurve_IsNull(t):
    return _ProjLib.Handle_ProjLib_CompProjectedCurve_IsNull(t)

def Handle_ProjLib_ProjectOnPlane_Create():
    return _ProjLib.Handle_ProjLib_ProjectOnPlane_Create()

def Handle_ProjLib_ProjectOnPlane_DownCast(t):
    return _ProjLib.Handle_ProjLib_ProjectOnPlane_DownCast(t)

def Handle_ProjLib_ProjectOnPlane_IsNull(t):
    return _ProjLib.Handle_ProjLib_ProjectOnPlane_IsNull(t)

def Handle_ProjLib_ProjectedCurve_Create():
    return _ProjLib.Handle_ProjLib_ProjectedCurve_Create()

def Handle_ProjLib_ProjectedCurve_DownCast(t):
    return _ProjLib.Handle_ProjLib_ProjectedCurve_DownCast(t)

def Handle_ProjLib_ProjectedCurve_IsNull(t):
    return _ProjLib.Handle_ProjLib_ProjectedCurve_IsNull(t)

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_Create():
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_Create()

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t):
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t)

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_IsNull(t):
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_IsNull(t)
class ProjLib_SequenceOfHSequenceOfPnt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_begin(self)

    def end(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_end(self)

    def cbegin(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_cbegin(self)

    def cend(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_cend(self)

    def __init__(self, *args):
        _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_swiginit(self, _ProjLib.new_ProjLib_SequenceOfHSequenceOfPnt(*args))

    def Size(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Size(self)

    def Length(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Length(self)

    def Lower(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Lower(self)

    def Upper(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Upper(self)

    def IsEmpty(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_IsEmpty(self)

    def Reverse(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Reverse(self)

    def Exchange(self, I, J):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Assign(self, theOther)

    def Set(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Set(self, *args)

    def Remove(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Remove(self, *args)

    def Append(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Append(self, *args)

    def Prepend(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Split(self, theIndex, theSeq)

    def First(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_First(self)

    def ChangeFirst(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeFirst(self)

    def Last(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Last(self)

    def ChangeLast(self):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeLast(self)

    def Value(self, theIndex):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _ProjLib.delete_ProjLib_SequenceOfHSequenceOfPnt

    def __len__(self):
        return self.Size()


# Register ProjLib_SequenceOfHSequenceOfPnt in _ProjLib:
_ProjLib.ProjLib_SequenceOfHSequenceOfPnt_swigregister(ProjLib_SequenceOfHSequenceOfPnt)
class projlib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def IsAnaSurf(*args):
        r"""

        Parameters
        ----------
        theAS: Adaptor3d_Surface

        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if surface is analytical, that is it can be plane, cylinder, cone, sphere, torus. for all other types of surface method returns 'false'.

        """
        return _ProjLib.projlib_IsAnaSurf(*args)

    @staticmethod
    def MakePCurveOfType(*args):
        r"""

        Parameters
        ----------
        PC: ProjLib_ProjectedCurve
        aC: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Make empty p-curve <ac> of relevant to <pc> type.

        """
        return _ProjLib.projlib_MakePCurveOfType(*args)

    @staticmethod
    def Project(*args):
        r"""

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Pnt

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        L: gp_Lin

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        C: gp_Circ

        Return
        -------
        gp_Circ2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        E: gp_Elips

        Return
        -------
        gp_Elips2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Parab

        Return
        -------
        gp_Parab2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        H: gp_Hypr

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        P: gp_Pnt

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        L: gp_Lin

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        Ci: gp_Circ

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        P: gp_Pnt

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        L: gp_Lin

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        Ci: gp_Circ

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Sp: gp_Sphere
        P: gp_Pnt

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Sp: gp_Sphere
        Ci: gp_Circ

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        To: gp_Torus
        P: gp_Pnt

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        To: gp_Torus
        Ci: gp_Circ

        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.projlib_Project(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ProjLib.projlib_swiginit(self, _ProjLib.new_projlib())
    __swig_destroy__ = _ProjLib.delete_projlib

# Register projlib in _ProjLib:
_ProjLib.projlib_swigregister(projlib)
class ProjLib_CompProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_Curve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: Adaptor3d_Surface
        C: Adaptor3d_Curve
        TolU: float
        TolV: float

        Return
        -------
        None

        Description
        -----------
        Try to find all solutions.

        Parameters
        ----------
        S: Adaptor3d_Surface
        C: Adaptor3d_Curve
        TolU: float
        TolV: float
        MaxDist: float

        Return
        -------
        None

        Description
        -----------
        This constructor tries to optimize the search using the assumption that maximum distance between surface and curve less or equal then maxdist. if maxdist < 0 then algorithm works as above.

        Parameters
        ----------
        Tol3d: float
        S: Adaptor3d_Surface
        C: Adaptor3d_Curve
        MaxDist: float (optional, default to -1.0)

        Return
        -------
        None

        Description
        -----------
        This constructor tries to optimize the search using the assumption that maximum distance between surface and curve less or equal then maxdist. if maxdist < 0 then algorithm try to find all solutions tolerances of parameters are calculated automatically.

        """
        _ProjLib.ProjLib_CompProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_CompProjectedCurve(*args))

    def Bounds(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        Udeb: float
        Ufin: float

        Description
        -----------
        Returns the bounds of the continuous part corresponding to index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Bounds(self, *args)

    def GetCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Curve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetCurve(self, *args)

    def GetProj2d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the parameter, which defines necessity of only 2d results.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetProj2d(self, *args)

    def GetProj3d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the parameter, which defines necessity of only 3d results.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetProj3d(self, *args)

    def GetResult2dC(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Returns the resulting 2d-curve of projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult2dC(self, *args)

    def GetResult2dP(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the resulting 2d-point of projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult2dP(self, *args)

    def GetResult2dUApproxError(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the error of approximation of u parameter 2d-curve as a result projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult2dUApproxError(self, *args)

    def GetResult2dVApproxError(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the error of approximation of v parameter 2d-curve as a result projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult2dVApproxError(self, *args)

    def GetResult3dApproxError(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the error of approximation of 3d-curve as a result projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult3dApproxError(self, *args)

    def GetResult3dC(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        Returns the resulting 3d-curve of projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult3dC(self, *args)

    def GetResult3dP(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the resulting 3d-point of projecting of the curve interval with number index.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetResult3dP(self, *args)

    def GetSequence(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ProjLib_HSequenceOfHSequenceOfPnt>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetSequence(self, *args)

    def GetSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Surface>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetSurface(self, *args)

    def GetTolerance(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        TolU: float
        TolV: float

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetTolerance(self, *args)

    def Init(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes a set of projected point and determine the continuous parts of the projected curves. the points corresponding to a projection on the bounds of the surface are included in this set of points.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Init(self, *args)

    def IsSinglePnt(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        P: gp_Pnt2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if part of projection with number index is a single point and writes its coordinates in p.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsSinglePnt(self, *args)

    def IsUIso(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        U: float

        Description
        -----------
        Returns true if part of projection with number index is an u-isoparametric curve of input surface.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsUIso(self, *args)

    def IsVIso(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        V: float

        Description
        -----------
        Returns true if part of projection with number index is an v-isoparametric curve of input surface.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsVIso(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        S: Adaptor3d_Surface

        Return
        -------
        None

        Description
        -----------
        Changes the surface.

        Parameters
        ----------
        C: Adaptor3d_Curve

        Return
        -------
        None

        Description
        -----------
        Changes the curve.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Load(self, *args)

    def MaxDistance(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between curve to project and surface.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_MaxDistance(self, *args)

    def NbCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of continuous part of the projected curve.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_NbCurves(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Performs projecting for given curve. if projecting uses approximation, approximation parameters can be set before by corresponding methods settol3d(...), secontinuity(...), setmaxdegree(...), setmaxseg(...).

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Perform(self, *args)

    def ResultIsPoint(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if result of projecting of the curve interval with number index is point.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_ResultIsPoint(self, *args)

    def SetContinuity(self, *args):
        r"""

        Parameters
        ----------
        theContinuity: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines curve continuity. default value is geomabs_c2;.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetContinuity(self, *args)

    def SetMaxDegree(self, *args):
        r"""

        Parameters
        ----------
        theMaxDegree: int

        Return
        -------
        None

        Description
        -----------
        Set max possible degree of result bspline curve2d, which is got by approximation. if maxdegree < 0, algorithm uses values that are chosen depending of types curve 3d and surface.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetMaxDegree(self, *args)

    def SetMaxSeg(self, *args):
        r"""

        Parameters
        ----------
        theMaxSeg: int

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if maxseg < 0, algorithm uses default value = 16.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetMaxSeg(self, *args)

    def SetProj2d(self, *args):
        r"""

        Parameters
        ----------
        theProj2d: bool

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines necessity of 2d results.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetProj2d(self, *args)

    def SetProj3d(self, *args):
        r"""

        Parameters
        ----------
        theProj3d: bool

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines necessity of 3d results.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetProj3d(self, *args)

    def SetTol3d(self, *args):
        r"""

        Parameters
        ----------
        theTol3d: float

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines 3d tolerance of approximation.

        """
        return _ProjLib.ProjLib_CompProjectedCurve_SetTol3d(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_CompProjectedCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_CompProjectedCurve

# Register ProjLib_CompProjectedCurve in _ProjLib:
_ProjLib.ProjLib_CompProjectedCurve_swigregister(ProjLib_CompProjectedCurve)
class ProjLib_ComputeApprox(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor, it only sets some initial values for class fields.

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        <tol> is the tolerance with which the approximation is performed. other parameters for approximation have default values.

        """
        _ProjLib.ProjLib_ComputeApprox_swiginit(self, _ProjLib.new_ProjLib_ComputeApprox(*args))

    def BSpline(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ComputeApprox_BSpline(self, *args)

    def Bezier(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BezierCurve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ComputeApprox_Bezier(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface

        Return
        -------
        None

        Description
        -----------
        Performs projecting. in case of approximation current values of parameters are used: default values or set by corresponding methods set...

        """
        return _ProjLib.ProjLib_ComputeApprox_Perform(self, *args)

    def SetBndPnt(self, *args):
        r"""

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint;.

        """
        return _ProjLib.ProjLib_ComputeApprox_SetBndPnt(self, *args)

    def SetDegree(self, *args):
        r"""

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Return
        -------
        None

        Description
        -----------
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values that are chosen depending of types curve 3d and surface.

        """
        return _ProjLib.ProjLib_ComputeApprox_SetDegree(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        """
        return _ProjLib.ProjLib_ComputeApprox_SetMaxSegments(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        theTolerance: float

        Return
        -------
        None

        Description
        -----------
        Set tolerance of approximation. default value is precision::confusion().

        """
        return _ProjLib.ProjLib_ComputeApprox_SetTolerance(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the reached tolerance.

        """
        return _ProjLib.ProjLib_ComputeApprox_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ComputeApprox

# Register ProjLib_ComputeApprox in _ProjLib:
_ProjLib.ProjLib_ComputeApprox_swigregister(ProjLib_ComputeApprox)
class ProjLib_ComputeApproxOnPolarSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor, it only sets some initial values for class fields.

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Tol: float (optional, default to 1.0e-4)

        Return
        -------
        None

        Description
        -----------
        Constructor, which performs projecting.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_Curve2d
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Constructor, which performs projecting, using initial curve 2d initcurve2d, which is any rough approximation of result curve. parameter tol is 3d tolerance of approximation.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_Curve2d
        InitCurve2dBis: Adaptor2d_Curve2d
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Constructor, which performs projecting, using two initial curves 2d: initcurve2d and initcurve2dbis that are any rough approximations of result curves. this constructor is used to get two pcurves for seem edge. parameter tol is 3d tolerance of approximation.

        """
        _ProjLib.ProjLib_ComputeApproxOnPolarSurface_swiginit(self, _ProjLib.new_ProjLib_ComputeApproxOnPolarSurface(*args))

    def BSpline(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Returns result curve 2d.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_BSpline(self, *args)

    def BuildInitialCurve2d(self, *args):
        r"""

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        S: Adaptor3d_Surface

        Return
        -------
        opencascade::handle<Adaptor2d_Curve2d>

        Description
        -----------
        Builds initial 2d curve as bspline with degree = 1 using extrema algorithm. method is used in method perform(...).

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_BuildInitialCurve2d(self, *args)

    def Curve2d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Returns second 2d curve.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Curve2d(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_IsDone(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface

        Return
        -------
        None

        Description
        -----------
        Method, which performs projecting, using default values of parameters or they must be set by corresponding methods before using.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_Curve2d
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface

        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Method, which performs projecting, using default values of parameters or they must be set by corresponding methods before using. parameter initcurve2d is any rough estimation of 2d result curve.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Perform(self, *args)

    def ProjectUsingInitialCurve2d(self, *args):
        r"""

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        S: Adaptor3d_Surface
        InitCurve2d: Adaptor2d_Curve2d

        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        Method, which performs projecting. method is used in method perform(...).

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_ProjectUsingInitialCurve2d(self, *args)

    def SetBndPnt(self, *args):
        r"""

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetBndPnt(self, *args)

    def SetDegree(self, *args):
        r"""

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Return
        -------
        None

        Description
        -----------
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values min = 2, max = 8.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetDegree(self, *args)

    def SetMaxDist(self, *args):
        r"""

        Parameters
        ----------
        theMaxDist: float

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines maximal possible distance between projected curve and surface. it is used only for projecting on not analytical surfaces. if themaxdist < 0, algorithm uses default value 100.*tolerance. if real distance between curve and surface more then themaxdist, algorithm stops working.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetMaxDist(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetMaxSegments(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        theTolerance: float

        Return
        -------
        None

        Description
        -----------
        Set the tolerance used to project the curve on the surface. default value is precision::approximation().

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetTolerance(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the reached tolerance.

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ComputeApproxOnPolarSurface

# Register ProjLib_ComputeApproxOnPolarSurface in _ProjLib:
_ProjLib.ProjLib_ComputeApproxOnPolarSurface_swigregister(ProjLib_ComputeApproxOnPolarSurface)
class ProjLib_PrjFunc(OCC.Core.math.math_FunctionSetWithDerivatives):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve *
        FixVal: float
        S: Adaptor3d_Surface *
        Fix: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ProjLib.ProjLib_PrjFunc_swiginit(self, _ProjLib.new_ProjLib_PrjFunc(*args))

    def Solution(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns point on surface.

        """
        return _ProjLib.ProjLib_PrjFunc_Solution(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_PrjFunc

# Register ProjLib_PrjFunc in _ProjLib:
_ProjLib.ProjLib_PrjFunc_swigregister(ProjLib_PrjFunc)
class ProjLib_PrjResolve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Fix: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ProjLib.ProjLib_PrjResolve_swiginit(self, _ProjLib.new_ProjLib_PrjResolve(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance is found.

        """
        return _ProjLib.ProjLib_PrjResolve_IsDone(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        t: float
        U: float
        V: float
        Tol: gp_Pnt2d
        Inf: gp_Pnt2d
        Sup: gp_Pnt2d
        FTol: float (optional, default to -1)
        StrictInside: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Calculates the ort from c(t) to s with a close point. the close point is defined by the parameter values u0 and v0. the function f(u,v)=distance(s(u,v),c(t)) has an extremum when gradient(f)=0. the algorithm searches a zero near the close point.

        """
        return _ProjLib.ProjLib_PrjResolve_Perform(self, *args)

    def Solution(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the point of the extremum distance.

        """
        return _ProjLib.ProjLib_PrjResolve_Solution(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_PrjResolve

# Register ProjLib_PrjResolve in _ProjLib:
_ProjLib.ProjLib_PrjResolve_swigregister(ProjLib_PrjResolve)
class ProjLib_ProjectOnPlane(OCC.Core.Adaptor3d.Adaptor3d_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        Pl: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        The projection will be normal to the plane defined by the ax3 <pl>.

        Parameters
        ----------
        Pl: gp_Ax3
        D: gp_Dir

        Return
        -------
        None

        Description
        -----------
        The projection will be along the direction <d> on the plane defined by the ax3 <pl>. raises if the direction <d> is parallel to the plane <pl>.

        """
        _ProjLib.ProjLib_ProjectOnPlane_swiginit(self, _ProjLib.new_ProjLib_ProjectOnPlane(*args))

    def GetCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Curve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetCurve(self, *args)

    def GetDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetDirection(self, *args)

    def GetPlane(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetPlane(self, *args)

    def GetResult(self, *args):
        r"""
        Return
        -------
        opencascade::handle<GeomAdaptor_Curve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetResult(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        Tolerance: float
        KeepParametrization: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets the curve and perform the projection. if <keepparametrization> is true, the parametrization of the projected curve <pc> will be the same as the parametrization of the initial curve <c>. it means: proj(c(u)) = pc(u) for each u. otherwise, the parametrization may change.

        """
        return _ProjLib.ProjLib_ProjectOnPlane_Load(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_ProjectOnPlane_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectOnPlane

# Register ProjLib_ProjectOnPlane in _ProjLib:
_ProjLib.ProjLib_ProjectOnPlane_swigregister(ProjLib_ProjectOnPlane)
class ProjLib_ProjectOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Create an empty projector.

        Parameters
        ----------
        S: Adaptor3d_Surface

        Return
        -------
        None

        Description
        -----------
        Create a projector normally to the surface <s>.

        """
        _ProjLib.ProjLib_ProjectOnSurface_swiginit(self, _ProjLib.new_ProjLib_ProjectOnSurface(*args))

    def BSpline(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnSurface_BSpline(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectOnSurface_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Load(self):
    	pass

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectOnSurface

# Register ProjLib_ProjectOnSurface in _ProjLib:
_ProjLib.ProjLib_ProjectOnSurface_swigregister(ProjLib_ProjectOnSurface)
class ProjLib_ProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_Curve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor, it only sets some initial values for class fields.

        Parameters
        ----------
        S: Adaptor3d_Surface

        Return
        -------
        None

        Description
        -----------
        Constructor with initialisation field mysurface.

        Parameters
        ----------
        S: Adaptor3d_Surface
        C: Adaptor3d_Curve

        Return
        -------
        None

        Description
        -----------
        Constructor, which performs projecting. if projecting uses approximation, default parameters are used, in particular, 3d tolerance of approximation is precision::confusion().

        Parameters
        ----------
        S: Adaptor3d_Surface
        C: Adaptor3d_Curve
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Constructor, which performs projecting. if projecting uses approximation, 3d tolerance is tol, default parameters are used, .

        """
        _ProjLib.ProjLib_ProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_ProjectedCurve(*args))

    def GetCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Curve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetCurve(self, *args)

    def GetSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Adaptor3d_Surface>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetSurface(self, *args)

    def GetTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the tolerance reached if an approximation is done.

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetTolerance(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve

        Return
        -------
        None

        Description
        -----------
        Performs projecting for given curve. if projecting uses approximation, approximation parameters can be set before by corresponding methods setdegree(...), setmaxsegmets(...), setbndpnt(...), setmaxdist(...).

        """
        return _ProjLib.ProjLib_ProjectedCurve_Perform(self, *args)

    def SetBndPnt(self, *args):
        r"""

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint;.

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetBndPnt(self, *args)

    def SetDegree(self, *args):
        r"""

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Return
        -------
        None

        Description
        -----------
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values that are chosen depending of types curve 3d and surface.

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetDegree(self, *args)

    def SetMaxDist(self, *args):
        r"""

        Parameters
        ----------
        theMaxDist: float

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which degines maximal possible distance between projected curve and surface. it uses only for projecting on not analytical surfaces. if themaxdist < 0, algorithm uses default value 100.*tolerance. if real distance between curve and surface more then themaxdist, algorithm stops working.

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetMaxDist(self, *args)

    def SetMaxSegments(self, *args):
        r"""

        Parameters
        ----------
        theMaxSegments: int

        Return
        -------
        None

        Description
        -----------
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetMaxSegments(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_ProjectedCurve_DownCast(t)


    __repr__ = _dumps_object

    @methodnotwrapped
    def Load(self):
    	pass

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectedCurve

# Register ProjLib_ProjectedCurve in _ProjLib:
_ProjLib.ProjLib_ProjectedCurve_swigregister(ProjLib_ProjectedCurve)
class ProjLib_Projector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the type to othercurve.

        """
        _ProjLib.ProjLib_Projector_swiginit(self, _ProjLib.new_ProjLib_Projector(*args))

    def BSpline(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_BSpline(self, *args)

    def Bezier(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom2d_BezierCurve>

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Bezier(self, *args)

    def Circle(self, *args):
        r"""
        Return
        -------
        gp_Circ2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Circle(self, *args)

    def Done(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Set isdone = standard_true;.

        """
        return _ProjLib.ProjLib_Projector_Done(self, *args)

    def Ellipse(self, *args):
        r"""
        Return
        -------
        gp_Elips2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Ellipse(self, *args)

    def GetType(self, *args):
        r"""
        Return
        -------
        GeomAbs_CurveType

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_GetType(self, *args)

    def Hyperbola(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Hyperbola(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_IsDone(self, *args)

    def IsPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_IsPeriodic(self, *args)

    def Line(self, *args):
        r"""
        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Line(self, *args)

    def Parabola(self, *args):
        r"""
        Return
        -------
        gp_Parab2d

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Parabola(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_Project(self, *args)

    def SetBSpline(self, *args):
        r"""

        Parameters
        ----------
        C: Geom2d_BSplineCurve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_SetBSpline(self, *args)

    def SetBezier(self, *args):
        r"""

        Parameters
        ----------
        C: Geom2d_BezierCurve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_SetBezier(self, *args)

    def SetPeriodic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_SetPeriodic(self, *args)

    def SetType(self, *args):
        r"""

        Parameters
        ----------
        Type: GeomAbs_CurveType

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Projector_SetType(self, *args)

    def UFrame(self, *args):
        r"""

        Parameters
        ----------
        CFirst: float
        CLast: float
        UFirst: float
        Period: float

        Return
        -------
        None

        Description
        -----------
        Translates the 2d curve to set the part of the curve [cfirst, clast] in the range [ ufirst, ufirst + period [.

        """
        return _ProjLib.ProjLib_Projector_UFrame(self, *args)

    def VFrame(self, *args):
        r"""

        Parameters
        ----------
        CFirst: float
        CLast: float
        VFirst: float
        Period: float

        Return
        -------
        None

        Description
        -----------
        Translates the 2d curve to set the part of the curve [cfirst, clast] in the range [ vfirst, vfirst + period [.

        """
        return _ProjLib.ProjLib_Projector_VFrame(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Projector

# Register ProjLib_Projector in _ProjLib:
_ProjLib.ProjLib_Projector_swigregister(ProjLib_Projector)
class ProjLib_Cone(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined projection.

        Parameters
        ----------
        Co: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Projection on the cone <co>.

        Parameters
        ----------
        Co: gp_Cone
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        Projection of the line <l> on the cone <co>.

        Parameters
        ----------
        Co: gp_Cone
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Projection of the circle <c> on the cone <co>.

        """
        _ProjLib.ProjLib_Cone_swiginit(self, _ProjLib.new_ProjLib_Cone(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Co: gp_Cone

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Cone_Init(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Cone_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Cone

# Register ProjLib_Cone in _ProjLib:
_ProjLib.ProjLib_Cone_swigregister(ProjLib_Cone)
class ProjLib_Cylinder(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined projection.

        Parameters
        ----------
        Cyl: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Projection on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        Projection of the line <l> on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Projection of the circle <c> on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        Projection of the ellipse <e> on the cylinder <cyl>.

        """
        _ProjLib.ProjLib_Cylinder_swiginit(self, _ProjLib.new_ProjLib_Cylinder(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Cyl: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Cylinder_Init(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Cylinder_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Cylinder

# Register ProjLib_Cylinder in _ProjLib:
_ProjLib.ProjLib_Cylinder_swigregister(ProjLib_Cylinder)
class ProjLib_Plane(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined projection.

        Parameters
        ----------
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Projection on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        Projection of the line <l> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Projection of the circle <c> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        Projection of the ellipse <e> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        Projection of the parabola <p> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        Projection of the hyperbola <h> on the plane <pl>.

        """
        _ProjLib.ProjLib_Plane_swiginit(self, _ProjLib.new_ProjLib_Plane(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Plane_Init(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Plane_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Plane

# Register ProjLib_Plane in _ProjLib:
_ProjLib.ProjLib_Plane_swigregister(ProjLib_Plane)
class ProjLib_Sphere(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined projection.

        Parameters
        ----------
        Sp: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Projection on the sphere <sp>.

        Parameters
        ----------
        Sp: gp_Sphere
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Projection of the circle <c> on the sphere <sp>.

        """
        _ProjLib.ProjLib_Sphere_swiginit(self, _ProjLib.new_ProjLib_Sphere(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Sp: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Sphere_Init(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Sphere_Project(self, *args)

    def SetInBounds(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        None

        Description
        -----------
        Set the point of parameter u on c in the natural restrictions of the sphere.

        """
        return _ProjLib.ProjLib_Sphere_SetInBounds(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Sphere

# Register ProjLib_Sphere in _ProjLib:
_ProjLib.ProjLib_Sphere_swigregister(ProjLib_Sphere)
class ProjLib_Torus(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined projection.

        Parameters
        ----------
        To: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Projection on the torus <to>.

        Parameters
        ----------
        To: gp_Torus
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Projection of the circle <c> on the torus <to>.

        """
        _ProjLib.ProjLib_Torus_swiginit(self, _ProjLib.new_ProjLib_Torus(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        To: gp_Torus

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Torus_Init(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ProjLib.ProjLib_Torus_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Torus

# Register ProjLib_Torus in _ProjLib:
_ProjLib.ProjLib_Torus_swigregister(ProjLib_Torus)
class ProjLib_HSequenceOfHSequenceOfPnt(ProjLib_SequenceOfHSequenceOfPnt, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_swiginit(self, _ProjLib.new_ProjLib_HSequenceOfHSequenceOfPnt(*args))

    def Sequence(self):
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_Sequence(self)

    def Append(self, *args):
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_Append(self, *args)

    def ChangeSequence(self):
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t)

    __swig_destroy__ = _ProjLib.delete_ProjLib_HSequenceOfHSequenceOfPnt

# Register ProjLib_HSequenceOfHSequenceOfPnt in _ProjLib:
_ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_swigregister(ProjLib_HSequenceOfHSequenceOfPnt)

ProjLib_HCompProjectedCurve=ProjLib_CompProjectedCurve
ProjLib_HProjectedCurve=ProjLib_ProjectedCurve


@deprecated
def projlib_IsAnaSurf(*args):
	return projlib.IsAnaSurf(*args)

@deprecated
def projlib_MakePCurveOfType(*args):
	return projlib.MakePCurveOfType(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)

@deprecated
def projlib_Project(*args):
	return projlib.Project(*args)



