# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
StdPrs module, see official documentation at
https://dev.opencascade.org/doc/occt-7.8.0/refman/html/package_stdprs.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _StdPrs
else:
    import _StdPrs

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _StdPrs.delete_SwigPyIterator

    def value(self):
        return _StdPrs.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _StdPrs.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _StdPrs.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _StdPrs.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _StdPrs.SwigPyIterator_equal(self, x)

    def copy(self):
        return _StdPrs.SwigPyIterator_copy(self)

    def next(self):
        return _StdPrs.SwigPyIterator_next(self)

    def __next__(self):
        return _StdPrs.SwigPyIterator___next__(self)

    def previous(self):
        return _StdPrs.SwigPyIterator_previous(self)

    def advance(self, n):
        return _StdPrs.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _StdPrs.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _StdPrs.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _StdPrs.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _StdPrs.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _StdPrs.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _StdPrs.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _StdPrs:
_StdPrs.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _StdPrs.process_exception(error, method_name, class_name)

import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

class ios_base(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _StdPrs.ios_base_erase_event
    imbue_event = _StdPrs.ios_base_imbue_event
    copyfmt_event = _StdPrs.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _StdPrs.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _StdPrs.ios_base_flags(self, *args)

    def setf(self, *args):
        return _StdPrs.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _StdPrs.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _StdPrs.ios_base_precision(self, *args)

    def width(self, *args):
        return _StdPrs.ios_base_width(self, *args)

    @staticmethod
    def sync_with_stdio(__sync=True):
        return _StdPrs.ios_base_sync_with_stdio(__sync)

    def imbue(self, __loc):
        return _StdPrs.ios_base_imbue(self, __loc)

    def getloc(self):
        return _StdPrs.ios_base_getloc(self)

    @staticmethod
    def xalloc():
        return _StdPrs.ios_base_xalloc()

    def iword(self, __ix):
        return _StdPrs.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _StdPrs.ios_base_pword(self, __ix)
    __swig_destroy__ = _StdPrs.delete_ios_base

# Register ios_base in _StdPrs:
_StdPrs.ios_base_swigregister(ios_base)
cvar = _StdPrs.cvar
ios_base.boolalpha = _StdPrs.cvar.ios_base_boolalpha
ios_base.dec = _StdPrs.cvar.ios_base_dec
ios_base.fixed = _StdPrs.cvar.ios_base_fixed
ios_base.hex = _StdPrs.cvar.ios_base_hex
ios_base.internal = _StdPrs.cvar.ios_base_internal
ios_base.left = _StdPrs.cvar.ios_base_left
ios_base.oct = _StdPrs.cvar.ios_base_oct
ios_base.right = _StdPrs.cvar.ios_base_right
ios_base.scientific = _StdPrs.cvar.ios_base_scientific
ios_base.showbase = _StdPrs.cvar.ios_base_showbase
ios_base.showpoint = _StdPrs.cvar.ios_base_showpoint
ios_base.showpos = _StdPrs.cvar.ios_base_showpos
ios_base.skipws = _StdPrs.cvar.ios_base_skipws
ios_base.unitbuf = _StdPrs.cvar.ios_base_unitbuf
ios_base.uppercase = _StdPrs.cvar.ios_base_uppercase
ios_base.adjustfield = _StdPrs.cvar.ios_base_adjustfield
ios_base.basefield = _StdPrs.cvar.ios_base_basefield
ios_base.floatfield = _StdPrs.cvar.ios_base_floatfield
ios_base.badbit = _StdPrs.cvar.ios_base_badbit
ios_base.eofbit = _StdPrs.cvar.ios_base_eofbit
ios_base.failbit = _StdPrs.cvar.ios_base_failbit
ios_base.goodbit = _StdPrs.cvar.ios_base_goodbit
ios_base.app = _StdPrs.cvar.ios_base_app
ios_base.ate = _StdPrs.cvar.ios_base_ate
ios_base.binary = _StdPrs.cvar.ios_base_binary
ios_base.ios_base_in = _StdPrs.cvar.ios_base_ios_base_in
ios_base.out = _StdPrs.cvar.ios_base_out
ios_base.trunc = _StdPrs.cvar.ios_base_trunc
ios_base.beg = _StdPrs.cvar.ios_base_beg
ios_base.cur = _StdPrs.cvar.ios_base_cur
ios_base.end = _StdPrs.cvar.ios_base_end

class ios(ios_base):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def rdstate(self):
        return _StdPrs.ios_rdstate(self)

    def clear(self, *args):
        return _StdPrs.ios_clear(self, *args)

    def setstate(self, __state):
        return _StdPrs.ios_setstate(self, __state)

    def good(self):
        return _StdPrs.ios_good(self)

    def eof(self):
        return _StdPrs.ios_eof(self)

    def fail(self):
        return _StdPrs.ios_fail(self)

    def bad(self):
        return _StdPrs.ios_bad(self)

    def exceptions(self, *args):
        return _StdPrs.ios_exceptions(self, *args)

    def __init__(self, __sb):
        _StdPrs.ios_swiginit(self, _StdPrs.new_ios(__sb))
    __swig_destroy__ = _StdPrs.delete_ios

    def tie(self, *args):
        return _StdPrs.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _StdPrs.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _StdPrs.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _StdPrs.ios_fill(self, *args)

    def imbue(self, __loc):
        return _StdPrs.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _StdPrs.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _StdPrs.ios_widen(self, __c)

# Register ios in _StdPrs:
_StdPrs.ios_swigregister(ios)
class ostream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _StdPrs.ostream_swiginit(self, _StdPrs.new_ostream(__sb))
    __swig_destroy__ = _StdPrs.delete_ostream

    def __lshift__(self, *args):
        return _StdPrs.ostream___lshift__(self, *args)

    def put(self, __c):
        return _StdPrs.ostream_put(self, __c)

    def write(self, __s, __n):
        return _StdPrs.ostream_write(self, __s, __n)

    def flush(self):
        return _StdPrs.ostream_flush(self)

    def tellp(self):
        return _StdPrs.ostream_tellp(self)

    def seekp(self, *args):
        return _StdPrs.ostream_seekp(self, *args)

# Register ostream in _StdPrs:
_StdPrs.ostream_swigregister(ostream)
class istream(ios):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _StdPrs.istream_swiginit(self, _StdPrs.new_istream(__sb))
    __swig_destroy__ = _StdPrs.delete_istream

    def __rshift__(self, *args):
        return _StdPrs.istream___rshift__(self, *args)

    def gcount(self):
        return _StdPrs.istream_gcount(self)

    def get(self, *args):
        return _StdPrs.istream_get(self, *args)

    def getline(self, *args):
        return _StdPrs.istream_getline(self, *args)

    def ignore(self, *args):
        return _StdPrs.istream_ignore(self, *args)

    def peek(self):
        return _StdPrs.istream_peek(self)

    def read(self, __s, __n):
        return _StdPrs.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _StdPrs.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _StdPrs.istream_putback(self, __c)

    def unget(self):
        return _StdPrs.istream_unget(self)

    def sync(self):
        return _StdPrs.istream_sync(self)

    def tellg(self):
        return _StdPrs.istream_tellg(self)

    def seekg(self, *args):
        return _StdPrs.istream_seekg(self, *args)

# Register istream in _StdPrs:
_StdPrs.istream_swigregister(istream)
class iostream(istream, ostream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        _StdPrs.iostream_swiginit(self, _StdPrs.new_iostream(__sb))
    __swig_destroy__ = _StdPrs.delete_iostream

# Register iostream in _StdPrs:
_StdPrs.iostream_swigregister(iostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

endl_cb_ptr = _StdPrs.endl_cb_ptr
endl = _StdPrs.endl
ends_cb_ptr = _StdPrs.ends_cb_ptr
ends = _StdPrs.ends
flush_cb_ptr = _StdPrs.flush_cb_ptr
flush = _StdPrs.flush
import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Prs3d
import OCC.Core.Graphic3d
import OCC.Core.BVH
import OCC.Core.Quantity
import OCC.Core.Aspect
import OCC.Core.Image
import OCC.Core.TopLoc
import OCC.Core.Bnd
import OCC.Core.OSD
import OCC.Core.Media
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TopAbs
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.HLRAlgo
import OCC.Core.BRepAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.GeomAdaptor
import OCC.Core.BRep
import OCC.Core.TopTools
import OCC.Core.BRepLib
import OCC.Core.BRepTools

from enum import IntEnum
from OCC.Core.Exception import *

StdPrs_Volume_Autodetection = _StdPrs.StdPrs_Volume_Autodetection
StdPrs_Volume_Closed = _StdPrs.StdPrs_Volume_Closed
StdPrs_Volume_Opened = _StdPrs.StdPrs_Volume_Opened


class StdPrs_Volume(IntEnum):
	StdPrs_Volume_Autodetection = 0
	StdPrs_Volume_Closed = 1
	StdPrs_Volume_Opened = 2
StdPrs_Volume_Autodetection = StdPrs_Volume.StdPrs_Volume_Autodetection
StdPrs_Volume_Closed = StdPrs_Volume.StdPrs_Volume_Closed
StdPrs_Volume_Opened = StdPrs_Volume.StdPrs_Volume_Opened


def Handle_StdPrs_BRepFont_Create():
    return _StdPrs.Handle_StdPrs_BRepFont_Create()

def Handle_StdPrs_BRepFont_DownCast(t):
    return _StdPrs.Handle_StdPrs_BRepFont_DownCast(t)

def Handle_StdPrs_BRepFont_IsNull(t):
    return _StdPrs.Handle_StdPrs_BRepFont_IsNull(t)

def Handle_StdPrs_HLRShapeI_Create():
    return _StdPrs.Handle_StdPrs_HLRShapeI_Create()

def Handle_StdPrs_HLRShapeI_DownCast(t):
    return _StdPrs.Handle_StdPrs_HLRShapeI_DownCast(t)

def Handle_StdPrs_HLRShapeI_IsNull(t):
    return _StdPrs.Handle_StdPrs_HLRShapeI_IsNull(t)

def Handle_StdPrs_HLRPolyShape_Create():
    return _StdPrs.Handle_StdPrs_HLRPolyShape_Create()

def Handle_StdPrs_HLRPolyShape_DownCast(t):
    return _StdPrs.Handle_StdPrs_HLRPolyShape_DownCast(t)

def Handle_StdPrs_HLRPolyShape_IsNull(t):
    return _StdPrs.Handle_StdPrs_HLRPolyShape_IsNull(t)

def Handle_StdPrs_HLRShape_Create():
    return _StdPrs.Handle_StdPrs_HLRShape_Create()

def Handle_StdPrs_HLRShape_DownCast(t):
    return _StdPrs.Handle_StdPrs_HLRShape_DownCast(t)

def Handle_StdPrs_HLRShape_IsNull(t):
    return _StdPrs.Handle_StdPrs_HLRShape_IsNull(t)
class StdPrs_BRepFont(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theFontPath: NCollection_String
        theSize: float
        theFaceId: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization. @param thefontpath full path to the font @param thesize the face size in model units @param thefaceid face id within the file (0 by default).

        Parameters
        ----------
        theFontName: NCollection_String
        theFontAspect: Font_FontAspect
        theSize: float
        theStrictLevel: Font_StrictLevel (optional, default to Font_StrictLevel_Any)

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization. @param thefontname the font name @param thefontaspect the font style @param thesize the face size in model units @param thestrictlevel search strict level for using aliases and fallback.

        """
        _StdPrs.StdPrs_BRepFont_swiginit(self, _StdPrs.new_StdPrs_BRepFont(*args))

    def AdvanceX(self, *args):
        r"""

        Parameters
        ----------
        theUCharNext: Standard_Utf32Char

        Return
        -------
        float

        Description
        -----------
        Compute advance to the next character with kerning applied when applicable. assuming text rendered horizontally.

        Parameters
        ----------
        theUChar: Standard_Utf32Char
        theUCharNext: Standard_Utf32Char

        Return
        -------
        float

        Description
        -----------
        Compute advance to the next character with kerning applied when applicable. assuming text rendered horizontally.

        """
        return _StdPrs.StdPrs_BRepFont_AdvanceX(self, *args)

    def AdvanceY(self, *args):
        r"""

        Parameters
        ----------
        theUCharNext: Standard_Utf32Char

        Return
        -------
        float

        Description
        -----------
        Compute advance to the next character with kerning applied when applicable. assuming text rendered vertically.

        Parameters
        ----------
        theUChar: Standard_Utf32Char
        theUCharNext: Standard_Utf32Char

        Return
        -------
        float

        Description
        -----------
        Compute advance to the next character with kerning applied when applicable. assuming text rendered vertically.

        """
        return _StdPrs.StdPrs_BRepFont_AdvanceY(self, *args)

    def Ascender(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return vertical distance from the horizontal baseline to the highest character coordinate.

        """
        return _StdPrs.StdPrs_BRepFont_Ascender(self, *args)

    def Descender(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return vertical distance from the horizontal baseline to the lowest character coordinate.

        """
        return _StdPrs.StdPrs_BRepFont_Descender(self, *args)

    def FTFont(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Font_FTFont>

        Description
        -----------
        Return wrapper over freetype font.

        """
        return _StdPrs.StdPrs_BRepFont_FTFont(self, *args)

    @staticmethod
    def FindAndCreate(*args):
        r"""

        Parameters
        ----------
        theFontName: str
        theFontAspect: Font_FontAspect
        theSize: float
        theStrictLevel: Font_StrictLevel (optional, default to Font_StrictLevel_Any)

        Return
        -------
        opencascade::handle<StdPrs_BRepFont>

        Description
        -----------
        Find the font initialize the font. @param thefontname the font name @param thefontaspect the font style @param thesize the face size in model units @param thestrictlevel search strict level for using aliases and fallback return true on success.

        """
        return _StdPrs.StdPrs_BRepFont_FindAndCreate(*args)

    def FindAndInit(self, *args):
        r"""

        Parameters
        ----------
        theFontName: str
        theFontAspect: Font_FontAspect
        theSize: float
        theStrictLevel: Font_StrictLevel (optional, default to Font_StrictLevel_Any)

        Return
        -------
        bool

        Description
        -----------
        Find (using font_fontmgr) and initialize the font from the given name. please take into account that size is specified not in typography points (pt.). if you need to specify size in points, value should be converted. formula for pt. -> m conversion: asizemeters = 0.0254 * thesizept / 72.0 @param thefontname the font name @param thefontaspect the font style @param thesize the face size in model units @param thestrictlevel search strict level for using aliases and fallback return true on success.

        """
        return _StdPrs.StdPrs_BRepFont_FindAndInit(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theFontPath: NCollection_String
        theSize: float
        theFaceId: int

        Return
        -------
        bool

        Description
        -----------
        Initialize the font. @param thefontpath full path to the font @param thesize the face size in model units @param thefaceid face id within the file (0 by default) return true on success.

        Parameters
        ----------
        theFontName: NCollection_String
        theFontAspect: Font_FontAspect
        theSize: float

        Return
        -------
        bool

        Description
        -----------
        Find (using font_fontmgr) and initialize the font from the given name. alias for findandinit() for backward compatibility.

        """
        return _StdPrs.StdPrs_BRepFont_Init(self, *args)

    def LineSpacing(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return default line spacing (the baseline-to-baseline distance).

        """
        return _StdPrs.StdPrs_BRepFont_LineSpacing(self, *args)

    def Mutex(self, *args):
        r"""
        Return
        -------
        Standard_Mutex

        Description
        -----------
        Returns mutex.

        """
        return _StdPrs.StdPrs_BRepFont_Mutex(self, *args)

    def PointSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Configured point size.

        """
        return _StdPrs.StdPrs_BRepFont_PointSize(self, *args)

    def Release(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Release currently loaded font.

        """
        return _StdPrs.StdPrs_BRepFont_Release(self, *args)

    def RenderGlyph(self, *args):
        r"""

        Parameters
        ----------
        theChar: Standard_Utf32Char

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Render single glyph as topods_shape. @param thechar glyph identifier return rendered glyph within cache, might be null shape.

        """
        return _StdPrs.StdPrs_BRepFont_RenderGlyph(self, *args)

    def Scale(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns scaling factor for current font size.

        """
        return _StdPrs.StdPrs_BRepFont_Scale(self, *args)

    def SetCompositeCurveMode(self, *args):
        r"""

        Parameters
        ----------
        theToConcatenate: bool

        Return
        -------
        None

        Description
        -----------
        Setup glyph geometry construction mode. by default algorithm creates independent topods_edge for each original curve in the glyph (line segment or bezie curve). algorithm might optionally create composite bspline curve for each contour which reduces memory footprint but limits curve class to c0. notice that altering this flag clears currently accumulated cache!.

        """
        return _StdPrs.StdPrs_BRepFont_SetCompositeCurveMode(self, *args)

    def SetWidthScaling(self, *args):
        r"""

        Parameters
        ----------
        theScaleFactor: float

        Return
        -------
        None

        Description
        -----------
        Setup glyph scaling along x-axis. by default glyphs are not scaled (scaling factor = 1.0).

        """
        return _StdPrs.StdPrs_BRepFont_SetWidthScaling(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_StdPrs_BRepFont_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _StdPrs.delete_StdPrs_BRepFont

# Register StdPrs_BRepFont in _StdPrs:
_StdPrs.StdPrs_BRepFont_swigregister(StdPrs_BRepFont)
class StdPrs_BRepTextBuilder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theFont: StdPrs_BRepFont
        theFormatter: Font_TextFormatter
        thePenLoc: gp_Ax3 (optional, default to gp_Ax3())

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Render text as brep shape. @param theformatter formatter which defines aligned text @param thepenloc start position and orientation on the baseline return result shape with pen transformation applied as shape location.

        Parameters
        ----------
        theFont: StdPrs_BRepFont
        theString: NCollection_String
        thePenLoc: gp_Ax3 (optional, default to gp_Ax3())
        theHAlign: Graphic3d_HorizontalTextAlignment (optional, default to Graphic3d_HTA_LEFT)
        theVAlign: Graphic3d_VerticalTextAlignment (optional, default to Graphic3d_VTA_BOTTOM)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Render text as brep shape. @param thestring text in utf-8 encoding @param thepenloc start position and orientation on the baseline @param thehalign horizontal alignment of the text @param thevalign vertical alignment of the text return result shape with pen transformation applied as shape location.

        """
        return _StdPrs.StdPrs_BRepTextBuilder_Perform(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_BRepTextBuilder_swiginit(self, _StdPrs.new_StdPrs_BRepTextBuilder())
    __swig_destroy__ = _StdPrs.delete_StdPrs_BRepTextBuilder

# Register StdPrs_BRepTextBuilder in _StdPrs:
_StdPrs.StdPrs_BRepTextBuilder_swigregister(StdPrs_BRepTextBuilder)
class StdPrs_Curve(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer
        drawCurve: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Adds to the presentation apresentation the drawing of the curve acurve. the aspect is defined by lineaspect in adrawer. if drawcurve equals standard_false the curve will not be displayed, it is used if the curve is a part of some shape and primitivearray visualization approach is activated (it is activated by default).

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aCurve: Adaptor3d_Curve
        U1: float
        U2: float
        aDrawer: Prs3d_Drawer
        drawCurve: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Adds to the presentation apresentation the drawing of the curve acurve. the aspect is defined by lineaspect in adrawer. the drawing will be limited between the points of parameter u1 and u2. if drawcurve equals standard_false the curve will not be displayed, it is used if the curve is a part of some shape and primitivearray visualization approach is activated (it is activated by default).

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer
        Points: TColgp_SequenceOfPnt
        drawCurve: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Adds to the presentation apresentation the drawing of the curve acurve. the aspect is the current aspect. adeflection is used in the circle case. points give a sequence of curve points. if drawcurve equals standard_false the curve will not be displayed, it is used if the curve is a part of some shape and primitivearray visualization approach is activated (it is activated by default).

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aCurve: Adaptor3d_Curve
        U1: float
        U2: float
        Points: TColgp_SequenceOfPnt
        aNbPoints: int (optional, default to 30)
        drawCurve: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Adds to the presentation apresentation the drawing of the curve acurve. the aspect is the current aspect. the drawing will be limited between the points of parameter u1 and u2. adeflection is used in the circle case. points give a sequence of curve points. if drawcurve equals standard_false the curve will not be displayed, it is used if the curve is a part of some shape and primitivearray visualization approach is activated (it is activated by default).

        """
        return _StdPrs.StdPrs_Curve_Add(*args)

    @staticmethod
    def Match(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the drawing of the curve is less than adistance.

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        aDeflection: float
        aLimit: float
        aNbPoints: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the drawing of the curve is less than adistance.

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        U1: float
        U2: float
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the drawing of the curve acurve is less than adistance. the drawing is considered between the points of parameter u1 and u2;.

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        U1: float
        U2: float
        aDeflection: float
        aNbPoints: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the drawing of the curve acurve is less than adistance. the drawing is considered between the points of parameter u1 and u2;.

        """
        return _StdPrs.StdPrs_Curve_Match(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_Curve_swiginit(self, _StdPrs.new_StdPrs_Curve())
    __swig_destroy__ = _StdPrs.delete_StdPrs_Curve

# Register StdPrs_Curve in _StdPrs:
_StdPrs.StdPrs_Curve_swigregister(StdPrs_Curve)
class StdPrs_HLRShapeI(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def ComputeHLR(self, *args):
        r"""

        Parameters
        ----------
        thePrs: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer
        theProjector: Graphic3d_Camera

        Return
        -------
        None

        Description
        -----------
        Compute presentation for specified shape.

        """
        return _StdPrs.StdPrs_HLRShapeI_ComputeHLR(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_StdPrs_HLRShapeI_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _StdPrs.delete_StdPrs_HLRShapeI

# Register StdPrs_HLRShapeI in _StdPrs:
_StdPrs.StdPrs_HLRShapeI_swigregister(StdPrs_HLRShapeI)
class StdPrs_HLRToolShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape
        TheProjector: HLRAlgo_Projector

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _StdPrs.StdPrs_HLRToolShape_swiginit(self, _StdPrs.new_StdPrs_HLRToolShape(*args))

    def Hidden(self, *args):
        r"""

        Parameters
        ----------
        TheEdge: BRepAdaptor_Curve

        Return
        -------
        U1: float
        U2: float

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_Hidden(self, *args)

    def InitHidden(self, *args):
        r"""

        Parameters
        ----------
        EdgeNumber: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_InitHidden(self, *args)

    def InitVisible(self, *args):
        r"""

        Parameters
        ----------
        EdgeNumber: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_InitVisible(self, *args)

    def MoreHidden(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_MoreHidden(self, *args)

    def MoreVisible(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_MoreVisible(self, *args)

    def NbEdges(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_NbEdges(self, *args)

    def NextHidden(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_NextHidden(self, *args)

    def NextVisible(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_NextVisible(self, *args)

    def Visible(self, *args):
        r"""

        Parameters
        ----------
        TheEdge: BRepAdaptor_Curve

        Return
        -------
        U1: float
        U2: float

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_HLRToolShape_Visible(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _StdPrs.delete_StdPrs_HLRToolShape

# Register StdPrs_HLRToolShape in _StdPrs:
_StdPrs.StdPrs_HLRToolShape_swigregister(StdPrs_HLRToolShape)
class StdPrs_Isolines(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer
        theDeflection: float

        Return
        -------
        None

        Description
        -----------
        Computes isolines presentation for a topods face. this method chooses proper version of isoline builder algorithm: on triangulation or surface depending on the flag passed from prs3d_drawer attributes. this method is a default way to display isolines for a given topods face. @param thepresentation [in] the presentation. @param theface [in] the face. @param thedrawer [in] the display settings. @param thedeflection [in] the deflection for isolines-on-surface version.

        Parameters
        ----------
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer
        theDeflection: float
        theUPolylines: Prs3d_NListOfSequenceOfPnt
        theVPolylines: Prs3d_NListOfSequenceOfPnt

        Return
        -------
        None

        Description
        -----------
        Computes isolines presentation for a topods face. this method chooses proper version of isoline builder algorithm: on triangulation or surface depending on the flag passed from prs3d_drawer attributes. this method is a default way to display isolines for a given topods face. @param theface [in] the face. @param thedrawer [in] the display settings. @param thedeflection [in] the deflection for isolines-on-surface version.

        """
        return _StdPrs.StdPrs_Isolines_Add(*args)

    @staticmethod
    def AddOnSurface(*args):
        r"""

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer
        theDeflection: float

        Return
        -------
        None

        Description
        -----------
        Computes isolines on surface and adds them to presentation. @param thepresentation [in] the presentation. @param theface [in] the face. @param thedrawer [in] the display settings. @param thedeflection [in] the deflection value.

        Parameters
        ----------
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer
        theDeflection: float
        theUPolylines: Prs3d_NListOfSequenceOfPnt
        theVPolylines: Prs3d_NListOfSequenceOfPnt

        Return
        -------
        None

        Description
        -----------
        Computes isolines on surface and adds them to presentation. @param theface [in] the face @param thedrawer [in] the display settings @param thedeflection [in] the deflection value @param theupolylines [out] the sequence of result polylines @param thevpolylines [out] the sequence of result polylines.

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theSurface: BRepAdaptor_Surface
        theDrawer: Prs3d_Drawer
        theDeflection: float
        theUIsoParams: TColStd_SequenceOfReal
        theVIsoParams: TColStd_SequenceOfReal

        Return
        -------
        None

        Description
        -----------
        Computes isolines on surface and adds them to presentation. @param thepresentation [in] the presentation. @param thesurface [in] the surface. @param thedrawer [in] the display settings. @param thedeflection [in] the deflection value. @param theuisoparams [in] the parameters of u isolines to compute. @param thevisoparams [in] the parameters of v isolines to compute.

        """
        return _StdPrs.StdPrs_Isolines_AddOnSurface(*args)

    @staticmethod
    def AddOnTriangulation(*args):
        r"""

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Computes isolines on triangulation and adds them to a presentation. @param thepresentation [in] the presentation. @param theface [in] the face. @param thedrawer [in] the display settings.

        Parameters
        ----------
        theFace: TopoDS_Face
        theDrawer: Prs3d_Drawer
        theUPolylines: Prs3d_NListOfSequenceOfPnt
        theVPolylines: Prs3d_NListOfSequenceOfPnt

        Return
        -------
        None

        Description
        -----------
        Computes isolines on triangulation. @param theface [in] the face. @param thedrawer [in] the display settings. @param theupolylines [out] the sequence of result polylines @param thevpolylines [out] the sequence of result polylines.

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theTriangulation: Poly_Triangulation
        theSurface: Geom_Surface
        theLocation: TopLoc_Location
        theDrawer: Prs3d_Drawer
        theUIsoParams: TColStd_SequenceOfReal
        theVIsoParams: TColStd_SequenceOfReal

        Return
        -------
        None

        Description
        -----------
        Computes isolines on triangulation and adds them to a presentation. @param thepresentation [in] the presentation. @param thetriangulation [in] the triangulation. @param thesurface [in] the definition of triangulated surface. the surface adapter is used to precisely evaluate isoline points using surface law and fit them on triangulation. if null is passed, the method will use linear interpolation of triangle node's uv coordinates to evaluate isoline points. @param thelocation [in] the location transformation defined for triangulation (surface). @param thedrawer [in] the display settings. @param theuisoparams [in] the parameters of u isolines to compute. @param thevisoparams [in] the parameters of v isolines to compute.

        """
        return _StdPrs.StdPrs_Isolines_AddOnTriangulation(*args)

    @staticmethod
    def UVIsoParameters(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theNbIsoU: int
        theNbIsoV: int
        theUVLimit: float
        theUIsoParams: TColStd_SequenceOfReal
        theVIsoParams: TColStd_SequenceOfReal

        Return
        -------
        theUmin: float
        theUmax: float
        theVmin: float
        theVmax: float

        Description
        -----------
        Evaluate sequence of parameters for drawing uv isolines for a given face. @param theface [in] the face. @param thenbisou [in] the number of u isolines. @param thenbisov [in] the number of v isolines. @param theuvlimit [in] the u, v parameter value limit. @param theuisoparams [out] the sequence of u isoline parameters. @param thevisoparams [out] the sequence of v isoline parameters. @param theumin [out] the lower u boundary of theface. @param theumax [out] the upper u boundary of theface. @param thevmin [out] the lower v boundary of theface. @param thevmax [out] the upper v boundary of theface.

        """
        return _StdPrs.StdPrs_Isolines_UVIsoParameters(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_Isolines_swiginit(self, _StdPrs.new_StdPrs_Isolines())
    __swig_destroy__ = _StdPrs.delete_StdPrs_Isolines

# Register StdPrs_Isolines in _StdPrs:
_StdPrs.StdPrs_Isolines_swigregister(StdPrs_Isolines)
class StdPrs_Plane(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aPlane: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Defines display of infinite planes. the infinite plane aplane is added to the display apresentation, and the attributes of the display are defined by the attribute manager adrawer.

        """
        return _StdPrs.StdPrs_Plane_Add(*args)

    @staticmethod
    def Match(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aPlane: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the plane is less than adistance.

        """
        return _StdPrs.StdPrs_Plane_Match(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_Plane_swiginit(self, _StdPrs.new_StdPrs_Plane())
    __swig_destroy__ = _StdPrs.delete_StdPrs_Plane

# Register StdPrs_Plane in _StdPrs:
_StdPrs.StdPrs_Plane_swigregister(StdPrs_Plane)
class StdPrs_PoleCurve(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Defines display of bspline and bezier curves. adds the 3d curve acurve to the stdprs_polecurve algorithm. this shape is found in the presentation object apresentation, and its display attributes are set in the attribute manager adrawer. the curve object from adaptor3d provides data from a geom curve. this makes it possible to use the surface in a geometric algorithm.

        """
        return _StdPrs.StdPrs_PoleCurve_Add(*args)

    @staticmethod
    def Match(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Returns true if the distance between the point (x,y,z) and the broken line made of the poles is less then adistance.

        """
        return _StdPrs.StdPrs_PoleCurve_Match(*args)

    @staticmethod
    def Pick(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aCurve: Adaptor3d_Curve
        aDrawer: Prs3d_Drawer

        Return
        -------
        int

        Description
        -----------
        Returns the pole the most near of the point (x,y,z) and returns its range. the distance between the pole and (x,y,z) must be less then adistance. if no pole corresponds, 0 is returned.

        """
        return _StdPrs.StdPrs_PoleCurve_Pick(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_PoleCurve_swiginit(self, _StdPrs.new_StdPrs_PoleCurve())
    __swig_destroy__ = _StdPrs.delete_StdPrs_PoleCurve

# Register StdPrs_PoleCurve in _StdPrs:
_StdPrs.StdPrs_PoleCurve_swigregister(StdPrs_PoleCurve)
class StdPrs_ShadedShape(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer
        theVolume: StdPrs_Volume (optional, default to StdPrs_Volume_Autodetection)
        theGroup: Graphic3d_Group (optional, default to NULL)

        Return
        -------
        None

        Description
        -----------
        Shades <theshape>. @param thevolumetype defines the way how to interpret input shapes - as closed volumes (to activate back-face culling and capping plane algorithms), as open volumes (shells or solids with holes) or to perform autodetection (would split input shape into two groups).

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer
        theHasTexels: bool
        theUVOrigin: gp_Pnt2d
        theUVRepeat: gp_Pnt2d
        theUVScale: gp_Pnt2d
        theVolume: StdPrs_Volume (optional, default to StdPrs_Volume_Autodetection)
        theGroup: Graphic3d_Group (optional, default to NULL)

        Return
        -------
        None

        Description
        -----------
        Shades <theshape> with texture coordinates. @param thevolumetype defines the way how to interpret input shapes - as closed volumes (to activate back-face culling and capping plane algorithms), as open volumes (shells or solids with holes) or to perform autodetection (would split input shape into two groups).

        """
        return _StdPrs.StdPrs_ShadedShape_Add(*args)

    @staticmethod
    def AddWireframeForFacesWithoutTriangles(*args):
        r"""

        Parameters
        ----------
        thePrs: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Computes special wireframe presentation for faces without triangulation.

        """
        return _StdPrs.StdPrs_ShadedShape_AddWireframeForFacesWithoutTriangles(*args)

    @staticmethod
    def AddWireframeForFreeElements(*args):
        r"""

        Parameters
        ----------
        thePrs: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Computes wireframe presentation for free wires and vertices.

        """
        return _StdPrs.StdPrs_ShadedShape_AddWireframeForFreeElements(*args)

    @staticmethod
    def ExploreSolids(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theBuilder: BRep_Builder
        theClosed: TopoDS_Compound
        theOpened: TopoDS_Compound
        theIgnore1DSubShape: bool

        Return
        -------
        None

        Description
        -----------
        Searches closed and unclosed subshapes in shape structure and puts them into two compounds for separate processing of closed and unclosed sub-shapes.

        """
        return _StdPrs.StdPrs_ShadedShape_ExploreSolids(*args)

    @staticmethod
    def FillFaceBoundaries(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theUpperContinuity: GeomAbs_Shape (optional, default to GeomAbs_CN)

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfSegments>

        Description
        -----------
        Define primitive array of boundary segments for specified shape. @param theshape segments array or null if specified face does not have computed triangulation @param theuppercontinuity the most edge continuity class to be included to result (edges with more continuity will be ignored).

        """
        return _StdPrs.StdPrs_ShadedShape_FillFaceBoundaries(*args)

    @staticmethod
    def FillTriangles(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfTriangles>

        Description
        -----------
        Create primitive array with triangles for specified shape. @param theshape [in] the shape with precomputed triangulation.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theHasTexels: bool
        theUVOrigin: gp_Pnt2d
        theUVRepeat: gp_Pnt2d
        theUVScale: gp_Pnt2d

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfTriangles>

        Description
        -----------
        Create primitive array of triangles for specified shape. @param theshape the shape with precomputed triangulation @param thehastexels define uv coordinates in primitive array @param theuvorigin origin for uv coordinates @param theuvrepeat repeat parameters for uv coordinates @param theuvscale scale coefficients for uv coordinates return triangles array or null if specified face does not have computed triangulation.

        """
        return _StdPrs.StdPrs_ShadedShape_FillTriangles(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_ShadedShape_swiginit(self, _StdPrs.new_StdPrs_ShadedShape())
    __swig_destroy__ = _StdPrs.delete_StdPrs_ShadedShape

# Register StdPrs_ShadedShape in _StdPrs:
_StdPrs.StdPrs_ShadedShape_swigregister(StdPrs_ShadedShape)
class StdPrs_ShadedSurface(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aSurface: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Adds the surface asurface to the presentation object apresentation. the surface's display attributes are set in the attribute manager adrawer. the surface object from adaptor3d provides data from a geom surface in order to use the surface in an algorithm.

        """
        return _StdPrs.StdPrs_ShadedSurface_Add(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_ShadedSurface_swiginit(self, _StdPrs.new_StdPrs_ShadedSurface())
    __swig_destroy__ = _StdPrs.delete_StdPrs_ShadedSurface

# Register StdPrs_ShadedSurface in _StdPrs:
_StdPrs.StdPrs_ShadedSurface_swigregister(StdPrs_ShadedSurface)
class StdPrs_ShapeTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theAllVertices: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs the tool and initializes it using theshape and theallvertices (optional) arguments. by default, only isolated and internal vertices are considered, however if theallvertices argument is equal to true, all shape's vertices are taken into account.

        """
        _StdPrs.StdPrs_ShapeTool_swiginit(self, _StdPrs.new_StdPrs_ShapeTool(*args))

    def CurrentTriangulation(self, *args):
        r"""

        Parameters
        ----------
        l: TopLoc_Location

        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_CurrentTriangulation(self, *args)

    def CurveBound(self, *args):
        r"""
        Return
        -------
        Bnd_Box

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_CurveBound(self, *args)

    def FaceBound(self, *args):
        r"""
        Return
        -------
        Bnd_Box

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_FaceBound(self, *args)

    def FacesOfEdge(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_FacesOfEdge(self, *args)

    def GetCurve(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_GetCurve(self, *args)

    def GetFace(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_GetFace(self, *args)

    def GetVertex(self, *args):
        r"""
        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_GetVertex(self, *args)

    def HasCurve(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_HasCurve(self, *args)

    def HasSurface(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_HasSurface(self, *args)

    def InitCurve(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_InitCurve(self, *args)

    def InitFace(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_InitFace(self, *args)

    def InitVertex(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_InitVertex(self, *args)

    @staticmethod
    def IsPlanarFace(*args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theFace: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_IsPlanarFace(*args)

    def MoreCurve(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_MoreCurve(self, *args)

    def MoreFace(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_MoreFace(self, *args)

    def MoreVertex(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_MoreVertex(self, *args)

    def Neighbours(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_Neighbours(self, *args)

    def NextCurve(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_NextCurve(self, *args)

    def NextFace(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_NextFace(self, *args)

    def NextVertex(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_NextVertex(self, *args)

    def Polygon3D(self, *args):
        r"""

        Parameters
        ----------
        l: TopLoc_Location

        Return
        -------
        opencascade::handle<Poly_Polygon3D>

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_Polygon3D(self, *args)

    def PolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------
        Indices: Poly_PolygonOnTriangulation
        T: Poly_Triangulation
        l: TopLoc_Location

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ShapeTool_PolygonOnTriangulation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _StdPrs.delete_StdPrs_ShapeTool

# Register StdPrs_ShapeTool in _StdPrs:
_StdPrs.StdPrs_ShapeTool_swigregister(StdPrs_ShapeTool)
class StdPrs_ToolPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Coord(*args):
        r"""

        Parameters
        ----------
        aPoint: Geom_Point

        Return
        -------
        X: float
        Y: float
        Z: float

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ToolPoint_Coord(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_ToolPoint_swiginit(self, _StdPrs.new_StdPrs_ToolPoint())
    __swig_destroy__ = _StdPrs.delete_StdPrs_ToolPoint

# Register StdPrs_ToolPoint in _StdPrs:
_StdPrs.StdPrs_ToolPoint_swigregister(StdPrs_ToolPoint)
class StdPrs_ToolRFace(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        aSurface: BRepAdaptor_Surface

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization.

        """
        _StdPrs.StdPrs_ToolRFace_swiginit(self, _StdPrs.new_StdPrs_ToolRFace(*args))

    def Edge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Return current edge.

        """
        return _StdPrs.StdPrs_ToolRFace_Edge(self, *args)

    def Init(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Move iterator to the first element.

        """
        return _StdPrs.StdPrs_ToolRFace_Init(self, *args)

    def IsInvalidGeometry(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if null curves have been skipped.

        """
        return _StdPrs.StdPrs_ToolRFace_IsInvalidGeometry(self, *args)

    def IsOriented(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true indicating that iterator looks only for oriented edges.

        """
        return _StdPrs.StdPrs_ToolRFace_IsOriented(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if iterator points to the curve.

        """
        return _StdPrs.StdPrs_ToolRFace_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Go to the next curve in the face.

        """
        return _StdPrs.StdPrs_ToolRFace_Next(self, *args)

    def Orientation(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Return current edge orientation.

        """
        return _StdPrs.StdPrs_ToolRFace_Orientation(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        Adaptor2d_Curve2d

        Description
        -----------
        Return current curve.

        """
        return _StdPrs.StdPrs_ToolRFace_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _StdPrs.delete_StdPrs_ToolRFace

# Register StdPrs_ToolRFace in _StdPrs:
_StdPrs.StdPrs_ToolRFace_swigregister(StdPrs_ToolRFace)
class StdPrs_ToolTriangulatedShape(OCC.Core.BRepLib.BRepLib_ToolTriangulatedShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ClearOnOwnDeflectionChange(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer
        theToResetCoeff: bool

        Return
        -------
        None

        Description
        -----------
        If presentation has own deviation coefficient and isautotriangulation() is true, function will compare actual coefficients with previous values and will clear triangulation on their change (regardless actual tessellation quality). function is placed here for compatibility reasons - new code should avoid using isautotriangulation(). @param theshape [in] the shape @param thedrawer [in] the display settings @param thetoresetcoeff [in] updates coefficients in thedrawer to actual state to avoid redundant recomputations.

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_ClearOnOwnDeflectionChange(*args)

    @staticmethod
    def GetDeflection(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        float

        Description
        -----------
        Computes the absolute deflection value depending on the type of deflection in thedrawer: <ul> <li><b>aspect_tod_relative</b>: the absolute deflection is computed using the relative deviation coefficient from thedrawer and the shape's bounding box;</li> <li><b>aspect_tod_absolute</b>: the maximal chordial deviation from thedrawer is returned.</li> </ul> in case of the type of deflection in thedrawer computed relative deflection for shape is stored as absolute deflection. it is necessary to use it later on for sub-shapes. this function should always be used to compute the deflection value for building discrete representations of the shape (triangulation, wireframe) to avoid inconsistencies between different representations of the shape and undesirable visual artifacts.

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_GetDeflection(*args)

    @staticmethod
    def IsClosed(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Checks back faces visibility for specified shape (to activate back-face culling). return true if shape is closed manifold solid or compound of such solids. .

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_IsClosed(*args)

    @staticmethod
    def IsTessellated(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Checks whether the shape is properly triangulated for a given display settings. @param theshape [in] the shape. @param thedrawer [in] the display settings.

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_IsTessellated(*args)

    @staticmethod
    def IsTriangulated(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Similar to breptools::triangulation() but without extra checks. return true if all faces within shape are triangulated.

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_IsTriangulated(*args)

    @staticmethod
    def Tessellate(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        Validates triangulation within the shape and performs tessellation if necessary. @param theshape [in] the shape. @param thedrawer [in] the display settings. return true if tessellation was recomputed and false otherwise.

        """
        return _StdPrs.StdPrs_ToolTriangulatedShape_Tessellate(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_ToolTriangulatedShape_swiginit(self, _StdPrs.new_StdPrs_ToolTriangulatedShape())
    __swig_destroy__ = _StdPrs.delete_StdPrs_ToolTriangulatedShape

# Register StdPrs_ToolTriangulatedShape in _StdPrs:
_StdPrs.StdPrs_ToolTriangulatedShape_swigregister(StdPrs_ToolTriangulatedShape)
class StdPrs_ToolVertex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Coord(*args):
        r"""

        Parameters
        ----------
        aPoint: TopoDS_Vertex

        Return
        -------
        X: float
        Y: float
        Z: float

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_ToolVertex_Coord(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_ToolVertex_swiginit(self, _StdPrs.new_StdPrs_ToolVertex())
    __swig_destroy__ = _StdPrs.delete_StdPrs_ToolVertex

# Register StdPrs_ToolVertex in _StdPrs:
_StdPrs.StdPrs_ToolVertex_swigregister(StdPrs_ToolVertex)
class StdPrs_WFDeflectionRestrictedFace(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Defines a display featuring u and v isoparameters. adds the surface aface to the stdprs_wfrestrictedface algorithm. this face is found in a shape in the presentation object apresentation, and its display attributes - in particular, the number of u and v isoparameters - are set in the attribute manager adrawer. aface is brepadaptor_surface surface created from a face in a topological shape. which is passed as an argument through the brepadaptor_surface surface created from it. this is what allows the topological face to be treated as a geometric surface.

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aFace: BRepAdaptor_Surface
        DrawUIso: bool
        DrawVIso: bool
        Deflection: float
        NBUiso: int
        NBViso: int
        aDrawer: Prs3d_Drawer
        Curves: Prs3d_NListOfSequenceOfPnt

        Return
        -------
        None

        Description
        -----------
        Defines a display of a delection-specified face. the display will feature u and v isoparameters. adds the topology ashape to the stdprs_wfrestrictedface algorithm. this shape is found in the presentation object apresentation, and its display attributes - except the number of u and v isoparameters - are set in the attribute manager adrawer. the function sets the number of u and v isoparameters, nbuiso and nbviso, in the shape. to do this, the arguments drawuiso and drawviso must be true. aface is brepadaptor_surface surface created from a face in a topological shape. which is passed as an argument through the brepadaptor_surface surface created from it. this is what allows the topological face to be treated as a geometric surface. curves give a sequence of face curves, it is used if the primitivearray visualization approach is activated (it is activated by default).

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_Add(*args)

    @staticmethod
    def AddUIso(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Defines a display featuring u isoparameters respectively. add the surface aface to the stdprs_wfrestrictedface algorithm. this face is found in a shape in the presentation object apresentation, and its display attributes - in particular, the number of u isoparameters - are set in the attribute manager adrawer. aface is brepadaptor_surface surface created from a face in a topological shape. which is passed to the function as an argument through the brepadaptor_surface surface created from it. this is what allows the topological face to be treated as a geometric surface.

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_AddUIso(*args)

    @staticmethod
    def AddVIso(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Defines a display featuring v isoparameters respectively. add the surface aface to the stdprs_wfrestrictedface algorithm. this face is found in a shape in the presentation object apresentation, and its display attributes - in particular, the number of v isoparameters - are set in the attribute manager adrawer. aface is brepadaptor_surface surface created from a face in a topological shape. which is passed to the function as an argument through the brepadaptor_surface surface created from it. this is what allows the topological face to be treated as a geometric surface.

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_AddVIso(*args)

    @staticmethod
    def Match(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer
        DrawUIso: bool
        DrawVIso: bool
        aDeflection: float
        NBUiso: int
        NBViso: int

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_Match(*args)

    @staticmethod
    def MatchUIso(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_MatchUIso(*args)

    @staticmethod
    def MatchVIso(*args):
        r"""

        Parameters
        ----------
        X: float
        Y: float
        Z: float
        aDistance: float
        aFace: BRepAdaptor_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFDeflectionRestrictedFace_MatchVIso(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFDeflectionRestrictedFace_swiginit(self, _StdPrs.new_StdPrs_WFDeflectionRestrictedFace())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFDeflectionRestrictedFace

# Register StdPrs_WFDeflectionRestrictedFace in _StdPrs:
_StdPrs.StdPrs_WFDeflectionRestrictedFace_swigregister(StdPrs_WFDeflectionRestrictedFace)
class StdPrs_WFDeflectionSurface(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aSurface: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Adds the surface asurface to the presentation object apresentation, and defines its boundaries and isoparameters. the shape's display attributes are set in the attribute manager adrawer. these include whether deflection is absolute or relative to the size of the shape. the surface asurface is a surface object from adaptor, and provides data from a geom surface. this makes it possible to use the surface in a geometric algorithm. note that this surface object is manipulated by handles.

        """
        return _StdPrs.StdPrs_WFDeflectionSurface_Add(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFDeflectionSurface_swiginit(self, _StdPrs.new_StdPrs_WFDeflectionSurface())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFDeflectionSurface

# Register StdPrs_WFDeflectionSurface in _StdPrs:
_StdPrs.StdPrs_WFDeflectionSurface_swigregister(StdPrs_WFDeflectionSurface)
class StdPrs_WFPoleSurface(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aSurface: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Adds the surface asurface to the presentation object apresentation. the shape's display attributes are set in the attribute manager adrawer. the surface asurface is a surface object from adaptor3d, and provides data from a geom surface. this makes it possible to use the surface in a geometric algorithm.

        """
        return _StdPrs.StdPrs_WFPoleSurface_Add(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFPoleSurface_swiginit(self, _StdPrs.new_StdPrs_WFPoleSurface())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFPoleSurface

# Register StdPrs_WFPoleSurface in _StdPrs:
_StdPrs.StdPrs_WFPoleSurface_swigregister(StdPrs_WFPoleSurface)
class StdPrs_WFRestrictedFace(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        thePresentation: Handle ( Prs3d_Presentation )
        theFace: BRepAdaptor_Surface
        theDrawUIso: bool
        theDrawVIso: bool
        theNbUIso: int
        theNbVIso: int
        theDrawer: Prs3d_Drawer
        theCurves: Prs3d_NListOfSequenceOfPnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePresentation: Handle ( Prs3d_Presentation )
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_Add(*args)

    @staticmethod
    def AddUIso(*args):
        r"""

        Parameters
        ----------
        thePresentation: Handle ( Prs3d_Presentation )
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_AddUIso(*args)

    @staticmethod
    def AddVIso(*args):
        r"""

        Parameters
        ----------
        thePresentation: Handle ( Prs3d_Presentation )
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_AddVIso(*args)

    @staticmethod
    def Match(*args):
        r"""

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theDistance: float
        theFace: BRepAdaptor_Surface
        theDrawUIso: bool
        theDrawVIso: bool
        theDeflection: float
        theNbUIso: int
        theNbVIso: int
        theDrawer: Prs3d_Drawer

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theDistance: float
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_Match(*args)

    @staticmethod
    def MatchUIso(*args):
        r"""

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theDistance: float
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_MatchUIso(*args)

    @staticmethod
    def MatchVIso(*args):
        r"""

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theDistance: float
        theFace: BRepAdaptor_Surface
        theDrawer: Handle ( Prs3d_Drawer )

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _StdPrs.StdPrs_WFRestrictedFace_MatchVIso(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFRestrictedFace_swiginit(self, _StdPrs.new_StdPrs_WFRestrictedFace())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFRestrictedFace

# Register StdPrs_WFRestrictedFace in _StdPrs:
_StdPrs.StdPrs_WFRestrictedFace_swigregister(StdPrs_WFRestrictedFace)
class StdPrs_WFShape(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        thePresentation: Prs3d_Presentation
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer
        theIsParallel: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes wireframe presentation of a shape. @param thepresentation [in] the presentation. @param theshape [in] the shape. @param thedrawer [in] the draw settings. @param theisparallel [in] perform algorithm using multiple threads.

        """
        return _StdPrs.StdPrs_WFShape_Add(*args)

    @staticmethod
    def AddAllEdges(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theDrawer: Prs3d_Drawer

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfPrimitives>

        Description
        -----------
        Compute all edges (wire, free, unfree) and put them into single primitive array. @param theshape [in] the shape @param thedrawer [in] the drawer settings (deviation angle and maximal parameter value).

        """
        return _StdPrs.StdPrs_WFShape_AddAllEdges(*args)

    @staticmethod
    def AddEdgesOnTriangulation(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theToExcludeGeometric: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfPrimitives>

        Description
        -----------
        Compute free and boundary edges on a triangulation of each face in the given shape. @param theshape  [in] the list of triangulated faces @param thetoexcludegeometric [in] flag indicating that faces with defined surface should be skipped.

        Parameters
        ----------
        theSegments: TColgp_SequenceOfPnt
        theShape: TopoDS_Shape
        theToExcludeGeometric: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Compute free and boundary edges on a triangulation of each face in the given shape. @param thesegments  [in] the sequence of points defining segments @param theshape  [in] the list of triangulated faces @param thetoexcludegeometric [in] flag indicating that faces with defined surface should be skipped.

        """
        return _StdPrs.StdPrs_WFShape_AddEdgesOnTriangulation(*args)

    @staticmethod
    def AddVertexes(*args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theVertexMode: Prs3d_VertexDrawMode

        Return
        -------
        opencascade::handle<Graphic3d_ArrayOfPoints>

        Description
        -----------
        Compute vertex presentation for a shape. @param theshape [in] the shape @param thevertexmode [in] vertex filter.

        """
        return _StdPrs.StdPrs_WFShape_AddVertexes(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFShape_swiginit(self, _StdPrs.new_StdPrs_WFShape())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFShape

# Register StdPrs_WFShape in _StdPrs:
_StdPrs.StdPrs_WFShape_swigregister(StdPrs_WFShape)
class StdPrs_WFSurface(OCC.Core.Prs3d.Prs3d_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        aPresentation: Prs3d_Presentation
        aSurface: Adaptor3d_Surface
        aDrawer: Prs3d_Drawer

        Return
        -------
        None

        Description
        -----------
        Draws a surface by drawing the isoparametric curves with respect to a fixed number of points given by the drawer. the number of isoparametric curves to be drawn and their color are controlled by the furnished drawer.

        """
        return _StdPrs.StdPrs_WFSurface_Add(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_WFSurface_swiginit(self, _StdPrs.new_StdPrs_WFSurface())
    __swig_destroy__ = _StdPrs.delete_StdPrs_WFSurface

# Register StdPrs_WFSurface in _StdPrs:
_StdPrs.StdPrs_WFSurface_swigregister(StdPrs_WFSurface)
class StdPrs_HLRPolyShape(StdPrs_HLRShapeI):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_StdPrs_HLRPolyShape_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_HLRPolyShape_swiginit(self, _StdPrs.new_StdPrs_HLRPolyShape())
    __swig_destroy__ = _StdPrs.delete_StdPrs_HLRPolyShape

# Register StdPrs_HLRPolyShape in _StdPrs:
_StdPrs.StdPrs_HLRPolyShape_swigregister(StdPrs_HLRPolyShape)
class StdPrs_HLRShape(StdPrs_HLRShapeI):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_StdPrs_HLRShape_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _StdPrs.StdPrs_HLRShape_swiginit(self, _StdPrs.new_StdPrs_HLRShape())
    __swig_destroy__ = _StdPrs.delete_StdPrs_HLRShape

# Register StdPrs_HLRShape in _StdPrs:
_StdPrs.StdPrs_HLRShape_swigregister(StdPrs_HLRShape)

@classnotwrapped
class StdPrs_DeflectionCurve:
	pass



StdPrs_BndBox=OCC.Core.Prs3d.Prs3d_BndBox


@deprecated
def StdPrs_BRepFont_FindAndCreate(*args):
	return StdPrs_BRepFont.FindAndCreate(*args)

@deprecated
def StdPrs_Curve_Add(*args):
	return StdPrs_Curve.Add(*args)

@deprecated
def StdPrs_Curve_Add(*args):
	return StdPrs_Curve.Add(*args)

@deprecated
def StdPrs_Curve_Add(*args):
	return StdPrs_Curve.Add(*args)

@deprecated
def StdPrs_Curve_Add(*args):
	return StdPrs_Curve.Add(*args)

@deprecated
def StdPrs_Curve_Match(*args):
	return StdPrs_Curve.Match(*args)

@deprecated
def StdPrs_Curve_Match(*args):
	return StdPrs_Curve.Match(*args)

@deprecated
def StdPrs_Curve_Match(*args):
	return StdPrs_Curve.Match(*args)

@deprecated
def StdPrs_Curve_Match(*args):
	return StdPrs_Curve.Match(*args)

@deprecated
def StdPrs_Isolines_Add(*args):
	return StdPrs_Isolines.Add(*args)

@deprecated
def StdPrs_Isolines_Add(*args):
	return StdPrs_Isolines.Add(*args)

@deprecated
def StdPrs_Isolines_AddOnSurface(*args):
	return StdPrs_Isolines.AddOnSurface(*args)

@deprecated
def StdPrs_Isolines_AddOnSurface(*args):
	return StdPrs_Isolines.AddOnSurface(*args)

@deprecated
def StdPrs_Isolines_AddOnSurface(*args):
	return StdPrs_Isolines.AddOnSurface(*args)

@deprecated
def StdPrs_Isolines_AddOnTriangulation(*args):
	return StdPrs_Isolines.AddOnTriangulation(*args)

@deprecated
def StdPrs_Isolines_AddOnTriangulation(*args):
	return StdPrs_Isolines.AddOnTriangulation(*args)

@deprecated
def StdPrs_Isolines_AddOnTriangulation(*args):
	return StdPrs_Isolines.AddOnTriangulation(*args)

@deprecated
def StdPrs_Isolines_UVIsoParameters(*args):
	return StdPrs_Isolines.UVIsoParameters(*args)

@deprecated
def StdPrs_Plane_Add(*args):
	return StdPrs_Plane.Add(*args)

@deprecated
def StdPrs_Plane_Match(*args):
	return StdPrs_Plane.Match(*args)

@deprecated
def StdPrs_PoleCurve_Add(*args):
	return StdPrs_PoleCurve.Add(*args)

@deprecated
def StdPrs_PoleCurve_Match(*args):
	return StdPrs_PoleCurve.Match(*args)

@deprecated
def StdPrs_PoleCurve_Pick(*args):
	return StdPrs_PoleCurve.Pick(*args)

@deprecated
def StdPrs_ShadedShape_Add(*args):
	return StdPrs_ShadedShape.Add(*args)

@deprecated
def StdPrs_ShadedShape_Add(*args):
	return StdPrs_ShadedShape.Add(*args)

@deprecated
def StdPrs_ShadedShape_AddWireframeForFacesWithoutTriangles(*args):
	return StdPrs_ShadedShape.AddWireframeForFacesWithoutTriangles(*args)

@deprecated
def StdPrs_ShadedShape_AddWireframeForFreeElements(*args):
	return StdPrs_ShadedShape.AddWireframeForFreeElements(*args)

@deprecated
def StdPrs_ShadedShape_ExploreSolids(*args):
	return StdPrs_ShadedShape.ExploreSolids(*args)

@deprecated
def StdPrs_ShadedShape_FillFaceBoundaries(*args):
	return StdPrs_ShadedShape.FillFaceBoundaries(*args)

@deprecated
def StdPrs_ShadedShape_FillTriangles(*args):
	return StdPrs_ShadedShape.FillTriangles(*args)

@deprecated
def StdPrs_ShadedShape_FillTriangles(*args):
	return StdPrs_ShadedShape.FillTriangles(*args)

@deprecated
def StdPrs_ShadedSurface_Add(*args):
	return StdPrs_ShadedSurface.Add(*args)

@deprecated
def StdPrs_ShapeTool_IsPlanarFace(*args):
	return StdPrs_ShapeTool.IsPlanarFace(*args)

@deprecated
def StdPrs_ToolPoint_Coord(*args):
	return StdPrs_ToolPoint.Coord(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_ClearOnOwnDeflectionChange(*args):
	return StdPrs_ToolTriangulatedShape.ClearOnOwnDeflectionChange(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_GetDeflection(*args):
	return StdPrs_ToolTriangulatedShape.GetDeflection(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_IsClosed(*args):
	return StdPrs_ToolTriangulatedShape.IsClosed(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_IsTessellated(*args):
	return StdPrs_ToolTriangulatedShape.IsTessellated(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_IsTriangulated(*args):
	return StdPrs_ToolTriangulatedShape.IsTriangulated(*args)

@deprecated
def StdPrs_ToolTriangulatedShape_Tessellate(*args):
	return StdPrs_ToolTriangulatedShape.Tessellate(*args)

@deprecated
def StdPrs_ToolVertex_Coord(*args):
	return StdPrs_ToolVertex.Coord(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_Add(*args):
	return StdPrs_WFDeflectionRestrictedFace.Add(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_Add(*args):
	return StdPrs_WFDeflectionRestrictedFace.Add(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_AddUIso(*args):
	return StdPrs_WFDeflectionRestrictedFace.AddUIso(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_AddVIso(*args):
	return StdPrs_WFDeflectionRestrictedFace.AddVIso(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_Match(*args):
	return StdPrs_WFDeflectionRestrictedFace.Match(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_Match(*args):
	return StdPrs_WFDeflectionRestrictedFace.Match(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_MatchUIso(*args):
	return StdPrs_WFDeflectionRestrictedFace.MatchUIso(*args)

@deprecated
def StdPrs_WFDeflectionRestrictedFace_MatchVIso(*args):
	return StdPrs_WFDeflectionRestrictedFace.MatchVIso(*args)

@deprecated
def StdPrs_WFDeflectionSurface_Add(*args):
	return StdPrs_WFDeflectionSurface.Add(*args)

@deprecated
def StdPrs_WFPoleSurface_Add(*args):
	return StdPrs_WFPoleSurface.Add(*args)

@deprecated
def StdPrs_WFRestrictedFace_Add(*args):
	return StdPrs_WFRestrictedFace.Add(*args)

@deprecated
def StdPrs_WFRestrictedFace_Add(*args):
	return StdPrs_WFRestrictedFace.Add(*args)

@deprecated
def StdPrs_WFRestrictedFace_AddUIso(*args):
	return StdPrs_WFRestrictedFace.AddUIso(*args)

@deprecated
def StdPrs_WFRestrictedFace_AddVIso(*args):
	return StdPrs_WFRestrictedFace.AddVIso(*args)

@deprecated
def StdPrs_WFRestrictedFace_Match(*args):
	return StdPrs_WFRestrictedFace.Match(*args)

@deprecated
def StdPrs_WFRestrictedFace_Match(*args):
	return StdPrs_WFRestrictedFace.Match(*args)

@deprecated
def StdPrs_WFRestrictedFace_MatchUIso(*args):
	return StdPrs_WFRestrictedFace.MatchUIso(*args)

@deprecated
def StdPrs_WFRestrictedFace_MatchVIso(*args):
	return StdPrs_WFRestrictedFace.MatchVIso(*args)

@deprecated
def StdPrs_WFShape_Add(*args):
	return StdPrs_WFShape.Add(*args)

@deprecated
def StdPrs_WFShape_AddAllEdges(*args):
	return StdPrs_WFShape.AddAllEdges(*args)

@deprecated
def StdPrs_WFShape_AddEdgesOnTriangulation(*args):
	return StdPrs_WFShape.AddEdgesOnTriangulation(*args)

@deprecated
def StdPrs_WFShape_AddEdgesOnTriangulation(*args):
	return StdPrs_WFShape.AddEdgesOnTriangulation(*args)

@deprecated
def StdPrs_WFShape_AddVertexes(*args):
	return StdPrs_WFShape.AddVertexes(*args)

@deprecated
def StdPrs_WFSurface_Add(*args):
	return StdPrs_WFSurface.Add(*args)



