from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkAddMembershipArray(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    CELL_DATA:int
    EDGE_DATA:int
    FIELD_DATA:int
    POINT_DATA:int
    ROW_DATA:int
    VERTEX_DATA:int
    def GetFieldType(self) -> int: ...
    def GetFieldTypeMaxValue(self) -> int: ...
    def GetFieldTypeMinValue(self) -> int: ...
    def GetInputArrayName(self) -> str: ...
    def GetInputValues(self) -> 'vtkAbstractArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAddMembershipArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAddMembershipArray': ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetInputArrayName(self, _arg:str) -> None: ...
    def SetInputValues(self, __a:'vtkAbstractArray') -> None: ...
    def SetOutputArrayName(self, _arg:str) -> None: ...

class vtkAdjacencyMatrixToEdgeTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetMinimumCount(self) -> int: ...
    def GetMinimumThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSourceDimension(self) -> int: ...
    def GetValueArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdjacencyMatrixToEdgeTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdjacencyMatrixToEdgeTable': ...
    def SetMinimumCount(self, _arg:int) -> None: ...
    def SetMinimumThreshold(self, _arg:float) -> None: ...
    def SetSourceDimension(self, _arg:int) -> None: ...
    def SetValueArrayName(self, _arg:str) -> None: ...

class vtkArrayNorm(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    def GetDimension(self) -> int: ...
    def GetInvert(self) -> int: ...
    def GetL(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWindow(self) -> 'vtkArrayRange': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayNorm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayNorm': ...
    def SetDimension(self, _arg:int) -> None: ...
    def SetInvert(self, _arg:int) -> None: ...
    def SetL(self, value:int) -> None: ...
    def SetWindow(self, window:'vtkArrayRange') -> None: ...

class vtkArrayToTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayToTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayToTable': ...

class vtkCollapseGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollapseGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollapseGraph': ...
    def SetGraphConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetSelectionConnection(self, __a:'vtkAlgorithmOutput') -> None: ...

class vtkCollapseVerticesByArray(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def AddAggregateEdgeArray(self, arrName:str) -> None: ...
    def AllowSelfLoopsOff(self) -> None: ...
    def AllowSelfLoopsOn(self) -> None: ...
    def ClearAggregateEdgeArray(self) -> None: ...
    def CountEdgesCollapsedOff(self) -> None: ...
    def CountEdgesCollapsedOn(self) -> None: ...
    def CountVerticesCollapsedOff(self) -> None: ...
    def CountVerticesCollapsedOn(self) -> None: ...
    def GetAllowSelfLoops(self) -> bool: ...
    def GetCountEdgesCollapsed(self) -> bool: ...
    def GetCountVerticesCollapsed(self) -> bool: ...
    def GetEdgesCollapsedArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertexArray(self) -> str: ...
    def GetVerticesCollapsedArray(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollapseVerticesByArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollapseVerticesByArray': ...
    def SetAllowSelfLoops(self, _arg:bool) -> None: ...
    def SetCountEdgesCollapsed(self, _arg:bool) -> None: ...
    def SetCountVerticesCollapsed(self, _arg:bool) -> None: ...
    def SetEdgesCollapsedArray(self, _arg:str) -> None: ...
    def SetVertexArray(self, _arg:str) -> None: ...
    def SetVerticesCollapsedArray(self, _arg:str) -> None: ...

class vtkContinuousScatterplot(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def GetEpsilon(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContinuousScatterplot': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContinuousScatterplot': ...
    def SetEpsilon(self, _arg:float) -> None: ...
    def SetField1(self, fieldName:str, ResX:int) -> None: ...
    def SetField2(self, fieldName:str, ResY:int) -> None: ...

class vtkDataObjectToTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    CELL_DATA:int
    EDGE_DATA:int
    FIELD_DATA:int
    POINT_DATA:int
    VERTEX_DATA:int
    def GetFieldType(self) -> int: ...
    def GetFieldTypeMaxValue(self) -> int: ...
    def GetFieldTypeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectToTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectToTable': ...
    def SetFieldType(self, _arg:int) -> None: ...

class vtkDotProductSimilarity(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetDiagonal(self) -> int: ...
    def GetFirstSecond(self) -> int: ...
    def GetLowerDiagonal(self) -> int: ...
    def GetMaximumCount(self) -> int: ...
    def GetMinimumCount(self) -> int: ...
    def GetMinimumThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSecondFirst(self) -> int: ...
    def GetUpperDiagonal(self) -> int: ...
    def GetVectorDimension(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDotProductSimilarity': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDotProductSimilarity': ...
    def SetDiagonal(self, _arg:int) -> None: ...
    def SetFirstSecond(self, _arg:int) -> None: ...
    def SetLowerDiagonal(self, _arg:int) -> None: ...
    def SetMaximumCount(self, _arg:int) -> None: ...
    def SetMinimumCount(self, _arg:int) -> None: ...
    def SetMinimumThreshold(self, _arg:float) -> None: ...
    def SetSecondFirst(self, _arg:int) -> None: ...
    def SetUpperDiagonal(self, _arg:int) -> None: ...
    def SetVectorDimension(self, _arg:int) -> None: ...

class vtkEdgeCenters(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertexCells(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgeCenters': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgeCenters': ...
    def SetVertexCells(self, _arg:int) -> None: ...
    def VertexCellsOff(self) -> None: ...
    def VertexCellsOn(self) -> None: ...

class vtkExpandSelectedGraph(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetBFSDistance(self) -> int: ...
    def GetDomain(self) -> str: ...
    def GetIncludeShortestPaths(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseDomain(self) -> bool: ...
    def IncludeShortestPathsOff(self) -> None: ...
    def IncludeShortestPathsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExpandSelectedGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExpandSelectedGraph': ...
    def SetBFSDistance(self, _arg:int) -> None: ...
    def SetDomain(self, _arg:str) -> None: ...
    def SetGraphConnection(self, in_:'vtkAlgorithmOutput') -> None: ...
    def SetIncludeShortestPaths(self, _arg:bool) -> None: ...
    def SetUseDomain(self, _arg:bool) -> None: ...
    def UseDomainOff(self) -> None: ...
    def UseDomainOn(self) -> None: ...

class vtkExtractSelectedGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRemoveIsolatedVertices(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSelectedGraph': ...
    def RemoveIsolatedVerticesOff(self) -> None: ...
    def RemoveIsolatedVerticesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSelectedGraph': ...
    def SetAnnotationLayersConnection(self, in_:'vtkAlgorithmOutput') -> None: ...
    def SetRemoveIsolatedVertices(self, _arg:bool) -> None: ...
    def SetSelectionConnection(self, in_:'vtkAlgorithmOutput') -> None: ...

class vtkExtractSelectedTree(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSelectedTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSelectedTree': ...
    def SetSelectionConnection(self, in_:'vtkAlgorithmOutput') -> None: ...

class vtkGenerateIndexArray(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    CELL_DATA:int
    EDGE_DATA:int
    POINT_DATA:int
    ROW_DATA:int
    VERTEX_DATA:int
    def GetArrayName(self) -> str: ...
    def GetFieldType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPedigreeID(self) -> int: ...
    def GetReferenceArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateIndexArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateIndexArray': ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetPedigreeID(self, _arg:int) -> None: ...
    def SetReferenceArrayName(self, _arg:str) -> None: ...

class vtkGraphHierarchicalBundleEdges(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def DirectMappingOff(self) -> None: ...
    def DirectMappingOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetBundlingStrength(self) -> float: ...
    def GetBundlingStrengthMaxValue(self) -> float: ...
    def GetBundlingStrengthMinValue(self) -> float: ...
    def GetDirectMapping(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphHierarchicalBundleEdges': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphHierarchicalBundleEdges': ...
    def SetBundlingStrength(self, _arg:float) -> None: ...
    def SetDirectMapping(self, _arg:bool) -> None: ...

class vtkGroupLeafVertices(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetGroupDomain(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGroupLeafVertices': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGroupLeafVertices': ...
    def SetGroupDomain(self, _arg:str) -> None: ...

class vtkKCoreDecomposition(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def CheckInputGraphOff(self) -> None: ...
    def CheckInputGraphOn(self) -> None: ...
    def GetCheckInputGraph(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseInDegreeNeighbors(self) -> bool: ...
    def GetUseOutDegreeNeighbors(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKCoreDecomposition': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKCoreDecomposition': ...
    def SetCheckInputGraph(self, _arg:bool) -> None: ...
    def SetOutputArrayName(self, _arg:str) -> None: ...
    def SetUseInDegreeNeighbors(self, _arg:bool) -> None: ...
    def SetUseOutDegreeNeighbors(self, _arg:bool) -> None: ...
    def UseInDegreeNeighborsOff(self) -> None: ...
    def UseInDegreeNeighborsOn(self) -> None: ...
    def UseOutDegreeNeighborsOff(self) -> None: ...
    def UseOutDegreeNeighborsOn(self) -> None: ...

class vtkMergeColumns(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetMergedColumnName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeColumns': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeColumns': ...
    def SetMergedColumnName(self, _arg:str) -> None: ...

class vtkMergeGraphs(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def ExtendGraph(self, g1:'vtkMutableGraphHelper', g2:'vtkGraph') -> int: ...
    def GetEdgeWindow(self) -> float: ...
    def GetEdgeWindowArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseEdgeWindow(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeGraphs': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeGraphs': ...
    def SetEdgeWindow(self, _arg:float) -> None: ...
    def SetEdgeWindowArrayName(self, _arg:str) -> None: ...
    def SetUseEdgeWindow(self, _arg:bool) -> None: ...
    def UseEdgeWindowOff(self) -> None: ...
    def UseEdgeWindowOn(self) -> None: ...

class vtkMergeTables(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetFirstTablePrefix(self) -> str: ...
    def GetMergeColumnsByName(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrefixAllButMerged(self) -> bool: ...
    def GetSecondTablePrefix(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeColumnsByNameOff(self) -> None: ...
    def MergeColumnsByNameOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMergeTables': ...
    def PrefixAllButMergedOff(self) -> None: ...
    def PrefixAllButMergedOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeTables': ...
    def SetFirstTablePrefix(self, _arg:str) -> None: ...
    def SetMergeColumnsByName(self, _arg:bool) -> None: ...
    def SetPrefixAllButMerged(self, _arg:bool) -> None: ...
    def SetSecondTablePrefix(self, _arg:str) -> None: ...

class vtkMutableGraphHelper(vtkmodules.vtkCommonCore.vtkObject):
    def AddEdge(self, u:int, v:int) -> 'vtkEdgeType': ...
    def AddGraphEdge(self, u:int, v:int) -> 'vtkGraphEdge': ...
    def AddVertex(self) -> int: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMutableGraphHelper': ...
    def RemoveEdge(self, e:int) -> None: ...
    def RemoveEdges(self, edges:'vtkIdTypeArray') -> None: ...
    def RemoveVertex(self, v:int) -> None: ...
    def RemoveVertices(self, verts:'vtkIdTypeArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMutableGraphHelper': ...
    def SetGraph(self, g:'vtkGraph') -> None: ...

class vtkNetworkHierarchy(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetIPArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNetworkHierarchy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNetworkHierarchy': ...
    def SetIPArrayName(self, _arg:str) -> None: ...

class vtkPipelineGraphSource(vtkmodules.vtkCommonExecutionModel.vtkDirectedGraphAlgorithm):
    def AddSink(self, sink:'vtkObject') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPipelineGraphSource': ...
    def RemoveSink(self, sink:'vtkObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPipelineGraphSource': ...

class vtkPruneTreeFilter(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParentVertex(self) -> int: ...
    def GetShouldPruneParentVertex(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPruneTreeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPruneTreeFilter': ...
    def SetParentVertex(self, _arg:int) -> None: ...
    def SetShouldPruneParentVertex(self, _arg:bool) -> None: ...

class vtkRandomGraphSource(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def AllowParallelEdgesOff(self) -> None: ...
    def AllowParallelEdgesOn(self) -> None: ...
    def AllowSelfLoopsOff(self) -> None: ...
    def AllowSelfLoopsOn(self) -> None: ...
    def DirectedOff(self) -> None: ...
    def DirectedOn(self) -> None: ...
    def GeneratePedigreeIdsOff(self) -> None: ...
    def GeneratePedigreeIdsOn(self) -> None: ...
    def GetAllowParallelEdges(self) -> bool: ...
    def GetAllowSelfLoops(self) -> bool: ...
    def GetDirected(self) -> bool: ...
    def GetEdgePedigreeIdArrayName(self) -> str: ...
    def GetEdgeProbability(self) -> float: ...
    def GetEdgeProbabilityMaxValue(self) -> float: ...
    def GetEdgeProbabilityMinValue(self) -> float: ...
    def GetEdgeWeightArrayName(self) -> str: ...
    def GetGeneratePedigreeIds(self) -> bool: ...
    def GetIncludeEdgeWeights(self) -> bool: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfEdgesMaxValue(self) -> int: ...
    def GetNumberOfEdgesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVertices(self) -> int: ...
    def GetNumberOfVerticesMaxValue(self) -> int: ...
    def GetNumberOfVerticesMinValue(self) -> int: ...
    def GetSeed(self) -> int: ...
    def GetStartWithTree(self) -> bool: ...
    def GetUseEdgeProbability(self) -> bool: ...
    def GetVertexPedigreeIdArrayName(self) -> str: ...
    def IncludeEdgeWeightsOff(self) -> None: ...
    def IncludeEdgeWeightsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRandomGraphSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRandomGraphSource': ...
    def SetAllowParallelEdges(self, _arg:bool) -> None: ...
    def SetAllowSelfLoops(self, _arg:bool) -> None: ...
    def SetDirected(self, _arg:bool) -> None: ...
    def SetEdgePedigreeIdArrayName(self, _arg:str) -> None: ...
    def SetEdgeProbability(self, _arg:float) -> None: ...
    def SetEdgeWeightArrayName(self, _arg:str) -> None: ...
    def SetGeneratePedigreeIds(self, _arg:bool) -> None: ...
    def SetIncludeEdgeWeights(self, _arg:bool) -> None: ...
    def SetNumberOfEdges(self, _arg:int) -> None: ...
    def SetNumberOfVertices(self, _arg:int) -> None: ...
    def SetSeed(self, _arg:int) -> None: ...
    def SetStartWithTree(self, _arg:bool) -> None: ...
    def SetUseEdgeProbability(self, _arg:bool) -> None: ...
    def SetVertexPedigreeIdArrayName(self, _arg:str) -> None: ...
    def StartWithTreeOff(self) -> None: ...
    def StartWithTreeOn(self) -> None: ...
    def UseEdgeProbabilityOff(self) -> None: ...
    def UseEdgeProbabilityOn(self) -> None: ...

class vtkReduceTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    MEAN:int
    MEDIAN:int
    MODE:int
    def GetIndexColumn(self) -> int: ...
    def GetNonNumericalReductionMethod(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumericalReductionMethod(self) -> int: ...
    def GetReductionMethodForColumn(self, col:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReduceTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReduceTable': ...
    def SetIndexColumn(self, _arg:int) -> None: ...
    def SetNonNumericalReductionMethod(self, _arg:int) -> None: ...
    def SetNumericalReductionMethod(self, _arg:int) -> None: ...
    def SetReductionMethodForColumn(self, col:int, method:int) -> None: ...

class vtkRemoveHiddenData(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveHiddenData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveHiddenData': ...

class vtkRemoveIsolatedVertices(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveIsolatedVertices': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveIsolatedVertices': ...

class vtkSparseArrayToTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValueColumn(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSparseArrayToTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSparseArrayToTable': ...
    def SetValueColumn(self, _arg:str) -> None: ...

class vtkStreamGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetEdgeWindow(self) -> float: ...
    def GetEdgeWindowArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseEdgeWindow(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamGraph': ...
    def SetEdgeWindow(self, _arg:float) -> None: ...
    def SetEdgeWindowArrayName(self, _arg:str) -> None: ...
    def SetUseEdgeWindow(self, _arg:bool) -> None: ...
    def UseEdgeWindowOff(self) -> None: ...
    def UseEdgeWindowOn(self) -> None: ...

class vtkStringToCategory(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetCategoryArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStringToCategory': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStringToCategory': ...
    def SetCategoryArrayName(self, _arg:str) -> None: ...

class vtkStringToNumeric(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def ConvertCellDataOff(self) -> None: ...
    def ConvertCellDataOn(self) -> None: ...
    def ConvertEdgeDataOff(self) -> None: ...
    def ConvertEdgeDataOn(self) -> None: ...
    def ConvertFieldDataOff(self) -> None: ...
    def ConvertFieldDataOn(self) -> None: ...
    def ConvertPointDataOff(self) -> None: ...
    def ConvertPointDataOn(self) -> None: ...
    def ConvertRowDataOff(self) -> None: ...
    def ConvertRowDataOn(self) -> None: ...
    def ConvertVertexDataOff(self) -> None: ...
    def ConvertVertexDataOn(self) -> None: ...
    def ForceDoubleOff(self) -> None: ...
    def ForceDoubleOn(self) -> None: ...
    def GetConvertCellData(self) -> bool: ...
    def GetConvertEdgeData(self) -> bool: ...
    def GetConvertFieldData(self) -> bool: ...
    def GetConvertPointData(self) -> bool: ...
    def GetConvertRowData(self) -> bool: ...
    def GetConvertVertexData(self) -> bool: ...
    def GetDefaultDoubleValue(self) -> float: ...
    def GetDefaultIntegerValue(self) -> int: ...
    def GetForceDouble(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTrimWhitespacePriorToNumericConversion(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStringToNumeric': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStringToNumeric': ...
    def SetConvertCellData(self, _arg:bool) -> None: ...
    def SetConvertEdgeData(self, b:bool) -> None: ...
    def SetConvertFieldData(self, _arg:bool) -> None: ...
    def SetConvertPointData(self, _arg:bool) -> None: ...
    def SetConvertRowData(self, b:bool) -> None: ...
    def SetConvertVertexData(self, b:bool) -> None: ...
    def SetDefaultDoubleValue(self, _arg:float) -> None: ...
    def SetDefaultIntegerValue(self, _arg:int) -> None: ...
    def SetForceDouble(self, _arg:bool) -> None: ...
    def SetTrimWhitespacePriorToNumericConversion(self, _arg:bool) -> None: ...
    def TrimWhitespacePriorToNumericConversionOff(self) -> None: ...
    def TrimWhitespacePriorToNumericConversionOn(self) -> None: ...

class vtkTableToArray(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    def AddAllColumns(self) -> None: ...
    @overload
    def AddColumn(self, name:str) -> None: ...
    @overload
    def AddColumn(self, index:int) -> None: ...
    def ClearColumns(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableToArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToArray': ...

class vtkTableToGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def AddLinkEdge(self, column1:str, column2:str) -> None: ...
    def AddLinkVertex(self, column:str, domain:str=..., hidden:int=0) -> None: ...
    def ClearLinkEdges(self) -> None: ...
    def ClearLinkVertices(self) -> None: ...
    def DirectedOff(self) -> None: ...
    def DirectedOn(self) -> None: ...
    def GetDirected(self) -> bool: ...
    def GetLinkGraph(self) -> 'vtkMutableDirectedGraph': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LinkColumnPath(self, column:'vtkStringArray', domain:'vtkStringArray'=..., hidden:'vtkBitArray'=...) -> None: ...
    def NewInstance(self) -> 'vtkTableToGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToGraph': ...
    def SetDirected(self, _arg:bool) -> None: ...
    def SetLinkGraph(self, g:'vtkMutableDirectedGraph') -> None: ...
    def SetVertexTableConnection(self, in_:'vtkAlgorithmOutput') -> None: ...

class vtkTableToSparseArray(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    def AddCoordinateColumn(self, name:str) -> None: ...
    def ClearCoordinateColumns(self) -> None: ...
    def ClearOutputExtents(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValueColumn(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableToSparseArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToSparseArray': ...
    def SetOutputExtents(self, extents:'vtkArrayExtents') -> None: ...
    def SetValueColumn(self, name:str) -> None: ...

class vtkTableToTreeFilter(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableToTreeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToTreeFilter': ...

class vtkThresholdGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkThresholdGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThresholdGraph': ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...

class vtkThresholdTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    ACCEPT_BETWEEN:int
    ACCEPT_GREATER_THAN:int
    ACCEPT_LESS_THAN:int
    ACCEPT_OUTSIDE:int
    def GetMaxValue(self) -> 'vtkVariant': ...
    def GetMinValue(self) -> 'vtkVariant': ...
    def GetMode(self) -> int: ...
    def GetModeMaxValue(self) -> int: ...
    def GetModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsValueAcceptable(self, value:'vtkVariant') -> bool: ...
    def NewInstance(self) -> 'vtkThresholdTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThresholdTable': ...
    @overload
    def SetMaxValue(self, v:'vtkVariant') -> None: ...
    @overload
    def SetMaxValue(self, v:float) -> None: ...
    @overload
    def SetMinValue(self, v:'vtkVariant') -> None: ...
    @overload
    def SetMinValue(self, v:float) -> None: ...
    def SetMode(self, _arg:int) -> None: ...
    @overload
    def ThresholdBetween(self, lower:'vtkVariant', upper:'vtkVariant') -> None: ...
    @overload
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...

class vtkTransferAttributes(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def DirectMappingOff(self) -> None: ...
    def DirectMappingOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetDefaultValue(self) -> 'vtkVariant': ...
    def GetDirectMapping(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSourceArrayName(self) -> str: ...
    def GetSourceFieldType(self) -> int: ...
    def GetTargetArrayName(self) -> str: ...
    def GetTargetFieldType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransferAttributes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransferAttributes': ...
    def SetDefaultValue(self, value:'vtkVariant') -> None: ...
    def SetDirectMapping(self, _arg:bool) -> None: ...
    def SetSourceArrayName(self, _arg:str) -> None: ...
    def SetSourceFieldType(self, _arg:int) -> None: ...
    def SetTargetArrayName(self, _arg:str) -> None: ...
    def SetTargetFieldType(self, _arg:int) -> None: ...

class vtkTransposeMatrix(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransposeMatrix': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransposeMatrix': ...

class vtkTreeDifferenceFilter(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetComparisonArrayIsVertexData(self) -> bool: ...
    def GetComparisonArrayName(self) -> str: ...
    def GetIdArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeDifferenceFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeDifferenceFilter': ...
    def SetComparisonArrayIsVertexData(self, _arg:bool) -> None: ...
    def SetComparisonArrayName(self, _arg:str) -> None: ...
    def SetIdArrayName(self, _arg:str) -> None: ...
    def SetOutputArrayName(self, _arg:str) -> None: ...

class vtkTreeFieldAggregator(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetField(self) -> str: ...
    def GetLeafVertexUnitSize(self) -> bool: ...
    def GetLogScale(self) -> bool: ...
    def GetMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LeafVertexUnitSizeOff(self) -> None: ...
    def LeafVertexUnitSizeOn(self) -> None: ...
    def LogScaleOff(self) -> None: ...
    def LogScaleOn(self) -> None: ...
    def NewInstance(self) -> 'vtkTreeFieldAggregator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeFieldAggregator': ...
    def SetField(self, _arg:str) -> None: ...
    def SetLeafVertexUnitSize(self, _arg:bool) -> None: ...
    def SetLogScale(self, _arg:bool) -> None: ...
    def SetMinValue(self, _arg:float) -> None: ...

class vtkTreeLevelsFilter(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeLevelsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeLevelsFilter': ...

class vtkVertexDegree(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVertexDegree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVertexDegree': ...
    def SetOutputArrayName(self, _arg:str) -> None: ...

class vtkWordCloud(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def AddOrientation(self, arg:float) -> None: ...
    def AddStopWord(self, word:str) -> None: ...
    def ClearStopWords(self) -> None: ...
    def GetBWMask(self) -> bool: ...
    def GetBackgroundColorName(self) -> str: ...
    def GetColorSchemeName(self) -> str: ...
    def GetDPI(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFontFileName(self) -> str: ...
    def GetFontMultiplier(self) -> int: ...
    def GetGap(self) -> int: ...
    def GetKeptWords(self) -> Tuple[str, str]: ...
    def GetMaskColorName(self) -> str: ...
    def GetMaskFileName(self) -> str: ...
    def GetMaxFontSize(self) -> int: ...
    def GetMinFontSize(self) -> int: ...
    def GetMinFrequency(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientations(self) -> Tuple[float, float]: ...
    def GetSkippedWords(self) -> Tuple[str, str]: ...
    def GetStopListFileName(self) -> str: ...
    def GetStoppedWords(self) -> Tuple[str, str]: ...
    def GetTitle(self) -> str: ...
    def GetWordColorName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWordCloud': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWordCloud': ...
    def SetBWMask(self, arg:bool) -> None: ...
    def SetBackgroundColorName(self, arg:str) -> None: ...
    def SetColorSchemeName(self, arg:str) -> None: ...
    def SetDPI(self, _arg:int) -> None: ...
    def SetFileName(self, arg:str) -> None: ...
    def SetFontFileName(self, arg:str) -> None: ...
    def SetFontMultiplier(self, _arg:int) -> None: ...
    def SetGap(self, _arg:int) -> None: ...
    def SetMaskColorName(self, arg:str) -> None: ...
    def SetMaskFileName(self, arg:str) -> None: ...
    def SetMaxFontSize(self, _arg:int) -> None: ...
    def SetMinFontSize(self, _arg:int) -> None: ...
    def SetMinFrequency(self, _arg:int) -> None: ...
    def SetOrientations(self, arg:MutableSequence[float]) -> None: ...
    def SetStopListFileName(self, arg:str) -> None: ...
    def SetTitle(self, arg:str) -> None: ...
    def SetWordColorName(self, arg:str) -> None: ...

