from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkRenderingCore

class vtkDGOpenGLRenderer(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGOpenGLRenderer': ...
    def Query(self, request:'vtkOpenGLCellGridRenderRequest', metadata:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGOpenGLRenderer': ...

class vtkOpenGLCellGridMapper(vtkmodules.vtkRenderingCore.vtkCellGridMapper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCellGridMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCellGridMapper': ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...

class vtkOpenGLCellGridRenderRequest(vtkmodules.vtkCommonDataModel.vtkCellGridQuery):
    class RenderableGeometry(int): ...
    ALL:'RenderableGeometry'
    EDGES:'RenderableGeometry'
    FACES:'RenderableGeometry'
    SURFACE_WITH_EDGES:'RenderableGeometry'
    VERTICES:'RenderableGeometry'
    VOLUMES:'RenderableGeometry'
    def Finalize(self) -> None: ...
    def GetActor(self) -> 'vtkActor': ...
    def GetIsReleasingResources(self) -> bool: ...
    def GetMapper(self) -> 'vtkOpenGLCellGridMapper': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetShapesToDraw(self) -> str: ...
    def GetShapesToDrawMaxValue(self) -> str: ...
    def GetShapesToDrawMinValue(self) -> str: ...
    def GetWindow(self) -> 'vtkWindow': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCellGridRenderRequest': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCellGridRenderRequest': ...
    def SetActor(self, actor:'vtkActor') -> None: ...
    def SetIsReleasingResources(self, _arg:bool) -> None: ...
    def SetMapper(self, mapper:'vtkOpenGLCellGridMapper') -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetShapesToDraw(self, _arg:str) -> None: ...
    def SetWindow(self, window:'vtkWindow') -> None: ...

