from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore
import vtkmodules.vtkRenderingLabel

class vtkQImageToImageSource(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQImageToImageSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQImageToImageSource': ...

class vtkQtInitialization(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQtInitialization': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQtInitialization': ...

class vtkQtLabelRenderStrategy(vtkmodules.vtkRenderingLabel.vtkLabelRenderStrategy):
    def ComputeLabelBounds(self, tprop:'vtkTextProperty', label:str, bds:MutableSequence[float]) -> None: ...
    def EndFrame(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQtLabelRenderStrategy': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    @overload
    def RenderLabel(self, x:MutableSequence[int], tprop:'vtkTextProperty', label:str) -> None: ...
    @overload
    def RenderLabel(self, x:MutableSequence[int], tprop:'vtkTextProperty', label:str, maxWidth:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQtLabelRenderStrategy': ...
    def StartFrame(self) -> None: ...

class vtkQtStringToImage(vtkmodules.vtkRenderingCore.vtkStringToImage):
    def DeepCopy(self, utility:'vtkQtStringToImage') -> None: ...
    def GetBounds(self, property:'vtkTextProperty', string:str, dpi:int) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQtStringToImage': ...
    def RenderString(self, property:'vtkTextProperty', string:str, dpi:int, data:'vtkImageData', textDims:MutableSequence[int]=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQtStringToImage': ...

class vtkQtTreeRingLabelMapper(vtkmodules.vtkRenderingLabel.vtkLabeledDataMapper):
    def GetInputTree(self) -> 'vtkTree': ...
    @overload
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetLabelTextProperty(self, type:int) -> 'vtkTextProperty': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetTextRotationArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQtTreeRingLabelMapper': ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQtTreeRingLabelMapper': ...
    @overload
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    @overload
    def SetLabelTextProperty(self, p:'vtkTextProperty', type:int) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetSectorsArrayName(self, name:str) -> None: ...
    def SetTextRotationArrayName(self, _arg:str) -> None: ...

